#ifndef _EQUATION_EVALUATOR_H_
#define _EQUATION_EVALUATOR_H_

/* Some of you may choose to define TYPE as a "float" instead... */
#define TYPE            double          /* Type of numbers to work with */

#define VARLEN          32              /* Max length of variable names */
#define MAXVARS         512             /* Max user-defined variables */
#define TOKLEN          512              /* Max token length */
 
#define VAR             1
#define DEL             2
#define NUM             3

int Equation(CString CExpression, CString CValues, double *data_result);
int Equation(CString CExpression, double *data_result);

int EquationSetVarible(CString CName, CString CValue);
int EquationSetVaribles(CString CNameEqualsValueList);

int GetValue( char* name, TYPE* value );


int Evaluate( char* e, TYPE* result, int* a );
void ClearAllVars(void);
void Parse(void);
int Level1(TYPE* r);
void Level2(TYPE* r);
void Level3(TYPE* r);
void Level4(TYPE* r);
void Level5(TYPE* r);
void Level6(TYPE* r);


typedef struct
{
   char name[VARLEN + 1];               /* Variable name */
   TYPE value;                          /* Variable value */
} VARIABLE;

typedef struct
{
   char* name;                          /* Function name */
   int   args;                          /* Number of arguments to expect */
   TYPE  (*func)(TYPE);                     /* Pointer to function */
} FUNCTION;


/* The following macros are ASCII dependant, no EBCDIC here! */
#define iswhite(c)  (c == ' ' || c == '\t')
#define isnumer(c)  ((c >= '0' && c <= '9') || c == '.')

/*
#define isalpha(c)  ((c >= 'a' && c <= 'z') || (c >= '0' && c <= '9') || c == '_') // doesnt work for upper case 9th Dec 2014
*/

#define isalpha(c)  ((c >= 'a' && c <= 'z') || (c >= 'A' && c <= 'Z') || (c >= '0' && c <= '9') || c == '_') // upper case 9th Dec 2014

#define isdelim(c)  (c == '+' || c == '-' || c == '*' || c == '/' || c == '%' \
                    || c == '^' || c == '(' || c == ')' || c == ',' || c == '=')

/* Codes returned from the evaluator */
#define E_OK           0        /* Successful evaluation */
#define E_SYNTAX       1        /* Syntax error */
#define E_UNBALAN      2        /* Unbalanced parenthesis */
#define E_DIVZERO      3        /* Attempted division by zero */
#define E_UNKNOWN      4        /* Reference to unknown variable */
#define E_MAXVARS      5        /* Maximum variables exceeded */
#define E_BADFUNC      6        /* Unrecognised function */
#define E_NUMARGS      7        /* Wrong number of arguments to funtion */
#define E_NOARG        8        /* Missing an argument to a funtion */
#define E_EMPTY        9        /* Empty expression */

#endif //_EQUATION_EVALUATOR_H_

