
/*
	Copyright Kevin Aylward. (c) 1997


 */

 
#include "stdafx.h"
#include "math.h"
#include "TCFileFunctions.h"
#include "Generic.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

IMPLEMENT_SERIAL(TCFont, CObject, 1)

/* to use later
	GetCursorPosition(),
    modify the values and call SetCursorPosition()

 */

//////////////////////////////////////////////////

double NoisePercentRatio(double fraction, double total)
{
	double value;

	if(total <= 0) return 0; // Fails
	if(fraction <= 0) return 0;
	if(fraction >= total) return 100.0;
	
	value = (fraction * fraction)/(total * total);

	value = 1 - value;

	value = sqrt(value);

	value = 100 *  (1 - value);

	return value;
}

int GetRandomNumber(void)
{
	srand((unsigned)time(NULL));

	return rand(); 
}

CString GetRandomNumberString(void)
{
	CString CText;

	int number = GetRandomNumber();

	CText.Format("%d", number);

	return CText;
}

bool GetPrinterDC(CDC &CPrinterDC)
{
	PRINTDLG PrintDlg;

	CWinApp *PCApp = AfxGetApp();
	
	if(!PCApp) return false;

	PCApp->GetPrinterDeviceDefaults(&PrintDlg);

	if(!PCApp->CreatePrinterDC(CPrinterDC))
	{
		return false;
	}

	return true;
}

float GetPrinterResolution(void)
{
	CDC CPrinterDC;

	PRINTDLG PrintDlg;

	CWinApp *PCApp = AfxGetApp();
	
	if(!PCApp) return false;

	PCApp->GetPrinterDeviceDefaults(&PrintDlg);

	if(!PCApp->CreatePrinterDC(CPrinterDC))
	{
		return false;
	}

	return true;
}

void DockControlBarRightOf(CXTPMDIFrameWnd *PCWnd, CToolBar* CBarLeft, CToolBar*  CBarRight)
{
	CRect rect;
	DWORD dw;
	UINT n;

	// get MFC to adjust the dimensions of all docked ToolBars
	// so that GetWindowRect will be accurate
	PCWnd->RecalcLayout();
	CBarLeft->GetWindowRect(&rect);
	rect.OffsetRect(1,0);
	dw=CBarLeft->GetBarStyle();
	n = 0;
	n = (dw&CBRS_ALIGN_TOP) ? AFX_IDW_DOCKBAR_TOP : n;
	n = (dw&CBRS_ALIGN_BOTTOM && n==0) ? AFX_IDW_DOCKBAR_BOTTOM : n;
	n = (dw&CBRS_ALIGN_LEFT && n==0) ? AFX_IDW_DOCKBAR_LEFT : n;
	n = (dw&CBRS_ALIGN_RIGHT && n==0) ? AFX_IDW_DOCKBAR_RIGHT : n;

	// When we take the default parameters on rect, DockControlBar will dock
	// each Toolbar on a seperate line.  By calculating a rectangle, we in effect
	// are simulating a Toolbar being dragged to that location and docked.
	PCWnd->DockControlBar(CBarRight, n, &rect);
}

void SaveWindow(CDocument *PCDoc, CString CWindowName)
{
	CView *PCView;

	if(!PCDoc) return;

	POSITION SPosition = PCDoc->GetFirstViewPosition();

	PCView = PCDoc->GetNextView(SPosition);

	if(!PCView) return;

	SaveWindowLayout(PCView->GetParent(), CWindowName);
}

CDocument *OpenAndLoadWindow(CMultiDocTemplate *PCMultiDocTemplate, CString CFileName, CString CWindowName)
{
	CDocument *PDoc;

	if(!FileExists(CFileName)) return NULL;

	PDoc = PCMultiDocTemplate->OpenDocumentFile(CFileName);

	if(!PDoc) return NULL;

	CView *PCView = ActivateADocumentView(PDoc);

	if(!PCView) return NULL;

	LoadWindowLayout(PCView->GetParent(), CWindowName);

	return PDoc;
}

CDocument *OpenWindow(CMultiDocTemplate *PCMultiDocTemplate, CString CFileName)
{
	CDocument *PDoc;

	if(!PCMultiDocTemplate) return NULL;

	if(!FileExists(CFileName)) return false;

	PDoc = PCMultiDocTemplate->OpenDocumentFile(CFileName);

	if(!PDoc) return NULL;

	CView *PCView = ActivateADocumentView(PDoc);

	if(!PCView) return NULL;

	return PDoc;
}

void SerializeWindow(CArchive &ar, CDocument *PCDocument)
{
	if(!PCDocument) return;// will mod later for all views

	WINDOWPLACEMENT		s_window_placment;	

	s_window_placment.flags		= WPF_SETMINPOSITION;
	s_window_placment.length	= sizeof(WINDOWPLACEMENT);

	POSITION pos = PCDocument->GetFirstViewPosition();

	if(!pos) return;

	CView* PCView = PCDocument->GetNextView(pos);

	if(!PCView) return;

	if (ar.IsStoring())
	{
		PCView->GetParent()->GetWindowPlacement(&s_window_placment);

		ar.Write(&s_window_placment, sizeof(s_window_placment));
	}
	else
	{
		ar.Read(&s_window_placment, sizeof(s_window_placment));

		PCView->GetParent()->SetWindowPlacement(&s_window_placment);
	}
}

void SerializeWindow(CArchive &ar, CView *PCView)
{
	WINDOWPLACEMENT		s_window_placment;	

	s_window_placment.flags		= WPF_SETMINPOSITION;
	s_window_placment.length	= sizeof(WINDOWPLACEMENT);


	if (ar.IsStoring())
	{
		PCView->GetParent()->GetWindowPlacement(&s_window_placment);

		ar.Write(&s_window_placment, sizeof(s_window_placment));
	}
	else
	{
		ar.Read(&s_window_placment, sizeof(s_window_placment));

		PCView->GetParent()->SetWindowPlacement(&s_window_placment);
	}
}



bool SaveWindowLayout(CWnd *PCWindow, CString CSectionName)
{
	WINDOWPLACEMENT  s_window_placment;

	int		left, top, right, bottom, showCmd;
	int		xmin, ymin, xmax, ymax;
	CString CIniKey;
			
	s_window_placment.flags		= WPF_SETMINPOSITION;
	s_window_placment.length	= sizeof(s_window_placment);

	CWinApp *PCWinApp = AfxGetApp();

	PCWindow->GetWindowPlacement(&s_window_placment);

	showCmd	= s_window_placment.showCmd;

//	showCmd = SW_NORMAL;// Microshit fucks up, it wont restore to old data

	top		= s_window_placment.rcNormalPosition.top;
	left	= s_window_placment.rcNormalPosition.left;	
	bottom	= s_window_placment.rcNormalPosition.bottom;
	right	= s_window_placment.rcNormalPosition.right;

	xmin	= s_window_placment.ptMinPosition.x;
	ymin	= s_window_placment.ptMinPosition.y;
	xmax	= s_window_placment.ptMaxPosition.x;
	ymax	= s_window_placment.ptMaxPosition.y;

	CIniKey.Format("WindowShowCmd1");		
	PCWinApp->WriteProfileInt(CSectionName, CIniKey, showCmd);

	CIniKey.Format("WindowTop1");		
	PCWinApp->WriteProfileInt(CSectionName, CIniKey, top);

	CIniKey.Format("WindowLeft1");		
	PCWinApp->WriteProfileInt(CSectionName, CIniKey, left);

	CIniKey.Format("WindowBottom1");		
	PCWinApp->WriteProfileInt(CSectionName, CIniKey, bottom);

	CIniKey.Format("WindowRight1");		
	PCWinApp->WriteProfileInt(CSectionName, CIniKey, right);

	CIniKey.Format("WindowXMinimised1");		
	PCWinApp->WriteProfileInt(CSectionName, CIniKey, xmin);

	CIniKey.Format("WindowYMinimised1");		
	PCWinApp->WriteProfileInt(CSectionName, CIniKey, ymin);

	CIniKey.Format("WindowXMaximised1");		
	PCWinApp->WriteProfileInt(CSectionName, CIniKey, xmax);

	CIniKey.Format("WindowYMaximised1");		
	PCWinApp->WriteProfileInt(CSectionName, CIniKey, ymax);

	return true;
}

bool LoadWindowLayout(CWnd *PCWindow, CString CSectionName)
{

	WINDOWPLACEMENT  s_window_placment;

	int		left, top, right, bottom, showCmd;
	int		xmin, ymin, xmax, ymax;
	CString CIniKey;
	
	s_window_placment.flags		= WPF_SETMINPOSITION;
	s_window_placment.length	= sizeof(s_window_placment);

	CWinApp *PCWinApp= AfxGetApp();	
	
	CIniKey.Format("WindowShowCmd1");		
	showCmd = PCWinApp->GetProfileInt(CSectionName, CIniKey, -1);
	if(showCmd == -1) return false;

	CIniKey.Format("WindowTop1");		
	top = PCWinApp->GetProfileInt(CSectionName, CIniKey, -1);	
	if(top < 1) return false;

	CIniKey.Format("WindowLeft1");		
	left = PCWinApp->GetProfileInt(CSectionName, CIniKey, -1);
	if(left < 1) return false;

	CIniKey.Format("WindowBottom1");		
	bottom = PCWinApp->GetProfileInt(CSectionName, CIniKey, 400);
	if(bottom < 10) return false;

	CIniKey.Format("WindowRight1");		
	right = PCWinApp->GetProfileInt(CSectionName, CIniKey, 400);
	if(right < 10) return false;

	CIniKey.Format("WindowXMinimised1");		
	xmin = PCWinApp->GetProfileInt(CSectionName, CIniKey, -1);

	CIniKey.Format("WindowYMinimised1");		
	ymin = PCWinApp->GetProfileInt(CSectionName, CIniKey, -1);

	CIniKey.Format("WindowXMaximised1");		
	xmax = PCWinApp->GetProfileInt(CSectionName, CIniKey, -1);

	CIniKey.Format("WindowYMaximised1");		
	ymax = PCWinApp->GetProfileInt(CSectionName, CIniKey, -1);

	s_window_placment.showCmd					= showCmd;
	s_window_placment.rcNormalPosition.right	= right;
	s_window_placment.rcNormalPosition.left		= left;	
	s_window_placment.rcNormalPosition.bottom	= bottom;
	s_window_placment.rcNormalPosition.top		= top;
	s_window_placment.ptMinPosition.x			= xmin;
	s_window_placment.ptMinPosition.y			= ymin;
	s_window_placment.ptMaxPosition.x			= xmax;
	s_window_placment.ptMaxPosition.y			= ymax;

	PCWindow->SetWindowPlacement(&s_window_placment);

	return true;
}

bool GetLastWindowPlacement(WINDOWPLACEMENT &s_window_placment, CString CSectionName)
{
	int		left, top, right, bottom, showCmd;
	int		xmin, ymin, xmax, ymax;
	CString CIniKey;
	
	s_window_placment.flags		= WPF_SETMINPOSITION;
	s_window_placment.length	= sizeof(s_window_placment);

	CWinApp *PCWinApp= AfxGetApp();	
	
	CIniKey.Format("WindowShowCmd1");		
	showCmd = PCWinApp->GetProfileInt(CSectionName, CIniKey, -1);
	if(showCmd == -1) return false;

	CIniKey.Format("WindowTop1");		
	top = PCWinApp->GetProfileInt(CSectionName, CIniKey, -1);	
	if(top < 1) return false;

	CIniKey.Format("WindowLeft1");		
	left = PCWinApp->GetProfileInt(CSectionName, CIniKey, -1);
	if(left < 1) return false;

	CIniKey.Format("WindowBottom1");		
	bottom = PCWinApp->GetProfileInt(CSectionName, CIniKey, 400);
	if(bottom < 10) return false;

	CIniKey.Format("WindowRight1");		
	right = PCWinApp->GetProfileInt(CSectionName, CIniKey, 400);
	if(right < 10) return false;

	CIniKey.Format("WindowXMinimised1");		
	xmin = PCWinApp->GetProfileInt(CSectionName, CIniKey, -1);

	CIniKey.Format("WindowYMinimised1");		
	ymin = PCWinApp->GetProfileInt(CSectionName, CIniKey, -1);

	CIniKey.Format("WindowXMaximised1");		
	xmax = PCWinApp->GetProfileInt(CSectionName, CIniKey, -1);

	CIniKey.Format("WindowYMaximised1");		
	ymax = PCWinApp->GetProfileInt(CSectionName, CIniKey, -1);

	s_window_placment.showCmd					= showCmd;
	s_window_placment.rcNormalPosition.right	= right;
	s_window_placment.rcNormalPosition.left		= left;	
	s_window_placment.rcNormalPosition.bottom	= bottom;
	s_window_placment.rcNormalPosition.top		= top;
	s_window_placment.ptMinPosition.x			= xmin;
	s_window_placment.ptMinPosition.y			= ymin;
	s_window_placment.ptMaxPosition.x			= xmax;
	s_window_placment.ptMaxPosition.y			= ymax;

	return true;
}

WINDOWPLACEMENT	GetWindowPlacement(CDocument *PCDoc)
{
	WINDOWPLACEMENT s_window_placment = GetDefaultWindowPlacment();

	if(!PCDoc) return s_window_placment;

	POSITION pos = PCDoc->GetFirstViewPosition();

	CView* PCView = PCDoc->GetNextView(pos);

	if(!PCView) return s_window_placment;

	PCView->GetParent()->GetWindowPlacement(&s_window_placment);

	return s_window_placment;
}

WINDOWPLACEMENT	GetViewPlacement(CDocument *PCDoc)
{
	WINDOWPLACEMENT s_window_placment = GetDefaultWindowPlacment();

	if(!PCDoc) return s_window_placment;

	POSITION pos = PCDoc->GetFirstViewPosition();

	CView* PCView = PCDoc->GetNextView(pos);

	if(!PCView) return s_window_placment;

	PCView->GetParent()->GetWindowPlacement(&s_window_placment);

	int showCmd = s_window_placment.showCmd;

	PCView->GetWindowPlacement(&s_window_placment);

	s_window_placment.showCmd = showCmd;

	return s_window_placment;
}


void SetWindowTitle(CMDIChildWnd *PCChildWnd, CString CPageTitle)// Called only after already called by the framework
{
	CString CNewTitle;	
	CString COldTitle;
	CString CAppend;

	COldTitle = ExtractFrameWorkTitle(PCChildWnd);

	CAppend.Format(" - %s", CPageTitle);

	CNewTitle = COldTitle + CAppend;

	PCChildWnd->SetWindowText(CNewTitle);

}

WINDOWPLACEMENT GetDefaultWindowPlacment(void)
{
	WINDOWPLACEMENT s_window_placment;

	s_window_placment.flags		= WPF_SETMINPOSITION;
	s_window_placment.length	= sizeof(s_window_placment);

	s_window_placment.showCmd					= 0;
	s_window_placment.rcNormalPosition.top		= 0;
	s_window_placment.rcNormalPosition.left		= 0;	
	s_window_placment.rcNormalPosition.bottom	= 400;
	s_window_placment.rcNormalPosition.right	= 600;
	
	s_window_placment.ptMinPosition.x			= -1;
	s_window_placment.ptMinPosition.y			= -1;
	s_window_placment.ptMaxPosition.x			= -1;
	s_window_placment.ptMaxPosition.y			= -1;

  
	return s_window_placment;
}

CString ExtractFrameWorkTitle(CMDIChildWnd *PCChildWnd)
{
	CString CFrameWorkTitle;

	PCChildWnd->GetWindowText(CFrameWorkTitle);

	int position = CFrameWorkTitle.Find("-");

	if(position < 0) // No other titles added yet so return full string
	{
		return CFrameWorkTitle;
	}

	CFrameWorkTitle = CFrameWorkTitle.Left(position - 1); // include space before the :

	return CFrameWorkTitle;

}


void ClearScreen(CDC *PCViewDC, COLORREF colour)
{
	if(!PCViewDC) return;

	CBrush CBackgroundBrush(colour);
 
	CBrush* pOldBrush = PCViewDC->SelectObject(&CBackgroundBrush);
 
	CRect CWindowRect;

	PCViewDC->GetClipBox(&CWindowRect);    

	// Note all devices support PatBlt, well tough luck !!

	PCViewDC->PatBlt(CWindowRect.left, CWindowRect.top, CWindowRect.Width(), 
					 CWindowRect.Height(), PATCOPY);
	
	PCViewDC->SelectObject(pOldBrush);

	CBackgroundBrush.DeleteObject();
}

void ClearScreen(CDC *PCViewDC, CRect ClearRect, COLORREF colour)
{
	if(!PCViewDC) return;

	CBrush CBackgroundBrush(colour);
 
	CBrush* pOldBrush = PCViewDC->SelectObject(&CBackgroundBrush);
   

	PCViewDC->PatBlt(ClearRect.left, ClearRect.top, ClearRect.Width(), 
					 ClearRect.Height(), PATCOPY);
	
	PCViewDC->SelectObject(pOldBrush);

	CBackgroundBrush.DeleteObject();
}

bool IsBadWindowHandle(CWnd *PCWnd)
{
	if(!PCWnd)
	{
		ASSERT(0);
		return true;
	}
	if(IsBadReadPtr(PCWnd, sizeof(CWnd)))
	{
		ASSERT(0);
		return true;
	}
	if(!IsWindow(PCWnd->m_hWnd)) 
	{
		ASSERT(0);
		
		return true;
	}

	return false;
}




CView *ActivateADocumentView(CDocument *PCDoc)
{
	if(!PCDoc) return NULL;

	if(IsBadReadPtr(PCDoc, sizeof(CDocument)))
	{
		ASSERT(0);

		return NULL;
	}

	POSITION pos = PCDoc->GetFirstViewPosition();

	if(!pos) return NULL;

	CView* PCView = PCDoc->GetNextView(pos);

	CWnd *PCChildWnd = PCView->GetParent();

	WINDOWPLACEMENT	s_window_placment;

	PCChildWnd->GetWindowPlacement(&s_window_placment);

	int show = SW_SHOWNORMAL;

	if(s_window_placment.showCmd == SW_SHOWMAXIMIZED)
		show = SW_SHOWMAXIMIZED;

	PCChildWnd->ShowWindow(show);
 	
	PCChildWnd->BringWindowToTop();

	return PCView;
}



int PrintBitmap(CDC *PCDCDest, HBITMAP HDDBitmap, int x, int y)
{
	HBITMAP PCPrinterBitmap = DDBToDDB(PCDCDest, HDDBitmap);

	if(!PCPrinterBitmap) return false;

	BITMAP s_bitmap;

	GetObject(HDDBitmap, sizeof(s_bitmap), (void *) &s_bitmap);

	CDC CCompatibleMemoryDC;
	
	CCompatibleMemoryDC.CreateCompatibleDC(PCDCDest);

	CObject *COldObject = (CObject *) CCompatibleMemoryDC.SelectObject(PCPrinterBitmap);

	if(!COldObject) return false;

	int result = PCDCDest->BitBlt(x, y, s_bitmap.bmWidth, s_bitmap.bmHeight, &CCompatibleMemoryDC,0,0,SRCCOPY);

	CCompatibleMemoryDC.SelectObject(COldObject);

	DeleteObject(PCPrinterBitmap);

	return result;
}
// This function takes device dependant bitmap and converts it to
// another device dependant bitmat compatable with the destination CDC

HBITMAP DDBToDDB(CDC *PCDCDest, HBITMAP HDDBitmap)
{
	HBITMAP DIBitmap = DDBToDIB(PCDCDest, HDDBitmap);

	if(!DIBitmap) return NULL;

	HBITMAP DDBitmap = DIBToDDB(PCDCDest, DIBitmap);

	DeleteObject(DIBitmap);

	delete [] (char*) DIBitmap;

	return DDBitmap;
}

HBITMAP DDBToDIB(CDC *PCDCDest, HBITMAP DDBitmap)
{
	HBITMAP HDiBitmap;

	BITMAP s_bitmap;

	if(!GetObject(DDBitmap, sizeof(s_bitmap), (void *) &s_bitmap)) return NULL;

	BITMAPINFOHEADER s_bitmap_info;

	s_bitmap_info.biSize		= sizeof(BITMAPINFOHEADER);
	s_bitmap_info.biWidth		= s_bitmap.bmWidth;
	s_bitmap_info.biHeight		= s_bitmap.bmHeight;
	s_bitmap_info.biPlanes		= 1;
	s_bitmap_info.biBitCount	= (WORD) (s_bitmap.bmPlanes * s_bitmap.bmBitsPixel); 
	s_bitmap_info.biCompression	= BI_RGB;

	s_bitmap_info.biSizeImage = (long) s_bitmap_info.biHeight * ((long) s_bitmap_info.biWidth *
								(long)  s_bitmap_info.biBitCount + 31L) / 32 * 4;

	s_bitmap_info.biXPelsPerMeter = 0;
	s_bitmap_info.biYPelsPerMeter = 0;

	if(!s_bitmap_info.biBitCount) s_bitmap_info.biClrUsed = 0; 
	else if(s_bitmap_info.biBitCount > 256) s_bitmap_info.biClrUsed = 0;
		 else s_bitmap_info.biClrUsed = 1 << s_bitmap_info.biBitCount;

	s_bitmap_info.biClrImportant = 0;

	DWORD size = sizeof(BITMAPINFOHEADER) + s_bitmap_info.biClrUsed *
				 sizeof(RGBQUAD) + s_bitmap_info.biSizeImage;
 
	void *p;

	p = (void *) new char[size];

	if(!p) return NULL;

	HDiBitmap = (HBITMAP) p;

/*	HDC hdc = GetDC(NULL);

	if(!hdc) 
	{
		delete [] p;

		return NULL;	
	}*/

	memcpy(HDiBitmap, &s_bitmap_info, (size_t) s_bitmap_info.biSize);

	LPSTR p_image = (LPSTR) HDiBitmap + (WORD) s_bitmap_info.biSize +
					        s_bitmap_info.biClrUsed * sizeof(RGBQUAD);
	
	if(!GetDIBits(PCDCDest->m_hDC, DDBitmap, 0, (WORD) s_bitmap_info.biHeight,
		      p_image, (LPBITMAPINFO) HDiBitmap, DIB_RGB_COLORS))
	{
//		ReleaseDC(NULL, hdc);

		delete [] p;

		return NULL;
	};

//	ReleaseDC(NULL, hdc);

	return HDiBitmap;
}

HBITMAP DIBToDDB(CDC *PCDC, HBITMAP DIBitmap)
{
	HBITMAP HDdBitmap;

	LPBITMAPINFOHEADER ps_bitmap_info =  (LPBITMAPINFOHEADER) DIBitmap;

	if(!ps_bitmap_info) return NULL;

	LPSTR p_image = (LPSTR) ps_bitmap_info + sizeof(BITMAPINFOHEADER) +
							ps_bitmap_info->biClrUsed * sizeof(RGBQUAD);

	
	HDdBitmap  = CreateDIBitmap(PCDC->m_hDC, ps_bitmap_info, CBM_INIT, p_image,
								(LPBITMAPINFO) ps_bitmap_info, DIB_RGB_COLORS);
 
	return HDdBitmap;
}
 
bool LoadGenericFromArchive(CObject *CDataObject, CString CFileName)
{
	CFile CDataFile;

	if(!CDataFile.Open(CFileName, CFile::modeRead | CFile::shareDenyNone)) return false;

	CArchive CArchiveFile(&CDataFile, CArchive::load);
	
	CDataObject->Serialize(CArchiveFile);

	return true;
}
bool SaveGenericToArchive(CObject *CDataObject, CString CFileName)
{
	CFile CDataFile;

	if(!CDataFile.Open(CFileName, CFile::modeCreate | CFile::modeWrite | CFile::shareDenyNone)) return false;

	CArchive CArchiveFile(&CDataFile, CArchive::store);

	CDataObject->Serialize(CArchiveFile);

	return true;
}

CView *CreateNewView(CDocument *PCDocument)
{
	// It is quite a toil trying to intersept the frame work !!
	// This fuction dublicates the framework
	// It is messy to intercept the new view command and InitialUpdateFrame to get the 
	// new view. Blank new pages need to be distinguished from new view copies.

	CDocTemplate* pTemplate = PCDocument->GetDocTemplate();

	CXTPMDIFrameWnd *PFrameWindow = (CXTPMDIFrameWnd *)AfxGetMainWnd();

	CMDIChildWnd *PCActiveChildWnd = (CMDIChildWnd *)PFrameWindow->MDIGetActive(NULL);

	CFrameWnd* PCFrame = pTemplate->CreateNewFrame(PCDocument, PCActiveChildWnd);

	if (PCFrame == NULL)
	{
		TRACE0("Warning: failed to create new frame.\n");
		return NULL;     // command failed
	}

	pTemplate->InitialUpdateFrame(PCFrame, PCDocument); 

	CView *PCView =  PCFrame->GetActiveView();

	return PCView; // This is the one just created !!
}


void DisplayPopupMenu(CWnd *PCWndPopupOwner, CPoint CMousePosition, int menu_resource_id)
{
	CRect CRectangle;

	if (CMousePosition.x == -1 && CMousePosition.y == -1)
	{
		PCWndPopupOwner->GetClientRect(CRectangle);
		PCWndPopupOwner->ClientToScreen(CRectangle);

		CMousePosition = CRectangle.TopLeft();
		CMousePosition.Offset(5, 5);
	}

	CMenu CPopupMainMenu;

	VERIFY(CPopupMainMenu.LoadMenu(menu_resource_id));

	CMenu* CPopupMenu = CPopupMainMenu.GetSubMenu(0);

	ASSERT(CPopupMenu != NULL);

//	while (PCWndPopupOwner->GetStyle() & WS_CHILD)
			PCWndPopupOwner = PCWndPopupOwner->GetParent();

	PCWndPopupOwner->ClientToScreen(&CMousePosition);
	

	CPopupMenu->TrackPopupMenu(TPM_LEFTALIGN | TPM_RIGHTBUTTON, CMousePosition.x, CMousePosition.y,
			PCWndPopupOwner);

}

bool CreateRegion(CRgn *CRegion, CPoint CStart, CPoint CEnd, bool subtract_edge)
{
	CPoint	CNewPoint = CStart;
	CArray <CPoint, CPoint> CPointArray;

	if(subtract_edge)
	{
		CEnd.x -= 1;
		CEnd.y -= 1;
	}

	CPointArray.Add(CStart);
	CNewPoint.y += CEnd.y - CStart.y; 
	CPointArray.Add(CNewPoint);
	CPointArray.Add(CEnd);
	CNewPoint = CStart;
	CNewPoint.x += CEnd.x - CStart.x;
	CPointArray.Add(CNewPoint);

	CRegion->DeleteObject();
	if(CRegion->CreatePolygonRgn(&CPointArray[0], 4, ALTERNATE)) return false;

	return true;
}
bool CreateRegion(CRgn *CRegion,CPoint CStart, int width, int height, bool subtract_edge)
{
	CPoint	CNewPoint = CStart;
	CArray <CPoint, CPoint> CPointArray;

	if(subtract_edge)
	{
		width -= 1;
		height -= 1;
	}

	if(!width || !height) return false;

	CPointArray.Add(CStart);
	CNewPoint.y += height; 
	CPointArray.Add(CNewPoint);
	CNewPoint.x += width;
	CPointArray.Add(CNewPoint);
	CNewPoint.y -= height;
	CPointArray.Add(CNewPoint);

	CRegion->DeleteObject();
	if(CRegion->CreatePolygonRgn(&CPointArray[0], 4, ALTERNATE)) return true;

	return false;
}

bool CreateRegion(CRgn *CRegion, CPoint CTopLeft, CPoint CBottomLeft, CPoint CBottomRight, CPoint CTopRight)
{
	CArray <CPoint, CPoint> CPointArray;

	CPointArray.Add(CTopLeft);
	CPointArray.Add(CBottomLeft);
	CPointArray.Add(CBottomRight);
	CPointArray.Add(CTopRight);

	CRegion->DeleteObject();
	if(CRegion->CreatePolygonRgn(&CPointArray[0], 4, ALTERNATE)) return false;

	return false;
}


TCFont::TCFont()
{

}
TCFont::~TCFont()
{
	DeleteObject();
}	

void TCFont::operator = (TCFont &CFontData)
{
	LOGFONT	s_logfont;

	CFontData.GetLogFont(&s_logfont);

	DeleteObject();

	CreateFontIndirect(&s_logfont);
}

void TCFont::Serialize(CArchive& CArchiveFile)
{
//	CFont::Serialize(CArchiveFile);

	LOGFONT	s_logfont;

	if(CArchiveFile.IsStoring())
	{
		GetLogFont(&s_logfont);

		CArchiveFile.Write(&s_logfont, sizeof(s_logfont));
	}
	else
	{
		CArchiveFile.Read(&s_logfont, sizeof(s_logfont));

		DeleteObject();
		CreateFontIndirect(&s_logfont);
	}
}

bool ProcessWindowsMessages(void)// to stop proccessing function locking out application
{
	MSG msg;

	if(!PeekMessage(&msg, NULL, 0, 0, PM_REMOVE)) return false;// recieved WM_QUIT message

    TranslateMessage(&msg);
    DispatchMessage(&msg);

	return true;
}

bool TransformMeanSigma(double *mean, double *sigma)
{
	double new_sigma, new_mean, sigma_m;
	// need to protect from model parameters changing sign, e.g. Is of bipolar, Vts are ok 
	if(!mean) return true; // Value can take +/- values

	if(mean > 0)
		if(3 * *sigma < *mean) return true; //do nothing all positive numbers will stay positive
	else
		if(3 * *sigma < - *mean) return true; //do nothing all negative numbers will stay negative

	sigma_m = *sigma / *mean;

	new_mean = *mean * (1 + sigma_m + 1/(1 + sigma_m))/2;

	new_sigma = *mean * (1 + sigma_m - 1/(1 + sigma_m))/2;

	*sigma = new_sigma;

	*mean = new_mean;

	return true;
}

double GetMCUniform(double mean, double sigma)
{
	double value = 0.0;

	if(!sigma) return mean;

	if(sigma < 0) sigma = - sigma;

	double uniform;
	
	uniform = (double)rand()/(double)RAND_MAX;// value from 0 to 1

	uniform -= 0.5; //variation goes from +/- 0.5

	uniform *= 5.94; //variation goes from +/- 3 * 0.99%

	// transform mean so that *2.5 and *.4 can be handled

	TransformMeanSigma(&mean, &sigma);

	value = mean + sigma * uniform; // limit variation to 3 Sigma

	return value;
}

double GetMCGaussian(double mean, double sigma)
{
	double gaussian, value;
	double rand1, rand2;

	if(!sigma) return mean;

	if(sigma < 0) sigma = - sigma;

	rand1 = (double)rand()/(double)RAND_MAX;// value from 0 to 1
	rand2 = (double)rand()/(double)RAND_MAX;// value from 0 to 1

	if(!rand1) rand1 = 1/32768;// ovoid divide by zero
	if(!rand2) rand2 = 1/32768;

	gaussian = sqrt(-2 * log(rand1)) * cos(6.2831835307 * rand2);// Box-Muller uniform to gaussian transformation

	if(gaussian > 4.56) gaussian = 4.56; // limit variation to 4.6 Sigma sqrt(-2*ln(1/32768))
	if(gaussian < -4.56) gaussian = -4.56; // Box-Muller will limit to +/- 4.6 with 1/32768

	gaussian *= 0.6513; // 3 *.99/(); 4.56 //scale to +/- 3 * 99% of sigma

	value = mean + sigma * gaussian; 

	return value;
}



double GetMCPoisson(double mean, double sigma)
{
	//to do
	double value = 0.0;

	mean;
	sigma;

	return value;
}

