#ifndef _GENERIC_H
#define _GENERIC_H

#include "stdafx.h"
#include <afxtempl.h>
//#include "xtgeneric.h"

bool ProcessWindowsMessages(void);// to stop proccessing function locking out application

void DisplayPopupMenu(CWnd *PCWndPopupOwner, CPoint CMousePosition, int menu_resource_id);

double NoisePercentRatio(double fraction, double total);

bool CreateRegion(CRgn *CRegion, CPoint CStart, CPoint CEnd, bool subtract_edge = false);
bool CreateRegion(CRgn *CRegion, CPoint CStart, int width, int height, bool subtract_edge = false);
bool CreateRegion(CRgn *CRegion, CPoint CTopLeft, CPoint CBottomLeft, CPoint CBottomRight, CPoint CTopRight);

bool GetPrinterDC(CDC &CPrinterDC);

bool SaveWindowLayout(CWnd *PCWindow, CString CSectionName);
bool LoadWindowLayout(CWnd *PCWindow, CString CSectionName);
bool GetLastWindowPlacement(WINDOWPLACEMENT &s_window_placment, CString CSectionName);
CDocument *OpenAndLoadWindow(CMultiDocTemplate *PCMultiDocTemplate, CString CFileName, CString CWindowName);
void SaveWindow(CDocument *PCDoc, CString CWindowName);
void DockControlBarRightOf(CXTPMDIFrameWnd *PCWnd, CToolBar* CBarLeft, CToolBar*  CBarRight);

WINDOWPLACEMENT GetDefaultWindowPlacment(void);

bool LoadGenericFromArchive(CObject *CDataObject, CString CFileName);
bool SaveGenericToArchive(CObject *CDataObject, CString CFileName);

int GetRandomNumber(void);
CString GetRandomNumberString(void);

float GetPrinterResolution(void);

void ClearScreen(CDC *PCViewDC, COLORREF colour);
void ClearScreen(CDC *PCViewDC, CRect ClearRect, COLORREF colour);

double GetMCUniform(double mean, double sigma);
double GetMCGaussian(double mean, double sigma);
double GetMCPoisson(double mean, double sigma);
bool   TransformMeanSigma(double *mean, double *sigma);

inline void MultyplyCPoint(CPoint *CPosition, float multiplyer);

inline void MultyplyCPoint(CPoint *CPosition, float multiplyer)
{
	CPosition->x = (long)((CPosition->x)* multiplyer);

	CPosition->y = (long)((CPosition->y )* multiplyer);
}

inline CPoint SnapToGrid(CPoint CLocation, int grid_size);

inline CPoint SnapToGrid(CPoint CLocation, int grid_size)
{
	if(!grid_size) return CLocation;

	CLocation.x += (int)(grid_size >> 1);
	CLocation.x /= grid_size;
	CLocation.x *= grid_size;

	CLocation.y += (int)(grid_size >> 1);
	CLocation.y /= grid_size;
	CLocation.y *= grid_size;

	return CLocation;
}

CView *CreateNewView(CDocument *PCDocument);

void SerializeWindow(CArchive &ar, CView *PCView);
void SerializeWindow(CArchive &ar, CDocument *PCDocument);

void	SetWindowTitle(CMDIChildWnd *PCChildWnd, CString CPageTitle);
CString ExtractFrameWorkTitle(CMDIChildWnd *PCChildWnd);

bool IsBadWindowHandle(CWnd *PCWnd);
CView *ActivateADocumentView(CDocument *PCDoc);
CDocument *OpenWindow(CMultiDocTemplate *PCMultiDocTemplate, CString CFileName);

int PrintBitmap(CDC *PCDCDest, HBITMAP HDDBitmap, int x, int y);
HBITMAP DDBToDDB(CDC *PCDC, HBITMAP DDBitmap); 
HBITMAP DDBToDIB(CDC *PCDCDest, HBITMAP DIBitmap);
HBITMAP DIBToDDB(CDC *PCDCDest, HBITMAP HDDBitmap);

WINDOWPLACEMENT	GetWindowPlacement(CDocument *PCDoc);
WINDOWPLACEMENT	GetViewPlacement(CDocument *PCDoc);

class TCFont : public CFont
{
	public:

			TCFont();
			~TCFont();

			void operator = (TCFont &CFontData);

			void Serialize(CArchive& CArchiveFile);

			DECLARE_SERIAL(TCFont)
};




#endif