// SuperSpice.cpp : Defines the class behaviors for the application.
//
#pragma warning(disable : 4611) /* C4113 warning expected */

// debug malloc is in \vc98\src\dbgheap.c
#include <malloc.h>
#include <signal.h>
#include <setjmp.h>
#include "stdafx.h"
#include "afxpriv.h"
#include <htmlhelp.h>
#include "float.h"
#include "math.h"
#include "winspool.h"
#include "Generic.h"
#include "SuperSpice.h"
#include "TCRealTimeData.h"
#include "TCFileFunctions.h"
#include "TCSuperSpiceGlobalData.h"
#include "TCSuperSpiceDataBase.h"
#include "TCSuperSpiceClipboard.h"
#include "TCSuperSpiceMainFrame.h"
#include "TCSuperSpiceChildFrame.h"
#include "TCSuperSpiceInPlaceFrame.h"
#include "TCSuperSpiceTextChildFrm.h"
#include "TCSuperSpiceTextDoc.h"
#include "TCSuperSpiceTextView.h"
#include "TCSuperSpiceTextCntrItem.h"
#include "TCSuperSpiceDoc.h"
#include "TCSuperSpiceView.h"
#include "TCOutputWaveformChildFrame.h"
#include "TCOutputWaveformDoc.h"
#include "TCOutputWaveformView.h"
#include "TCAuthorization.h"
#include "TCContactInfo.h"
#include "TCSymbolEditorDoc.h"
#include "TCSymbolEditorView.h"
#include "TCModelTreeDoc.h"
#include "TCModelTreeView.h"
#include "TCSymbolTreeDoc.h"
#include "TCSymbolTreeView.h"
#include "TCFileTreeDoc.h"
#include "TCFileTreeView.h"
#include "TCCircuitsTreeDoc.h"
#include "TCCircuitsTreeView.h"
#include "TCSymbolPreDoc.h"
#include "TCSymbolPreView.h"
#include "TCModelPreviewDoc.h"
#include "TCModelPreViewView.h"
#include "TESuperSpiceMessages.h"
#include "TCXSpiceProgressData.h"
#include "TCSignalsTreeDoc.h"
#include "TCSignalsTreeView.h"
#include "TCGeneralReportsTab.h"
#include "TCWorkspaceTree.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif
 
CString GGeneratorLoadVersion;
CString GGeneratorSaveVersion;
TCSuperSpiceGlobalData	GCSuperSpiceGlobalData;
TCSuperSpiceDataBase	GCSuperSpiceDataBase;
TCAuthorization			GCAuthorization;
UINT					GSuperSpiceToXSpiceMessageID = 0;

TCSuperSpiceClipboard	GCSuperSpiceClipboard;
extern TCSuperSpiceDoc *PCSuperSpiceDocLastFocused;
extern TCSuperSpiceView *PCSuperSpiceViewLastFocused;
extern TCMultyTaskedString CGlobalStatusMessage;
extern TCMultyTaskedString CGlobalXSpiceMessage;
TCMultyTaskedString CGlobalXSpiceStatusNull;
extern TCGeneralReportsTab GCGeneralReportsTab;
extern TCWorkspaceTree GCWorkspaceTree;



TCVersionInfo GCProgramVersionInfo;

CString GetHTMLTopicName(DWORD dwData);
CString CSuperSpiceXSpiceMessage = "SuperSpiceXSpiceMessage";

HDC	HDCMSrcCmp = CreateCompatibleDC(NULL);
HDC	HDCMDestCmp = CreateCompatibleDC(HDCMSrcCmp);
CDC GlobalCDCTemp;
int global_screen_planes = 1;
int global_screen_bitspixels = 8;
bool GetSafeDouble(double &);

void FloatingPointExceptionHandler(int sig);  
extern jmp_buf GFloatingPointExceptionBuff; /* Address for long jump to jump to */
CString FloatToSpiceMKSString(double);

CString GetWebSiteName(void);
CString GetSupportEMailName(void);
CString GetContactEMailName(void);
CString GetCompanyName(void);
CString GetHelpFileName(void);
CString GetOEMProgramName(void);
CString GetCompanyAddress(void);
CString GetCompanyPhoneNumber(void);
CString GetKevinsTutorialWebSiteName(void);
CString GetKevinsWebSiteName(void);

int GetOEMID(void);
void SetOEMID(void);
static int m_oem_id = 0;

enum TE_OEMIDS
{
	E_ANASOFT_LTD = 0,
	E_INTELLISENSE_CORP,
};

/////////////////////////////////////////////////////////////////////////////
// TCSuperSpiceApp

BEGIN_MESSAGE_MAP(TCSuperSpiceApp, CWinApp)
	//{{AFX_MSG_MAP(TCSuperSpiceApp)
	ON_COMMAND(ID_APP_ABOUT, OnAppAbout)
	ON_COMMAND(ID_FILE_OPEN, OnFileOpen)
	ON_COMMAND(ID_HELP_CONTACT, OnHelpContact)
	ON_COMMAND(ID_FILE_PRINT_SETUP, OnFilePrintSetup)
	//}}AFX_MSG_MAP
	// Standard file based document commands
	ON_COMMAND(ID_FILE_NEW, CWinApp::OnFileNew)
	// Standard print setup command
	ON_COMMAND(ID_FILE_PRINT_SETUP, CWinApp::OnFilePrintSetup)
	ON_COMMAND(ID_FILE_OPENEXAMPLES, &TCSuperSpiceApp::OnFileOpenExamples)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// TCSuperSpiceApp construction

TCSuperSpiceApp::TCSuperSpiceApp()
{
	super_spice_xspice_message = RegisterWindowMessage(CSuperSpiceXSpiceMessage);

	CGlobalXSpiceStatusNull ="XSpice:																				";

	pm_msg_data = new char[4096];

	m_real_time_run_type = 0;
}

TCSuperSpiceApp::~TCSuperSpiceApp()
{
	if(pm_msg_data) delete pm_msg_data;
}

/////////////////////////////////////////////////////////////////////////////
// The one and only TCSuperSpiceApp object

TCSuperSpiceApp theApp;

// This identifier was generated to be statistically unique for your app.
// You may change it if you prefer to choose a specific identifier.

// {0290C286-590E-11D0-9196-F6D029BC0B3F}
static const CLSID clsid =
{ 0x290c286, 0x590e, 0x11d0, { 0x91, 0x96, 0xf6, 0xd0, 0x29, 0xbc, 0xb, 0x3f } };

/////////////////////////////////////////////////////////////////////////////
// TCSuperSpiceApp initialization

BOOL TCSuperSpiceApp::InitInstance()
{	
	_fpreset();// make sure all cleared

	GSuperSpiceToXSpiceMessageID = RegisterWindowMessage("GSuperSpiceToXSpiceMessageString");
 
	if (!AfxSocketInit())
	{
		AfxMessageBox(IDP_SOCKETS_INIT_FAILED);
		return FALSE;
	}    
  
	// Initialize OLE libraries
	if (!AfxOleInit())
	{
		AfxMessageBox(IDP_OLE_INIT_FAILED);
		return FALSE;
	}

#ifdef RELEASE_OEM1

#else
	;         
#endif

	AfxEnableControlContainer();

	// Standard initialization
	// If you are not using these features and wish to reduce the size
	//  of your final executable, you should remove from the following
	//  the specific initialization routines you do not need.


//	SHGetFolderLocation();

#ifdef RELEASE_OEM1
	SetRegistryKey(_T("IntelliSense"));
#else
	SetRegistryKey(_T("AnaSoft"));         
#endif
	

	LoadStdProfileSettings(16);  // Load standard INI file options (including MRU)

	// Register the application's document templates.  Document templates
	//  serve as the connection between documents, frame windows and views.

	int text_type			= IDR_SPICE_TEXTTYPE;
	int schematic_type		= IDR_SUPERSTYPE;
	int graphics_type		= IDR_SUPERSTYPE_GRAPHICS;
	int symbol_editor_type	= IDR_SUPERSTYPE_SYMBOL_EDITOR;

#ifdef	RELEASE_OEM1
		schematic_type		= IDR_SUPERSTYPE_OEM1;
		text_type			= IDR_SPICE_TEXT_OEM1;
		graphics_type		= IDR_SUPERSTYPE_GRAPHICS_OEM1;
		symbol_editor_type	= IDR_SUPERSTYPE_SYMBOL_OEM1;
#endif

	PCMSpiceTextViewDocTemplate = new CMultiDocTemplate(
		text_type,
		RUNTIME_CLASS(TCSuperSpiceTextDoc),
		RUNTIME_CLASS(TCSuperSpiceTextChildFrame),
		RUNTIME_CLASS(TCSuperSpiceTextView));

	PCMSuperSpiceDocTemplate = new CMultiDocTemplate(
		schematic_type,
		RUNTIME_CLASS(TCSuperSpiceDoc),
		RUNTIME_CLASS(TCSuperSpiceChildFrame), // custom MDI child frame
		RUNTIME_CLASS(TCSuperSpiceView));

		PCMWaveformDisplayDocTemplate = new CMultiDocTemplate(
		graphics_type,
		RUNTIME_CLASS(TCOutputWaveformDoc),
		RUNTIME_CLASS(TCOutputWaveformChildFrame),
		RUNTIME_CLASS(TCOutputWaveformView));

		PCMSpiceNetListViewDocTemplate = new CMultiDocTemplate(
		text_type,
		RUNTIME_CLASS(TCSuperSpiceTextDoc),
		RUNTIME_CLASS(TCSuperSpiceTextChildFrame),
		RUNTIME_CLASS(TCSuperSpiceTextView));
		
	// Same as .net files but .out
	PCMSpiceOutputTextViewDocTemplate = new CMultiDocTemplate(
		text_type,
		RUNTIME_CLASS(TCSuperSpiceTextDoc),
		RUNTIME_CLASS(TCSuperSpiceTextChildFrame),
		RUNTIME_CLASS(TCSuperSpiceTextView));
	
		PCEngineErrorLogTemplate = new CMultiDocTemplate(
		text_type,
		RUNTIME_CLASS(TCSuperSpiceTextDoc),
		RUNTIME_CLASS(TCSuperSpiceTextChildFrame),
		RUNTIME_CLASS(TCSuperSpiceTextView));

		PCMSpiceLibaryViewDocTemplate = new CMultiDocTemplate(
		text_type,
		RUNTIME_CLASS(TCSuperSpiceTextDoc),
		RUNTIME_CLASS(TCSuperSpiceTextChildFrame),
		RUNTIME_CLASS(TCSuperSpiceTextView));

		PCMSpiceModelViewDocTemplate = new CMultiDocTemplate(
		text_type,
		RUNTIME_CLASS(TCSuperSpiceTextDoc),
		RUNTIME_CLASS(TCSuperSpiceTextChildFrame),
		RUNTIME_CLASS(TCSuperSpiceTextView));

		// temp, more to do
		PCMSuperSpiceSchematicSymbolViewDocTemplate = new CMultiDocTemplate(
		symbol_editor_type,
		RUNTIME_CLASS(TCSymbolEditorDoc),
		RUNTIME_CLASS(TCOutputWaveformChildFrame),// may change later
		RUNTIME_CLASS(TCSymbolEditorView));

		// CModelView object
		PCModelTreeTemplate = new CMultiDocTemplate(
		IDR_MENU_MODEL_TREE,
		RUNTIME_CLASS(TCModelTreeDoc), NULL,
		RUNTIME_CLASS(TCModelTreeView));
		
		// CSymbolView object
		PCSymbolTreeTemplate = new CMultiDocTemplate(
		IDR_MENU_SYMBOL_TREE,
		RUNTIME_CLASS(TCSymbolTreeDoc), NULL,
		RUNTIME_CLASS(TCSymbolTreeView));

		// CFileView object
		PCFileTreeTemplate = new CMultiDocTemplate(
		IDR_MENU_FILE_TREE,
		RUNTIME_CLASS(TCFileTreeDoc), NULL,
		RUNTIME_CLASS(TCFileTreeView));

		// CCircuitsView object
		PCCircuitsTreeTemplate = new CMultiDocTemplate(
		IDR_MENU_CIRCUITS_TREE,
		RUNTIME_CLASS(TCCircuitsTreeDoc), NULL,
		RUNTIME_CLASS(TCCircuitsTreeView));

		// Symbol Preview object
		PCSymbolPreviewTemplate = new CMultiDocTemplate(
		CG_IDR_POPUP_TCSUPER_SPICE_SYMBOL_PREVIEW,
		RUNTIME_CLASS(TCSymbolPreDoc), NULL,
		RUNTIME_CLASS(TCSymbolPreView));

		// Model Preview object
		PCModelPreviewTemplate = new CMultiDocTemplate(
		CG_IDR_POPUP_TCSUPER_SPICE_MODEL_PREVIEW,
		RUNTIME_CLASS(TCModelPreviewDoc), NULL,
		RUNTIME_CLASS(TCModelPreViewView));

		//Waveform Signals object
		PCSignalsTemplate = new CMultiDocTemplate(
		CG_IDR_POPUP_TREE_SIGNALS,
		RUNTIME_CLASS(TCSignalsTreeDoc), NULL,
		RUNTIME_CLASS(TCSignalsTreeView));

		PCMSuperSpiceDocTemplate->SetContainerInfo(IDR_SUPERSTYPE_CNTR_IP);
		PCMSuperSpiceDocTemplate->SetServerInfo(
		IDR_SUPERSTYPE_SRVR_EMB, IDR_SUPERSTYPE_SRVR_IP,
		RUNTIME_CLASS(TCSuperSpiceInPlaceFrame));


	AddDocTemplate(PCMSuperSpiceDocTemplate);

	// Enable DDE Execute open
	EnableShellOpen();                   // Moved from futher down to stop the other docs getting registered
	RegisterShellFileTypes(TRUE);

	// Parse command line for standard shell commands, DDE, file open
	CCommandLineInfo cmdInfo;
	ParseCommandLine(cmdInfo);

	AddDocTemplate(PCMSpiceNetListViewDocTemplate);
	AddDocTemplate(PCMSpiceOutputTextViewDocTemplate);
	AddDocTemplate(PCMSpiceLibaryViewDocTemplate);
	AddDocTemplate(PCMSpiceModelViewDocTemplate);
	AddDocTemplate(PCMSpiceTextViewDocTemplate);
	AddDocTemplate(PCMWaveformDisplayDocTemplate);
	AddDocTemplate(PCEngineErrorLogTemplate);

	AddDocTemplate(PCModelTreeTemplate);
	AddDocTemplate(PCSymbolTreeTemplate);
	AddDocTemplate(PCFileTreeTemplate);
	AddDocTemplate(PCCircuitsTreeTemplate);
	AddDocTemplate(PCSignalsTemplate);

	AddDocTemplate(PCSymbolPreviewTemplate);
	AddDocTemplate(PCModelPreviewTemplate);
	
	AddDocTemplate(PCMSuperSpiceSchematicSymbolViewDocTemplate);

	// Connect the COleTemplateServer to the document template.
	//  The COleTemplateServer creates new documents on behalf
	//  of requesting OLE containers by using information
	//  specified in the document template.
	m_server.ConnectTemplate(clsid, PCMSuperSpiceDocTemplate, FALSE);

	// Register all OLE server factories as running.  This enables the
	//  OLE libraries to create objects from other applications.
	COleTemplateServer::RegisterAll();
		// Note: MDI applications register all server objects without regard
		//  to the /Embedding or /Automation on the command line.

	// create main MDI Frame window
	TCSuperSpiceMainFrame* pMainFrame = new TCSuperSpiceMainFrame;

	int main_frame_type = IDR_MAINFRAME;

#ifdef	RELEASE_OEM1
		main_frame_type = IDR_MAINFRAME_OEM1;
#endif

	LoadInitFile();
 
	SetupPrinter();

	GCSuperSpiceGlobalData.Setup();

	if (!pMainFrame->LoadFrame(main_frame_type)) return FALSE;

	m_pMainWnd = pMainFrame;

	m_pMainWnd->DragAcceptFiles();

	pMainFrame->ShowWindow(m_nCmdShow);

	pMainFrame->UpdateWindow();

	SetupGlobals(); //  window painting DC's

	LoadWinLayout(pMainFrame);

	InitDB(); // Load symbols etc

	GCWorkspaceTree.Refresh();

	((TCSuperSpiceMainFrame*)m_pMainWnd)->RedrawAllPanes();// forces pane to be created and tabs to get drawn correctly

	((TCSuperSpiceMainFrame*)m_pMainWnd)->SetXSpiceStatusText(CGlobalXSpiceStatusNull);

	if(!GCAuthorization.Verify()) return false;

	SetOEMID();

	GetCommandLineFileName(cmdInfo);

	if(!ProcessShellCommand(cmdInfo)) return false;

//	if(cmdInfo.m_strFileName && *cmdInfo.m_strFileName)
	//	OpenDocumentFile(cmdInfo.m_strFileName);

	return TRUE;
}

void TCSuperSpiceApp::LoadInitFile(void)
{
	CString CUserDir;

	CUserDir = GetInitDirectory();

	CFile CDataFile;

	CString CFileName = GCSuperSpiceDataBase.CSuperSpiceInitName;
								
	CString CText =  CUserDir + CFileName;

	if(CDataFile.Open(CText, CFile::modeRead | CFile::shareDenyNone))// load init file
	{
		int file_length; // on new install SuperSpice.ssi is zero length

		file_length = (int)CDataFile.GetLength();

		CDataFile.Close();

		if(file_length < 10) DeleteInitFiles(CUserDir);

		if(file_length && GCSuperSpiceGlobalData.Load(CText))// load the user init if it exists
		{
			if(!GCSuperSpiceGlobalData.load_ok)
			{
				AfxMessageBox(IDS_BAD_INIT_FILE);
			}
		}
	}
	else DeleteInitFiles(CUserDir);
}

void TCSuperSpiceApp::DeleteInitFiles(CString CUserDir)
{
	CString CFileName = "SuperSpice";

#ifdef RELEASE_OEM1
		CFileName = "MEMSystem";
#endif

	DeleteFile(CUserDir + CFileName + ".scb");
	DeleteFile(CUserDir + CFileName + ".scl");
	DeleteFile(CUserDir + CFileName + ".skl");
	DeleteFile(CUserDir + CFileName + ".sdb");
	DeleteFile(CUserDir + CFileName + ".sef");
	DeleteFile(CUserDir + CFileName + ".sff");
	DeleteFile(CUserDir + CFileName + ".sml");
	DeleteFile(CUserDir + CFileName + ".ssi");
	DeleteFile(CUserDir + CFileName + ".ssl");
	DeleteFile(CUserDir + CFileName + ".ssm");
	DeleteFile(CUserDir + CFileName + ".sym");

}

void TCSuperSpiceApp::InitDB(void)
{
	CString CFileName = GCSuperSpiceGlobalData.CGeneric.CDataBaseInitFileName;

	CString CText = GetApplicationDataDirectory();

	GCSuperSpiceDataBase.Init();
	GCSuperSpiceDataBase.SetupFilePaths(CText);
	GCSuperSpiceDataBase.SetupSymbolNames();
	GCSuperSpiceDataBase.Load(CFileName);
	GCSuperSpiceDataBase.Setup();
}

void TCSuperSpiceApp::LoadWinLayout(TCSuperSpiceMainFrame* pMainFrame)
{
	CString CSectionName;

	CSectionName.LoadString(IDS_MAINWINDOW_SECTION_NAME);

	// if no init file loaded, dont load layout
	if(GCSuperSpiceGlobalData.CGeneric.load_toolbar_state) LoadWindowLayout(pMainFrame, CSectionName);

	GCSuperSpiceClipboard.Load(GCSuperSpiceGlobalData.CGeneric.CDataBaseClipboardFileName);
}

void TCSuperSpiceApp::GetCommandLineFileName(CCommandLineInfo &cmdInfo)
{
	if(cmdInfo.m_strFileName != "") return;// if passed a name, dont load the default

	if(!GCSuperSpiceGlobalData.CProgramOptions.CGeneral.load_on_start) return;

	CString CText = GCSuperSpiceGlobalData.CProgramOptions.CGeneral.CLastWorkspaceLoaded;
	CFile CFileTest;

	if(FileExists(CText))
	{
		cmdInfo.m_strFileName = CText;

		cmdInfo.m_nShellCommand = CCommandLineInfo::FileOpen;
	}
}

bool TCSuperSpiceApp::CloseWorkSpaces(void)// this is to overide the framework
{
	// close top level superspice docs first
	// these close their own children 

	CDocTemplate *PCDocTemplate;
	CDocument	*PCDocument;

	CArray <CDocument*, CDocument*> PDocsList;
	PDocsList.SetSize(0, 8);

	POSITION DocTemplatePos = GetFirstDocTemplatePosition();
	POSITION DocPos;

	// Now save model and symbol files
	int value;

	if(GCSuperSpiceGlobalData.CProgramOptions.CGeneral.prompt_save_model_files_on_exit)
	{
		value = AfxMessageBox(IDS_QUERY_SAVE_MODEL_FILE, MB_YESNO);
		
		if(value == 6)//IDOK dont work!!!!!
		{
			if(!GCSuperSpiceDataBase.SaveModels()) AfxMessageBox(IDS_QUERY_SAVE_MODEL_FILE);
		}
	}
	else if(GCSuperSpiceGlobalData.CProgramOptions.CGeneral.save_model_files_on_exit) GCSuperSpiceDataBase.SaveModels();

	if(GCSuperSpiceGlobalData.CProgramOptions.CGeneral.prompt_save_symbol_files_on_exit)
	{
		value = AfxMessageBox(IDS_QUERY_SAVE_SYMBOL_FILES, MB_YESNO);
		
		if(value == 6)
		{
			if(!GCSuperSpiceDataBase.SaveSymbols()) AfxMessageBox(IDS_UNABLE_TO_SAVESYMBOLS);
		}
	}
	else if(GCSuperSpiceGlobalData.CProgramOptions.CGeneral.save_symbol_files_on_exit) GCSuperSpiceDataBase.SaveSymbols();

	if(GCSuperSpiceGlobalData.CProgramOptions.CGeneral.prompt_save_component_files_on_exit)
	{
		value = AfxMessageBox(IDS_QUERY_SAVE_ALL_COMPONENT_CHANGES, MB_YESNO);

		if(value == 6)
		{
			if(!GCSuperSpiceDataBase.SaveCircuits()) AfxMessageBox(IDS_UNABLE_TO_SAVE_CIRCUITS);
		}
	}
	else if(GCSuperSpiceGlobalData.CProgramOptions.CGeneral.save_component_files_on_exit) GCSuperSpiceDataBase.SaveCircuits();

	TCSuperSpiceDoc *PCSuperSpiceDoc;

	while(DocTemplatePos)// get top level schematics, and close them first
	{
		PCDocTemplate = GetNextDocTemplate(DocTemplatePos);

		DocPos = PCDocTemplate->GetFirstDocPosition();

		while(DocPos)
		{
			PCDocument = PCDocTemplate->GetNextDoc(DocPos);

			if(PCDocument->IsKindOf(RUNTIME_CLASS(TCSuperSpiceDoc)))
			{
				PCSuperSpiceDoc = (TCSuperSpiceDoc *)PCDocument;
				
				if(!PCSuperSpiceDoc->top_level) continue;

				PDocsList.Add(PCDocument);
			}
		}
	}

	int count = PDocsList.GetSize();

	CString CThisFileName;
	CString CMessage, CMsg;

	int save_value;

	for(int p = 0; p < count; p++)// top levels will close their own workspaces/children
	{
		PCSuperSpiceDoc = (TCSuperSpiceDoc *) PDocsList[p];

		CThisFileName = PCSuperSpiceDoc->CThisFileName; 
		
		if(CThisFileName != "")
		if(PCSuperSpiceDoc->IsModified())
		{
			CMsg.LoadString(IDS_QUERY_SAVE_SCHEMATICS);

			CMessage.Format(" %s", CThisFileName);

			CMsg += CMessage;

			save_value = AfxMessageBox(CMsg, MB_YESNOCANCEL);

			if(save_value == IDCANCEL) return false;
			if(save_value == IDYES) PCSuperSpiceDoc->OnSaveDocument(CThisFileName);
		}

		PCSuperSpiceDoc->OnCloseDocument();

		//Ensure a toplevel is the last loaded file name
		if(!p) 	GCSuperSpiceGlobalData.CProgramOptions.CGeneral.CLastWorkspaceLoaded = CThisFileName;
	}

	if(GCSuperSpiceGlobalData.CProgramOptions.CGeneral.save_on_exit)
	{
		SaveOnExit();// saves all global data and database data
	}
	else
	{
		value = AfxMessageBox(IDS_QUARY_SAVE_ALL_PROGRAM_CHANGES, MB_YESNO);

		if(value == IDOK) SaveOnExit();
	}
	// Framework takes care of the rest

	return true;
}

void TCSuperSpiceApp::SetupGlobals(void)
{
	CDC *PCDC = m_pMainWnd->GetDC();

	global_screen_planes		= PCDC->GetDeviceCaps(PLANES);
	global_screen_bitspixels	= PCDC->GetDeviceCaps(BITSPIXEL);

	m_pMainWnd->ReleaseDC(PCDC);

	GlobalCDCTemp.CreateCompatibleDC(NULL);
}

void TCSuperSpiceApp::SaveOnExit(void)
{
	CString CUserDirectory, CFileName;

	CUserDirectory = GetInitDirectory();

	CFileName = CUserDirectory + GCSuperSpiceDataBase.CSuperSpiceInitName;

	GCSuperSpiceGlobalData.Save(CFileName);

	GCSuperSpiceDataBase.Save(GCSuperSpiceGlobalData.CGeneric.CDataBaseInitFileName);

	GCSuperSpiceClipboard.Save(GCSuperSpiceGlobalData.CGeneric.CDataBaseClipboardFileName);
}

int TCSuperSpiceApp::ExitInstance() 
{

	DeleteDC(HDCMSrcCmp);
	DeleteDC(HDCMDestCmp);
	GlobalCDCTemp.DeleteDC();

	return CWinApp::ExitInstance();
}

CMultiDocTemplate *TCSuperSpiceApp::GetSuperSpiceDocTemplate(void)
{
	return PCMSuperSpiceDocTemplate;
}
/////////////////////////////////////////////////////////////////////////////

CMultiDocTemplate *TCSuperSpiceApp::GetWaveformDisplayDocTemplate(void)
{
	return PCMWaveformDisplayDocTemplate;
}

CMultiDocTemplate *TCSuperSpiceApp::GetSpiceNetListViewDocTemplate(void)
{
	return PCMSpiceNetListViewDocTemplate;
}

CMultiDocTemplate *TCSuperSpiceApp::GetSpiceOutputTextViewDocTemplate(void)
{
	return PCMSpiceOutputTextViewDocTemplate;
}

CMultiDocTemplate *TCSuperSpiceApp::GetSpiceSchematicSymbolViewDocTemplate(void)
{
	return PCMSuperSpiceSchematicSymbolViewDocTemplate;
}

CMultiDocTemplate *TCSuperSpiceApp::GetSpiceLibaryViewDocTemplate(void)
{
	return PCMSpiceLibaryViewDocTemplate;
}

CMultiDocTemplate *TCSuperSpiceApp::GetSpiceModelViewDocTemplate(void)
{
	return PCMSpiceLibaryViewDocTemplate;
}

CMultiDocTemplate *TCSuperSpiceApp::GetSpiceTextViewDocTemplate(void)
{
	return PCMSpiceTextViewDocTemplate;
}

CMultiDocTemplate *TCSuperSpiceApp::GetEngineErrorLogTemplate(void)
{
	return PCEngineErrorLogTemplate;
}

CMultiDocTemplate *TCSuperSpiceApp::GetModelTreeTemplate(void)
{
	return PCModelTreeTemplate;
}

CMultiDocTemplate *TCSuperSpiceApp::GetSymbolTreeTemplate(void)
{
	return PCSymbolTreeTemplate;
}

CMultiDocTemplate *TCSuperSpiceApp::GetFileTreeTemplate(void)
{
	return PCFileTreeTemplate;
}

CMultiDocTemplate *TCSuperSpiceApp::GetCircuitsTreeTemplate(void)
{
	return PCCircuitsTreeTemplate;
}

CMultiDocTemplate *TCSuperSpiceApp::GetSymbolPreviewTemplate(void)
{
	return PCSymbolPreviewTemplate;
}

CMultiDocTemplate *TCSuperSpiceApp::GetModelPreviewTemplate(void)
{
	return PCModelPreviewTemplate;
}

CMultiDocTemplate *TCSuperSpiceApp::GetSignalsTreeTemplate(void)
{
	return PCSignalsTemplate;
}

// CAboutDlg dialog used for App About
class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	CString	CEdiCopyright;
	CString	CMRegistrationId;
	CXTHyperLink	CMEmail;
	CXTHyperLink	CMURL;
	CXTHyperLink	CMKevinsEmail;

//	CString	CMEmail;
//	CString	CMURL;
//	CString	CMKevinsEmail;

	CString	CMCompany;
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	virtual BOOL OnInitDialog();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	CEdiCopyright = _T("");
	CMRegistrationId = _T("");
	CMCompany = _T("");
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	DDX_Text(pDX, IDC_EDIT_COPYRIGHT, CEdiCopyright);
	DDX_Text(pDX, IDC_EDIT_REGISTRATION_ID, CMRegistrationId);

	DDX_Control(pDX, IDC_TXT_EMAIL, CMEmail);
	DDX_Control(pDX, IDC_TXT_URL, CMURL);
	DDX_Control(pDX, IDC_TXT_EMAIL2, CMKevinsEmail);

//	DDX_Text(pDX, IDC_TXT_EMAIL, CMEmail);
//	DDX_Text(pDX, IDC_TXT_URL, CMURL);
//	DDX_Text(pDX, IDC_TXT_EMAIL2, CMKevinsEmail);

	DDX_Text(pDX, IDC_STATIC_COMAPNY, CMCompany);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

// App command to run the dialog
void TCSuperSpiceApp::OnAppAbout()
{
	CAboutDlg aboutDlg;

	aboutDlg.CEdiCopyright		= GCAuthorization.GetCopyRightNotice();

	if(GCAuthorization.m_build_type != E_FULL_RELEASE_GOLD && GCAuthorization.m_build_type != E_FULL_RELEASE_STUDENT_GOLD)
	{
		aboutDlg.CMRegistrationId	= GCAuthorization.GetRegistrationId();
	}
	else
	{
		aboutDlg.CMRegistrationId = "**********";
	}

//	aboutDlg.CEdiCopyright.LoadString(IDS_ABOUT_COPYRIGHT);

	aboutDlg.DoModal();
}
  

void TCSuperSpiceApp::OnHelpContact() 
{
	TCContactInfo CContactInfo;

	CString CFIleName = GetProgramDirectory();

	CContactInfo.DoModal();
}

/////////////////////////////////////////////////////////////////////////////
// TCSuperSpiceApp commands

CDocument* TCSuperSpiceApp::OpenDocumentFile(LPCTSTR lpszFileName) 
{

	//The framework will not load a file over an existing document !!
	// so it is closed first!!

	
	CString CExt = GetFileExtention(lpszFileName);

	CExt.MakeLower();

	DWORD handle = GetFileAttributes(lpszFileName);

	if(CExt == "" && (handle == FILE_ATTRIBUTE_DIRECTORY))
	{
		if(GCSuperSpiceDataBase.FindCircuitsFile(lpszFileName) < 0)
		{
			if(AfxMessageBox(IDS_QUERY_ADD_CIRCUIT_FOLDERS, MB_YESNO) == IDYES)
			{
				GCSuperSpiceDataBase.AddCircuitsFile(lpszFileName);

				GCWorkspaceTree.Refresh();
			}
			else return NULL;
		}

		return NULL;
	}

	if(CExt == "exe")
	{
		if(AfxMessageBox(IDS_QUERY_CHANGE_SPICE_ENGINE, MB_YESNO) == IDYES)
		{
			CString CText1 = ExtractFileName(lpszFileName);

			CString CText2 = AfxGetApp()->m_pszAppName;

			CText2 += ".exe";

			CText1.MakeLower();
			CText2.MakeLower();

			if(CText1 == CText2)
			{
				AfxMessageBox(IDS_SUPER_SPICE_NOT_ENGINE);

				return NULL;
			}

			GCSuperSpiceGlobalData.CProgramOptions.CSpiceEngine.CSpiceEngineName = lpszFileName;
		}

		return NULL;
	}

	if(CExt == "ssm")
	{
		if(GCSuperSpiceDataBase.FindSymbolFile(lpszFileName) < 0)
		if(AfxMessageBox(IDS_QUERY_ADD_SYMBOL_FILE, MB_YESNO) == IDYES)
		{
			BeginWaitCursor();
			GCSuperSpiceDataBase.AddSymbolFile(lpszFileName);
			EndWaitCursor();
		}

		return NULL;
	}

	if(CExt == "scl")
	{
		GCSuperSpiceClipboard.Load(lpszFileName);

		if(!PCSuperSpiceDocLastFocused) return NULL;
		if(!PCSuperSpiceViewLastFocused) return NULL;

		PCSuperSpiceDocLastFocused->OnViewEditPaste(PCSuperSpiceViewLastFocused, PCSuperSpiceViewLastFocused->CSuperSpiceViewData.CLastMousePosition);

		PCSuperSpiceViewLastFocused->CSuperSpiceViewData.system_state = E_GRAPHICS_MANAGER_STATE_GOT_CLIPBOARD;

		return NULL;
	}

	if(CExt != "sss"  &&  CExt != "spw" && CExt != "ssg" && CExt != "srp" && CExt != "sym" &&
	   CExt != "lib" && CExt != "mod" && CExt != "sub")
	{
		return PCMSpiceTextViewDocTemplate->OpenDocumentFile(lpszFileName);
	}

	POSITION position = PCMSuperSpiceDocTemplate->GetFirstDocPosition();

	while(position != NULL)
	{
		CDocument* PDoc = PCMSuperSpiceDocTemplate->GetNextDoc(position);
		
		if(PDoc)
		{
			CString CFileName = PDoc->GetPathName();

			if(CFileName == lpszFileName)
			{
				POSITION pos = PDoc->GetFirstViewPosition();

				while (pos != NULL)
				{
					CView *PCView = (TCSuperSpiceView *) PDoc->GetNextView(pos);
					
					if(PCView) PCView->GetParent()->DestroyWindow();
				}
			}
		}
	}

	TCSuperSpiceDoc *PCSuperSpiceTopLevelDoc = NULL;
	TCSymbolEditorDoc   *PCEditorDocument;
	TCOutputWaveformDoc *PCOutputWaveformDoc;

	if(CExt == "sym")// if schematic open, connect symbol doc to it
	{	
		PCSuperSpiceTopLevelDoc = GetATopLevelDocument();

		PCEditorDocument = (TCSymbolEditorDoc*)CWinApp::OpenDocumentFile(lpszFileName);

		if(!PCSuperSpiceTopLevelDoc) return PCEditorDocument;

		if(PCEditorDocument) 
		{
			PCSuperSpiceTopLevelDoc->AddSymbolEditorDoc(PCEditorDocument, lpszFileName);
		
			PCEditorDocument->PCParentSuperSpiceDoc = PCSuperSpiceTopLevelDoc;
		}
		return PCEditorDocument;
	}

	if(CExt == "ssg")// if schematic open, connect doc to it
	{	
		PCSuperSpiceTopLevelDoc = GetATopLevelDocument();

		PCOutputWaveformDoc = (TCOutputWaveformDoc*)CWinApp::OpenDocumentFile(lpszFileName);

		if(!PCSuperSpiceTopLevelDoc) return PCOutputWaveformDoc;

		if(PCOutputWaveformDoc) 
		{
			PCSuperSpiceTopLevelDoc->AddGraphOutputDoc(PCOutputWaveformDoc, lpszFileName);
		
			PCOutputWaveformDoc->PCParentSuperSpiceDoc = PCSuperSpiceTopLevelDoc;
		}
		return PCOutputWaveformDoc;
	}

	if(CExt == "lib" || CExt == "mod" || CExt == "sub")// if schematic open, connect doc to it
	{	
		if(GCSuperSpiceDataBase.FindModelFile(lpszFileName) < 0)
		if(AfxMessageBox(IDS_QUERY_ADDMODEL_FILE, MB_YESNO) == IDYES)
		{
			GCSuperSpiceDataBase.AddModelFile(lpszFileName);

			return NULL;// Add but dont display
		}

		TCSuperSpiceTextDoc *PCSuperSpiceTextDoc;

		PCSuperSpiceTopLevelDoc = GetATopLevelDocument();

		PCSuperSpiceTextDoc = (TCSuperSpiceTextDoc *) PCMSpiceTextViewDocTemplate->OpenDocumentFile(lpszFileName);

		if(PCSuperSpiceTextDoc) 
		{
			PCSuperSpiceTextDoc->PCParentSuperSpiceDoc = PCSuperSpiceTopLevelDoc;

			if(PCSuperSpiceTopLevelDoc)
				PCSuperSpiceTopLevelDoc->AddModelLibaryDoc(PCSuperSpiceTextDoc, lpszFileName);
		}

		return PCSuperSpiceTextDoc;
	}

	PCSuperSpiceTopLevelDoc = (TCSuperSpiceDoc *) CWinApp::OpenDocumentFile(lpszFileName);// not ness. a top level

	if(!PCSuperSpiceTopLevelDoc) return NULL;

	GCWorkspaceTree.RefreshSchematicFiles();

	return PCSuperSpiceTopLevelDoc;
}


TCSuperSpiceDoc *TCSuperSpiceApp::GetATopLevelDocument(void)
{
	TCSuperSpiceDoc *PCSuperSpiceDoc = NULL;
	CDocTemplate *PCDocTemplate;
	CDocument	*PCDocument;
	POSITION DocTemplatePos = GetFirstDocTemplatePosition();
	POSITION DocPos;
	
	while(DocTemplatePos)// get top level schematics
	{
		PCDocTemplate = GetNextDocTemplate(DocTemplatePos);

		DocPos = PCDocTemplate->GetFirstDocPosition();

		while(DocPos)
		{
			PCDocument = PCDocTemplate->GetNextDoc(DocPos);

			if(PCDocument->IsKindOf(RUNTIME_CLASS(TCSuperSpiceDoc)))
			{
				PCSuperSpiceDoc = (TCSuperSpiceDoc *)PCDocument;
				
				if(!PCSuperSpiceDoc->top_level) continue;

				return PCSuperSpiceDoc;

				break;
			}
		}
	}

	return NULL;
}

void TCSuperSpiceApp::OnFileOpen() 
{
	//Overide the framework to set last directorys used

	ASSERT(m_pDocManager != NULL);

	if(GCSuperSpiceGlobalData.CGeneric.CLastOpenFileDlgName == "") 
	{
		GCSuperSpiceGlobalData.CGeneric.CLastOpenFileDlgName = GetInitDirectory();

		GCSuperSpiceGlobalData.CGeneric.CLastOpenFileDlgName += "*.sss";
	}

	CString CFileName;
	CString CPromptString;

	CPromptString.LoadString(IDR_FILE_OPEN_DIALOG);

	CString CExt = GetFileExtention(GCSuperSpiceGlobalData.CGeneric.CLastOpenFileDlgName);

	CFileDialog	CLoadFileDialog(true, CExt, GCSuperSpiceGlobalData.CGeneric.CLastOpenFileDlgName, 0, CPromptString);

	if(CLoadFileDialog.DoModal() != IDOK) return;

	CFileName = CLoadFileDialog.GetPathName();

	if(CFileName == "") return;

	OpenDocumentFile(CFileName);
	
	CFileName = ExtractPathName(CFileName);

	CFileName += "*.sss";

	GCSuperSpiceGlobalData.CGeneric.CLastOpenFileDlgName = CFileName;
}

void TCSuperSpiceApp::OnFileOpenExamples()
{
	CString CFileName;
	CString CPromptString;
	CString CExamplesDir;

	CPromptString.LoadString(IDR_FILE_OPEN_DIALOG);

	CExamplesDir = GetExamplesDir();

	CFileDialog	CLoadFileDialog(true, "sss", CExamplesDir, 0, CPromptString);

	if(CLoadFileDialog.DoModal() != IDOK) return;

	CFileName = CLoadFileDialog.GetPathName();

	if(CFileName == "") return;

	OpenDocumentFile(CFileName);
	
	CFileName = ExtractPathName(CFileName);

	CFileName += "*.sss";

	GCSuperSpiceGlobalData.CGeneric.CLastOpenFileDlgName = CFileName;
}

void TCSuperSpiceApp::SetupPrinter(void)
{
	//This is shamlesly copied from ms help
	// setup landscape as default;

    // Get default printer settings.
    PRINTDLG   PrinterDefaults;

    PrinterDefaults.lStructSize = (DWORD) sizeof(PRINTDLG);

    if(GetPrinterDeviceDefaults(&PrinterDefaults))
    {
        // Lock memory handle.
        DEVMODE FAR* pDevMode = (DEVMODE FAR*)::GlobalLock(m_hDevMode);
        LPDEVNAMES	lpDevNames;
        LPTSTR		lpszDriverName, lpszDeviceName, lpszPortName;
        HANDLE		hPrinter;

        if(pDevMode)
        {
            // Change printer settings in here.
            pDevMode->dmOrientation = DMORIENT_LANDSCAPE;
           
			lpDevNames = (LPDEVNAMES)GlobalLock(PrinterDefaults.hDevNames);
			lpszDriverName = (LPTSTR )lpDevNames + lpDevNames->wDriverOffset;
			lpszDeviceName = (LPTSTR )lpDevNames + lpDevNames->wDeviceOffset;
			lpszPortName   = (LPTSTR )lpDevNames + lpDevNames->wOutputOffset;

			OpenPrinter(lpszDeviceName, &hPrinter, NULL);

			DocumentProperties(NULL,hPrinter,lpszDeviceName,pDevMode, pDevMode, DM_IN_BUFFER|DM_OUT_BUFFER);

       // Sync the pDevMode.
       // See SDK help for DocumentProperties for more info.
			ClosePrinter(hPrinter);
			::GlobalUnlock(m_hDevNames);
			::GlobalUnlock(m_hDevMode);
       }
    }

	GCSuperSpiceGlobalData.CPrinterData.SetPrinterPageData();
}

void TCSuperSpiceApp::DrawAllSchematics(void)
{
	CDocTemplate *PCDocTemplate;
	CDocument	*PCDocument;
	POSITION DocTemplatePos = GetFirstDocTemplatePosition();
	POSITION DocPos;
	TCSuperSpiceView *PCViewInList = NULL;
	TCOutputWaveformView *PCViewInListG = NULL;
	TCSchematicManager *PCSchematicManager;
	TCOutputWaveformDoc *PCOutputWaveformDoc;

	TCSuperSpiceDoc *PCSuperSpiceDoc;

	while(DocTemplatePos)
	{
		PCDocTemplate = GetNextDocTemplate(DocTemplatePos);

		DocPos = PCDocTemplate->GetFirstDocPosition();

		while(DocPos)
		{
			PCDocument = PCDocTemplate->GetNextDoc(DocPos);

			if(PCDocument->IsKindOf(RUNTIME_CLASS(TCSuperSpiceDoc)))
			{
				PCSuperSpiceDoc = (TCSuperSpiceDoc *)PCDocument;
				
				POSITION pos = PCSuperSpiceDoc->GetFirstViewPosition();

				while (pos != NULL)
				{
					PCViewInList = (TCSuperSpiceView *)PCSuperSpiceDoc->GetNextView(pos);

					PCSchematicManager = PCViewInList->GetSchematicManager();

					if(!PCSchematicManager) continue;
				
					PCSchematicManager->DrawAll();
				}
			}
			else if(PCDocument->IsKindOf(RUNTIME_CLASS(TCOutputWaveformDoc)))
			{
				PCOutputWaveformDoc = (TCOutputWaveformDoc *)PCDocument;
				
				POSITION pos = PCOutputWaveformDoc->GetFirstViewPosition();

				while (pos != NULL)
				{
					PCViewInListG = (TCOutputWaveformView *)PCOutputWaveformDoc->GetNextView(pos);

					PCSchematicManager = PCViewInListG->CSuperSpiceViewData.PCMSchematicManager;

					if(!PCSchematicManager) continue;
				
					PCSchematicManager->DrawAll();
				}
			}
		}
	}
}


////////////////////////////////////////////////////
BOOL CAboutDlg::OnInitDialog() 
{
	CString CText;

	CText = GetRandomNumberString() + " " + " About " + GetOEMProgramName();

	SetWindowText(CText);

	CMCompany = GetCompanyName();

	CDialog::OnInitDialog();
	
	CMURL.SetWindowText(GetWebSiteName());

	CMURL.SetURL(_T(GetWebSiteName()));

	CMEmail.SetWindowText(GetSupportEMailName());

	CMEmail.SetURL(_T("mailto:" + GetSupportEMailName()));

	CMKevinsEmail.SetWindowText("kan@anasoft.co.uk");

	CMKevinsEmail.SetURL(_T("mailto:kan@anasoft.co.uk"));

	return TRUE; 
}


void TCSuperSpiceApp::OnFilePrintSetup() 
{
	CWinApp::OnFilePrintSetup();

	GCSuperSpiceGlobalData.CPrinterData.SetPrinterPageData();

	DrawAllSchematics();
}

int TCSuperSpiceApp::Run() 
{	
	return CWinApp::Run();
}

BOOL TCSuperSpiceApp::OnIdle(LONG lCount) 
{	
	CWinApp::OnIdle(lCount);

	return 0;
}

void TCSuperSpiceApp::AddToRecentFileList(LPCTSTR lpszPathName) 
{
	// TODO: Add your specialized code here and/or call the base class
	
	CString CExt = GetFileExtention(lpszPathName);

	CExt.MakeLower();

	if(CExt != "sss") return;

	CWinApp::AddToRecentFileList(lpszPathName);

}
  
void TCSuperSpiceApp::Help(CString CTopicFileName)
{
	::HtmlHelp(GetDesktopWindow(), CTopicFileName, HH_DISPLAY_TOPIC, NULL);
} 

void TCSuperSpiceApp::WinHelpInternal(DWORD_PTR dwData, UINT nCmd) 
{
	// Overide the default 
	
//	CWinApp::WinHelpInternal(dwData, HELP_CONTENTS);

	nCmd; 

	CString CHelpFileName = GetProgramDirectory();

	CHelpFileName += GetHelpFileName();

	CHelpFileName += GetHTMLTopicName(dwData);

	Help(CHelpFileName);
}

void TCSuperSpiceApp::DialogHelp(DWORD dwData)
{
	CString CHelpFileName = GetProgramDirectory();

	CHelpFileName += GetHelpFileName();

	CHelpFileName += GetHTMLTopicName(dwData);

	Help(CHelpFileName);
}

CString GetHTMLTopicName(DWORD dwData)
{
	CString CTopicName = "::/html/";
	
	dwData -= HID_BASE_RESOURCE;

	switch(dwData)
	{
		case IDD_PAGE_PROPERTIES:			return  CTopicName + "afxc36b7" + ".htm";                     
		case IDD_GRID_SETTINGS:				return  CTopicName + "afxc2ks3" + ".htm";                    
		case IDD_PROPPAGE_COLORS:			return  CTopicName + "afxc019v" + ".htm";                  
		case IDD_SELECT_FONT_DLG:			return  CTopicName + "afxc05wn" + ".htm";  
			
		case IDD_PROPPAGE_AC_ANALYSIS:		return  CTopicName + "afxc63sj" + ".htm";               
		case IDD_PROPPAGE_TEMPERATURE:		return  CTopicName + "afxc812d" + ".htm";            
		case IDD_PROPPAGE_SENSITIVITY:		return  CTopicName + "afxc886x" + ".htm"; 
		case IDD_PROPPAGE_BERKLY_OPTION  :	return  CTopicName + "afxc059q" + ".htm";                
		case IDD_PROPPAGE_DC_ANALYSIS      :return  CTopicName + "afxc0fxv" + ".htm";              
		case IDD_PROPPAGE_TRANSIENT_ANALYSIS   :return  CTopicName + "afxc1k1f" + ".htm";          
		case IDD_PROPPAGE_PARAMETER_ANALYSIS :return  CTopicName + "afxc4hf7" + ".htm";           
		case IDD_PROPPAGE_POLE_ZERO      :return  CTopicName + "afxc7jsf" + ".htm";                
		case IDD_PROPPAGE_DISTORTION       :return  CTopicName + "afxc7bxq" + ".htm";              
		case IDD_PROPPAGE_NOISE_ANALYSIS1:return  CTopicName + "afxc0a29" + ".htm"; 	
		case IDD_DIALOG_POLE_ZERO          :return  CTopicName + "afxc7jsf" + ".htm"; 
		case IDD_DIALOG_OUTPUT_SELECT      :return  CTopicName + "afxc4uus" + ".htm"; 
		case IDD_PROPPAGE_RERUN        :return  CTopicName + "afxc0wxa" + ".htm";                   
 //		case IDD_PROPPAGE_STATISYICAL_ANALYSIS:return  CTopicName + "afx" + ".htm";          

		case IDD_PROGRAM_OPTIONS_PAGE2:       return  CTopicName + "afxc9s36" + ".htm"; 
		case IDD_PROGRAM_OPTIONS_PAGE1:        return  CTopicName + "afxc9s35" + ".htm"; 
			
		case IDD_PROPP_WAVEFORM_INFO    :return  CTopicName + "afxc1ii7" + ".htm";                 
		case IDD_PROPP_WAVEFORM_SIGNALS   :return  CTopicName + "afxc7kkz" + ".htm";               
		case IDD_PROPP_WAVEFORM_GRAPH    :return  CTopicName + "afxc9qzs" + ".htm";                
		case IDD_WAVEFORM_LABELS         :return  CTopicName + "afxc67ar" + ".htm";   
		case IDD_PROPP_WAVEFORM_CALCULATOR     :return  CTopicName + "afxc8oj6" + ".htm";          

		case IDD_SPICE_GENERATOR_DC_VALUES     :return  CTopicName + "afxc6sc3" + ".htm";          
		case IDD_SPICE_GENERATOR_SINE_VALUES     :return  CTopicName + "afxc6sc3" + ".htm";        
		case IDD_SPICE_GENERATOR_PULSE_VALUES     :return  CTopicName + "afxc6sc3" + ".htm";       
		case IDD_SPICE_GENERATOR_EXP_VALUES       :return  CTopicName + "afxc6sc3" + ".htm";       
		case IDD_SPICE_GENERATOR_PWL_VALUES       :return  CTopicName + "afxc6sc3" + ".htm";       
		case IDD_SPICE_GENERATOR_SFFM_VALUES      :return  CTopicName + "afxc6sc3" + ".htm"; 

		case IDD_DIALOG_CONNECTOR           :return  CTopicName + "afxc4k50" + ".htm";             

		case IDD_PROP_MODEL_LIB    :return  CTopicName + "afxc0qhu" + ".htm";  
		case IDD_PROP_SYMBOL_LIB    :return  CTopicName + "afxc6d2a" + ".htm";              
		case IDD_COMPONENT_LIBARY      :return  CTopicName + "afx6d2a" + ".htm";                   

		case IDD_DIALOG_CONTACT_INFO      :return  CTopicName + "afxc9vp0" + ".htm";               
                  
  		case IDD_PROPPAGE2_FANTASTIC_FILTER     :return  CTopicName + "afx03le" + ".htm";         
		case IDD_PROPPAGE1_FANTASTIC_FILTER    :return  CTopicName + "afxc2drm" + ".htm";          
                    	
		case IDD_WIRE_LABLE    :return  CTopicName + "afx14vn" + ".htm";                          
		case IDD_RESISTOR_LABELS             :return  CTopicName + "afxc3xmb" + ".htm";            
		case IDD_CAPACITOR_LABELS           :return  CTopicName + "afxc74z7" + ".htm";             
		case IDD_INDUCTOR_LABELS        :return  CTopicName + "afxc14oj" + ".htm";  
		case IDD_DIODE_LABELS         :return  CTopicName + "afxc1o1f" + ".htm";                   
		case IDD_SPICE_COMPONENT_LABELS:        return  CTopicName + "afxc1ldf" + ".htm";         
		case IDD_LAPLACE_LABELS                 :return  CTopicName + "afxc5otv" + ".htm";
		case IDD_VARIABLE_RESISTOR_LABELS       :return  CTopicName + "afxc6voz" + ".htm";
		case IDD_PCB_COMPONENT_LABELS           :return  CTopicName + "afxc9p0z" + ".htm";         
		case IDD_VALUE_LABELS     :return  CTopicName + "afxc9xf7" + ".htm";                       
		case IDD_TRANSFORMER_LABELS    :return  CTopicName + "afxc3l9v" + ".htm";                  
		case IDD_SUBCIRCUIT_LABELS     :return  CTopicName + "afxc9xf7" + ".htm";                  
		case IDD_TRANSMISSION_LINE_LABELS:return  CTopicName + "afxc6pv7" + ".htm";                
		case IDD_SWITCH_LABELS          :return  CTopicName + "afxc2sc3" + ".htm";                 
			
		case IDD_SPICE_COMPONENT_PINS:          return  CTopicName + "afxc36gj" + ".htm";         
		case IDD_SPICE_COMPONENT_2PINS        :return  CTopicName + "afxc7jlf" + ".htm";           
		case IDD_COMPONENT_PIN_LABELS:return  CTopicName + "afx36gj" + ".htm";  
		case IDD_SPICE_COMPONENT_PINS_LARGE     :return  CTopicName + "afxc5mzp" + ".htm";         
		case IDD_PIN_LABLE       :return  CTopicName + "afxafxc7jlf" + ".htm";                        

		case IDD_SPICE_COMPONENT_MODEL:         return  CTopicName + "afxc7ing" + ".htm";
		case IDD_SPICE_COMPONENT_BASIC_MODEL     :return  CTopicName + "afxc7ing" + ".htm";        
		case IDD_SPICE_COMPONENT_MODEL_SUB_SMALL  :return  CTopicName + "Subckts" + ".htm";
		case IDD_DIALOG_CREATE_SYMBOL:				return  CTopicName + "CreateSymbol" + ".htm";
		case IDD_DIALOG_CREATE_SYMBOL_FOR_MODELS:	return  CTopicName + "CreateSymbol" + ".htm";
		case IDD_DIALOG_CIRCUIT_PRPERTIES:	return  CTopicName + "Circuits" + ".htm";
		
		case IDD_PROPP_ANALYSIS_TRANSIENT:	return  CTopicName + "PulseAnalysis" + ".htm";
		case IDD_PROPP_ANALYSIS_TRAN_POWER:	return  CTopicName + "TransientPower" + ".htm";
		case IDD_PROPP_ANALYSIS_TRAN_RMS:	return  CTopicName + "TransientAverages" + ".htm";


		case IDD_COMPONENT_PINS_SYM_EDITOR:
		case IDD_DIALOG_SYM_ED_PIN_PROP:	return  CTopicName + "afxc0mgi" + ".htm";
		case IDD_DIALOG_SYMBOL_DATA:		return  CTopicName + "SymbolSchematic" + ".htm";

		case IDD_DIALOGTEST_POINTS:			return  CTopicName + "afxc6hv7" + ".htm";
		case IDD_WIRE_PROPERTIES:			return  CTopicName + "DeviceDesigner" + ".htm";//to do
		case IDD_DIALOG_DESIGNER:			return  CTopicName + "DeviceDesigner" + ".htm";//to do

		case IDD_SUBCIRCUIT_LARGE_LABELS:	return  CTopicName + "afxc9xf7" + ".htm";
		case IDD_URC_LABELS:				return  CTopicName + "URCResister" + ".htm";
		case IDD_SPICE_BIPOLAR_LABELS:		return  CTopicName + "BipolarLabels"  + ".htm";
		case IDD_SPICE_PARAMETER_MODEL:		return  CTopicName + "SchematicParameters"  + ".htm";
		case IDD_CONTROLLED_SOURCE_LABELS:	return  CTopicName + "ControlledSources"  + ".htm";

		default: 
		{
			int oem_id = GetOEMID();

			switch(oem_id)
			{
				case E_ANASOFT_LTD:			return CTopicName + "afxc0wc8" + ".htm";
				case E_INTELLISENSE_CORP:	return CTopicName + "MEMSystemMain.htm"; 

				default: return   CTopicName + "afxc0wc8" + ".htm";
			}
		}
	}
}

bool TCSuperSpiceApp::SendSuperSpiceMessage(UINT h_msg, WPARAM wParam, LPARAM lParam)
{
	wParam, lParam;

	if(!h_msg) return false;

	PostMessage(HWND_BROADCAST, h_msg, wParam, lParam);

	return true;
}

void TCSuperSpiceApp::ProccessSuperSpiceXSpiceMessage(MSG* pMsg)
{
	switch(pMsg->wParam)
	{
		case E_SS_XS_MSG_NULL: return;

		case E_XS_TO_SS_MSG_ACK: ((TCSuperSpiceMainFrame*)m_pMainWnd)->SetXSpiceStatusText("XSpice ack"); break;

		case E_XS_TO_SS_MSG_EXITED:  GCGeneralReportsTab.DisplayMessage(IDS_EER_STATUS, "XSpice exited.", -1);
									 ((TCSuperSpiceMainFrame*)m_pMainWnd)->SetXSpiceStatusText(CGlobalXSpiceMessage); break;

		case E_XS_TO_SS_MSG_DC_DATA: ProccessXSpiceDCData(pMsg);	break;
		case E_XS_TO_SS_MSG_AC_DATA: ProccessXSpiceACData(pMsg);	break;
		case E_XS_TO_SS_MSG_NOISE:	ProccessXSpiceNoiseData(pMsg);	break;
		case E_XS_TO_SS_MSG_OP:		ProccessXSpiceOPData(pMsg);		break;
		case E_XS_TO_SS_MSG_TRAN_DATA: ProccessXSpiceTranData(pMsg); break;
		case E_XS_TO_SS_MSG_HEADER_READY: ProccessXSpiceHeaderReady(pMsg);break;

		case E_XS_TO_SS_MSG_START_MSG:		SSMsgStart(pMsg->lParam);break;
		case E_XS_TO_SS_MSG_CONTINUE_MSG:	SSMsgContinue(pMsg->lParam);break;
		case E_XS_TO_SS_MSG_END_MSG:		SSMsgEnd(pMsg);break;
		case E_XS_TO_SS_MSG_SET_REAL_TIME_TYPE: m_real_time_run_type = pMsg->lParam;
		
	};
}

void TCSuperSpiceApp::SendXSpiceSetMsgCounts(UINT h_msg, TCXSpiceProgressData &CXSpiceProgressData)
{
	SendXSpiceSetDCMsgCount(h_msg, CXSpiceProgressData.dc_msg_count);
	SendXSpiceSetACMsgCount(h_msg, CXSpiceProgressData.ac_msg_count);
	SendXSpiceSetTRANMsgCount(h_msg, CXSpiceProgressData.tran_msg_count);
	SendXSpiceSetSimSpeed(h_msg, CXSpiceProgressData.simulation_wait_time);
}

void TCSuperSpiceApp::SendXSpiceSetSimSpeed(UINT h_msg, int wait)
{
	if(wait < 1) wait = 0;

	SendSuperSpiceMessage(h_msg, E_SS_TO_XS_MSG_SET_SIM_SPEED, wait);
}

void TCSuperSpiceApp::SendXSpiceSetDCMsgCount(UINT h_msg, int count)
{
	if(count < 1) count = 100;

	SendSuperSpiceMessage(h_msg, E_SS_TO_XS_MSG_SET_DC_MSG_COUNT, count);
}

void TCSuperSpiceApp::SendXSpiceSetACMsgCount(UINT h_msg, int count)
{
	if(count < 1) count = 100;

	SendSuperSpiceMessage(h_msg, E_SS_TO_XS_MSG_SET_AC_MSG_COUNT, count);
}

void TCSuperSpiceApp::SendXSpiceSetTRANMsgCount(UINT h_msg, int count)
{
	if(count < 1) count = 100;

	SendSuperSpiceMessage(h_msg, E_SS_TO_XS_MSG_SET_TRAN_MSG_COUNT, count);
}

void TCSuperSpiceApp::SendSuperSpiceAck(UINT h_msg)
{
	SendSuperSpiceMessage(h_msg, E_SS_TO_XS_MSG_ACK, 0);
}

void TCSuperSpiceApp::SendPauseCommand(UINT h_msg)
{
	SendSuperSpiceMessage(h_msg, E_SS_TO_XS_MSG_SET_PAUSE, 0);
}

void TCSuperSpiceApp::SendContinueCommand(UINT h_msg)
{
	SendSuperSpiceMessage(h_msg, E_SS_TO_XS_MSG_SET_CONTINUE, 0);
}

void TCSuperSpiceApp::SendEnableMarchingWaveforms(UINT h_msg, int data)
{
	SendSuperSpiceMessage(h_msg, E_SS_TO_XS_MSG_ENABLE_MARCHING_WAVEFORMS, data);
}

void TCSuperSpiceApp::SendXSpiceQuitMessage(UINT h_msg)
{
	SendSuperSpiceMessage(h_msg, E_SS_TO_XS_MSG_EXIT, 0);
}

void TCSuperSpiceApp::SendXSpiceMsg(UINT h_msg, int cmd, char *msg, int msg_size)
{
	if(!msg) return;
	if(msg_size < 1) return;

	int data;
	int counter = 0;

	msg_size += sizeof(DWORD);// add command field

	SendSuperSpiceMessage(h_msg, E_SS_TO_XS_MSG_START_MSG, msg_size);
	SendSuperSpiceMessage(h_msg, E_SS_TO_XS_MSG_CONTINUE_MSG, cmd);

	msg_size = msg_size/sizeof(DWORD);

	for(int p = 0; p < msg_size; p++)
	{
		memcpy(&data, &msg[counter], sizeof(DWORD)); 

		SendSuperSpiceMessage(h_msg, E_SS_TO_XS_MSG_CONTINUE_MSG, data);

		counter += sizeof(DWORD);
	}

	SendSuperSpiceMessage(h_msg, E_SS_TO_XS_MSG_END_MSG, 0);
}

void TCSuperSpiceApp::ModifyComponentValue(UINT h_msg, CString CRefDes, float value, int type)
{
	char *p_buff;
	int length, size;

	length = CRefDes.GetLength() + 1;

	size = length + sizeof(DWORD) + sizeof(DWORD);

	size = 4*((size/4) + 1);// round to dword size. worst case is extra 3 bytes

	p_buff = new char[size];

	if(!p_buff) return;

	memcpy(p_buff, CRefDes.GetBuffer(length), length);
	memcpy(&p_buff[length], &value, sizeof(DWORD));
	memcpy(&p_buff[length + sizeof(DWORD)], &type, sizeof(DWORD));

	SendXSpiceMsg(h_msg, E_SS_XS_DATA_MSG_MODIFY_COMPONENT_VALUE, p_buff, size);

	delete p_buff;
}

void TCSuperSpiceApp::SSMsgStart(int data)
{
	msg_counter = 0;

	if(!(data < 1024)) data = 1023;

	msg_size = data;
}

void TCSuperSpiceApp::SSMsgContinue(int data)
{
	if(!pm_msg_data) return;
	if(!(msg_counter < msg_size)) return;

	memcpy(&pm_msg_data[msg_counter], &data, sizeof(DWORD)); 
	
	msg_counter += sizeof(DWORD);
}

void TCSuperSpiceApp::SSMsgEnd(MSG* pMsg)
{
	if(!pm_msg_data) return;

	int  cmd;

	memcpy(&cmd, pm_msg_data, sizeof(DWORD));// first dword is command

	switch(cmd)
	{
		case E_XS_SX_DATA_MSG_SIGNAL_DATA:  XSRxWaveformSignal(pMsg); return;
	}
}

void TCSuperSpiceApp::XSRxWaveformSignal(MSG* pMsg)
{
	//Rx realtime data
	// Signal name
	// X value
	//Y value
	//index

	if(!pm_msg_data) return;

	char *p_data = &pm_msg_data[sizeof(DWORD)];// first word is cmd
	float x_value, y_value_r, y_value_i;
	int index;

	CString CSignalName = p_data;

	int length = CSignalName.GetLength() + 1;

	memcpy(&x_value, &p_data[length], sizeof(DWORD));			 
	memcpy(&y_value_r, &p_data[length + sizeof(DWORD)], sizeof(DWORD)); 
	memcpy(&y_value_i, &p_data[length + sizeof(DWORD) + sizeof(DWORD)], sizeof(DWORD)); 
	memcpy(&index, &p_data[length + sizeof(DWORD)+ sizeof(DWORD) + sizeof(DWORD)], sizeof(DWORD));

	//Now send signal data to schematic/waveform display
	TCSuperSpiceDoc *PCSuperSpiceDoc = GetDocumentForMsg(pMsg);

	if(!PCSuperSpiceDoc) return;

	TCRealTimeData CRealTimeData;

	CRealTimeData.CSignalName	= CSignalName;
	CRealTimeData.signal_index	= index;
	CRealTimeData.type			= m_real_time_run_type;
	CRealTimeData.x				= x_value;
	CRealTimeData.yr			= y_value_r;
	CRealTimeData.yi			= y_value_i;

	PCSuperSpiceDoc->XSRxWaveformSignal(CRealTimeData);
}

void TCSuperSpiceApp::ProccessXSpiceTranData(MSG* pMsg)
{
	CString CText, CData;
	float   data;
	
	memcpy(&data, &pMsg->lParam, sizeof(unsigned int));

	CData = FloatToSpiceMKSString((double)data);

	CText =  "Transient simulation time: " + CData + " ...";

	((TCSuperSpiceMainFrame*)m_pMainWnd)->SetXSpiceStatusText(CText);

}

void TCSuperSpiceApp::ProccessXSpiceOPData(MSG* pMsg)
{
	CString CText, CData;
	float   data;
	
	memcpy(&data, &pMsg->lParam, sizeof(unsigned int));

	CData = FloatToSpiceMKSString((double)data);

	CText =  "Operating Point Value: " + CData + " ...";

	((TCSuperSpiceMainFrame*)m_pMainWnd)->SetXSpiceStatusText(CText);

}
void TCSuperSpiceApp::ProccessXSpiceNoiseData(MSG* pMsg)
{
	CString CText, CData;
	float   data;
	
	memcpy(&data, &pMsg->lParam, sizeof(unsigned int));

	CData = FloatToSpiceMKSString((double)data);

	CText =  "Noise Analysis Value: " + CData + " ...";

	((TCSuperSpiceMainFrame*)m_pMainWnd)->SetXSpiceStatusText(CText);

}

void TCSuperSpiceApp::ProccessXSpiceACData(MSG* pMsg)
{
	CString CText, CData;
	float   data;
	
	memcpy(&data, &pMsg->lParam, sizeof(unsigned int));

	CData = FloatToSpiceMKSString((double)data);

	CText =  "AC Simulation Frequency: " + CData + " ...";

	((TCSuperSpiceMainFrame*)m_pMainWnd)->SetXSpiceStatusText(CText);

}

void TCSuperSpiceApp::ProccessXSpiceDCData(MSG* pMsg)
{
	CString CText, CData;
	float   data;
	
	memcpy(&data, &pMsg->lParam, sizeof(unsigned int));

	CData = FloatToSpiceMKSString((double)data);

	CText =  "DC Sweep Value: " + CData + " ...";

	((TCSuperSpiceMainFrame*)m_pMainWnd)->SetXSpiceStatusText(CText);

}

TCSuperSpiceDoc *TCSuperSpiceApp::GetDocumentForMsg(MSG* pMsg)
{
	CDocTemplate *PCDocTemplate;
	CDocument	*PCDocument;
	POSITION DocTemplatePos = GetFirstDocTemplatePosition();
	POSITION DocPos;

	TCSuperSpiceDoc *PCSuperSpiceDoc;

	while(DocTemplatePos)// get top level schematics, chech the msg handle 
	{
		PCDocTemplate = GetNextDocTemplate(DocTemplatePos);

		DocPos = PCDocTemplate->GetFirstDocPosition();

		while(DocPos)
		{
			PCDocument = PCDocTemplate->GetNextDoc(DocPos);

			if(PCDocument->IsKindOf(RUNTIME_CLASS(TCSuperSpiceDoc)))
			{
				PCSuperSpiceDoc = (TCSuperSpiceDoc *)PCDocument;
				
				if(!PCSuperSpiceDoc->top_level) continue;

				if(pMsg->message != PCSuperSpiceDoc->h_msg)  continue;

				return PCSuperSpiceDoc;
			}
		}
	}

	return NULL;
}

void TCSuperSpiceApp::ProccessXSpiceHeaderReady(MSG* pMsg)
{
	TCSuperSpiceDoc *PCSuperSpiceDoc = GetDocumentForMsg(pMsg);

	if(!PCSuperSpiceDoc) return;

	int data;

	memcpy(&data, &pMsg->lParam, sizeof(unsigned int));

	PCSuperSpiceDoc->MarchingWaveformAddHeader(data);
}

CString GetWebSiteName()
{
	CString CText = "http://www.anasoft.co.uk";

	int oem_id = GetOEMID();

	if(!oem_id) return CText;

	switch(oem_id)
	{
		case E_ANASOFT_LTD:			return CText;
		case E_INTELLISENSE_CORP:	CText = "http://www.intellisensesoftware.com"; break;

		default: return CText;
	}

	return CText;
}

CString GetKevinsTutorialWebSiteName(void)
{
	CString CText = "http://www.kevinaylward.co.uk/ee/index.html";

	return CText;
}

CString GetSupportEMailName(void)
{
	CString CText = "spice@anasoft.co.uk";

	int oem_id = GetOEMID();

	if(!oem_id) return CText;

	switch(oem_id)
	{
		case E_ANASOFT_LTD:			return CText;
		case E_INTELLISENSE_CORP:	CText = "info@intellisensesoftware.com"; break;

		default: return CText;
	}

	return CText;
}

CString GetContactEMailName(void)
{
	CString CText = "spice@anasoft.co.uk";

	int oem_id = GetOEMID();

	if(!oem_id) return CText;

	switch(oem_id)
	{
		case E_ANASOFT_LTD:			return CText;
		case E_INTELLISENSE_CORP:	CText = "info@intellisensesoftware.com "; break;

		default: return CText;
	}

	return CText;
}

CString GetCompanyName(void)
{
	CString CText = "AnaSoft Ltd, England UK";

	int oem_id = GetOEMID();

	if(!oem_id) return CText;	
	
	switch(oem_id)
	{
		case E_ANASOFT_LTD:			return CText;
		case E_INTELLISENSE_CORP:	CText = "IntelliSense Software Corporation"; break;

		default: return CText;
	}

	return CText;
}

CString GetCompanyAddress(void)
{
	CString CText = "England, U.K";

	int oem_id = GetOEMID();

	if(!oem_id) return CText;

	switch(oem_id)
	{
		case E_ANASOFT_LTD:			return CText;
		case E_INTELLISENSE_CORP:	CText = "another address"; break;

		default: return CText;
	}

	return CText;
}

CString GetCompanyPhoneNumber(void)
{
	CString CText = "See website";

	int oem_id = GetOEMID();

	if(!oem_id) return CText;

	switch(oem_id)
	{
		case E_ANASOFT_LTD:			return CText;
		case E_INTELLISENSE_CORP:	CText = "see website"; break;

		default: return CText;
	}

	return CText;
}

CString GetHelpFileName(void)
{
	CString CText = "SuperSpice.chm";

	int oem_id = GetOEMID();

	if(!oem_id) return CText;

	switch(oem_id)
	{
		case E_ANASOFT_LTD:			return CText;
		case E_INTELLISENSE_CORP:	CText = "MEMSystem.chm"; break;

		default: return CText;
	}

	return CText;
}

CString GetOEMProgramName(void)
{
	CString CText = "SuperSpice";

	int oem_id = GetOEMID();

	if(!oem_id) return CText;

	switch(oem_id)
	{
		case E_ANASOFT_LTD:			return CText;
		case E_INTELLISENSE_CORP:	CText = "MEMSystem"; break;

		default: return CText;
	}

	return CText;
}

int GetOEMID(void)
{	
	return m_oem_id;
}

void SetOEMID()
{
	m_oem_id = 0;

#ifndef RELEASE_OEM1
    m_oem_id   = 0;
#else
	m_oem_id = E_INTELLISENSE_CORP;         
#endif

	// add more as required
}

