// SuperSpice.h : main header file for the SUPERSPICE application
//

#ifndef _SUPERSPICE_APP_H
#define _SUPERSPICE_APP_H

#ifndef __AFXWIN_H__
	#error include 'stdafx.h' before including this file for PCH
#endif

#include "resource.h"       // main symbols

class TCXSpiceProgressData;

/////////////////////////////////////////////////////////////////////////////
// TCSuperSpiceApp:
// See SuperSpice.cpp for the implementation of this class
//

class TCSuperSpiceDoc;
class TCSuperSpiceMainFrame;

class TCSuperSpiceApp : public CWinApp
{
	void SetupGlobals(void);
public:
	TCSuperSpiceApp();
	~TCSuperSpiceApp();

	char *pm_msg_data;
	int  msg_size;
	int  msg_counter;
	int  m_real_time_run_type;

	void SSMsgStart(int data);
	void SSMsgContinue(int data);
	void SSMsgEnd(MSG* pMsg);

	void XSRxWaveformSignal(MSG* pMsg);

	void SaveOnExit(void);
	bool CloseWorkSpaces(void);
	void SetupPrinter(void);
	void LoadInitFile(void);
	void DeleteInitFiles(CString CUserDir);
	void LoadWinLayout(TCSuperSpiceMainFrame* pMainFrame);
	void GetCommandLineFileName(CCommandLineInfo &cmdInfo);
	void InitDB(void);

	UINT super_spice_xspice_message;
	bool SendSuperSpiceMessage(UINT h_msg, WPARAM wParam, LPARAM lParam);
	void SendXSpiceQuitMessage(UINT h_msg);
	void SendSuperSpiceAck(UINT h_msg);

	void SendXSpiceSetDCMsgCount(UINT h_msg, int count);
	void SendXSpiceSetACMsgCount(UINT h_msg, int count);
	void SendXSpiceSetTRANMsgCount(UINT h_msg, int count);
	void SendXSpiceSetSimSpeed(UINT h_msg, int wait);
	void SendXSpiceSetMsgCounts(UINT h_msg, TCXSpiceProgressData &CXSpiceProgressData);
	void SendPauseCommand(UINT h_msg);
	void SendContinueCommand(UINT h_msg);
	void SendEnableMarchingWaveforms(UINT h_msg, int data);
	void SendXSpiceMsg(UINT h_msg, int cmd, char *msg, int msg_size);
	void ModifyComponentValue(UINT h_msg, CString CRefDes, float value, int type);

	void ProccessSuperSpiceXSpiceMessage(MSG* pMsg);
	void ProccessXSpiceTranData(MSG* pMsg);
	void ProccessXSpiceACData(MSG* pMsg);
	void ProccessXSpiceDCData(MSG* pMsg);
	void ProccessXSpiceOPData(MSG* pMsg);
	void ProccessXSpiceNoiseData(MSG* pMsg);
	void ProccessXSpiceHeaderReady(MSG* pMsg);
	TCSuperSpiceDoc *GetDocumentForMsg(MSG* pMsg);
	
	 CMultiDocTemplate *GetSuperSpiceDocTemplate(void);
	 CMultiDocTemplate *GetWaveformDisplayDocTemplate(void);
	 CMultiDocTemplate *GetSpiceNetListViewDocTemplate(void);
	 CMultiDocTemplate *GetSpiceOutputTextViewDocTemplate(void);
	 CMultiDocTemplate *GetSpiceSchematicSymbolViewDocTemplate(void);
	CMultiDocTemplate *GetSpiceLibaryViewDocTemplate(void);
	CMultiDocTemplate *GetSpiceModelViewDocTemplate(void);
	CMultiDocTemplate *GetSpiceTextViewDocTemplate(void);
	CMultiDocTemplate *GetEngineErrorLogTemplate(void);
	CMultiDocTemplate *GetModelTreeTemplate(void);
	CMultiDocTemplate *GetSymbolTreeTemplate(void);
	CMultiDocTemplate *GetFileTreeTemplate(void);
	CMultiDocTemplate *GetCircuitsTreeTemplate(void);
	CMultiDocTemplate *GetSymbolPreviewTemplate(void);
	CMultiDocTemplate *GetModelPreviewTemplate(void);
	CMultiDocTemplate *GetSignalsTreeTemplate(void);

	CMultiDocTemplate *PCMSuperSpiceDocTemplate;
	CMultiDocTemplate *PCMWaveformDisplayDocTemplate;
	CMultiDocTemplate *PCMSpiceNetListViewDocTemplate;
	CMultiDocTemplate *PCMSpiceOutputTextViewDocTemplate;
	CMultiDocTemplate *PCMSuperSpiceSchematicSymbolViewDocTemplate;
	CMultiDocTemplate *PCMSpiceLibaryViewDocTemplate;
	CMultiDocTemplate *PCMSpiceModelViewDocTemplate;
	CMultiDocTemplate *PCMSpiceTextViewDocTemplate;
	CMultiDocTemplate *PCEngineErrorLogTemplate;
	CMultiDocTemplate *PCModelTreeTemplate;
	CMultiDocTemplate *PCSymbolTreeTemplate;
	CMultiDocTemplate *PCFileTreeTemplate;
	CMultiDocTemplate *PCCircuitsTreeTemplate;
	CMultiDocTemplate *PCSymbolPreviewTemplate;
	CMultiDocTemplate *PCModelPreviewTemplate;
	CMultiDocTemplate *PCSignalsTemplate;


	TCSuperSpiceDoc *GetATopLevelDocument(void);
	void DialogHelp(DWORD id);
	void Help(CString CTopicFileName);

	void DrawAllSchematics(void);

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(TCSuperSpiceApp)
	public:
	virtual BOOL InitInstance();
	virtual CDocument* OpenDocumentFile(LPCTSTR lpszFileName);
	virtual int ExitInstance();
	virtual int Run();
	virtual BOOL OnIdle(LONG lCount);
	virtual void AddToRecentFileList(LPCTSTR lpszPathName);
	virtual void WinHelpInternal(DWORD_PTR dwData, UINT nCmd = HELP_CONTEXT);

	//}}AFX_VIRTUAL

// Implementation
	COleTemplateServer m_server;
		// Server object for document creation

	//{{AFX_MSG(TCSuperSpiceApp)
	afx_msg void OnAppAbout();
	afx_msg void OnFileOpen();
	afx_msg void OnHelpContact();
	afx_msg void OnFilePrintSetup();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
	afx_msg void OnFileOpenExamples();
};

#endif
/////////////////////////////////////////////////////////////////////////////
