// TCAnalysisMainPropPage.cpp : implementation file
//

#include "stdafx.h"
#include "resource.h"
#include "TCSuperSpiceGlobalData.h"
#include "TCSimulationSetup.h"
#include "TCOutputWaveformData.h"
#include "TCAnalysisMainPropPage.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

extern int g_last_active_signal_analysis_property_page;

/////////////////////////////////////////////////////////////////////////////
// TCAnalysisMainPropPage

IMPLEMENT_DYNAMIC(TCAnalysisMainPropPage, CPropertySheet)

TCAnalysisMainPropPage::TCAnalysisMainPropPage(CWnd* pWndParent)
	 : CPropertySheet(IDS_PROPSHT_CAPTION5, pWndParent)
{
	PCAnalysisSetup		= NULL;
	PCWaveformDataRuns	= NULL;
	PCSuperSpiceDoc		= NULL;

	AddPage(&CAnalysisTranProp);
	AddPage(&CAnalysisTranPowerProp);
	AddPage(&CAnalysisTranRMSProp);
}

TCAnalysisMainPropPage::~TCAnalysisMainPropPage()
{
}
 

BEGIN_MESSAGE_MAP(TCAnalysisMainPropPage, CPropertySheet)
	//{{AFX_MSG_MAP(TCAnalysisMainPropPage)
		// NOTE - the ClassWizard will add and remove mapping macros here.
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// TCAnalysisMainPropPage message handlers



INT_PTR TCAnalysisMainPropPage::DoModal() 
{
	if(PCAnalysisSetup)
	{
		CAnalysisTranProp.CWaveformAnalyisisData	= CWaveformAnalyisisData;
		CAnalysisTranProp.PCWaveformDataRuns		= PCWaveformDataRuns;

		CAnalysisTranPowerProp.CWaveformAnalyisisData	= CWaveformAnalyisisData;
		CAnalysisTranPowerProp.PCWaveformDataRuns		= PCWaveformDataRuns;
		CAnalysisTranPowerProp.PCSuperSpiceDoc			= PCSuperSpiceDoc;

		CAnalysisTranRMSProp.CWaveformAnalyisisData	= CWaveformAnalyisisData;
		CAnalysisTranRMSProp.PCWaveformDataRuns		= PCWaveformDataRuns;
		CAnalysisTranRMSProp.PCSuperSpiceDoc		= PCSuperSpiceDoc;
		
	}
	
	SetActivePage(g_last_active_signal_analysis_property_page);

	int value = CPropertySheet::DoModal();

	if(value != IDOK) return value;
	
    if(!PCAnalysisSetup) return value;

	CWaveformAnalyisisData = CAnalysisTranProp.CWaveformAnalyisisData;

	CWaveformAnalyisisData.CPowerDeviceName = CAnalysisTranPowerProp.CWaveformAnalyisisData.CPowerDeviceName;
	CWaveformAnalyisisData.CPowerRunSelect = CAnalysisTranPowerProp.CWaveformAnalyisisData.CPowerRunSelect;
	CWaveformAnalyisisData.power_end		= CAnalysisTranPowerProp.CWaveformAnalyisisData.power_end;
	CWaveformAnalyisisData.power_start		= CAnalysisTranPowerProp.CWaveformAnalyisisData.power_start;
	CWaveformAnalyisisData.power_value		= CAnalysisTranPowerProp.CWaveformAnalyisisData.power_value;
	CWaveformAnalyisisData.power_temperture	= CAnalysisTranPowerProp.CWaveformAnalyisisData.power_temperture;
	CWaveformAnalyisisData.power_rtheata	= CAnalysisTranPowerProp.CWaveformAnalyisisData.power_rtheata;
	CWaveformAnalyisisData.power_enable		= CAnalysisTranPowerProp.CWaveformAnalyisisData.power_enable;

	CWaveformAnalyisisData.CRMSSignalName	= CAnalysisTranRMSProp.CWaveformAnalyisisData.CRMSSignalName;
	CWaveformAnalyisisData.CRMSRunSelect	= CAnalysisTranRMSProp.CWaveformAnalyisisData.CRMSRunSelect;
	CWaveformAnalyisisData.rms_end			= CAnalysisTranRMSProp.CWaveformAnalyisisData.rms_end;
	CWaveformAnalyisisData.rms_start		= CAnalysisTranRMSProp.CWaveformAnalyisisData.rms_start;
	CWaveformAnalyisisData.rms_value		= CAnalysisTranRMSProp.CWaveformAnalyisisData.rms_value;
	CWaveformAnalyisisData.rms_enable		= CAnalysisTranRMSProp.CWaveformAnalyisisData.rms_enable;
	CWaveformAnalyisisData.rms_av_value		= CAnalysisTranRMSProp.CWaveformAnalyisisData.rms_av_value;
	CWaveformAnalyisisData.rms_pk_value		= CAnalysisTranRMSProp.CWaveformAnalyisisData.rms_pk_value;
	CWaveformAnalyisisData.rms_ripple_value = CAnalysisTranRMSProp.CWaveformAnalyisisData.rms_ripple_value;
	
	return value;
}
