// TCAnalysisPropPages.cpp : implementation file
//

#include "stdafx.h"
#include "resource.h"
#include "TCMKSConvert.h"
#include "TCOutputWaveformData.h"
#include "TCSuperSpiceDoc.h"
#include "TCAnalysisPropPages.h"
#include "TCSuperSpiceDoc.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

IMPLEMENT_DYNCREATE(TCAnalysisTranProp, CPropertyPage)
IMPLEMENT_DYNCREATE(TCAnalysisTranPowerProp, CPropertyPage)
IMPLEMENT_DYNCREATE(TCAnalysisTranRMSProp, CPropertyPage)


extern int g_last_active_signal_analysis_property_page;

/////////////////////////////////////////////////////////////////////////////
// TCAnalysisTranProp property page

TCAnalysisTranProp::TCAnalysisTranProp() : CPropertyPage(TCAnalysisTranProp::IDD)
{
	//{{AFX_DATA_INIT(TCAnalysisTranProp)
	pulse_width_polarity = -1;
	CPulseReferanceSignal = _T("");
	CPulseMeasureSignal = _T("");
	pulse_xing_count = 0;
	pulse_ref_xing_count = 0;
	pulse_enable = FALSE;
	CPulseRunSelect = _T("");
	//}}AFX_DATA_INIT

	m_signal_index = 0;
	m_ref_index    = 0;
}

TCAnalysisTranProp::~TCAnalysisTranProp()
{
}

void TCAnalysisTranProp::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(TCAnalysisTranProp)
	DDX_Control(pDX, IDC_COMBO_RUN_SELECT2, CPulseRunSelectCtrl);
	DDX_Control(pDX, IDC_COMBO_SIGNAL_NAME, CComboSignalName);
	DDX_Control(pDX, IDC_COMBO_REF_SIGNAL_NAME, CComboRefSignal);
	DDX_Radio(pDX, IDC_RADIO_PULSE_POLARITY, pulse_width_polarity);
	DDX_CBString(pDX, IDC_COMBO_REF_SIGNAL_NAME, CPulseReferanceSignal);
	DDX_CBString(pDX, IDC_COMBO_SIGNAL_NAME, CPulseMeasureSignal);
	DDX_MKSValue(pDX, IDC_EDIT_DELAY, pulse_delay);
	DDX_MKSValue(pDX, IDC_EDIT_DELAY_POSITION, pulse_time);
	DDX_MKSValue(pDX, IDC_EDIT_PERIOD_POSITION, pulse_time_period);
	DDX_MKSValue(pDX, IDC_EDIT_FALL_POSITION, pulse_fall_xing_time);
	DDX_MKSValue(pDX, IDC_EDIT_MAX_LEVEL, pulse_max_level);
	DDX_MKSValue(pDX, IDC_EDIT_MID_LEVEL, pulse_mid_level);
	DDX_MKSValue(pDX, IDC_EDIT_MIN_LEVEL, pulse_min_level);
	DDX_MKSValue(pDX, IDC_EDIT_PERIOD, pulse_period);
	DDX_Text(pDX, IDC_EDIT_POS_COUNT, pulse_xing_count);
	DDX_Text(pDX, IDC_EDIT_REF_POS_COUNT, pulse_ref_xing_count);
	DDX_MKSValue(pDX, IDC_EDIT_RISE_POSITION, pulse_rise_xing_time);
	DDX_MKSValue(pDX, IDC_EDIT_RISE_TIME, pulse_rise_time);
	DDX_MKSValue(pDX, IDC_EDIT_WIDTH, pulse_width);
	DDX_MKSValue(pDX, IDC_EDIT_FALL_TIME, pulse_fall_time);
	DDX_Check(pDX, IDC_CHECK_ENABLE, pulse_enable);
	DDX_MKSValue(pDX, IDC_EDIT_WIDTH_POSITION, pulse_width_mid_time);
	DDX_CBString(pDX, IDC_COMBO_RUN_SELECT2, CPulseRunSelect);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(TCAnalysisTranProp, CPropertyPage)
	//{{AFX_MSG_MAP(TCAnalysisTranProp)
	ON_BN_CLICKED(IDC_BUTTON_CALCULATE, OnButtonCalculate)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// TCAnalysisTranPowerProp property page

TCAnalysisTranPowerProp::TCAnalysisTranPowerProp() : CPropertyPage(TCAnalysisTranPowerProp::IDD)
{
	//{{AFX_DATA_INIT(TCAnalysisTranPowerProp)
	CComponentList = _T("");
	CRunSelect = _T("");
	m_power_enable = TRUE;
	//}}AFX_DATA_INIT

	m_tran_start_time = 0;
	m_tran_stop_time = 0;
	m_signal_index = 0;

	PCSuperSpiceDoc = NULL;
}

TCAnalysisTranPowerProp::~TCAnalysisTranPowerProp()
{
}

void TCAnalysisTranPowerProp::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(TCAnalysisTranPowerProp)
	DDX_Control(pDX, IDC_COMBO_RUN_SELECT, CRunSelectCtrl);
	DDX_Control(pDX, IDC_COMBO_COMPONENT_LIST, CComponentListCtrl);
	DDX_CBString(pDX, IDC_COMBO_COMPONENT_LIST, CComponentList);
	DDX_MKSValue(pDX, IDC_EDIT_END_TIME, m_end_time);
	DDX_MKSValue(pDX, IDC_EDIT_POWER, m_power_value);
	DDX_MKSValue(pDX, IDC_EDIT_START_TIME, m_start_time);
	DDX_CBString(pDX, IDC_COMBO_RUN_SELECT, CRunSelect);
	DDX_MKSValue(pDX, IDC_EDIT_TRANSTART, m_tran_start_time);
	DDX_MKSValue(pDX, IDC_EDIT_TRANSTOP, m_tran_stop_time);
	DDX_Check(pDX, IDC_CHECK_ENABLE_MOUSE_PROBING, m_power_enable);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(TCAnalysisTranPowerProp, CPropertyPage)
	//{{AFX_MSG_MAP(TCAnalysisTranPowerProp)
	ON_BN_CLICKED(IDC_BUTTON_CALCULATE, OnButtonCalculate)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


BOOL TCAnalysisTranPowerProp::OnInitDialog() 
{
	CPropertyPage::OnInitDialog();
	
	CComponentList	= CWaveformAnalyisisData.CPowerDeviceName;

	LoadDeviceList();

	SetDisplay();

	return TRUE;  
}

BOOL TCAnalysisTranPowerProp::OnSetActive() 
{
	g_last_active_signal_analysis_property_page = 1;
	
	return CPropertyPage::OnSetActive();
}

BOOL TCAnalysisTranProp::OnSetActive() 
{
	g_last_active_signal_analysis_property_page	= 0;

	return CPropertyPage::OnSetActive();
}

void TCAnalysisTranProp::GetDisplay(void)
{
	UpdateData(true);

	CWaveformAnalyisisData.pulse_width_polarity = pulse_width_polarity;
	CWaveformAnalyisisData.CPulseReferanceSignal = CPulseReferanceSignal;
	CWaveformAnalyisisData.CPulseMeasureSignal = CPulseMeasureSignal;
	CWaveformAnalyisisData.CPulseRunSelect		= CPulseRunSelect;
	CWaveformAnalyisisData.pulse_delay = pulse_delay;
	CWaveformAnalyisisData.pulse_time = pulse_time;
	CWaveformAnalyisisData.pulse_fall_xing_time = pulse_fall_xing_time;
	CWaveformAnalyisisData.pulse_max_level = pulse_max_level;
	CWaveformAnalyisisData.pulse_mid_level = pulse_mid_level;
	CWaveformAnalyisisData.pulse_min_level = pulse_min_level;
	CWaveformAnalyisisData.pulse_period = pulse_period;
	CWaveformAnalyisisData.pulse_xing_count = pulse_xing_count;
	CWaveformAnalyisisData.pulse_ref_xing_count = pulse_ref_xing_count;
	CWaveformAnalyisisData.pulse_rise_xing_time = pulse_rise_xing_time;
	CWaveformAnalyisisData.pulse_rise_time = pulse_rise_time;
	CWaveformAnalyisisData.pulse_width = pulse_width;
	CWaveformAnalyisisData.pulse_width_mid_time = pulse_width_mid_time;
	CWaveformAnalyisisData.pulse_fall_time = pulse_fall_time;
	CWaveformAnalyisisData.pulse_enable = pulse_enable;

	m_signal_index = CComboSignalName.GetCurSel();
	m_ref_index = CComboRefSignal.GetCurSel();
}

void TCAnalysisTranProp::SetDisplay(void)
{
	pulse_width_polarity = CWaveformAnalyisisData.pulse_width_polarity;
	CPulseReferanceSignal = CWaveformAnalyisisData.CPulseReferanceSignal;
	CPulseMeasureSignal = CWaveformAnalyisisData.CPulseMeasureSignal;
	CPulseRunSelect = CWaveformAnalyisisData.CPulseRunSelect;
	pulse_delay = CWaveformAnalyisisData.pulse_delay;
	pulse_time = CWaveformAnalyisisData.pulse_time;
	pulse_time_period = CWaveformAnalyisisData.pulse_time;
	pulse_fall_xing_time = CWaveformAnalyisisData.pulse_fall_xing_time;
	pulse_max_level = CWaveformAnalyisisData.pulse_max_level;
	pulse_mid_level = CWaveformAnalyisisData.pulse_mid_level;
	pulse_min_level = CWaveformAnalyisisData.pulse_min_level;
	pulse_period = CWaveformAnalyisisData.pulse_period;
	pulse_xing_count = CWaveformAnalyisisData.pulse_xing_count;
	pulse_ref_xing_count = CWaveformAnalyisisData.pulse_ref_xing_count;
	pulse_rise_xing_time = CWaveformAnalyisisData.pulse_rise_xing_time;
	pulse_rise_time = CWaveformAnalyisisData.pulse_rise_time;
	pulse_width = CWaveformAnalyisisData.pulse_width;
	pulse_width_mid_time = CWaveformAnalyisisData.pulse_width_mid_time;
	pulse_fall_time = CWaveformAnalyisisData.pulse_fall_time;
	pulse_enable = CWaveformAnalyisisData.pulse_enable;

	UpdateData(false);

	CComboSignalName.GetCurSel();
	CComboRefSignal.GetCurSel();
}

void TCAnalysisTranProp::LoadSignalList(void)
{
	if(!PCWaveformDataRuns) return;
	if(IsBadReadPtr(PCWaveformDataRuns, 4)) return;

	int index = PCWaveformDataRuns->CRuns[0]->IsWaveformHeaderAvailable(E_SPICE_RECORD_TRANSIENT);

	if(!index) return;

	TCOutputWaveformDataHeader *PCHeader = &PCWaveformDataRuns->CRuns[0]->CRecords[E_SPICE_RECORD_TRANSIENT].CHeader;

	CComboSignalName.ResetContent();
	CComboRefSignal.ResetContent();
	CPulseRunSelectCtrl.ResetContent();
	
	CArray <TCSignal, TCSignal &> &CSignals = *PCHeader->PCSignals;

	int count = CSignals.GetSize();

	int p;

	for(int p = 0; p < count; p++)
	{
		if(CPulseMeasureSignal == CSignals[p].CName)	m_signal_index =p;
		if(CPulseReferanceSignal == CSignals[p].CName)	m_ref_index = p;

		CComboSignalName.InsertString(-1, CSignals[p].CName);

		CComboRefSignal.InsertString(-1, CSignals[p].CName);
	}

	index = PCWaveformDataRuns->CRuns[0]->GetWaveFormHeaderIndex(E_SPICE_RECORD_TRANSIENT);

	if(index < 0) return;

	CPulseRunSelect = PCWaveformDataRuns->CRunDiscription;

	if(index < 0) return;

	count = PCWaveformDataRuns->CRuns.GetSize();

	CString CText;

	for(p = 0; p < count; p++)
	{
		if(!(index < PCWaveformDataRuns->CRuns[p]->CRecords.GetSize())) return;

		CText = PCWaveformDataRuns->CRuns[p]->CRunDiscription;

		CPulseRunSelectCtrl.InsertString(-1, CText);
	}
}

void TCAnalysisTranProp::OnButtonCalculate() 
{
	if(!PCWaveformDataRuns) return;
	if(IsBadReadPtr(PCWaveformDataRuns, 4)) return;

	GetDisplay();

	int index = CPulseRunSelectCtrl.GetCurSel();

	if(index < 0) index = 0;

	PCWaveformDataRuns->CalculatePulseData(CWaveformAnalyisisData, index);

	SetDisplay();
}

BOOL TCAnalysisTranProp::OnInitDialog() 
{
	CPropertyPage::OnInitDialog();

	CPulseReferanceSignal = CWaveformAnalyisisData.CPulseReferanceSignal;
	CPulseMeasureSignal = CWaveformAnalyisisData.CPulseMeasureSignal;
	CPulseRunSelect = CWaveformAnalyisisData.CPulseRunSelect;

	LoadSignalList();

	SetDisplay();

	return TRUE; 
}

void TCAnalysisTranProp::OnOK() 
{
	GetDisplay();

	CPropertyPage::OnOK();
}

void TCAnalysisTranPowerProp::GetDisplay(void) 
{
	UpdateData(true);

	CWaveformAnalyisisData.CPowerDeviceName = CComponentList;
	CWaveformAnalyisisData.CPowerRunSelect	= CRunSelect;
	CWaveformAnalyisisData.power_start		= m_start_time;
	CWaveformAnalyisisData.power_end		= m_end_time;
	CWaveformAnalyisisData.power_enable		= m_power_enable;

	m_signal_index = CComponentListCtrl.GetCurSel();
}

void TCAnalysisTranPowerProp::SetDisplay(void) 
{
	CComponentList	= CWaveformAnalyisisData.CPowerDeviceName;
	CRunSelect		= CWaveformAnalyisisData.CPowerRunSelect;
	m_end_time		= CWaveformAnalyisisData.power_end;
	m_start_time	= CWaveformAnalyisisData.power_start;
	m_power_value	= CWaveformAnalyisisData.power_value;
	m_power_enable	= CWaveformAnalyisisData.power_enable;

	if(PCWaveformDataRuns && !IsBadReadPtr(PCWaveformDataRuns, 4))
	{
		if(PCWaveformDataRuns->CRuns[0]->IsWaveformHeaderAvailable(E_SPICE_RECORD_TRANSIENT))
		{
			CArray <TCSignal, TCSignal&> &CSignals = *PCWaveformDataRuns->CRuns[0]->CRecords[E_SPICE_RECORD_TRANSIENT].CHeader.PCSignals;

			if(!IsBadReadPtr(&CSignals, sizeof(TCSignal)))
			{
				if(CSignals.GetSize())
				{
				int size = CSignals[0].CMagnitudeData.CX.GetSize();
				
					if(size > 1)
					{
						m_tran_stop_time = CSignals[0].CMagnitudeData.CX[size - 1];
						m_tran_start_time = CSignals[0].CMagnitudeData.CX[0];
					}
				}
			}
		}
	}

	UpdateData(false);

	CComponentListCtrl.SetCurSel(m_signal_index);
}

void TCAnalysisTranPowerProp::LoadDeviceList(void) 
{
	if(!PCSuperSpiceDoc) return;
	if(!PCWaveformDataRuns) return;
	if(IsBadReadPtr(PCWaveformDataRuns, 4)) return;

	CComponentListCtrl.ResetContent();
	CRunSelectCtrl.ResetContent();
	
	CArray <CString, CString&> CRefDesList;

	PCSuperSpiceDoc->GetRefDesList(CRefDesList);

	int count = CRefDesList.GetSize();

	int p;

	for(p = 0; p < count; p++)
	{
		if(CComponentList == CRefDesList[p]) m_signal_index = p;
		
		CComponentListCtrl.InsertString(-1, CRefDesList[p]);
	}

	CRunSelectCtrl.ResetContent();

	int index = PCWaveformDataRuns->CRuns[0]->GetWaveFormHeaderIndex(E_SPICE_RECORD_TRANSIENT);

	if(index < 0) return;

	CRunSelect = PCWaveformDataRuns->CRunDiscription;

	if(index < 0) return;

	count = PCWaveformDataRuns->CRuns.GetSize();

	CString CText;

	for(p = 0; p < count; p++)
	{
		if(!(index < PCWaveformDataRuns->CRuns[p]->CRecords.GetSize())) return;

		CText = PCWaveformDataRuns->CRuns[p]->CRunDiscription;

		CRunSelectCtrl.InsertString(-1, CText);
	}
}

void TCAnalysisTranPowerProp::OnButtonCalculate() 
{
	if(!PCSuperSpiceDoc) return;
	if(!PCWaveformDataRuns) return;

	int index = PCWaveformDataRuns->CRuns[0]->GetWaveFormHeaderIndex(E_SPICE_RECORD_TRANSIENT);

	if(index < 0) return;

	GetDisplay();

	index = CRunSelectCtrl.GetCurSel();

	if(index < 0) index = 0;

	PCSuperSpiceDoc->CalculateTransientPower(CComponentList, CWaveformAnalyisisData, index);

	m_power_value = CWaveformAnalyisisData.power_value;

	SetDisplay();
}

void TCAnalysisTranPowerProp::OnOK() 
{
	GetDisplay();
	
	CPropertyPage::OnOK();
}

////////////////////////
////////////////////////
TCAnalysisTranRMSProp::TCAnalysisTranRMSProp() : CPropertyPage(TCAnalysisTranRMSProp::IDD)
{
	//{{AFX_DATA_INIT(TCAnalysisTranRMSProp)
	CSignalInList = _T("");
	CRunSelect = _T("");
	m_rms_enable = FALSE;
	//}}AFX_DATA_INIT

	m_tran_start_time = 0;
	m_tran_stop_time = 0;
	m_signal_index = 0;

	PCSuperSpiceDoc = NULL;
}

TCAnalysisTranRMSProp::~TCAnalysisTranRMSProp()
{
}

void TCAnalysisTranRMSProp::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(TCAnalysisTranRMSProp)
	DDX_Control(pDX, IDC_COMBO_RUN_SELECT, CRunSelectCtrl);
	DDX_Control(pDX, IDC_COMBO_COMPONENT_LIST, CSignalListCtrl);
	DDX_CBString(pDX, IDC_COMBO_COMPONENT_LIST, CSignalInList);
	DDX_MKSValue(pDX, IDC_EDIT_END_TIME, m_end_time);
	DDX_MKSValue(pDX, IDC_EDIT_POWER, m_rms_value);
	DDX_MKSValue(pDX, IDC_EDIT_START_TIME, m_start_time);
	DDX_CBString(pDX, IDC_COMBO_RUN_SELECT, CRunSelect);
	DDX_MKSValue(pDX, IDC_EDIT_TRANSTART, m_tran_start_time);
	DDX_MKSValue(pDX, IDC_EDIT_TRANSTOP, m_tran_stop_time);
	DDX_MKSValue(pDX, IDC_EDIT_AVERAGE, m_rms_av_value);
	DDX_MKSValue(pDX, IDC_EDIT_PKPK, m_rms_pk_value);
	DDX_Check(pDX, IDC_CHECK_ENABLE_DISPLAY, m_rms_enable);
	DDX_MKSValue(pDX, IDC_EDIT_RMS_RIPPLE, m_rms_ripple_value);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(TCAnalysisTranRMSProp, CPropertyPage)
	//{{AFX_MSG_MAP(TCAnalysisTranRMSProp)
	ON_BN_CLICKED(IDC_BUTTON_CALCULATE, OnButtonCalculate)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


BOOL TCAnalysisTranRMSProp::OnInitDialog() 
{
	CPropertyPage::OnInitDialog();
	
	CSignalInList = CWaveformAnalyisisData.CRMSSignalName;

	LoadSignalList();

	SetDisplay();

	return TRUE;  
}

BOOL TCAnalysisTranRMSProp::OnSetActive() 
{
	g_last_active_signal_analysis_property_page = 2;
	
	return CPropertyPage::OnSetActive();
}

void TCAnalysisTranRMSProp::GetDisplay(void) 
{
	UpdateData(true);

	CWaveformAnalyisisData.CRMSSignalName	= CSignalInList;
	CWaveformAnalyisisData.CRMSRunSelect	= CRunSelect;
	CWaveformAnalyisisData.rms_start		= m_start_time;
	CWaveformAnalyisisData.rms_end			= m_end_time;
	CWaveformAnalyisisData.rms_enable		= m_rms_enable;
	CWaveformAnalyisisData.rms_ripple_value = m_rms_ripple_value;

	m_signal_index = CSignalListCtrl.GetCurSel();
}

void TCAnalysisTranRMSProp::SetDisplay(void) 
{
	CSignalInList	= CWaveformAnalyisisData.CRMSSignalName;
	CRunSelect		= CWaveformAnalyisisData.CRMSRunSelect;
	m_end_time		= CWaveformAnalyisisData.rms_end;
	m_start_time	= CWaveformAnalyisisData.rms_start;
	m_rms_value		= CWaveformAnalyisisData.rms_value;
	m_rms_av_value	= CWaveformAnalyisisData.rms_av_value;
	m_rms_pk_value	= CWaveformAnalyisisData.rms_pk_value;
	m_rms_enable	= CWaveformAnalyisisData.rms_enable;
	m_rms_ripple_value= CWaveformAnalyisisData.rms_ripple_value;

	if(PCWaveformDataRuns && !IsBadReadPtr(PCWaveformDataRuns, 4))
	{
		if(PCWaveformDataRuns->CRuns[0]->IsWaveformHeaderAvailable(E_SPICE_RECORD_TRANSIENT))
		{
			CArray <TCSignal, TCSignal&> &CSignals = *PCWaveformDataRuns->CRuns[0]->CRecords[E_SPICE_RECORD_TRANSIENT].CHeader.PCSignals;

			if(!IsBadReadPtr(&CSignals, sizeof(TCSignal)))
			{
				if(CSignals.GetSize())
				{
				int size = CSignals[0].CMagnitudeData.CX.GetSize();
				
					if(size > 1)
					{
						m_tran_stop_time = CSignals[0].CMagnitudeData.CX[size - 1];
						m_tran_start_time = CSignals[0].CMagnitudeData.CX[0];
					}
				}
			}
		}
	}

	UpdateData(false);

	CSignalListCtrl.SetCurSel(m_signal_index);
}

void TCAnalysisTranRMSProp::LoadSignalList(void) 
{
	if(!PCWaveformDataRuns) return;
	if(IsBadReadPtr(PCWaveformDataRuns, 4)) return;

	int index = PCWaveformDataRuns->CRuns[0]->IsWaveformHeaderAvailable(E_SPICE_RECORD_TRANSIENT);

	if(!index) return;

	TCOutputWaveformDataHeader *PCHeader = &PCWaveformDataRuns->CRuns[0]->CRecords[E_SPICE_RECORD_TRANSIENT].CHeader;

	CSignalListCtrl.ResetContent();
	CRunSelectCtrl.ResetContent();
	
	CArray <TCSignal, TCSignal &> &CSignals = *PCHeader->PCSignals;

	int count = CSignals.GetSize();

	int p;

	for(p = 0; p < count; p++)
	{
		if(CSignals[p].CName == CSignalInList) m_signal_index = p;

		CSignalListCtrl.InsertString(-1, CSignals[p].CName);
	}

	index = PCWaveformDataRuns->CRuns[0]->GetWaveFormHeaderIndex(E_SPICE_RECORD_TRANSIENT);

	if(index < 0) return;

	CRunSelect = PCWaveformDataRuns->CRunDiscription;

	if(index < 0) return;

	count = PCWaveformDataRuns->CRuns.GetSize();

	CString CText;

	for(p = 0; p < count; p++)
	{
		if(!(index < PCWaveformDataRuns->CRuns[p]->CRecords.GetSize())) return;

		CText = PCWaveformDataRuns->CRuns[p]->CRunDiscription;

		CRunSelectCtrl.InsertString(-1, CText);
	}
}

void TCAnalysisTranRMSProp::OnButtonCalculate() 
{
	if(!PCSuperSpiceDoc) return;
	if(!PCWaveformDataRuns) return;

	int index = PCWaveformDataRuns->CRuns[0]->GetWaveFormHeaderIndex(E_SPICE_RECORD_TRANSIENT);

	if(index < 0) return;

	GetDisplay();

	index = CRunSelectCtrl.GetCurSel();

	if(index < 0) index = 0;

	PCSuperSpiceDoc->CalculateTransientAverages(CWaveformAnalyisisData, index);

	SetDisplay();
}

void TCAnalysisTranRMSProp::OnOK() 
{
	GetDisplay();
	
	CPropertyPage::OnOK();
}

