// TCAnalysisPropPages.h : header file
//

#ifndef __TCANALYSISPROPPAGES_H__
#define __TCANALYSISPROPPAGES_H__
/////////////////////////////////////////////////////////////////////////////
// TCAnalysisTranProp dialog

class TCAnalysisTranProp : public CPropertyPage
{
	DECLARE_DYNCREATE(TCAnalysisTranProp)

// Construction
public:
	TCAnalysisTranProp();
	~TCAnalysisTranProp();

	TCWaveformDataRuns *PCWaveformDataRuns;
	TCWaveformAnalyisisData CWaveformAnalyisisData;

	void GetDisplay(void);
	void SetDisplay(void);
	void LoadSignalList(void);

	int m_signal_index;
	int m_ref_index;

// Dialog Data
	//{{AFX_DATA(TCAnalysisTranProp)
	enum { IDD = IDD_PROPP_ANALYSIS_TRANSIENT };
	CComboBox	CPulseRunSelectCtrl;
	CComboBox	CComboSignalName;
	CComboBox	CComboRefSignal;
	int		pulse_width_polarity;
	CString	CPulseReferanceSignal;
	CString	CPulseMeasureSignal;
	double	pulse_delay;
	double	pulse_time;
	double	pulse_time_period;
	double	pulse_fall_xing_time;
	double	pulse_max_level;
	double	pulse_mid_level;
	double	pulse_min_level;
	double	pulse_period;
	int		pulse_xing_count;
	int		pulse_ref_xing_count;
	double	pulse_rise_xing_time;
	double	pulse_rise_time;
	double	pulse_width;
	double	pulse_fall_time;
	BOOL	pulse_enable;
	double	pulse_width_mid_time;
	CString	CPulseRunSelect;
	//}}AFX_DATA


// Overrides
	// ClassWizard generate virtual function overrides
	//{{AFX_VIRTUAL(TCAnalysisTranProp)
	public:
	virtual void OnOK();
	virtual BOOL OnSetActive();
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	// Generated message map functions
	//{{AFX_MSG(TCAnalysisTranProp)
	afx_msg void OnButtonCalculate();
	virtual BOOL OnInitDialog();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

};

class TCSuperSpiceDoc;
/////////////////////////////////////////////////////////////////////////////
// TCAnalysisTranPowerProp dialog

class TCAnalysisTranPowerProp : public CPropertyPage
{
	DECLARE_DYNCREATE(TCAnalysisTranPowerProp)

// Construction
public:
	TCAnalysisTranPowerProp();
	~TCAnalysisTranPowerProp();

	TCWaveformDataRuns *PCWaveformDataRuns;
	TCWaveformAnalyisisData CWaveformAnalyisisData;
	TCSuperSpiceDoc *PCSuperSpiceDoc;

	void GetDisplay(void);
	void SetDisplay(void);
	void LoadDeviceList(void);

	int m_signal_index;

// Dialog Data
	//{{AFX_DATA(TCAnalysisTranPowerProp)
	enum { IDD = IDD_PROPP_ANALYSIS_TRAN_POWER };
	CComboBox	CRunSelectCtrl;
	CComboBox	CComponentListCtrl;
	CString	CComponentList;
	double	m_end_time;
	double	m_power_value;
	double	m_start_time;
	CString	CRunSelect;
	double	m_tran_start_time;
	double	m_tran_stop_time;
	BOOL	m_power_enable;
	//}}AFX_DATA


// Overrides
	// ClassWizard generate virtual function overrides
	//{{AFX_VIRTUAL(TCAnalysisTranPowerProp)
	public:
	virtual void OnOK();
	virtual BOOL OnSetActive();
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	// Generated message map functions
	//{{AFX_MSG(TCAnalysisTranPowerProp)
	virtual BOOL OnInitDialog();
	afx_msg void OnButtonCalculate();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

};

class TCAnalysisTranRMSProp : public CPropertyPage
{
	DECLARE_DYNCREATE(TCAnalysisTranRMSProp)

// Construction
public:
	TCAnalysisTranRMSProp();
	~TCAnalysisTranRMSProp();

	TCWaveformDataRuns *PCWaveformDataRuns;
	TCWaveformAnalyisisData CWaveformAnalyisisData;
	TCSuperSpiceDoc *PCSuperSpiceDoc;

	void GetDisplay(void);
	void SetDisplay(void);
	void LoadSignalList(void);

	int m_signal_index;

// Dialog Data
	//{{AFX_DATA(TCAnalysisTranRMSProp)
	enum { IDD = IDD_PROPP_ANALYSIS_TRAN_RMS };
	CComboBox	CRunSelectCtrl;
	CComboBox	CSignalListCtrl;
	CString	CSignalInList;
	double	m_end_time;
	double	m_rms_value;
	double	m_start_time;
	CString	CRunSelect;
	double	m_tran_start_time;
	double	m_tran_stop_time;
	double	m_rms_av_value;
	double	m_rms_pk_value;
	BOOL	m_rms_enable;
	double	m_rms_ripple_value;
	//}}AFX_DATA


// Overrides
	// ClassWizard generate virtual function overrides
	//{{AFX_VIRTUAL(TCAnalysisTranRMSProp)
	public:
	virtual void OnOK();
	virtual BOOL OnSetActive();
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	// Generated message map functions
	//{{AFX_MSG(TCAnalysisTranRMSProp)
	virtual BOOL OnInitDialog();
	afx_msg void OnButtonCalculate();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

};


#endif // __TCANALYSISPROPPAGES_H__
