#pragma warning(disable:4706)//assignment within conditional expression
#include "stdafx.h"
#include "TDVersion.h"
#include "TCFileFunctions.h"
#include "Generic.h"
#include "TCUserRegistrationId.h"
#include "TCAuthorizationDlg.h"
#include "TCAuthorization.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


IMPLEMENT_SERIAL(TCAuthorization, CObject, ID_VERSION_NUMBER)
IMPLEMENT_SERIAL(TCIntArray, CObject, ID_VERSION_NUMBER)
IMPLEMENT_SERIAL(TCPasswordData, CObject, ID_VERSION_NUMBER)


extern HDC	HDCMDestCmp;
extern HDC	HDCMSrcCmp;
CString GetDriveSerialNumber(void);
CString GetDriveSerialNumberLast5Digits(void);


TCPasswordData::TCPasswordData(void)
{
	type	= 0;

	timeout = false;
}

TCPasswordData::TCPasswordData(TCPasswordData &CPasswordData)
{
	*this = CPasswordData;
}
TCPasswordData::~TCPasswordData(void)
{

}

void TCPasswordData::Serialize(CArchive& CArchiveFile)
{
	CObject::Serialize(CArchiveFile);

	if(CArchiveFile.IsStoring())
	{
		CArchiveFile << CCoprightNotice;
		CArchiveFile << CUserData;
		CArchiveFile << CProductID;
		CArchiveFile << CWindowsUserName;
		CArchiveFile << CCompany;
		CArchiveFile << type;
		CArchiveFile << timeout;
		CArchiveFile << CTimeStamp;
	}
	else
	{
		CArchiveFile >> CCoprightNotice;
		CArchiveFile >> CUserData;
		CArchiveFile >> CProductID;
		CArchiveFile >> CWindowsUserName;
		CArchiveFile >> CCompany;
		CArchiveFile >> type;
		CArchiveFile >> timeout;
		CArchiveFile >> CTimeStamp;
	}
}
void TCPasswordData::operator = (TCPasswordData &CPasswordData)
{
	CCoprightNotice		= CPasswordData.CCoprightNotice;
	CUserData			= CPasswordData.CUserData;
	CProductID			= CPasswordData.CProductID;
	CWindowsUserName	= CPasswordData.CWindowsUserName;
	CCompany 			= CPasswordData.CCompany;
	type				= CPasswordData.type;
	timeout				= CPasswordData.timeout;
	CTimeStamp			= CPasswordData.CTimeStamp;
}

//////////////////////////////////////////////////////////////////////
void TCIntArray::Serialize(CArchive& CArchiveFile)
{
	CObject::Serialize(CArchiveFile);

	int count;
	int p;


	if(CArchiveFile.IsStoring())
	{
		count = CIntList.GetSize();

		CArchiveFile << count;

		for(p = 0; p < count; p++) CArchiveFile << CIntList[p];
	}
	else
	{
		CArchiveFile >> count;

		CIntList.SetSize(count);

		for(p = 0; p < count; p++) CArchiveFile >> CIntList[p];
	}
}

///////////////////////////////////////////////////////
TCAuthorization::TCAuthorization(void)
{
	m_build_type		= 0;
	m_build_type2		= 0;
	m_authorized		= false;
	m_authorized2		= false;
	m_not_authorized1	= true;

	varify_at_netlist1	= 0;
	varify_at_netlist2	= 0;
	timeout				= false;
	oem					= E_OEM_SUPERSPICE;
	m_magic_nmber		= 2856947246;

#ifdef GENERATE_PASSWORD
	timeout = m_magic_nmber + 5773;  // special manual set only for the oem relese to oem vendors
#endif

#ifndef RELEASE_OEM1
    CPasswordFilename = "SuperSpice.pwd";
#else
	CPasswordFilename = "MEMSystem.pwd";         
#endif

#ifdef OEM_PASSWORD
	CPasswordFilename = "Password.pwd";
#endif

	Setup();
}

void TCAuthorization::CodeString(int id, CString CText)
{
	if(!(id < CodedStringList.GetSize())) return;

	int count = CText.GetLength();

	char test_char;


	CodedStringList[id].CIntList.SetSize(count);

	for(int p = 0; p < count; p++)
	{
		test_char = CText.GetAt(p);

		if(test_char < 0) test_char = '?';
		if(test_char > 255) test_char = '?';

		CodedStringList[id].CIntList[p] = CodeCharList[test_char];
	}
}

CString TCAuthorization::DeCodeString(int id)
{
	CString CText;

	if(!(id < CodedStringList.GetSize())) return CText;

	int count = CodedStringList[id].CIntList.GetSize();

	for(int p = 0; p < count; p++)
	{
		CText += DeCodeCharList[CodedStringList[id].CIntList[p]];
	}

	return CText;
}

void TCAuthorization::GenerateCode(void)
{
	DeCodeCharList.SetSize(E_AUTHORIZATION_CODES_MAX);

	int p;

	for(p = 0; p < E_AUTHORIZATION_CODES_MAX; p++)
	{
		DeCodeCharList[p] = ' ';
	}

	int code_int;

	for(p = 0; p < 256; p++)
	{
		code_int = Code((char) p);

		DeCodeCharList[code_int] = (char)p;

		CodeCharList[p] = code_int;
	}

	// to do
}

int  TCAuthorization::Code(char CChar)
{
	CChar;
	// to do
	return 0;
}

void TCAuthorization::GenerateCodeTest(void)
{
	DeCodeCharList.SetSize(E_AUTHORIZATION_CODES_MAX);

	int p;

	for(p = 0; p < E_AUTHORIZATION_CODES_MAX; p++)
	{
		DeCodeCharList[p] = ' ';
	}

	for( p = 0; p < 256; p++)
	{
		CodeCharList[p] = E_AUTHORIZATION_MARK;
	}

	DeCodeCharList[E_AUTHORIZATION_A]  = 'A';
	CodeCharList['A'] = E_AUTHORIZATION_A;
	DeCodeCharList[E_AUTHORIZATION_a]  = 'a';
	CodeCharList['a'] = E_AUTHORIZATION_a;
	DeCodeCharList[E_AUTHORIZATION_3] =  '3';
	CodeCharList['3'] = E_AUTHORIZATION_3;
	DeCodeCharList[E_AUTHORIZATION_s3]  = '#';
	CodeCharList['#'] = E_AUTHORIZATION_s3;
	DeCodeCharList[E_AUTHORIZATION_C]  =  'C';
	CodeCharList['C'] = E_AUTHORIZATION_C;
	DeCodeCharList[E_AUTHORIZATION_c]  = 'c';
	CodeCharList['c'] = E_AUTHORIZATION_c;
	DeCodeCharList[E_AUTHORIZATION_I]  =  'I';
	CodeCharList['I'] = E_AUTHORIZATION_I;
	DeCodeCharList[E_AUTHORIZATION_i]  = 'i';
	CodeCharList['i'] = E_AUTHORIZATION_i;
	DeCodeCharList[E_AUTHORIZATION_Z] =  'Z';
	CodeCharList['Z'] = E_AUTHORIZATION_Z;
	DeCodeCharList[E_AUTHORIZATION_z]  = 'z';
	CodeCharList['z'] = E_AUTHORIZATION_z;
	DeCodeCharList[E_AUTHORIZATION_0] =  '0';
	CodeCharList['0'] = E_AUTHORIZATION_0;
	DeCodeCharList[E_AUTHORIZATION_s0]  = ')';
	CodeCharList[')'] = E_AUTHORIZATION_s0;	
	DeCodeCharList[E_AUTHORIZATION_O]  =  'O';
	CodeCharList['O'] = E_AUTHORIZATION_O;
	DeCodeCharList[E_AUTHORIZATION_o]  = 'o';
	CodeCharList['o'] = E_AUTHORIZATION_o;
	DeCodeCharList[E_AUTHORIZATION_1] =  '1';
	CodeCharList['1'] = E_AUTHORIZATION_1;
	DeCodeCharList[E_AUTHORIZATION_s1]  = '!';
	CodeCharList['!'] = E_AUTHORIZATION_s1;
	DeCodeCharList[E_AUTHORIZATION_5] =  '5';
	CodeCharList['5'] = E_AUTHORIZATION_5;
	DeCodeCharList[E_AUTHORIZATION_s5]  = '%';
	CodeCharList['%'] = E_AUTHORIZATION_s5;
	DeCodeCharList[E_AUTHORIZATION_K]  = 'K';
	CodeCharList['K'] = E_AUTHORIZATION_K;
	DeCodeCharList[E_AUTHORIZATION_k]  = 'k';
	CodeCharList['k'] = E_AUTHORIZATION_k;
	DeCodeCharList[E_AUTHORIZATION_B]  =  'B';
	CodeCharList['B'] = E_AUTHORIZATION_B;
	DeCodeCharList[E_AUTHORIZATION_b]  = 'b';
	CodeCharList['b'] = E_AUTHORIZATION_b;
	DeCodeCharList[E_AUTHORIZATION_L]  =  'L';
	CodeCharList['L'] = E_AUTHORIZATION_L;
	DeCodeCharList[E_AUTHORIZATION_l]  = 'l';
	CodeCharList['l'] = E_AUTHORIZATION_l;
	DeCodeCharList[E_AUTHORIZATION_N]  =  'N';
	CodeCharList['N'] = E_AUTHORIZATION_N;
	DeCodeCharList[E_AUTHORIZATION_n]  = 'n';
	CodeCharList['n'] = E_AUTHORIZATION_n;
	DeCodeCharList[E_AUTHORIZATION_V]  =  'V';
	CodeCharList['V'] = E_AUTHORIZATION_V;
	DeCodeCharList[E_AUTHORIZATION_v]  = 'v';
	CodeCharList['v'] = E_AUTHORIZATION_v;
	DeCodeCharList[E_AUTHORIZATION_8] =  '8';
	CodeCharList['8'] = E_AUTHORIZATION_8;
	DeCodeCharList[E_AUTHORIZATION_s8]  = '*';
	CodeCharList['*'] = E_AUTHORIZATION_s8;
	DeCodeCharList[E_AUTHORIZATION_9] =  '9';
	CodeCharList['9'] = E_AUTHORIZATION_9;
	DeCodeCharList[E_AUTHORIZATION_s9]  = '(';
	CodeCharList['('] = E_AUTHORIZATION_s9;
	DeCodeCharList[E_AUTHORIZATION_P]  =  'P';
	CodeCharList['P'] = E_AUTHORIZATION_P;
	DeCodeCharList[E_AUTHORIZATION_p]  = 'p';
	CodeCharList['p'] = E_AUTHORIZATION_p;
	DeCodeCharList[E_AUTHORIZATION_Q]  =  'Q';
	CodeCharList['Q'] = E_AUTHORIZATION_Q;
	DeCodeCharList[E_AUTHORIZATION_q]  = 'q';
	CodeCharList['q'] = E_AUTHORIZATION_q;
	DeCodeCharList[E_AUTHORIZATION_M]  =  'M';
	CodeCharList['M'] = E_AUTHORIZATION_M;
	DeCodeCharList[E_AUTHORIZATION_m]  = 'm';
	CodeCharList['m'] = E_AUTHORIZATION_m;
	DeCodeCharList[E_AUTHORIZATION_F]  =  'F';
	CodeCharList['F'] = E_AUTHORIZATION_F;
	DeCodeCharList[E_AUTHORIZATION_f]  = 'f';
	CodeCharList['f'] = E_AUTHORIZATION_f;
	DeCodeCharList[E_AUTHORIZATION_D]  =  'D';
	CodeCharList['D'] = E_AUTHORIZATION_D;
	DeCodeCharList[E_AUTHORIZATION_d]  = 'd';
	CodeCharList['d'] = E_AUTHORIZATION_d;
	DeCodeCharList[E_AUTHORIZATION_E]  =  'E';
	CodeCharList['E'] = E_AUTHORIZATION_E;
	DeCodeCharList[E_AUTHORIZATION_e]  = 'e';
	CodeCharList['e'] = E_AUTHORIZATION_e;
	DeCodeCharList[E_AUTHORIZATION_H]  =  'H';
	CodeCharList['H'] = E_AUTHORIZATION_H;
	DeCodeCharList[E_AUTHORIZATION_h]  = 'h';
	CodeCharList['h'] = E_AUTHORIZATION_h;
	DeCodeCharList[E_AUTHORIZATION_R]  = 'R';
	CodeCharList['R'] = E_AUTHORIZATION_R;
	DeCodeCharList[E_AUTHORIZATION_r]  = 'r';
	CodeCharList['r'] = E_AUTHORIZATION_r;
	DeCodeCharList[E_AUTHORIZATION_T]  =  'T';
	CodeCharList['T'] = E_AUTHORIZATION_T;
	DeCodeCharList[E_AUTHORIZATION_t]  = 't';
	CodeCharList['t'] = E_AUTHORIZATION_t;
	DeCodeCharList[E_AUTHORIZATION_U]  =  'U';
	CodeCharList['U'] = E_AUTHORIZATION_U;
	DeCodeCharList[E_AUTHORIZATION_u]  = 'u';
	CodeCharList['u'] = E_AUTHORIZATION_u;
	DeCodeCharList[E_AUTHORIZATION_W] =  'W';
	CodeCharList['W'] = E_AUTHORIZATION_W;
	DeCodeCharList[E_AUTHORIZATION_w]  = 'w';
	CodeCharList['w'] = E_AUTHORIZATION_w;
	DeCodeCharList[E_AUTHORIZATION_X] =  'X';
	CodeCharList['X'] = E_AUTHORIZATION_X;
	DeCodeCharList[E_AUTHORIZATION_x]  = 'x';
	CodeCharList['x'] = E_AUTHORIZATION_x;
	DeCodeCharList[E_AUTHORIZATION_Y] =  'Y';
	CodeCharList['Y'] = E_AUTHORIZATION_Y;
	DeCodeCharList[E_AUTHORIZATION_y]  = 'y';
	CodeCharList['y'] = E_AUTHORIZATION_y;
	DeCodeCharList[E_AUTHORIZATION_J]  =  'J';
	CodeCharList['J'] = E_AUTHORIZATION_J;
	DeCodeCharList[E_AUTHORIZATION_j]  = 'j';
	CodeCharList['j'] = E_AUTHORIZATION_j;
	DeCodeCharList[E_AUTHORIZATION_2] =  '2';
	CodeCharList['2'] = E_AUTHORIZATION_2;
	DeCodeCharList[E_AUTHORIZATION_s2]  = '@';
	CodeCharList['@'] = E_AUTHORIZATION_s2;
	DeCodeCharList[E_AUTHORIZATION_4] =  '4';
	CodeCharList['4'] = E_AUTHORIZATION_4;
	DeCodeCharList[E_AUTHORIZATION_s4]  = '$';
	CodeCharList['$'] = E_AUTHORIZATION_s4;
	DeCodeCharList[E_AUTHORIZATION_6] =  '6'; 
	CodeCharList['6'] = E_AUTHORIZATION_6;
	DeCodeCharList[E_AUTHORIZATION_s6]  = '^';
	CodeCharList['^'] = E_AUTHORIZATION_s6;
	DeCodeCharList[E_AUTHORIZATION_7] =  '7';
	CodeCharList['7'] = E_AUTHORIZATION_7;
	DeCodeCharList[E_AUTHORIZATION_s7]  = '&';
	CodeCharList['&'] = E_AUTHORIZATION_s7;
	DeCodeCharList[E_AUTHORIZATION_G]  =  'G';
	CodeCharList['G'] = E_AUTHORIZATION_G;
	DeCodeCharList[E_AUTHORIZATION_g]  = 'g';
	CodeCharList['g'] = E_AUTHORIZATION_g;
	DeCodeCharList[E_AUTHORIZATION_S]  =  'S';
	CodeCharList['S'] = E_AUTHORIZATION_S;
	DeCodeCharList[E_AUTHORIZATION_s]  = 's';
	CodeCharList['s'] = E_AUTHORIZATION_s;
	DeCodeCharList[E_AUTHORIZATION__]  =  ' ';
	CodeCharList[' '] = E_AUTHORIZATION__;
	DeCodeCharList[E_AUTHORIZATION_COMMA] = ',';
	CodeCharList[','] = E_AUTHORIZATION_COMMA;
	DeCodeCharList[E_AUTHORIZATION_DOT]  = '.';
	CodeCharList['.'] = E_AUTHORIZATION_DOT;
	DeCodeCharList[E_AUTHORIZATION_MARK] = '?';
	CodeCharList['?'] = E_AUTHORIZATION_MARK;
	DeCodeCharList[E_AUTHORIZATION_BS]   = '\\';
	CodeCharList['\\'] = E_AUTHORIZATION_BS;
	DeCodeCharList[E_AUTHORIZATION_FS]   = '/';
	CodeCharList['/'] = E_AUTHORIZATION_FS;

	DeCodeCharList[E_AUTHORIZATION_CR] = '\r';
	CodeCharList['\r'] = E_AUTHORIZATION_CR;

	DeCodeCharList[E_AUTHORIZATION_LF] = '\n';
	CodeCharList['\n'] = E_AUTHORIZATION_LF;

	DeCodeCharList[E_AUTHORIZATION_QUOTE] = '\"';
	CodeCharList['\"'] = E_AUTHORIZATION_QUOTE;

	DeCodeCharList[E_AUTHORIZATION_COLON] = ':';
	CodeCharList[':'] = E_AUTHORIZATION_COLON;

	DeCodeCharList[E_AUTHORIZATION___]  = '-';
	CodeCharList['-'] = E_AUTHORIZATION___;

	DeCodeCharList[E_AUTHORIZATION_APOS] = '\'';
	CodeCharList['\''] = E_AUTHORIZATION_APOS;

	CodedStringList[E_AUTHORIZATION_INVALID].CIntList.SetSize(21);
	CodedStringList[E_AUTHORIZATION_INVALID].CIntList[0] = E_AUTHORIZATION_I;
	CodedStringList[E_AUTHORIZATION_INVALID].CIntList[1] = E_AUTHORIZATION_N;
	CodedStringList[E_AUTHORIZATION_INVALID].CIntList[2] = E_AUTHORIZATION_V;
	CodedStringList[E_AUTHORIZATION_INVALID].CIntList[3] = E_AUTHORIZATION_A;
	CodedStringList[E_AUTHORIZATION_INVALID].CIntList[4] = E_AUTHORIZATION_L;
	CodedStringList[E_AUTHORIZATION_INVALID].CIntList[5] = E_AUTHORIZATION_I;
	CodedStringList[E_AUTHORIZATION_INVALID].CIntList[6] = E_AUTHORIZATION_D;
	CodedStringList[E_AUTHORIZATION_INVALID].CIntList[7] = E_AUTHORIZATION__;
	CodedStringList[E_AUTHORIZATION_INVALID].CIntList[8] = E_AUTHORIZATION_A;
	CodedStringList[E_AUTHORIZATION_INVALID].CIntList[9] = E_AUTHORIZATION_U;
	CodedStringList[E_AUTHORIZATION_INVALID].CIntList[10] = E_AUTHORIZATION_T;
	CodedStringList[E_AUTHORIZATION_INVALID].CIntList[11] = E_AUTHORIZATION_H;
	CodedStringList[E_AUTHORIZATION_INVALID].CIntList[12] = E_AUTHORIZATION_O;
	CodedStringList[E_AUTHORIZATION_INVALID].CIntList[13] = E_AUTHORIZATION_R;
	CodedStringList[E_AUTHORIZATION_INVALID].CIntList[14] = E_AUTHORIZATION_I;
	CodedStringList[E_AUTHORIZATION_INVALID].CIntList[15] = E_AUTHORIZATION_Z;
	CodedStringList[E_AUTHORIZATION_INVALID].CIntList[16] = E_AUTHORIZATION_A;
	CodedStringList[E_AUTHORIZATION_INVALID].CIntList[17] = E_AUTHORIZATION_T;
	CodedStringList[E_AUTHORIZATION_INVALID].CIntList[18] = E_AUTHORIZATION_I;
	CodedStringList[E_AUTHORIZATION_INVALID].CIntList[19] = E_AUTHORIZATION_O;
	CodedStringList[E_AUTHORIZATION_INVALID].CIntList[20] = E_AUTHORIZATION_N;

}

TCAuthorization::TCAuthorization(TCAuthorization &CAuthorization)
{
	*this = CAuthorization;
}
TCAuthorization::~TCAuthorization(void)
{

}

void TCAuthorization::Serialize(CArchive& CArchiveFile)
{
	CObject::Serialize(CArchiveFile);

	int p, count;

	if(CArchiveFile.IsStoring())
	{
		CArchiveFile << m_authorized2;
		CArchiveFile << m_build_type;

		count = CodedStringList.GetSize();

		CArchiveFile << count;

		CArchiveFile << m_authorized;

		for(p = 0; p < count; p++) CodedStringList[p].Serialize(CArchiveFile);

		CArchiveFile << m_not_authorized1;
		CArchiveFile << m_build_type2;
		CArchiveFile << timeout;
		CArchiveFile << CTimeStamp;
	}
	else
	{
		CArchiveFile >> m_authorized2;
		CArchiveFile >> m_build_type;

		CArchiveFile >> count;
		CArchiveFile >> m_authorized;

		CodedStringList.SetSize(count);

		for(p = 0; p < count; p++) CodedStringList[p].Serialize(CArchiveFile);
	
		CArchiveFile >> m_not_authorized1;

		CArchiveFile >> m_build_type2;
		CArchiveFile >> timeout;
		CArchiveFile >> CTimeStamp;
	}
}

void TCAuthorization::operator = (TCAuthorization &CAuthorization)
{
	CAuthorization;
}

CString TCAuthorization::GetString(int string_id)
{ 
	if(string_id < 0) return "";
	if(!(string_id < CodedStringList.GetSize())) return "";

	CString CText;

	int count = CodedStringList[string_id].CIntList.GetSize();

	for(int p = 0; p < count; p++)
	{
		CText += DeCodeCharList[CodedStringList[string_id].CIntList[p]];
	}

	return CText;
}

bool TCAuthorization::Verify(void)
{
	CString CText;

	CText = GetProgramDirectory();

	CText += CPasswordFilename;

	if(!Load(CText)) 
	{
		AfxMessageBox(IDS_UNABLE_TO_FIND_PWD_FILE);

		return false;
	}

	if(!Check())
	{
		AfxMessageBox(IDS_INVALID_PASSWORD_FILE);

		return false;
	}
 
#ifndef RELEASE_OEM1
	ShowLicenceAgreement();
#endif

	return true;
}

bool TCAuthorization::VerifyAtNetList(void)
{
	CString CText;

	CText = GetProgramDirectory();

	CText += CPasswordFilename;

	if(!Load(CText)) 
	{
		AfxMessageBox(IDS_UNABLE_TO_FIND_PWD_FILE);

		// irritate the fuck out of them

		ShowLicenceAgreementAtRunNetList();

		AfxGetApp()->ExitInstance();// get the fuck out

		return false;
	}

	if(!Check())// irritate the fuck out of them
	{
		AfxMessageBox(IDS_INVALID_PASSWORD_FILE);

		ShowLicenceAgreementAtRunNetList();

		HDCMSrcCmp = NULL;

		return false;
	}

	if(m_build_type == E_DEMO_RELEASE)
	{
		ShowLicenceAgreementAtRunNetList();
	}

	if(varify_at_netlist1 != 3*2) 
	{
		ASSERT(0);

		return false;
	}

	return true;
}

bool TCAuthorization::ShowLicenceAgreement(void)
{
	TCAuthorizationDlg CAuthorizationDlg;

	CAuthorizationDlg.CMAuthorization = GetCopyRightNotice();

	CAuthorizationDlg.DoModal();

	return true;
}

bool TCAuthorization::ShowLicenceAgreementAtRunNetList(void)
{
	TCAuthorizationDlg CAuthorizationDlg;

	CAuthorizationDlg.CMAuthorization = GetCopyRightNotice();

	CAuthorizationDlg.DoModal();

	return true;
}

bool TCAuthorization::Load(CString CFileName)
{
	return LoadGenericFromArchive(this, CFileName);
}

bool TCAuthorization::Save(CString CFileName)
{
	return SaveGenericToArchive(this, CFileName);
}

bool TCAuthorization::Save(void)
{
	CString CText;

	CText = GetProgramDirectory();

	CText += CPasswordFilename;

	return Save(CText);
}

bool TCAuthorization::LoadText(CString CFileName)
{
	return true;
}

bool TCAuthorization::Check(void)
{
	if(m_build_type2 != m_build_type) return false;// invalid password file

	if(PasswordExpired()) return false;

#ifdef OEM_PASSWORD				//timeout files only for the password generator
	if(!timeout) return false;  // dont allow normal SS pwd files to be used
	if(m_build_type != E_FULL_PASSWORD_GENERATOR) return false;
	if(timeout != m_magic_nmber + 5773) return false;
#endif

	CUserRegistrationExeId;

	CMPassWord = DeCodeString(E_AUTHORIZATION_REGISTRATIONID);// read data from password file

	strcpy(CUserRegistrationExeId, CMPassWord);
 
	CMPassWord = GetDriveSerialNumberLast5Digits();

	int check = 2*1;

	if(m_build_type == E_DEMO_RELEASE && m_build_type2 == E_DEMO_RELEASE) 
	{
		CMPassWord = "TRIAL";

		varify_at_netlist1 = 3*check;
		varify_at_netlist2 = 4*check;

		return true;
	}
	
	//Gets data from CUserRegistrationExeId
	if(CMPassWord != GetLastPasswordWord()) 
	{
		if(GetLastPasswordWord() == GetMasterPassword1()) 
		{
			varify_at_netlist1 = 3*check;
			varify_at_netlist2 = 4*check;

			return true;// My Master key password file
		}
		else if(GetLastPasswordWord() == GetMasterPasswordStudent1())
		{
			varify_at_netlist1 = 3*check;
			varify_at_netlist2 = 4*check;

			return true;
		}
		else if(GetLastPasswordWord() == GetMasterPassword64Bit())
		{
			varify_at_netlist1 = 3*check;
			varify_at_netlist2 = 4*check;

			return true;
		}


		return false;
	}

	bool flag = false;

	if(E_DEMO_RELEASE				== m_build_type2) flag = true;
	if(E_FULL_RELEASE_STUDENT		== m_build_type2) flag = true;
	if(E_FULL_RELEASE_PROFESSONAL	== m_build_type2) flag = true;
	if(E_FULL_RELEASE_GOLD			== m_build_type2) flag = true;
	if(E_RESTRICTED_RELEASE_STUDENT	== m_build_type2) flag = true;
	if(E_AUTHORIZATION_MASTER_PASSWORD_STUDENT	== m_build_type2) flag = true;
	if(E_FULL_RELEASE_GOLD_64BIT	== m_build_type2) flag = true;

	if(!flag) HDCMSrcCmp = NULL;

	varify_at_netlist1 = 3*check;
	varify_at_netlist2 = 4*check;

	if(CMPassWord != GetLastPasswordWord()) // first bypassed
	{
		ASSERT(0);// debug testing

		if(GetLastPasswordWord() == GetMasterPassword2()) return true;// My Master key password file

		HDCMSrcCmp	= NULL;
		HDCMDestCmp = NULL;

		return true;
	}

	return true;
}
   
CString TCAuthorization::GetMasterPassword1(void)
{
	CString CText ;

	CText = DeCodeString(E_AUTHORIZATION_MASTER_PASSWORD);

	CText.MakeUpper();

	CText = CText.Left(36/3); // version 2.xx

	CText = CText.Right(20/2);

	return CText;
}

CString TCAuthorization::GetMasterPassword64Bit(void)
{
	CString CText ;

	CText = DeCodeString(E_AUTHORIZATION_MASTER_PASSWORD_64BIT);

	CText.MakeUpper();

	CText = CText.Left(36/3); 

	CText = CText.Right(20/2);

	return CText;
}

CString TCAuthorization::GetMasterPassword2(void)
{
	CString CText;
	
	CText = DeCodeString(E_AUTHORIZATION_MASTER_PASSWORD);

	CText.MakeUpper();

	CText = CText.Left(36/3); // version 2.xx

	CText = CText.Right(20/2);

	return CText;
}

CString TCAuthorization::GetMasterPasswordStudent1(void)
{
	CString CText;

	CText = DeCodeString(E_AUTHORIZATION_MASTER_PASSWORD_STUDENT);

	CText.MakeUpper();

	CText = CText.Left(36/3); // version 2.xx

	CText = CText.Right(20/2);

	return CText;
}

CString TCAuthorization::GetMasterPasswordStudent2(void)
{
	CString CText;

	CText = DeCodeString(E_AUTHORIZATION_MASTER_PASSWORD_STUDENT);

	CText.MakeUpper();

	CText = CText.Left(36/3); // version 2.xx

	CText = CText.Right(20/2);

	return CText;
}

void TCAuthorization::Setup(void)
{
	CodedStringList.SetSize(E_AUTHORIZATION_CODES_MAX);
	CodeCharList.SetSize(256);

	GenerateCodeTest();

#ifdef _DEBUG
//	CodeString(E_AUTHORIZATION_MASTER_PASSWORD, "!?81472id2Q");
		
// version 2.xx
	CodeString(E_AUTHORIZATION_MASTER_PASSWORD, "!?9172411657id2Q");
	CodeString(E_AUTHORIZATION_MASTER_PASSWORD_STUDENT, "!?8431782563id2Q");
	CodeString(E_AUTHORIZATION_MASTER_PASSWORD_64BIT, "!?7383946718id2Q");

#endif
}
 
void TCAuthorization::GeneratePassword(CString CUserData, CString CProductID, int type)
{	
	m_authorized		= true;
	m_authorized2		= true;
	m_not_authorized1	= false;
	m_build_type		= type;
	m_build_type2		= type;

	CProductID = CUserData +  CProductID;

	if(type == E_DEMO_RELEASE) CProductID = "TRIAL";

	strcpy(CUserRegistrationExeId, CProductID);// only product id is checked

	CodeString(E_AUTHORIZATION_REGISTRATIONID, CUserRegistrationExeId);
}

CString TCAuthorization::GetLastPasswordWord(void)
{
	CString CText;

	CText = CUserRegistrationExeId;

	if(CText == "") return "";

	CText = CText.Right(10);

	return CText;
}

CString TCAuthorization::GetCopyRightNotice(void)
{
	CString CText;

	CText = DeCodeString(E_AUTHORIZATION_COPYRIGHT);

	int length = CText.GetLength();

	if(CText.GetAt(length - 1) != '#') return CText;// this character has never been generated

	CText = CText.Left(length - 16);// remove the randam data.

	return CText;
}

void TCAuthorization::CreateCodedCopyRightNotice(CString CText)
{
	CString CAddedText = "123456789abcdef#";// Stuff some randam data into the file

	int i_char;
	char c_char;

	srand((unsigned)time(NULL));

	for(int p = 0; p < 15; p++)
	{
		while(!(i_char = (rand()*64)/RAND_MAX));
	
		c_char = (char) i_char;

		CAddedText.SetAt(p, c_char);
	}

	CText = CText + CAddedText;

	CodeString(E_AUTHORIZATION_COPYRIGHT, CText);
}

CString TCAuthorization::GetRegistrationId(void)
{
	return DeCodeString(E_AUTHORIZATION_REGISTRATIONID);
}

void TCAuthorization::CreatePasswordFile(TCPasswordData &CPasswordData)
{

#ifndef GENERATE_PASSWORD
	timeout = CPasswordData.timeout;
#else
		if(!VerifyAtNetList()) return;// ensure pc clock has not been reset after bootup
#endif

	GeneratePassword(CPasswordData.CUserData, CPasswordData.CProductID, CPasswordData.type);
	CreateCodedCopyRightNotice(CPasswordData.CCoprightNotice);

	CTimeStamp = CPasswordData.CTimeStamp;
}

bool TCAuthorization::PasswordExpired(void)
{
	if(!timeout) return false; // no time lockout for SS

	time_t	s_current_time;

	time(&s_current_time);

	CTime CCurrentTime(s_current_time);

	CTime CTestTime(CTimeStamp);

	int now_year = CCurrentTime.GetYear();
	int password_year = CTestTime.GetYear();
	int now_month = CCurrentTime.GetMonth();
	int password_month = CTestTime.GetMonth();

#ifdef GENERATE_PASSWORD
	if(now_year > 2000 + 6) return true;					// hard code the program itself to expire
	if(now_year > 2000 + 5 && now_month > 50/10) return true;	// hard code the program itself to expire
#endif

	if(now_year > password_year + 1) return true;

	if(now_year > password_year && now_month > password_month) return true;

	return false;
}