
#ifndef _TCAuthorization_H
#define _TCAuthorization_H

#include <afxtempl.h>
 
enum TE_AUTHORIZATION_NUMBER
{
	E_AUTHORIZATION_INVALID = 0,
	E_AUTHORIZATION_COPYRIGHT,
	E_AUTHORIZATION_REGISTRATIONID,
	E_AUTHORIZATION_SUPERSPICE,
	E_AUTHORIZATION_SUPERSPICEPWD,
	E_AUTHORIZATION_MASTER_PASSWORD,
	E_AUTHORIZATION_MASTER_PASSWORD_STUDENT,
	E_AUTHORIZATION_PASSWORD_GENERATOR,
	E_AUTHORIZATION_MASTER_PASSWORD_64BIT,

	E_AUTHORIZATION_NUBER_OF

};

enum TE_AUTHORIZATION_CODES
{
	E_AUTHORIZATION_A = 11,
	E_AUTHORIZATION_a = 12,
	E_AUTHORIZATION_B = 26,
	E_AUTHORIZATION_b = 27,
	E_AUTHORIZATION_E = 137,
	E_AUTHORIZATION_e = 138,
	E_AUTHORIZATION_F = 753,
	E_AUTHORIZATION_f = 754,
	E_AUTHORIZATION_G = 400,
	E_AUTHORIZATION_g = 401,
	E_AUTHORIZATION_L = 49,
	E_AUTHORIZATION_l = 50,
	E_AUTHORIZATION_M = 755,
	E_AUTHORIZATION_m = 756,
	E_AUTHORIZATION_N = 882,
	E_AUTHORIZATION_n = 883,
	E_AUTHORIZATION_H = 505,
	E_AUTHORIZATION_h = 503,
	E_AUTHORIZATION_I = 799,
	E_AUTHORIZATION_i = 800,
	E_AUTHORIZATION_J = 375,
	E_AUTHORIZATION_j = 376,
	E_AUTHORIZATION_K = 885,
	E_AUTHORIZATION_k = 884,
	E_AUTHORIZATION_T = 38,
	E_AUTHORIZATION_t = 39,
	E_AUTHORIZATION_3 = 777,
	E_AUTHORIZATION_s3 = 778,
	E_AUTHORIZATION_P = 637,
	E_AUTHORIZATION_p = 658,
	E_AUTHORIZATION_9 = 638,
	E_AUTHORIZATION_V = 879,
	E_AUTHORIZATION_v = 801,
	E_AUTHORIZATION_W = 621,
	E_AUTHORIZATION_w = 622,
	E_AUTHORIZATION_X = 986,
	E_AUTHORIZATION_x = 987,
	E_AUTHORIZATION_Y = 258,
	E_AUTHORIZATION_y = 259,
	E_AUTHORIZATION_Z = 845,
	E_AUTHORIZATION_z = 846,
	E_AUTHORIZATION_0 = 1014,
	E_AUTHORIZATION_s0 = 1015,
	E_AUTHORIZATION_O = 327,
	E_AUTHORIZATION_o = 328,
	E_AUTHORIZATION_R = 501,
	E_AUTHORIZATION_r = 502,
	E_AUTHORIZATION_4 = 103,
	E_AUTHORIZATION_s4 = 104,
	E_AUTHORIZATION_S = 981,
	E_AUTHORIZATION_s = 982,
	E_AUTHORIZATION_5 = 147,
	E_AUTHORIZATION_s5 = 148,
	E_AUTHORIZATION_6 = 943,
	E_AUTHORIZATION_s6= 944,
	E_AUTHORIZATION_Q = 913,
	E_AUTHORIZATION_q = 914,
	E_AUTHORIZATION_U = 666,
	E_AUTHORIZATION_u = 667,
	E_AUTHORIZATION_1 = 483,
	E_AUTHORIZATION_s1= 484,
	E_AUTHORIZATION_2 = 742,
	E_AUTHORIZATION_s2 = 743,
	E_AUTHORIZATION_C = 585,
	E_AUTHORIZATION_c = 586,
	E_AUTHORIZATION_D = 729,
	E_AUTHORIZATION_d = 730,
	E_AUTHORIZATION_7 = 499,
	E_AUTHORIZATION_s7=500,
	E_AUTHORIZATION_8 = 589,
	E_AUTHORIZATION_s8 = 590,
	E_AUTHORIZATION_s9 = 1017,
	E_AUTHORIZATION__ = 485,
	E_AUTHORIZATION_COMMA = 922,
	E_AUTHORIZATION_DOT = 927,
	E_AUTHORIZATION_MARK = 933,
	E_AUTHORIZATION_BS   = 938,
	E_AUTHORIZATION_FS   = 940,
	E_AUTHORIZATION_CR	= '\r',
	E_AUTHORIZATION_LF	= '\n',
	E_AUTHORIZATION_QUOTE = '\"',
	E_AUTHORIZATION_COLON = 1000,
	E_AUTHORIZATION___     = 403,// -
	E_AUTHORIZATION_APOS   = 835, 
 
 
	E_AUTHORIZATION_CODES_MAX = 1023
};

class TCPasswordData : public CObject
{
	public:	TCPasswordData(void);
			TCPasswordData(TCPasswordData &CPasswordData);
			~TCPasswordData(void);

			CString CCoprightNotice;
			CString CUserData;
			CString CProductID;
			CString CWindowsUserName;
			CString CCompany;
			int		type;
			int		timeout;
			CTime   CTimeStamp;

			void operator = (TCPasswordData &CPasswordData);
	
			void Serialize(CArchive& CArchiveFile);

			DECLARE_SERIAL(TCPasswordData)

};

class TCIntArray  : public CObject
{
	
	public:		TCIntArray(){};
				~TCIntArray(){};

				CArray <int, int>	CIntList;

				void Serialize(CArchive& CArchiveFile);

				DECLARE_SERIAL(TCIntArray)
};

enum TE_AUTHORIZATION_DEFFINES
{
	E_MAX_NUM_NET_LINES = 30,
	E_MAX_NUM_SUBCKT_NET_LINES = 25,
	E_MAX_NUM_NET_PAGES = 2,

};

enum TE_OEM_CODES
{
	E_OEM_SUPERSPICE = 0,
	E_OEM_ONE,
};

enum TE_BUILD_TYPE
{
	E_VALID_BUILD,
	E_DEMO_RELEASE				= 624,
	E_FULL_RELEASE_STUDENT		= 432,
	E_RESTRICTED_RELEASE_STUDENT= 673,
	E_FULL_RELEASE_PROFESSONAL	= 284,
	E_FULL_RELEASE_GOLD			= 747,
	E_FULL_RELEASE_STUDENT_GOLD	= 193,
	E_FULL_PASSWORD_GENERATOR   = 358,
	E_FULL_RELEASE_GOLD_64BIT	= 573,

};
 
class TCAuthorization : public CObject
{
	public:	TCAuthorization(void);
			TCAuthorization(TCAuthorization  &CAuthorization);
			~TCAuthorization(void);

			char	CUserRegistrationExeId[256];// this pointer is now known, bin replace directly in exe

			CArray <char, char>				DeCodeCharList;
			CArray <int, int>				CodeCharList;
			CArray <TCIntArray, TCIntArray>	CodedStringList;

			CTime   CTimeStamp;
			CString CPasswordFilename;

			int		m_build_type;
			int		m_authorized;
			int		m_build_type2;

			char	dummy[55];
			int		m_not_authorized1;
			char	dummy2[23];
			int		m_authorized2;
			CString CMPassWord;

			int		varify_at_netlist1;
			int		varify_at_netlist2;
			int		timeout;
			int		oem;
			int		m_magic_nmber;

			void operator = (TCAuthorization &CAuthorization);
	
			void Serialize(CArchive& CArchiveFile);

			bool Verify(void);
			bool VerifyAtNetList(void);
			bool ShowLicenceAgreement(void);
			bool ShowLicenceAgreementAtRunNetList(void);

			void GenerateCodeTest(void);
			void GenerateCode(void);
			int  Code(char CChar);
			void Setup(void);
 
			void CodeString(int id, CString CText);
			CString DeCodeString(int id);

			CString GetString(int string_id);

			bool Load(CString CFileName);
			bool LoadText(CString CFileName);
			bool Save(CString CFileName);
			bool Save(void);
			bool Check(void);

			CString GetCopyRightNotice(void);
			void	CreateCodedCopyRightNotice(CString CText);
			CString GetRegistrationId(void);
			void	GeneratePassword(CString CUserData, CString CProductID, int type);
			CString GetLastPasswordWord(void);
			CString GetMasterPassword1(void);
			CString GetMasterPassword2(void);
			CString GetMasterPassword64Bit(void);
			CString GetMasterPasswordStudent1(void);
			CString GetMasterPasswordStudent2(void);
			bool	PasswordExpired(void);


			void CreatePasswordFile(TCPasswordData &CPasswordData);

			DECLARE_SERIAL(TCAuthorization)

};

#endif