#include "stdafx.h"
#include <float.h>
#include "TDVersion.h"
#include "TEPropertyViewTypes.h"
#include "TCSuperSpiceDataBase.h"
#include "TCBillOfMaterials.h"
#include "TCReRuns.h"
#include "Equation.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

extern TCSuperSpiceDataBase GCSuperSpiceDataBase;
extern CString GSSWCFileName;
extern CString GSSWCModelName;

IMPLEMENT_SERIAL(TCBillOfMaterials, CObject, ID_VERSION_NUMBER)


TCBillOfMaterials::TCBillOfMaterials(void)
{
//		CMCRunType = "_XS";
}
TCBillOfMaterials::TCBillOfMaterials(TCBillOfMaterials &CBillOfMaterials)
{
	*this = CBillOfMaterials;
}
TCBillOfMaterials::~TCBillOfMaterials(void)
{

}

void TCBillOfMaterials::Serialize(CArchive& CArchiveFile)
{
	CObject::Serialize(CArchiveFile);

	if(CArchiveFile.IsStoring())
	{

	}
	else
	{

	}
}

void TCBillOfMaterials::operator = (TCBillOfMaterials &CBillOfMaterials)
{
	CRefDes			= CBillOfMaterials.CRefDes;
	CModelName		= CBillOfMaterials.CModelName;
	CModelType		= CBillOfMaterials.CModelType;
	value			= CBillOfMaterials.value;
	CPackageName	= CBillOfMaterials.CPackageName;
	CModelFileName  = CBillOfMaterials.CModelFileName;
	CModelFilePath  = CBillOfMaterials.CModelFilePath;
	CSymbolParameters = CBillOfMaterials.CSymbolParameters;
	CMCRunType		= CBillOfMaterials.CMCRunType;

	property_view	= CBillOfMaterials.property_view;
	m_param_index	= CBillOfMaterials.m_param_index;
}

void TCBillOfMaterials::operator = (TCReRunData &CReRunData)
{
	CRefDes			= CReRunData.CRefDes;
	CModelName		= CReRunData.CModelName;
	value			= CReRunData.value;

}

bool TCBillOfMaterials::GetModelPointers(void)
{
	TCSpiceParameters *PCSpiceParameters;
	PCSpiceParametersMC = 0;
	PCSpiceParametersWC	= 0;

	TCSpiceParameters CSpiceParameters;

	CSpiceParameters.CDataBaseIdInfo.CRecordFileName = CModelFileName;
	CSpiceParameters.CDataBaseIdInfo.CRecordFilePath = CModelFilePath;
	CSpiceParameters.CDataBaseIdInfo.CRecordName	 = CModelName;
	CSpiceParameters.CSymbolParameters = CSymbolParameters;

	// Get pointer to the loaded main model
	PCSpiceParameters = GCSuperSpiceDataBase.CModelDataBase.GetPointer(CSpiceParameters);// The nominal model

	if(!PCSpiceParameters) return false;

	PCSpiceParameters->CSymbolParameters = CSymbolParameters;

	CSpiceParameters = *PCSpiceParameters;

	//Get the MC variance data for the nominal model
	PCSpiceParametersMC = GCSuperSpiceDataBase.CModelDataBase.GetWCMCModelPointer(CSpiceParameters, "_XN");

	if(!PCSpiceParametersMC ) return false;

	CSpiceParameters.CDataBaseIdInfo.CRecordFileName = CModelFileName;
	CSpiceParameters.CDataBaseIdInfo.CRecordFilePath = CModelFilePath;
	CSpiceParameters.CDataBaseIdInfo.CRecordName	 = CModelName;
	CSpiceParameters.CSymbolParameters = CSymbolParameters;

	CSpiceParameters.CDataBaseIdInfo.SetWCRecordName(CMCRunType);

	// Get the specific WC corner that MC varies about in order to get the correct name of MC spec file
	PCSpiceParametersWC = GCSuperSpiceDataBase.CModelDataBase.GetPointer(CSpiceParameters, true);

	if(!PCSpiceParametersWC) return false;

	CMCSpiceParametersMC = *PCSpiceParametersMC;

	CMSpiceParametersWC  = *PCSpiceParametersWC;

	return true;
}

bool TCBillOfMaterials::GetFirstParameter(CString &CParam, double &mean, double &sigma)
{
	if(!GetModelPointers()) return false;

	m_param_index = 0;

	return GetNextParameter(CParam, mean, sigma);
}

bool TCBillOfMaterials::GetNextParameter(CString &CParam, double &mean, double &sigma)
{
	if(!PCSpiceParametersMC) return false;
	if(!PCSpiceParametersWC) return false;

	double mc_value, wc_value;
	CString CValue, CValueText;
	CString CParamMC;
	CString CWCValue;

	int count = CMSpiceParametersWC.CData.GetSize();
	
	if(!count) return false;

	if(!(m_param_index < count)) return false;
	
	CParam = "";

	EquationSetVaribles(CSymbolParameters);

	for(int p = m_param_index;  p < count; p++)// Find MC data for WC corner
	{
		CParam = CMSpiceParametersWC.CData[p].CName;

		CParam.MakeLower();

		CParamMC =  CParam + "mc"; // Get the name of the MC spec to CParam

		if(!CMSpiceParametersWC.Get(CParam, &wc_value)) continue;

		if(!wc_value)
		{
			if(!CMSpiceParametersWC.GetString(CParam, &CValueText)) continue;

			if(CValueText == "") continue;
 
			if(!Equation(CValueText, &wc_value)) continue;
		}

		CWCValue.Format(" %s=%e ", CParam, wc_value);

		EquationSetVaribles(CWCValue);// So the wc mean can be used in the mc expression

		if(!CMCSpiceParametersMC.Get(CParamMC, &mc_value)) continue;

		if(!mc_value)
		{
			if(!CMCSpiceParametersMC.GetString(CParamMC, &CValueText)) continue;

			if(CValueText == "") continue;

			CValueText.MakeLower();//equation needs case insenitive data

			if(!Equation(CValueText, &mc_value)) continue;// evaluate the value of mc_value
		}

		mean = wc_value;

		sigma = mc_value; 

		m_param_index = p + 1; 

		return true;
	}

	return false;
}