#include "stdafx.h"
#include "resource.h"
#include "generic.h"
#include "TCSuperSpiceDataBase.h"
#include "TCSuperSpiceGlobalData.h"
#include "TCCircuitsTreeDoc.h"
#include "TCCircuitsTreeView.h"
#include "TCSuperSpiceDoc.h"
#include "TCModelSymbolTab.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

extern TCSuperSpiceGlobalData	GCSuperSpiceGlobalData;
extern TCSuperSpiceDataBase		GCSuperSpiceDataBase; 
extern CString GLastFileTreeFilesFile;
extern CString GLastFileTreeFiles;
extern TCModelSymbolTab CModelSymbolTab;

HTREEITEM InsertTreeItem(CTreeCtrl * ctrl,LPCTSTR txt,int imgind,int selimgind, int id);
HTREEITEM InsertTreeItem(CTreeCtrl * ctrl,HTREEITEM hTreeItem, LPCTSTR txt,int imgind,int selimgind, int id);

/////////////////////////////////////////////////////////////////////////////
// TCCircuitsTreeView

IMPLEMENT_DYNCREATE(TCCircuitsTreeView, CXTTreeView)

BEGIN_MESSAGE_MAP(TCCircuitsTreeView, CXTTreeView)
	//{{AFX_MSG_MAP(TCCircuitsTreeView)
	ON_WM_ERASEBKGND()
	ON_WM_PAINT()
	ON_WM_CREATE()
	ON_WM_NCHITTEST()
	ON_WM_CONTEXTMENU()
	//}}AFX_MSG_MAP
	// Standard printing commands

	ON_NOTIFY_REFLECT(NM_DBLCLK, OnDoubleClickTree) 
	ON_COMMAND(ID_REFRESH_TREE, Refresh)
	ON_COMMAND(ID_POPUP_REMOVEFROMLIST, EditDelete)
	ON_COMMAND(ID_POPUP_ADDFOLDER, AddFolder)
	ON_COMMAND(ID_POPUP_PROPERTIES, Properties)
	ON_WM_LBUTTONDOWN()
	ON_WM_RBUTTONDOWN()
	ON_COMMAND(ID_POPUP_PLACECIRCUIT, PlaceCircuit)
	ON_NOTIFY_REFLECT(TVN_BEGINDRAG, OnBeginDragDrop)

	
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// TCCircuitsTreeView construction/destruction

TCCircuitsTreeView::TCCircuitsTreeView()
{
	m_pTreeCtrl = &GetTreeCtrl();

	ASSERT(m_pTreeCtrl);

	hlast_saved_file = NULL;
	hlast_saved_item = NULL;
	f_last_file		 = false;	
	m_is_dragging	 = false;
}

TCCircuitsTreeView::~TCCircuitsTreeView()
{
	m_ImageList.DeleteImageList();
}

BOOL TCCircuitsTreeView::PreCreateWindow(CREATESTRUCT& cs)
{
	if( !CXTTreeView::PreCreateWindow( cs ))
		return FALSE;

	// Set the style for the tree control.
	cs.style |= TVS_HASBUTTONS|TVS_HASLINES|TVS_LINESATROOT;

	// TODO: Modify the Window class or styles here by modifying
	//  the CREATESTRUCT cs

	return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
// TCCircuitsTreeView drawing

void TCCircuitsTreeView::OnDraw(CDC* pDC)
{
	pDC;
	TCCircuitsTreeDoc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);
	// TODO: add draw code for native data here

}

void TCCircuitsTreeView::OnInitialUpdate()
{
	CXTTreeView::OnInitialUpdate();

	// TODO: You may populate your TreeView with items by directly accessing
	//  its tree control through a call to GetTreeCtrl().

}



/////////////////////////////////////////////////////////////////////////////
// TCCircuitsTreeView diagnostics

#ifdef _DEBUG
void TCCircuitsTreeView::AssertValid() const
{
	CXTTreeView::AssertValid();
}

void TCCircuitsTreeView::Dump(CDumpContext& dc) const
{
	CXTTreeView::Dump(dc);
}

TCCircuitsTreeDoc* TCCircuitsTreeView::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(TCCircuitsTreeDoc)));
	return (TCCircuitsTreeDoc*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// TCCircuitsTreeView message handlers

void TCCircuitsTreeView::OnUpdate(CView* pSender, LPARAM lHint, CObject* pHint) 
{
	pSender;
	lHint;
	pHint;
}

void TCCircuitsTreeView::UpdateView()
{

}

BOOL TCCircuitsTreeView::OnEraseBkgnd(CDC* pDC) 
{
	UNUSED_ALWAYS(pDC);
	return TRUE;
}

int TCCircuitsTreeView::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if (CXTTreeView::OnCreate(lpCreateStruct) == -1)
		return -1;

	CBitmap bitmap;

	m_ImageList.Create(23, 19, ILC_COLOR|ILC_MASK, 6, 4); 
	m_ImageList.SetBkColor(GetSysColor(COLOR_WINDOW));
	bitmap.LoadBitmap(IDB_TREENODES_CIRCUITS);
	m_ImageList.Add(&bitmap, (COLORREF)0xFFFFFF);
	m_pTreeCtrl->SetImageList(&m_ImageList, TVSIL_NORMAL);

	 
	UpdateView();

	return 0;
}

void TCCircuitsTreeView::OnRButtonDown(UINT nFlags, CPoint point)
{
nFlags;
	OnContextMenu(NULL, point);// XT messes up context menu handling
}

void TCCircuitsTreeView::OnContextMenu(CWnd*, CPoint point)
{
	CMenu menu;
	VERIFY(menu.LoadMenu(CG_IDR_POPUP_TREE_CIRCUIT));

	CMenu* pPopup = menu.GetSubMenu(0);
	ASSERT(pPopup != NULL);

	ClientToScreen(&point);// XT messes up context menu handling

	CWnd* pWndPopupOwner = this;
//	while (pWndPopupOwner->GetStyle() & WS_CHILD) // XT messes up context menu handling
//		pWndPopupOwner = pWndPopupOwner->GetParent(); // XT messes up context menu handling

	pPopup->TrackPopupMenu(TPM_LEFTALIGN | TPM_RIGHTBUTTON, point.x, point.y,pWndPopupOwner);
}

LRESULT TCCircuitsTreeView::OnNcHitTest(CPoint point) 
{
	UINT uFlag=0;

	if(!m_pTreeCtrl) return HTNOWHERE;
	if(!m_pTreeCtrl->m_hWnd) return HTNOWHERE;

	// Get the cursor location in client coordinates.
	CPoint pt = point;	
	ScreenToClient(&pt);

	// Get a pointer to the tooltip control.
	CToolTipCtrl* pCtrl = (CToolTipCtrl*)CWnd::FromHandle(
		(HWND)::SendMessage(m_hWnd, TVM_GETTOOLTIPS, 0, 0L));

	// If we have a valid tooltip pointer and the cursor
	// is over a tree item, the bring the tooltip control
	// to the top of the Z-order.
	if (pCtrl && m_pTreeCtrl->HitTest(pt, &uFlag)){
		pCtrl->SetWindowPos(&wndTop,0, 0, 0, 0,
			SWP_NOACTIVATE | SWP_NOSIZE |SWP_NOMOVE);
	}
	
	return CXTTreeView::OnNcHitTest(point);
}

void TCCircuitsTreeView::PlaceCircuit(void)
{
	CString CFileName = GetCircuitName();

	if(CFileName =="") return;

	CString CFileFolderName = GetFileName();

	if(CFileFolderName == "") return;

	CFileName += ".scl";

	if(GCSuperSpiceDataBase.PlaceCircuit(CFileFolderName, CFileName)) return;

	CString Msg;

	Msg.LoadString(IDS_CANTFIND_CKT);

	Msg += ' ' + CFileFolderName +'\\' + CFileName;

	AfxMessageBox(Msg);

	return;
}

void TCCircuitsTreeView::OnDoubleClickTree(NMHDR * pNMHDR, LRESULT* pResult)
{
	*pResult = 0;

	pNMHDR;

	DWORD				dwpos;
	TV_HITTESTINFO		tvhti;
	HTREEITEM           htiItemClicked, hparent;
	POINT				point;
	int					id;

	dwpos = GetMessagePos();
	point.x = LOWORD(dwpos);
	point.y = HIWORD(dwpos);

	::MapWindowPoints(HWND_DESKTOP, m_hWnd, &point, 1);

	tvhti.pt = point;

	htiItemClicked = m_pTreeCtrl->HitTest(&tvhti);

	if(!htiItemClicked) return;

	hparent = m_pTreeCtrl->GetParentItem(htiItemClicked);

	if(!hparent) return;

	if(!(tvhti.flags & (TVHT_ONITEMLABEL | TVHT_ONITEMICON))) return;

	CString CFileName = m_pTreeCtrl->GetItemText(htiItemClicked);

	if(CFileName == "") return;

	id = m_pTreeCtrl->GetItemData(htiItemClicked);

	if(id < 0) return; 

	id = CFileID.GetPageIndex(id);

	if(id < 0) return;

	id = m_pTreeCtrl->GetItemData(hparent);

	if(id < 0) return; 

	id = CFileID.GetPageIndex(id);

	if(id < 0) return;

	CString CFileFolderName = CFileID.CPageIdData[id].CPageTitle;

	if(CFileFolderName == "") return;

	CFileName += ".scl";

	if(GCSuperSpiceDataBase.PlaceCircuit(CFileFolderName, CFileName)) return;

	CString Msg;

	Msg.LoadString(IDS_CANTFIND_CKT);

	Msg += ' ' + CFileFolderName +'\\' + CFileName;

	AfxMessageBox(Msg);
}

void TCCircuitsTreeView::UpdateAllData(void)
{
	int count, p, q, cir_count;

	CString CCircuitsFileName, CCCircuitName;

	HTREEITEM	hTI = NULL, htmp = NULL;

	CArray <TCCircuitsDataBaseData, TCCircuitsDataBaseData &> &CFiles = GCSuperSpiceDataBase.CCircuitsDataBase.CFileList;
	
	count = CFiles.GetSize();

	if(!count) return;

	int id;

	for(p = 0; p < count; p++)
	{
		id = CFileID.GetNewPageId("");

		int index_id = CFileID.GetPageIndex(id);

		if(index_id < 0) return;

		CFileID.CPageIdData[index_id].CPageTitle = CFiles[p].CPath + CFiles[p].CName;

		hTI = InsertTreeItem(m_pTreeCtrl, CFiles[p].CName,0,1, id);

		CFiles[p].HTreeItem = hTI;

		TCCircuitsDataBaseData &CCirList = CFiles[p];

		cir_count = CCirList.CCircuitNameList.GetSize();

		for(q = 0; q < cir_count; q++)
		{
			htmp = InsertTreeItem(m_pTreeCtrl, hTI, CCirList.CCircuitNameList[q].CName,2,3, 0);

			CCirList.CCircuitNameList[q].HTreeItem = htmp;
		}

		m_pTreeCtrl->SelectItem(hTI);// force a redraw
	}
}

bool TCCircuitsTreeView::AddCircuitsFolder(int index)
{
	int count, q;

	HTREEITEM	hTI = NULL, htmp = NULL;

	CArray <TCCircuitsDataBaseData, TCCircuitsDataBaseData &> &CFiles = GCSuperSpiceDataBase.CCircuitsDataBase.CFileList;
	
	count = CFiles.GetSize();

	if(!count) return false;
	if(!(index < count)) return false;
	if(index < 0) return false;

	int id = CFileID.GetNewPageId("");

	int index_id = CFileID.GetPageIndex(id);

	if(index_id < 0) return false;

	id = CFileID.GetNewPageId("");

	TCCircuitsDataBaseData &CCirList = CFiles[index];

	CFileID.CPageIdData[index_id].CPageTitle = CCirList.CPath + CCirList.CName;

	hTI = InsertTreeItem(m_pTreeCtrl, CCirList.CName,0,1, id);

	CCirList.HTreeItem = hTI;

	int cir_count = CCirList.CCircuitNameList.GetSize();

	for(q = 0; q < cir_count; q++)
	{
		htmp = InsertTreeItem(m_pTreeCtrl, hTI, CCirList.CCircuitNameList[q].CName,2,3, 0);

		CCirList.CCircuitNameList[q].HTreeItem = htmp;
	}

	m_pTreeCtrl->SelectItem(hTI);// force a redraw

	return true;
}

void TCCircuitsTreeView::Refresh(void)
{
	ASSERT(m_pTreeCtrl);

	m_pTreeCtrl->DeleteAllItems();

	CFileID.Clear();

	GCSuperSpiceDataBase.CCircuitsDataBase.Load();//Get curent direvtory information

	UpdateAllData();
}

void TCCircuitsTreeView::AddFolder(void)
{
	CString CFileName;

	CFileDialog	CLoadFileDialog(true, "scl", "Select any file to select this directory", 0,"SuperSpice Circuit Files  (*.scl)| *.scl||");

	if(CLoadFileDialog.DoModal() != IDOK)
	{
		CFileName = CLoadFileDialog.GetPathName();

		return;
	}

	CFileName = CLoadFileDialog.GetPathName();

	if(CFileName == "") return;

	CFileName = ExtractPathName(CFileName);

	CFileName = CFileName.Left(CFileName.GetLength()-1);// remove last backslash

	if(!GCSuperSpiceDataBase.AddCircuitsFile(CFileName))
	{
		AfxMessageBox(IDS_ERR_ADD_CKT_FILE);

		return;
	}

	Refresh();
}

void TCCircuitsTreeView::EditDelete(void)
{
	int file_index;

	file_index = GetFileIndex();

	if(file_index < 0) return;

	CString CFileName = GetFileName();

	CString CMessage;

	CMessage.LoadString(IDS_CNF_REMOVE_CKTFILE);

	CMessage += ' ' + CFileName;

	if(AfxMessageBox(CMessage, MB_OKCANCEL) != IDOK) return;

	GCSuperSpiceDataBase.RemoveCircuitsFile(file_index);
}

void TCCircuitsTreeView::Properties(void)
{
	CString CFileName = GetCircuitName();

	if(CFileName =="") return;

	CString CFileFolderName = GetFileName();

	if(CFileFolderName == "") return;

	GCSuperSpiceDataBase.DisplayCircuitProperties(CFileFolderName, CFileName);
}

CString TCCircuitsTreeView::GetCircuitName(void)
{
	HTREEITEM		htiItemClicked, hparent;

	htiItemClicked = m_pTreeCtrl->GetSelectedItem();

	if(!htiItemClicked) return "";

	hparent = m_pTreeCtrl->GetParentItem(htiItemClicked);

	if(!hparent) return "";

	return m_pTreeCtrl->GetItemText(htiItemClicked);
}

void TCCircuitsTreeView::Remove(HTREEITEM HItem)
{
	int id;

	if(!HItem) return;

	if(IsBadCodePtr((FARPROC) HItem)) return;

	HTREEITEM hparent = m_pTreeCtrl->GetParentItem(HItem);

	if(!hparent)// must be the file folder
	{
		id = m_pTreeCtrl->GetItemData(HItem);

		if(id < 0) return;

		CFileID.RemovePageId(id);
	}

	if(HItem) m_pTreeCtrl->DeleteItem(HItem);
}


CString TCCircuitsTreeView::GetFileName(void)
{
	HTREEITEM		htiItemClicked, hparent;

	htiItemClicked = m_pTreeCtrl->GetSelectedItem();

	if(!htiItemClicked) return "";

	hparent = m_pTreeCtrl->GetParentItem(htiItemClicked);

	if(!hparent) hparent = htiItemClicked;

	CString CFileFileName = m_pTreeCtrl->GetItemText(htiItemClicked);

	if(CFileFileName == "") return "";

	CString CModelFileNameType = m_pTreeCtrl->GetItemText(hparent);	

	int id = m_pTreeCtrl->GetItemData(hparent);

	if(id < 0) return "";

	id = CFileID.GetPageIndex(id);

	if(id < 0) return "";

	return CFileID.CPageIdData[id].CPageTitle;
}

int TCCircuitsTreeView::GetFileIndex()
{
	HTREEITEM		htiItemClicked, hparent;

	htiItemClicked = m_pTreeCtrl->GetSelectedItem();

	if(!htiItemClicked) return -1;

	hparent = m_pTreeCtrl->GetParentItem(htiItemClicked);

	if(!hparent) hparent = htiItemClicked;

	CString CSymbolName = m_pTreeCtrl->GetItemText(htiItemClicked);

	CString CSymbolFileNameType = m_pTreeCtrl->GetItemText(hparent);	

	int id = m_pTreeCtrl->GetItemData(hparent);

	if(id < 0) return -1; 
	
	id = CFileID.GetPageIndex(id);

	if(id < 0) return -1;

	CString CFileName = CFileID.CPageIdData[id].CPageTitle;

	return GCSuperSpiceDataBase.FindCircuitsFile(CFileName);
}

void TCCircuitsTreeView::OnLButtonDown(UINT nFlags, CPoint CMousePosition) 
{
	HTREEITEM hItem;
	UINT      nHF;

	hItem = m_pTreeCtrl->HitTest(CMousePosition, &nHF);

	//Force the new selection to the current one
	if(hItem) m_pTreeCtrl->SelectItem(hItem);

	CXTTreeView::OnLButtonDown(nFlags, CMousePosition);

	CString CCircuitName = GetCircuitName();

	if(CCircuitName == "") return;

	CString CCircuitFileName = GetFileName();

	if(CCircuitFileName == "") return;

	CCircuitName += ".scl";

	CModelSymbolTab.DisplayCircuit(CCircuitFileName, CCircuitName);
}

bool TCCircuitsTreeView::IsDragging(void)
{
	return m_is_dragging;
}

bool TCCircuitsTreeView::PlaceDragedSymbol(void)
{
	PlaceCircuit();

	return true;
}

void TCCircuitsTreeView::ClearDragging(void)
{
	m_is_dragging	= false;
}

BOOL TCCircuitsTreeView::PreTranslateMessage(MSG* pMsg) 
{	
	return CXTTreeView::PreTranslateMessage(pMsg);
}

void TCCircuitsTreeView::OnBeginDragDrop(NMHDR* pNMHDR, LRESULT* pResult) 
{
	pNMHDR; pResult;

	m_is_dragging = true;

	return;
}
