#if !defined(AFX_TABVIEW3_H__0EDC1D11_1C40_45B7_9AE2_CC2D8E295F20__INCLUDED_2)
#define AFX_TABVIEW_H__0EDC1D11_1C40_45B7_9AE2_CC2D8E295F20__INCLUDED_2

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include <afxcview.h>
#include "TCNumberStack.h"

class TCSuperSpiceDoc;

class TCCircuitsTreeView : public CXTTreeView
{
protected: // create from serialization only
	TCCircuitsTreeView();
	DECLARE_DYNCREATE(TCCircuitsTreeView)

// Attributes
public:
	TCCircuitsTreeDoc* GetDocument();
	
	CTreeCtrl*	m_pTreeCtrl;
	CImageList	m_ImageList;
	bool		m_is_dragging;

	TCPageId		CFileID;

	void UpdateAllData(void);
	void Refresh(void);
	void Remove(HTREEITEM HItem);
	void EditDelete(void);
	int GetFileIndex();
	CString GetFileName(void);
	void AddFolder(void);
	void Properties(void);

	CString GetCircuitName(void);
	bool IsDragging(void);
	bool PlaceDragedSymbol(void);

	HTREEITEM hlast_saved_file;
	HTREEITEM hlast_saved_item;
	bool	  f_last_file;

	bool AddCircuitsFolder(int index);
	void ClearDragging(void);


// Operations
public:

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(TCCircuitsTreeView)
	public:
	virtual void OnDraw(CDC* pDC);  // overridden to draw this view
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
	virtual BOOL PreTranslateMessage(MSG* pMsg);
	protected:
	virtual void OnInitialUpdate(); // called first time after construct
	virtual void OnUpdate(CView* pSender, LPARAM lHint, CObject* pHint);
	//}}AFX_VIRTUAL

// Implementation
public:
	void UpdateView();
	virtual ~TCCircuitsTreeView();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

protected:

// Generated message map functions
protected:
	//{{AFX_MSG(TCCircuitsTreeView)
	afx_msg BOOL OnEraseBkgnd(CDC* pDC);
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg LRESULT OnNcHitTest(CPoint point);
	afx_msg void OnContextMenu(CWnd*, CPoint point);
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnBeginDragDrop(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnRButtonDown(UINT nFlags, CPoint point);

	//}}AFX_MSG

	void OnDoubleClickTree(NMHDR * pNMHDR, LRESULT* pResult);
	afx_msg void PlaceCircuit(void);


	DECLARE_MESSAGE_MAP()
};

#ifndef _DEBUG  // debug version in TabView.cpp
inline TCCircuitsTreeDoc* TCCircuitsTreeView::GetDocument()
   { return (TCCircuitsTreeDoc*)m_pDocument; }
#endif

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_TABVIEW_H__0EDC1D11_1C40_45B7_9AE2_CC2D8E295F20__INCLUDED_)

