// TCColorListBox.cpp : implementation file
// See TCColorListBox.h for details on how to use this class
//

#include "stdafx.h"
#include "TCColorListBox.h"
#include "TCColourDlg.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

enum 
{
	NUM_COLOR_PER_RED_GUN	= 127,
	NUM_COLOR_PER_GREEN_GUN = 127,
	NUM_COLOR_PER_BLUE_GUN	= 255,
	COLOR_ITEM_HEIGHT		= 20
};
/////////////////////////////////////////////////////////////////////////////
// TCColorListBox

CArray <COLORREF, COLORREF> CMColorRefList;// one copy for all list boxes

static TCInitColorListBox CInitColorListBox;

TCInitColorListBox::TCInitColorListBox(void)
{
	CMColorRefList.SetSize(0, 256);

	CMColorRefList.Add(RGB(11, 47, 251)); // Unselectable color end stop

	CMColorRefList.Add(RGB(255, 255, 255));	// white
	CMColorRefList.Add(0x0000000);			//black
	CMColorRefList.Add(RGB(255, 0, 0));		// red
	CMColorRefList.Add(0x0ffd700); //gold
	CMColorRefList.Add(0x00000ff);			//blue
	CMColorRefList.Add(0x0008000);			//green
	CMColorRefList.Add(0x0ffff00);			//yellow
	CMColorRefList.Add(RGB(0, 0, 127));			// dark blue 
	CMColorRefList.Add(RGB(0, 127, 0));			// dark green
	CMColorRefList.Add(RGB(0, 127, 127));		// dark cyan
	CMColorRefList.Add(RGB(127, 0, 0));			// dark red
	CMColorRefList.Add(RGB(127, 0, 127));		// purple
	CMColorRefList.Add(RGB(127, 127, 0));		// brown
	CMColorRefList.Add(RGB(127, 127, 127));		// gray
	CMColorRefList.Add(RGB(255, 127, 0));		// orange
	CMColorRefList.Add(RGB(0, 255, 255));		// cyan
	CMColorRefList.Add(RGB(255, 0, 0));			// red
	CMColorRefList.Add(RGB(255, 127, 127));		// salmon
	CMColorRefList.Add(RGB(255, 0, 127));		// pink
	CMColorRefList.Add(RGB(255, 0, 255));		// magenta
	CMColorRefList.Add(RGB(192, 192, 192));		// light gray
	CMColorRefList.Add(0x0f0f8ff); //aliceblue
	CMColorRefList.Add(0x0f0ffff); //azure
	CMColorRefList.Add(0x0ffebcd); //blanchedalmond
	CMColorRefList.Add(0x0deb887); //burlywood
	CMColorRefList.Add(0x0ff7f50); //coral 
	CMColorRefList.Add(0x000ffff); //cyan
	CMColorRefList.Add(0x0a9a9a9); //darkgray
	CMColorRefList.Add(0x0556b2f); //darkolivegreen
	CMColorRefList.Add(0x0e9967a); //darksalmon
	CMColorRefList.Add(0x000ced1); //darktorquoise
	CMColorRefList.Add(0x0696969); //dimgray
	CMColorRefList.Add(0x0228b22); //forestgreen
	CMColorRefList.Add(0x0adff2f); //greenyellow
	CMColorRefList.Add(0x04b0082); //indigo
	CMColorRefList.Add(0x0fff0f5); //lavenderblush
	CMColorRefList.Add(0x0f08080); //lightcoral
	CMColorRefList.Add(0x0d3d3d3); //lightgrey
	CMColorRefList.Add(0x087cefa); //lightskyblue
	CMColorRefList.Add(0x000ff00); //lime
	CMColorRefList.Add(0x0800000); //maroon
	CMColorRefList.Add(0x09370db); //meduimpurple
	CMColorRefList.Add(0x048d1cc); //meduimturquoise
	CMColorRefList.Add(0x0ffe4e1); //mistyrose
	CMColorRefList.Add(0x0faebdf); //antiquewhite 
	CMColorRefList.Add(0x0f5f5dc); //beige
	CMColorRefList.Add(0x05f9ea0); //cadetblue
	CMColorRefList.Add(0x06495ed); //cornflower
	CMColorRefList.Add(0x000008b); //darkblue
	CMColorRefList.Add(0x0006400); //darkgreen
	CMColorRefList.Add(0x0ff8c00); //darkorange
	CMColorRefList.Add(0x08fbc8b); //darkseagreen
	CMColorRefList.Add(0x09400d3); //darkviolet
	CMColorRefList.Add(0x01e90ff); //dodgerblue
	CMColorRefList.Add(0x0ff00ff); //fuchia
	CMColorRefList.Add(0x0daa520); //goldenrod
	CMColorRefList.Add(0x0f0fff0); //honeydew
	CMColorRefList.Add(0x0fffff0); //ivory
	CMColorRefList.Add(0x07cfc00); //lawngreen
	CMColorRefList.Add(0x0e0ffff); //lightcyan
	CMColorRefList.Add(0x0ffb6c1); //lightpink
	CMColorRefList.Add(0x0778899); //lightslategray
	CMColorRefList.Add(0x032cd32); //limegreen
	CMColorRefList.Add(0x066cdaa); //mediumaquamarine
	CMColorRefList.Add(0x03cb371); //mediumseagreen
	CMColorRefList.Add(0x0c71585); //mediumvioletred
	CMColorRefList.Add(0x0ffe4b5); //moccasin
	CMColorRefList.Add(0x000ffff); //aqua
	CMColorRefList.Add(0x0ffe4c4); //bisque
	CMColorRefList.Add(0x08a2be2); //blueviolet
	CMColorRefList.Add(0x07fff00); //chartreuse
	CMColorRefList.Add(0x0fff8dc); //cornsilk
	CMColorRefList.Add(0x0008b8b); //darkcyan
	CMColorRefList.Add(0x0bdb76b); //darkhaki
	CMColorRefList.Add(0x09932cc); //darkorchid
	CMColorRefList.Add(0x0483d8b); //darkblueslate
	CMColorRefList.Add(0x0ff1493); //deeppink
	CMColorRefList.Add(0x0b22222); //firebrick
	CMColorRefList.Add(0x0dcdcdc); //grainsboro
	CMColorRefList.Add(0x0808080); //gray
	CMColorRefList.Add(0x0ff69b4); //hotpink
	CMColorRefList.Add(0x0f0e68c); //khaki
	CMColorRefList.Add(0x0fffacd); //lemonchiffon
	CMColorRefList.Add(0x0fafad2); //lightgoldenrodyellow
	CMColorRefList.Add(0x0ffa07a); //lightsalmon
	CMColorRefList.Add(0x0b0c4de); //lightsteelblue
	CMColorRefList.Add(0x0faf0e6); //linen
	CMColorRefList.Add(0x00000cd); //mediumblue
	CMColorRefList.Add(0x07b68ee); // mediumslateblue
	CMColorRefList.Add(0x0191970); //midnightblue
	CMColorRefList.Add(0x0ffdead); //navajowhite
	CMColorRefList.Add(0x07fffd4); //aquamarine
	CMColorRefList.Add(0x0a52a2a); //brown
	CMColorRefList.Add(0x0d2691e); //chocolate
	CMColorRefList.Add(0x0dc143c); //crimson
	CMColorRefList.Add(0x0b8860b); //darkgoldenrod
	CMColorRefList.Add(0x08b008b); //darkmagenta
	CMColorRefList.Add(0x08b0000); //darkred
	CMColorRefList.Add(0x02f4f4f); // darkslategray 
	CMColorRefList.Add(0x000bfff); //deepskyblue
	CMColorRefList.Add(0x0fffaf0); //floralwhite
	CMColorRefList.Add(0x0f8f8ff); //ghostwhite
	CMColorRefList.Add(0x0cd5c5c); //indianred
	CMColorRefList.Add(0x0e6e6fa); //lavender
	CMColorRefList.Add(0x0add8e6); //lightblue
	CMColorRefList.Add(0x090ee90); //lightgreen
	CMColorRefList.Add(0x020b2aa); //lightseagreen
	CMColorRefList.Add(0x0ffffe0); //lightyellow
	CMColorRefList.Add(0x0ff00ff); //magenta
	CMColorRefList.Add(0x0ba55d3); //mediumorchid
	CMColorRefList.Add(0x000fa9a); //mediumspringgreen
	CMColorRefList.Add(0x0f5fffa); //mintcream
	CMColorRefList.Add(0x0000080); //navy
	CMColorRefList.Add(0x0fdf5e6); //oldlace
	CMColorRefList.Add(0x0ff4500); //orangered
	CMColorRefList.Add(0x0afeeee); //paleturquoise
	CMColorRefList.Add(0x0cd853f); //peru
	CMColorRefList.Add(0x0800080); //purple
	CMColorRefList.Add(0x08b4513); //saddlebrown
	CMColorRefList.Add(0x0fff5ee); //seashell
	CMColorRefList.Add(0x06a5acd); //slateblue
	CMColorRefList.Add(0x04682b4); //steelblue
	CMColorRefList.Add(0x0ff6347); //tomato
	CMColorRefList.Add(0x0ffffff); //white
	CMColorRefList.Add(0x0808000); //olive
	CMColorRefList.Add(0x0da70d6); //orchid
	CMColorRefList.Add(0x0db7093); //palevioletred
	CMColorRefList.Add(0x0ffc0cb); //pink
	CMColorRefList.Add(0x0ff0000); //red
	CMColorRefList.Add(0x0fa8072); //salmon
	CMColorRefList.Add(0x0a0522d); //sienna
	CMColorRefList.Add(0x0708090); //slategray
	CMColorRefList.Add(0x0d2b48c); //tan
	CMColorRefList.Add(0x040e0d0); //turquoise
	CMColorRefList.Add(0x0f5f5f5); //white smoke
	CMColorRefList.Add(0x06b8e23); //olivedrab
	CMColorRefList.Add(0x0eee8aa); //palegoldenrod
	CMColorRefList.Add(0x0ffefd5); //papayawhip
	CMColorRefList.Add(0x0dda0dd);  //plum
	CMColorRefList.Add(0x0bc8f8f); //rosybrown
	CMColorRefList.Add(0x0f4a460); //sandybrown
	CMColorRefList.Add(0x0c0c0c0); //silver
	CMColorRefList.Add(0x0fffafa); //snow
	CMColorRefList.Add(0x0008080); //teal
	CMColorRefList.Add(0x0ee82ee); //violet
	CMColorRefList.Add(0x0ffa500); //orange
	CMColorRefList.Add(0x098fb98); //palegreen
	CMColorRefList.Add(0x0ffdab9); //peachpuff
	CMColorRefList.Add(0x0b0e0e6); //powderblue
	CMColorRefList.Add(0x04169e1); //royalblue
	CMColorRefList.Add(0x02e8b57); //seagreen
	CMColorRefList.Add(0x087ceeb); //skyblue
	CMColorRefList.Add(0x000ff7f); //springgreen
	CMColorRefList.Add(0x0d8bfd8); //thistle
	CMColorRefList.Add(0x0f5deb3); //wheat
	CMColorRefList.Add(0x09acd32); //yellowgreen

	CMColorRefList.Add(RGB(11, 47, 251));		// Unselectable color end stop
}

TCColorListBox::TCColorListBox()
{
	// You can't actually add anything to the list box here since the
	// associated CWnd hasn't been created yet.  Save any initialization
	// you need to do for after the CWnd has been constructed.  The TODO: 
	// comments in TCColorListBox.h explain how to do this for 
	// TCColorListBox as implemented here.
}

TCColorListBox::~TCColorListBox()
{
}


BEGIN_MESSAGE_MAP(TCColorListBox, CListBox)
	//{{AFX_MSG_MAP(TCColorListBox)
	ON_WM_VSCROLL()
	ON_CONTROL_REFLECT(LBN_DBLCLK, OnDblclk)
	//}}AFX_MSG_MAP

	//	ON_WM_VSCROLL()
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// TCColorListBox message handlers

// This function draws a color bar in the client space of this list box 
// item.  If your list box item contains something other than color bars, 
// you need to replace the contents of this function with your own code 
// for drawing it.  If you are working with strings, the default MFC
// implementation of this function will probably work just fine for you.  
// (Example of a string where you need to do the drawing yourself: one 
// displayed in a different font than the rest of the dialog.)
void TCColorListBox::DrawItem(LPDRAWITEMSTRUCT lpDrawItemStruct) 
{
	CDC* pDC = CDC::FromHandle(lpDrawItemStruct->hDC);
	COLORREF color = (COLORREF)lpDrawItemStruct->itemData; // RGB in item data

	// White space
	CRect rcItem(lpDrawItemStruct->rcItem);
	rcItem.InflateRect(-2, -2);

	// Paint the color item in the color requested
	CBrush brush(color);
	pDC->FillRect(rcItem, &brush);

	// Focus rect
	if (lpDrawItemStruct->itemAction & ODA_FOCUS)
		pDC->DrawFocusRect(&lpDrawItemStruct->rcItem);
}

// This function compares two colors to each other. If you're doing 
// something different, like comparing two bitmaps to each other, use 
// a different algorithm.  If you are working with strings, the default 
// implementation provided by MFC will probably do the job just fine.  
// (Example of a string where you need to do your own comparisons: if 
// your sorting scheme is different than a standard collating sequence, 
// such as one where the comparisons need to be case-insensitive.)
int TCColorListBox::CompareItem(LPCOMPAREITEMSTRUCT lpCompareItemStruct) 
{
	// return -1 = item 1 sorts before item 2
	// return 0 = item 1 and item 2 sort the same
	// return 1 = item 1 sorts after item 2

	COLORREF color1 = (COLORREF)lpCompareItemStruct->itemData1;
	COLORREF color2 = (COLORREF)lpCompareItemStruct->itemData2;
	if (color1 == color2)
		return 0;       // exact match

	// first do an intensity sort, lower intensities go first
	int intensity1 = GetRValue(color1) + GetGValue(color1) + GetBValue(color1);
	int intensity2 = GetRValue(color2) + GetGValue(color2) + GetBValue(color2);
	if (intensity1 < intensity2)
		return -1;      // lower intensity goes first
	else if (intensity1 > intensity2)
		return 1;       // higher intensity goes second

	// if same intensity, sort by color (blues first, reds last)
	if (GetBValue(color1) > GetBValue(color2))
		return -1;
	else if (GetGValue(color1) > GetGValue(color2))
		return -1;
	else if (GetRValue(color1) > GetRValue(color2))
		return -1;
	else
		return 1;
}

// We made our color bars all be the same height for simplicity.  You 
// can actually specify variable heights as long as you set the 
// CBS_OWNERDRAWVARIABLE style.
void TCColorListBox::MeasureItem(LPMEASUREITEMSTRUCT lpMeasureItemStruct)
{
	// all items are of fixed size
	// must use LBS_OWNERDRAWVARIABLE for this to work
	lpMeasureItemStruct->itemHeight = COLOR_ITEM_HEIGHT;
}

void TCColorListBox::AddListItem(COLORREF color)
{
	// add a listbox item
	AddString((LPCTSTR) color);
		// List box does not have the LBS_HASSTRINGS style, so the
		//  normal list box string is used to store an RGB color
}

// add alot of colors to the list box 
void TCColorListBox::LoadList()
{
	AddListItem(RGB(11, 47, 251));
		
	int p = 0;

	int count = CMColorRefList.GetSize() - 1;

	for (p = 1; p < count; p++)
	{
		AddListItem(CMColorRefList[p]);	
	}

	AddListItem(RGB(11, 47, 251));
}

COLORREF TCColorListBox::GetColorRef(void)
{
	int select =  GetCurSel();

	if(select < 0) return 0;

	if(CMColorRefList.GetSize() <= select) return 0;

	return CMColorRefList[select];
}

void TCColorListBox::SetColorRef(COLORREF color)
{
	SetCurSel(0);

	int count = CMColorRefList.GetSize();

	if(!count) return;

	for(int p = 0; p < count; p++)
	{
		if(CMColorRefList[p] == color)
		{
			SetCurSel(p + 1); // Fudge fix to fource a scroll to the correct position
			SetCurSel(p);

			return;
		}
	}
}

void TCColorListBox::OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar) 
{
	// TODO: Add your message handler code here and/or call default
	
	int select = GetCurSel();

	if(select <= 1 && nSBCode == SB_LINEUP) return;
	if(select >= CMColorRefList.GetSize() - 2 && nSBCode == SB_LINEDOWN) return;

	CListBox::OnVScroll(nSBCode, nPos, pScrollBar);

	if(nSBCode == SB_LINEUP)
	{
		SetCurSel(select - 1);
	}
	else if(nSBCode == SB_LINEDOWN)
		{
			SetCurSel(select + 1);
		}

}

void TCColorListBox::OnDblclk() 
{return;/*
	TCColourDlg CColorDialog;

	CColorDialog.m_colour = GetColorRef();
	
	if(CColorDialog.DoModal() == IDOK)
	{
		SetColorRef(CColorDialog.GetColor());
	}*/
}
