// TCColorListBox.h : header file
//

#ifndef __TCCOLORLISTBOX_H__
#define __TCCOLORLISTBOX_H__

#include <afxtempl.h>
// This class handles an owner-draw list box.  The list box in question
// handles color bars instead of text.  It shows all of the required
// features for an owner-draw list box. See the on-line help for CListBox 
// for other ways you can manipulate the contents of an owner-draw list
// box.
//
// You can actually handle just about anything you want in an owner-draw 
// list box as long as you override functions CompareItem, DrawItem, and 
// MeasureItem.  Strings are easiest and don't require all the overrides.  
// Other examples: bitmaps, text in varying fonts, text in a non-standard 
// font, etc.
//
// TODO:
//	1.	Create an owner-draw list box in your resources to use with
//		this class.  You will need to have the following features set
//		on the Styles page for the list box:
//		- Owner-Draw: Variable
//		- Has Strings: Unchecked
//		- Sort: Checked (to show off owner-draw sorting)
//
//	2.	Subclass your owner-draw list box to associate it with this
//		class.  The following statement placed in OnInitDialog() for 
//		the dialog you used this list box in should work fine:
//			m_myDraw.SubclassDlgItem(IDC_MYDRAW, this);
//		where:
//			m_myDraw is an instance of the owner-draw list box class
//			IDC_MYDRAW is the ID associated with your list box resource
//
//	3.	Call m_myDraw.LoadList() to initialize the contents of the owner-draw
//		list box.  Do this immediately after you subclass the list box
//		control.
//
//	4.	The list box implemented here is single selection for simplicity.  
//		If you want	something different (like multiple or extended selection),
//		you will need to do the following:
//		- change the Selections type on the Styles page for the list box 
//			appropriately
//		- use the multiple-selection operations functions provided for 
//			CListBox to manipulate the selections (see the on-line help 
//			for CListBox for more details on these functions)

/////////////////////////////////////////////////////////////////////////////
// TCColorListBox window

class TCInitColorListBox
{
	public:	
			TCInitColorListBox(void);
};

class TCColorListBox : public CListBox
{
// Construction

	friend TCInitColorListBox;
public:
	TCColorListBox();

// Attributes
public:

// Operations
public:
	void AddListItem(COLORREF color);
	void LoadList();
	
	COLORREF GetColorRef(void);
	void SetColorRef(COLORREF color);
// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(TCColorListBox)
	public:
	virtual void DrawItem(LPDRAWITEMSTRUCT lpDrawItemStruct);
	virtual int CompareItem(LPCOMPAREITEMSTRUCT lpCompareItemStruct);
	virtual void MeasureItem(LPMEASUREITEMSTRUCT lpMeasureItemStruct);
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~TCColorListBox();

	// Generated message map functions
protected:
	//{{AFX_MSG(TCColorListBox)
	afx_msg void OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);
	afx_msg void OnDblclk();
	//}}AFX_MSG

	DECLARE_MESSAGE_MAP()
};


#endif __TCCOLORLISTBOX_H__	// end define of TCColorListBox
