// TCComponentLibaryDlg.cpp : implementation file
//

#include "stdafx.h"
#include "resource.h"
#include "Generic.h"
#include "TCFileFunctions.h"
#include "TESuperSpiceLabelEnums.h"
#include "TCSuperSpiceGlobalData.h"
#include "TCSuperSpiceDataBase.h"
#include "TCComponentLibaryDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// TCComponentLibaryDlg dialog
extern TCSuperSpiceGlobalData	GCSuperSpiceGlobalData;
extern TCSuperSpiceDataBase GCSuperSpiceDataBase; 

TCComponentLibaryDlg::TCComponentLibaryDlg(CWnd* pParent /*=NULL*/)
	: CDialog(TCComponentLibaryDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(TCComponentLibaryDlg)
	CMComboModel = _T("");
	CMComboSymbolFile = _T("");
	CMComboSymbol = _T("");
	CMComboModelFile = _T("");
	//}}AFX_DATA_INIT

}


void TCComponentLibaryDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(TCComponentLibaryDlg)
	DDX_Control(pDX, IDC_COMBO_MODEL_DATA, CMComboModelList);
	DDX_Control(pDX, IDC_COMBO_MODEL_FILES, CMComboModelFileList);
	DDX_Control(pDX, IDC_COMBO_COMPONENT_SYMBOLS, CMComboSymbolList);
	DDX_Control(pDX, IDC_COMBO_COMPONENT_FILES, CMComboSymbolFilesList);
	DDX_CBString(pDX, IDC_COMBO_MODEL_DATA, CMComboModel);
	DDX_CBString(pDX, IDC_COMBO_COMPONENT_FILES, CMComboSymbolFile);
	DDX_CBString(pDX, IDC_COMBO_COMPONENT_SYMBOLS, CMComboSymbol);
	DDX_CBString(pDX, IDC_COMBO_MODEL_FILES, CMComboModelFile);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(TCComponentLibaryDlg, CDialog)
	//{{AFX_MSG_MAP(TCComponentLibaryDlg)
	ON_BN_CLICKED(IDC_BUTTON_ADD_MODEL_FILE, OnButtonAddModelFile)
	ON_BN_CLICKED(IDC_BUTTON_REMOVE_MODEL_FILE, OnButtonRemoveModelFile)
	ON_BN_CLICKED(IDC_BUTTON_ADD_SYMBOL_FILE, OnButtonAddSymbolFile)
	ON_BN_CLICKED(IDC_BUTTON_REMOVE_SYMBOL_FILE, OnButtonRemoveSymbolFile)
	ON_BN_CLICKED(IDC_BUTTON_EDIT_MODEL, OnButtonEditModel)
	ON_BN_CLICKED(IDC_BUTTON_EDIT_SYMBOL, OnButtonEditSymbol)
	ON_CBN_SELCHANGE(IDC_COMBO_COMPONENT_FILES, OnSelchangeComboComponentFiles)
	ON_CBN_SELCHANGE(IDC_COMBO_MODEL_FILES, OnSelchangeComboModelFiles)
	ON_CBN_EDITCHANGE(IDC_COMBO_MODEL_FILES, OnEditchangeComboModelFiles)
	ON_CBN_SELCHANGE(IDC_COMBO_MODEL_DATA, OnSelchangeComboModelData)
	ON_CBN_SELCHANGE(IDC_COMBO_COMPONENT_SYMBOLS, OnSelchangeComboComponentSymbols)
	ON_CBN_KILLFOCUS(IDC_COMBO_MODEL_DATA, OnKillfocusComboModelData)
	ON_CBN_KILLFOCUS(IDC_COMBO_COMPONENT_SYMBOLS, OnKillfocusComboComponentSymbols)
	ON_BN_CLICKED(IDC_BUTTON_LOAD_SETUP, OnButtonLoadSetup)
	ON_BN_CLICKED(IDC_BUTTON_SAVE_SETUP, OnButtonSaveSetup)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// TCComponentLibaryDlg message handlers

BOOL TCComponentLibaryDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	SetDisplay();

	return TRUE; 
}

void TCComponentLibaryDlg::GetDisplay(void)
{
	UpdateData(true);

	bool	no_symbols	= true;
	bool	no_models	= true;
	int		symbol_index	= 0; 
	int		model_index		= 0;

	OnSelchangeComboModelData();
	OnSelchangeComboComponentSymbols();

	int symbol_file_index = GCSuperSpiceDataBase.CSymbolDataBase.index;
	int model_file_index = GCSuperSpiceDataBase.CModelDataBase.index;

	CComponentDataBaseData.use_index			= true;
	CComponentDataBaseData.symbol_file_index	= symbol_file_index;
	CComponentDataBaseData.model_file_index		= model_file_index;

	if(symbol_file_index < GCSuperSpiceDataBase.CSymbolDataBase.CFileList.GetSize())
	{
		symbol_index = GCSuperSpiceDataBase.CSymbolDataBase.CFileList[symbol_file_index].index;
		
		CComponentDataBaseData.symbol_index	= symbol_index;
		
		no_symbols = false;
	}
	else CComponentDataBaseData.symbol_index = 0;

	if(model_file_index < GCSuperSpiceDataBase.CModelDataBase.CFileList.GetSize())
	{
		model_index  = GCSuperSpiceDataBase.CModelDataBase.CFileList[model_file_index].index;
	
		CComponentDataBaseData.model_index = model_index;

		no_models = false;
	}
	else CComponentDataBaseData.model_index	= 0;

	GCSuperSpiceDataBase.CSymbolDataBase.CComboEdit = CMComboSymbolFile;
	
	GCSuperSpiceDataBase.CModelDataBase.CComboEdit	= CMComboModelFile;

	CString CText;

	if(!no_symbols)
	{
		GCSuperSpiceDataBase.CSymbolDataBase.CFileList[symbol_file_index].CComboEdit = CMComboSymbol;

		CArray <TCSchematicObjectData, TCSchematicObjectData&> &CSymbolList = GCSuperSpiceDataBase.CSymbolDataBase.CFileList[symbol_file_index].CSymbolList;

		if(!no_models)
		{
			if(symbol_index < CSymbolList.GetSize())
			{
				if(model_index < GCSuperSpiceDataBase.CModelDataBase.CFileList[model_file_index].CParametersList.CParameters.GetSize())
					CSymbolList[symbol_index].CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel = GCSuperSpiceDataBase.CModelDataBase.CFileList[model_file_index].CParametersList.CParameters[model_index].CDataBaseIdInfo.CRecordName;
		
				CSymbolList[symbol_index].FormatSpiceValue();
			}
		}

		if(symbol_index < CSymbolList.GetSize())
		{
			CText = CSymbolList[symbol_index].CLabelListData[E_COMPONENT_VALUE].CLabel;

			CComponentDataBaseData.CSymbolName		= CSymbolList[symbol_index].CSymbolData.CName;
			CComponentDataBaseData.CSymbolFileName	= CSymbolList[symbol_index].CSymbolData.CFileName;
			CComponentDataBaseData.CSymbolPathName	= CSymbolList[symbol_index].CSymbolData.CFilePath;
		}
	}
	if(!no_models)
	{
		GCSuperSpiceDataBase.CModelDataBase.CFileList[model_file_index].CComboEdit = CMComboModel;

		TCSpiceParametersList &CModelList = GCSuperSpiceDataBase.CModelDataBase.CFileList[model_file_index].CParametersList;

		CComponentDataBaseData.CModelName		= CText;

		if(model_index < CModelList.CParameters.GetSize())
		{
			CComponentDataBaseData.CModelFileName	= CModelList.CParameters[model_index].CDataBaseIdInfo.CRecordFileName;
			CComponentDataBaseData.CModelPathName	= CModelList.CParameters[model_index].CDataBaseIdInfo.CRecordFilePath;
		}
	}

	CComponentDataBaseData.CComponentFileName;
	CComponentDataBaseData.CComponentPathName;
	CComponentDataBaseData.CComponentName;
}

void TCComponentLibaryDlg::SetDisplay(void)
{
	SetSymbolFileList();
	SetSymbolList();
	SetModelFileList();
	SetModelList();

	UpdateData(false);
}

void TCComponentLibaryDlg::SetSymbolFileList(void)
{
	int count, p;

	CMComboSymbolFilesList.ResetContent();

	CArray <TCSymbolDataBaseData, TCSymbolDataBaseData &> &CFiles = GCSuperSpiceDataBase.CSymbolDataBase.CFileList;

	CMComboSymbolFile = GCSuperSpiceDataBase.CSymbolDataBase.CComboEdit;
	
	count = CFiles.GetSize();

	if(!count) CMComboSymbolFile = "";

	if(count) if(CMComboSymbolFile == "") CMComboSymbolFile = CFiles[0].CType;

	for(p = 0; p < count; p++)
	{
		CMComboSymbolFilesList.InsertString(-1, CFiles[p].CType);
	}

	if(count) CMComboSymbolFilesList.SetCurSel(GCSuperSpiceDataBase.CSymbolDataBase.index);
}

void TCComponentLibaryDlg::SetSymbolList(void)
{
	int count, p;

	int index = GCSuperSpiceDataBase.CSymbolDataBase.index;

	CMComboSymbolList.ResetContent();

	count = GCSuperSpiceDataBase.CSymbolDataBase.CFileList.GetSize();
	
	if(!count) CMComboSymbol = "";

	if(!count) return;

	if(index >= count) 
	{
		GCSuperSpiceDataBase.CSymbolDataBase.index = 0;
		index = 0;
	}

	CArray <TCSchematicObjectData, TCSchematicObjectData&> &CSymbolList = GCSuperSpiceDataBase.CSymbolDataBase.CFileList[index].CSymbolList;

	CMComboSymbol = GCSuperSpiceDataBase.CSymbolDataBase.CFileList[index].CComboEdit;

	count = CSymbolList.GetSize();

	if(count) if(CMComboSymbol == "") CMComboSymbol = CSymbolList[0].CSymbolData.CName;

	for(p = 0; p < count; p++)
	{
		CMComboSymbolList.InsertString(-1, CSymbolList[p].CSymbolData.CName);
	}

	if(count) CMComboSymbolList.SetCurSel(GCSuperSpiceDataBase.CSymbolDataBase.CFileList[index].index);
}

void TCComponentLibaryDlg::SetModelFileList(void)
{
	int count, p;

	CMComboModelFileList.ResetContent();

	CArray <TCModelDataBaseData, TCModelDataBaseData &> &CFiles = GCSuperSpiceDataBase.CModelDataBase.CFileList;

	CMComboModelFile = GCSuperSpiceDataBase.CModelDataBase.CComboEdit;
	
	count = CFiles.GetSize();

	if(!count) CMComboModelFile = "";

	if(count) if(CMComboModelFile == "") CMComboModelFile = CFiles[0].CType;

	for(p = 0; p < count; p++)
	{
		CMComboModelFileList.InsertString(-1, CFiles[p].CType);
	}

	if(count) CMComboModelFileList.SetCurSel(GCSuperSpiceDataBase.CModelDataBase.index);
}
void TCComponentLibaryDlg::SetModelList(void)
{
	int count, p;

	int index = GCSuperSpiceDataBase.CModelDataBase.index;

	count = GCSuperSpiceDataBase.CModelDataBase.CFileList.GetSize();
	
	CMComboModelList.ResetContent();

	if(!count) CMComboModel = "";
	
	if(!count) return;

	if(index >= count) 
	{
		GCSuperSpiceDataBase.CModelDataBase.index = 0;
		index = 0;
	}

	TCSpiceParametersList &CModelList = GCSuperSpiceDataBase.CModelDataBase.CFileList[index].CParametersList;

	CMComboModel = GCSuperSpiceDataBase.CModelDataBase.CFileList[index].CComboEdit;

	count = CModelList.CParameters.GetSize();

	if(count) if(CMComboModel == "") CMComboModel = CModelList.CParameters[0].CDataBaseIdInfo.CRecordName;

	for(p = 0; p < count; p++)
	{
		CMComboModelList.InsertString(-1, CModelList.CParameters[p].CDataBaseIdInfo.CRecordName);
	}

	if(count) CMComboModelList.SetCurSel(GCSuperSpiceDataBase.CModelDataBase.CFileList[index].index);
}


void TCComponentLibaryDlg::OnButtonEditModel() 
{
	
}

void TCComponentLibaryDlg::OnButtonEditSymbol() 
{
	
}

void TCComponentLibaryDlg::OnOK() 
{
	GetDisplay();
	
	CDialog::OnOK();
}

void TCComponentLibaryDlg::OnCancel() 
{
	GetDisplay();
	
	CDialog::OnCancel();
}

void TCComponentLibaryDlg::OnSelchangeComboComponentFiles() 
{
	GetDisplay();

	int index = CMComboSymbolFilesList.GetCurSel();

	if(index < 0) index = 0;

	GCSuperSpiceDataBase.CSymbolDataBase.index = index;

	SetSymbolList();
}

void TCComponentLibaryDlg::OnSelchangeComboModelFiles() 
{
	GetDisplay();

	int index = CMComboModelFileList.GetCurSel();

	if(index < 0) index = 0;

	GCSuperSpiceDataBase.CModelDataBase.index = index;

	SetModelList();
}

void TCComponentLibaryDlg::OnSelchangeComboModelData() 
{
	int index = CMComboModelList.GetCurSel();

	if(index < 0) index = 0;

	if(GCSuperSpiceDataBase.CModelDataBase.index >= GCSuperSpiceDataBase.CModelDataBase.CFileList.GetSize()) return;

	GCSuperSpiceDataBase.CModelDataBase.CFileList[GCSuperSpiceDataBase.CModelDataBase.index].index = index;
}

void TCComponentLibaryDlg::OnSelchangeComboComponentSymbols() 
{
	int index = CMComboSymbolList.GetCurSel();

	if(index < 0) index = 0;
	
	if(GCSuperSpiceDataBase.CSymbolDataBase.index >= GCSuperSpiceDataBase.CSymbolDataBase.CFileList.GetSize()) return;

	GCSuperSpiceDataBase.CSymbolDataBase.CFileList[GCSuperSpiceDataBase.CSymbolDataBase.index].index = index;
	
}
void TCComponentLibaryDlg::OnKillfocusComboModelData() 
{
	OnSelchangeComboModelData();
}

void TCComponentLibaryDlg::OnKillfocusComboComponentSymbols() 
{
	OnSelchangeComboComponentSymbols();
}

void TCComponentLibaryDlg::OnEditchangeComboModelFiles() 
{

}

void TCComponentLibaryDlg::OnButtonLoadSetup() 
{
	CString CFileName;

	CFileName = GCSuperSpiceGlobalData.CGeneric.CDataBaseInitFileName;

	CFileDialog	CLoadFileDialog(true, "sdb",CFileName, 0,"SuperSpice DB Files  (*.sdb)| *.sdb||");

	if(CLoadFileDialog.DoModal() != IDOK) return;

	CFileName = CLoadFileDialog.GetPathName();

	if(CFileName == "") return;

	if(!GCSuperSpiceDataBase.LoadAs(CFileName))
	{
		AfxMessageBox(IDS_ERR_IN_DB_FILE);

		SetDisplay();

		return;
	}

	GCSuperSpiceGlobalData.CGeneric.CDataBaseInitFileName = CFileName;

	SetDisplay();
}

void TCComponentLibaryDlg::OnButtonSaveSetup() 
{
	CString CFileName;

	CFileName = GCSuperSpiceGlobalData.CGeneric.CDataBaseInitFileName;

	CFileDialog	CSaveFileDialog(false, "sdb", CFileName, 0, "SuperSpice DB Files  (*.sdb)| *.sdb||");

	if(CSaveFileDialog.DoModal() != IDOK) return;

	CFileName = CSaveFileDialog.GetPathName();

	if(CFileName == "") return;

	if(!GCSuperSpiceDataBase.SaveAs(CFileName))
	{
		AfxMessageBox(IDS_ERR_SAVE_DB_FILE);

		return;
	}

	GCSuperSpiceGlobalData.CGeneric.CDataBaseInitFileName = CFileName;
}

void TCComponentLibaryDlg::OnButtonAddModelFile() 
{
	CString CFileName;

	CString CFileDescriptor;
	
	CFileDescriptor.LoadString(IDS_STRING_MODEL_FILE_DESCRIPTOR);

	CFileDialog	CLoadFileDialog(true, "lib",GCSuperSpiceGlobalData.CGeneric.CDataBaseLastModelFileName, 0, CFileDescriptor);

	if(CLoadFileDialog.DoModal() != IDOK) 
	{
		CFileName = CLoadFileDialog.GetPathName();

		GCSuperSpiceGlobalData.CGeneric.CDataBaseLastModelFileName = CFileName;

		return;
	}
	CFileName = CLoadFileDialog.GetPathName();

	if(CFileName == "") return;

	GCSuperSpiceGlobalData.CGeneric.CDataBaseLastModelFileName = CFileName;

	BeginWaitCursor();

	if(!GCSuperSpiceDataBase.AddModelFile(CFileName))
	{
		AfxMessageBox(IDS_ERR_ADD_MODEL_FILE);

		return;
	}

	SetDisplay();

	EndWaitCursor();
}

void TCComponentLibaryDlg::OnButtonRemoveModelFile() 
{
	if(!GCSuperSpiceDataBase.CModelDataBase.CFileList.GetSize()) return;

	if(!GCSuperSpiceDataBase.RemoveModelFile(GCSuperSpiceDataBase.CModelDataBase.index))
	{
		AfxMessageBox(IDS_ERR_REMOVE_MODELFILE);

		return;
	}

	SetDisplay();
}

void TCComponentLibaryDlg::OnButtonAddSymbolFile() 
{
	CString CFileName;

	CFileDialog	CLoadFileDialog(true, "ssm",GCSuperSpiceGlobalData.CGeneric.CDataBaseLastSymbolFileName, 0,"SuperSpice Component Files  (*.ssm)| *.ssm||");

	if(CLoadFileDialog.DoModal() != IDOK)
	{
		CFileName = CLoadFileDialog.GetPathName();

		GCSuperSpiceGlobalData.CGeneric.CDataBaseLastSymbolFileName = CFileName;

		return;
	}

	CFileName = CLoadFileDialog.GetPathName();

	if(CFileName == "") return;

	GCSuperSpiceGlobalData.CGeneric.CDataBaseLastSymbolFileName = CFileName;

	BeginWaitCursor();

	if(!GCSuperSpiceDataBase.AddSymbolFile(CFileName))
	{
		AfxMessageBox(IDS_ERR_ADD_SYM_FILE);

		return;
	}

	SetDisplay();

	EndWaitCursor();
}

void TCComponentLibaryDlg::OnButtonRemoveSymbolFile() 
{
	if(!GCSuperSpiceDataBase.CSymbolDataBase.CFileList.GetSize()) return;

	if(!GCSuperSpiceDataBase.RemoveSymbolFile(GCSuperSpiceDataBase.CSymbolDataBase.index))
	{
		AfxMessageBox(IDS_ERR_REMOVE_SYM_FILE);

		return;
	}

	SetDisplay();
}
