// TCCreateSymbolForModelDlg.cpp : implementation file
//

#include "stdafx.h"
#include "afxpriv.h"
#include "superspice.h"
#include "TCSuperSpiceDataBase.h"
#include "TCMasterModelDlg.h"
#include "TCMasterSymbolDlg.h"
#include "TCCreateSymbolForModelDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

extern TCSuperSpiceDataBase	GCSuperSpiceDataBase;

/////////////////////////////////////////////////////////////////////////////
// TCCreateSymbolForModelDlg dialog


TCCreateSymbolForModelDlg::TCCreateSymbolForModelDlg(CWnd* pParent /*=NULL*/)
	: CDialog(TCCreateSymbolForModelDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(TCCreateSymbolForModelDlg)
	CMBottomPinNames = _T("");
	CMLeftPinNames = _T("");
	CMRightPinNames = _T("");
	CMSymbolFileName = _T("");
	CMSymbolName = _T("");
	CMTopPinNames = _T("");
	CMSubcktModelName = _T("");
	CMAllPinNames = _T("");
	//}}AFX_DATA_INIT
}


void TCCreateSymbolForModelDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(TCCreateSymbolForModelDlg)
	DDX_Text(pDX, IDC_EDIT_BOTTOM_PIN_NAMES, CMBottomPinNames);
	DDX_Text(pDX, IDC_EDIT_LEFT_PIN_NAMES, CMLeftPinNames);
	DDX_Text(pDX, IDC_EDIT_RIGHT_PIN_NAMES, CMRightPinNames);
	DDX_Text(pDX, IDC_EDIT_SYMBOL_FILE_NAME, CMSymbolFileName);
	DDX_Text(pDX, IDC_EDIT_SYMBOL_NAME, CMSymbolName);
	DDX_Text(pDX, IDC_EDIT_TOP_PIN_NAMES, CMTopPinNames);
	DDX_Text(pDX, IDC_EDIT_MODEL_NAMES, CMSubcktModelName);
	DDX_Text(pDX, IDC_EDIT_ALL_PIN_NAMES, CMAllPinNames);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(TCCreateSymbolForModelDlg, CDialog)
	//{{AFX_MSG_MAP(TCCreateSymbolForModelDlg)
	ON_BN_CLICKED(IDC_HELP_CREATE_SYMBOL, OnHelpCreateSymbol)
	ON_BN_CLICKED(IDC_BUTTON_SELECT_MODEL, OnButtonSelectModel)
	ON_BN_CLICKED(IDC_BUTTON_BROWSE_SYMBOL_FILE_NAME, OnButtonBrowseSymbolFileName)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// TCCreateSymbolForModelDlg message handlers

void TCCreateSymbolForModelDlg::OnHelpCreateSymbol() 
{
	TCSuperSpiceApp	*PCSuperSpiceApp = (TCSuperSpiceApp	*)AfxGetApp();

	if(!PCSuperSpiceApp) return;

	PCSuperSpiceApp->DialogHelp(IDD_DIALOG_CREATE_SYMBOL + HID_BASE_RESOURCE);	
}

void TCCreateSymbolForModelDlg::OnOK() 
{
	GetDisplay();
	
	CCreateSymbolFromSchematicData.CSymbolName.TrimLeft();
	CCreateSymbolFromSchematicData.CSymbolName.TrimRight();

	if(CCreateSymbolFromSchematicData.CSymbolName == "")
	{
		AfxMessageBox(IDS_ERR_MUSTNAME_SYMBOL);

		return;
	}

	if(!CCreateSymbolFromSchematicData.CAllList.GetSize())
	{
		AfxMessageBox(IDS_ERR_MUST_HAVE_PIN);

		return;
	}

	CDialog::OnOK();
}


bool TCCreateSymbolForModelDlg::ValidateData(void)
{
	return CCreateSymbolFromSchematicData.ValidateStringsToArrays();
}

void TCCreateSymbolForModelDlg::GetDisplay(void)
{
	UpdateData(true);

	CCreateSymbolFromSchematicData.CBottom			= CMBottomPinNames;
	CCreateSymbolFromSchematicData.CLeft			= CMLeftPinNames;
	CCreateSymbolFromSchematicData.CRight			= CMRightPinNames;
	CCreateSymbolFromSchematicData.CSymbolFileName	= CMSymbolFileName;
	CCreateSymbolFromSchematicData.CSymbolName		= CMSymbolName;
	CCreateSymbolFromSchematicData.CTop				= CMTopPinNames;

//	CCreateSymbolFromSchematicData.CreateAllDataFromPinStrings();
	CCreateSymbolFromSchematicData.CreateArraysFromString();
}

void TCCreateSymbolForModelDlg::SetDisplay(void)
{

	CMBottomPinNames	= CCreateSymbolFromSchematicData.CBottom;
	CMLeftPinNames		= CCreateSymbolFromSchematicData.CLeft;
	CMRightPinNames		= CCreateSymbolFromSchematicData.CRight;
	CMSymbolFileName	= CCreateSymbolFromSchematicData.CSymbolFileName;
	CMSymbolName		= CCreateSymbolFromSchematicData.CSymbolName;
	CMTopPinNames		= CCreateSymbolFromSchematicData.CTop;

	CMAllPinNames		= CCreateSymbolFromSchematicData.CAll;
	CMSubcktModelName	= CCreateSymbolFromSchematicData.CModelName;

	UpdateData(false);
}

BOOL TCCreateSymbolForModelDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	SetDisplay();
	
	return TRUE;  
}

void TCCreateSymbolForModelDlg::OnButtonSelectModel() 
{
	TCMasterModelDlg		CMasterModelDlg;
	
	CMasterModelDlg.m_check = false;

	CMasterModelDlg.enable_edit_model_file = false;

	CMasterModelDlg.CComponentDataBaseData.CModelPathName	= ExtractPathName(CCreateSymbolFromSchematicData.CModelFileName);
	CMasterModelDlg.CComponentDataBaseData.CModelFileName	= ExtractFileName(CCreateSymbolFromSchematicData.CModelFileName);
	CMasterModelDlg.CComponentDataBaseData.CModelName		= CCreateSymbolFromSchematicData.CModelName;

	GetDisplay();// so that set display dont overwrite any changed data.

	if(CMasterModelDlg.DoModal() != IDOK) return;

	CCreateSymbolFromSchematicData.CModelFileName = CMasterModelDlg.CComponentDataBaseData.CModelPathName + CMasterModelDlg.CComponentDataBaseData.CModelFileName;

	CCreateSymbolFromSchematicData.CModelName = CMasterModelDlg.CComponentDataBaseData.CModelName;

	TCSpiceParameters CSpiceParameters;

	CSpiceParameters.CDataBaseIdInfo.CRecordFilePath	= CMasterModelDlg.CComponentDataBaseData.CModelPathName;
	CSpiceParameters.CDataBaseIdInfo.CRecordFileName	= CMasterModelDlg.CComponentDataBaseData.CModelFileName;
	CSpiceParameters.CDataBaseIdInfo.CRecordName		= CMasterModelDlg.CComponentDataBaseData.CModelName;

	if(!GCSuperSpiceDataBase.CModelDataBase.Get(CSpiceParameters)) return;

	if(CSpiceParameters.CDataBaseIdInfo.model_type != E_SPICE_DOT_SUBCIRCUIT)
	{
		AfxMessageBox(IDS_NO_PIN_NAMES );

		return;
	}

	CCreateSymbolFromSchematicData.CAll = CSpiceParameters.GetPinList(CCreateSymbolFromSchematicData.CAllList);

	int count = CCreateSymbolFromSchematicData.CAllList.GetSize();

	CCreateSymbolFromSchematicData.CPinID.SetSize(count);

	for(int p = 0; p < count; p++)
	{
		CCreateSymbolFromSchematicData.CPinID[p] = p;
	}

	SetDisplay();
}

void TCCreateSymbolForModelDlg::OnButtonBrowseSymbolFileName() 
{
	TCMasterSymbolDlg CSymbolDlg;

	TCComponentDataBaseData CComponentDataBaseData;
		
	CSymbolDlg.CComponentDataBaseData.CSymbolPathName	= ExtractPathName(CCreateSymbolFromSchematicData.CSymbolFileName);
	CSymbolDlg.CComponentDataBaseData.CSymbolFileName	= ExtractFileName(CCreateSymbolFromSchematicData.CSymbolFileName);
	CSymbolDlg.CComponentDataBaseData.CSymbolName		= CCreateSymbolFromSchematicData.CSymbolName;

	if(CSymbolDlg.DoModal() != IDOK) return;

	CCreateSymbolFromSchematicData.CSymbolFileName = CSymbolDlg.CComponentDataBaseData.CSymbolPathName + CSymbolDlg.CComponentDataBaseData.CSymbolFileName;

	SetDisplay();
}
