// TCCreateSymbolFromSchematic.cpp : implementation file
//

#include "stdafx.h"
#include "afxpriv.h"
#include "superspice.h"
#include "TCMasterSymbolDlg.h"
#include "TCCreateSymbolFromSchematic.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// TCCreateSymbolFromSchematic dialog


TCCreateSymbolFromSchematic::TCCreateSymbolFromSchematic(CWnd* pParent /*=NULL*/)
	: CDialog(TCCreateSymbolFromSchematic::IDD, pParent)
{
	//{{AFX_DATA_INIT(TCCreateSymbolFromSchematic)
	CMAllSymbolNames = _T("");
	CMBottomPinNames = _T("");
	CMLeftPinNames = _T("");
	CMRightPinNames = _T("");
	CMSymbolFileName = _T("");
	CMSymbolName = _T("");
	CMTopPinNames = _T("");
	//}}AFX_DATA_INIT
}


void TCCreateSymbolFromSchematic::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(TCCreateSymbolFromSchematic)
	DDX_Text(pDX, IDC_EDIT_ALL_SYMBOL_NAMES, CMAllSymbolNames);
	DDX_Text(pDX, IDC_EDIT_BOTTOM_PIN_NAMES, CMBottomPinNames);
	DDX_Text(pDX, IDC_EDIT_LEFT_PIN_NAMES, CMLeftPinNames);
	DDX_Text(pDX, IDC_EDIT_RIGHT_PIN_NAMES, CMRightPinNames);
	DDX_Text(pDX, IDC_EDIT_SYMBOL_FILE_NAME, CMSymbolFileName);
	DDX_Text(pDX, IDC_EDIT_SYMBOL_NAME, CMSymbolName);
	DDX_Text(pDX, IDC_EDIT_TOP_PIN_NAMES, CMTopPinNames);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(TCCreateSymbolFromSchematic, CDialog)
	//{{AFX_MSG_MAP(TCCreateSymbolFromSchematic)
	ON_BN_CLICKED(IDC_HELP_CREATE_SYMBOL, OnHelpCreateSymbol)
	ON_BN_CLICKED(IDC_HELP, OnHelp)
	ON_BN_CLICKED(IDC_BUTTON_BROWSE_SYMBOL_FILE_NAME, OnButtonBrowseSymbolFileName)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// TCCreateSymbolFromSchematic message handlers

void TCCreateSymbolFromSchematic::OnOK() 
{
	GetDisplay();

	if(!ValidateData()) return;

	if(!CCreateSymbolFromSchematicData.CAllList.GetSize())
	{
		AfxMessageBox(IDS_NO_SYMBOL_PINS);

		return;
	}

	CDialog::OnOK();
}

bool TCCreateSymbolFromSchematic::ValidateData(void)
{
	return CCreateSymbolFromSchematicData.ValidateStringsToArrays();
}

void TCCreateSymbolFromSchematic::GetDisplay(void)
{
	UpdateData(true);

	CCreateSymbolFromSchematicData.CAll				= CMAllSymbolNames;
	CCreateSymbolFromSchematicData.CBottom			= CMBottomPinNames;
	CCreateSymbolFromSchematicData.CLeft			= CMLeftPinNames;
	CCreateSymbolFromSchematicData.CRight			= CMRightPinNames;
	CCreateSymbolFromSchematicData.CSymbolFileName	= CMSymbolFileName;
	CCreateSymbolFromSchematicData.CSymbolName		= CMSymbolName;
	CCreateSymbolFromSchematicData.CTop				= CMTopPinNames;

	CCreateSymbolFromSchematicData.CreateArraysFromString();
}

void TCCreateSymbolFromSchematic::SetDisplay(void)
{
	CMAllSymbolNames	= CCreateSymbolFromSchematicData.CAll;
	CMBottomPinNames	= CCreateSymbolFromSchematicData.CBottom;
	CMLeftPinNames		= CCreateSymbolFromSchematicData.CLeft;
	CMRightPinNames		= CCreateSymbolFromSchematicData.CRight;
	CMSymbolFileName	= CCreateSymbolFromSchematicData.CSymbolFileName;
	CMSymbolName		= CCreateSymbolFromSchematicData.CSymbolName;
	CMTopPinNames		= CCreateSymbolFromSchematicData.CTop;

	UpdateData(false);
}

BOOL TCCreateSymbolFromSchematic::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	SetDisplay();

	return TRUE;  
}

void TCCreateSymbolFromSchematic::OnHelpCreateSymbol() 
{
	TCSuperSpiceApp	*PCSuperSpiceApp = (TCSuperSpiceApp	*)AfxGetApp();

	if(!PCSuperSpiceApp) return;

	PCSuperSpiceApp->DialogHelp(IDD_DIALOG_CREATE_SYMBOL + HID_BASE_RESOURCE);	
}

void TCCreateSymbolFromSchematic::OnButtonBrowseSymbolFileName() 
{
	TCMasterSymbolDlg CSymbolDlg;

	TCComponentDataBaseData CComponentDataBaseData;
		
	CSymbolDlg.CComponentDataBaseData.CSymbolPathName	= ExtractPathName(CCreateSymbolFromSchematicData.CSymbolFileName);
	CSymbolDlg.CComponentDataBaseData.CSymbolFileName	= ExtractFileName(CCreateSymbolFromSchematicData.CSymbolFileName);
	CSymbolDlg.CComponentDataBaseData.CSymbolName		= CCreateSymbolFromSchematicData.CSymbolName;

	if(CSymbolDlg.DoModal() != IDOK) return;

	CCreateSymbolFromSchematicData.CSymbolFileName = CSymbolDlg.CComponentDataBaseData.CSymbolPathName + CSymbolDlg.CComponentDataBaseData.CSymbolFileName;

	SetDisplay();
}
