#include "float.h"
#include "stdafx.h"
#include "TDVersion.h"
#include "TCMKSConvert.h"
#include "TCStringFunctions.h"
#include "TCCreateSymbolFromSchematicData.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

extern bool SaveGenericToArchive(CObject *, CString);
extern bool LoadGenericFromArchive(CObject *, CString);

IMPLEMENT_SERIAL(TCCreateSymbolFromSchematicData, CObject, ID_VERSION_NUMBER)

TCCreateSymbolFromSchematicData::TCCreateSymbolFromSchematicData(void)
{

}
TCCreateSymbolFromSchematicData::TCCreateSymbolFromSchematicData(TCCreateSymbolFromSchematicData &CCreateSymbolFromSchematicData)
{
	*this = CCreateSymbolFromSchematicData;
}
TCCreateSymbolFromSchematicData::~TCCreateSymbolFromSchematicData(void)
{

}

void TCCreateSymbolFromSchematicData::Serialize(CArchive& CArchiveFile)
{
	CObject::Serialize(CArchiveFile);
	int count, p;
	int magic_number		= 1234;
	int magic_number_test = 0;

	if(CArchiveFile.IsStoring())
	{
		CArchiveFile << magic_number;

		CArchiveFile << CSymbolName;
		CArchiveFile << CSymbolFileName;
		CArchiveFile << CSchematicName;

		CArchiveFile << CModelName;
		CArchiveFile << CModelFileName;

		CArchiveFile << CAll;
		CArchiveFile << CTop;
		CArchiveFile << CBottom;
		CArchiveFile << CLeft;
		CArchiveFile << CRight;

		count = CAllList.GetSize();
		CArchiveFile << count;
		for(p = 0; p < count; p++ ) CArchiveFile << CAllList[p];

		count = CTopList.GetSize();
		CArchiveFile << count;
		for(p = 0; p < count; p++ ) CArchiveFile << CTopList[p];

		count = CBottomList.GetSize();
		CArchiveFile << count;
		for(p = 0; p < count; p++ ) CArchiveFile << CBottomList[p];

		count = CLeftList.GetSize();
		CArchiveFile << count;
		for(p = 0; p < count; p++ ) CArchiveFile << CLeftList[p];

		count = CRightList.GetSize();
		CArchiveFile << count;
		for(p = 0; p < count; p++ ) CArchiveFile << CRightList[p];

		count = CPinID.GetSize();
		CArchiveFile << count;
		for(p = 0; p < count; p++ ) CArchiveFile << CPinID[p];

	}
	else
	{
		CArchiveFile >> magic_number_test;

		CArchiveFile >> CSymbolName;
		CArchiveFile >> CSymbolFileName;
		CArchiveFile >> CSchematicName;

		CArchiveFile >> CModelName;
		CArchiveFile >> CModelFileName;

		CArchiveFile >> CAll;
		CArchiveFile >> CTop;
		CArchiveFile >> CBottom;
		CArchiveFile >> CLeft;
		CArchiveFile >> CRight;

		CArchiveFile >> count;
		CAllList.SetSize(count);
		for(p = 0; p < count; p++ ) CArchiveFile >> CAllList[p];

		CArchiveFile >> count;
		CTopList.SetSize(count);
		for(p = 0; p < count; p++ ) CArchiveFile >> CTopList[p];

		CArchiveFile >> count;
		CBottomList.SetSize(count);
		for(p = 0; p < count; p++ ) CArchiveFile >> CBottomList[p];

		CArchiveFile >> count;
		CLeftList.SetSize(count);
		for(p = 0; p < count; p++ ) CArchiveFile >> CLeftList[p];

		CArchiveFile >> count;
		CRightList.SetSize(count);
		for(p = 0; p < count; p++ ) CArchiveFile >> CRightList[p];

		CArchiveFile >> count;
		CPinID.SetSize(count);
		for(p = 0; p < count; p++ ) CArchiveFile >> CPinID[p];
	}
}

void TCCreateSymbolFromSchematicData::operator = (TCCreateSymbolFromSchematicData &CCreateSymbolFromSchematicData)
{
	CSymbolName		= CCreateSymbolFromSchematicData.CSymbolName;
	CSymbolFileName = CCreateSymbolFromSchematicData.CSymbolFileName;
	CSchematicName	= CCreateSymbolFromSchematicData.CSchematicName;

	CModelName		= CCreateSymbolFromSchematicData.CModelName;
	CModelFileName	= CCreateSymbolFromSchematicData.CModelFileName;

	CAll	= CCreateSymbolFromSchematicData.CAll;
	CTop	= CCreateSymbolFromSchematicData.CTop;
	CBottom = CCreateSymbolFromSchematicData.CBottom;
	CLeft	= CCreateSymbolFromSchematicData.CLeft;
	CRight	= CCreateSymbolFromSchematicData.CRight;

	int count, p;

	count = CCreateSymbolFromSchematicData.CAllList.GetSize();

	CAllList.SetSize(count);

	for(p = 0; p < count; p++ ) CAllList[p] = CCreateSymbolFromSchematicData.CAllList[p];
	
	count = CCreateSymbolFromSchematicData.CTopList.GetSize();

	CTopList.SetSize(count);

	for(p = 0; p < count; p++ ) CTopList[p] = CCreateSymbolFromSchematicData.CTopList[p];

	count = CCreateSymbolFromSchematicData.CBottomList.GetSize();

	CBottomList.SetSize(count);

	for(p = 0; p < count; p++ ) CBottomList[p] = CCreateSymbolFromSchematicData.CBottomList[p];

	count = CCreateSymbolFromSchematicData.CLeftList.GetSize();

	CLeftList.SetSize(count);

	for(p = 0; p < count; p++ ) CLeftList[p] = CCreateSymbolFromSchematicData.CLeftList[p];

	count = CCreateSymbolFromSchematicData.CRightList.GetSize();

	CRightList.SetSize(count);

	for(p = 0; p < count; p++ ) CRightList[p] = CCreateSymbolFromSchematicData.CRightList[p];

	count = CCreateSymbolFromSchematicData.CPinID.GetSize();

	CPinID.SetSize(count);

	for(p = 0; p < count; p++ ) CPinID[p] = CCreateSymbolFromSchematicData.CPinID[p];
}

void TCCreateSymbolFromSchematicData::CreateArraysFromString(void)
{
	CTopList.SetSize(0, 32);
	CBottomList.SetSize(0, 32);
	CLeftList.SetSize(0, 32);
	CRightList.SetSize(0, 32);

	CString CFirstWord, CNextLine;

	CFirstWord = GetFirstWord(CTop);

	CNextLine = RemoveFirstWord(CTop);

	while(CFirstWord != "")
	{
		CTopList.Add(CFirstWord);

		CFirstWord = GetFirstWord(CNextLine);

		CNextLine = RemoveFirstWord(CNextLine);
	}

	CFirstWord = GetFirstWord(CBottom);

	CNextLine = RemoveFirstWord(CBottom);

	while(CFirstWord != "")
	{
		CBottomList.Add(CFirstWord);

		CFirstWord = GetFirstWord(CNextLine);

		CNextLine = RemoveFirstWord(CNextLine);
	}

	CFirstWord = GetFirstWord(CLeft);

	CNextLine = RemoveFirstWord(CLeft);

	while(CFirstWord != "")
	{
		CLeftList.Add(CFirstWord);

		CFirstWord = GetFirstWord(CNextLine);

		CNextLine = RemoveFirstWord(CNextLine);
	}

	CFirstWord = GetFirstWord(CRight);

	CNextLine = RemoveFirstWord(CRight);

	while(CFirstWord != "")
	{
		CRightList.Add(CFirstWord);

		CFirstWord = GetFirstWord(CNextLine);

		CNextLine = RemoveFirstWord(CNextLine);
	}
}

void TCCreateSymbolFromSchematicData::CreateStringsFromArrays(void)
{
	int count, p;
	
	CTop	= "";
	CBottom	= "";
	CLeft	= "";
	CRight	= "";

	count = CTopList.GetSize();

	for(p = 0; p < count; p++ )
	{
		CTop += CTopList[p] + " ";
	}

	CTop.TrimLeft();

	count = CBottomList.GetSize();

	for(p = 0; p < count; p++ )
	{
		CBottom += CBottomList[p] + " ";
	}

	CBottom.TrimLeft();

	count = CLeftList.GetSize();

	for(p = 0; p < count; p++ )
	{
		CLeft += CLeftList[p] + " ";
	}

	CLeft.TrimLeft();

	count = CRightList.GetSize();

	for(p = 0; p < count; p++ )
	{
		CRight += CRightList[p] + " ";
	}

	CRight.TrimLeft();
}

void TCCreateSymbolFromSchematicData::CreateAllDataFromPinStrings(void)
{
	CAll = CTop + ' ' + CBottom + ' ' + CLeft + ' ' + CRight;

	CAllList.SetSize(0, 32);
	CPinID.SetSize(0, 32);

	CString CFirstWord, CNextLine;

	CFirstWord = GetFirstWord(CAll);

	CNextLine = RemoveFirstWord(CAll);

	int pin_counter = 0;

	while(CFirstWord != "")
	{
		CAllList.Add(CFirstWord);
		CPinID.Add(pin_counter);

		CFirstWord = GetFirstWord(CNextLine);

		CNextLine = RemoveFirstWord(CNextLine);

		pin_counter++;
	}
}

bool TCCreateSymbolFromSchematicData::ValidateStringsToArrays(void)
{


	return true;
}

void TCCreateSymbolFromSchematicData::RemoveDeletedFromLists(void)
{
	CreateArraysFromString();

	int count, p;
	
	CString CTemp;

	CTop	= "";
	CBottom	= "";
	CLeft	= "";
	CRight	= "";

	count = CTopList.GetSize();

	for(p = 0; p < count; p++ )
	{
		CTemp = CTopList[p];

		if(FindID(CTemp) < 0) continue;

		CTop += CTemp + " ";
	}

	CTop.TrimLeft();

	count = CBottomList.GetSize();

	for(p = 0; p < count; p++ )
	{
		CTemp = CBottomList[p];

		if(FindID(CTemp) < 0) continue;

		CBottom += CTemp  + " ";
	}

	CBottom.TrimLeft();

	count = CLeftList.GetSize();

	for(p = 0; p < count; p++ )
	{
		CTemp = CLeftList[p];

		if(FindID(CTemp) < 0) continue;

		CLeft += CTemp + " ";
	}

	CLeft.TrimLeft();

	count = CRightList.GetSize();

	for(p = 0; p < count; p++ )
	{
		CTemp = CRightList[p];

		if(FindID(CTemp) < 0) continue;

		CRight +=  CTemp + " ";
	}

	CRight.TrimLeft();
}

int TCCreateSymbolFromSchematicData::FindID(CString CName)
{
	int count, p;

	CName.MakeLower();

	CString CPinName;

	count = CAllList.GetSize();

	if(count != CPinID.GetSize()) return -1;

	for(p = 0; p < count; p++ )
	{
		CPinName = CAllList[p];

		CPinName.MakeLower();

		if(CPinName != CName) continue;

		return CPinID[p];
	}

	return -1;
}

CString TCCreateSymbolFromSchematicData::FindName(int id)
{
	if(id < 0) return "";

	int p, count;
	CString CName;

	if(!(id < CAllList.GetSize())) return "";

	count = CPinID.GetSize();

	for(p = 0; p < count; p++)
	{
		if(!CPinID[p] == id) continue;
		
		return CAllList[p];
	}

	return "";
}

bool TCCreateSymbolFromSchematicData::Load(void)
{
	if(RemoveExtention(CSchematicName) == "") return false;

	CString CFileName = ReplaceFileExtension(CSchematicName, "ssp");

	return LoadGenericFromArchive(this, CFileName);
}

bool TCCreateSymbolFromSchematicData::Save(void)
{
	if(RemoveExtention(CSchematicName) == "") return false;

	CString CFileName = ReplaceFileExtension(CSchematicName, "ssp");

	return SaveGenericToArchive(this, CFileName);
}