#include "stdafx.h"
#include "TDVersion.h"
#include "TCDataBaseIdInfo.h"

IMPLEMENT_SERIAL(TCDataBaseIdInfo, CObject, ID_VERSION_NUMBER)

CString ReplaceWCType(CString WCType);

TCDataBaseIdInfo::TCDataBaseIdInfo(void)
{
	matched		= 1;
	strength	= 1;//
}

TCDataBaseIdInfo::TCDataBaseIdInfo(TCDataBaseIdInfo &CDataBaseIdInfo)
{
	*this = CDataBaseIdInfo;
}
TCDataBaseIdInfo::~TCDataBaseIdInfo(void)
{

}

void TCDataBaseIdInfo::Serialize(CArchive& CArchiveFile)
{
	CObject::Serialize(CArchiveFile);

	if(CArchiveFile.IsStoring())
	{
		CArchiveFile << matched;
		CArchiveFile << strength;
		CArchiveFile << model_type;
		CArchiveFile << CRecordName;
		CArchiveFile << CRecordFileName;
		CArchiveFile << CRecordFilePath;
		CArchiveFile << CRecordType;
		CArchiveFile << CModelType;
		CArchiveFile << CDescription;
		CArchiveFile << CNotes;
//		CArchiveFile << CSymbolName; // do not add in until back support is done, this gets recalculated anyway
//		CArchiveFile << CSymbolFileName;
	}
	else
	{
		CArchiveFile >> matched;
		CArchiveFile >> strength;
		CArchiveFile >> model_type;
		CArchiveFile >> CRecordName;
		CArchiveFile >> CRecordFileName;
		CArchiveFile >> CRecordFilePath;
		CArchiveFile >> CRecordType;
		CArchiveFile >> CModelType;
		CArchiveFile >> CDescription;
		CArchiveFile >> CNotes;
//		CArchiveFile >> CSymbolName; // do not add in until back support is done, this gets recalculated anyway
//		CArchiveFile >> CSymbolFileName;
	}
}
void TCDataBaseIdInfo::operator = (TCDataBaseIdInfo &CDataBaseIdInfo)
{
	matched			= CDataBaseIdInfo.matched;
	strength		= CDataBaseIdInfo.strength;
	model_type		= CDataBaseIdInfo.model_type;
	CRecordName		= CDataBaseIdInfo.CRecordName;
	CRecordFileName = CDataBaseIdInfo.CRecordFileName;
	CRecordFilePath = CDataBaseIdInfo.CRecordFilePath;
	CRecordType		= CDataBaseIdInfo.CRecordType;
	CModelType		= CDataBaseIdInfo.CModelType;
	CDescription	= CDataBaseIdInfo.CDescription;
	CNotes			= CDataBaseIdInfo.CNotes;
	CSymbolName		= CDataBaseIdInfo.CSymbolName;
	CSymbolFileName = CDataBaseIdInfo.CSymbolFileName;
}

bool TCDataBaseIdInfo::operator == (TCDataBaseIdInfo  &CDataBaseIdInfo)
{
	if(matched != CDataBaseIdInfo.matched) return false;
	if(strength != CDataBaseIdInfo.strength) return false;
	if(model_type != CDataBaseIdInfo.model_type) return false;

	CString CTemp1, CTemp2;

	CTemp1 = CRecordName;
	CTemp2 = CDataBaseIdInfo.CRecordName;

	CTemp1.MakeUpper();
	CTemp2.MakeUpper();

	if(CTemp1 != CTemp2) return false;

	CTemp1 = CRecordFileName;
	CTemp2 = CDataBaseIdInfo.CRecordFileName;

	CTemp1.MakeUpper();
	CTemp2.MakeUpper();

	if(CTemp1 != CTemp2) return false;

	CTemp1 = CRecordType;
	CTemp2 = CDataBaseIdInfo.CRecordType;

	CTemp1.MakeUpper();
	CTemp2.MakeUpper();

	if(CTemp1 != CTemp2) return false;

	CTemp1 = CRecordFilePath;
	CTemp2 = CDataBaseIdInfo.CRecordFilePath;

	CTemp1.MakeUpper();
	CTemp2.MakeUpper();

	if(CTemp1 != CTemp2) return false;

	CTemp1 = CModelType;
	CTemp2 = CDataBaseIdInfo.CModelType;

	CTemp1.MakeUpper();
	CTemp2.MakeUpper();

	if(CTemp1 != CTemp2) return false;

	// ignor description

	return true;
}

bool TCDataBaseIdInfo::operator != (TCDataBaseIdInfo  &CDataBaseIdInfo)
{
	return !(*this == CDataBaseIdInfo);
}

CString TCDataBaseIdInfo::GetBaseRecordName(void)
{
	CString CBaseRecordName;

	int length = CRecordName.GetLength();

	if(length < 3) return "";

	CBaseRecordName = CRecordName.Left(length - 3);

	return CBaseRecordName;
}

void TCDataBaseIdInfo::SetWCRecordName(CString CWCNameExt)
{
	int length = CRecordName.GetLength();

	if(length < 3) return;

	CRecordName = CRecordName.Left(length - 3);

	CRecordName += CWCNameExt;
}

CString TCDataBaseIdInfo::GetRecordName(void)
{
	return CRecordName;// future expansion
}

void TCDataBaseIdInfo::SetRecordName(CString CRecordNameSet)
{
	CRecordName = CRecordNameSet; // future expansion
}

CString ReplaceWCType(CString CTextData, CString WCType)
{
	int length = CTextData.GetLength();

	if(length < 3) return CTextData;

	CTextData = CTextData.Left(length - 3);

	CTextData += WCType;

	return CTextData;
}