// TCDiodeLabelsDlg.cpp : implementation file
//

#include "stdafx.h"
#include "resource.h"
#include "TESuperSpiceLabelEnums.h"
#include "TCMKSConvert.h"
#include "TCSchematicObjectData.h"
#include "TCDiodeLabelsDlg.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

IMPLEMENT_DYNCREATE(TCDiodeLabelsDlg, CPropertyPage)

extern int g_last_active_component_property_page;

/////////////////////////////////////////////////////////////////////////////
// TCDiodeLabelsDlg property page

TCDiodeLabelsDlg::TCDiodeLabelsDlg() : CPropertyPage(TCDiodeLabelsDlg::IDD)
{
	//{{AFX_DATA_INIT(TCDiodeLabelsDlg)
	m_ref_des_visable = FALSE;
	m_spice_name_visable = FALSE;
	m_value_visable = FALSE;
	CMEditSpicename = _T("");
	CMEditRefDes = _T("");
	CMEditValue = _T("");
	m_type_name_visable = FALSE;
	CMEditTypeName = _T("");
	m_check_visable_bv = FALSE;
	m_check_visable_area = FALSE;
	CMEditArea = _T("");
	CMBreakDownVoltage = _T("");
	//}}AFX_DATA_INIT
}

TCDiodeLabelsDlg::~TCDiodeLabelsDlg()
{
}

void TCDiodeLabelsDlg::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(TCDiodeLabelsDlg)
	DDX_Control(pDX, IDC_EDIT_VALUE, CMEditCntlValue);
	DDX_Control(pDX, IDC_EDIT_SPICE_NAME, CMEditCntlSpiceName);
	DDX_Control(pDX, IDC_EDIT_TYPE_NAME, CMEditCntlTypeName);
	DDX_Check(pDX, IDC_CHECK_VISABLE_REF_DESIGNATOR, m_ref_des_visable);
	DDX_Check(pDX, IDC_CHECK_VISABLE_SPICE_NAME, m_spice_name_visable);
	DDX_Check(pDX, IDC_CHECK_VISABLE_VALUE, m_value_visable);
	DDX_Text(pDX, IDC_EDIT_SPICE_NAME, CMEditSpicename);
	DDX_Text(pDX, IDC_EDIT_REF_DESIGNATOR, CMEditRefDes);
	DDX_Text(pDX, IDC_EDIT_VALUE, CMEditValue);
	DDX_Check(pDX, IDC_CHECK_VISABLE_TYPE_NAME, m_type_name_visable);
	DDX_Text(pDX, IDC_EDIT_TYPE_NAME, CMEditTypeName);
	DDX_Check(pDX, IDC_CHECK_VISABLE_BV, m_check_visable_bv);
	DDX_Check(pDX, IDC_CHECK_VISABLE_AREA, m_check_visable_area);
	DDX_Text(pDX, IDC_EDIT_AREA, CMEditArea);
	DDX_Text(pDX, IDC_EDIT_BREAKDOWN_VOLT, CMBreakDownVoltage);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(TCDiodeLabelsDlg, CPropertyPage)
	//{{AFX_MSG_MAP(TCDiodeLabelsDlg)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()



BOOL TCDiodeLabelsDlg::OnKillActive() 
{
	
	CPropertyPage::OnKillActive();

	if(!PCSchematicObjectData) return true;

	PCSchematicObjectData->CLabelListData[E_COMPONENT_SYMBOL_NAME].is_visable = !!m_type_name_visable;
	PCSchematicObjectData->CLabelListData[E_COMPONENT_SYMBOL_NAME].CLabel = 	CMEditTypeName;

	PCSchematicObjectData->CLabelListData[E_COMPONENT_VALUE].is_visable = !!m_value_visable;
	PCSchematicObjectData->CLabelListData[E_COMPONENT_VALUE].CLabel = CMEditValue;

	PCSchematicObjectData->CLabelListData[E_COMPONENT_DESIGNATOR].is_visable = !!m_ref_des_visable;
	PCSchematicObjectData->CLabelListData[E_COMPONENT_DESIGNATOR].CLabel = CMEditRefDes;

	PCSchematicObjectData->CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].is_visable = !!m_spice_name_visable;
	PCSchematicObjectData->CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel = CMEditSpicename;

	PCSchematicObjectData->CLabelListData[E_COMPONENT_DIODE_M].is_visable = !!m_check_visable_area;
	PCSchematicObjectData->CLabelListData[E_COMPONENT_DIODE_M].CLabelValue = CMEditArea;

	CMBreakDownVoltage.TrimLeft();
	CMBreakDownVoltage.TrimRight();

	PCSchematicObjectData->CLabelListData[E_COMPONENT_DIODE_BREAKDOWN_VOLTAGE].is_visable = !!m_check_visable_bv;
	PCSchematicObjectData->CLabelListData[E_COMPONENT_DIODE_BREAKDOWN_VOLTAGE].CLabelValue = CMBreakDownVoltage;
	
	PCSchematicObjectData->FormatLabel();

	return true;
}

BOOL TCDiodeLabelsDlg::OnSetActive() 
{
	g_last_active_component_property_page = 0;
	
	CMEditValue	=  PCSchematicObjectData->CLabelListData[E_COMPONENT_VALUE].CLabel;

	PCSchematicObjectData->FormatSpiceName();

	CMEditSpicename	=  PCSchematicObjectData->CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel;

	CMBreakDownVoltage = PCSchematicObjectData->CLabelListData[E_COMPONENT_DIODE_BREAKDOWN_VOLTAGE].CLabelValue;

	return CPropertyPage::OnSetActive();
}

BOOL TCDiodeLabelsDlg::OnInitDialog() 
{
	 
	m_type_name_visable = PCSchematicObjectData->CLabelListData[E_COMPONENT_SYMBOL_NAME].is_visable;
	CMEditTypeName		=  PCSchematicObjectData->CLabelListData[E_COMPONENT_SYMBOL_NAME].CLabel;

	m_value_visable = PCSchematicObjectData->CLabelListData[E_COMPONENT_VALUE].is_visable;
	CMEditValue		=  PCSchematicObjectData->CLabelListData[E_COMPONENT_VALUE].CLabel;

	m_ref_des_visable = PCSchematicObjectData->CLabelListData[E_COMPONENT_DESIGNATOR].is_visable;
	CMEditRefDes		=  PCSchematicObjectData->CLabelListData[E_COMPONENT_DESIGNATOR].CLabel;

	m_spice_name_visable = PCSchematicObjectData->CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].is_visable;
	CMEditSpicename		=  PCSchematicObjectData->CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel;

	m_check_visable_area = PCSchematicObjectData->CLabelListData[E_COMPONENT_DIODE_M].is_visable;
	CMEditArea = PCSchematicObjectData->CLabelListData[E_COMPONENT_DIODE_M].CLabelValue;

	m_check_visable_bv = PCSchematicObjectData->CLabelListData[E_COMPONENT_DIODE_BREAKDOWN_VOLTAGE].is_visable;
	
	CMBreakDownVoltage = PCSchematicObjectData->CLabelListData[E_COMPONENT_DIODE_BREAKDOWN_VOLTAGE].CLabelValue;

	CMBreakDownVoltage.TrimLeft();
	CMBreakDownVoltage.TrimRight();

	double breakdown_volt;

	if(CMBreakDownVoltage == "")
		if(PCSchematicObjectData->CSpiceParameters.Get("BV", &breakdown_volt))// changed to parameter passed
			CMBreakDownVoltage = FloatToMKSString(breakdown_volt);

	CPropertyPage::OnInitDialog();
	
//	CMEditCntlTypeName.SetReadOnly(PCSchematicObjectData->CLabelListData[E_COMPONENT_SYMBOL_NAME].read_only);
//	CMEditCntlSpiceName.SetReadOnly(PCSchematicObjectData->CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].read_only);
	CMEditCntlValue.SetReadOnly(PCSchematicObjectData->CLabelListData[E_COMPONENT_VALUE].read_only);

	return TRUE;  
}
