#include "stdafx.h"
#include "TDVersion.h"
#include "Generic.h"
#include "SuperSpice.h"
#include "TCDocumentWindowsList.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

IMPLEMENT_SERIAL(TCDocumentWindowsList, CObject, ID_VERSION_NUMBER)
IMPLEMENT_SERIAL(TCDocumentWindowsListData, CObject, ID_VERSION_NUMBER)

CMultiDocTemplate *GetDocTemplate(TE_DOCUMENT_TYPES type)
{
	TCSuperSpiceApp *PCSuperSpiceApp = (TCSuperSpiceApp*) AfxGetApp();

	switch(type)
	{
		case E_GENERIC_TEXT:			return PCSuperSpiceApp->GetSpiceTextViewDocTemplate();
		case E_SCHEMATIC_DOCUMENT:		return PCSuperSpiceApp->GetSuperSpiceDocTemplate();
		case E_NETLIST_DOCUMENT:		return PCSuperSpiceApp->GetSpiceNetListViewDocTemplate();
		case E_OUTPUT_TEXT_DOCUMENT:	return PCSuperSpiceApp->GetSpiceOutputTextViewDocTemplate();
		case E_WAVEFORM_DOCUMENT:		return PCSuperSpiceApp->GetWaveformDisplayDocTemplate();
		case E_SYMBOL_DOCUMENT:			return PCSuperSpiceApp->GetSpiceSchematicSymbolViewDocTemplate();
		case E_SPICE_LIBARY_DOCUMENT:	return PCSuperSpiceApp->GetSpiceLibaryViewDocTemplate();
		case E_SPICE_MODEL_DOCUMENT:	return PCSuperSpiceApp->GetSpiceModelViewDocTemplate();
		case E_SPICE_ENGINE_LOG_DOCUMENT: return PCSuperSpiceApp->GetEngineErrorLogTemplate();

		default: return NULL;
	}
}

TCDocumentWindowsListData::TCDocumentWindowsListData(void)
{
	PCMultiDocTemplate	= NULL;
	PCDoc				= NULL;
	PCParentDoc			= NULL;
	type				= E_GENERIC_TEXT;
	is_open				= false;
	is_saved			= false;

	s_window_placment = GetDefaultWindowPlacment();
}

TCDocumentWindowsListData::TCDocumentWindowsListData(TCDocumentWindowsListData &CDocumentWindowsListData)
{
	*this = CDocumentWindowsListData;
}
TCDocumentWindowsListData::~TCDocumentWindowsListData(void)
{

}

void TCDocumentWindowsListData::Serialize(CArchive& CArchiveFile)
{
	CObject::Serialize(CArchiveFile);

	int temp = (TE_DOCUMENT_TYPES) type;
	int p, count;

	if(CArchiveFile.IsStoring())
	{
		CArchiveFile << CFileName;
		CArchiveFile << temp;
		CArchiveFile << is_open;
		CArchiveFile << is_saved;
		CArchiveFile << is_docked;
		CArchiveFile << CParentRefDes;
		CArchiveFile.Write(&type, sizeof(type));
		CArchiveFile.Write(&s_window_placment, sizeof(s_window_placment));

		count = CParentRefIDList.GetSize();
		
		CArchiveFile << count;

		for(p = 0; p < count; p++) CArchiveFile << CParentRefIDList[p];


	}
	else
	{
		CArchiveFile >> CFileName;
		CArchiveFile >> temp;
		CArchiveFile >> is_open;
		CArchiveFile >> is_saved;
		CArchiveFile >> is_docked;
		CArchiveFile >> CParentRefDes;
		CArchiveFile.Read(&type, sizeof(type));
		CArchiveFile.Read(&s_window_placment, sizeof(s_window_placment));

		CArchiveFile >> count;

		CParentRefIDList.SetSize(count);

		for(p = 0; p < count; p++) CArchiveFile >> CParentRefIDList[p];


		type = (TE_DOCUMENT_TYPES)temp;

		PCDoc		= NULL;
		PCParentDoc	= NULL;

		PCMultiDocTemplate = GetDocTemplate(type);
	}
}

void TCDocumentWindowsListData::operator = (TCDocumentWindowsListData &CDocumentWindowsListData)
{
	PCMultiDocTemplate	= CDocumentWindowsListData.PCMultiDocTemplate;
	CFileName			= CDocumentWindowsListData.CFileName;
	PCDoc				= CDocumentWindowsListData.PCDoc;
	PCParentDoc			= CDocumentWindowsListData.PCParentDoc;
	type				= CDocumentWindowsListData.type;
	is_open				= CDocumentWindowsListData.is_open;
	is_saved			= CDocumentWindowsListData.is_saved;
	is_docked			= is_docked;
	s_window_placment   = CDocumentWindowsListData.s_window_placment;
	CParentRefDes		= CDocumentWindowsListData.CParentRefDes;

	int p, count;

	count = CDocumentWindowsListData.CParentRefIDList.GetSize();

	CParentRefIDList.SetSize(count);

	for(p = 0; p < count; p++)CParentRefIDList[p] = CDocumentWindowsListData.CParentRefIDList[p];

}

void TCDocumentWindowsListData::SaveWindowPosition(void)
{
	if(!PCDoc) return;
	if(!is_open) return;

	POSITION pos = PCDoc->GetFirstViewPosition();

	if(!pos) return;

	CView* PCView = PCDoc->GetNextView(pos);

	if(!PCView) return;

	is_saved = true;

	PCView->GetParent()->GetWindowPlacement(&s_window_placment);
}

void TCDocumentWindowsListData::LoadWindowPosition(void)
{
	if(!PCDoc) return;
	if(!is_saved) return;

	POSITION pos = PCDoc->GetFirstViewPosition();

	if(!pos) return;

	CView* PCView = PCDoc->GetNextView(pos);

	if(!PCView) return;

	PCView->GetParent()->SetWindowPlacement(&s_window_placment);
}

CDocument *TCDocumentWindowsListData::Open(CDocument *PCParentDocument)
{
	if(!PCDoc)
	{
		PCDoc = OpenWindow(PCMultiDocTemplate, CFileName);

		if(!PCDoc)
		{
			is_open = false;

			return false;
		}

		LoadWindowPosition();

		is_open		= true;
		PCParentDoc = PCParentDocument;

		return PCDoc;
	}

	if(!ActivateADocumentView(PCDoc))
	{
		is_open = false;
		PCDoc = NULL;

		return NULL;
	}

	is_open = true;

	return PCDoc;
}

bool TCDocumentWindowsListData::Close(void)
{
	SaveWindowPosition();

	if(type == E_SCHEMATIC_DOCUMENT)
	{
		type = E_SCHEMATIC_DOCUMENT;
	}

	CDocument *PDocTest = PCDoc;

	if(PCDoc) PCDoc->OnCloseDocument();

	if(PDocTest != PCDoc)
	{
		type = E_SCHEMATIC_DOCUMENT;
	}

	is_open		= false;
	PCDoc		= NULL;
	PCParentDoc	= NULL;

	return true;
}

int TCDocumentWindowsListData::Save(void)
{
	if(!PCDoc) return true;

	int flag = false;

	flag = (int)PCDoc->DoFileSave();

	return flag;
}

////////////////////////////////////////////////////////
TCDocumentWindowsList::TCDocumentWindowsList(void)
{
	index = 0;
}
TCDocumentWindowsList::TCDocumentWindowsList(TCDocumentWindowsList &CDocumentWindowsList)
{
	*this = CDocumentWindowsList;
}
TCDocumentWindowsList::~TCDocumentWindowsList(void)
{

}

void TCDocumentWindowsList::Serialize(CArchive& CArchiveFile)
{
	CObject::Serialize(CArchiveFile);

	int p, count;

	if(CArchiveFile.IsStoring())
	{
		CArchiveFile << index;
		CArchiveFile << CFileIndexedName;
		CArchiveFile << CFileName;
		CArchiveFile << CThisFileName;

		count = CDocList.GetSize();

		CArchiveFile << count;

		for(p = 0; p < count; p++) CDocList[p].Serialize(CArchiveFile);
	}
	else
	{
		CArchiveFile >> index;
		CArchiveFile >> CFileIndexedName;
		CArchiveFile >> CFileName;
		CArchiveFile >> CThisFileName;

		CArchiveFile >> count;

		CDocList.SetSize(count, count);

		for(p = 0; p < count; p++) CDocList[p].Serialize(CArchiveFile);
	}
}

void TCDocumentWindowsList::operator = (TCDocumentWindowsList &CDocumentWindowsList)
{
	int p, count;

	index			 = CDocumentWindowsList.index;
	CFileIndexedName = CDocumentWindowsList.CFileIndexedName;
	CThisFileName	 = CDocumentWindowsList.CThisFileName;

	CFileName = CDocumentWindowsList.CFileName;

	count = CDocumentWindowsList.CDocList.GetSize();

	CDocList.SetSize(count, count);

	for(p = 0; p < count; p++) CDocList[p] = CDocumentWindowsList.CDocList[p];
}

CDocument *TCDocumentWindowsList::GetDoc(CString CFileName)
{
	int p, count;

	CFileName.MakeUpper();

	count = CDocList.GetSize();

	CString CText;

	for(p = 0; p < count; p++) 
	{
		CText = CDocList[p].CFileName;
	
		CText.MakeUpper();

		if(CText != CFileName) continue;

		return CDocList[p].PCDoc;
	}

	return NULL;
}

CDocument *TCDocumentWindowsList::GetParent(CDocument *PCDocChild)
{
	int p, count;

	count = CDocList.GetSize();

	for(p = 0; p < count; p++) 
	{
		if(PCDocChild != CDocList[p].PCDoc) continue;
	
		return CDocList[p].PCParentDoc;
	}

	return NULL;
}

int TCDocumentWindowsList::GetDocId(CString CFileName, CString CRefDes)
{
	int p, count;

	CFileName.MakeUpper();

	count = CDocList.GetSize();

	CString CText;

	for(p = 0; p < count; p++) 
	{
		CText = CDocList[p].CFileName;
	
		CText.MakeUpper();

		if(CText != CFileName) continue;

		if(CRefDes != "")
			if(CRefDes != CDocList[p].CParentRefDes) continue;

		return p;
	}

	return -1;
}

int TCDocumentWindowsList::GetDocId(CDocument *PCDoc, CString CRefDes)
{
	int p, count;

	count = CDocList.GetSize();

	for(p = 0; p < count; p++) 
	{
		if(PCDoc != CDocList[p].PCDoc) continue;

		if(CRefDes != "")
			if(CRefDes != CDocList[p].CParentRefDes) continue;
	
		return p;
	}

	return -1;
}

bool TCDocumentWindowsList::CreateSchematic(CString CFileName, CDocument *PCParent, CArray <CString, CString&> &CRefDesList, CString CRefDes)
{
	return Create(CFileName, E_SCHEMATIC_DOCUMENT, PCParent, CRefDesList, CRefDes);
}

bool TCDocumentWindowsList::Create(CString CFileName, TE_DOCUMENT_TYPES type, CDocument *PCParent, CArray <CString, CString&> &CRefDesList, CString CRefDes, CDocument *PCSourceDoc)
{
	int flag = 0;

	int index = GetDocId(CFileName, ""); //CRefDes to do.

	int count = CRefDesList.GetSize();

	int p;
/*
	if(type == E_SCHEMATIC_DOCUMENT)// added type = E_SCHEMATIC_DOCUMENT to open multiple instances of hireachical schematics
	{
		sch_count = CDocList.GetSize();

		for(q = 0; q < sch_count; q++)
		{
			TCDocumentWindowsListData &CDocListItem = CDocList[q];

			if(CDocumentWindowsListData.type != E_SCHEMATIC_DOCUMENT)  continue;

			if(CDocListItem.CFileName != CFileName) continue;

			if(CRefDes != "";

			if(CDocListItem.CParentRefDes != CRefDes) continue;

			flag = (index < 0);

			break;
		}
	}
*/
	if((index < 0) || flag) 
	{
		TCDocumentWindowsListData CDocumentWindowsListData;

		CDocumentWindowsListData.PCMultiDocTemplate = GetDocTemplate(type);
		CDocumentWindowsListData.CFileName			= CFileName;

		CDocumentWindowsListData.PCParentDoc		= PCParent;
		CDocumentWindowsListData.type				= type;
		CDocumentWindowsListData.CParentRefDes		= CRefDes;

		if(PCSourceDoc)
		{
			CDocumentWindowsListData.PCDoc = PCSourceDoc;
			CDocumentWindowsListData.is_open = true;	
		}

		if(CDocumentWindowsListData.PCParentDoc == CDocumentWindowsListData.PCDoc)
		{
			ASSERT(0);

			CDocumentWindowsListData.PCParentDoc = NULL;
		}

		CDocumentWindowsListData.CParentRefIDList.SetSize(count);

		for(p = 0; p < count; p++)CDocumentWindowsListData.CParentRefIDList[p] = CRefDesList[p];

		CDocList.Add(CDocumentWindowsListData);

		return true;
	}

	TCDocumentWindowsListData &CDocumentWindowsListData = CDocList[index];

	CDocumentWindowsListData.PCMultiDocTemplate = GetDocTemplate(type);
	CDocumentWindowsListData.CFileName			= CFileName;
	CDocumentWindowsListData.PCParentDoc		= PCParent;
	CDocumentWindowsListData.type				= type;
	CDocumentWindowsListData.CParentRefDes		= CRefDes;

	if(PCSourceDoc)
	{
		CDocumentWindowsListData.PCDoc = PCSourceDoc;
		CDocumentWindowsListData.is_open = true;	
	}

	if(CDocumentWindowsListData.PCParentDoc == CDocumentWindowsListData.PCDoc)
	{
		ASSERT(0);

		CDocumentWindowsListData.PCParentDoc = NULL;
	}

	CDocumentWindowsListData.CParentRefIDList.SetSize(count);

	for(p = 0; p < count; p++)CDocumentWindowsListData.CParentRefIDList[p] = CRefDesList[p];

	return true;
}

bool TCDocumentWindowsList::Remove(CString CFileName, bool close_open_docs)
{
	int index = GetDocId(CFileName, "");

	if(index < 0) return false;

	if(close_open_docs) Close(CFileName);

	CDocList.RemoveAt(index);

	return true;
}

void TCDocumentWindowsList::RemoveAllOfType(TE_DOCUMENT_TYPES type, bool close_open_docs)
{
	int p, count;

	CArray <CString, CString> CDocTypeList;

	count = CDocList.GetSize();

	for(p = 0; p < count; p++) // find all of that type
	{
		if(CDocList[p].type != type) continue;

		if(!close_open_docs) if(CDocList[p].is_open)  continue;

		CDocTypeList.Add(CDocList[p].CFileName);
	}

	count = CDocTypeList.GetSize();

	for(p = 0; p < count; p++) 
	{
		Remove(CDocTypeList[p], close_open_docs);
	}
}

void TCDocumentWindowsList::RemoveAllSchematicDocuments(bool close_open_docs)
{
	RemoveAllOfType(E_SCHEMATIC_DOCUMENT,  close_open_docs);
}

CDocument *TCDocumentWindowsList::Open(CDocument *PCParentDoc, CString CFileName)
{
	int index = GetDocId(CFileName, "");

	if(index < 0) return false;

	return CDocList[index].Open(PCParentDoc);
}

bool TCDocumentWindowsList::Close(CString CFileName)
{
	int index = GetDocId(CFileName, "");

	if(index < 0) return false;

	return CDocList[index].Close();
}

bool TCDocumentWindowsList::Get(CString CFileName, TCDocumentWindowsListData &CDocumentWindowsListData)
{
	int index = GetDocId(CFileName, "");

	if(index < 0) return false;

	CDocumentWindowsListData = CDocList[index];

	return true;
}

void TCDocumentWindowsList::Close(void)
{
	int p, count;

	count = CDocList.GetSize();

	for(p = 0; p < count; p++) 
	{
		CDocList[p].Close();
	}
}

bool TCDocumentWindowsList::SaveOpenSchematics(void)
{
	int p, count;
	bool flag = true;

	count = CDocList.GetSize();

	for(p = 0; p < count; p++) 
	{
		if(CDocList[p].type != E_SCHEMATIC_DOCUMENT) continue;

		if(!CDocList[p].Save()) flag = false;
			
	}

	return flag;
}

void TCDocumentWindowsList::Open(CDocument *PCParentDoc)
{
	int p, count;

	count = CDocList.GetSize();

	for(p = 0; p < count; p++) 
	{
		CDocList[p].Open(PCParentDoc);
	}
}

void TCDocumentWindowsList::UpdateWindowPosition(void)
{
	int p, count;

	count = CDocList.GetSize();

	for(p = 0; p < count; p++) 
	{
		if(!CDocList[p].is_open) continue;

		CDocList[p].SaveWindowPosition();
	}
}

bool TCDocumentWindowsList::NotifyDocumentClosed(CDocument *PCDoc)
{
	int index = GetDocId(PCDoc, "");

	if(index < 0) return false;

	TCDocumentWindowsListData &CDocumentWindowsListData = CDocList[index];

	CDocumentWindowsListData.SaveWindowPosition();

	CDocumentWindowsListData.PCDoc		= NULL;
	CDocumentWindowsListData.PCParentDoc= NULL;
	CDocumentWindowsListData.is_open	= false;
					
	return true;
}

CDocument *TCDocumentWindowsList::IsOpen(CString CFileName)
{
	int index = GetDocId(CFileName, "");

	if(index < 0) return NULL;	

	return CDocList[index].PCDoc;
}

void TCDocumentWindowsList::Restore(CDocument *PCParentDoc)
{
	int p, count;

	count = CDocList.GetSize();

	for(p = 0; p < count; p++) 
	{
		if(!CDocList[p].is_open) continue;

		CDocList[p].Open(PCParentDoc);
	}
}

bool TCDocumentWindowsList::Rename(CString CSource, CString CDestination)
{
	int p, count;

	count = CDocList.GetSize();

	for(p = 0; p < count; p++) 
	{
		if(CDocList[p].CFileName == CSource)
		{
			CDocList[p].CFileName = CDestination;

			return true;
		}
	}

	return false;
}