
#ifndef _TCDocumentWindowsList_H
#define _TCDocumentWindowsList_H

#include <afxtempl.h>


enum TE_DOCUMENT_TYPES
{
	E_GENERIC_TEXT,
	E_SCHEMATIC_DOCUMENT,
	E_NETLIST_DOCUMENT,
	E_OUTPUT_TEXT_DOCUMENT,
	E_WAVEFORM_DOCUMENT,
	E_SYMBOL_DOCUMENT,
	E_SPICE_LIBARY_DOCUMENT,
	E_SPICE_MODEL_DOCUMENT,
	E_WORKSPACE_DOCUMENT,
	E_ERROR_REPORT_DOCUMENT,
	E_SPICE_ENGINE_LOG_DOCUMENT

};

CMultiDocTemplate *GetDocTemplate(TE_DOCUMENT_TYPES type);


class TCDocumentWindowsListData : public CObject
{
	public:	TCDocumentWindowsListData(void);
			TCDocumentWindowsListData(TCDocumentWindowsListData &CDocumentWindowsListData);
			~TCDocumentWindowsListData(void);

			CMultiDocTemplate	*PCMultiDocTemplate;
			CString				CFileName;
			CArray <CString, CString&>	CParentRefIDList;
			CString						CParentRefDes;
			CDocument			*PCDoc;
			CDocument			*PCParentDoc;
			TE_DOCUMENT_TYPES	type;
			int					is_open;
			int					is_saved;
			int					is_docked;
			WINDOWPLACEMENT		s_window_placment;

			CDocument	*Open(CDocument *PCParentDocument);
			bool		Close(void);
			void		SaveWindowPosition(void);
			void		LoadWindowPosition(void);
			int			Save(void);

			void operator = (TCDocumentWindowsListData &CDocumentWindowsListData);
	
			void Serialize(CArchive& CArchiveFile);

			DECLARE_SERIAL(TCDocumentWindowsListData)

};

class TCDocumentWindowsList : public CObject
{
	public:	TCDocumentWindowsList(void);
			TCDocumentWindowsList(TCDocumentWindowsList &CDocumentWindowsList);
			~TCDocumentWindowsList(void);

			int		index;
			CString CFileIndexedName;
			CString CFileName;
			CString CThisFileName;

			CArray <TCDocumentWindowsListData, TCDocumentWindowsListData> CDocList;

			void operator = (TCDocumentWindowsList &CDocumentWindowsList);
	
			void Serialize(CArchive& CArchiveFile);

			CDocument *GetDoc(CString CFileName);
			int			GetDocId(CString CFileName, CString CRefDes);
			int			GetDocId(CDocument *PCDoc, CString CRefDes);
			CDocument *GetParent(CDocument *PCDocChild);

			bool Create(CString CFileName, TE_DOCUMENT_TYPES type, CDocument *PCParent, CArray <CString, CString&> &CRefDesList, CString CRefDes, CDocument *PCSourceDoc = NULL);
			bool CreateSchematic(CString CFileName, CDocument *PCParent, CArray <CString, CString&> &CRefDesList, CString CRefDes);

			bool Remove(CString CFileName, bool close_open_docs);
			void RemoveAllOfType(TE_DOCUMENT_TYPES type, bool close_open_docs);
			void RemoveAllSchematicDocuments(bool close_open_docs);
			CDocument *Open(CDocument *PCParentDoc, CString CFileName);
			bool Close(CString CFileName);
			void Close(void);
			void Open(CDocument	*PCParentDoc);
			bool NotifyDocumentClosed(CDocument	*PCDoc);
			void Restore(CDocument *PCParentDoc);
			void UpdateWindowPosition(void);
			bool SaveOpenSchematics(void);
			bool Rename(CString CSource, CString CDestination);

			CDocument *IsOpen(CString CFileName);

			bool Get(CString CFileName, TCDocumentWindowsListData &CDocumentWindowsListData);

			DECLARE_SERIAL(TCDocumentWindowsList)

};

#endif