// TCDocumentWindowsListDlg.cpp : implementation file
//

#include "stdafx.h"
#include "SuperSpice.h"
#include "TCDocumentWindowsList.h"
#include "TCDocumentWindowsListDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// TCDocumentWindowsListDlg dialog


TCDocumentWindowsListDlg::TCDocumentWindowsListDlg(CWnd* pParent /*=NULL*/)
	: CDialog(TCDocumentWindowsListDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(TCDocumentWindowsListDlg)
	CFileName = _T("");
	//}}AFX_DATA_INIT

	view_file = false;
}


void TCDocumentWindowsListDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(TCDocumentWindowsListDlg)
	DDX_Control(pDX, IDC_COMBO_FILE_LIST, CMComboFileList);
	DDX_CBString(pDX, IDC_COMBO_FILE_LIST, CFileName);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(TCDocumentWindowsListDlg, CDialog)
	//{{AFX_MSG_MAP(TCDocumentWindowsListDlg)
	ON_BN_CLICKED(IDC_BUTTON_VIEW_FILE, OnButtonViewFile)
	ON_CBN_SELCHANGE(IDC_COMBO_FILE_LIST, OnSelchangeComboFileList)
	ON_CBN_DBLCLK(IDC_COMBO_FILE_LIST, OnDblclkComboFileList)
	ON_BN_CLICKED(IDC_BUTTON_DELETE_GRAPH, OnButtonDeleteGraph)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// TCDocumentWindowsListDlg message handlers

BOOL TCDocumentWindowsListDlg::OnInitDialog() 
{
	CFileName = CDocumentWindowsList.CFileIndexedName;

	CDialog::OnInitDialog();
	
	SetDisplay();
	
	return TRUE;  
}

void TCDocumentWindowsListDlg::SetDisplay(void)
{
	int count, p;

	CMComboFileList.ResetContent();

	count = CDocumentWindowsList.CDocList.GetSize();

	if(!count) CFileName = "";

	for(p = 0; p < count; p++) 
	{
		CMComboFileList.InsertString(-1, CDocumentWindowsList.CDocList[p].CFileName);
	}

	if(CDocumentWindowsList.index < count)
		if(count) CMComboFileList.SetCurSel(CDocumentWindowsList.index);

	UpdateData(false);
}

void TCDocumentWindowsListDlg::GetDisplay(void)
{
	UpdateData(true);

	int index = CMComboFileList.GetCurSel();

	if(index < 0) index = 0;

	CDocumentWindowsList.index				= index;
	CDocumentWindowsList.CFileIndexedName	= CFileName;
}

void TCDocumentWindowsListDlg::OnButtonViewFile() 
{
	view_file = true;

	OnOK();
}

void TCDocumentWindowsListDlg::OnSelchangeComboFileList() 
{
	GetDisplay();
}

void TCDocumentWindowsListDlg::OnDblclkComboFileList() 
{
	OnButtonViewFile();
}

void TCDocumentWindowsListDlg::OnOK() 
{
	GetDisplay();

	CDialog::OnOK();
}

void TCDocumentWindowsListDlg::OnCancel() 
{
	GetDisplay();

	CDialog::OnCancel();
}

void TCDocumentWindowsListDlg::OnButtonDeleteGraph() 
{
	int index = CMComboFileList.GetCurSel();

	if(index < 0) return;

	if(!(index < CDocumentWindowsList.CDocList.GetSize())) return;
	
	if(CDocumentWindowsList.CDocList[index].type != E_WAVEFORM_DOCUMENT)
	{
		AfxMessageBox(IDS_ERR_GRP_FILES_REMOVE);

		return;
	}

	CDocumentWindowsList.Remove(CDocumentWindowsList.CDocList[index].CFileName, true);

	SetDisplay();
}
