#include "stdafx.h"
#include "math.h"
#include "TDVersion.h"
#include "TCElectronicFormulars.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

TCElectronicFormulars GCElectronicFormulars;

bool LoadGenericFromArchive(CObject *CDataObject, CString CFileName);
bool SaveGenericToArchive(CObject *CDataObject, CString CFileName);

IMPLEMENT_SERIAL(TCCapacitorFormular, CObject, ID_VERSION_NUMBER)
IMPLEMENT_SERIAL(TCInductorFormular, CObject, ID_VERSION_NUMBER)
IMPLEMENT_SERIAL(TCSeriesLCRFormular, CObject, ID_VERSION_NUMBER)
IMPLEMENT_SERIAL(TCParallelLCRFormular, CObject, ID_VERSION_NUMBER)
IMPLEMENT_SERIAL(TCCapacitorSlewFormular, CObject, ID_VERSION_NUMBER)
IMPLEMENT_SERIAL(TCInductorSlewFormular, CObject, ID_VERSION_NUMBER)
IMPLEMENT_SERIAL(TCResistanceFormulars, CObject, ID_VERSION_NUMBER)
IMPLEMENT_SERIAL(TCBipolarFormulars, CObject, ID_VERSION_NUMBER)
IMPLEMENT_SERIAL(TCMosFormulars, CObject, ID_VERSION_NUMBER)
IMPLEMENT_SERIAL(TCJFetFormulars, CObject, ID_VERSION_NUMBER)
IMPLEMENT_SERIAL(TCTransmissionLineFormulars, CObject, ID_VERSION_NUMBER)
IMPLEMENT_SERIAL(TCTransformersFormulars, CObject, ID_VERSION_NUMBER)
IMPLEMENT_SERIAL(TCSwitchingSuppyFormulars, CObject, ID_VERSION_NUMBER)
IMPLEMENT_SERIAL(TCElectronicFormulars, CObject, ID_VERSION_NUMBER)

double boltzmanns_constant = 1.380658e-23;
double pi = 3.141592654;

TCSwitchingSuppyFormulars::TCSwitchingSuppyFormulars(void)
{

}
TCSwitchingSuppyFormulars::TCSwitchingSuppyFormulars(TCSwitchingSuppyFormulars &CSwitchingSuppyFormulars)
{
	*this = CSwitchingSuppyFormulars;
}
TCSwitchingSuppyFormulars::~TCSwitchingSuppyFormulars(void)
{

}

void TCSwitchingSuppyFormulars::Serialize(CArchive& CArchiveFile)
{
	CObject::Serialize(CArchiveFile);

	if(CArchiveFile.IsStoring())
	{

	}
	else
	{

	}
}
void TCSwitchingSuppyFormulars::operator = (TCSwitchingSuppyFormulars &CSwitchingSuppyFormulars)
{
	CSwitchingSuppyFormulars;
}


////////////////////////////////////////////////////////
TCTransformersFormulars::TCTransformersFormulars(void)
{

}
TCTransformersFormulars::TCTransformersFormulars(TCTransformersFormulars &CTransformersFormulars)
{
	*this = CTransformersFormulars;
}
TCTransformersFormulars::~TCTransformersFormulars(void)
{

}

void TCTransformersFormulars::Serialize(CArchive& CArchiveFile)
{
	CObject::Serialize(CArchiveFile);

	if(CArchiveFile.IsStoring())
	{

	}
	else
	{

	}
}
void TCTransformersFormulars::operator = (TCTransformersFormulars &CTransformersFormulars)
{
	CTransformersFormulars;
}

///////////////////////////////////////
TCTransmissionLineFormulars::TCTransmissionLineFormulars(void)
{

}
TCTransmissionLineFormulars::TCTransmissionLineFormulars(TCTransmissionLineFormulars &CTransmissionLineFormulars)
{
	*this = CTransmissionLineFormulars;
}
TCTransmissionLineFormulars::~TCTransmissionLineFormulars(void)
{

}

void TCTransmissionLineFormulars::Serialize(CArchive& CArchiveFile)
{
	CObject::Serialize(CArchiveFile);

	if(CArchiveFile.IsStoring())
	{

	}
	else
	{

	}
}
void TCTransmissionLineFormulars::operator = (TCTransmissionLineFormulars &CTransmissionLineFormulars)
{
	CTransmissionLineFormulars;
}


///////////////////////////////////////////

TCJFetFormulars::TCJFetFormulars(void)
{

}
TCJFetFormulars::TCJFetFormulars(TCJFetFormulars &TCJFetFormulars)
{
	*this = TCJFetFormulars;
}
TCJFetFormulars::~TCJFetFormulars(void)
{

}

void TCJFetFormulars::Serialize(CArchive& CArchiveFile)
{
	CObject::Serialize(CArchiveFile);

	if(CArchiveFile.IsStoring())
	{

	}
	else
	{

	}
}
void TCJFetFormulars::operator = (TCJFetFormulars &TCJFetFormulars)
{
	TCJFetFormulars;
}


////////////////////////////////////////////////////////
TCMosFormulars::TCMosFormulars(void)
{

}
TCMosFormulars::TCMosFormulars(TCMosFormulars &TCMosFormulars)
{
	*this = TCMosFormulars;
}
TCMosFormulars::~TCMosFormulars(void)
{

}

void TCMosFormulars::Serialize(CArchive& CArchiveFile)
{
	CObject::Serialize(CArchiveFile);

	if(CArchiveFile.IsStoring())
	{

	}
	else
	{

	}
}
void TCMosFormulars::operator = (TCMosFormulars &TCMosFormulars)
{
	TCMosFormulars;
}

////////////////////////////////////////////
TCBipolarFormulars::TCBipolarFormulars(void)
{

}
TCBipolarFormulars::TCBipolarFormulars(TCBipolarFormulars &TCBipolarFormulars)
{
	*this = TCBipolarFormulars;
}
TCBipolarFormulars::~TCBipolarFormulars(void)
{

}

void TCBipolarFormulars::Serialize(CArchive& CArchiveFile)
{
	CObject::Serialize(CArchiveFile);

	if(CArchiveFile.IsStoring())
	{

	}
	else
	{

	}
}
void TCBipolarFormulars::operator = (TCBipolarFormulars &TCBipolarFormulars)
{
	TCBipolarFormulars;
}


/////////////////////////////////////////////////////
TCResistanceFormulars::TCResistanceFormulars(void)
{
	resistance	= 100;
	temperature	= 25.0;
	bandwidth	= 1.0;
	unknown		= 2;

	noise =   CalculateNoise();
}

TCResistanceFormulars::TCResistanceFormulars(TCResistanceFormulars &CTCResistanceFormulars)
{
	*this = CTCResistanceFormulars;
}
TCResistanceFormulars::~TCResistanceFormulars(void)
{

}

void TCResistanceFormulars::Serialize(CArchive& CArchiveFile)
{
	CObject::Serialize(CArchiveFile);

	if(CArchiveFile.IsStoring())
	{
		CArchiveFile << resistance;
		CArchiveFile << noise;
		CArchiveFile << temperature;
		CArchiveFile << bandwidth;
		CArchiveFile << unknown;
	}
	else
	{
		CArchiveFile >> resistance;
		CArchiveFile >> noise;
		CArchiveFile >> temperature;
		CArchiveFile >> bandwidth;
		CArchiveFile >> unknown;
	}
}
void TCResistanceFormulars::operator = (TCResistanceFormulars &CTCResistanceFormulars)
{
	resistance	= CTCResistanceFormulars.resistance;
	noise		= CTCResistanceFormulars.noise;
	temperature	= CTCResistanceFormulars.temperature;
	bandwidth	= CTCResistanceFormulars.bandwidth;
	unknown		= CTCResistanceFormulars.unknown;
}

double TCResistanceFormulars::CalculateNoise(void)
{
	if(resistance < 0) resistance	= -resistance;
	if(temperature < 0) resistance	= -temperature;
	if(bandwidth < 0) bandwidth		= -bandwidth;

	return sqrt(4*boltzmanns_constant * temperature * bandwidth * resistance);
}

//////////////////////////////////////////////////////
////////

TCCapacitorFormular::TCCapacitorFormular(void)
{
	capacitance = 1e-9;
	frequency	=1e3;
	unknown		= 2;
	impedance	= CalculateImpedance();

}
TCCapacitorFormular::TCCapacitorFormular(TCCapacitorFormular &CCapacitorFormular)
{
	*this = CCapacitorFormular;
}
TCCapacitorFormular::~TCCapacitorFormular(void)
{

}

void TCCapacitorFormular::Serialize(CArchive& CArchiveFile)
{
	CObject::Serialize(CArchiveFile);

	if(CArchiveFile.IsStoring())
	{
		CArchiveFile << capacitance;
		CArchiveFile << frequency;
		CArchiveFile << impedance;
		CArchiveFile << unknown;

	}
	else
	{
		CArchiveFile >> capacitance;
		CArchiveFile >> frequency;
		CArchiveFile >> impedance;
		CArchiveFile >> unknown;
	}
}
void TCCapacitorFormular::operator = (TCCapacitorFormular &CCapacitorFormular)
{
	capacitance = CCapacitorFormular.capacitance;
	frequency	= CCapacitorFormular.frequency;
	impedance	= CCapacitorFormular.impedance;
	unknown		= CCapacitorFormular.unknown;
}

double TCCapacitorFormular::Calculate(void)
{
	if(capacitance < 0) capacitance = -capacitance;
	if(!capacitance)	capacitance = 1.0;
	if(frequency < 0)	frequency	= -frequency;
	if(!frequency)		frequency	= 1.0;
	if(impedance < 0)	impedance	= -impedance;
	if(!impedance)		impedance	= 1.0;

	switch(unknown)
	{
		case E_CALC_CAP_CAPACITANCE:return CalculateCapacitance();
		case E_CALC_CAP_FREQUENCY:	return CalculateFrequency();
		case E_CALC_CAP_IMPEDANCE:	return CalculateImpedance();
	}

	return 1.0;
}

double TCCapacitorFormular::CalculateImpedance(void)
{
	impedance = 1.0/2.0/pi/frequency/capacitance;

	return impedance;
}

double TCCapacitorFormular::CalculateCapacitance(void)
{
	capacitance = 1.0/2.0/pi/frequency/impedance;

	return capacitance;
}

double TCCapacitorFormular::CalculateFrequency(void)
{
	frequency  = 1.0/2.0/pi/capacitance/impedance;

	return frequency;
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////

TCInductorFormular::TCInductorFormular(void)
{
	inductance = 1.0e-6;
	unknown		= 2;
	frequency	=1e3;

	impedance	= CalculateImpedance();
}

TCInductorFormular::TCInductorFormular(TCInductorFormular &CInductorFormular)
{
	*this = CInductorFormular;
}
TCInductorFormular::~TCInductorFormular(void)
{

}

void TCInductorFormular::Serialize(CArchive& CArchiveFile)
{
	CObject::Serialize(CArchiveFile);

	if(CArchiveFile.IsStoring())
	{
		CArchiveFile << inductance;
		CArchiveFile << frequency;
		CArchiveFile << impedance;
		CArchiveFile << unknown;
	} 
	else
	{
		CArchiveFile >> inductance;
		CArchiveFile >> frequency;
		CArchiveFile >> impedance;
		CArchiveFile >> unknown;
	}
}
void TCInductorFormular::operator = (TCInductorFormular &CInductorFormular)
{
	inductance	= CInductorFormular.inductance;
	frequency	= CInductorFormular.frequency;
	impedance	= CInductorFormular.impedance;
	unknown		= CInductorFormular.unknown;
}

double TCInductorFormular::Calculate(void)
{
	if(inductance < 0)	inductance = -inductance;
	if(!inductance)		inductance = 1.0;
	if(frequency < 0)	frequency	= -frequency;
	if(!frequency)		frequency	= 1.0;
	if(impedance < 0)	impedance	= -impedance;
	if(!impedance)		impedance	= 1.0;

	switch(unknown)
	{
		case E_CALC_IND_INDUCTANCE:	return CalculateInductance();
		case E_CALC_IND_FREQUENCY:	return CalculateFrequency();
		case E_CALC_IND_IMPEDANCE:	return CalculateImpedance();
	}

	return 1.0;
}

double TCInductorFormular::CalculateImpedance(void)
{
	impedance = 2.0*pi*frequency*inductance;

	return impedance;
}

double TCInductorFormular::CalculateInductance(void)
{
	inductance = impedance/2.0/pi/frequency;

	return inductance;
}

double TCInductorFormular::CalculateFrequency(void)
{
	frequency = impedance/2.0/pi/inductance;

	return frequency;
}

//////////////////////////////////////////////////////

TCInductorSlewFormular::TCInductorSlewFormular(void)
{
	current		= 1.0;
	frequency	= 1.0;
	inductance	= 1.0;
	time		= 1.0;
	voltage		= 1.0;
	unknown		= 3;
}
TCInductorSlewFormular::TCInductorSlewFormular(TCInductorSlewFormular &CInductorSlewFormular)
{
	*this = CInductorSlewFormular;
}
TCInductorSlewFormular::~TCInductorSlewFormular(void)
{

}

void TCInductorSlewFormular::Serialize(CArchive& CArchiveFile)
{
	CObject::Serialize(CArchiveFile);

	if(CArchiveFile.IsStoring())
	{
		CArchiveFile << current;
		CArchiveFile << frequency;
		CArchiveFile << inductance;
		CArchiveFile << time;
		CArchiveFile << voltage;
		CArchiveFile << unknown;
	}
	else
	{
		CArchiveFile >> current;
		CArchiveFile >> frequency;
		CArchiveFile >> inductance;
		CArchiveFile >> time;
		CArchiveFile >> voltage;
		CArchiveFile >> unknown;
	}
}
void TCInductorSlewFormular::operator = (TCInductorSlewFormular &CInductorSlewFormular)
{
	current		= CInductorSlewFormular.current;
	frequency	= CInductorSlewFormular.frequency;
	inductance	= CInductorSlewFormular.inductance;
	time		= CInductorSlewFormular.time;
	voltage		= CInductorSlewFormular.voltage;
	unknown		= CInductorSlewFormular.unknown;
}

double TCInductorSlewFormular::Calculate(void)
{
	if(inductance <= 0) inductance = 1.0;
	if(current <= 0)	current = 1.0;
	if(frequency <= 0)	frequency = 1.0;
	if(time <= 0)		time = 1.0;
	if(voltage <= 0)	voltage = 1.0;

	switch(unknown)
	{
		case E_CALC_SLEW_INDUCTOR_INDUCTANCE:return CalculateInductance();
		case E_CALC_SLEW_INDUCTOR_FREQUENCY:return CalculateFrequency();
		case E_CALC_SLEW_INDUCTOR_TIME:		return CalculateTime();
		case E_CALC_SLEW_INDUCTOR_VOLTS:	return CalculateVoltage();
		case E_CALC_SLEW_INDUCTOR_CURRENT:	return CalculateCurrent();
	}

	return 1.0;
}

double TCInductorSlewFormular::CalculateInductance(void)
{
	inductance = voltage*time/current;

	return inductance;
}
double TCInductorSlewFormular::CalculateCurrent(void)
{
	current = voltage*time/inductance;

	return current;
}
double TCInductorSlewFormular::CalculateFrequency(void)
{
	frequency = voltage/inductance/2.0/pi/current;

	return frequency;
}

double TCInductorSlewFormular::CalculateTime(void)
{
	time = current*inductance/voltage;

	TimeToFrequency();

	return time;
}
double TCInductorSlewFormular::CalculateVoltage(void)
{
	voltage = inductance*current/time;

	return voltage;
}

void TCInductorSlewFormular::TimeToFrequency(void)
{
	if(time <= 0) time = 1.0;

	frequency = 1.0/2.0/pi/time;
}
void TCInductorSlewFormular::FrequencyToTime(void)
{
	if(frequency <= 0) frequency = 1.0;

	time = 1.0/2.0/pi/frequency;
}
///////////////////////////////////
TCCapacitorSlewFormular::TCCapacitorSlewFormular(void)
{
	capacitance = 1.0;
	current		= 1.0;
	frequency	= 1.0;
	time		= 1.0;
	voltage		= 1.0;
	unknown		= 3;
}
TCCapacitorSlewFormular::TCCapacitorSlewFormular(TCCapacitorSlewFormular &CCapacitorSlewFormular)
{
	*this = CCapacitorSlewFormular;
}
TCCapacitorSlewFormular::~TCCapacitorSlewFormular(void)
{

}

void TCCapacitorSlewFormular::Serialize(CArchive& CArchiveFile)
{
	CObject::Serialize(CArchiveFile);

	if(CArchiveFile.IsStoring())
	{
		CArchiveFile << capacitance;
		CArchiveFile << current;
		CArchiveFile << frequency;
		CArchiveFile << time;
		CArchiveFile << voltage;
		CArchiveFile << unknown;
	}
	else
	{
		CArchiveFile >> capacitance;
		CArchiveFile >> current;
		CArchiveFile >> frequency;
		CArchiveFile >> time;
		CArchiveFile >> voltage;
		CArchiveFile >> unknown;
	}
}
void TCCapacitorSlewFormular::operator = (TCCapacitorSlewFormular &CCapacitorSlewFormular)
{
	capacitance = CCapacitorSlewFormular.capacitance;
	current		= CCapacitorSlewFormular.current;
	frequency	= CCapacitorSlewFormular.frequency;
	time		= CCapacitorSlewFormular.time;
	voltage		= CCapacitorSlewFormular.voltage;
	unknown		= CCapacitorSlewFormular.unknown;
}

double TCCapacitorSlewFormular::Calculate(void)
{
	if(capacitance <= 0) capacitance = 1.0;
	if(current <= 0)	current = 1.0;
	if(frequency <= 0)	frequency = 1.0;
	if(time <= 0)		time = 1.0;
	if(voltage <= 0)	voltage = 1.0;

	switch(unknown)
	{
		case E_CALC_SLEW_CAPACITOR_CAPACITANCE:	return CalculateCapacitance();
		case E_CALC_SLEW_CAPACITOR_FREQUENCY:	return CalculateFrequency();
		case E_CALC_SLEW_CAPACITOR_TIME:		return CalculateTime();
		case E_CALC_SLEW_CAPACITOR_VOLTS:		return CalculateVoltage();
		case E_CALC_SLEW_CAPACITOR_CURRENT:		return CalculateCurrent();
	}

	return 1.0;
}

double TCCapacitorSlewFormular::CalculateCapacitance(void)
{
	capacitance = current/voltage/time;

	return capacitance;
}
double TCCapacitorSlewFormular::CalculateCurrent(void)
{
	current = capacitance*voltage/time;

	return current;
}
double TCCapacitorSlewFormular::CalculateFrequency(void)
{
	frequency = current/voltage/2.0/pi/capacitance;

	return frequency;
}

double TCCapacitorSlewFormular::CalculateTime(void)
{
	time = capacitance*voltage/current;

	TimeToFrequency();

	return time;
}
double TCCapacitorSlewFormular::CalculateVoltage(void)
{
	voltage = time*current/capacitance;

	return voltage;
}

void TCCapacitorSlewFormular::TimeToFrequency(void)
{
	if(time <= 0) time = 1.0;

	frequency = 1.0/2.0/pi/time;
}
void TCCapacitorSlewFormular::FrequencyToTime(void)
{
	if(frequency <= 0) frequency = 1.0;

	time = 1.0/2.0/pi/frequency;
}
////////////////////////////////////////////////////////
TCParallelLCRFormular::TCParallelLCRFormular(void)
{
	inductance	= 1e-6;
	capacitance	= 1e-9;
	resistance	= 100.0;
	frequency	= 1e3;
	unknown		= 4;

	q = 0.0;
	bandwidth = 0.0;
	fo= 0.0;
	impedance= 1.0;

	CalculateImpedance();
}

TCParallelLCRFormular::TCParallelLCRFormular(TCParallelLCRFormular &CParallelLCRFormular)
{
	*this = CParallelLCRFormular;
}
TCParallelLCRFormular::~TCParallelLCRFormular(void)
{

}

void TCParallelLCRFormular::Serialize(CArchive& CArchiveFile)
{
	CObject::Serialize(CArchiveFile);

	if(CArchiveFile.IsStoring())
	{
		CArchiveFile << inductance;
		CArchiveFile << capacitance;
		CArchiveFile << resistance;
		CArchiveFile << frequency;
		CArchiveFile << q;
		CArchiveFile << bandwidth;
		CArchiveFile << fo;
		CArchiveFile << impedance;
		CArchiveFile << unknown;
	}
	else
	{
		CArchiveFile >> inductance;
		CArchiveFile >> capacitance;
		CArchiveFile >> resistance;
		CArchiveFile >> frequency;
		CArchiveFile >> q;
		CArchiveFile >> bandwidth;
		CArchiveFile >> fo;
		CArchiveFile >> impedance;
		CArchiveFile >> unknown;
	}
}

void TCParallelLCRFormular::operator = (TCParallelLCRFormular &CParallelLCRFormular)
{
	inductance	= CParallelLCRFormular.inductance;
	capacitance	= CParallelLCRFormular.capacitance;
	resistance	= CParallelLCRFormular.resistance;
	frequency	= CParallelLCRFormular.frequency;
	q			= CParallelLCRFormular.q;
	bandwidth	= CParallelLCRFormular.bandwidth;
	fo			= CParallelLCRFormular.fo;
	impedance	= CParallelLCRFormular.impedance;
	unknown		= CParallelLCRFormular.unknown;
}

void TCParallelLCRFormular::operator = (TCSeriesLCRFormular &CSeriesLCRFormular)
{
	inductance	= CSeriesLCRFormular.inductance;
	capacitance	= CSeriesLCRFormular.capacitance;
	resistance	= CSeriesLCRFormular.resistance;
	frequency	= CSeriesLCRFormular.frequency;

	// to do 
	q			= CSeriesLCRFormular.q;
	bandwidth	= CSeriesLCRFormular.bandwidth;
	fo			= CSeriesLCRFormular.fo;
	impedance	= CSeriesLCRFormular.impedance;
	unknown		= CSeriesLCRFormular.unknown;
}

double TCParallelLCRFormular::Calculate(void)
{
	if(capacitance < 0) capacitance =1.0;
	if(!capacitance)	capacitance = 1.0;
	if(resistance < 0) resistance =1.0;
	if(!resistance)		resistance = 1.0;
	if(inductance < 0) inductance =1.0;
	if(!inductance)		inductance = 1.0;
	if(frequency < 0)	frequency =1.0;
	if(!frequency)		frequency = 1.0;
	if(q <= 0)			q = 0.0;
	if(bandwidth <= 0)	bandwidth = 0.0;
	if(fo <= 0)			fo = 0.0;
	if(impedance <= 0) impedance = 1.0;

	switch(unknown)
	{
		case E_CALC_PARALLE_INDUCTANCE: return CalculateInductance();
		case E_CALC_PARALLE_CAPACITANCE:return CalculateCapacitance();
		case E_CALC_PARALLE_RESISTANCE:	return CalculateResistance();
		case E_CALC_PARALLE_FREQUENCY:	return CalculateFrequency();
		case E_CALC_PARALLE_IMPEDANCE:	return CalculateImpedance();
		case E_CALC_PARALLE_FO:			return CalculateImpedance();
		case E_CALC_PARALLE_Q:			return CalculateImpedance();
		case E_CALC_PARALLE_BANDWIDTH:	return CalculateImpedance();
	}

	return 1.0;
}

 
double TCParallelLCRFormular::CalculateQBWFo(void)
{
	double w2 = 1.0/inductance/capacitance - resistance * resistance/inductance/inductance;
	
	if(w2 < 0) w2 = 0;

	if(w2)	fo = sqrt(w2)/2.0/pi;
	else	fo = 0.0;

	double q2 = fabs(inductance/capacitance/resistance/resistance);

	q = sqrt(q2);

	if(q)bandwidth = fo/q;
	else bandwidth = 0.0;

	return fo;
}

double TCParallelLCRFormular::CalculateImpedance(void)
{
	CalculateQBWFo();

	double xwi, zxi2, r, i;
	
	xwi = 2*pi*frequency*inductance - 1.0/2.0/pi/frequency/capacitance;

	zxi2 = resistance * resistance + xwi*xwi;

	if(!zxi2) zxi2 =1.0;

	r = (resistance/capacitance)*(inductance - xwi/frequency/2.0/pi);

	i = -(resistance*resistance/frequency/2.0/pi + inductance*xwi)/capacitance;

	impedance = sqrt(r*r + i*i);

	impedance /= zxi2;

	return impedance;
}

double TCParallelLCRFormular::CalculateInductance(void)
{
	double temp, w2;

	w2 = 4.0*pi*pi*fo*fo;

	if(w2)
	temp = (1.0/w2/capacitance)*(1.0/w2/capacitance) - 4*resistance*resistance/w2;

	else return 1.0;
	
	if(temp < 0) return 1.0;

	inductance = 1.0/w2/capacitance + sqrt(temp);

	inductance /= 2;

	CalculateImpedance();

	return inductance;
}

double TCParallelLCRFormular::CalculateCapacitance(void)
{
	double w2;

	w2 = 4.0*pi*pi*fo*fo;

	capacitance = 1.0/inductance/(w2 + resistance*resistance/inductance*inductance);

	CalculateImpedance();

	return capacitance;
}

double TCParallelLCRFormular::CalculateResistance(void)
{
	double temp, w2;

	w2 = 4.0*pi*pi*fo*fo;

	temp = 1.0/inductance/capacitance - w2;

	if(temp < 0) return 1.0;

	resistance = inductance*sqrt(temp);

	CalculateImpedance();

	return resistance;
}

double TCParallelLCRFormular::CalculateFrequency(void)
{
	double temp;

	temp;

	CalculateImpedance();

	return frequency;
}

///////////////////////////////////////////////////
TCSeriesLCRFormular::TCSeriesLCRFormular(void)
{
	inductance	= 1e-6;
	capacitance	= 1e-9;
	resistance	= 100.0;
	frequency	= 1e3;
	unknown		= 4;

	q = 1.0;
	bandwidth = 1.0;
	fo= 1.0;

	impedance= 1.0;

	CalculateImpedance();
}

TCSeriesLCRFormular::TCSeriesLCRFormular(TCSeriesLCRFormular &CSeriesLCRFormular)
{
	*this = CSeriesLCRFormular;
}
TCSeriesLCRFormular::~TCSeriesLCRFormular(void)
{

}

void TCSeriesLCRFormular::Serialize(CArchive& CArchiveFile)
{
	CObject::Serialize(CArchiveFile);

	if(CArchiveFile.IsStoring())
	{
		CArchiveFile << inductance;
		CArchiveFile << capacitance;
		CArchiveFile << resistance;
		CArchiveFile << frequency;
		CArchiveFile << q;
		CArchiveFile << bandwidth;
		CArchiveFile << fo;
		CArchiveFile << impedance;
		CArchiveFile << unknown;
	}
	else
	{
		CArchiveFile >> inductance;
		CArchiveFile >> capacitance;
		CArchiveFile >> resistance;
		CArchiveFile >> frequency;
		CArchiveFile >> q;
		CArchiveFile >> bandwidth;
		CArchiveFile >> fo;
		CArchiveFile >> impedance;
		CArchiveFile >> unknown;
	}
}

void TCSeriesLCRFormular::operator = (TCSeriesLCRFormular &CSeriesLCRFormular)
{
	inductance	= CSeriesLCRFormular.inductance;
	capacitance	= CSeriesLCRFormular.capacitance;
	resistance	= CSeriesLCRFormular.resistance;
	frequency	= CSeriesLCRFormular.frequency;
	q			= CSeriesLCRFormular.q;
	bandwidth	= CSeriesLCRFormular.bandwidth;
	fo			= CSeriesLCRFormular.fo;
	impedance	= CSeriesLCRFormular.impedance;
	unknown		= CSeriesLCRFormular.unknown;
}

void TCSeriesLCRFormular::operator = (TCParallelLCRFormular &CParallelLCRFormular)
{
	inductance	= CParallelLCRFormular.inductance;
	capacitance	= CParallelLCRFormular.capacitance;
	resistance	= CParallelLCRFormular.resistance;
	frequency	= CParallelLCRFormular.frequency;
	q			= CParallelLCRFormular.q;
	bandwidth	= CParallelLCRFormular.bandwidth;
	fo			= CParallelLCRFormular.fo;
	impedance	= CParallelLCRFormular.impedance;
	unknown		= CParallelLCRFormular.unknown;
}

double TCSeriesLCRFormular::Calculate(void)
{
	if(capacitance < 0) capacitance =1.0;
	if(!capacitance)	capacitance = 1.0;
	if(resistance < 0) resistance =1.0;
	if(!resistance)		resistance = 1.0;
	if(inductance < 0) inductance =1.0;
	if(!inductance)		inductance = 1.0;
	if(frequency < 0)	frequency =1.0;
	if(!frequency)		frequency = 1.0;
	if(q <= 0)			q = 0.0;
	if(bandwidth <= 0)	bandwidth = 0.0;
	if(fo <= 0)			fo = 0.0;
	if(impedance <= 0) impedance = 1.0;

	switch(unknown)
	{
		case E_CALC_SERIES_INDUCTANCE:	return CalculateInductance();
		case E_CALC_SERIES_CAPACITANCE:	return CalculateCapacitance();
		case E_CALC_SERIES_RESISTANCE:	return CalculateResistance();
		case E_CALC_SERIES_FREQUENCY:	return CalculateFrequency();
		case E_CALC_SERIES_IMPEDANCE:	return CalculateImpedance();
		case E_CALC_SERIES_FO:			return CalculateImpedance();
		case E_CALC_SERIES_Q:			return CalculateImpedance();
		case E_CALC_SERIES_BANDWIDTH:	return CalculateImpedance();
	}

	return 1.0;
}

double TCSeriesLCRFormular::CalculateQBWFo(void)
{
	fo = 1.0/2.0/pi/sqrt(inductance*capacitance);

	double q2 = fabs(inductance/capacitance/resistance/resistance);

	q = sqrt(q2);

	if(q) bandwidth = fo/q;
	else q = 0.0;

	return fo;
}

double TCSeriesLCRFormular::CalculateImpedance(void)
{
	CalculateQBWFo();

	impedance = sqrt(resistance * resistance + (2*pi*frequency*inductance - 1.0/2.0/pi/frequency/capacitance) *
					(2*pi*frequency*inductance - 1.0/2.0/pi/frequency/capacitance));


	return impedance;
}

double TCSeriesLCRFormular::CalculateInductance(void)
{
	double w2;

	w2 = 4.0*pi*pi*fo*fo;

	inductance = 1.0/w2/capacitance;

	CalculateImpedance();

	return inductance;
}

double TCSeriesLCRFormular::CalculateCapacitance(void)
{
	double w2;

	w2 = 4.0*pi*pi*fo*fo;

	capacitance  = 1.0/w2/inductance;

	CalculateImpedance();

	return capacitance;
}

double TCSeriesLCRFormular::CalculateResistance(void)
{
	double temp;

	temp = impedance * impedance - (2*pi*frequency*inductance - 1.0/2.0/pi/frequency/capacitance)*(2*pi*frequency*inductance - 1.0/2.0/pi/frequency/capacitance);

	if(temp < 0) return 1.0;

	resistance = sqrt(temp);

	CalculateImpedance();

	return resistance;
}

double TCSeriesLCRFormular::CalculateFrequency(void)
{
	double temp, temp2;

	temp = impedance * impedance - resistance * resistance;

	CalculateQBWFo();

	if(temp < 0) return 1.0;

	temp = sqrt(temp);

	if(temp < 0) 
	{
		frequency = 0;

		return 0.0;
	}

	temp2 = (temp/inductance)*(temp/inductance) + 4.0/inductance/capacitance;

	if(temp2 < 0) return 0.0;

	frequency = temp/inductance + sqrt(temp2);

	frequency /= 2;

	frequency = frequency/2.0/pi;

	return frequency;
}

///////////////////////////////////////////////

TCElectronicFormulars::TCElectronicFormulars(void)
{

}
TCElectronicFormulars::TCElectronicFormulars(TCElectronicFormulars &TCElectronicFormulars)
{
	*this = TCElectronicFormulars;
}
TCElectronicFormulars::~TCElectronicFormulars(void)
{

}

void TCElectronicFormulars::Serialize(CArchive& CArchiveFile)
{
	CObject::Serialize(CArchiveFile);
	CResistance.Serialize(CArchiveFile);
	CCapacitor.Serialize(CArchiveFile);
	CInductor.Serialize(CArchiveFile);
	CCapacitorSlew.Serialize(CArchiveFile);
	CInductorSlew.Serialize(CArchiveFile);
	CSeriesLCR.Serialize(CArchiveFile);
	CParallelLCR.Serialize(CArchiveFile);
	CBipolar.Serialize(CArchiveFile);
	CMos.Serialize(CArchiveFile);
	CJFet.Serialize(CArchiveFile);
	CTransmissionLine.Serialize(CArchiveFile);
	CTransformers.Serialize(CArchiveFile);
	CSwitchingSuppy.Serialize(CArchiveFile);

	if(CArchiveFile.IsStoring())
	{

	}
	else
	{

	}
}
void TCElectronicFormulars::operator = (TCElectronicFormulars &CElectronicFormulars)
{
	CResistance		= CElectronicFormulars.CResistance;
	CCapacitor		= CElectronicFormulars.CCapacitor;
	CInductor		= CElectronicFormulars.CInductor;
	CCapacitorSlew	= CElectronicFormulars.CCapacitorSlew;
	CInductorSlew	= CElectronicFormulars.CInductorSlew;
	CSeriesLCR		= CElectronicFormulars.CSeriesLCR;
	CParallelLCR	= CElectronicFormulars.CParallelLCR;
	CBipolar		= CElectronicFormulars.CBipolar;
	CMos			= CElectronicFormulars.CMos;
	CJFet			= CElectronicFormulars.CJFet;

	CTransmissionLine	= CElectronicFormulars.CTransmissionLine;
	CTransformers		= CElectronicFormulars.CTransformers;
	CSwitchingSuppy		= CElectronicFormulars.CSwitchingSuppy;
}

bool TCElectronicFormulars::Save(CString CFileNAme)
{
	return SaveGenericToArchive(this, CFileNAme);
}

bool TCElectronicFormulars::Load(CString CFileame)
{
	return LoadGenericFromArchive(this, CFileame);
}

/////////////////////////////////////////////