
#ifndef _TCELECTRONIC_FORMLARS_H
#define _TCELECTRONIC_FORMLARS_H

#include <afxtempl.h>

enum
{
	E_CALC_CAP_CAPACITANCE,
	E_CALC_CAP_FREQUENCY,
	E_CALC_CAP_IMPEDANCE
};

enum
{
	E_CALC_IND_INDUCTANCE,
	E_CALC_IND_FREQUENCY,
	E_CALC_IND_IMPEDANCE
};

enum
{
	E_CALC_SERIES_INDUCTANCE,
	E_CALC_SERIES_CAPACITANCE,
	E_CALC_SERIES_RESISTANCE,
	E_CALC_SERIES_FREQUENCY,
	E_CALC_SERIES_IMPEDANCE,
	E_CALC_SERIES_FO,
	E_CALC_SERIES_Q,
	E_CALC_SERIES_BANDWIDTH
};

enum
{
	E_CALC_PARALLE_INDUCTANCE,
	E_CALC_PARALLE_CAPACITANCE,
	E_CALC_PARALLE_RESISTANCE,
	E_CALC_PARALLE_FREQUENCY,
	E_CALC_PARALLE_IMPEDANCE,
	E_CALC_PARALLE_FO,
	E_CALC_PARALLE_Q,
	E_CALC_PARALLE_BANDWIDTH
};

enum
{
	E_CALC_SLEW_CAPACITOR_CAPACITANCE,
	E_CALC_SLEW_CAPACITOR_FREQUENCY,
	E_CALC_SLEW_CAPACITOR_TIME,
	E_CALC_SLEW_CAPACITOR_VOLTS,
	E_CALC_SLEW_CAPACITOR_CURRENT
};

enum
{
	E_CALC_SLEW_INDUCTOR_INDUCTANCE,
	E_CALC_SLEW_INDUCTOR_FREQUENCY,
	E_CALC_SLEW_INDUCTOR_TIME,
	E_CALC_SLEW_INDUCTOR_VOLTS,
	E_CALC_SLEW_INDUCTOR_CURRENT
};

enum
{

};

class TCResistanceFormulars : public CObject
{
	public:	TCResistanceFormulars(void);
			TCResistanceFormulars(TCResistanceFormulars &TCResistanceFormulars);
			~TCResistanceFormulars(void);

			double resistance;
			double noise;
			double temperature;
			double bandwidth;
			double unknown;

			double CalculateNoise(void);

			void operator = (TCResistanceFormulars &TCResistanceFormulars);
	
			void Serialize(CArchive& CArchiveFile);

			DECLARE_SERIAL(TCResistanceFormulars)

};

class TCCapacitorFormular : public CObject
{
	public:	TCCapacitorFormular(void);
			TCCapacitorFormular(TCCapacitorFormular &CCapacitorFormular);
			~TCCapacitorFormular(void);

			double	capacitance;
			double	frequency;
			double	impedance;
			int		unknown;

			double Calculate(void);
			double CalculateImpedance(void);
			double CalculateCapacitance(void);
			double CalculateFrequency(void);

			void operator = (TCCapacitorFormular &CCapacitorFormular);
	
			void Serialize(CArchive& CArchiveFile);

			DECLARE_SERIAL(TCCapacitorFormular)

};

class TCInductorFormular : public CObject
{
	public:	TCInductorFormular(void);
			TCInductorFormular(TCInductorFormular &CInductorFormular);
			~TCInductorFormular(void);

			double inductance;
			double	frequency;
			double	impedance;
			int unknown;

			double CalculateImpedance(void);
			double CalculateInductance(void);
			double CalculateFrequency(void);
			double Calculate(void);

			void operator = (TCInductorFormular &CInductorFormular);
	
			void Serialize(CArchive& CArchiveFile);

			DECLARE_SERIAL(TCInductorFormular)

};

class TCParallelLCRFormular;

class TCSeriesLCRFormular : public CObject
{
	public:	TCSeriesLCRFormular(void);
			TCSeriesLCRFormular(TCSeriesLCRFormular &CSeriesLCRFormular);
			~TCSeriesLCRFormular(void);

			double	inductance;
			double	capacitance;
			double	resistance;
			double	q;
			double	bandwidth;
			double	fo;
			double	frequency;
			double	impedance;
			int		unknown;

			double CalculateImpedance(void);
			double Calculate(void);
			double CalculateQBWFo(void);
			double CalculateInductance(void);
			double CalculateCapacitance(void);
			double CalculateResistance(void);
			double CalculateFrequency(void);

			void operator = (TCSeriesLCRFormular &CSeriesLCRFormular);
			void operator = (TCParallelLCRFormular &CParallelLCRFormular);
	
			void Serialize(CArchive& CArchiveFile);

			DECLARE_SERIAL(TCSeriesLCRFormular)

};

class TCParallelLCRFormular : public CObject
{
	public:	TCParallelLCRFormular(void);
			TCParallelLCRFormular(TCParallelLCRFormular &CParallelLCRFormular);
			~TCParallelLCRFormular(void);

			double	inductance;
			double	capacitance;
			double	resistance;
			double	q;
			double	bandwidth;
			double	fo;
			double	frequency;
			double	impedance;
			int		unknown;


			void operator = (TCParallelLCRFormular &CParallelLCRFormular);
			void operator = (TCSeriesLCRFormular &CSeriesLCRFormular);

			double CalculateImpedance(void);
			double Calculate(void);
			double CalculateQBWFo(void);
			double CalculateInductance(void);
			double CalculateCapacitance(void);
			double CalculateResistance(void);
			double CalculateFrequency(void);
	
			void Serialize(CArchive& CArchiveFile);

			DECLARE_SERIAL(TCParallelLCRFormular)

};

class TCCapacitorSlewFormular : public CObject
{
	public:	TCCapacitorSlewFormular(void);
			TCCapacitorSlewFormular(TCCapacitorSlewFormular &CCapacitorSlewFormular);
			~TCCapacitorSlewFormular(void);

			double	capacitance;
			double	current;
			double	frequency;
			double	time;
			double	voltage;
			int		unknown;

			double Calculate(void);
			double CalculateCapacitance(void);
			double CalculateCurrent(void);
			double CalculateFrequency(void);
			double CalculateTime(void);
			double CalculateVoltage(void);
			void   TimeToFrequency(void);
			void   FrequencyToTime(void);


			void operator = (TCCapacitorSlewFormular &CCapacitorSlewFormular);
	
			void Serialize(CArchive& CArchiveFile);

			DECLARE_SERIAL(TCCapacitorSlewFormular)

};

class TCInductorSlewFormular : public CObject
{
	public:	TCInductorSlewFormular(void);
			TCInductorSlewFormular(TCInductorSlewFormular &CInductorSlewFormular);
			~TCInductorSlewFormular(void);

			double	current;
			double	frequency;
			double	inductance;
			double	time;
			double	voltage;
			int		unknown;

			double Calculate(void);
			double CalculateInductance(void);
			double CalculateCurrent(void);
			double CalculateFrequency(void);
			double CalculateTime(void);
			double CalculateVoltage(void);
			void   TimeToFrequency(void);
			void   FrequencyToTime(void);

			void operator = (TCInductorSlewFormular &CInductorSlewFormular);
	
			void Serialize(CArchive& CArchiveFile);

			DECLARE_SERIAL(TCInductorSlewFormular)

};

class TCBipolarFormulars : public CObject
{
	public:	TCBipolarFormulars(void);
			TCBipolarFormulars(TCBipolarFormulars &TCBipolarFormulars);
			~TCBipolarFormulars(void);

			void operator = (TCBipolarFormulars &TCBipolarFormulars);
	
			void Serialize(CArchive& CArchiveFile);

			DECLARE_SERIAL(TCBipolarFormulars)

};

class TCMosFormulars : public CObject
{
	public:	TCMosFormulars(void);
			TCMosFormulars(TCMosFormulars &TCMosFormulars);
			~TCMosFormulars(void);

			void operator = (TCMosFormulars &TCMosFormulars);
	
			void Serialize(CArchive& CArchiveFile);

			DECLARE_SERIAL(TCMosFormulars)

};

class TCJFetFormulars : public CObject
{
	public:	TCJFetFormulars(void);
			TCJFetFormulars(TCJFetFormulars &TCJFetFormulars);
			~TCJFetFormulars(void);

			void operator = (TCJFetFormulars &TCJFetFormulars);
	
			void Serialize(CArchive& CArchiveFile);

			DECLARE_SERIAL(TCJFetFormulars)

};

class TCTransmissionLineFormulars : public CObject
{
	public:	TCTransmissionLineFormulars(void);
			TCTransmissionLineFormulars(TCTransmissionLineFormulars &CTransmissionLineFormulars);
			~TCTransmissionLineFormulars(void);

			void operator = (TCTransmissionLineFormulars &CTransmissionLineFormulars);
	
			void Serialize(CArchive& CArchiveFile);

			DECLARE_SERIAL(TCTransmissionLineFormulars)

};

class TCTransformersFormulars : public CObject
{
	public:	TCTransformersFormulars(void);
			TCTransformersFormulars(TCTransformersFormulars &CTransformersFormulars);
			~TCTransformersFormulars(void);

			void operator = (TCTransformersFormulars &CTransformersFormulars);
	
			void Serialize(CArchive& CArchiveFile);

			DECLARE_SERIAL(TCTransformersFormulars)

};

class TCSwitchingSuppyFormulars : public CObject
{
	public:	TCSwitchingSuppyFormulars(void);
			TCSwitchingSuppyFormulars(TCSwitchingSuppyFormulars &CSwitchingSuppyFormulars);
			~TCSwitchingSuppyFormulars(void);

			void operator = (TCSwitchingSuppyFormulars &CSwitchingSuppyFormulars);
	
			void Serialize(CArchive& CArchiveFile);

			DECLARE_SERIAL(TCSwitchingSuppyFormulars)

};

class TCElectronicFormulars : public CObject
{
	public:	TCElectronicFormulars(void);
			TCElectronicFormulars(TCElectronicFormulars &TCElectronicFormulars);
			~TCElectronicFormulars(void);

			TCResistanceFormulars	CResistance;
			TCCapacitorFormular		CCapacitor;
			TCInductorFormular		CInductor;
			TCCapacitorSlewFormular CCapacitorSlew;
			TCInductorSlewFormular	CInductorSlew;
			TCSeriesLCRFormular		CSeriesLCR;
			TCParallelLCRFormular	CParallelLCR;
			TCBipolarFormulars		CBipolar;
			TCMosFormulars			CMos;
			TCJFetFormulars			CJFet;
			TCTransmissionLineFormulars CTransmissionLine;
			TCTransformersFormulars	CTransformers;
			TCSwitchingSuppyFormulars CSwitchingSuppy;

			bool Save(CString CFileNAme);
			bool Load(CString CFileame);

			void operator = (TCElectronicFormulars &CElectronicFormulars);
	
			void Serialize(CArchive& CArchiveFile);

			DECLARE_SERIAL(TCElectronicFormulars)

};


#endif