#include "stdafx.h"
#include "resource.h"
#include "math.h"
#include "TDVersion.h"
#include "TCFantasticFilter.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

bool LoadGenericFromArchive(CObject *CDataObject, CString CFileName);
bool SaveGenericToArchive(CObject *CDataObject, CString CFileName);

IMPLEMENT_SERIAL(TCFantasticFilter, CObject, ID_VERSION_NUMBER)
IMPLEMENT_SERIAL(TCFantasticFilterData, CObject, ID_VERSION_NUMBER)
IMPLEMENT_SERIAL(TCComplexPoleZero, CObject, ID_VERSION_NUMBER)

TCFantasticFilter GCFantasticFilter;

double Ln(double value);
//////////////////////////////////
TCComplexPoleZero::TCComplexPoleZero(void)
{
	i = 0;
	r = 0;
	CType = "Pole";
}
TCComplexPoleZero::TCComplexPoleZero(TCComplexPoleZero &CComplexPoleZero)
{
	*this = CComplexPoleZero;
}
TCComplexPoleZero::~TCComplexPoleZero(void)
{

}

void TCComplexPoleZero::Serialize(CArchive& CArchiveFile)
{
	CObject::Serialize(CArchiveFile);

	if(CArchiveFile.IsStoring())
	{
		CArchiveFile << r;
		CArchiveFile << i;	
		CArchiveFile << CType;
	}
	else
	{
		CArchiveFile >> r;
		CArchiveFile >> i;
		CArchiveFile >> CType;
	}
}
void TCComplexPoleZero::operator = (TCComplexPoleZero &CComplexPoleZero)
{
	r = CComplexPoleZero.r;
	i = CComplexPoleZero.i;
	CType = CComplexPoleZero.CType;
}

TCComplexPoleZero TCComplexPoleZero::operator * (TCComplexPoleZero &CComplexPoleZero)
{
	TCComplexPoleZero CReturnValue;
	CComplexPoleZero;

	return CReturnValue;
}

TCComplexPoleZero TCComplexPoleZero::operator - (TCComplexPoleZero &CComplexPoleZero)
{
	TCComplexPoleZero CReturnValue;
	CComplexPoleZero;

	return CReturnValue;
}
TCComplexPoleZero TCComplexPoleZero::operator + (TCComplexPoleZero &CComplexPoleZero)
{
	TCComplexPoleZero CReturnValue;
	CComplexPoleZero;

	return CReturnValue;
}
TCComplexPoleZero TCComplexPoleZero::Sine(void)
{
	TCComplexPoleZero CReturnValue;

	return CReturnValue;
}
TCComplexPoleZero TCComplexPoleZero::Cos(void)
{
	TCComplexPoleZero CReturnValue;


	return CReturnValue;
}

/////////////////////////////////********

TCFantasticFilterData::TCFantasticFilterData(void)
{
	CRefDesignator;
	value = 1;
}
TCFantasticFilterData::TCFantasticFilterData(TCFantasticFilterData &CFantasticFilterData)
{
	*this = CFantasticFilterData;
}
TCFantasticFilterData::~TCFantasticFilterData(void)
{

}

void TCFantasticFilterData::Serialize(CArchive& CArchiveFile)
{
	CObject::Serialize(CArchiveFile);

	if(CArchiveFile.IsStoring())
	{
		CArchiveFile << CRefDesignator;
		CArchiveFile << value;
	}
	else
	{
		CArchiveFile >> CRefDesignator;
		CArchiveFile >> value;
	}
}
void TCFantasticFilterData::operator = (TCFantasticFilterData &CFantasticFilterData)
{
	CFantasticFilterData;

	CRefDesignator	= CFantasticFilterData.CRefDesignator;
	value			= CFantasticFilterData.value;
}

////////////////

TCFantasticFilter::TCFantasticFilter(void)
{
	frequency_type			= 0;
	implementation_type		= 0;
	name_type				= 0;
	bandwidth				= 1;
	frequency				= 0.159154943;
	order					= 1;
	capacitance				= 1;
	output_resistance		= 1;
	ripple					= 1;

	CFrequencyTypeList.SetSize(E_FANTASTIC_FILTER_FREQ_TYPE_MAX);
	CImplementationTypeList.SetSize(TE_FANTASTIC_FILTER_IMPLEMENTATION_TYPE_MAX);
	CFilterNameType.SetSize(TE_FANTASTIC_FILTER_IMPLEMENTATION_TYPE_MAX);
	CFilterRippleList.SetSize(TE_FANTASTIC_FILTER_RIPPLE_MAX);
	CRippleTable.SetSize(TE_FANTASTIC_FILTER_RIPPLE_MAX);

	CFrequencyTypeList[E_LOWPASS]	= "LP";
	CFrequencyTypeList[E_BANDPASS]	= "BP";
	CFrequencyTypeList[E_BANDREJECT]= "BR";
	CFrequencyTypeList[E_HIGHPASS]	= "HP";

	CImplementationTypeList[E_TWO_POLE_OPAMP]	= "OpAmp_";
	CImplementationTypeList[E_EQUAL_CR_OPAMP]	= "OpAmpERC_";
	CImplementationTypeList[E_RCL_LADDERA]		= "LCRa_";
	CImplementationTypeList[E_RCL_LADDERB]		= "LCRb_";
	CImplementationTypeList[E_STATE_VARIABLE]	= "StateVariable_";
	CImplementationTypeList[E_LEAP_FROG]		= "LeapFrog_";
	CImplementationTypeList[E_GYRATOR]			= "Gyrator_";
	CImplementationTypeList[E_NEGATIVE_RESISTOR]= "NegResistor_";

	CFilterNameType[E_BUTTERWORTH]			= "Butterworth";
	CFilterNameType[E_CHEBYSHEV]			= "Chebyshev";
	CFilterNameType[E_BESSEL]				= "Bessel";
	CFilterNameType[E_ELIPTIC]				= "Eliptic";
	CFilterNameType[E_GAUSSIAN]				= "Gausian";
	CFilterNameType[E_INVERSE_CHEBYSHEV]	= "InverseChebyshev";
	
	CFilterRippleList[E_POINT_01DB_RIPPLE]	= "0.01";
	CFilterRippleList[E_POINT_1DB_RIPPLE]	= "0.1";
	CFilterRippleList[E_POINT_5DB_RIPPLE]	= "0.5";
	CFilterRippleList[E_1DB_RIPPLE]			= "1.0";
	CFilterRippleList[E_3DB_RIPPLE]			= "3.0";

	CFilterRipple = CFilterRippleList[E_1DB_RIPPLE];
	ripple_index = E_1DB_RIPPLE;

	CRippleTable[E_POINT_01DB_RIPPLE]	= 0.01;
	CRippleTable[E_POINT_1DB_RIPPLE]	= 0.1;
	CRippleTable[E_POINT_5DB_RIPPLE]	= 0.5;
	CRippleTable[E_1DB_RIPPLE]			= 1.0;
	CRippleTable[E_3DB_RIPPLE]			= 3.0;
}

TCFantasticFilter::TCFantasticFilter(TCFantasticFilter &CFantasticFilter)
{
	*this = CFantasticFilter;
}
TCFantasticFilter::~TCFantasticFilter(void)
{

}

void TCFantasticFilter::Serialize(CArchive& CArchiveFile)
{
	CObject::Serialize(CArchiveFile);

	int count, p;

	if(CArchiveFile.IsStoring())
	{
		CArchiveFile << frequency_type;
		CArchiveFile << implementation_type;
		CArchiveFile << name_type;
		CArchiveFile << bandwidth;
		CArchiveFile << frequency;
		CArchiveFile << capacitance;
		CArchiveFile << output_resistance;
		CArchiveFile << ripple;
		CArchiveFile << order;
		CArchiveFile << ripple_index;
		CArchiveFile << CFilterFileName;
		CArchiveFile << CFilterRipple;

		count = ComponentList.GetSize();

		CArchiveFile << count;

		for(p = 0; p < count; p++) ComponentList[p].Serialize(CArchiveFile);

		count = CPoleZeroList.GetSize();

		CArchiveFile << count;

		for(p = 0; p < count; p++) CPoleZeroList[p].Serialize(CArchiveFile);

		count = CLCRList.GetSize();

		CArchiveFile << count;

		for(p = 0; p < count; p++) CArchiveFile << CLCRList[p];

		count = CFilterRippleList.GetSize();

		CArchiveFile << count;

		for(p = 0; p < count; p++) CArchiveFile << CFilterRippleList[p];
		
	}
	else
	{
		CArchiveFile >> frequency_type;
		CArchiveFile >> implementation_type;
		CArchiveFile >> name_type;
		CArchiveFile >> bandwidth;
		CArchiveFile >> frequency;
		CArchiveFile >> capacitance;
		CArchiveFile >> output_resistance;
		CArchiveFile >> ripple;
		CArchiveFile >> order;
		CArchiveFile >> ripple_index;
		CArchiveFile >> CFilterFileName;
		CArchiveFile >> CFilterRipple;

		CArchiveFile >> count;

		ComponentList.SetSize(count);

		for(p = 0; p < count; p++) ComponentList[p].Serialize(CArchiveFile);

		CArchiveFile >> count;

		CPoleZeroList.SetSize(count);

		for(p = 0; p < count; p++) CPoleZeroList[p].Serialize(CArchiveFile);

		CArchiveFile >> count;

		CLCRList.SetSize(count);

		for(p = 0; p < count; p++) CArchiveFile >> CLCRList[p];

		CArchiveFile >> count;

		CFilterRippleList.SetSize(count);

		for(p = 0; p < count; p++) CArchiveFile >> CFilterRippleList[p];
	}
}

void TCFantasticFilter::operator = (TCFantasticFilter &CFantasticFilter)
{
	frequency_type			= CFantasticFilter.frequency_type;
	implementation_type		= CFantasticFilter.implementation_type;
	name_type				= CFantasticFilter.name_type;
	bandwidth				= CFantasticFilter.bandwidth;
	frequency				= CFantasticFilter.frequency;
	order					= CFantasticFilter.order;
	ripple_index			= CFantasticFilter.ripple_index;
	capacitance				= CFantasticFilter.capacitance;
	output_resistance		= CFantasticFilter.output_resistance;
	ripple					= CFantasticFilter.ripple;
	CFilterFileName			= CFantasticFilter.CFilterFileName;
	CTransferFunctionFileName = CFantasticFilter.CTransferFunctionFileName;
	CFilterRipple			= CFantasticFilter.CFilterRipple;

	int count, p;

	count = CFantasticFilter.ComponentList.GetSize();

	ComponentList.SetSize(count);

	for(p = 0; p < count; p++) ComponentList[p] = CFantasticFilter.ComponentList[p];

	count = CFantasticFilter.CPoleZeroList.GetSize();

	CPoleZeroList.SetSize(count);

	for(p = 0; p < count; p++) CPoleZeroList[p] = CFantasticFilter.CPoleZeroList[p];

	count = CFantasticFilter.CLCRList.GetSize();

	CLCRList.SetSize(count);

	for(p = 0; p < count; p++) CLCRList[p] = CFantasticFilter.CLCRList[p];

	count = CFantasticFilter.CFilterRippleList.GetSize();

	CFilterRippleList.SetSize(count);

	for(p = 0; p < count; p++) CFilterRippleList[p] = CFantasticFilter.CFilterRippleList[p];

}

CString TCFantasticFilter::FormatFileName(void)
{
	CString COrder;

	COrder.Format("%d", order);

	CFilterFileName = CImplementationTypeList[implementation_type] + CFrequencyTypeList[frequency_type];

	CFilterFileName += COrder;

	CFilterFileName += ".scl";

	return CFilterFileName;//as a check
}

bool TCFantasticFilter::Load(CString CFileName)
{
	return LoadGenericFromArchive(this, CFileName);
}

bool TCFantasticFilter::Save(CString CFileName)
{
	return SaveGenericToArchive(this, CFileName);
}

bool TCFantasticFilter::CalculateButterworthPoleZeros(void)
{
	CArray <TCComplexPoleZero, TCComplexPoleZero> CPoleZeroListTemp;

	CPoleZeroListTemp.SetSize(order);
	CPoleZeroList.SetSize(order);

	int k= 1;

	int p;

	for(int p = 0; p < order; p++)
	{
		CPoleZeroListTemp[p].r = cos((2 * k + order - 1)*1.570796327/order);

		CPoleZeroListTemp[p].i = sin((2 * k + order - 1)*1.570796327/order);

		k++;
	}

	k = 0;

	for(p = 0; p < order/2; p++)// reorder poles
	{
		CPoleZeroList[k] = CPoleZeroListTemp[p];

		CPoleZeroList[k + 1] = CPoleZeroListTemp[order - p - 1];

		k +=2;
	}

	//if odd
	if((order%2)) 
	{
		CPoleZeroList[order - 1] = CPoleZeroListTemp[p];
	}

	return true;
}


bool TCFantasticFilter::CalculateChebyshevPoleZeros(void)
{
/*
	function [z,p,k] = cheb1ap(n, rp)
%CHEB1AP	Chebyshev type I analog lowpass filter prototype.
%	[Z,P,K] = CHEB1AP(N,Rp) returns the zeros, poles, and gain
%	of an N-th order normalized prototype type I Chebyshev analog


j = sqrt(-1);
epsilon = sqrt(10^(.1*rp)-1);
mu = asinh(1/epsilon)/n;
p = exp(j*((1:2:2*n-1)*pi/(2*n) + pi/2)).';
p = sinh(mu)*real(p) + j*cosh(mu)*imag(p);
z = [];
k = real(prod(-p));
if ~rem(n,2)	% n is even so patch k
	k = k/sqrt((1 + epsilon^2));
end

*/
	if(order <=0) order =1;

	double epsilon, mu, r, i, alpha, sinh_mu, cosh_mu, actual_ripple;

	actual_ripple = ripple;

	if(ripple <= 0) ripple =1;

	if(implementation_type == E_RCL_LADDERA || implementation_type == E_RCL_LADDERB)
	{
		if(ripple_index < 0) ripple_index = 0;

		actual_ripple = CRippleTable[ripple_index];
	}

	epsilon = sqrt(pow(10, 0.1 * actual_ripple) - 1);

	if(epsilon <= 0) epsilon=1;
	
	alpha= 1/epsilon;

	mu = Ln(alpha + sqrt(alpha*alpha + 1)) / order; //asinh(alpha);

	CArray <TCComplexPoleZero, TCComplexPoleZero> CPoleZeroListTemp;

	CPoleZeroListTemp.SetSize(order);
	CPoleZeroList.SetSize(order);

	int k= 1;

	sinh_mu = sinh(mu);
	cosh_mu = cosh(mu);

	int p;

	for(p = 0; p < order; p++)
	{
		r = -sin((2 * k - 1)*1.570796327/order);

		i = cos((2 * k - 1)*1.570796327/order);

 		CPoleZeroListTemp[p].r = sinh_mu * r;
		CPoleZeroListTemp[p].i = cosh_mu * i;

		k++;
	}

	k = 0;

	for(p = 0; p < order/2; p++)// reorder poles
	{
		CPoleZeroList[k] = CPoleZeroListTemp[p];

		CPoleZeroList[k + 1] = CPoleZeroListTemp[order - p - 1];

		k +=2;
	}

	//if odd
	if((order%2)) //to do
	{
		CPoleZeroList[order - 1] = CPoleZeroListTemp[p];
	}	

	int size = 0;//

	if(frequency_type == E_LOWPASS || frequency_type == E_HIGHPASS)
	{
		size = order + 1;//r ratio
	}
	
	if(!size || order > 17) 
	{
		CLCRList.SetSize(0);

		return false;
	}

	CLCRList.SetSize(size); 

	switch(ripple_index)
	{
		case E_POINT_01DB_RIPPLE:	
		{
			switch(order)
			{

			case 1:	CLCRList[0] = 0.09602579;
					CLCRList[1] = 1.0;
					break;
					
			case 2:	
					CLCRList[0] = 0.30988028;
					CLCRList[1] = 0.30988028;
					CLCRList[2] = 1.0;
					break;
			case 3:
					CLCRList[0] = 0.62917991;
					CLCRList[1] = 0.97028246;
					CLCRList[2] = 0.62917991;
					CLCRList[3] = 1.0;
					break;
			case 4:
					CLCRList[0] = 0.62664531;
					CLCRList[1] = 1.1938447;
					CLCRList[2] = 1.1938447;
					CLCRList[3] = 0.62664531;
					CLCRList[4] = 1.0;
					break;
			case 5:
					CLCRList[0] = 0.75633165;
					CLCRList[1] = 1.3049197;
					CLCRList[2] = 1.5773051;
					CLCRList[3] = 1.3049197;
					CLCRList[4] = 0.75633165;
					CLCRList[5] = 1.0;
					break;
			case 6:
					CLCRList[0] = 0.71896604;
					CLCRList[1] = 1.3728128;
					CLCRList[2] = 1.6005918;
					CLCRList[3] = 1.6005918;
					CLCRList[4] = 1.3728128;
					CLCRList[5] = 0.71896604;
					CLCRList[6] = 1.0;
					break;
			case 7:
					CLCRList[0] = 0.79694442;
					CLCRList[1] = 1.3924222;
					CLCRList[2] = 1.7481332;
					CLCRList[3] = 1.6331303;
					CLCRList[4] = 1.7481332;
					CLCRList[5] = 1.3924222;
					CLCRList[6] = 0.79694442;
					CLCRList[7] = 1.0;
					break;
			case 8:
					CLCRList[0] = 0.75835289;
					CLCRList[1] = 1.4274078;
					CLCRList[2] = 1.7121857;
					CLCRList[3] = 1.750348;
					CLCRList[4] = 1.750348;
					CLCRList[5] = 1.7121857;
					CLCRList[6] = 1.4274078;
					CLCRList[7] = 0.75835289;
					CLCRList[8] = 1.0;
					break;
			case 9:
					CLCRList[0] = 0.81446148;
					CLCRList[1] = 1.4270577;
					CLCRList[2] = 1.8043593;
					CLCRList[3] = 1.7125421;
					CLCRList[4] = 1.9057902;
					CLCRList[5] = 1.7125421;
					CLCRList[6] = 1.8043593;
					CLCRList[7] = 1.4270577;
					CLCRList[8] = 0.81446148;
					CLCRList[9] = 1.0;
					break;
			case 10:
					CLCRList[0] = 0.77945283;
					CLCRList[1] = 1.4502772;
					CLCRList[2] = 1.7608469;
					CLCRList[3] = 1.7902684;
					CLCRList[4] = 1.8494729;
					CLCRList[5] = 1.8494729;
					CLCRList[6] = 1.7902684;
					CLCRList[7] = 1.7608469;
					CLCRList[8] = 1.4502772;
					CLCRList[9] = 0.77945283;
					CLCRList[10] = 1.0;
					break;
			case 11:
					CLCRList[0] = 0.8235158;
					CLCRList[1] = 1.4442257;
					CLCRList[2] = 1.8298756;
					CLCRList[3] = 1.7437242;
					CLCRList[4] = 1.9554736;
					CLCRList[5] = 1.7855466;
					CLCRList[6] = 1.9554736;
					CLCRList[7] = 1.7437242;
					CLCRList[8] = 1.8298756;
					CLCRList[9] = 1.4442257;
					CLCRList[10] = 0.8235158;
					CLCRList[11] = 1.0;
					break;
			case 12:
					CLCRList[0] = 0.79239324;
					CLCRList[1] = 1.4617366;
					CLCRList[2] = 1.7876596;
					CLCRList[3] = 1.8045695;
					CLCRList[4] = 1.8932752;
					CLCRList[5] = 1.8827308;
					CLCRList[6] = 1.8827308;
					CLCRList[7] = 1.8932752;
					CLCRList[8] = 1.8045695;
					CLCRList[9] = 1.7876596;
					CLCRList[10] = 1.4617366;
					CLCRList[11] = 0.79239324;
					CLCRList[12] = 1.0;
					break;
			case 13:
					CLCRList[0] = 0.8287816;
					CLCRList[1] = 1.4539807;
					CLCRList[2] = 1.8436914;
					CLCRList[3] = 1.7593564;
					CLCRList[4] = 1.9777278;
					CLCRList[5] = 1.8134114;
					CLCRList[6] = 2.0014305;
					CLCRList[7] = 1.8134114;
					CLCRList[8] = 1.9777278;
					CLCRList[9] = 1.7593564;
					CLCRList[10] = 1.8436914;
					CLCRList[11] = 1.4539807;
					CLCRList[12] = 0.8287816;
					CLCRList[13] = 1.0;
					break;
			case 14:
					CLCRList[0] = 0.80106282;
					CLCRList[1] = 1.4681617;
					CLCRList[2] = 1.8045326;
					CLCRList[3] = 1.8103333;
					CLCRList[4] = 1.9181836;
					CLCRList[5] = 1.8929642;
					CLCRList[6] = 1.9236098;
					CLCRList[7] = 1.9236098;
					CLCRList[8] = 1.8929642;
					CLCRList[9] = 1.9181836;
					CLCRList[10] = 1.8103333;
					CLCRList[11] = 1.8045326;
					CLCRList[12] = 1.4681617;
					CLCRList[13] = 0.80106282;
					CLCRList[14] = 1.0;
					break;
			case 15:
					CLCRList[0] = 0.8321074;
					CLCRList[1] = 1.4600549;
					CLCRList[2] = 1.8520473;
					CLCRList[3] = 1.7683886;
					CLCRList[4] = 1.9897757;
					CLCRList[5] = 1.8272113;
					CLCRList[6] = 2.0216078;
					CLCRList[7] = 1.8393803;
					CLCRList[8] = 2.0216078;
					CLCRList[9] = 1.8272113;
					CLCRList[0] = 1.9897757;
					CLCRList[11] = 1.7683885;
					CLCRList[12] = 1.8520474;
					CLCRList[13] = 1.4600549;
					CLCRList[14] = 0.83210738;
					CLCRList[15] = 1.0;
					break;
			case 16:
					CLCRList[0] = 0.80724276;
					CLCRList[1] = 1.4720496;
					CLCRList[2] = 1.8160888;
					CLCRList[3] = 1.812638;
					CLCRList[4] = 1.9344331;
					CLCRList[5] = 1.8959329;
					CLCRList[6] = 1.947211;
					CLCRList[7] = 1.9318977;
					CLCRList[8] = 1.9318977;
					CLCRList[9] = 1.947211;
					CLCRList[0] = 1.8959329;
					CLCRList[11] = 1.9344331;
					CLCRList[12] = 1.812638;
					CLCRList[13] = 1.8160887;
					CLCRList[14] = 1.4720497;
					CLCRList[15] = 0.80724269;
					CLCRList[16] = 1.0;
					break;
			case 17:
					CLCRList[0] = 0.83433945;
					CLCRList[1] = 1.4640922;
					CLCRList[2] = 1.8575028;
					CLCRList[3] = 1.7741112;
					CLCRList[4] = 1.9971025;
					CLCRList[5] = 1.8351553;
					CLCRList[6] = 2.0324184;
					CLCRList[7] = 1.8520514;
					CLCRList[8] = 2.0405433;
					CLCRList[9] = 1.8520514;
					CLCRList[10] = 2.0324184;
					CLCRList[11] = 1.8351554;
					CLCRList[12] = 1.9971026;
					CLCRList[13] = 1.7741118;
					CLCRList[14] = 1.8574998;
					CLCRList[15] = 1.4640942;
					CLCRList[16] = 0.83433959;
					CLCRList[17] = 1.0;
					break;
			case 18:
					CLCRList[0] = 0.81185427;
					CLCRList[1] = 1.4745337;
					CLCRList[2] = 1.8244819;
					CLCRList[3] = 1.8133728;
					CLCRList[4] = 1.9459622;
					CLCRList[5] = 1.8961559;
					CLCRList[6] = 1.9629317;
					CLCRList[7] = 1.9334391;
					CLCRList[8] = 1.9545348;
					CLCRList[9] = 1.9545349;
					CLCRList[10] = 1.9334392;
					CLCRList[11] = 1.9629318;
					CLCRList[12] = 1.896156;
					CLCRList[13] = 1.9459621;
					CLCRList[14] = 1.8133727;
					CLCRList[15] = 1.8244802;
					CLCRList[16] = 1.4745346;
					CLCRList[17] = 0.81185429;
					CLCRList[18] = 1.0;
					break;
					}
		}break;

		case E_POINT_1DB_RIPPLE:	
		{
			switch(order)
			{
				case 1:
						CLCRList[0] = 0.30524084;
						CLCRList[1] = 1.0;
						break;
				case 2:
						CLCRList[0] = 0.55248605;
						CLCRList[1] = 0.55248605;
						CLCRList[2] = 1.0;
						break;

				case 3:
						CLCRList[0] = 1.0315598;
						CLCRList[1] = 1.1473972;
						CLCRList[2] = 1.0315598;
						CLCRList[3] = 1.0;
						break;
				case 4:
						CLCRList[0] = 0.92972399;
						CLCRList[1] = 1.4346401;
						CLCRList[2] = 1.4346401;
						CLCRList[3] = 0.92972399;
						CLCRList[4] = 1.0;
						break;
				case 5:
						CLCRList[0] = 1.1468131;
						CLCRList[1] = 1.3712126;
						CLCRList[2] = 1.9750032;
						CLCRList[3] = 1.3712126;
						CLCRList[4] = 1.1468131;
						CLCRList[5] = 1.0;
						break;
				case 6:
						CLCRList[0] = 1.0382194;
						CLCRList[1] = 1.5163168;
						CLCRList[2] = 1.7891574;
						CLCRList[3] = 1.7891574;
						CLCRList[4] = 1.5163168;
						CLCRList[5] = 1.0382194;
						CLCRList[6] = 1.0;
						break;
				case 7:
						CLCRList[0] = 1.1811783;
						CLCRList[1] = 1.4228062;
						CLCRList[2] = 2.0966713;
						CLCRList[3] = 1.5734011;
						CLCRList[4] = 2.0966713;
						CLCRList[5] = 1.4228062;
						CLCRList[6] = 1.1811783;
						CLCRList[7] = 1.0;
						break;
				case 8:
						CLCRList[0] = 1.0880321;
						CLCRList[1] = 1.5265026;
						CLCRList[2] = 1.9028541;
						CLCRList[3] = 1.8301105;
						CLCRList[4] = 1.8301105;
						CLCRList[5] = 1.9028541;
						CLCRList[6] = 1.5265026;
						CLCRList[7] = 1.0880321;
						CLCRList[8] = 1.0;
						break;
				case 9:
						CLCRList[0] = 1.1956722;
						CLCRList[1] = 1.442601;
						CLCRList[2] = 2.1345513;
						CLCRList[3] = 1.6167233;
						CLCRList[4] = 2.2053693;
						CLCRList[5] = 1.6167233;
						CLCRList[6] = 2.1345513;
						CLCRList[7] = 1.442601;
						CLCRList[8] = 1.1956722;
						CLCRList[9] = 1.0;
						break;
				case 10:
						CLCRList[0] = 1.1164514;
						CLCRList[1] = 1.5248801;
						CLCRList[2] = 1.9621145;
						CLCRList[3] = 1.8182881;
						CLCRList[4] = 1.9346096;
						CLCRList[5] = 1.9346096;
						CLCRList[6] = 1.8182881;
						CLCRList[7] = 1.9621145;
						CLCRList[8] = 1.5248801;
						CLCRList[9] = 1.1164514;
						CLCRList[10] = 1.0;
						break;
				case 11:
						CLCRList[0] = 1.203089;
						CLCRList[1] = 1.4522926;
						CLCRList[2] = 2.1514377;
						CLCRList[3] = 1.6332416;
						CLCRList[4] = 2.2377939;
						CLCRList[5] = 1.6559236;
						CLCRList[6] = 2.2377939;
						CLCRList[7] = 1.6332416;
						CLCRList[8] = 2.1514377;
						CLCRList[9] = 1.4522926;
						CLCRList[10] = 1.203089;
						CLCRList[11] = 1.0;
						break;
				case 12:
						CLCRList[0] = 1.134771;
						CLCRList[1] = 1.520939;
						CLCRList[2] = 1.99954;
						CLCRList[3] = 1.8019955;
						CLCRList[4] = 1.993022;
						CLCRList[5] = 1.9159393;
						CLCRList[6] = 1.9159393;
						CLCRList[7] = 1.993022;
						CLCRList[8] = 1.8019955;
						CLCRList[9] = 1.99954;
						CLCRList[10] = 1.520939;
						CLCRList[11] = 1.134771;
						CLCRList[12] = 1.0;
						break;
				case 13:
						CLCRList[0] = 1.2073794;
						CLCRList[1] = 1.4577656;
						CLCRList[2] = 2.1605083;
						CLCRList[3] = 1.6414293;
						CLCRList[4] = 2.2520665;
						CLCRList[5] = 1.6704549;
						CLCRList[6] = 2.2675221;
						CLCRList[7] = 1.6704549;
						CLCRList[8] = 2.2520665;
						CLCRList[9] = 1.6414293;
						CLCRList[10] = 2.1605083;
						CLCRList[11] = 1.4577656;
						CLCRList[12] = 1.2073794;
						CLCRList[13] = 1.0;
						break;
				case 14:
						CLCRList[0] = 1.1475425;
						CLCRList[1] = 1.5168148;
						CLCRList[2] = 2.025655;
						CLCRList[3] = 1.7872792;
						CLCRList[4] = 2.0323356;
						CLCRList[5] = 1.8941371;
						CLCRList[6] = 1.9723074;
						CLCRList[7] = 1.9723074;
						CLCRList[8] = 1.8941371;
						CLCRList[9] = 2.0323356;
						CLCRList[10] = 1.7872792;
						CLCRList[11] = 2.025655;
						CLCRList[12] = 1.5168148;
						CLCRList[13] = 1.1475425;
						CLCRList[14] = 1.0;
						break;
				case 15:
						CLCRList[0] = 1.2100804;
						CLCRList[1] = 1.4611615;
						CLCRList[2] = 2.1659709;
						CLCRList[3] = 1.6461339;
						CLCRList[4] = 2.2597344;
						CLCRList[5] = 1.6775713;
						CLCRList[6] = 2.2803494;
						CLCRList[7] = 1.6839243;
						CLCRList[8] = 2.2803494;
						CLCRList[9] = 1.6775713;
						CLCRList[10] = 2.2597344;
						CLCRList[11] = 1.6461339;
						CLCRList[12] = 2.1659709;
						CLCRList[13] = 1.4611615;
						CLCRList[14] = 1.2100804;
						CLCRList[15] = 1.0;
						break;
				case 16:
						CLCRList[0] = 1.156946;
						CLCRList[1] = 1.5130352;
						CLCRList[2] = 2.0450355;
						CLCRList[3] = 1.7748022;
						CLCRList[4] = 2.0612693;
						CLCRList[5] = 1.8748198;
						CLCRList[6] = 2.0115248;
						CLCRList[7] = 1.9482438;
						CLCRList[8] = 1.9482438;
						CLCRList[9] = 2.0115248;
						CLCRList[10] = 1.8748198;
						CLCRList[11] = 2.0612693;
						CLCRList[12] = 1.7748022;
						CLCRList[13] = 2.0450356;
						CLCRList[14] = 1.5130352;
						CLCRList[15] = 1.1569459;
						CLCRList[16] = 1.0;
						break;
				case 17:
						CLCRList[0] = 1.21189;
						CLCRList[1] = 1.4634157;
						CLCRList[2] = 2.169524;
						CLCRList[3] = 1.6491062;
						CLCRList[4] = 2.2643788;
						CLCRList[5] = 1.6816459;
						CLCRList[6] = 2.2871698;
						CLCRList[7] = 1.6904234;
						CLCRList[8] = 2.2923445;
						CLCRList[9] = 1.6904235;
						CLCRList[10] = 2.2871699;
						CLCRList[11] = 1.6816458;
						CLCRList[12] = 2.2643787;
						CLCRList[13] = 1.6491056;
						CLCRList[14] = 2.1695262;
						CLCRList[15] = 1.4634146;
						CLCRList[16] = 1.2118894;
						CLCRList[17] = 1.0;
						break;
				case 18:
						CLCRList[0] = 1.1641472;
						CLCRList[1] = 1.5097193;
						CLCRList[2] = 2.0600017;
						CLCRList[3] = 1.7643229;
						CLCRList[4] = 2.0837125;
						CLCRList[5] = 1.8584192;
						CLCRList[6] = 2.0412567;
						CLCRList[7] = 1.9267212;
						CLCRList[8] = 1.9866609;
						CLCRList[9] = 1.9866604;
						CLCRList[10] = 1.926721;
						CLCRList[11] = 2.0412555;
						CLCRList[12] = 1.8584188;
						CLCRList[13] = 2.0837118;
						CLCRList[14] = 1.764319;
						CLCRList[15] = 2.0600399;
						CLCRList[16] = 1.5097004;
						CLCRList[17] = 1.1641537;
						CLCRList[18] = 1.0;
						break;
			}

		}break;

		case E_POINT_5DB_RIPPLE:	
		{
			switch(order)
			{
				case 1:
						CLCRList[0] = 0.6986228;
						CLCRList[1] = 1.0;
						break;
				case 2:
						CLCRList[0] = 0.83583659;
						CLCRList[1] = 0.83583659;
						CLCRList[2] = 1.0;
						break;
				case 3:
						CLCRList[0] = 1.5962801;
						CLCRList[1] = 1.0966917;
						CLCRList[2] = 1.5962801;
						CLCRList[3] = 1.0;
						break;
				case 4:
						CLCRList[0] = 1.3090586;
						CLCRList[1] = 1.5414802;
						CLCRList[2] = 1.5414802;
						CLCRList[3] = 1.3090586;
						CLCRList[4] = 1.0;
						break;
				case 5:
						CLCRList[0] = 1.7057701;
						CLCRList[1] = 1.2296267;
						CLCRList[2] = 2.5408272;
						CLCRList[3] = 1.2296267;
						CLCRList[4] = 1.7057701;
						CLCRList[5] = 1.0;
						break;
				case 6:
						CLCRList[0] = 1.4610934;
						CLCRList[1] = 1.5084871;
						CLCRList[2] = 1.9333394;
						CLCRList[3] = 1.9333394;
						CLCRList[4] = 1.5084871;
						CLCRList[5] = 1.4610934;
						CLCRList[6] = 1.0;
						break;
				case 7:
						CLCRList[0] = 1.7372911;
						CLCRList[1] = 1.2582365;
						CLCRList[2] = 2.6382923;
						CLCRList[3] = 1.3443341;
						CLCRList[4] = 2.6382923;
						CLCRList[5] = 1.2582365;
						CLCRList[6] = 1.7372911;
						CLCRList[7] = 1.0;
						break;
				case 8:
						CLCRList[0] = 1.537227;
						CLCRList[1] = 1.4679435;
						CLCRList[2] = 2.1033395;
						CLCRList[3] = 1.8435945;
						CLCRList[4] = 1.8435945;
						CLCRList[5] = 2.1033395;
						CLCRList[6] = 1.4679435;
						CLCRList[7] = 1.537227;
						CLCRList[8] = 1.0;
						break;
				case 9:
						CLCRList[0] = 1.750439;
						CLCRList[1] = 1.2690431;
						CLCRList[2] = 2.6677804;
						CLCRList[3] = 1.3673258;
						CLCRList[4] = 2.7239042;
						CLCRList[5] = 1.3673258;
						CLCRList[6] = 2.6677804;
						CLCRList[7] = 1.2690431;
						CLCRList[8] = 1.750439;
						CLCRList[9] = 1.0;
						break;
				case 10:
						CLCRList[0] = 1.583179;
						CLCRList[1] = 1.4379569;
						CLCRList[2] = 2.207217;
						CLCRList[3] = 1.7663338;
						CLCRList[4] = 2.0029139;
						CLCRList[5] = 2.0029139;
						CLCRList[6] = 1.7663338;
						CLCRList[7] = 2.207217;
						CLCRList[8] = 1.4379569;
						CLCRList[9] = 1.583179;
						CLCRList[10] = 1.0;
						break;
				case 11:
						CLCRList[0] = 1.7571342;
						CLCRList[1] = 1.2743021;
						CLCRList[2] = 2.6808103;
						CLCRList[3] = 1.3759638;
						CLCRList[4] = 2.7487288;
						CLCRList[5] = 1.3879637;
						CLCRList[6] = 2.7487288;
						CLCRList[7] = 1.3759638;
						CLCRList[8] = 2.6808103;
						CLCRList[9] = 1.2743021;
						CLCRList[10] = 1.7571342;
						CLCRList[11] = 1.0;
						break;
				case 12:
						CLCRList[0] = 1.6139803;
						CLCRList[1] = 1.4159131;
						CLCRList[2] = 2.279077;
						CLCRList[3] = 1.7099785;
						CLCRList[4] = 2.1085263;
						CLCRList[5] = 1.913085;
						CLCRList[6] = 1.913085;
						CLCRList[7] = 2.1085263;
						CLCRList[8] = 1.7099785;
						CLCRList[9] = 2.279077;
						CLCRList[10] = 1.4159131;
						CLCRList[11] = 1.6139803;
						CLCRList[12] = 1.0;
						break;
				case 13:
						CLCRList[0] = 1.760997;
						CLCRList[1] = 1.2772631;
						CLCRList[2] = 2.6877821;
						CLCRList[3] = 1.3802217;
						CLCRList[4] = 2.7595619;
						CLCRList[5] = 1.3955024;
						CLCRList[6] = 2.7713888;
						CLCRList[7] = 1.3955024;
						CLCRList[8] = 2.7595619;
						CLCRList[9] = 1.3802217;
						CLCRList[10] = 2.6877821;
						CLCRList[11] = 1.2772631;
						CLCRList[12] = 1.760997;
						CLCRList[13] = 1.0;
						break;
				case 14:
						CLCRList[0] = 1.6360785;
						CLCRList[1] = 1.3992353;
						CLCRList[2] = 2.3322452;
						CLCRList[3] = 1.6679425;
						CLCRList[4] = 2.1864188;
						CLCRList[5] = 1.8454568;
						CLCRList[6] = 2.0144353;
						CLCRList[7] = 2.0144353;
						CLCRList[8] = 1.8454568;
						CLCRList[9] = 2.1864188;
						CLCRList[10] = 1.6679425;
						CLCRList[11] = 2.3322452;
						CLCRList[12] = 1.3992353;
						CLCRList[13] = 1.6360785;
						CLCRList[14] = 1.0;
						break;
				case 15:
						CLCRList[0] = 1.7634251;
						CLCRList[1] = 1.2790972;
						CLCRList[2] = 2.6919719;
						CLCRList[3] = 1.3826616;
						CLCRList[4] = 2.7653602;
						CLCRList[5] = 1.3991741;
						CLCRList[6] = 2.7810824;
						CLCRList[7] = 1.4024715;
						CLCRList[8] = 2.7810823;
						CLCRList[9] = 1.3991741;
						CLCRList[10] = 2.7653602;
						CLCRList[11] = 1.3826616;
						CLCRList[12] = 2.691972;
						CLCRList[13] = 1.2790972;
						CLCRList[14] = 1.7634251;
						CLCRList[15] = 1.0;
						break;
				case 16:
						CLCRList[0] = 1.6527108;
						CLCRList[1] = 1.3862405;
						CLCRList[2] = 2.373349;
						CLCRList[3] = 1.6355502;
						CLCRList[4] = 2.2470844;
						CLCRList[5] = 1.7936862;
						CLCRList[6] = 2.0918059;
						CLCRList[7] = 1.9414573;
						CLCRList[8] = 1.9414573;
						CLCRList[9] = 2.0918059;
						CLCRList[10] = 1.7936862;
						CLCRList[11] = 2.2470844;
						CLCRList[12] = 1.6355501;
						CLCRList[13] = 2.3733488;
						CLCRList[14] = 1.3862404;
						CLCRList[15] = 1.6527108;
						CLCRList[16] = 1.0;
						break;
				case 17:
						CLCRList[0] = 1.7650499;
						CLCRList[1] = 1.2803125;
						CLCRList[2] = 2.6946958;
						CLCRList[3] = 1.3842002;
						CLCRList[4] = 2.7688651;
						CLCRList[5] = 1.4012707;
						CLCRList[6] = 2.7862175;
						CLCRList[7] = 1.4058158;
						CLCRList[8] = 2.7901313;
						CLCRList[9] = 1.4058158;
						CLCRList[10] = 2.7862174;
						CLCRList[11] = 1.4012707;
						CLCRList[12] = 2.7688653;
						CLCRList[13] = 1.3842005;
						CLCRList[14] = 2.6946957;
						CLCRList[15] = 1.2803128;
						CLCRList[16] = 1.76505;
						CLCRList[17] = 1.0;
						break;
				case 18:
						CLCRList[0] = 1.6656765;
						CLCRList[1] = 1.3758632;
						CLCRList[2]	= 2.4061631;
						CLCRList[3]	= 1.6098692;
						CLCRList[4]	= 2.2959924;
						CLCRList[5] = 1.752914;
						CLCRList[6] = 2.1538433;
						CLCRList[7] = 1.8843984;
						CLCRList[8] = 2.0164046;
						CLCRList[9] = 2.0164057;
						CLCRList[10] = 1.8843985;
						CLCRList[11] = 2.1538455;
						CLCRList[12] = 1.7529142;
						CLCRList[13] = 2.2959929;
						CLCRList[14] = 1.6098667;
						CLCRList[15] = 2.4061449;
						CLCRList[16] = 1.3758521;
						CLCRList[17] = 1.6656825;
						CLCRList[18] = 1.0;
						break;
			}

		}break;

		case E_1DB_RIPPLE:
		{
			switch(order)
			{
				case 1:
						CLCRList[0] = 1.0176943;
						CLCRList[1] = 1.0;
						break;
				case 2:
						CLCRList[0] = 1.0088083;
						CLCRList[1] = 1.0088083;
						CLCRList[2] = 1.0;
						break;
				case 3:
						CLCRList[0] = 2.0235926;
						CLCRList[1] = 0.99410244;
						CLCRList[2] = 2.0235926;
						CLCRList[3] = 1.0;
						break;
				case 4:
						CLCRList[0] = 1.5674903;
						CLCRList[1] = 1.5537441;
						CLCRList[2] = 1.5537441;
						CLCRList[3] = 1.5674903;
						CLCRList[4] = 1.0;
						break;
				case 5:
						CLCRList[0] = 2.1348815;
						CLCRList[1] = 1.0911073;
						CLCRList[2] = 3.0009229;
						CLCRList[3] = 1.0911073;
						CLCRList[4] = 2.1348815;
						CLCRList[5] = 1.0;
						break;
				case 6:
						CLCRList[0] = 1.7622566;
						CLCRList[1] = 1.4527688;
						CLCRList[2] = 2.0088585;
						CLCRList[3] = 2.0088585;
						CLCRList[4] = 1.4527688;
						CLCRList[5] = 1.7622566;
						CLCRList[6] = 1.0;
						break;
				case 7:
						CLCRList[0] = 2.1665574;
						CLCRList[1] = 1.1115092;
						CLCRList[2] = 3.093642;
						CLCRList[3] = 1.1735205;
						CLCRList[4] = 3.093642;
						CLCRList[5] = 1.1115092;
						CLCRList[6] = 2.1665574;
						CLCRList[7] = 1.0;
						break;
				case 8:
						CLCRList[0] = 1.8641752;
						CLCRList[1] = 1.3832633;
						CLCRList[2] = 2.2357221;
						CLCRList[3] = 1.8318926;
						CLCRList[4] = 1.8318926;
						CLCRList[5] = 2.2357221;
						CLCRList[6] = 1.3832633;
						CLCRList[7] = 1.8641752;
						CLCRList[8] = 1.0;
						break;
				case 9:
						CLCRList[0] = 2.1797233;
						CLCRList[1] = 1.1191769;
						CLCRList[2] = 3.1214337;
						CLCRList[3] = 1.1896729;
						CLCRList[4] = 3.174634;
						CLCRList[5] = 1.1896729;
						CLCRList[6] = 3.1214337;
						CLCRList[7] = 1.1191769;
						CLCRList[8] = 2.1797233;
						CLCRList[9] = 1.0;
						break;
				case 10:
						CLCRList[0] = 1.9273167;
						CLCRList[1] = 1.3373597;
						CLCRList[2] = 2.382569;
						CLCRList[3] = 1.7118028;
						CLCRList[4] = 2.0409988;
						CLCRList[5] = 2.0409988;
						CLCRList[6] = 1.7118028;
						CLCRList[7] = 2.382569;
						CLCRList[8] = 1.3373597;
						CLCRList[9] = 1.9273167;
						CLCRList[10] = 1.0;
						break;
				case 11:
						CLCRList[0] = 2.1864172;
						CLCRList[1] = 1.1229012;
						CLCRList[2] = 3.1336793;
						CLCRList[3] = 1.1957126;
						CLCRList[4] = 3.1979029;
						CLCRList[5] = 1.2041341;
						CLCRList[6] = 3.1979029;
						CLCRList[7] = 1.1957126;
						CLCRList[8] = 3.1336793;
						CLCRList[9] = 1.1229012;
						CLCRList[10] = 2.1864172;
						CLCRList[11] = 1.0;
						break;
				case 12:
						CLCRList[0] = 1.9703793;
						CLCRList[1] = 1.3052747;
						CLCRList[2] = 2.487447;
						CLCRList[3] = 1.6297816;
						CLCRList[4] = 2.187785;
						CLCRList[5] = 1.9008392;
						CLCRList[6] = 1.9008392;
						CLCRList[7] = 2.187785;
						CLCRList[8] = 1.6297816;
						CLCRList[9] = 2.487447;
						CLCRList[10] = 1.3052747;
						CLCRList[11] = 1.9703793;
						CLCRList[12] = 1.0;
						break;
				case 13:
						CLCRList[0] = 2.1902761;
						CLCRList[1] = 1.1249961;
						CLCRList[2] = 3.1402234;
						CLCRList[3] = 1.1986844;
						CLCRList[4] = 3.2080291;
						CLCRList[5] = 1.2093917;
						CLCRList[6] = 3.2191128;
						CLCRList[7] = 1.2093917;
						CLCRList[8] = 3.2080291;
						CLCRList[9] = 1.1986844;
						CLCRList[10] = 3.1402234;
						CLCRList[11] = 1.1249961;
						CLCRList[12] = 2.1902761;
						CLCRList[13] = 1.0;
						break;
				case 14:
						CLCRList[0] = 2.0016587;
						CLCRList[1] = 1.2816945;
						CLCRList[2] = 2.5666669;
						CLCRList[3] = 1.5705797;
						CLCRList[4] = 2.2995056;
						CLCRList[5] = 1.8015116;
						CLCRList[6] = 2.0391654;
						CLCRList[7] = 2.0391654;
						CLCRList[8] = 1.8015116;
						CLCRList[9] = 2.2995056;
						CLCRList[10] = 1.5705797;
						CLCRList[11] = 2.5666669;
						CLCRList[12] = 1.2816945;
						CLCRList[13] = 2.0016587;
						CLCRList[14] = 1.0;
						break;
				case 15:
						CLCRList[0] = 2.1927003;
						CLCRList[1] = 1.1262933;
						CLCRList[2] = 3.1441519;
						CLCRList[3] = 1.2003861;
						CLCRList[4] = 3.2134423;
						CLCRList[5] = 1.2119479;
						CLCRList[6] = 3.2281608;
						CLCRList[7] = 1.2142479;
						CLCRList[8] = 3.2281608;
						CLCRList[9] = 1.2119479;
						CLCRList[10] = 3.2134423;
						CLCRList[11] = 1.200386;
						CLCRList[12] = 3.1441535;
						CLCRList[13] = 1.126293;
						CLCRList[14] = 2.1927003;
						CLCRList[15] = 1.0;
						break;
				case 16:
						CLCRList[0] = 2.0254211;
						CLCRList[1] = 1.2636682;
						CLCRList[2] = 2.6288183;
						CLCRList[3] = 1.5258806;
						CLCRList[4] = 2.3883438;
						CLCRList[5] = 1.7277902;
						CLCRList[6] = 2.1481162;
						CLCRList[7] = 1.9305833;
						CLCRList[8] = 1.9305832;
						CLCRList[9] = 2.1481165;
						CLCRList[10] = 1.7277902;
						CLCRList[11] = 2.3883439;
						CLCRList[12] = 1.5258801;
						CLCRList[13] = 2.628817;
						CLCRList[14] = 1.2636672;
						CLCRList[15] = 2.0254207;
						CLCRList[16] = 1.0;
						break;
				case 17:
						CLCRList[0] = 2.1943231;
						CLCRList[1] = 1.1271554;
						CLCRList[2] = 3.1467141;
						CLCRList[3] = 1.2014597;
						CLCRList[4] = 3.2167127;
						CLCRList[5] = 1.2134057;
						CLCRList[6] = 3.2329469;
						CLCRList[7] = 1.2165735;
						CLCRList[8] = 3.2366018;
						CLCRList[9] = 1.2165738;
						CLCRList[10] = 3.232948;
						CLCRList[11] = 1.213406;
						CLCRList[12] = 3.2167121;
						CLCRList[13] = 1.2014581;
						CLCRList[14] = 3.1467056;
						CLCRList[15] = 1.1271513;
						CLCRList[16] = 2.1943202;
						CLCRList[17] = 1.0;
						break;
				case 18:
						CLCRList[0] = 2.0443339;
						CLCRList[1] = 1.2494061;
						CLCRList[2] = 2.6789824;
						CLCRList[3] = 1.4909177;
						CLCRList[4] = 2.4610758;
						CLCRList[5] = 1.6708528;
						CLCRList[6] = 2.2373205;
						CLCRList[7] = 1.8482483;
						CLCRList[8] = 2.0345402;
						CLCRList[9] = 2.0345475;
						CLCRList[10] = 1.848241;
						CLCRList[11] = 2.2373284;
						CLCRList[12] = 1.6708467;
						CLCRList[13] = 2.4610885;
						CLCRList[14] = 1.4909155;
						CLCRList[15] = 2.679011;
						CLCRList[16] = 1.2494291;
						CLCRList[17] = 2.0441213;
						CLCRList[18] = 1.0;
						break;
			}

		}break;

		case E_3DB_RIPPLE:	
		{
			switch(order)
			{
				case 1:
						CLCRList[0] = 1.9952567;
						CLCRList[1] = 1.0;
						break;
				case 2:
						CLCRList[0] = 1.4125356;
						CLCRList[1] = 1.4125356;
						CLCRList[2] = 1.0;
						break;
				case 3:
						CLCRList[0] = 3.3487352;
						CLCRList[1] = 0.71170031;
						CLCRList[2] = 3.3487352;
						CLCRList[3] = 1.0;
						break;
				case 4:
						CLCRList[0] = 2.2573791;
						CLCRList[1] = 1.5106734;
						CLCRList[2] = 1.5106734;
						CLCRList[3] = 2.2573791;
						CLCRList[4] = 1.0;
						break;
				case 5:
						CLCRList[0] = 3.4812879;
						CLCRList[1] = 0.7619192;
						CLCRList[2] = 4.537546;
						CLCRList[3] = 0.7619192;
						CLCRList[4] = 3.4812879;
						CLCRList[5] = 1.0;
						break;
				case 6:
						CLCRList[0] = 2.6072901;
						CLCRList[1] = 1.271065;
						CLCRList[2] = 2.1729443;
						CLCRList[3] = 2.1729443;
						CLCRList[4] = 1.271065;
						CLCRList[5] = 2.6072901;
						CLCRList[6] = 1.0;
						break;
				case 7:
						CLCRList[0] = 3.5185244;
						CLCRList[1] = 0.77220005;
						CLCRList[2] = 4.6389788;
						CLCRList[3] = 0.80380957;
						CLCRList[4] = 4.6389788;
						CLCRList[5] = 0.77220005;
						CLCRList[6] = 3.5185244;
						CLCRList[7] = 1.0;
						break;
				case 8:
						CLCRList[0] = 2.8062127;
						CLCRList[1] = 1.1473343;
						CLCRList[2] = 2.5784181;
						CLCRList[3] = 1.7812965;
						CLCRList[4] = 1.7812965;
						CLCRList[5] = 2.5784181;
						CLCRList[6] = 1.1473343;
						CLCRList[7] = 2.8062127;
						CLCRList[8] = 1.0;
						break;
				case 9:
						CLCRList[0] = 3.5339392;
						CLCRList[1] = 0.77604177;
						CLCRList[2] = 4.6690569;
						CLCRList[3] = 0.81180656;
						CLCRList[4] = 4.7270147;
						CLCRList[5] = 0.81180656;
						CLCRList[6] = 4.6690569;
						CLCRList[7] = 0.77604177;
						CLCRList[8] = 3.5339392;
						CLCRList[9] = 1.0;
						break;
				case 10:
						CLCRList[0] = 2.9355983;
						CLCRList[1] = 1.0731298;
						CLCRList[2] = 2.8660908;
						CLCRList[3] = 1.564415;
						CLCRList[4] = 2.1268811;
						CLCRList[5] = 2.1268811;
						CLCRList[6] = 1.564415;
						CLCRList[7] = 2.8660908;
						CLCRList[8] = 1.0731298;
						CLCRList[9] = 2.9355983;
						CLCRList[10] = 1.0;
						break;
				case 11:
						CLCRList[0] = 3.5417625;
						CLCRList[1] = 0.77790365;
						CLCRList[2] = 4.6822671;
						CLCRList[3] = 0.81478049;
						CLCRList[4] = 4.7520388;
						CLCRList[5] = 0.81894491;
						CLCRList[6] = 4.7520388;
						CLCRList[7] = 0.81478049;
						CLCRList[8] = 4.6822671;
						CLCRList[9] = 0.77790365;
						CLCRList[10] = 3.5417625;
						CLCRList[11] = 1.0;
						break;
				case 12:
						CLCRList[0] = 3.0267346;
						CLCRList[1] = 1.0238345;
						CLCRList[2] = 3.0834025;
						CLCRList[3] = 1.4278206;
						CLCRList[4] = 2.3922144;
						CLCRList[5] = 1.8602346;
						CLCRList[6] = 1.8602346;
						CLCRList[7] = 2.3922144;
						CLCRList[8] = 1.4278206;
						CLCRList[9] = 3.0834025;
						CLCRList[10] = 1.0238345;
						CLCRList[11] = 3.0267346;
						CLCRList[12] = 1.0;
						break;
				case 13:
						CLCRList[0] = 3.5462683;
						CLCRList[1] = 0.77894979;
						CLCRList[2] = 4.6893167;
						CLCRList[3] = 0.81624085;
						CLCRList[4] = 4.7628944;
						CLCRList[5] = 0.82152607;
						CLCRList[6] = 4.7748117;
						CLCRList[7] = 0.82152607;
						CLCRList[8] = 4.7628944;
 						CLCRList[9] = 0.81624085;
						CLCRList[10] = 4.6893167;
						CLCRList[11] = 0.77894979;
						CLCRList[12] = 3.5462683;
						CLCRList[13] = 1.0;
						break;
				case 14:
						CLCRList[0] = 3.0944777;
						CLCRList[1] = 0.98874797;
						CLCRList[2] = 3.2540878;
						CLCRList[3] = 1.333775;
						CLCRList[4] = 2.6060067;
						CLCRList[5] = 1.6860968;
						CLCRList[6] = 2.0964085;
						CLCRList[7] = 2.0964085;
						CLCRList[8] = 1.6860968;
						CLCRList[9] = 2.6060067;
						CLCRList[10] = 1.333775;
						CLCRList[11] = 3.2540878;
						CLCRList[12] = 0.98874796;
						CLCRList[13] = 3.0944777;
						CLCRList[14] = 1.0;
						break;
				case 15:
						CLCRList[0] = 3.549097;
						CLCRList[1] = 0.77959692;
						CLCRList[2] = 4.6935468;
						CLCRList[3] = 0.81707613;
						CLCRList[4] = 4.7686898;
						CLCRList[5] = 0.82277851;
						CLCRList[6] = 4.7844961;
						CLCRList[7] = 0.82390785;
						CLCRList[8] = 4.784496;
						CLCRList[9] = 0.82277849;
						CLCRList[10] = 4.7686898;
						CLCRList[11] = 0.81707617;
						CLCRList[12] = 4.6935475;
						CLCRList[13] = 0.7795971;
						CLCRList[14] = 3.5490978;
						CLCRList[15] = 1.0;
						break;
				case 16:
						CLCRList[0] = 3.1468413;
						CLCRList[1] = 0.96251468;
						CLCRList[2] = 3.3919572;
						CLCRList[3] = 1.2650006;
						CLCRList[4] = 2.7832175;
						CLCRList[5] = 1.5630646;
						CLCRList[6] = 2.2930858;
						CLCRList[7] = 1.8975211;
						CLCRList[8] = 1.8975209;
						CLCRList[9] = 2.2930862;
						CLCRList[10] = 1.5630645;
						CLCRList[11] = 2.7832178;
						CLCRList[12] = 1.2650002;
						CLCRList[13] = 3.3919564;
						CLCRList[14] = 0.96251412;
						CLCRList[15] = 3.14684;
						CLCRList[16] = 1.0;
						break;
				case 17:
						CLCRList[0] = 3.5509954;
						CLCRList[1] = 0.78002715;
						CLCRList[2] = 4.6962997;
						CLCRList[3] = 0.81760243;
						CLCRList[4] = 4.7721869;
						CLCRList[5] = 0.82349204;
						CLCRList[6] = 4.7896121;
						CLCRList[7] = 0.82504636;
						CLCRList[8] = 4.7935253;
						CLCRList[9] = 0.82504644;
						CLCRList[10] = 4.7896132;
						CLCRList[11] = 0.82349236;
						CLCRList[12] = 4.7721887;
						CLCRList[13] = 0.81760231;
						CLCRList[14] = 4.6962929;
						CLCRList[15] = 0.780025;
						CLCRList[16] = 3.5509853;
						CLCRList[17] = 1.0;
						break;

			}

		}break;
	}

	return true;
}

bool TCFantasticFilter::CalculateInverseChebyshevPoleZeros(void)
{
/*
	function [z,p,k] = cheb2ap(n, rs)
%CHEB2AP	Chebyshev type II analog lowpass filter prototype.
%	[Z,P,K] = CHEB2AP(N,Rs) returns the zeros, poles, and gain
%	of an N-th order normalized prototype type II Chebyshev analog
%	lowpass filter with Rs decibels of ripple in the stopband.
%	Type II Chebyshev filters are maximally flat in the passband.
%


j = sqrt(-1);
delta = 1/sqrt(10^(.1*rs)-1);
mu = asinh(1/delta)/n;
if (rem(n,2))
	m = n - 1;
	z = j ./ cos([1:2:n-2 n+2:2:2*n-1]*pi/(2*n))';
else
	m = n;
	z = j ./ cos((1:2:2*n-1)*pi/(2*n))';
end
% Organize zeros in complex pairs:
i = [1:m/2; m:-1:m/2+1];
z = z(i(:));

p = exp(j*(pi*(1:2:2*n-1)/(2*n) + pi/2)).';
p = sinh(mu)*real(p) + j*cosh(mu)*imag(p);
p = 1 ./ p;
k = real(prod(-p)/prod(-z));


*/
/*
			case 18:CLCRList[0]=;
				CLCRList[1]=;
				CLCRList[2]=;
				CLCRList[3]=;
				CLCRList[4]=;
				CLCRList[5]=;
				CLCRList[6]=;
				CLCRList[7]=;
				CLCRList[8]=;
				CLCRList[9]=;
				CLCRList[10]=;
				CLCRList[11]=;
				CLCRList[12]=;
				CLCRList[13]=;
				CLCRList[14]=;
				CLCRList[15]=;
				CLCRList[16]=;
				CLCRList[17]=;
				break;

		case 19:CLCRList[0]=;
				CLCRList[1]=;
				CLCRList[2]=;
				CLCRList[3]=;
				CLCRList[4]=;
				CLCRList[5]=;
				CLCRList[6]=;
				CLCRList[7]=;
				CLCRList[8]=;
				CLCRList[9]=;
				CLCRList[10]=;
				CLCRList[11]=;
				CLCRList[12]=;
				CLCRList[13]=;
				CLCRList[14]=;
				CLCRList[15]=;
				CLCRList[16]=;
				CLCRList[17]=;
				CLCRList[18]=;
				break;

		case 20:CLCRList[0]=;
				CLCRList[1]=;
				CLCRList[2]=;
				CLCRList[3]=;
				CLCRList[4]=;
				CLCRList[5]=;
				CLCRList[6]=;
				CLCRList[7]=;
				CLCRList[8]=;
				CLCRList[9]=;
				CLCRList[10]=;
				CLCRList[11]=;
				CLCRList[12]=;
				CLCRList[13]=;
				CLCRList[14]=;
				CLCRList[15]=;
				CLCRList[16]=;
				CLCRList[17]=;
				CLCRList[18]=;
				CLCRList[19]=;
				break;
*/
	return true;
}

bool TCFantasticFilter::CalculateBesselPoleZeros(void)
{
	if(order > 18)
	{
		AfxMessageBox(IDS_NOT_YET_SUPPOTED);

		return false;
	}

	if(order < 0) order = 1;

	CPoleZeroList.SetSize(order);

	switch(order)
	{
		case 1: CPoleZeroList[0].r = -1; CPoleZeroList[0].i = 0; break;

		case 2: CPoleZeroList[0].r = -0.866025403; CPoleZeroList[0].i	= 0.5;
				CPoleZeroList[1].r = -0.866025403; CPoleZeroList[1].i	= -0.5;break;

		case 3: CPoleZeroList[0].r = -0.745640385; CPoleZeroList[0].i	= 0.711366625;
				CPoleZeroList[1].r = -0.745640385; CPoleZeroList[1].i	= -0.711366625;
				CPoleZeroList[2].r = -0.941600026533; CPoleZeroList[2].i = 0;break;

		case 4: CPoleZeroList[0].r = -0.657211171; CPoleZeroList[0].i = 0.830161434;
				CPoleZeroList[1].r = -0.657211171; CPoleZeroList[1].i = -0.830161434;
				CPoleZeroList[2].r = -0.904758796; CPoleZeroList[2].i = -0.270918733;
				CPoleZeroList[3].r = -0.904758796; CPoleZeroList[3].i = 0.270918733;break;

		case 5: CPoleZeroList[0].r = -0.590575944; CPoleZeroList[0].i = 0.907206756;
				CPoleZeroList[1].r = -0.590575944; CPoleZeroList[1].i = -0.907206756;
				CPoleZeroList[2].r = -0.851553619; CPoleZeroList[2].i = 0.442717464;
				CPoleZeroList[3].r = -0.851553619; CPoleZeroList[3].i = -0.442717464;
				CPoleZeroList[4].r = -0.926442077388; CPoleZeroList[4].i = 0;break;

		case 6:	CPoleZeroList[0].r = -0.538552681; CPoleZeroList[0].i = 0.961687688;
				CPoleZeroList[1].r = -0.538552681; CPoleZeroList[1].i = -0.961687688;
				CPoleZeroList[2].r = -0.799654185; CPoleZeroList[2].i = 0.596688411;
				CPoleZeroList[3].r = -0.799654185; CPoleZeroList[3].i = -0.596688411;
				CPoleZeroList[4].r = -0.909390683; CPoleZeroList[4].i = 0.185696439;
				CPoleZeroList[5].r = -0.909390683; CPoleZeroList[5].i = -0.185696439;break;

		case 7:	CPoleZeroList[0].r = -0.496691725; CPoleZeroList[0].i = 1.002508508;
				CPoleZeroList[1].r = -0.496691725; CPoleZeroList[1].i = -1.002508508;
				CPoleZeroList[2].r = -0.752735543; CPoleZeroList[2].i = 0.648540352;
				CPoleZeroList[3].r = -0.752735543; CPoleZeroList[3].i = -0.648540352;
				CPoleZeroList[4].r = -0.880002934; CPoleZeroList[4].i = 0.321665276;
				CPoleZeroList[5].r = -0.880002934; CPoleZeroList[5].i = -0.321665276;
				CPoleZeroList[6].r = -.919487155649; CPoleZeroList[6].i = 0;break;

		case 8:	CPoleZeroList[0].r = -0.462174041; CPoleZeroList[0].i = 0.1034388681;
				CPoleZeroList[1].r = -0.462174041; CPoleZeroList[1].i = -0.1034388681;
				CPoleZeroList[2].r = -0.71113818; CPoleZeroList[2].i = 0.718651731;
				CPoleZeroList[3].r = -0.71113818; CPoleZeroList[3].i = -0.718651731;
				CPoleZeroList[4].r = -0.84732508; CPoleZeroList[4].i = 0.425901754;
				CPoleZeroList[5].r = -0.84732508; CPoleZeroList[5].i = -0.425901754;
				CPoleZeroList[6].r = -0.909683154; CPoleZeroList[6].i = 0.141243798;
				CPoleZeroList[7].r = -0.909683154; CPoleZeroList[7].i = -0.141243798;break;


		case 9:	CPoleZeroList[0].r = -0.433141556; CPoleZeroList[0].i = 1.06007367;
				CPoleZeroList[1].r = -0.433141556; CPoleZeroList[1].i = -1.06007367;
				CPoleZeroList[2].r = -0.814802111; CPoleZeroList[2].i = 0.508581569;
				CPoleZeroList[3].r = -0.814802111; CPoleZeroList[3].i = -0.508581569;
				CPoleZeroList[4].r = -0.6743362268; CPoleZeroList[4].i = 0.77305462;
				CPoleZeroList[5].r = -0.6743362268; CPoleZeroList[5].i = -0.77305462;
				CPoleZeroList[6].r = -0.891121701; CPoleZeroList[6].i = 0.252658094;
				CPoleZeroList[7].r = -0.891121701; CPoleZeroList[7].i = -0.252658094;
				CPoleZeroList[8].r = -.915495779750; CPoleZeroList[8].i = 0;break;

		case 10:CPoleZeroList[0].r = -0.408322073; CPoleZeroList[0].i = 1.081274843;
				CPoleZeroList[1].r = -0.408322073; CPoleZeroList[1].i = -1.081274843;
				CPoleZeroList[2].r = -0.641751386; CPoleZeroList[2].i = 0.817583616;
				CPoleZeroList[3].r = -0.641751386; CPoleZeroList[3].i = -0.817583616;
				CPoleZeroList[4].r = -0.783769441; CPoleZeroList[4].i = 0.575914754;
				CPoleZeroList[5].r = -0.783769441; CPoleZeroList[5].i = -0.575914754;
				CPoleZeroList[6].r = -0.90913473; CPoleZeroList[6].i = 0.113958326;
				CPoleZeroList[7].r = -0.90913473; CPoleZeroList[7].i = -0.113958326;
				CPoleZeroList[8].r = -0.868845964; CPoleZeroList[8].i = 0.343000823;
				CPoleZeroList[9].r = -0.868845964; CPoleZeroList[9].i = -0.343000823;

		case 11:CPoleZeroList[0].r = -0.3868149510055090879155425; CPoleZeroList[0].i = 1.099117466763120928733632;
				CPoleZeroList[1].r = -0.3868149510055090879155425; CPoleZeroList[1].i = -1.099117466763120928733632;
				CPoleZeroList[2].r = -0.6126871554915194054182909; CPoleZeroList[2].i = .8547813893314764631518509;
				CPoleZeroList[3].r = -0.6126871554915194054182909; CPoleZeroList[3].i = -.8547813893314764631518509;
				CPoleZeroList[4].r = -0.7546938934722303128102142; CPoleZeroList[4].i = .6319150050721846494520941;
				CPoleZeroList[5].r = -0.7546938934722303128102142; CPoleZeroList[5].i = -.6319150050721846494520941;
				CPoleZeroList[6].r = -.8453044014712962954184557; CPoleZeroList[6].i = .4178696917801248292797448;
				CPoleZeroList[7].r = -.8453044014712962954184557; CPoleZeroList[7].i = -.4178696917801248292797448;
				CPoleZeroList[8].r = -.8963656705721166099815744; CPoleZeroList[8].i = .2080480375071031919692341;
				CPoleZeroList[9].r = -.8963656705721166099815744; CPoleZeroList[9].i = -.2080480375071031919692341;
				CPoleZeroList[10].r = -0.9129067244518981934637318; CPoleZeroList[10].i = 0.0;
				break;

		case 12:CPoleZeroList[0].r = -.9084478234140682638817772; CPoleZeroList[0].i = 95506365213450398415258360.0E-27;
				CPoleZeroList[1].r = -.9084478234140682638817772; CPoleZeroList[1].i = -95506365213450398415258360.0E-27;
				CPoleZeroList[2].r = -.8802534342016826507901575; CPoleZeroList[2].i = .2871779503524226723615457;
				CPoleZeroList[3].r = -.8802534342016826507901575; CPoleZeroList[3].i = -.2871779503524226723615457;
				CPoleZeroList[4].r = -.8217296939939077285792834; CPoleZeroList[4].i = .4810212115100676440620548;
				CPoleZeroList[5].r = -.8217296939939077285792834; CPoleZeroList[5].i = -.4810212115100676440620548;
				CPoleZeroList[6].r = -.7276681615395159454547013; CPoleZeroList[6].i = .6792961178764694160048987;
				CPoleZeroList[7].r = -.7276681615395159454547013; CPoleZeroList[7].i = -.6792961178764694160048987;
				CPoleZeroList[8].r = -.5866369321861477207528215; CPoleZeroList[8].i = .8863772751320727026622149;
				CPoleZeroList[9].r = -.5866369321861477207528215; CPoleZeroList[9].i = -.8863772751320727026622149;
				CPoleZeroList[10].r = -.3679640085526312839425808; CPoleZeroList[10].i = 1.114373575641546257595657;
				CPoleZeroList[11].r = -.3679640085526312839425808; CPoleZeroList[11].i = -1.114373575641546257595657;
				break;
				
		case 13:CPoleZeroList[0].r = -.8991314665475196220910718; CPoleZeroList[0].i = .1768342956161043620980863;
				CPoleZeroList[1].r = -.8991314665475196220910718; CPoleZeroList[1].i = -.1768342956161043620980863;
				CPoleZeroList[2].r = -.8625094198260548711573628; CPoleZeroList[2].i = .3547413731172988997754038;
				CPoleZeroList[3].r = -.8625094198260548711573628; CPoleZeroList[3].i = -.3547413731172988997754038;
				CPoleZeroList[4].r = -.7987460692470972510394686; CPoleZeroList[4].i = .5350752120696801938272504;
				CPoleZeroList[5].r = -.7987460692470972510394686; CPoleZeroList[5].i = -.5350752120696801938272504;
				CPoleZeroList[6].r = -.7026234675721275653944062; CPoleZeroList[6].i = .7199611890171304131266374;
				CPoleZeroList[7].r = -.7026234675721275653944062; CPoleZeroList[7].i = -.7199611890171304131266374;
				CPoleZeroList[8].r = -.5631559842430199266325818; CPoleZeroList[8].i = .9135900338325109684927731;
				CPoleZeroList[9].r = -.5631559842430199266325818; CPoleZeroList[9].i = -.9135900338325109684927731;
				CPoleZeroList[10].r = -.3512792323389821669401925; CPoleZeroList[10].i = 1.127591548317705678613239;
				CPoleZeroList[11].r = -.3512792323389821669401925; CPoleZeroList[11].i = -1.127591548317705678613239;
				CPoleZeroList[12].r = -.9110914665984182781070663; CPoleZeroList[12].i = 0.0;


		case 14:CPoleZeroList[0].r = -.9077932138396487614720659; CPoleZeroList[0].i = 82196399419401501888968130.0E-27;
				CPoleZeroList[1].r = -.9077932138396487614720659; CPoleZeroList[1].i = -82196399419401501888968130.0E-27;
				CPoleZeroList[2].r = -.8869506674916445312089167; CPoleZeroList[2].i = .2470079178765333183201435;
				CPoleZeroList[3].r = -.8869506674916445312089167; CPoleZeroList[3].i = -.2470079178765333183201435;
				CPoleZeroList[4].r = -.8441199160909851197897667; CPoleZeroList[4].i = .4131653825102692595237260;
				CPoleZeroList[5].r = -.8441199160909851197897667; CPoleZeroList[5].i = -.4131653825102692595237260;
				CPoleZeroList[6].r = -.7766591387063623897344648; CPoleZeroList[6].i = .5819170677377608590492434;
				CPoleZeroList[7].r = -.7766591387063623897344648; CPoleZeroList[7].i = -.5819170677377608590492434;
				CPoleZeroList[8].r = -.6794256425119233117869491; CPoleZeroList[8].i = .7552857305042033418417492;
				CPoleZeroList[9].r = -.6794256425119233117869491; CPoleZeroList[9].i = -.7552857305042033418417492;
				CPoleZeroList[10].r = -.5418766775112297376541293; CPoleZeroList[10].i = .9373043683516919569183099;
				CPoleZeroList[11].r = -.5418766775112297376541293; CPoleZeroList[11].i = -.9373043683516919569183099;
				CPoleZeroList[12].r = -.3363868224902037330610040; CPoleZeroList[12].i = 1.139172297839859991370924;
				CPoleZeroList[13].r = -.3363868224902037330610040; CPoleZeroList[13].i = -1.139172297839859991370924;
				break;

		case 15:CPoleZeroList[0].r = -.9006981694176978324932918; CPoleZeroList[0].i = .1537681197278439351298882;
				CPoleZeroList[1].r = -.9006981694176978324932918; CPoleZeroList[1].i = -.1537681197278439351298882;
				CPoleZeroList[2].r = -.8731264620834984978337843; CPoleZeroList[2].i = .3082352470564267657715883;
				CPoleZeroList[3].r = -.8731264620834984978337843; CPoleZeroList[3].i = -.3082352470564267657715883;
				CPoleZeroList[4].r = -.8256631452587146506294553; CPoleZeroList[4].i = .4642348752734325631275134;
				CPoleZeroList[5].r = -.8256631452587146506294553; CPoleZeroList[5].i = -.4642348752734325631275134;
				CPoleZeroList[6].r = -.7556027168970728127850416; CPoleZeroList[6].i = .6229396358758267198938604;
				CPoleZeroList[7].r = -.7556027168970728127850416; CPoleZeroList[7].i = -.6229396358758267198938604;
				CPoleZeroList[8].r = -.6579196593110998676999362; CPoleZeroList[8].i = .7862895503722515897065645;
				CPoleZeroList[9].r = -.6579196593110998676999362; CPoleZeroList[9].i = -.7862895503722515897065645;
				CPoleZeroList[10].r = -.5224954069658330616875186; CPoleZeroList[10].i = .9581787261092526478889345;
				CPoleZeroList[11].r = -.5224954069658330616875186; CPoleZeroList[11].i = -.9581787261092526478889345;
				CPoleZeroList[12].r = -.3229963059766444287113517; CPoleZeroList[12].i = 1.149416154583629539665297;
				CPoleZeroList[13].r = -.3229963059766444287113517; CPoleZeroList[13].i = -1.149416154583629539665297;
				CPoleZeroList[14].r = -.9097482363849064167228581; CPoleZeroList[14].i = 0.0;
				break;

		case 16:CPoleZeroList[0].r = -.9072099595087001356491337; CPoleZeroList[0].i = 72142113041117326028823950.0E-27;
				CPoleZeroList[1].r = -.9072099595087001356491337; CPoleZeroList[1].i = -72142113041117326028823950.0E-27;
				CPoleZeroList[2].r = -.8911723070323647674780132; CPoleZeroList[2].i = .2167089659900576449410059;
				CPoleZeroList[3].r = -.8911723070323647674780132; CPoleZeroList[3].i = -.2167089659900576449410059;
				CPoleZeroList[4].r = -.8584264231521330481755780; CPoleZeroList[4].i = .3621697271802065647661080;
				CPoleZeroList[5].r = -.8584264231521330481755780; CPoleZeroList[5].i = -.3621697271802065647661080;
				CPoleZeroList[6].r = -.8074790293236003885306146; CPoleZeroList[6].i = .5092933751171800179676218;
				CPoleZeroList[7].r = -.8074790293236003885306146; CPoleZeroList[7].i = -.5092933751171800179676218;
				CPoleZeroList[8].r = -.7356166304713115980927279; CPoleZeroList[8].i = .6591950877860393745845254;
				CPoleZeroList[9].r = -.7356166304713115980927279; CPoleZeroList[9].i = -.6591950877860393745845254;
				CPoleZeroList[10].r = -.6379502514039066715773828; CPoleZeroList[10].i = .8137453537108761895522580;
				CPoleZeroList[11].r = -.6379502514039066715773828; CPoleZeroList[11].i = -.8137453537108761895522580;
				CPoleZeroList[12].r = -.5047606444424766743309967; CPoleZeroList[12].i = .9767137477799090692947061;
				CPoleZeroList[13].r = -.5047606444424766743309967; CPoleZeroList[13].i = -.9767137477799090692947061;
				CPoleZeroList[14].r = -.3108782755645387813283867; CPoleZeroList[14].i = 1.158552841199330479412225;
				CPoleZeroList[15].r = -.3108782755645387813283867; CPoleZeroList[15].i = -1.158552841199330479412225;
				break;

		case 17:CPoleZeroList[0].r = -.9016273850787285964692844; CPoleZeroList[0].i = .1360267995173024591237303;
				CPoleZeroList[1].r = -.9016273850787285964692844; CPoleZeroList[1].i = -.1360267995173024591237303;
				CPoleZeroList[2].r = -.8801100704438627158492165; CPoleZeroList[2].i = .2725347156478803885651973;
				CPoleZeroList[3].r = -.8801100704438627158492165; CPoleZeroList[3].i = -.2725347156478803885651973;
				CPoleZeroList[4].r = -.8433414495836129204455491; CPoleZeroList[4].i = .4100759282910021624185986;
				CPoleZeroList[5].r = -.8433414495836129204455491; CPoleZeroList[5].i = -.4100759282910021624185986;
				CPoleZeroList[6].r = -.7897644147799708220288138; CPoleZeroList[6].i = .5493724405281088674296232;
				CPoleZeroList[7].r = -.7897644147799708220288138; CPoleZeroList[7].i = -.5493724405281088674296232;
				CPoleZeroList[8].r = -.7166893842372349049842743; CPoleZeroList[8].i = .6914936286393609433305754;
				CPoleZeroList[9].r = -.7166893842372349049842743; CPoleZeroList[9].i = -.6914936286393609433305754;
				CPoleZeroList[10].r = -.6193710717342144521602448; CPoleZeroList[10].i = .8382497252826992979368621;
				CPoleZeroList[11].r = -.6193710717342144521602448; CPoleZeroList[11].i = -.8382497252826992979368621;
				CPoleZeroList[12].r = -.4884629337672704194973683; CPoleZeroList[12].i = .9932971956316781632345466;
				CPoleZeroList[13].r = -.4884629337672704194973683; CPoleZeroList[13].i = -.9932971956316781632345466;
				CPoleZeroList[14].r = -.2998489459990082015466971; CPoleZeroList[14].i = 1.166761272925668786676672;
				CPoleZeroList[15].r = -.2998489459990082015466971; CPoleZeroList[15].i = -1.166761272925668786676672;
				CPoleZeroList[16].r = -.9087141161336397432860029; CPoleZeroList[16].i = 0.0;
				break;

		case 18:CPoleZeroList[0].r = -.906700432416277555418903; CPoleZeroList[0].i = 64279241063930693839360680.0E-27;
				CPoleZeroList[1].r = -.906700432416277555418903; CPoleZeroList[1].i = -64279241063930693839360680.0E-27;
				CPoleZeroList[2].r = -.8939764278132455733032155; CPoleZeroList[2].i = .1930374640894758606940586;
				CPoleZeroList[3].r = -.8939764278132455733032155; CPoleZeroList[3].i = -.1930374640894758606940586;
				CPoleZeroList[4].r = -.8681095503628830078317207; CPoleZeroList[4].i = .3224204925163257604931634;
				CPoleZeroList[5].r = -.8681095503628830078317207; CPoleZeroList[5].i = -.3224204925163257604931634;
				CPoleZeroList[6].r = -.8281885016242836608829018; CPoleZeroList[6].i = .4529385697815916950149364;
				CPoleZeroList[7].r = -.8281885016242836608829018; CPoleZeroList[7].i = .4529385697815916950149364;
				CPoleZeroList[8].r = -.7726285030739558780127746; CPoleZeroList[8].i = .5852778162086640620016316;
				CPoleZeroList[9].r = -.7726285030739558780127746; CPoleZeroList[9].i = -.5852778162086640620016316;
				CPoleZeroList[10].r = -.6987821445005273020051878; CPoleZeroList[10].i = .7204696509726630531663123;
				CPoleZeroList[11].r = -.6987821445005273020051878; CPoleZeroList[11].i = -.7204696509726630531663123;
				CPoleZeroList[12].r = -.6020482668090644386627299; CPoleZeroList[12].i = .8602708961893664447167418;
				CPoleZeroList[13].r = -.6020482668090644386627299; CPoleZeroList[13].i = -.8602708961893664447167418;
				CPoleZeroList[14].r = -.4734268069916151511140032; CPoleZeroList[14].i = 1.008234300314801077034158;
				CPoleZeroList[15].r = -.4734268069916151511140032; CPoleZeroList[15].i = -1.008234300314801077034158;
				CPoleZeroList[16].r = -.2897592029880489845789953; CPoleZeroList[16].i = 1.174183010600059128532230;
				CPoleZeroList[17].r = -.2897592029880489845789953; CPoleZeroList[17].i = -1.174183010600059128532230;
				break;

		case 19:CPoleZeroList[0].r = -.9021937639390660668922536; CPoleZeroList[0].i = .1219568381872026517578164;
				CPoleZeroList[1].r = -.9021937639390660668922536; CPoleZeroList[1].i = -.1219568381872026517578164;
				CPoleZeroList[2].r = -.8849290585034385274001112; CPoleZeroList[2].i = .2442590757549818229026280;
				CPoleZeroList[3].r = -.8849290585034385274001112; CPoleZeroList[3].i = .2442590757549818229026280;
				CPoleZeroList[4].r = -.8555768765618421591093993; CPoleZeroList[4].i = .3672925896399872304734923;
				CPoleZeroList[5].r = -.8555768765618421591093993; CPoleZeroList[5].i = -.3672925896399872304734923;
				CPoleZeroList[6].r = -.8131725551578197705476160; CPoleZeroList[6].i = .4915365035562459055630005;
				CPoleZeroList[7].r = -.8131725551578197705476160; CPoleZeroList[7].i = -.4915365035562459055630005;
				CPoleZeroList[8].r = -.7561260971541629355231897; CPoleZeroList[8].i = .6176483917970178919174173;
				CPoleZeroList[9].r = -.7561260971541629355231897; CPoleZeroList[9].i = -.6176483917970178919174173;
				CPoleZeroList[10].r = -.6818424412912442033411634; CPoleZeroList[10].i = .7466272357947761283262338;
				CPoleZeroList[11].r = -.6818424412912442033411634; CPoleZeroList[11].i = -.7466272357947761283262338;
				CPoleZeroList[12].r = -.5858613321217832644813602; CPoleZeroList[12].i = .8801817131014566284786759;
				CPoleZeroList[13].r = -.5858613321217832644813602; CPoleZeroList[13].i = -.8801817131014566284786759;
				CPoleZeroList[14].r = -.4595043449730988600785456; CPoleZeroList[14].i = 1.021768776912671221830298;
				CPoleZeroList[15].r = -.4595043449730988600785456; CPoleZeroList[15].i = -1.021768776912671221830298;
				CPoleZeroList[16].r = -.2804866851439370027628724; CPoleZeroList[16].i = 1.180931628453291873626003;
				CPoleZeroList[17].r = -.2804866851439370027628724; CPoleZeroList[17].i = -1.180931628453291873626003;
				CPoleZeroList[18].r = -.9078934217899404528985092; CPoleZeroList[18].i = 0.0;
				break;

		case 20:CPoleZeroList[0].r = -.9062570115576771146523497; CPoleZeroList[0].i = 57961780277849516990208850.0E-27;
				CPoleZeroList[1].r = -.9062570115576771146523497; CPoleZeroList[1].i = -57961780277849516990208850.0E-27;
				CPoleZeroList[2].r = -.8959150941925768608568248; CPoleZeroList[2].i = .1740317175918705058595844;
				CPoleZeroList[3].r = -.8959150941925768608568248; CPoleZeroList[3].i = -.1740317175918705058595844;
				CPoleZeroList[4].r = -.8749560316673332850673214; CPoleZeroList[4].i = .2905559296567908031706902;
				CPoleZeroList[5].r = -.8749560316673332850673214; CPoleZeroList[5].i = -.2905559296567908031706902;
				CPoleZeroList[6].r = -.8427907479956670633544106; CPoleZeroList[6].i = .4078917326291934082132821;
				CPoleZeroList[7].r = -.8427907479956670633544106; CPoleZeroList[7].i = -.4078917326291934082132821;
				CPoleZeroList[8].r = -.7984251191290606875799876; CPoleZeroList[8].i = .5264942388817132427317659;
				CPoleZeroList[9].r = -.7984251191290606875799876; CPoleZeroList[9].i = -.5264942388817132427317659;
				CPoleZeroList[10].r = -.7402780309646768991232610; CPoleZeroList[10].i = .6469975237605228320268752;
				CPoleZeroList[11].r = -.7402780309646768991232610; CPoleZeroList[11].i = -.6469975237605228320268752;
				CPoleZeroList[12].r = -.6658120544829934193890626; CPoleZeroList[12].i = .7703721701100763015154510;
				CPoleZeroList[13].r = -.6658120544829934193890626; CPoleZeroList[13].i = -.7703721701100763015154510;
				CPoleZeroList[14].r = -.5707026806915714094398061; CPoleZeroList[14].i = .8982829066468255593407161;
				CPoleZeroList[15].r = -.5707026806915714094398061; CPoleZeroList[15].i = -.8982829066468255593407161;
				CPoleZeroList[16].r = -.4465700698205149555701841; CPoleZeroList[16].i = 1.034097702560842962315411;
				CPoleZeroList[17].r = -.4465700698205149555701841; CPoleZeroList[17].i = -1.034097702560842962315411;
				CPoleZeroList[18].r = -.2719299580251652601727704; CPoleZeroList[18].i = 1.187099379810885886139638;
				CPoleZeroList[19].r = -.2719299580251652601727704; CPoleZeroList[19].i = -1.187099379810885886139638;
				break;
	}

	int size = 0;//

	if(frequency_type == E_LOWPASS || frequency_type == E_HIGHPASS)
	{
		size = order + 1;//Last is RS/RL
	}
	
	CLCRList.SetSize(size); // setup to do

	switch(order)
	{
		case 1: CLCRList[0]=2.0;
				CLCRList[1]= 1.0;
				break;

		case 2:	CLCRList[0]= 0.732050807569;
				CLCRList[1]= 2.73205080757;
				CLCRList[2]= 1.0;
				break;

		case 3:	CLCRList[0]=0.473979630417;
				CLCRList[1]=1.3632885053;
				CLCRList[2]=3.09515601294;
				CLCRList[3]= 1.0;
				break;

		case 4:	CLCRList[0]=0.353459379658;
				CLCRList[1]=1.01839806439;
				CLCRList[2]=1.63772975826;
				CLCRList[3]=3.39258454358;
				CLCRList[4]= 1.0;
				break;

		case 5: CLCRList[0]=0.282675893579;
				CLCRList[1]=0.822540201911;
				CLCRList[2]=1.30378260475;
				CLCRList[3]=1.80164874945;
				CLCRList[4]=3.66191940438;
				CLCRList[5]= 1.0;
				break;

		case 6:	CLCRList[0]=0.235868341893;
				CLCRList[1]=0.691555897386;
				CLCRList[2]=1.10450502733;
				CLCRList[3]=1.47540140758;
				CLCRList[4]=1.92272454621;
				CLCRList[5]=3.91325448149;
				CLCRList[6]= 1.0;
				break;

		case 7:	CLCRList[0]=0.202534501783;
				CLCRList[1]=0.596980168225;
				CLCRList[2]=0.961527960889;
				CLCRList[3]=1.28597976881;
				CLCRList[4]=1.59193214672;
				CLCRList[5]=2.02450224278;
				CLCRList[6]=4.15080380809;
				CLCRList[7]= 1.0;
				break;

		case 8:	CLCRList[0]=0.177551490882;
				CLCRList[1]=0.525301730214;
				CLCRList[2]=0.851813349888;
				CLCRList[3]=1.14671751497;
				CLCRList[4]=1.41077601722;
				CLCRList[5]=1.67977965863;
				CLCRList[6]=2.11650070408;
				CLCRList[7]=4.37690529348;
				CLCRList[8]= 1.0;
				break;
 
		case 9:	CLCRList[0]=0.158111921572;
				CLCRList[1]=0.469052237841;
				CLCRList[2]=0.764518379085;
				CLCRList[3]=1.03584528209;
				CLCRList[4]=1.27882981534;
				CLCRList[5]=1.50218633087;
				CLCRList[6]=1.75191181625;
				CLCRList[7]=2.20295403698;
				CLCRList[8]=4.59311275714;
				CLCRList[9]= 1.0;
				break;

		case 10:CLCRList[0]=0.142544785706;
				CLCRList[1]=0.423717142735;
				CLCRList[2]=0.693324989997;
				CLCRList[3]=0.944444160835;
				CLCRList[4]=1.17212171912;
				CLCRList[5]=1.37677261833;
				CLCRList[6]=1.57328413961;
				CLCRList[7]=1.81511268196;
				CLCRList[8]=2.28586232139;
				CLCRList[9]=4.8005801733;
				CLCRList[10]= 1.0;
				break;

		case 11:CLCRList[0]=0.129791785696;
				CLCRList[1]=0.386393985446;
				CLCRList[2]=0.634151320523;
				CLCRList[3]=0.867568748167;
				CLCRList[4]=1.08209335674;
				CLCRList[5]=1.27559076334;
				CLCRList[6]=1.45219971631;
				CLCRList[7]=1.63175090401;
				CLCRList[8]=1.87308351666;
				CLCRList[9]=2.36620686187;
				CLCRList[10]=5.00022413994;
				CLCRList[11]= 1.0;
				break;
 
		case 12:CLCRList[0]=0.119149379689;
				CLCRList[1]=0.355128125884;
				CLCRList[2]=0.584202373258;
				CLCRList[3]=0.801987002149;
				CLCRList[4]=1.0045780595;
				CLCRList[5]=1.18923589839;
				CLCRList[6]=1.35612613026;
				CLCRList[7]=1.51253726534;
				CLCRList[8]=1.68225914351;
				CLCRList[9]=1.92789296124;
				CLCRList[10]=2.44448265449;
				CLCRList[11]=5.19280305508;
				CLCRList[12]= 1.0;
				break;

		case 13:CLCRList[0]=0.110131283674;
				CLCRList[1]=0.328553844424;
				CLCRList[2]=0.541489238686;
				CLCRList[3]=0.745403370239;
				CLCRList[4]=0.937022715639;
				CLCRList[5]=1.11366730657;
				CLCRList[6]=1.27407610562;
				CLCRList[7]=1.42040400881;
				CLCRList[8]=1.56265550734;
				CLCRList[9]=1.72771866206;
				CLCRList[10]=1.98070716231;
				CLCRList[11]=2.5209477152;
				CLCRList[12]=5.37896049531;
				CLCRList[13]= 1.0;
				break;
 
		case 14:CLCRList[0]=0.102390351037;
				CLCRList[1]=0.305687844941;
				CLCRList[2]=0.504555187695;
				CLCRList[3]=0.696113238669;
				CLCRList[4]=0.877630287529;
				CLCRList[5]=1.04669368867;
				CLCRList[6]=1.20161738436;
				CLCRList[7]=1.342421312;
				CLCRList[8]=1.47304388664;
				CLCRList[9]=1.60582086971;
				CLCRList[10]=1.76996519158;
				CLCRList[11]=2.03217967865;
				CLCRList[12]=2.5957448654;
				CLCRList[13]=5.55925150754;
				CLCRList[14]= 1.0;
				break;


		case 15:CLCRList[0]=0.0956744319799;
				CLCRList[1]=0.285797946898;
				CLCRList[2]=0.472315401058;
				CLCRList[3]=0.652810110519;
				CLCRList[4]=0.825043622597;
				CLCRList[5]=0.986875681397;
				CLCRList[6]=1.13661171828;
				CLCRList[7]=1.27340911911;
				CLCRList[8]=1.39845521763;
				CLCRList[9]=1.51730765686;
				CLCRList[10]=1.64425829546;
				CLCRList[11]=1.81016041295;
				CLCRList[12]=2.0826692461;
				CLCRList[13]=2.66896244693;
				CLCRList[14]=5.73416000102;
				CLCRList[15]= 1.0;
				break;

		case 16:CLCRList[0]=0.0897919299458;
				CLCRList[1]=0.268338379475;
				CLCRList[2]=0.443931555661;
				CLCRList[3]=0.614486847996;
				CLCRList[4]=0.778188807567;
				CLCRList[5]=0.933148885597;
				CLCRList[6]=1.07780853029;
				CLCRList[7]=1.21102620962;
				CLCRList[8]=1.33274873017;
				CLCRList[9]=1.44524415797;
				CLCRList[10]=1.55553635791;
				CLCRList[11]=1.67949620077;
				CLCRList[12]=1.84903460519;
				CLCRList[13]=2.13236527246;
				CLCRList[14]=2.74066455421;
				CLCRList[15]=5.9041111237;
				CLCRList[16]= 1.0;
				break;

		case 17:CLCRList[0]=0.0846322843164;
				CLCRList[1]=0.252799423223;
				CLCRList[2]=0.418855840677;
				CLCRList[3]=0.580266880378;
				CLCRList[4]=0.736248931482;
				CLCRList[5]=0.884651414918;
				CLCRList[6]=1.02434823019;
				CLCRList[7]=1.15404926839;
				CLCRList[8]=1.27318853009;
				CLCRList[9]=1.38243086862;
				CLCRList[10]=1.48507093836;
				CLCRList[11]=1.58942960296;
				CLCRList[12]=1.71258618248;
				CLCRList[13]=1.88703914121;
				CLCRList[14]=2.18136150677;
				CLCRList[15]=2.8109056941;
				CLCRList[16]=6.06948059044;
				CLCRList[17]= 1.0;
				break;
 
		case 18:CLCRList[0]=0.0793311428625;
				CLCRList[1]=0.240832775757;
				CLCRList[2]=0.394075604097;
				CLCRList[3]=0.551826818197;
				CLCRList[4]=0.696849697343;
				CLCRList[5]=0.841666016079;
				CLCRList[6]=0.975106232801;
				CLCRList[7]=1.10189492294;
				CLCRList[8]=1.21838703618;
				CLCRList[9]=1.32561928237;
				CLCRList[10]=1.42459137818;
				CLCRList[11]=1.51965672743;
				CLCRList[12]=1.62022944089;
				CLCRList[13]=1.7442479818;
				CLCRList[14]=1.92444491047;
				CLCRList[15]=2.22969955105;
				CLCRList[16]=2.87973745094;
				CLCRList[17]=6.23060201896;
				CLCRList[18]= 1.0;
				break;
	}

	return true;
}

bool TCFantasticFilter::CalculateGaussianPoleZeros(void)
{
	if(order > 17)
	{
		AfxMessageBox(IDS_NOT_YET_SUPPOTED);

		return false;
	}

	int size = 0;//

	if(frequency_type == E_LOWPASS || frequency_type == E_HIGHPASS)
	{
		size = order + 1;//RS/RL ratio on end
	}
	
	if(!size) return false;

	switch(order)
	{
		case 1:	CPoleZeroList[0].r = 1; CPoleZeroList[0].i = 0.0;
				break;

		case 2:	CPoleZeroList[0].r = -0.923879532; CPoleZeroList[0].i = 0.382683432;
				CPoleZeroList[1].r = -0.923879532; CPoleZeroList[1].i = -0.382683432;
				break;

		case 3:	CPoleZeroList[0].r = -0.852440286; CPoleZeroList[0].i = 0.583394092;
				CPoleZeroList[1].r = -0.852440286; CPoleZeroList[1].i = -0.583394092;
				CPoleZeroList[2].r = -.937204391852; CPoleZeroList[2].i = 0.0;
				break;

		case 4:	CPoleZeroList[0].r = -0.793876652; CPoleZeroList[0].i = .712743132;
				CPoleZeroList[1].r = -0.793876652; CPoleZeroList[1].i = -.712743132;
				CPoleZeroList[2].r = -.911019134; CPoleZeroList[2].i = 0.01888886;
				CPoleZeroList[3].r = -.911019134; CPoleZeroList[3].i = -0.01888886;
				break;

		case 5:	CPoleZeroList[0].r = -.745751395; CPoleZeroList[0].i = 0.805105767;
				CPoleZeroList[1].r = -.745751395; CPoleZeroList[1].i = -0.805105767;
				CPoleZeroList[2].r = -0.877705787; CPoleZeroList[2].i = 0.370408655;
				CPoleZeroList[3].r = -0.877705787; CPoleZeroList[3].i = -0.370408655;
				CPoleZeroList[4].r = -.914893598160; CPoleZeroList[4].i = 0.0;
				break;

		case 6:	CPoleZeroList[0].r = -0.705523823; CPoleZeroList[0].i = 0.875322551;
				CPoleZeroList[1].r = -0.705523823; CPoleZeroList[1].i = -0.875322551;
				CPoleZeroList[2].r = -0.844599209; CPoleZeroList[2].i = 0.481405531;
				CPoleZeroList[3].r = -0.844599209; CPoleZeroList[3].i = -0.481405531;
				CPoleZeroList[4].r = -0.90167321; CPoleZeroList[4].i = 0.155283127;
				CPoleZeroList[5].r = -0.90167321; CPoleZeroList[5].i = -0.155283127;
				break;

		case 7:	CPoleZeroList[0].r = -.81364079; CPoleZeroList[0].i = 0.56798272;
				CPoleZeroList[1].r = -.81364079; CPoleZeroList[1].i = -0.56798272;
				CPoleZeroList[2].r = -0.671311156; CPoleZeroList[2].i = 0.931024427;
				CPoleZeroList[3].r = -0.671311156; CPoleZeroList[3].i = -0.931024427;
				CPoleZeroList[4].r = -0.882427503; CPoleZeroList[4].i = 0.273082036;
				CPoleZeroList[5].r = -0.882427503; CPoleZeroList[5].i = -0.273082036;
				CPoleZeroList[6].r = -.903476247714; CPoleZeroList[6].i = 0.0;
				break;

		case 8:	CPoleZeroList[0].r = -0.641768254; CPoleZeroList[0].i = 0.976598924;
				CPoleZeroList[1].r = -0.641768254; CPoleZeroList[1].i = -0.976598924;
				CPoleZeroList[2].r = -0.78523918; CPoleZeroList[2].i = 0.638010572;
				CPoleZeroList[3].r = -0.78523918; CPoleZeroList[3].i = -0.638010572;
				CPoleZeroList[4].r = -0.861302485; CPoleZeroList[4].i = 0.366676795;
				CPoleZeroList[5].r = -0.861302485; CPoleZeroList[5].i = -0.366676795;
				CPoleZeroList[6].r = -0.895511116; CPoleZeroList[6].i = 0.119975387;
				CPoleZeroList[7].r = -0.895511116; CPoleZeroList[7].i = -0.119975387;
				break;

		case 9:	CPoleZeroList[0].r = -0.615924672; CPoleZeroList[0].i = 1.014774451;
				CPoleZeroList[1].r = -0.615924672; CPoleZeroList[1].i = -1.014774451;
				CPoleZeroList[2].r = -0.840031788; CPoleZeroList[2].i = 0.443474646;
				CPoleZeroList[3].r = -0.840031788; CPoleZeroList[3].i = -0.443474646;
				CPoleZeroList[4].r = -0.759320423; CPoleZeroList[4].i = 0.696190135;
				CPoleZeroList[5].r = -0.759320423; CPoleZeroList[5].i = -0.696190135;
				CPoleZeroList[6].r = -0.882977339; CPoleZeroList[6].i = 0.216666375;
				CPoleZeroList[7].r = -0.882977339; CPoleZeroList[7].i = -0.216666375;
				CPoleZeroList[8].r = -.896556904490; CPoleZeroList[8].i = 0.0;
				break;

		case 10:CPoleZeroList[0].r = -0.593066359; CPoleZeroList[0].i = 1.04734966;
				CPoleZeroList[1].r = -0.593066359; CPoleZeroList[1].i = -1.04734966;
				CPoleZeroList[2].r = -0.735664691; CPoleZeroList[2].i = 0.745533719;
				CPoleZeroList[3].r = -0.735664691; CPoleZeroList[3].i = -0.745533719;
				CPoleZeroList[4].r = -0.819369316; CPoleZeroList[4].i = 0.508015857;
				CPoleZeroList[5].r = -0.819369316; CPoleZeroList[5].i = -0.508015857;
				CPoleZeroList[6].r = -0.89123727; CPoleZeroList[6].i = 0.97793419;
				CPoleZeroList[7].r = -0.89123727; CPoleZeroList[7].i = -0.97793419;
				CPoleZeroList[8].r = -0.868346356; CPoleZeroList[8].i = 0.296913014;
				CPoleZeroList[9].r = -0.868346356; CPoleZeroList[9].i = -0.296913014;
				break;

		case 11:CPoleZeroList[0].r = -0.572656817; CPoleZeroList[0].i = 1.075565201;
				CPoleZeroList[1].r = -0.572656817; CPoleZeroList[1].i = -1.075565201;
				CPoleZeroList[2].r = -0.714023366; CPoleZeroList[2].i = 0.78807624;
				CPoleZeroList[3].r = -0.714023366; CPoleZeroList[3].i = -0.78807624;
				CPoleZeroList[4].r = -0.852882653; CPoleZeroList[4].i = 0.3649831;
				CPoleZeroList[5].r = -0.852882653; CPoleZeroList[5].i = -0.3649831;
				CPoleZeroList[6].r = -0.799632525; CPoleZeroList[6].i = 0.56327305;
				CPoleZeroList[7].r = -0.799632525; CPoleZeroList[7].i = -0.56327305;
				CPoleZeroList[8].r = -0.882425849; CPoleZeroList[8].i = 0.179712578;
				CPoleZeroList[9].r = -0.882425849; CPoleZeroList[9].i = -0.179712578;
				CPoleZeroList[10].r = -.891925459272; CPoleZeroList[10].i = 0.0;
				break;

		case 12:CPoleZeroList[0].r = -0.554284944; CPoleZeroList[0].i = 1.100308382;
				CPoleZeroList[1].r = -0.554284944; CPoleZeroList[1].i = -1.100308382;
				CPoleZeroList[2].r = -0.694160068; CPoleZeroList[2].i = 0.825249252;
				CPoleZeroList[3].r = -0.694160068; CPoleZeroList[3].i = -0.825249252;
				CPoleZeroList[4].r = -0.780933391; CPoleZeroList[4].i = 0.611290594;
				CPoleZeroList[5].r = -0.780933391; CPoleZeroList[5].i = -0.611290594;
				CPoleZeroList[6].r = -0.837261364; CPoleZeroList[6].i = 0.423715001;
				CPoleZeroList[7].r = -0.837261364; CPoleZeroList[7].i = -0.423715001;
				CPoleZeroList[8].r = -0.888123543; CPoleZeroList[8].i = 0.82554467;
				CPoleZeroList[9].r = -0.888123543; CPoleZeroList[9].i = -0.82554467;
				CPoleZeroList[10].r = -0.871697371; CPoleZeroList[10].i = 0.24974166;
				CPoleZeroList[11].r = -0.871697371; CPoleZeroList[11].i = -0.24974166;
				break;
				
		case 13:CPoleZeroList[0].r = -0.537630056; CPoleZeroList[0].i = 1.122232913;
				CPoleZeroList[1].r = -0.537630056; CPoleZeroList[1].i = -1.122232913;
				CPoleZeroList[2].r = -0.675863469; CPoleZeroList[2].i = 0.858094331;
				CPoleZeroList[3].r = -0.675863469; CPoleZeroList[3].i = -0.858094331;
				CPoleZeroList[4].r = -0.881590965; CPoleZeroList[4].i = 0.153590446;
				CPoleZeroList[5].r = -0.881590965; CPoleZeroList[5].i = -0.153590446;
				CPoleZeroList[6].r = -0.859961069; CPoleZeroList[6].i = 0.310560929;
				CPoleZeroList[7].r = -0.859961069; CPoleZeroList[7].i = -0.310560929;
				CPoleZeroList[8].r = -0.821849595; CPoleZeroList[8].i = 0.475087774;
				CPoleZeroList[9].r = -0.821849595; CPoleZeroList[9].i = -0.475087774;
				CPoleZeroList[10].r = -0.763284652; CPoleZeroList[10].i = 0.653529439;
				CPoleZeroList[11].r = -0.763284652; CPoleZeroList[11].i = -0.653529439;
				CPoleZeroList[12].r = -.888614549919; CPoleZeroList[12].i = 0.0;
				break;

		case 14:CPoleZeroList[0].r = -0.522437979; CPoleZeroList[0].i = 1.14183247;
				CPoleZeroList[1].r = -0.522437979; CPoleZeroList[1].i = -1.14183247;
				CPoleZeroList[2].r = -0.658949408; CPoleZeroList[2].i = 0.88738992;
				CPoleZeroList[3].r = -0.658949408; CPoleZeroList[3].i = -0.88738992;
				CPoleZeroList[4].r = -0.746651429; CPoleZeroList[4].i = 0.691066341;
				CPoleZeroList[5].r = -0.746651429; CPoleZeroList[5].i = -0.691066341;
				CPoleZeroList[6].r = -0.806845506; CPoleZeroList[6].i = 0.520532844;
				CPoleZeroList[7].r = -0.806845506; CPoleZeroList[7].i = -0.520532844;
				CPoleZeroList[8].r = -0.847760695; CPoleZeroList[8].i = 0.364058868;
				CPoleZeroList[9].r = -0.847760695; CPoleZeroList[9].i = -0.364058868;
				CPoleZeroList[10].r = -0.885763523; CPoleZeroList[10].i = 0.071435516;
				CPoleZeroList[11].r = -0.885763523; CPoleZeroList[11].i = -0.071435516;
				CPoleZeroList[12].r = -0.873388439; CPoleZeroList[12].i = 0.215631823;
				CPoleZeroList[13].r = -0.873388439; CPoleZeroList[13].i = -0.215631823;

		case 15:CPoleZeroList[0].r = -0.508504366; CPoleZeroList[0].i = 1.159487787;
				CPoleZeroList[1].r = -0.508504366; CPoleZeroList[1].i = -1.159487787;;
				CPoleZeroList[2].r = -0.643259065; CPoleZeroList[2].i = 0.913731285;
				CPoleZeroList[3].r = -0.643259065; CPoleZeroList[3].i = -0.913731285;
				CPoleZeroList[4].r = -0.730977262; CPoleZeroList[4].i = 0.724715359;
				CPoleZeroList[5].r = -0.730977262; CPoleZeroList[5].i = -0.724715359;
				CPoleZeroList[6].r = -0.792351389; CPoleZeroList[6].i = 0.561116473;
				CPoleZeroList[7].r = -0.792351389; CPoleZeroList[7].i = -0.561116473;
				CPoleZeroList[8].r = -0.835428712; CPoleZeroList[8].i = 0.411614429;
				CPoleZeroList[9].r = -0.835428712; CPoleZeroList[9].i = -0.411614429;
				CPoleZeroList[10].r = -0.880727322; CPoleZeroList[10].i = 0.134130503;
				CPoleZeroList[11].r = -0.880727322; CPoleZeroList[11].i = -0.134130503;
				CPoleZeroList[12].r = -0.864180852; CPoleZeroList[12].i = 0.270471143;
				CPoleZeroList[13].r = -0.864180852; CPoleZeroList[13].i = -0.270471143;
				CPoleZeroList[14].r = -.886133909481; CPoleZeroList[14].i = 0.0;
				break;

		case 16:CPoleZeroList[0].r = -0.49566283; CPoleZeroList[0].i = 1.175497831;
				CPoleZeroList[1].r = -0.49566283; CPoleZeroList[1].i = -1.175497831;
				CPoleZeroList[2].r = -0.628655922; CPoleZeroList[2].i = 0.937582555;
				CPoleZeroList[3].r = -0.628655922; CPoleZeroList[3].i = -0.937582555;
				CPoleZeroList[4].r = -0.716197499; CPoleZeroList[4].i = 0.755105258;
				CPoleZeroList[5].r = -0.716197499; CPoleZeroList[5].i = -0.755105258;
				CPoleZeroList[6].r = -0.778413924; CPoleZeroList[6].i = 0.597652386;
				CPoleZeroList[7].r = -0.778413924; CPoleZeroList[7].i = -0.597652386;
				CPoleZeroList[8].r = -0.82317058; CPoleZeroList[8].i = 0.454263623;
				CPoleZeroList[9].r = -0.82317058; CPoleZeroList[9].i = -0.454263623;
				CPoleZeroList[10].r = -0.854396951; CPoleZeroList[10].i = 0.319427118;
				CPoleZeroList[11].r = -0.854396951; CPoleZeroList[11].i = -0.319427118;
				CPoleZeroList[12].r = -0.883917761; CPoleZeroList[12].i = 0.062962644;
				CPoleZeroList[13].r = -0.883917761; CPoleZeroList[13].i = -0.062962644;
				CPoleZeroList[14].r = -0.874253029; CPoleZeroList[14].i = 0.189784497;
				CPoleZeroList[15].r = -0.874253029; CPoleZeroList[15].i = -0.189784497;

		case 17:CPoleZeroList[0].r = -0.483776337; CPoleZeroList[0].i = 1.190101073;
				CPoleZeroList[1].r = -0.483776337; CPoleZeroList[1].i = -1.190101073;
				CPoleZeroList[2].r = -0.615022582; CPoleZeroList[2].i = 0.959311727;
				CPoleZeroList[3].r = -0.615022582; CPoleZeroList[3].i = -0.959311727;
				CPoleZeroList[4].r = -0.702246206; CPoleZeroList[4].i = 0.782730628;
				CPoleZeroList[5].r = -0.702246206; CPoleZeroList[5].i = -0.782730628;
				CPoleZeroList[6].r = -0.765047166; CPoleZeroList[6].i = 0.630774359;
				CPoleZeroList[7].r = -0.765047166; CPoleZeroList[7].i = -0.630774359;
				CPoleZeroList[8].r = -0.811113093; CPoleZeroList[8].i = 0.492803243;
				CPoleZeroList[9].r = -0.811113093; CPoleZeroList[9].i = -0.492803243;
				CPoleZeroList[10].r = -0.844318848; CPoleZeroList[10].i = 0.363497395;
				CPoleZeroList[11].r = -0.844318848; CPoleZeroList[11].i = -0.363497395;
				CPoleZeroList[12].r = -0.866837892; CPoleZeroList[12].i = 0.239655146;
				CPoleZeroList[13].r = -0.866837892; CPoleZeroList[13].i = -0.239655146;
				CPoleZeroList[14].r = -0.879916951; CPoleZeroList[14].i = 0.119065152;
				CPoleZeroList[15].r = -0.879916951; CPoleZeroList[15].i = -0.119065152;
				CPoleZeroList[16].r = -.884208689342; CPoleZeroList[16].i = 0.0;
				break;
				
	}

	switch(order)
	{
		case 1: CLCRList[0]=2.0;
				CLCRList[1]=1;
				break;


		case 2:	CLCRList[0]= 0.65855195002;
				CLCRList[1]= 3.03696618003;
				CLCRList[2]=1;
				break;
 
		case 3:	CLCRList[0]=0.423099073923;
				CLCRList[1]=1.3168185158;
				CLCRList[2]=3.58973175107;
				CLCRList[3]=1;
				break;

		case 4:	CLCRList[0]=0.316416612215;
				CLCRList[1]=0.946973013323;
				CLCRList[2]=1.66468375556;
				CLCRList[3]=4.00960300678;
				CLCRList[4]=1;
				break;
  
		case 5: CLCRList[0]=0.254266494458;
				CLCRList[1]=0.75529538;
				CLCRList[2]=1.25722360337;
				CLCRList[3]=1.89630176123;
				CLCRList[4]=4.36821552033;
				CLCRList[5]=1;
				break;
  
		case 6:	CLCRList[0]=0.213202131769;
				CLCRList[1]=0.632746396584;
				CLCRList[2]=1.0399548212;
				CLCRList[3]=1.4651620075;
				CLCRList[4]=2.07449252549;
				CLCRList[5]=4.69025847241;
				CLCRList[6]=1;
				break;
  
		case 7:	CLCRList[0]=0.183900907944;
				CLCRList[1]=0.546196541876;
				CLCRList[2]=0.895452300835;
				CLCRList[3]=1.23794834307;
				CLCRList[4]=1.61922140873;
				CLCRList[5]=2.22439812931;
				CLCRList[6]=4.98693190439;
				CLCRList[7]=1;
				break;


		case 8:	CLCRList[0]=0.161872950493;
				CLCRList[1]=0.481306782059;
				CLCRList[2]=0.789453420779;
				CLCRList[3]=1.0855878603;
				CLCRList[4]=1.38483022988;
				CLCRList[5]=1.74281546878;
				CLCRList[6]=2.3574970587;
				CLCRList[7]=5.26433043639;
				CLCRList[8]=1;
				break;
  
		case 9:	CLCRList[0]=0.14467362194;
				CLCRList[1]=0.430638217397;
				CLCRList[2]=0.707304662566;
				CLCRList[3]=0.971883972895;
				CLCRList[4]=1.2290691148;
				CLCRList[5]=1.50037734901;
				CLCRList[6]=1.84810505409;
				CLCRList[7]=2.47956173758;
				CLCRList[8]=5.52622732225;
				CLCRList[9]=1;
				break;


		case 10:CLCRList[0]=0.130852142746;
				CLCRList[1]=0.389876954512;
				CLCRList[2]=0.641330192637;
				CLCRList[3]=0.882000321685;
				CLCRList[4]=1.11255396483;
				CLCRList[5]=1.34188069488;
				CLCRList[6]=1.59606445113;
				CLCRList[7]=1.9417534611;
				CLCRList[8]=2.59373524008;
				CLCRList[9]=5.77518653399;
				CLCRList[10]=1;
				break;
 
		case 11:CLCRList[0]=0.119490536593;
				CLCRList[1]=0.35632351405;
				CLCRList[2]=0.586982081075;
				CLCRList[3]=0.808394797817;
				CLCRList[4]=1.01963472429;
				CLCRList[5]=1.22417418358;
				CLCRList[6]=1.43413465431;
				CLCRList[7]=1.67877220109;
				CLCRList[8]=2.02756820439;
				CLCRList[9]=2.701856504;
				CLCRList[10]=6.01307140698;
				CLCRList[11]=1;

				break;
 
		case 12:CLCRList[0]=0.109978347654;
				CLCRList[1]=0.328191804124;
				CLCRList[2]=0.541338118256;
				CLCRList[3]=0.746660907484;
				CLCRList[4]=0.942649603248;
				CLCRList[5]=1.13029090546;
				CLCRList[6]=1.31534293295;
				CLCRList[7]=1.51236838637;
				CLCRList[8]=1.75273170214;
				CLCRList[9]=2.10780409023;
				CLCRList[10]=2.80507800993;
				CLCRList[11]=6.24130350544;
				CLCRList[12]=1;
				break;
   
		case 13:CLCRList[0]=0.101893212123;
				CLCRList[1]=0.304248145151;
				CLCRList[2]=0.502410995377;
				CLCRList[3]=0.693970025056;
				CLCRList[4]=0.877268142543;
				CLCRList[5]=1.05212843909;
				CLCRList[6]=1.22115816633;
				CLCRList[7]=1.39196294322;
				CLCRList[8]=1.58088044554;
				CLCRList[9]=1.8205959757;
				CLCRList[10]=2.18384238201;
				CLCRList[11]=2.90417138438;
				CLCRList[12]=6.461006518;
				CLCRList[13]=1;
				break;
  
		case 14:CLCRList[0]=0.0949333138363;
				CLCRList[1]=0.283610581192;
				CLCRList[2]=0.468791369715;
				CLCRList[3]=0.648383354879;
				CLCRList[4]=0.820773806452;
				CLCRList[5]=0.985253688132;
				CLCRList[6]=1.14280606243;
				CLCRList[7]=1.29741311892;
				CLCRList[8]=1.45813693598;
				CLCRList[9]=1.64253227566;
				CLCRList[10]=1.88405564594;
				CLCRList[11]=2.25655967645;
				CLCRList[12]=2.99968594826;
				CLCRList[13]=6.6730924263;
				CLCRList[14]=1;
				break;

		case 15:CLCRList[0]=0.0888788842242;
				CLCRList[1]=0.265626062224;
				CLCRList[2]=0.439452142789;
				CLCRList[3]=0.608503717508;
				CLCRList[4]=0.77132990307;
				CLCRList[5]=0.926972498282;
				CLCRList[6]=1.07558300208;
				CLCRList[7]=1.21915250818;
				CLCRList[8]=1.36281852452;
				CLCRList[9]=1.51674241992;
				CLCRList[10]=1.69924519599;
				CLCRList[11]=1.94420461415;
				CLCRList[12]=2.32653439091;
				CLCRList[13]=3.09203439059;
				CLCRList[14]=6.87831645203;
				CLCRList[15]=1;
				break;
 

		case 16:CLCRList[0]=0.0834754759198;
				CLCRList[1]=0.250029272939;
				CLCRList[2]=0.413353704602;
				CLCRList[3]=0.573513923465;
				CLCRList[4]=0.727480942045;
				CLCRList[5]=0.875576542999;
				CLCRList[6]=1.01668486493;
				CLCRList[7]=1.1520944937;
				CLCRList[8]=1.2845350739;
				CLCRList[9]=1.4201300057;
				CLCRList[10]=1.56980903767;
				CLCRList[11]=1.7523174646;
				CLCRList[12]=2.00176256169;
				CLCRList[13]=2.39416493128;
				CLCRList[14]=3.18154086982;
				CLCRList[15]=7.07731398164;
				CLCRList[6]=1;
				break;

		case 17:CLCRList[0]=0.0781535120171;
				CLCRList[1]=0.237618180849;
				CLCRList[2]=0.388428548801;
				CLCRList[3]=0.543983243787;
				CLCRList[4]=0.687265759668;
				CLCRList[5]=0.830384775737;
				CLCRList[6]=0.964069011905;
				CLCRList[7]=1.09337710016;
				CLCRList[8]=1.21771232863;
				CLCRList[9]=1.341517488;
				CLCRList[10]=1.47137389432;
				CLCRList[11]=1.61877261041;
				CLCRList[12]=1.80263120388;
				CLCRList[13]=2.05721255963;
				CLCRList[14]=2.45973846577;
				CLCRList[15]=3.26846909374;
				CLCRList[16]=7.27062647363;
				CLCRList[17]=1;
				break;
	}
	return true;
}

bool TCFantasticFilter::CalculateElipticPoleZeros(void)
{
	return true;
}

///////////////////////////////////////////////////
bool TCFantasticFilter::Calculate(void)
{
	// soft errors

	if(order < 1)				order = 1;
	if(frequency < 0)			frequency = 1.0;
	if(!frequency)				frequency = 1.0;
	if(bandwidth < 0)			bandwidth = 1.0;
	if(!bandwidth)				bandwidth = 1.0;
	if(output_resistance < 0)	output_resistance = 1.0;
	if(!output_resistance)		output_resistance = 1.0;
	if(capacitance < 0)			capacitance = 1.0;
	if(!capacitance)			capacitance = 1.0;

	bool ok = false;

	switch(name_type)
	{
		case E_BUTTERWORTH:			if(CalculateButterworthPoleZeros())	ok = CalculateButterworth(); break;
		case E_CHEBYSHEV:			if(CalculateChebyshevPoleZeros())		ok = CalculateChebyshev(); break;
		case E_BESSEL:				if(CalculateBesselPoleZeros())			ok = CalculateBessel(); break;
		case E_ELIPTIC:				if(CalculateElipticPoleZeros())		ok = CalculateEliptic(); break;
		case E_GAUSSIAN:			if(CalculateGaussianPoleZeros())		ok = CalculateGaussian(); break;
		case E_INVERSE_CHEBYSHEV:	if(CalculateInverseChebyshevPoleZeros())ok = CalculateInverseChebyshev();break;
	}

	if(!ok) return false;

	FormatFileName();

	return true;
}


bool TCFantasticFilter::CalculateButterworth(void)
{
	switch(implementation_type)
	{
		case E_TWO_POLE_OPAMP: return CalculateButterworthOpAmp();
		case E_EQUAL_CR_OPAMP: return CalculateButterworthEqRCOpAmp();
		case E_RCL_LADDERA:return CalculateButterworthLCR();
		case E_RCL_LADDERB:return CalculateButterworthLCR();
		case E_STATE_VARIABLE:return CalculateButterworthStateVariable();
		case E_LEAP_FROG:return CalculateButterworthLeapFrog();
		case E_GYRATOR:return CalculateButterworthGyrator();
		case E_NEGATIVE_RESISTOR:return CalculateButterworthNegativeResistor();
	}

	return false;
}

bool TCFantasticFilter::CalculateChebyshev(void)
{
	switch(implementation_type)
	{
		case E_TWO_POLE_OPAMP: return CalculateChebyshevOpAmp();
		case E_EQUAL_CR_OPAMP: return CalculateChebyshevEqRCOpAmp();
		case E_RCL_LADDERA:return CalculateChebyshevLCR();
		case E_RCL_LADDERB:return CalculateChebyshevLCR();
		case E_STATE_VARIABLE:return CalculateChebyshevStateVariable();
		case E_LEAP_FROG:return CalculateChebyshevLeapFrog();
		case E_GYRATOR:return CalculateChebyshevGyrator();
		case E_NEGATIVE_RESISTOR:return CalculateChebyshevNegativeResistor();
	}

	return false;
}
bool TCFantasticFilter::CalculateBessel(void)
{
	switch(implementation_type)
	{
		case E_TWO_POLE_OPAMP: return CalculateBesselOpAmp();
		case E_EQUAL_CR_OPAMP: return CalculateBesselEqRCOpAmp();
		case E_RCL_LADDERA:return CalculateBesselLCR();
		case E_RCL_LADDERB:return CalculateBesselLCR();
		case E_STATE_VARIABLE:return CalculateBesselStateVariable();
		case E_LEAP_FROG:return CalculateBesselLeapFrog();
		case E_GYRATOR:return CalculateBesselGyrator();
		case E_NEGATIVE_RESISTOR:return CalculateBesselNegativeResistor();
	}
	return false;
}
bool TCFantasticFilter::CalculateEliptic(void)
{
	switch(implementation_type)
	{
		case E_TWO_POLE_OPAMP: return CalculateElipticOpAmp();
		case E_EQUAL_CR_OPAMP: return CalculateElipticEqRCOpAmp();
		case E_RCL_LADDERA:return CalculateElipticLCR();
		case E_RCL_LADDERB:return CalculateElipticLCR();
		case E_STATE_VARIABLE:return CalculateElipticStateVariable();
		case E_LEAP_FROG:return CalculateElipticLeapFrog();
		case E_GYRATOR:return CalculateElipticGyrator();
		case E_NEGATIVE_RESISTOR:return CalculateElipticNegativeResistor();
	}
	return false;
}

bool TCFantasticFilter::CalculateGaussian(void)
{
	switch(implementation_type)
	{
		case E_TWO_POLE_OPAMP: return CalculateGaussianOpAmp();
		case E_EQUAL_CR_OPAMP: return CalculateGaussianEqRCOpAmp();
		case E_RCL_LADDERA:return CalculateGaussianLCR();
		case E_RCL_LADDERB:return CalculateGaussianLCR();
		case E_STATE_VARIABLE:return CalculateGaussianStateVariable();
		case E_LEAP_FROG:return CalculateGaussianLeapFrog();
		case E_GYRATOR:return CalculateGaussianGyrator();
		case E_NEGATIVE_RESISTOR:return CalculateGaussianNegativeResistor();
	}
	return false;
}

bool TCFantasticFilter::CalculateInverseChebyshev(void)
{
	switch(implementation_type)
	{
		case E_TWO_POLE_OPAMP: return CalculateInverseChebyshevOpAmp();
		case E_EQUAL_CR_OPAMP: return CalculateInverseChebyshevEqRCOpAmp();
		case E_RCL_LADDERA:return CalculateInverseChebyshevLCR();
		case E_RCL_LADDERB:return CalculateInverseChebyshevLCR();
		case E_STATE_VARIABLE:return CalculateInverseChebyshevStateVariable();
		case E_LEAP_FROG:return CalculateInverseChebyshevLeapFrog();
		case E_GYRATOR:return CalculateInverseChebyshevGyrator();
		case E_NEGATIVE_RESISTOR:return CalculateInverseChebyshevNegativeResistor();
	}

	return false;
}
////////////

bool TCFantasticFilter::CalculateButterworthLCR(void)
{
	int size = 0;//

	if(frequency_type == E_LOWPASS || frequency_type == E_HIGHPASS)
	{
		size = order + 2;//
	}
	else 
	{
		return false;
	}
	
	if(!size) return false;// extra check

	ComponentList.SetSize(size);

	if(ComponentList.GetSize() != size) return false;

// Input and output terminators
	ComponentList[0].CRefDesignator = "RSOURCE";
	ComponentList[0].value			= output_resistance;

	ComponentList[size -1].CRefDesignator = "RLOAD";
	ComponentList[size -1].value	= output_resistance;//output_resistance;
// Input and output terminators

	double value;
	int number;
	CString RefDes, CText;

// for LP and HP
	for(int p = 1; p < size - 1; p++)
	{
		value = 2*sin((2*p - 1)*1.570796327/order);

		number = (p + 1)/2;

		if(frequency_type == E_HIGHPASS)
		{
			value = 1/value;
		}

		if(implementation_type == E_RCL_LADDERA)
		{
			if(!(p%2))// if even is inductor
			{
				RefDes = "L";

				value = value * output_resistance / 6.283185307 / frequency;
			}
			else // if odd is capacitor
			{
				RefDes = "C";

				value = value / output_resistance / 6.283185307 / frequency;
			}
		}
		else
		{
			if((p%2))// if odd is inductor
			{
				RefDes = "L";

				value = value * output_resistance / 6.283185307 / frequency;
			}
			else // if even is capacitor
			{
				RefDes = "C";

				value = value / output_resistance / 6.283185307 / frequency;
			}
		}

		ComponentList[p].value = value;

		CText.Format("%d", number);

		RefDes = RefDes + CText;

		ComponentList[p].CRefDesignator = RefDes;
	}
// for LP and HP



	return true;
}


bool TCFantasticFilter::CalculateButterworthOpAmp(void)
{
	int size = 0;//

	if(frequency_type == E_LOWPASS || frequency_type == E_HIGHPASS)
	{
		size = 2 * order;//
	}
	else 
	{
		return false;
	}
	
	if(!size) return false;// extra check

	ComponentList.SetSize(size);

	if(ComponentList.GetSize() != size) return false;

	double value, impedance, w2, dtemp;
	int r = 0;
	CString CRefDes, CTemp;
	int count = order/2;


	if(frequency_type == E_HIGHPASS) impedance = capacitance;
	else impedance = output_resistance;

	count = 2 * count;// to ignor the last odd one

	int p;

	for(p = 0; p < count; p++)
	{
		r = 2 * p;

		value = - CPoleZeroList[p].r;

		dtemp = - CPoleZeroList[p].i;

		w2 = value * value + dtemp * dtemp;

		if(!w2)  w2 = 1;// should not happen

		if(frequency_type == E_HIGHPASS) 
		{
			w2		= 1/w2;
			value	= 1/value;
		}

		CTemp = "R";

		if(frequency_type == E_HIGHPASS) CTemp = "C";

		CRefDes.Format("%s%d", CTemp, p +1);

		ComponentList[r].CRefDesignator = CRefDes;
		ComponentList[r].value			= impedance;

		CTemp = "C";

		if(frequency_type == E_HIGHPASS) CTemp = "R";

		CRefDes.Format("%s%d", CTemp, p + 1);

		ComponentList[r + 1].CRefDesignator = CRefDes;

		if(!(p%2)) // if even is 1/value
		{
			value = 1 / value / impedance / 6.283185307 / frequency;
		}
		else
		{
			value = value / impedance / 6.283185307 / frequency / w2;
		}

		ComponentList[r + 1].value	= value;
	}

	if((order%2)) // manual last one if odd
	{
		CTemp = "R";

		if(frequency_type == E_HIGHPASS) CTemp = "C";

		CRefDes.Format("%s%d", CTemp, order);

		ComponentList[size - 2].CRefDesignator	= CRefDes;
		ComponentList[size - 2].value			= impedance;

		CTemp = "C";

		if(frequency_type == E_HIGHPASS) CTemp = "R";

		CRefDes.Format("%s%d", CTemp, order);

		value = - CPoleZeroList[p].r;

		dtemp = - CPoleZeroList[p].i;

		w2 = value * value + dtemp * dtemp;

		if(!w2)  w2 = 1;// should not happen

		if(frequency_type == E_HIGHPASS) 
		{
			w2	= 1/w2;

			value = 1/value;
		}

		ComponentList[size - 1].CRefDesignator = CRefDes;
		ComponentList[size - 1].value			= value / w2 /impedance / 6.283185307 / frequency;
	}

	return true;
}

bool TCFantasticFilter::CalculateButterworthEqRCOpAmp(void)
{
	int size = 0;//

	if(frequency_type == E_LOWPASS || frequency_type == E_HIGHPASS)
	{
		if(!(order%2)) // if even
		{
			size = 3 * order;//
		}
		else
		{
			size = 3*(order - 1) + 2;
		}
	}
	else 
	{
		return false;
	}
	
	if(!size) return false;// extra check

	ComponentList.SetSize(size);

	if(ComponentList.GetSize() != size) return false;

	double value, impedance, w2, dtemp;
	double k2 = 2;//temp

	int r = 0;
	CString CRefDes, CTemp;
	int count = order/2;
		
	int r_counter = 0;
	int c_counter = 0;

	impedance = output_resistance;

	int p = 0;

	for(int p = 0; p < count; p++)
	{
		r = 6 * p;

		value = - CPoleZeroList[2*p + 1].r;

		dtemp = - CPoleZeroList[2*p + 1].i;

		w2 = value * value + dtemp * dtemp;

		w2 = sqrt(w2);

		if(!w2)  w2 = 1;// should not happen

		k2 = 2*(1 - value/w2);

		value = 1 / impedance / 6.283185307 / frequency / w2;

		CTemp = "R";

		r_counter++;
		CRefDes.Format("%s%d", CTemp, r_counter);

		ComponentList[r].CRefDesignator = CRefDes;
		ComponentList[r].value			= output_resistance;

		r_counter++;
		CRefDes.Format("%s%d", CTemp, r_counter);

		ComponentList[r + 1].CRefDesignator = CRefDes;
		ComponentList[r + 1].value			= output_resistance;

		r_counter++;
		CRefDes.Format("%s%d", CTemp, r_counter);

		ComponentList[r + 4].CRefDesignator = CRefDes;
		ComponentList[r + 4].value			= output_resistance;

		r_counter++;
		CRefDes.Format("%s%d", CTemp, r_counter);

		ComponentList[r + 5].CRefDesignator = CRefDes;
		ComponentList[r + 5].value			= output_resistance * k2;

		CTemp = "C";

		c_counter++;
		CRefDes.Format("%s%d", CTemp, c_counter);

		ComponentList[r + 2].CRefDesignator = CRefDes;
		ComponentList[r + 2].value			= value;

		c_counter++;
		CRefDes.Format("%s%d", CTemp, c_counter);

		ComponentList[r + 3].CRefDesignator = CRefDes;
		ComponentList[r + 3].value			= value;
	}

	if((order%2)) // manual last one if odd
	{
		value = - CPoleZeroList[2*p].r;

		w2 = value;

		if(!w2)  w2 = 1;// should not happen

		value = 1 / impedance / 6.283185307 / frequency / w2;

		CTemp = "R";

		r_counter++;
		CRefDes.Format("%s%d", CTemp, r_counter);

		ComponentList[size - 2].CRefDesignator	= CRefDes;
		ComponentList[size - 2].value			= output_resistance;

		CTemp = "C";

		c_counter++;
		CRefDes.Format("%s%d", CTemp, c_counter);

		ComponentList[size - 1].CRefDesignator = CRefDes;
		ComponentList[size - 1].value			= value;
	}

	return true;
}

bool TCFantasticFilter::CalculateButterworthStateVariable(void)
{
	return false;
}
bool TCFantasticFilter::CalculateButterworthLeapFrog(void)
{
	return false;
}
bool TCFantasticFilter::CalculateButterworthGyrator(void)
{
	return false;
}
bool TCFantasticFilter::CalculateButterworthNegativeResistor(void)
{
	return false;
}

/////
bool TCFantasticFilter::CalculateChebyshevLCR(void)
{
	return CalculateBesselLCR();
}
bool TCFantasticFilter::CalculateChebyshevOpAmp(void)
{
	return CalculateButterworthOpAmp();
}
bool TCFantasticFilter::CalculateChebyshevEqRCOpAmp(void)
{
	return CalculateButterworthEqRCOpAmp();
}
bool TCFantasticFilter::CalculateChebyshevStateVariable(void)
{
	return false;
}
bool TCFantasticFilter::CalculateChebyshevLeapFrog(void)
{
	return false;
}
bool TCFantasticFilter::CalculateChebyshevGyrator(void)
{
	return false;
}
bool TCFantasticFilter::CalculateChebyshevNegativeResistor(void)
{
	return false;
}

bool TCFantasticFilter::CalculateBesselLCR(void)
{
	int size = 0;//

	if(frequency_type == E_LOWPASS || frequency_type == E_HIGHPASS)
	{
		size = order + 2;//
	}
	else 
	{
		return false;
	}
	
	if(!size) return false;// extra check

	ComponentList.SetSize(size);

	if(ComponentList.GetSize() != size) return false;

	if(!(CLCRList.GetSize() < size)) return false;

// Input and output terminators
	ComponentList[0].CRefDesignator = "RSOURCE";
	ComponentList[0].value			= CLCRList[size -2] * output_resistance;

	ComponentList[size -1].CRefDesignator = "RLOAD";
	ComponentList[size -1].value	= output_resistance;//output_resistance;
// Input and output terminators

	double value;
	int number;
	CString RefDes, CText;

// for LP and HP
	for(int p = 1; p < size - 1; p++)
	{
		value = CLCRList[p - 1];

		number = (p + 1)/2;

		if(frequency_type == E_HIGHPASS)
		{
			value = 1/value;
		}

		if(implementation_type == E_RCL_LADDERA)
		{
			if(!(p%2))// if even is inductor
			{
				RefDes = "L";

				value = value * output_resistance / 6.283185307 / frequency;
			}
			else // if odd is capacitor
			{
				RefDes = "C";

				value = value / output_resistance / 6.283185307 / frequency;
			}
		}
		else
		{
			if((p%2))// if odd is inductor
			{
				RefDes = "L";

				value = value * output_resistance / 6.283185307 / frequency;
			}
			else // if even is capacitor
			{
				RefDes = "C";

				value = value / output_resistance / 6.283185307 / frequency;
			}
		}

		ComponentList[p].value = value;

		CText.Format("%d", number);

		RefDes = RefDes + CText;

		ComponentList[p].CRefDesignator = RefDes;
	}
// for LP and HP

	return true;
}
bool TCFantasticFilter::CalculateBesselOpAmp(void)
{
	return CalculateButterworthOpAmp();
}
bool TCFantasticFilter::CalculateBesselEqRCOpAmp(void)
{
	return CalculateButterworthEqRCOpAmp();
}
bool TCFantasticFilter::CalculateBesselStateVariable(void)
{
	return false;
}
bool TCFantasticFilter::CalculateBesselLeapFrog(void)
{
	return false;
}
bool TCFantasticFilter::CalculateBesselGyrator(void)
{
	return false;
}
bool TCFantasticFilter::CalculateBesselNegativeResistor(void)
{
	return false;
}

bool TCFantasticFilter::CalculateElipticLCR(void)
{
	return false;
}
bool TCFantasticFilter::CalculateElipticOpAmp(void)
{
	return false;
}
bool TCFantasticFilter::CalculateElipticEqRCOpAmp(void)
{
	return false;
}
bool TCFantasticFilter::CalculateElipticStateVariable(void)
{
	return false;
}
bool TCFantasticFilter::CalculateElipticLeapFrog(void)
{
	return false;
}
bool TCFantasticFilter::CalculateElipticGyrator(void)
{
	return false;
}
bool TCFantasticFilter::CalculateElipticNegativeResistor(void)
{
	return false;
}

bool TCFantasticFilter::CalculateGaussianLCR(void)
{
	return CalculateBesselLCR();
}
bool TCFantasticFilter::CalculateGaussianOpAmp(void)
{
	return CalculateButterworthOpAmp();
}
bool TCFantasticFilter::CalculateGaussianEqRCOpAmp(void)
{
	return CalculateButterworthEqRCOpAmp();
}
bool TCFantasticFilter::CalculateGaussianStateVariable(void)
{
	return false;
}
bool TCFantasticFilter::CalculateGaussianLeapFrog(void)
{
	return false;
}
bool TCFantasticFilter::CalculateGaussianGyrator(void)
{
	return false;
}
bool TCFantasticFilter::CalculateGaussianNegativeResistor(void)
{
	return false;
}

bool TCFantasticFilter::CalculateInverseChebyshevLCR(void)
{
	return false;
}
bool TCFantasticFilter::CalculateInverseChebyshevOpAmp(void)
{
	return false;
}
bool TCFantasticFilter::CalculateInverseChebyshevEqRCOpAmp(void)
{
	return false;
}
bool TCFantasticFilter::CalculateInverseChebyshevStateVariable(void)
{
	return false;
}
bool TCFantasticFilter::CalculateInverseChebyshevLeapFrog(void)
{
	return false;
}
bool TCFantasticFilter::CalculateInverseChebyshevGyrator(void)
{
	return false;
}
bool TCFantasticFilter::CalculateInverseChebyshevNegativeResistor(void)
{
	return false;
}





