
#ifndef _TCFantasticFilter_H
#define _TCFantasticFilter_H

#include <afxtempl.h>


enum TE_FANTASTIC_FILTER_FREQ_TYPE
{
	E_LOWPASS,
	E_BANDPASS,
	E_BANDREJECT,
	E_HIGHPASS,
	E_NOTCH,

	E_FANTASTIC_FILTER_FREQ_TYPE_MAX
};

enum TE_FANTASTIC_FILTER_IMPLEMENTATION_TYPE
{
	E_TWO_POLE_OPAMP,
	E_EQUAL_CR_OPAMP,
	E_RCL_LADDERA,
	E_RCL_LADDERB,
	E_STATE_VARIABLE,
	E_LEAP_FROG,
	E_GYRATOR,
	E_NEGATIVE_RESISTOR,

	TE_FANTASTIC_FILTER_IMPLEMENTATION_TYPE_MAX
};

enum TE_FANTASTIC_FILTER_NAME_TYPE
{
	E_BUTTERWORTH,
	E_CHEBYSHEV,
	E_BESSEL,
	E_ELIPTIC,
	E_GAUSSIAN,
	E_INVERSE_CHEBYSHEV,


	TE_FANTASTIC_FILTER_NAME_TYPE_MAX
};

enum TE_FANTASTIC_FILTER_RIPPLE
{
	E_POINT_01DB_RIPPLE,
	E_POINT_1DB_RIPPLE,
	E_POINT_5DB_RIPPLE,
	E_1DB_RIPPLE,
	E_3DB_RIPPLE,

	TE_FANTASTIC_FILTER_RIPPLE_MAX
};

class TCComplexPoleZero : public CObject
{
	public:	TCComplexPoleZero(void);
			TCComplexPoleZero(TCComplexPoleZero &CComplexPoleZero);
			~TCComplexPoleZero(void);

			double r;
			double i;
			CString CType;

			void operator = (TCComplexPoleZero &CComplexPoleZero);
			TCComplexPoleZero operator * (TCComplexPoleZero &CComplexPoleZero);
			TCComplexPoleZero operator - (TCComplexPoleZero &CComplexPoleZero);
			TCComplexPoleZero operator + (TCComplexPoleZero &CComplexPoleZero);
			TCComplexPoleZero Sine(void);
			TCComplexPoleZero Cos(void);
	
			void Serialize(CArchive& CArchiveFile);

			DECLARE_SERIAL(TCComplexPoleZero)

};

class TCFantasticFilterData : public CObject
{
	public:	TCFantasticFilterData(void);
			TCFantasticFilterData(TCFantasticFilterData &CFantasticFilterData);
			~TCFantasticFilterData(void);

			CString CRefDesignator;
			double	value;

			void operator = (TCFantasticFilterData &CFantasticFilterData);
	
			void Serialize(CArchive& CArchiveFile);

			DECLARE_SERIAL(TCFantasticFilterData)

};

class TCFantasticFilter : public CObject
{
	public:	TCFantasticFilter(void);
			TCFantasticFilter(TCFantasticFilter &CFantasticFilter);
			~TCFantasticFilter(void);


			int		frequency_type;
			int		implementation_type;
			int		name_type;
			double	bandwidth;
			double	frequency;
			double  capacitance;
			double	output_resistance;
			double	ripple;
			int		order;
			int		ripple_index;
			CString	CFilterRipple;
			CString CFilterFileName;
			CString	CTransferFunctionFileName;// if used

			CArray <TCFantasticFilterData, TCFantasticFilterData&> ComponentList;
			CArray <TCComplexPoleZero, TCComplexPoleZero> CPoleZeroList;
			CArray <double, double> CLCRList;

			CArray <CString, CString> CFrequencyTypeList;
			CArray <CString, CString> CImplementationTypeList;
			CArray <CString, CString> CFilterNameType;
			CArray <CString, CString> CFilterRippleList;
			CArray <double, double>	  CRippleTable;


			void operator = (TCFantasticFilter &CFantasticFilter);
	
			void Serialize(CArchive& CArchiveFile);

			bool Calculate(void);
			bool CalculateButterworth(void);
			bool CalculateChebyshev(void);
			bool CalculateBessel(void);
			bool CalculateEliptic(void);
			bool CalculateGaussian(void);
			bool CalculateInverseChebyshev(void);

			bool CalculateButterworthPoleZeros(void);
			bool CalculateChebyshevPoleZeros(void);
			bool CalculateBesselPoleZeros(void);
			bool CalculateElipticPoleZeros(void);
			bool CalculateGaussianPoleZeros(void);
			bool CalculateInverseChebyshevPoleZeros(void);

			bool CalculateButterworthLCR(void);
			bool CalculateButterworthOpAmp(void);
			bool CalculateButterworthEqRCOpAmp(void);
			bool CalculateButterworthStateVariable(void);
			bool CalculateButterworthLeapFrog(void);
			bool CalculateButterworthGyrator(void);
			bool CalculateButterworthNegativeResistor(void);

			bool CalculateChebyshevLCR(void);
			bool CalculateChebyshevOpAmp(void);
			bool CalculateChebyshevEqRCOpAmp(void);
			bool CalculateChebyshevStateVariable(void);
			bool CalculateChebyshevLeapFrog(void);
			bool CalculateChebyshevGyrator(void);
			bool CalculateChebyshevNegativeResistor(void);

			bool CalculateBesselLCR(void);
			bool CalculateBesselOpAmp(void);
			bool CalculateBesselEqRCOpAmp(void);
			bool CalculateBesselStateVariable(void);
			bool CalculateBesselLeapFrog(void);
			bool CalculateBesselGyrator(void);
			bool CalculateBesselNegativeResistor(void);

			bool CalculateElipticLCR(void);
			bool CalculateElipticOpAmp(void);
			bool CalculateElipticEqRCOpAmp(void);
			bool CalculateElipticStateVariable(void);
			bool CalculateElipticLeapFrog(void);
			bool CalculateElipticGyrator(void);
			bool CalculateElipticNegativeResistor(void);

			bool CalculateGaussianLCR(void);
			bool CalculateGaussianOpAmp(void);
			bool CalculateGaussianEqRCOpAmp(void);
			bool CalculateGaussianStateVariable(void);
			bool CalculateGaussianLeapFrog(void);
			bool CalculateGaussianGyrator(void);
			bool CalculateGaussianNegativeResistor(void);

			bool CalculateInverseChebyshevLCR(void);
			bool CalculateInverseChebyshevOpAmp(void);
			bool CalculateInverseChebyshevEqRCOpAmp(void);
			bool CalculateInverseChebyshevStateVariable(void);
			bool CalculateInverseChebyshevLeapFrog(void);
			bool CalculateInverseChebyshevGyrator(void);
			bool CalculateInverseChebyshevNegativeResistor(void);

			CString FormatFileName(void);

			bool Load(CString CFileName);
			bool Save(CString CFileName);

			DECLARE_SERIAL(TCFantasticFilter)

};

#endif