// TCFantasticFilterPropertyPages.cpp : implementation file
//

#include "stdafx.h"
#include "math.h"
#include "resource.h"
#include "TCMasterFantasticFilterPropertySheet.h"
#include "TCFantasticFilterPropertyPages.h"
#include "TCElectronicFormulars.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

IMPLEMENT_DYNCREATE(TCFantasticFilterPropertyPage1, CPropertyPage)
IMPLEMENT_DYNCREATE(TCFantasticFilterPropertyPage2, CPropertyPage)
IMPLEMENT_DYNCREATE(TCFantasticFilterPropertyPage3, CPropertyPage)

extern int	g_last_active_fantastic_filter_property_page;

void AFXAPI DDX_MKSValue(CDataExchange* pDX, int nIDC, double& data);
CString FloatToMKSString(double data);

/////////////////////////////////////////////////////////////////////////////
// TCFantasticFilterPropertyPage1 property page

TCFantasticFilterPropertyPage1::TCFantasticFilterPropertyPage1() : CPropertyPage(TCFantasticFilterPropertyPage1::IDD)
{
	//{{AFX_DATA_INIT(TCFantasticFilterPropertyPage1)
	m_order = 1;
	m_frequency_type = 0;
	m_implementation_type = 0;
	m_name_type = 0;
	CMComboStringRipple = _T("");
	//}}AFX_DATA_INIT

	m_bandwidth			= 1;
	m_frequency			= 0.159154943;
	m_order				= 1;
	m_capacitance		= 1;
	m_output_resistance = 1;
	m_ripple			= 1;

	PCParent	= NULL;
	button		= E_FILTER_CANCEL;
}

TCFantasticFilterPropertyPage1::~TCFantasticFilterPropertyPage1()
{
}

void TCFantasticFilterPropertyPage1::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(TCFantasticFilterPropertyPage1)
	DDX_Control(pDX, IDC_COMBO_RIPPLE, CMComboRipple);
	DDX_Control(pDX, IDC_EDIT_INPUT_RESISTANCE2, CMEditResistance);
	DDX_Control(pDX, IDC_EDIT_INPUT_RESISTANCE, CMEditCapacitance);
	DDX_Control(pDX, IDC_EDIT_BANDWIDTH, CMEditBandwidth);
	DDX_Control(pDX, IDC_EDIT_FILTER_RIPPLE, CMEditFilterRipple);
	DDX_Control(pDX, IDC_LIST_POLE_ZERO, CMListPoleZero);
	DDX_Control(pDX, IDC_LIST_COMPONENTS, CMComponentList);
	DDX_MKSValue(pDX, IDC_EDIT_BANDWIDTH, m_bandwidth);
	DDX_MKSValue(pDX, IDC_EDIT_CENTER_FREQUENCY, m_frequency);
	DDX_Text(pDX, IDC_EDIT_FILTER_ORDER, m_order);
	DDX_Radio(pDX, IDC_RADIO_FREQUENCY_TYPE, m_frequency_type);
	DDX_Radio(pDX, IDC_RADIO_IMPLEMENTATION, m_implementation_type);
	DDX_Radio(pDX, IDC_RADIO_FILTER_NAME, m_name_type);
	DDX_MKSValue(pDX, IDC_EDIT_INPUT_RESISTANCE, m_capacitance);
	DDX_MKSValue(pDX, IDC_EDIT_INPUT_RESISTANCE2, m_output_resistance);
	DDX_MKSValue(pDX, IDC_EDIT_FILTER_RIPPLE, m_ripple);
	DDX_CBString(pDX, IDC_COMBO_RIPPLE, CMComboStringRipple);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(TCFantasticFilterPropertyPage1, CPropertyPage)
	//{{AFX_MSG_MAP(TCFantasticFilterPropertyPage1)
	ON_BN_CLICKED(IDC_BUTTON_CREATE_FILTER, OnButtonCreateFilter)
	ON_BN_CLICKED(IDC_BUTTON_PLACE_FILTER, OnButtonPlaceFilter)
	ON_BN_CLICKED(IDC_BUTTON_EDIT_FILTER, OnButtonEditFilter)
	ON_BN_CLICKED(IDC_RADIO_IMPLEMENTATION, OnRadioImplementation)
	ON_BN_CLICKED(IDC_RADIO_IMPLEMENTATION2, OnRadioImplementation2)
	ON_BN_CLICKED(IDC_RADIO_IMPLEMENTATION3, OnRadioImplementation3)
	ON_BN_CLICKED(IDC_RADIO_IMPLEMENTATION4, OnRadioImplementation4)
	ON_BN_CLICKED(IDC_RADIO_IMPLEMENTATION5, OnRadioImplementation5)
	ON_BN_CLICKED(IDC_RADIO_IMPLEMENTATION6, OnRadioImplementation6)
	ON_BN_CLICKED(IDC_RADIO_IMPLEMENTATION7, OnRadioImplementation7)
	ON_BN_CLICKED(IDC_RADIO_IMPLEMENTATION8, OnRadioImplementation8)
	ON_BN_CLICKED(IDC_RADIO_FILTER_NAME, OnRadioFilterName)
	ON_BN_CLICKED(IDC_RADIO_FILTER_NAME2, OnRadioFilterName2)
	ON_BN_CLICKED(IDC_RADIO_FILTER_NAME3, OnRadioFilterName3)
	ON_BN_CLICKED(IDC_RADIO_FILTER_NAME4, OnRadioFilterName4)
	ON_BN_CLICKED(IDC_RADIO_FILTER_NAME5, OnRadioFilterName5)
	ON_BN_CLICKED(IDC_RADIO_FILTER_NAME6, OnRadioFilterName6)
	ON_BN_CLICKED(IDC_RADIO_FREQUENCY_TYPE, OnRadioFrequencyType)
	ON_BN_CLICKED(IDC_RADIO_FREQUENCY_TYPE2, OnRadioFrequencyType2)
	ON_BN_CLICKED(IDC_RADIO_FREQUENCY_TYPE3, OnRadioFrequencyType3)
	ON_BN_CLICKED(IDC_RADIO_FREQUENCY_TYPE4, OnRadioFrequencyType4)
	ON_BN_CLICKED(IDC_RADIO_FREQUENCY_TYPE5, OnRadioFrequencyType5)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// TCFantasticFilterPropertyPage2 property page

TCFantasticFilterPropertyPage2::TCFantasticFilterPropertyPage2() : CPropertyPage(TCFantasticFilterPropertyPage2::IDD)
{
	//{{AFX_DATA_INIT(TCFantasticFilterPropertyPage2)
	m_capacitor_unknown = -1;
	m_inductor_unknown = -1;
	m_inductor_slew_unknown = -1;
	m_paralle_unknown = -1;
	m_series_unknown = -1;
	m_capacitor_slew_unknown = -1;
	//}}AFX_DATA_INIT

	m_capacitor_slew_capacitance = 1.0;
	m_capacitor_slew_current = 1.0;
	m_capacitor_slew_frequency = 1.0;
	m_capacitor_slew_time = 1.0;
	m_capacitor_slew_voltage = 1.0;
	m_capacitor_capacitance = 1.0;
	m_capacitor_frequency = 1.0;
	m_capacitor_impedance = 1.0;
	m_inductor_frequency = 1.0;
	m_inductor_impedance = 1.0;
	m_inductor_inductance = 1.0;
	m_inductor_slew_current = 1.0;
	m_inductor_slew_frequency = 1.0;
	m_inductor_slew_inductance = 1.0;
	m_inductor_slew_time = 1.0;
	m_inductor_slew_voltage = 1.0;
	m_parallel_capacitance = 1.0;
	m_parallel_frequency = 1.0;
	m_parallel_impedance = 1.0;
	m_parallel_inductance = 1.0;
	m_parallel_resistance = 1.0;
	m_parallel_resonance_frequency = 1.0;
	m_series_capacitance = 1.0;
	m_series_frequency = 1.0;
	m_series_impedance = 1.0;
	m_series_inductance = 1.0;
	m_series_resistance = 1.0;
	m_series_resonance_frequency = 1.0;
	m_parallel_q = 1.0;
	m_series_q = 1.0;
	m_series_bandwidth = 1.0;
	m_parallel_bandwidth = 1.0;
}

TCFantasticFilterPropertyPage2::~TCFantasticFilterPropertyPage2()
{
}

void TCFantasticFilterPropertyPage2::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(TCFantasticFilterPropertyPage2)
	DDX_Control(pDX, IDC_EDIT_SERIES_LCR_RESONANCE_FREQ, CMEditSeriesFo);
	DDX_Control(pDX, IDC_EDIT_SERIES_LCR_RESISTANCE, CMEditSeriesResistance);
	DDX_Control(pDX, IDC_EDIT_SERIES_LCR_Q, CMEditSeriesQ);
	DDX_Control(pDX, IDC_EDIT_SERIES_LCR_INDUCTANCE, CMEditSeriesInductance);
	DDX_Control(pDX, IDC_EDIT_SERIES_LCR_IMPEDANCE, CMEditSeriesImpedance);
	DDX_Control(pDX, IDC_EDIT_SERIES_LCR_FREQUENCY, CMEditSeriesFrequency);
	DDX_Control(pDX, IDC_EDIT_SERIES_LCR_CAPACITANCE, CMEditSeriesCapacitance);
	DDX_Control(pDX, IDC_EDIT_SERIES_LCR_BANDWIDTH, CMEditSeriesBandwidth);
	DDX_Control(pDX, IDC_EDIT_PARALLEL_LCR_RESONANCE_FREQ, CMEditParallelFO);
	DDX_Control(pDX, IDC_EDIT_PARALLEL_LCR_RESISTANCE, CMEditParallelResistance);
	DDX_Control(pDX, IDC_EDIT_PARALLEL_LCR_Q, CMEditParallelQ);
	DDX_Control(pDX, IDC_EDIT_PARALLEL_LCR_INDUCTANCE, CMEditParallelInductance);
	DDX_Control(pDX, IDC_EDIT_PARALLEL_LCR_IMPEDANCE, CMEditParallelImpedance);
	DDX_Control(pDX, IDC_EDIT_PARALLEL_LCR_FREQUENCY, CMEditParallelFrequency);
	DDX_Control(pDX, IDC_EDIT_PARALLEL_LCR_CAPACITANCE, CMEditParallelCapacitor);
	DDX_Control(pDX, IDC_EDIT_PARALLEL_LCR_BANDWIDTH, CMEditParallelBandwidth);
	DDX_Control(pDX, IDC_EDIT_INDUCTOR_SLEW_VOLTAGE, CMEditInductorSlewVoltage);
	DDX_Control(pDX, IDC_EDIT_INDUCTOR_SLEW_TIME, CMEditInductorSlewTime);
	DDX_Control(pDX, IDC_EDIT_INDUCTOR_SLEW_INDUCTANCE, CMEditInductorSlewInductance);
	DDX_Control(pDX, IDC_EDIT_INDUCTOR_SLEW_FREQUENCY, CMEditInductorSlewFrequency);
	DDX_Control(pDX, IDC_EDIT_INDUCTOR_SLEW_CURRENT, CMEditInductorSlewCurrent);
	DDX_Control(pDX, IDC_EDIT_CAPACITOR_SLEW_VOLTAGE, CMEditCapacitorSlewVoltage);
	DDX_Control(pDX, IDC_EDIT_CAPACITOR_SLEW_TIME, CMEditCapacitorSlewTime);
	DDX_Control(pDX, IDC_EDIT_CAPACITOR_SLEW_FREQUENCY, CMEditCapacitorSlewFrequency);
	DDX_Control(pDX, IDC_EDIT_CAPACITOR_SLEW_CURRENT, CMEditCapacitorSlewCurrent);
	DDX_Control(pDX, IDC_EDIT_CAPACITOR_SLEW_CAPACITANCE, CMEditCapacitorSlewCapactiance);
	DDX_Control(pDX, IDC_EDIT_INDUCTOR_INDUCTANCE, CMEditInductorInductance);
	DDX_Control(pDX, IDC_EDIT_INDUCTOR_IMPEDANCE, CMEditInductorImpedance);
	DDX_Control(pDX, IDC_EDIT_INDUCTOR_FREQUENCY, CMEditInductorFrequency);
	DDX_Control(pDX, IDC_EDIT_CAPAITOR_IMPEDANCE, CMEditCapacitorImpedance);
	DDX_Control(pDX, IDC_EDIT_CAPAITOR_FREQUENCY, CMEditCapacitorFrequency);
	DDX_Control(pDX, IDC_EDIT_CAPAITOR_CAPACITANCE, CMEditCapacitorCapacitance);
	DDX_MKSValue(pDX, IDC_EDIT_CAPACITOR_SLEW_CAPACITANCE, m_capacitor_slew_capacitance);
	DDX_MKSValue(pDX, IDC_EDIT_CAPACITOR_SLEW_CURRENT, m_capacitor_slew_current);
	DDX_MKSValue(pDX, IDC_EDIT_CAPACITOR_SLEW_FREQUENCY, m_capacitor_slew_frequency);
	DDX_MKSValue(pDX, IDC_EDIT_CAPACITOR_SLEW_TIME, m_capacitor_slew_time);
	DDX_MKSValue(pDX, IDC_EDIT_CAPACITOR_SLEW_VOLTAGE, m_capacitor_slew_voltage);
	DDX_MKSValue(pDX, IDC_EDIT_CAPAITOR_CAPACITANCE, m_capacitor_capacitance);
	DDX_MKSValue(pDX, IDC_EDIT_CAPAITOR_FREQUENCY, m_capacitor_frequency);
	DDX_MKSValue(pDX, IDC_EDIT_CAPAITOR_IMPEDANCE, m_capacitor_impedance);
	DDX_MKSValue(pDX, IDC_EDIT_INDUCTOR_FREQUENCY, m_inductor_frequency);
	DDX_MKSValue(pDX, IDC_EDIT_INDUCTOR_IMPEDANCE, m_inductor_impedance);
	DDX_MKSValue(pDX, IDC_EDIT_INDUCTOR_INDUCTANCE, m_inductor_inductance);
	DDX_MKSValue(pDX, IDC_EDIT_INDUCTOR_SLEW_CURRENT, m_inductor_slew_current);
	DDX_MKSValue(pDX, IDC_EDIT_INDUCTOR_SLEW_FREQUENCY, m_inductor_slew_frequency);
	DDX_MKSValue(pDX, IDC_EDIT_INDUCTOR_SLEW_INDUCTANCE, m_inductor_slew_inductance);
	DDX_MKSValue(pDX, IDC_EDIT_INDUCTOR_SLEW_TIME, m_inductor_slew_time);
	DDX_MKSValue(pDX, IDC_EDIT_INDUCTOR_SLEW_VOLTAGE, m_inductor_slew_voltage);
	DDX_MKSValue(pDX, IDC_EDIT_PARALLEL_LCR_CAPACITANCE, m_parallel_capacitance);
	DDX_MKSValue(pDX, IDC_EDIT_PARALLEL_LCR_FREQUENCY, m_parallel_frequency);
	DDX_MKSValue(pDX, IDC_EDIT_PARALLEL_LCR_IMPEDANCE, m_parallel_impedance);
	DDX_MKSValue(pDX, IDC_EDIT_PARALLEL_LCR_INDUCTANCE, m_parallel_inductance);
	DDX_MKSValue(pDX, IDC_EDIT_PARALLEL_LCR_RESISTANCE, m_parallel_resistance);
	DDX_MKSValue(pDX, IDC_EDIT_PARALLEL_LCR_RESONANCE_FREQ, m_parallel_resonance_frequency);
	DDX_MKSValue(pDX, IDC_EDIT_SERIES_LCR_CAPACITANCE, m_series_capacitance);
	DDX_MKSValue(pDX, IDC_EDIT_SERIES_LCR_FREQUENCY, m_series_frequency);
	DDX_MKSValue(pDX, IDC_EDIT_SERIES_LCR_IMPEDANCE, m_series_impedance);
	DDX_MKSValue(pDX, IDC_EDIT_SERIES_LCR_INDUCTANCE, m_series_inductance);
	DDX_MKSValue(pDX, IDC_EDIT_SERIES_LCR_RESISTANCE, m_series_resistance);
	DDX_MKSValue(pDX, IDC_EDIT_SERIES_LCR_RESONANCE_FREQ, m_series_resonance_frequency);
	DDX_MKSValue(pDX, IDC_EDIT_PARALLEL_LCR_Q, m_parallel_q);
	DDX_MKSValue(pDX, IDC_EDIT_SERIES_LCR_Q, m_series_q);
	DDX_MKSValue(pDX, IDC_EDIT_SERIES_LCR_BANDWIDTH, m_series_bandwidth);
	DDX_MKSValue(pDX, IDC_EDIT_PARALLEL_LCR_BANDWIDTH, m_parallel_bandwidth);
	DDX_Radio(pDX, IDC_RADIO_CAPAITOR_CAPACITANCE, m_capacitor_unknown);
	DDX_Radio(pDX, IDC_RADIO_INDUCTOR_CAPACITANCE, m_inductor_unknown);
	DDX_Radio(pDX, IDC_RADIO_INDUCTOR_SLEW_IND, m_inductor_slew_unknown);
	DDX_Radio(pDX, IDC_RADIO_PARALLEL_LCR_INDUCTANCE, m_paralle_unknown);
	DDX_Radio(pDX, IDC_RADIO_SERIES_LCR_INDUCTANCE, m_series_unknown);
	DDX_Radio(pDX, IDC_RADIO_CAPACITOR_SLEW_CAPACITANCE, m_capacitor_slew_unknown);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(TCFantasticFilterPropertyPage2, CPropertyPage)
	//{{AFX_MSG_MAP(TCFantasticFilterPropertyPage2)
	ON_EN_KILLFOCUS(IDC_EDIT_CAPAITOR_CAPACITANCE, OnKillfocusEditCapaitorCapacitance)
	ON_EN_KILLFOCUS(IDC_EDIT_CAPAITOR_FREQUENCY, OnKillfocusEditCapaitorFrequency)
	ON_EN_KILLFOCUS(IDC_EDIT_CAPAITOR_IMPEDANCE, OnKillfocusEditCapaitorImpedance)
	ON_EN_KILLFOCUS(IDC_EDIT_INDUCTOR_FREQUENCY, OnKillfocusEditInductorFrequency)
	ON_EN_KILLFOCUS(IDC_EDIT_INDUCTOR_IMPEDANCE, OnKillfocusEditInductorImpedance)
	ON_EN_KILLFOCUS(IDC_EDIT_INDUCTOR_INDUCTANCE, OnKillfocusEditInductorInductance)
	ON_EN_KILLFOCUS(IDC_EDIT_CAPACITOR_SLEW_CAPACITANCE, OnKillfocusEditCapacitorSlewCapacitance)
	ON_EN_KILLFOCUS(IDC_EDIT_CAPACITOR_SLEW_CURRENT, OnKillfocusEditCapacitorSlewCurrent)
	ON_EN_KILLFOCUS(IDC_EDIT_CAPACITOR_SLEW_FREQUENCY, OnKillfocusEditCapacitorSlewFrequency)
	ON_EN_KILLFOCUS(IDC_EDIT_CAPACITOR_SLEW_TIME, OnKillfocusEditCapacitorSlewTime)
	ON_EN_KILLFOCUS(IDC_EDIT_CAPACITOR_SLEW_VOLTAGE, OnKillfocusEditCapacitorSlewVoltage)
	ON_EN_KILLFOCUS(IDC_EDIT_INDUCTOR_SLEW_CURRENT, OnKillfocusEditInductorSlewCurrent)
	ON_EN_KILLFOCUS(IDC_EDIT_INDUCTOR_SLEW_FREQUENCY, OnKillfocusEditInductorSlewFrequency)
	ON_EN_KILLFOCUS(IDC_EDIT_INDUCTOR_SLEW_INDUCTANCE, OnKillfocusEditInductorSlewInductance)
	ON_EN_KILLFOCUS(IDC_EDIT_INDUCTOR_SLEW_TIME, OnKillfocusEditInductorSlewTime)
	ON_EN_KILLFOCUS(IDC_EDIT_INDUCTOR_SLEW_VOLTAGE, OnKillfocusEditInductorSlewVoltage)
	ON_EN_KILLFOCUS(IDC_EDIT_SERIES_LCR_BANDWIDTH, OnKillfocusEditSeriesLcrBandwidth)
	ON_EN_KILLFOCUS(IDC_EDIT_SERIES_LCR_CAPACITANCE, OnKillfocusEditSeriesLcrCapacitance)
	ON_EN_KILLFOCUS(IDC_EDIT_SERIES_LCR_FREQUENCY, OnKillfocusEditSeriesLcrFrequency)
	ON_EN_KILLFOCUS(IDC_EDIT_SERIES_LCR_Q, OnKillfocusEditSeriesLcrQ)
	ON_EN_KILLFOCUS(IDC_EDIT_SERIES_LCR_RESISTANCE, OnKillfocusEditSeriesLcrResistance)
	ON_EN_KILLFOCUS(IDC_EDIT_SERIES_LCR_RESONANCE_FREQ, OnKillfocusEditSeriesLcrResonanceFreq)
	ON_EN_KILLFOCUS(IDC_EDIT_PARALLEL_LCR_BANDWIDTH, OnKillfocusEditParallelLcrBandwidth)
	ON_EN_KILLFOCUS(IDC_EDIT_PARALLEL_LCR_CAPACITANCE, OnKillfocusEditParallelLcrCapacitance)
	ON_EN_KILLFOCUS(IDC_EDIT_PARALLEL_LCR_FREQUENCY, OnKillfocusEditParallelLcrFrequency)
	ON_EN_KILLFOCUS(IDC_EDIT_PARALLEL_LCR_IMPEDANCE, OnKillfocusEditParallelLcrImpedance)
	ON_EN_KILLFOCUS(IDC_EDIT_PARALLEL_LCR_INDUCTANCE, OnKillfocusEditParallelLcrInductance)
	ON_EN_KILLFOCUS(IDC_EDIT_PARALLEL_LCR_Q, OnKillfocusEditParallelLcrQ)
	ON_EN_KILLFOCUS(IDC_EDIT_PARALLEL_LCR_RESISTANCE, OnKillfocusEditParallelLcrResistance)
	ON_EN_KILLFOCUS(IDC_EDIT_PARALLEL_LCR_RESONANCE_FREQ, OnKillfocusEditParallelLcrResonanceFreq)
	ON_EN_KILLFOCUS(IDC_EDIT_SERIES_LCR_INDUCTANCE, OnKillfocusEditSeriesLcrInductance)
	ON_EN_KILLFOCUS(IDC_EDIT_SERIES_LCR_IMPEDANCE, OnKillfocusEditSeriesLcrImpedance)
	ON_BN_CLICKED(IDC_RADIO_CAPACITOR_SLEW_CURRENT, OnRadioCapacitorSlewCurrent)
	ON_BN_CLICKED(IDC_RADIO_CAPACITOR_SLEW_F, OnRadioCapacitorSlewF)
	ON_BN_CLICKED(IDC_EDIT_CAPACITOR_SLEW_CAPACITANCE, OnRadioCapacitorSlewInd)
	ON_BN_CLICKED(IDC_RADIO_CAPACITOR_SLEW_TIME, OnRadioCapacitorSlewTime)
	ON_BN_CLICKED(IDC_RADIO_CAPACITOR_SLEW_VOLT, OnRadioCapacitorSlewVolt)
	ON_BN_CLICKED(IDC_RADIO_CAPAITOR_CAPACITANCE, OnRadioCapaitorCapacitance)
	ON_BN_CLICKED(IDC_RADIO_CAPAITOR_FREQUENCY, OnRadioCapaitorFrequency)
	ON_BN_CLICKED(IDC_RADIO_CAPAITOR_IMPEDANCE, OnRadioCapaitorImpedance)
	ON_BN_CLICKED(IDC_RADIO_INDUCTOR_CAPACITANCE, OnRadioInductorCapacitance)
	ON_BN_CLICKED(IDC_RADIO_INDUCTOR_FREQUENCY, OnRadioInductorFrequency)
	ON_BN_CLICKED(IDC_RADIO_INDUCTOR_IMPEDANCE, OnRadioInductorImpedance)
	ON_BN_CLICKED(IDC_RADIO_INDUCTOR_SLEW_CURRENT, OnRadioInductorSlewCurrent)
	ON_BN_CLICKED(IDC_RADIO_INDUCTOR_SLEW_F, OnRadioInductorSlewF)
	ON_BN_CLICKED(IDC_RADIO_INDUCTOR_SLEW_IND, OnRadioInductorSlewInd)
	ON_BN_CLICKED(IDC_RADIO_INDUCTOR_SLEW_TIME, OnRadioInductorSlewTime)
	ON_BN_CLICKED(IDC_RADIO_INDUCTOR_SLEW_VOLT, OnRadioInductorSlewVolt)
	ON_BN_CLICKED(IDC_RADIO_PARALLEL_LCR_CAPACITANCE, OnRadioParallelLcrCapacitance)
	ON_BN_CLICKED(IDC_RADIO_PARALLEL_LCR_FREQUENCY, OnRadioParallelLcrFrequency)
	ON_BN_CLICKED(IDC_RADIO_PARALLEL_LCR_IMPEDANCE, OnRadioParallelLcrImpedance)
	ON_BN_CLICKED(IDC_RADIO_PARALLEL_LCR_INDUCTANCE, OnRadioParallelLcrInductance)
	ON_BN_CLICKED(IDC_RADIO_PARALLEL_LCR_RESISTANCE, OnRadioParallelLcrResistance)
	ON_BN_CLICKED(IDC_RADIO_SERIES_LCR_CAPACITANCE, OnRadioSeriesLcrCapacitance)
	ON_BN_CLICKED(IDC_RADIO_SERIES_LCR_FREQUENCY, OnRadioSeriesLcrFrequency)
	ON_BN_CLICKED(IDC_RADIO_SERIES_LCR_IMPEDANCE, OnRadioSeriesLcrImpedance)
	ON_BN_CLICKED(IDC_RADIO_SERIES_LCR_INDUCTANCE, OnRadioSeriesLcrInductance)
	ON_BN_CLICKED(IDC_RADIO_SERIES_LCR_RESISTANCE, OnRadioSeriesLcrResistance)
	ON_BN_CLICKED(IDC_RADIO_SERIES_LCR_Q, OnRadioSeriesLcrQ)
	ON_BN_CLICKED(IDC_RADIO_SERIES_LCR_FO, OnRadioSeriesLcrFo)
	ON_BN_CLICKED(IDC_RADIO_SERIES_LCR_BANDWIDTH, OnRadioSeriesLcrBandwidth)
	ON_BN_CLICKED(IDC_RADIO_PARALLEL_LCR_Q, OnRadioParallelLcrQ)
	ON_BN_CLICKED(IDC_RADIO_PARALLEL_LCR_FO, OnRadioParallelLcrFo)
	ON_BN_CLICKED(IDC_RADIO_PARALLEL_LCR_BANDWIDTH, OnRadioParallelLcrBandwidth)
	ON_BN_CLICKED(IDC_RADIO_CAPACITOR_SLEW_CAPACITANCE, OnRadioCapacitorSlewCapacitance)
	ON_BN_CLICKED(IDC_BUTTON_UPDATE, OnButtonUpdate)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

////////////////////////////////////////////////


TCFantasticFilterPropertyPage3::TCFantasticFilterPropertyPage3() : CPropertyPage(TCFantasticFilterPropertyPage3::IDD)
{
	//{{AFX_DATA_INIT(TCFantasticFilterPropertyPage3)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT

	PCElectronicFormulars = NULL;
}

TCFantasticFilterPropertyPage3::~TCFantasticFilterPropertyPage3()
{
}

void TCFantasticFilterPropertyPage3::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(TCFantasticFilterPropertyPage3)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(TCFantasticFilterPropertyPage3, CPropertyPage)
	//{{AFX_MSG_MAP(TCFantasticFilterPropertyPage3)
	ON_BN_CLICKED(IDC_BUTTON_UPDATE, OnButtonUpdate)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


////////////////////////////////////////////////
////////////////////////////////////////////////

/*
TCFantasticFilterPropertyPage4::TCFantasticFilterPropertyPage4() : CPropertyPage(TCFantasticFilterPropertyPage4::IDD)
{
	//{{AFX_DATA_INIT(TCFantasticFilterPropertyPage4)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
}

TCFantasticFilterPropertyPage4::~TCFantasticFilterPropertyPage4()
{
}

void TCFantasticFilterPropertyPage4::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(TCFantasticFilterPropertyPage4)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(TCFantasticFilterPropertyPage4, CPropertyPage)
	//{{AFX_MSG_MAP(TCFantasticFilterPropertyPage4)
		// NOTE: the ClassWizard will add message map macros here
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()
*/


////////////////////////////////////////////////

////////////////////////////////////////////////
INT_PTR TCFantasticFilterPropertyPage1::DoModal() 
{
	
	CPropertyPage::DoModal();

	SetDisplay();

	return true;
}

BOOL TCFantasticFilterPropertyPage1::OnKillActive() 
{
	GetDisplay();

	return CPropertyPage::OnKillActive();
}

BOOL TCFantasticFilterPropertyPage2::OnKillActive() 
{
	GetDisplay();

	return CPropertyPage::OnKillActive();
}

BOOL TCFantasticFilterPropertyPage1::OnSetActive() 
{
	g_last_active_fantastic_filter_property_page = 0;

	SetDisplay();

	return CPropertyPage::OnSetActive();
}

void TCFantasticFilterPropertyPage1::GetDisplay(void)
{
	UpdateData(true);

	CFantasticFilter.bandwidth				= m_bandwidth;
	CFantasticFilter.frequency				= m_frequency;
	CFantasticFilter.order					= m_order;
	CFantasticFilter.frequency_type			= m_frequency_type;
	CFantasticFilter.implementation_type	= m_implementation_type;
	CFantasticFilter.name_type				= m_name_type;
	CFantasticFilter.capacitance			= m_capacitance;
	CFantasticFilter.output_resistance		= m_output_resistance;
	CFantasticFilter.ripple					= m_ripple;
	CFantasticFilter.CFilterRipple			= CMComboStringRipple;

	CFantasticFilter.ripple_index			= CMComboRipple.GetCurSel();

	if(CFantasticFilter.ripple_index < 0) CFantasticFilter.ripple_index = 0;
}

void TCFantasticFilterPropertyPage1::SetDisplay(void)
{
	m_bandwidth				= CFantasticFilter.bandwidth;
	m_frequency				= CFantasticFilter.frequency;
	m_order					= CFantasticFilter.order;
	m_frequency_type		= CFantasticFilter.frequency_type ;
	m_implementation_type	= CFantasticFilter.implementation_type;
	m_name_type				= CFantasticFilter.name_type;
	m_capacitance			= CFantasticFilter.capacitance;
	m_output_resistance		= CFantasticFilter.output_resistance;
	m_ripple				= CFantasticFilter.ripple;
	CMComboStringRipple		= CFantasticFilter.CFilterRipple;

	int count = CFantasticFilter.ComponentList.GetSize();

	CMComponentList.ResetContent();
	CMListPoleZero.ResetContent();
	CMComboRipple.ResetContent();

	CString CRefDesignator;
	CString	CValue;
	CString CTemp;
	CString CR;
	CString CI;
	double temp;

	int p;

	for(p = 0; p < count; p++)
	{
		CRefDesignator = CFantasticFilter.ComponentList[p].CRefDesignator;

		CValue = FloatToMKSString(CFantasticFilter.ComponentList[p].value);

		CRefDesignator = CRefDesignator + '=' + CValue;

		CMComponentList.InsertString(-1, CRefDesignator);
	}

	count = CFantasticFilter.CPoleZeroList.GetSize();

	for(p = 0; p < count; p++)
	{
		CTemp = CFantasticFilter.CPoleZeroList[p].CType;

		CR = FloatToMKSString(CFantasticFilter.CPoleZeroList[p].r);

		temp = CFantasticFilter.CPoleZeroList[p].i;

		CI = FloatToMKSString(fabs(temp));

		if(temp < 0)
		{
			CTemp.Format("%s %d = %s - i%s", CTemp, p + 1, CR, CI);
		}
		else
		{
			CTemp.Format("%s %d = %s + i%s", CTemp, p + 1, CR, CI);
		}

		CMListPoleZero.InsertString(-1, CTemp);
	}

	count = CFantasticFilter.CFilterRippleList.GetSize();

	for(p = 0; p < count; p++)
	{
		CMComboRipple.InsertString(-1, CFantasticFilter.CFilterRippleList[p]);
	}

	CMComboRipple.SelectString(-1, CFantasticFilter.CFilterRipple);

	SetButtons();

	UpdateData(false);
}

void TCFantasticFilterPropertyPage1::SetButtons(void)
{
	CMEditResistance.SetReadOnly(true);
	CMEditCapacitance.SetReadOnly(true);
	CMEditBandwidth.SetReadOnly(true);
	CMEditFilterRipple.SetReadOnly(true);
	CMComboRipple.EnableWindow(false);

	if(m_implementation_type == E_RCL_LADDERA || m_implementation_type == E_RCL_LADDERB)
	{
		if(m_name_type == E_CHEBYSHEV || m_name_type == E_ELIPTIC || m_name_type == E_INVERSE_CHEBYSHEV)

			CMComboRipple.EnableWindow(true);
	}

	if(m_frequency_type == E_LOWPASS)
	{
		CMEditResistance.SetReadOnly(false);
	}

	if(m_frequency_type == E_BANDPASS || m_frequency == E_BANDREJECT)
	{
		CMEditBandwidth.SetReadOnly(false);
	}

	if(m_frequency_type == E_BANDREJECT)
	{
		CMEditBandwidth.SetReadOnly(false);
	}

	if(m_frequency_type == E_HIGHPASS)
	{
		if(m_implementation_type != E_RCL_LADDERA && m_implementation_type != E_RCL_LADDERB)

			if(m_implementation_type == E_TWO_POLE_OPAMP)
				CMEditCapacitance.SetReadOnly(false);

		if(m_implementation_type == E_RCL_LADDERA || m_implementation_type == E_RCL_LADDERB ||
			m_implementation_type == E_EQUAL_CR_OPAMP)
			
			CMEditResistance.SetReadOnly(false);
	}

	if(m_frequency_type == E_NOTCH)
	{
		;
	}

	if(m_name_type == E_CHEBYSHEV || m_name_type == E_ELIPTIC || m_name_type == E_INVERSE_CHEBYSHEV)
	{
		if(m_implementation_type != E_RCL_LADDERA && m_implementation_type != E_RCL_LADDERB)
			CMEditFilterRipple.SetReadOnly(false);
	}
}


void TCFantasticFilterPropertyPage1::OnButtonCreateFilter() 
{
	GetDisplay();

	CFantasticFilter.Calculate();

	SetDisplay();	
}

void TCFantasticFilterPropertyPage1::OnButtonPlaceFilter() 
{
	if(!PCParent) return;
	
	button = E_PLACE_FILTER;

	PCParent->PressButton(PSBTN_OK);
}

void TCFantasticFilterPropertyPage1::OnButtonEditFilter() 
{
	if(!PCParent) return;

	button = E_EDIT_FILTER;

	PCParent->PressButton(PSBTN_OK);
}

void TCFantasticFilterPropertyPage1::OnRadioImplementation() 
{
	GetDisplay();

	SetDisplay();	
}

void TCFantasticFilterPropertyPage1::OnRadioImplementation2() 
{
	GetDisplay();

	SetDisplay();
}

void TCFantasticFilterPropertyPage1::OnRadioImplementation3() 
{
	GetDisplay();

	SetDisplay();	
}

void TCFantasticFilterPropertyPage1::OnRadioImplementation4() 
{
	GetDisplay();

	SetDisplay();	
}

void TCFantasticFilterPropertyPage1::OnRadioImplementation5() 
{
	GetDisplay();

	SetDisplay();	
}

void TCFantasticFilterPropertyPage1::OnRadioImplementation6() 
{
	GetDisplay();

	SetDisplay();	
}

void TCFantasticFilterPropertyPage1::OnRadioImplementation7() 
{
	GetDisplay();

	SetDisplay();	
}

void TCFantasticFilterPropertyPage1::OnRadioImplementation8() 
{
	GetDisplay();

	SetDisplay();	
}

void TCFantasticFilterPropertyPage1::OnRadioFilterName() 
{
	GetDisplay();

	SetDisplay();	
}

void TCFantasticFilterPropertyPage1::OnRadioFilterName2() 
{
	GetDisplay();

	SetDisplay();	
}

void TCFantasticFilterPropertyPage1::OnRadioFilterName3() 
{
	GetDisplay();

	SetDisplay();	
}

void TCFantasticFilterPropertyPage1::OnRadioFilterName4() 
{
	GetDisplay();

	SetDisplay();	
}

void TCFantasticFilterPropertyPage1::OnRadioFilterName5() 
{
	GetDisplay();

	SetDisplay();	
}

void TCFantasticFilterPropertyPage1::OnRadioFilterName6() 
{
	GetDisplay();

	SetDisplay();	
}

void TCFantasticFilterPropertyPage1::OnRadioFrequencyType() 
{
	GetDisplay();

	SetDisplay();	
}

void TCFantasticFilterPropertyPage1::OnRadioFrequencyType2() 
{
	GetDisplay();

	SetDisplay();	
}

void TCFantasticFilterPropertyPage1::OnRadioFrequencyType3() 
{
	GetDisplay();

	SetDisplay();	
}

void TCFantasticFilterPropertyPage1::OnRadioFrequencyType4() 
{
	GetDisplay();

	SetDisplay();	
}

void TCFantasticFilterPropertyPage1::OnRadioFrequencyType5() 
{
	GetDisplay();

	SetDisplay();	
}

////////////////////////////
void TCFantasticFilterPropertyPage2::GetDisplay(void)
{
	UpdateData(true);

	CElectronicFormulars.CCapacitor.capacitance = m_capacitor_capacitance;
	CElectronicFormulars.CCapacitor.frequency	= m_capacitor_frequency;
	CElectronicFormulars.CCapacitor.impedance	= m_capacitor_impedance;

	CElectronicFormulars.CInductor.frequency	= m_inductor_frequency;
	CElectronicFormulars.CInductor.impedance	= m_inductor_impedance;
	CElectronicFormulars.CInductor.inductance	= m_inductor_inductance;

	CElectronicFormulars.CInductorSlew.current	= m_inductor_slew_current;
	CElectronicFormulars.CInductorSlew.frequency =	m_inductor_slew_frequency;
	CElectronicFormulars.CInductorSlew.inductance =	m_inductor_slew_inductance;
	CElectronicFormulars.CInductorSlew.time		= m_inductor_slew_time;
	CElectronicFormulars.CInductorSlew.voltage	= m_inductor_slew_voltage;

	CElectronicFormulars.CCapacitorSlew.capacitance = m_capacitor_slew_capacitance;
	CElectronicFormulars.CCapacitorSlew.current		= m_capacitor_slew_current;
	CElectronicFormulars.CCapacitorSlew.frequency	= m_capacitor_slew_frequency;
	CElectronicFormulars.CCapacitorSlew.time		= m_capacitor_slew_time;
	CElectronicFormulars.CCapacitorSlew.voltage		= m_capacitor_slew_voltage;

	CElectronicFormulars.CParallelLCR.capacitance	= m_parallel_capacitance;
	CElectronicFormulars.CParallelLCR.frequency		= m_parallel_frequency;
	CElectronicFormulars.CParallelLCR.impedance		= m_parallel_impedance;
	CElectronicFormulars.CParallelLCR.inductance	= m_parallel_inductance;
	CElectronicFormulars.CParallelLCR.resistance	= m_parallel_resistance;
	CElectronicFormulars.CParallelLCR.fo			= m_parallel_resonance_frequency;
	CElectronicFormulars.CParallelLCR.q				= m_parallel_q;
	CElectronicFormulars.CParallelLCR.bandwidth		= m_parallel_bandwidth;


	CElectronicFormulars.CSeriesLCR.capacitance	= m_series_capacitance;
	CElectronicFormulars.CSeriesLCR.frequency	= m_series_frequency;
	CElectronicFormulars.CSeriesLCR.impedance	= m_series_impedance;
	CElectronicFormulars.CSeriesLCR.inductance	= m_series_inductance;
	CElectronicFormulars.CSeriesLCR.resistance	= m_series_resistance;
	CElectronicFormulars.CSeriesLCR.fo			= m_series_resonance_frequency;
	CElectronicFormulars.CSeriesLCR.q			= m_series_q;
	CElectronicFormulars.CSeriesLCR.bandwidth	= m_series_bandwidth;

	CElectronicFormulars.CCapacitor.unknown		= m_capacitor_unknown;
	CElectronicFormulars.CInductor.unknown		= m_inductor_unknown;
	CElectronicFormulars.CInductorSlew.unknown	= m_inductor_slew_unknown;
	CElectronicFormulars.CCapacitorSlew.unknown = m_capacitor_slew_unknown;
	CElectronicFormulars.CParallelLCR.unknown	= m_paralle_unknown;
	CElectronicFormulars.CSeriesLCR.unknown		= m_series_unknown;
}

void TCFantasticFilterPropertyPage2::SetDisplay(void)
{
	m_capacitor_capacitance = CElectronicFormulars.CCapacitor.capacitance;
	m_capacitor_frequency	= CElectronicFormulars.CCapacitor.frequency;
	m_capacitor_impedance	= CElectronicFormulars.CCapacitor.impedance;

	m_inductor_frequency	= CElectronicFormulars.CInductor.frequency;
	m_inductor_impedance	= CElectronicFormulars.CInductor.impedance;
	m_inductor_inductance	= CElectronicFormulars.CInductor.inductance;

	m_inductor_slew_current		= CElectronicFormulars.CInductorSlew.current;
	m_inductor_slew_frequency	= CElectronicFormulars.CInductorSlew.frequency;
	m_inductor_slew_inductance	= CElectronicFormulars.CInductorSlew.inductance;
	m_inductor_slew_time		= CElectronicFormulars.CInductorSlew.time;
	m_inductor_slew_voltage		= CElectronicFormulars.CInductorSlew.voltage;

	m_capacitor_slew_capacitance= CElectronicFormulars.CCapacitorSlew.capacitance;
	m_capacitor_slew_current	= CElectronicFormulars.CCapacitorSlew.current;
	m_capacitor_slew_frequency	= CElectronicFormulars.CCapacitorSlew.frequency;
	m_capacitor_slew_time		= CElectronicFormulars.CCapacitorSlew.time;
	m_capacitor_slew_voltage	= CElectronicFormulars.CCapacitorSlew.voltage;

	m_parallel_capacitance			= CElectronicFormulars.CParallelLCR.capacitance;
	m_parallel_frequency			= CElectronicFormulars.CParallelLCR.frequency;
	m_parallel_impedance			= CElectronicFormulars.CParallelLCR.impedance;
	m_parallel_inductance			= CElectronicFormulars.CParallelLCR.inductance;
	m_parallel_resistance			= CElectronicFormulars.CParallelLCR.resistance;
	m_parallel_resonance_frequency	= CElectronicFormulars.CParallelLCR.fo;
	m_parallel_q					= CElectronicFormulars.CParallelLCR.q;
	m_parallel_bandwidth			= CElectronicFormulars.CParallelLCR.bandwidth;

	m_series_capacitance		= CElectronicFormulars.CSeriesLCR.capacitance;
	m_series_frequency			= CElectronicFormulars.CSeriesLCR.frequency;
	m_series_impedance			= CElectronicFormulars.CSeriesLCR.impedance;
	m_series_inductance			= CElectronicFormulars.CSeriesLCR.inductance;
	m_series_resistance			= CElectronicFormulars.CSeriesLCR.resistance;
	m_series_resonance_frequency= CElectronicFormulars.CSeriesLCR.fo;
	m_series_q					= CElectronicFormulars.CSeriesLCR.q;
	m_series_bandwidth			= CElectronicFormulars.CSeriesLCR.bandwidth;

	m_capacitor_unknown		= CElectronicFormulars.CCapacitor.unknown;
	m_inductor_unknown		= CElectronicFormulars.CInductor.unknown;
	m_inductor_slew_unknown	= CElectronicFormulars.CInductorSlew.unknown;
	m_capacitor_slew_unknown= CElectronicFormulars.CCapacitorSlew.unknown;
	m_paralle_unknown 		= CElectronicFormulars.CParallelLCR.unknown;
	m_series_unknown		= CElectronicFormulars.CSeriesLCR.unknown;

	UpdateData(false);

	SetEnables();
}

void TCFantasticFilterPropertyPage2::SetEnables(void)
{
	UpdateData(true);

	CMEditSeriesFo.SetReadOnly(false);
	CMEditSeriesResistance.SetReadOnly(false);
	CMEditSeriesInductance.SetReadOnly(false);
	CMEditSeriesImpedance.SetReadOnly();
	CMEditSeriesFrequency.SetReadOnly(false);
	CMEditSeriesCapacitance.SetReadOnly(false);
	CMEditSeriesBandwidth.SetReadOnly();
	CMEditSeriesQ.SetReadOnly();

	if(m_series_unknown == 0) CMEditSeriesInductance.SetReadOnly();
	else if(m_series_unknown == 1) CMEditSeriesCapacitance.SetReadOnly();
	else if(m_series_unknown == 2) CMEditSeriesResistance.SetReadOnly();
	else if(m_series_unknown == 3) CMEditSeriesFrequency.SetReadOnly();
	else if(m_series_unknown == 4) 
	{
		CMEditSeriesImpedance.SetReadOnly();
		CMEditSeriesFo.SetReadOnly();
	}
	else 
	{
		CMEditSeriesImpedance.SetReadOnly();
		CMEditSeriesFo.SetReadOnly();
	}


	CMEditParallelFO.SetReadOnly(false);
	CMEditParallelResistance.SetReadOnly(false);
	CMEditParallelInductance.SetReadOnly(false);
	CMEditParallelImpedance.SetReadOnly();
	CMEditParallelFrequency.SetReadOnly(false);
	CMEditParallelCapacitor.SetReadOnly(false);
	CMEditParallelBandwidth.SetReadOnly();
	CMEditParallelQ.SetReadOnly();

	if(m_paralle_unknown == 0) CMEditParallelInductance.SetReadOnly();
	else if(m_paralle_unknown == 1) CMEditParallelCapacitor.SetReadOnly();
	else if(m_paralle_unknown == 2) CMEditParallelResistance.SetReadOnly();
	else if(m_paralle_unknown == 3) CMEditParallelFrequency.SetReadOnly();
	else if(m_paralle_unknown == 4) 
	{
		CMEditParallelImpedance.SetReadOnly();
		CMEditParallelFO.SetReadOnly();
	}
	else 
	{
		CMEditParallelImpedance.SetReadOnly();
		CMEditParallelFO.SetReadOnly();
	}
 

	CMEditInductorSlewVoltage.SetReadOnly(false);
	CMEditInductorSlewTime.SetReadOnly(false);
	CMEditInductorSlewInductance.SetReadOnly(false);
	CMEditInductorSlewFrequency.SetReadOnly(false);
	CMEditInductorSlewCurrent.SetReadOnly(false);

	if(m_inductor_slew_unknown == 0) CMEditInductorSlewInductance.SetReadOnly();
	else if(m_inductor_slew_unknown == 1) 
	{
		CMEditInductorSlewTime.SetReadOnly();
		CMEditInductorSlewFrequency.SetReadOnly();
	}
	else if(m_inductor_slew_unknown == 2) 
	{
		CMEditInductorSlewFrequency.SetReadOnly();
		CMEditInductorSlewTime.SetReadOnly();
	}
	else if(m_inductor_slew_unknown == 3) CMEditInductorSlewVoltage.SetReadOnly();
	else CMEditInductorSlewCurrent.SetReadOnly();


	CMEditCapacitorSlewVoltage.SetReadOnly(false);
	CMEditCapacitorSlewTime.SetReadOnly(false);
	CMEditCapacitorSlewFrequency.SetReadOnly(false);
	CMEditCapacitorSlewCurrent.SetReadOnly(false);
	CMEditCapacitorSlewCapactiance.SetReadOnly(false);

	if(m_capacitor_slew_unknown == 0) CMEditCapacitorSlewCapactiance.SetReadOnly();
	else if(m_capacitor_slew_unknown == 1) 
	{
		CMEditCapacitorSlewTime.SetReadOnly();
		CMEditCapacitorSlewFrequency.SetReadOnly();
	}
	else if(m_capacitor_slew_unknown == 2) 
	{
		CMEditCapacitorSlewTime.SetReadOnly();
		CMEditCapacitorSlewFrequency.SetReadOnly();
	}
	else if(m_capacitor_slew_unknown == 3) CMEditCapacitorSlewVoltage.SetReadOnly();
	else CMEditCapacitorSlewCurrent.SetReadOnly();

	CMEditCapacitorCapacitance.SetReadOnly(false);
	CMEditCapacitorFrequency.SetReadOnly(false);
	CMEditCapacitorImpedance.SetReadOnly(false);

	if(m_capacitor_unknown == 0) CMEditCapacitorCapacitance.SetReadOnly();
	else if (m_capacitor_unknown == 1)CMEditCapacitorFrequency.SetReadOnly();
	else CMEditCapacitorImpedance.SetReadOnly();

	CMEditInductorInductance.SetReadOnly(false);
	CMEditInductorFrequency.SetReadOnly(false);
	CMEditInductorImpedance.SetReadOnly(false);

	if(m_inductor_unknown == 0) CMEditInductorInductance.SetReadOnly();
	else if (m_inductor_unknown == 1)CMEditInductorFrequency.SetReadOnly();
	else CMEditInductorImpedance.SetReadOnly();
	
}

BOOL TCFantasticFilterPropertyPage2::OnSetActive() 
{	
	g_last_active_fantastic_filter_property_page = 1;

	return CPropertyPage::OnSetActive();
}

BOOL TCFantasticFilterPropertyPage2::OnInitDialog() 
{
	CPropertyPage::OnInitDialog();
	
	SetDisplay();
	
	return TRUE;  
}

void TCFantasticFilterPropertyPage2::OnKillfocusEditCapaitorCapacitance() 
{
	GetDisplay();

	CElectronicFormulars.CCapacitor.Calculate();

	SetDisplay();
}

void TCFantasticFilterPropertyPage2::OnKillfocusEditCapaitorFrequency() 
{
	GetDisplay();

	CElectronicFormulars.CCapacitor.Calculate();

	SetDisplay();
}

void TCFantasticFilterPropertyPage2::OnKillfocusEditCapaitorImpedance() 
{
	GetDisplay();

	CElectronicFormulars.CCapacitor.Calculate();

	SetDisplay();
}

void TCFantasticFilterPropertyPage2::OnKillfocusEditInductorFrequency() 
{
	GetDisplay();

	CElectronicFormulars.CInductor.Calculate();

	SetDisplay();
}

void TCFantasticFilterPropertyPage2::OnKillfocusEditInductorInductance() 
{
	GetDisplay();

	CElectronicFormulars.CInductor.Calculate();

	SetDisplay();
}

void TCFantasticFilterPropertyPage2::OnKillfocusEditInductorImpedance() 
{
	GetDisplay();

	CElectronicFormulars.CInductor.Calculate();

	SetDisplay();
}


void TCFantasticFilterPropertyPage2::OnKillfocusEditCapacitorSlewCapacitance() 
{
	GetDisplay();

	CElectronicFormulars.CCapacitorSlew.Calculate();

	SetDisplay();
}

void TCFantasticFilterPropertyPage2::OnKillfocusEditCapacitorSlewCurrent() 
{
	GetDisplay();

	CElectronicFormulars.CCapacitorSlew.Calculate();

	SetDisplay();
}

void TCFantasticFilterPropertyPage2::OnKillfocusEditCapacitorSlewFrequency() 
{
	GetDisplay();

	CElectronicFormulars.CCapacitorSlew.FrequencyToTime();
	CElectronicFormulars.CCapacitorSlew.Calculate();

	SetDisplay();
}

void TCFantasticFilterPropertyPage2::OnKillfocusEditCapacitorSlewTime() 
{
	GetDisplay();

	CElectronicFormulars.CCapacitorSlew.TimeToFrequency();
	CElectronicFormulars.CCapacitorSlew.Calculate();

	SetDisplay();
}

void TCFantasticFilterPropertyPage2::OnKillfocusEditCapacitorSlewVoltage() 
{
	GetDisplay();

	CElectronicFormulars.CCapacitorSlew.Calculate();

	SetDisplay();
}

void TCFantasticFilterPropertyPage2::OnKillfocusEditInductorSlewCurrent() 
{
	GetDisplay();

	CElectronicFormulars.CInductorSlew.Calculate();;

	SetDisplay();
}

void TCFantasticFilterPropertyPage2::OnKillfocusEditInductorSlewFrequency() 
{
	GetDisplay();

	CElectronicFormulars.CInductorSlew.FrequencyToTime();
	CElectronicFormulars.CInductorSlew.Calculate();

	SetDisplay();
}

void TCFantasticFilterPropertyPage2::OnKillfocusEditInductorSlewInductance() 
{
	GetDisplay();

	CElectronicFormulars.CInductorSlew.Calculate();

	SetDisplay();
}

void TCFantasticFilterPropertyPage2::OnKillfocusEditInductorSlewTime() 
{
	GetDisplay();

	CElectronicFormulars.CInductorSlew.TimeToFrequency();
	CElectronicFormulars.CInductorSlew.Calculate();

	SetDisplay();
}

void TCFantasticFilterPropertyPage2::OnKillfocusEditInductorSlewVoltage() 
{
	GetDisplay();

	CElectronicFormulars.CInductorSlew.Calculate();

	SetDisplay();
}

void TCFantasticFilterPropertyPage2::OnKillfocusEditSeriesLcrBandwidth() 
{
	GetDisplay();

	CElectronicFormulars.CSeriesLCR.Calculate();

	SetDisplay();
}

void TCFantasticFilterPropertyPage2::OnKillfocusEditSeriesLcrCapacitance() 
{
	GetDisplay();

	CElectronicFormulars.CSeriesLCR.Calculate();

	SetDisplay();
}

void TCFantasticFilterPropertyPage2::OnKillfocusEditSeriesLcrInductance() 
{
	GetDisplay();

	CElectronicFormulars.CSeriesLCR.Calculate();

	SetDisplay();
}

void TCFantasticFilterPropertyPage2::OnKillfocusEditSeriesLcrImpedance() 
{
	GetDisplay();

	CElectronicFormulars.CSeriesLCR.Calculate();

	SetDisplay();
}

void TCFantasticFilterPropertyPage2::OnKillfocusEditSeriesLcrFrequency() 
{
	GetDisplay();

	CElectronicFormulars.CSeriesLCR.Calculate();

	SetDisplay();
}

void TCFantasticFilterPropertyPage2::OnKillfocusEditSeriesLcrQ() 
{
	GetDisplay();

	CElectronicFormulars.CSeriesLCR.Calculate();

	SetDisplay();
}

void TCFantasticFilterPropertyPage2::OnKillfocusEditSeriesLcrResistance() 
{
	GetDisplay();

	CElectronicFormulars.CSeriesLCR.Calculate();

	SetDisplay();
}

void TCFantasticFilterPropertyPage2::OnKillfocusEditSeriesLcrResonanceFreq() 
{
	GetDisplay();

	CElectronicFormulars.CSeriesLCR.Calculate();

	SetDisplay();
}

void TCFantasticFilterPropertyPage2::OnKillfocusEditParallelLcrBandwidth() 
{
	GetDisplay();

	CElectronicFormulars.CParallelLCR.Calculate();

	SetDisplay();
}

void TCFantasticFilterPropertyPage2::OnKillfocusEditParallelLcrCapacitance() 
{
	GetDisplay();

	CElectronicFormulars.CParallelLCR.Calculate();

	SetDisplay();
}

void TCFantasticFilterPropertyPage2::OnKillfocusEditParallelLcrFrequency() 
{
	GetDisplay();

	CElectronicFormulars.CParallelLCR.Calculate();

	SetDisplay();
}

void TCFantasticFilterPropertyPage2::OnKillfocusEditParallelLcrImpedance() 
{
	GetDisplay();

	CElectronicFormulars.CParallelLCR.Calculate();

	SetDisplay();
}

void TCFantasticFilterPropertyPage2::OnKillfocusEditParallelLcrInductance() 
{
	GetDisplay();

	CElectronicFormulars.CParallelLCR.Calculate();

	SetDisplay();
}

void TCFantasticFilterPropertyPage2::OnKillfocusEditParallelLcrQ() 
{
	GetDisplay();

	CElectronicFormulars.CParallelLCR.Calculate();

	SetDisplay();
}

void TCFantasticFilterPropertyPage2::OnKillfocusEditParallelLcrResistance() 
{
	GetDisplay();

	CElectronicFormulars.CParallelLCR.Calculate();

	SetDisplay();
}

void TCFantasticFilterPropertyPage2::OnKillfocusEditParallelLcrResonanceFreq() 
{
	GetDisplay();

	CElectronicFormulars.CParallelLCR.Calculate();

	SetDisplay();
}


void TCFantasticFilterPropertyPage2::OnRadioCapacitorSlewCurrent() 
{
	SetEnables();	
}

void TCFantasticFilterPropertyPage2::OnRadioCapacitorSlewF() 
{
	SetEnables();		
}

void TCFantasticFilterPropertyPage2::OnRadioCapacitorSlewInd() 
{
	SetEnables();		
}

void TCFantasticFilterPropertyPage2::OnRadioCapacitorSlewTime() 
{
	SetEnables();		
}

void TCFantasticFilterPropertyPage2::OnRadioCapacitorSlewVolt() 
{
	SetEnables();		
}

void TCFantasticFilterPropertyPage2::OnRadioCapaitorCapacitance() 
{
	SetEnables();		
}

void TCFantasticFilterPropertyPage2::OnRadioCapaitorFrequency() 
{
	SetEnables();		
}

void TCFantasticFilterPropertyPage2::OnRadioCapaitorImpedance() 
{
	SetEnables();		
}

void TCFantasticFilterPropertyPage2::OnRadioInductorCapacitance() 
{
	SetEnables();		
}

void TCFantasticFilterPropertyPage2::OnRadioInductorFrequency() 
{
	SetEnables();		
}

void TCFantasticFilterPropertyPage2::OnRadioInductorImpedance() 
{
	SetEnables();		
}

void TCFantasticFilterPropertyPage2::OnRadioInductorSlewCurrent() 
{
	SetEnables();		
}

void TCFantasticFilterPropertyPage2::OnRadioInductorSlewF() 
{
	SetEnables();		
}

void TCFantasticFilterPropertyPage2::OnRadioInductorSlewInd() 
{
	SetEnables();		
}

void TCFantasticFilterPropertyPage2::OnRadioInductorSlewTime() 
{
	SetEnables();		
}

void TCFantasticFilterPropertyPage2::OnRadioInductorSlewVolt() 
{
	SetEnables();		
}

void TCFantasticFilterPropertyPage2::OnRadioParallelLcrCapacitance() 
{
	SetEnables();		
}

void TCFantasticFilterPropertyPage2::OnRadioParallelLcrFrequency() 
{
	SetEnables();		
}

void TCFantasticFilterPropertyPage2::OnRadioParallelLcrImpedance() 
{
	SetEnables();		
}

void TCFantasticFilterPropertyPage2::OnRadioParallelLcrInductance() 
{
	SetEnables();		
}

void TCFantasticFilterPropertyPage2::OnRadioParallelLcrResistance() 
{
	SetEnables();		
}

void TCFantasticFilterPropertyPage2::OnRadioSeriesLcrCapacitance() 
{
	SetEnables();		
}

void TCFantasticFilterPropertyPage2::OnRadioSeriesLcrFrequency() 
{
	SetEnables();		
}

void TCFantasticFilterPropertyPage2::OnRadioSeriesLcrImpedance() 
{
	SetEnables();		
}

void TCFantasticFilterPropertyPage2::OnRadioSeriesLcrInductance() 
{
	SetEnables();		
}

void TCFantasticFilterPropertyPage2::OnRadioSeriesLcrResistance() 
{
	SetEnables();		
}

void TCFantasticFilterPropertyPage2::OnRadioSeriesLcrQ() 
{
	SetEnables();		
}

void TCFantasticFilterPropertyPage2::OnRadioSeriesLcrFo() 
{
	SetEnables();		
}

void TCFantasticFilterPropertyPage2::OnRadioSeriesLcrBandwidth() 
{
	SetEnables();		
}

void TCFantasticFilterPropertyPage2::OnRadioParallelLcrQ() 
{
	SetEnables();		
}

void TCFantasticFilterPropertyPage2::OnRadioParallelLcrFo() 
{
	SetEnables();		
}

void TCFantasticFilterPropertyPage2::OnRadioParallelLcrBandwidth() 
{
	SetEnables();		
}

void TCFantasticFilterPropertyPage2::OnRadioCapacitorSlewCapacitance() 
{
	SetEnables();	
}

void TCFantasticFilterPropertyPage2::OnButtonUpdate() 
{
	GetDisplay();

	CElectronicFormulars.CCapacitor.Calculate();
	CElectronicFormulars.CInductor.Calculate();
	CElectronicFormulars.CCapacitorSlew.Calculate();
	CElectronicFormulars.CInductorSlew.Calculate();
	CElectronicFormulars.CSeriesLCR.Calculate();
	CElectronicFormulars.CParallelLCR.Calculate();

	SetDisplay();	
}

BOOL TCFantasticFilterPropertyPage3::OnKillActive() 
{
	GetDisplay();

	return CPropertyPage::OnKillActive();
}

BOOL TCFantasticFilterPropertyPage3::OnSetActive() 
{
	g_last_active_fantastic_filter_property_page = 2;

	return CPropertyPage::OnSetActive();
}

BOOL TCFantasticFilterPropertyPage3::OnInitDialog() 
{
	CPropertyPage::OnInitDialog();
	
	SetDisplay();

	return TRUE;  
}


void TCFantasticFilterPropertyPage3::GetDisplay(void)
{
	if(!PCElectronicFormulars) return;

	UpdateData(true);



}

void TCFantasticFilterPropertyPage3::SetDisplay(void)
{
	if(!PCElectronicFormulars) return;



}

void TCFantasticFilterPropertyPage3::SetEnables(void)
{
	if(!PCElectronicFormulars) return;




	UpdateData(false);
}

void TCFantasticFilterPropertyPage3::OnButtonUpdate() 
{
	
}
