// TCSpiceComponentDlg.cpp : implementation file
//

#include "stdafx.h"
#include "resource.h"
#include"TESuperSpiceEnums.h"
#include "TEPropertyViewTypes.h"
#include "TCMKSConvert.h"
#include "TESuperSpiceLabelEnums.h"
#include "TCSuperSpiceDataBase.h"
#include "TCSchematicObjectData.h"
#include "TCFetLablesDlg.h"


#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

IMPLEMENT_DYNCREATE(TCFetLablesDlg, CPropertyPage)
extern class TCSuperSpiceDataBase GCSuperSpiceDataBase;

extern int	g_last_active_component_property_page;
extern int	g_last_active_generator_property_page;
/////////////////////////////////////////////////////////////////////////////

TCFetLablesDlg::TCFetLablesDlg() : CPropertyPage(TCFetLablesDlg::IDD)
{
	//{{AFX_DATA_INIT(TCFetLablesDlg)
	m_check_visable_ref_designator = FALSE;
	m_check_visable_spice_name = FALSE;
	m_check_visable_type_name = FALSE;
	m_check_visable_value = FALSE;
	CMRefDesignator = _T("");
	CMEditSpiceName = _T("");
	CMEditTypeName = _T("");
	CMEditValue = _T("");
	m_value_1_visable = FALSE;
	m_value_3_visable = FALSE;
	CEditValueHeader1 = _T("");
	CEditValueHeader3 = _T("");
	CMEditValue1 = _T("");
	CMEditValue3 = _T("");
	m_value_designer_type = 0;
	m_calculation_type = 1;
	//}}AFX_DATA_INIT
}

TCFetLablesDlg::~TCFetLablesDlg()
{
}

void TCFetLablesDlg::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(TCFetLablesDlg)
	DDX_Control(pDX, IDC_EDIT_CURRENT2, CMCurrentCtrl);
	DDX_Control(pDX, IDC_EDIT_VALUE_3, CMEditCntrlValue3);
	DDX_Control(pDX, IDC_EDIT_VALUE_1, CMEditCntrlValue1);
	DDX_Control(pDX, IDC_EDIT_VALUE, CEditCntlValue);
	DDX_Control(pDX, IDC_EDIT_TYPE_NAME, CEditCntlTypeName);
	DDX_Control(pDX, IDC_EDIT_SPICE_NAME, CEditCntlSpiceName);
	DDX_Control(pDX, IDC_EDIT_REF_DESIGNATOR, CEditCntlRefDesignator);
	DDX_Check(pDX, IDC_CHECK_VISABLE_REF_DESIGNATOR, m_check_visable_ref_designator);
	DDX_Check(pDX, IDC_CHECK_VISABLE_SPICE_NAME, m_check_visable_spice_name);
	DDX_Check(pDX, IDC_CHECK_VISABLE_TYPE_NAME, m_check_visable_type_name);
	DDX_Check(pDX, IDC_CHECK_VISABLE_VALUE, m_check_visable_value);
	DDX_Text(pDX, IDC_EDIT_REF_DESIGNATOR, CMRefDesignator);
	DDX_Text(pDX, IDC_EDIT_SPICE_NAME, CMEditSpiceName);
	DDX_Text(pDX, IDC_EDIT_TYPE_NAME, CMEditTypeName);
	DDX_Text(pDX, IDC_EDIT_VALUE, CMEditValue);
	DDX_Check(pDX, IDC_CHECK_VISABLE_VALUE_1, m_value_1_visable);
	DDX_Check(pDX, IDC_CHECK_VISABLE_VALUE_3, m_value_3_visable);
	DDX_Text(pDX, IDC_STATIC_VALUE_1, CEditValueHeader1);
	DDX_Text(pDX, IDC_STATIC_VALUE_3, CEditValueHeader3);
	DDX_Text(pDX, IDC_EDIT_VALUE_1, CMEditValue1);
	DDX_Text(pDX, IDC_EDIT_VALUE_3, CMEditValue3);
	DDX_MKSValue(pDX, IDC_EDIT_CURRENT2, m_drain_current);
	DDX_Radio(pDX, IDC_RADIO_VALUE_DESIGNER, m_value_designer_type);
	DDX_Radio(pDX, IDC_RADIO_CALC_TYPE, m_calculation_type);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(TCFetLablesDlg, CPropertyPage)
	//{{AFX_MSG_MAP(TCFetLablesDlg)
	ON_EN_KILLFOCUS(IDC_EDIT_SPICE_NAME, OnKillfocusEditSpiceName)
	ON_BN_CLICKED(IDC_RADIO_VALUE_DESIGNER, OnRadioValueDesigner)
	ON_BN_CLICKED(IDC_RADIO_VALUE_DESIGNER2, OnRadioValueDesigner2)
	ON_BN_CLICKED(IDC_RADIO_VALUE_DESIGNER3, OnRadioValueDesigner3)
	ON_BN_CLICKED(IDC_RADIO_VALUE_DESIGNER4, OnRadioValueDesigner4)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

BOOL TCFetLablesDlg::OnKillActive() 
{
	int value =  CPropertyPage::OnKillActive();

	if(value)
	{
		PCSchematicObjectData->CLabelListData[E_COMPONENT_SYMBOL_NAME].is_visable = !!m_check_visable_type_name;
		PCSchematicObjectData->CLabelListData[E_COMPONENT_SYMBOL_NAME].CLabel = CMEditTypeName;

		PCSchematicObjectData->CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].is_visable = !!m_check_visable_spice_name;
		PCSchematicObjectData->CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel = CMEditSpiceName;

		PCSchematicObjectData->CLabelListData[E_COMPONENT_VALUE].is_visable = !!m_check_visable_value;
		PCSchematicObjectData->CLabelListData[E_COMPONENT_VALUE].CLabel = CMEditValue;

		PCSchematicObjectData->CLabelListData[E_COMPONENT_DESIGNATOR].is_visable = !!m_check_visable_ref_designator;
		PCSchematicObjectData->CLabelListData[E_COMPONENT_DESIGNATOR].CLabel = CMRefDesignator;


		PCSchematicObjectData->CLabelListData[E_COMPONENT_FET_M].is_visable = !!m_value_1_visable;
		PCSchematicObjectData->CLabelListData[E_COMPONENT_FET_PARAMETERS].is_visable = !!m_value_3_visable;

		CMEditValue1.TrimLeft();
		CMEditValue1.TrimRight();

		if(CMEditValue1 == "") CMEditValue1 = "1"; 

		PCSchematicObjectData->CLabelListData[E_COMPONENT_FET_M].CLabelValue = CMEditValue1;
		PCSchematicObjectData->CLabelListData[E_COMPONENT_FET_PARAMETERS].CLabelValue = CMEditValue3;
	}
 
	PCSchematicObjectData->FormatLabel();

	return value;
}

BOOL TCFetLablesDlg::OnInitDialog() 
{
	m_check_visable_type_name = PCSchematicObjectData->CLabelListData[E_COMPONENT_SYMBOL_NAME].is_visable;
	CMEditTypeName =  PCSchematicObjectData->CLabelListData[E_COMPONENT_SYMBOL_NAME].CLabel;

	m_check_visable_spice_name = PCSchematicObjectData->CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].is_visable;
	CMEditSpiceName =  PCSchematicObjectData->CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel;

	m_check_visable_value = PCSchematicObjectData->CLabelListData[E_COMPONENT_VALUE].is_visable;
	CMEditValue =  PCSchematicObjectData->CLabelListData[E_COMPONENT_VALUE].CLabel;
	
	m_check_visable_ref_designator = PCSchematicObjectData->CLabelListData[E_COMPONENT_DESIGNATOR].is_visable;
	CMRefDesignator =  PCSchematicObjectData->CLabelListData[E_COMPONENT_DESIGNATOR].CLabel;
	
	m_drain_current = PCSchematicObjectData->CReserved.CIntArray[E_RESERVED_INT_DESIGNER_VALUE];
	m_value_designer_type = (int) PCSchematicObjectData->CReserved.CIntArray[E_RESERVED_INT_DESIGNER_TYPE];

	if(PCSchematicObjectData->CReserved.CIntArray[E_RESERVED_INT_DESIGNER_CALC_MODE] == E_COMPONENT_FET_WIDTH) m_calculation_type = 1;
	else m_calculation_type = 0;
			
	CEditValueHeader3	= "Parameters:";
	CEditValueHeader1	= "Multiplier:";

	m_value_1_visable = PCSchematicObjectData->CLabelListData[E_COMPONENT_FET_M].is_visable;
	m_value_3_visable = PCSchematicObjectData->CLabelListData[E_COMPONENT_FET_PARAMETERS].is_visable;
		
	CMEditValue1 = PCSchematicObjectData->CLabelListData[E_COMPONENT_FET_M].CLabelValue;
	CMEditValue3 = PCSchematicObjectData->CLabelListData[E_COMPONENT_FET_PARAMETERS].CLabelValue;

	CMEditValue1.TrimLeft();
	CMEditValue1.TrimRight();

	if(CMEditValue1 == "") 
	{
		CMEditValue1 = "1";

		PCSchematicObjectData->CLabelListData[E_COMPONENT_FET_M].CLabelValue = CMEditValue1;
	}

	CPropertyPage::OnInitDialog();
	
	CEditCntlValue.SetReadOnly(PCSchematicObjectData->CLabelListData[E_COMPONENT_VALUE].read_only);

	if(m_value_designer_type == 3) CMCurrentCtrl.EnableWindow(true);
	else CMCurrentCtrl.EnableWindow(false);

	return TRUE; 
}


void TCFetLablesDlg::OnRadioValueDesigner() 
{
	CMCurrentCtrl.EnableWindow(false);
}

void TCFetLablesDlg::OnRadioValueDesigner2() 
{
	CMCurrentCtrl.EnableWindow(false);
}

void TCFetLablesDlg::OnRadioValueDesigner3() 
{
	CMCurrentCtrl.EnableWindow(false);
}

void TCFetLablesDlg::OnRadioValueDesigner4() 
{
	CMCurrentCtrl.EnableWindow(true);
}

BOOL TCFetLablesDlg::OnSetActive() 
{
	g_last_active_component_property_page = 0;
	g_last_active_generator_property_page = 0;

	PCSchematicObjectData->FormatSpiceName();
	PCSchematicObjectData->FormatSpiceValue();

	CMEditSpiceName	=  PCSchematicObjectData->CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel;
	CMEditValue = PCSchematicObjectData->CLabelListData[E_COMPONENT_VALUE].CLabel;

	CEditCntlValue.SetWindowText(CMEditValue);
	CEditCntlSpiceName.SetWindowText(CMEditSpiceName);

	return CPropertyPage::OnSetActive();
}

void TCFetLablesDlg::OnKillfocusEditSpiceName() 
{
	UpdateData(true);
	
	PCSchematicObjectData->CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel = CMEditSpiceName;

	PCSchematicObjectData->FormatRecordName();
	PCSchematicObjectData->FormatSpiceValue();

	CMEditValue = PCSchematicObjectData->CLabelListData[E_COMPONENT_VALUE].CLabel;

	CEditCntlValue.SetWindowText(CMEditValue);
}

