
#include "stdafx.h"
#include "TDVersion.h"
#include "TCFileFunctions.h"

#ifdef _DEBUG
#define new DEBUG_NEW 
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

extern CString ExtractFileName(CString CPathAndName);

////////////////////////////////

bool CreateNullFile(CString &CName)
{
	CFile CDataFile;

	if(!CDataFile.Open(CName, CFile::modeCreate | CFile::modeRead | CFile::shareDenyNone)) return false;

	return true;
}

CString GetFileExtention(CString CPathAndName)
{
	CString CExt;

	int count	= CPathAndName.ReverseFind('.');

	if(count < 0) return "";

	int length	= CPathAndName.GetLength();

	int delta = length - count;

	if(delta > -1)
		CExt = CPathAndName.Right(length - count - 1);

	return CExt;
}

CString GetProgramDirectory(void)
{
	char *p_buff = new char[8192];

	if(!p_buff) return "";

	if(!AfxGetApp())
	{
		ASSERT(0);

		return "";
	}

	CString CText = AfxGetApp()->m_pszAppName;

	CText += ".exe";

	GetModuleFileName(GetModuleHandle(CText), p_buff, 8191);

	CText = p_buff;

	CText = GetPathFromPathAndName(CText);

	delete [] p_buff;

	return CText;
}

CString GetPathFromPathAndName(CString CPathAndName)
{
	CString CText = CPathAndName;

	char *p_buff = CText.GetBuffer(1024);
	char *p_buff_inspect;

	int length = CText.GetLength();

	p_buff_inspect = &p_buff[length];

	while(p_buff_inspect != p_buff)
	{
		if(*p_buff_inspect == '\\')
		{
			*++p_buff_inspect = 0;

			break;
		}
		p_buff_inspect--;
	}

	CText.ReleaseBuffer();

	return CText;
}

CString ExpandFilePath(CString CPath)
{
	CString CText = CPath; // look for <system> <default> <.> 

	if(CText.Find('<') < 0) return CPath;
	if(CText.Find('>') < 0) return CPath;
	
	CText.MakeLower();

	if(CText.Find("<examples>") > -1) return GetExamplesDir();
	if(CText.Find("<system>") > -1) return GetSuperSpiceSystemDir();
	if(CText.Find("<default>") > -1) return GetInitDirectory();
	if(CText.Find("<.>") > -1) return GetProgramDirectory();
	
	return CPath;
}

CString GetAllUsersAppDataFolderName(void)
{
	TCHAR szPath[MAX_PATH];
	HRESULT result;

	*szPath = 0;

	CString CText;

	result = SHGetFolderPath(0, CSIDL_COMMON_APPDATA | CSIDL_FLAG_CREATE, 0, 0, szPath);
	
	if(result != S_OK)  return CText;

	CText = szPath;

	CText += "\\";

	return CText;
}

CString GetApplicationDataDirectory(void)
{
	CString CText, CTest;

	CTest = GetProgramDirectory() + "allusrappdata.tst"; 

	if(!FileExists(CTest)) // use folders all referanced to .exe directory
	{
		return GetProgramDirectory();
	}

	// For vister/windows 7 writing to program files not allowed

	CText = GetAllUsersAppDataFolderName();

	if(!CText) 
	{
		AfxMessageBox("Unable to find All Users Application Data Folder");

		return GetProgramDirectory();
	}

	CText += "AnaSoft\\SuperSpice\\";

	return CText;
}

CString GetInitName(void)
{
	return "Default"; // simplifies instalation, multyuser sorts it self out anyway
}

CString GetInitDirectory(void)
{
	CString CUserName = GetInitName();

	CString CUserDir;

	CUserDir = GetApplicationDataDirectory() + CUserName;

	CUserDir += "\\";

	return CUserDir;
}

CString GetExamplesDir(void)
{
	CString CExamplesDir;

	CExamplesDir = GetApplicationDataDirectory() + "Examples\\"; 

	return CExamplesDir;
}


CString GetSuperSpiceSystemDir(void)
{
	CString CSystemDir;

	CSystemDir = GetApplicationDataDirectory();

	CSystemDir += "System\\";

	return CSystemDir;
}

CString GetSuperSpiceFilterDir(void)
{
	CString CFilterDir;

	CFilterDir = GetSuperSpiceSystemDir() + "SuperSpiceFilters\\";

	return CFilterDir;
}


bool FileExists(CString &CName)
{
	CFile CDataFile;

	if(CDataFile.Open(CName, CFile::modeRead | CFile::shareDenyNone)) return true;

	return false;
}

bool AppendFile(CString CDestination, CString CSource)
{
	if(!FileExists(CDestination)) return false;
	if(!FileExists(CSource)) return false;

	CFile CDestinationFile;
	CFile CSourceFile;

	if(!CDestinationFile.Open(CDestination, CFile::modeWrite | CFile::shareDenyNone)) return false;

	if(!CSourceFile.Open(CSource,  CFile::modeRead | CFile::shareDenyNone)) return false;

	CDestinationFile.SeekToEnd();

	int length = (int) CSourceFile.GetLength();

	char *buff = new char[length + 1];

	if(!buff) return false;

	if(!CSourceFile.Read(buff, length))
	{
		delete [] buff;

		return false;	
	}

	CDestinationFile.Write(buff, length);

	delete [] buff;

	return true;
}

TCAchiveRaw::TCAchiveRaw(bool is_storing)
{
	m_is_storing	= is_storing;
}

TCAchiveRaw::~TCAchiveRaw()
{

}

bool TCAchiveRaw::GetLine(CString *CGetLine)
{
	CGetLine;
	unsigned char abyte;

	*CGetLine = "";

	while(this->Read(&abyte, sizeof(abyte)) == 1)
	{
		if(abyte != '\r')
			*CGetLine += abyte;
		else
		{
			this->Read(&abyte, sizeof(abyte));// discard next \n

			return true;
		}
	}

	return false;
}
void TCAchiveRaw::operator << (CString &Data)
{
	int count = Data.GetLength();

	this->Write(Data.GetBuffer(count), count);
}
void TCAchiveRaw::operator >> (CString &Data)
{
	int count;

	this->Read(&count, sizeof(count));
	
	char *buff = new char[count + 1];
	
	if(!buff) return;
	
	this->Read(buff, count);

	buff[count] = 0;

	Data = buff;

	delete [] buff;
}
void TCAchiveRaw::operator << (float &Data)
{
	this->Write(&Data, sizeof(Data));
}
void TCAchiveRaw::operator >> (float &Data)
{
	this->Read(&Data, sizeof(Data));
}
void TCAchiveRaw::operator << (int &Data)
{
	this->Write(&Data, sizeof(Data));
}
void TCAchiveRaw::operator >> (int &Data)
{
	this->Read(&Data, sizeof(Data));
}
void TCAchiveRaw::operator << (double &Data)
{
this->Write(&Data, sizeof(Data));
}
void TCAchiveRaw::operator >> (double &Data)
{
	this->Read(&Data, sizeof(Data));
}
void TCAchiveRaw::operator << (char &Data)
{
	this->Write(&Data, sizeof(Data));
}
void TCAchiveRaw::operator >> (char &Data)
{
	this->Read(&Data, sizeof(Data));
}

void TCAchiveRaw::operator << (bool &Data)
{
	this->Write(&Data, sizeof(Data));
}
void TCAchiveRaw::operator >> (bool &Data)
{
	this->Read(&Data, sizeof(Data));
}

bool LoadGenericFromRawArchive(CFileObject *CDataObject, CString CFileName)
{
	TCAchiveRaw CDataFile(false);

	if(!CDataFile.Open(CFileName, CFile::modeRead | CFile::shareDenyNone)) return false;

	CDataObject->Serialize(CDataFile);

	return true;
}

bool SaveGenericToRawArchive(CFileObject *CDataObject, CString CFileName)
{
	TCAchiveRaw CDataFile(true);

	if(!CDataFile.Open(CFileName, CFile::modeCreate | CFile::modeWrite | CFile::shareDenyNone)) return false;

	CDataObject->Serialize(CDataFile);

	return true;
}

CString FindLine(ifstream &CFileStream, CString CFirstWord)
{
	CString CText, CTemp;

	CFirstWord.MakeUpper();

	char *buff = new char[1024];

	if(!buff) return CText;

	while(!CFileStream.eof())
	{
		if(!CFileStream.getline(buff, 1023)) 
		{
			delete [] buff;

			CFileStream.clear();

			return CText;
		}

		CText = buff;
		CTemp = buff;

		CText.TrimLeft();

		CText = CText.Left(CFirstWord.GetLength());

		CText.MakeUpper();

		if(CText == CFirstWord) return CTemp;
	}

	delete [] buff;

	return CText;
}

bool TCIFStream::GetLine(char* pchar, int count)
{
	// this is for line reading in binary mode to get rid of extra character
/*	if(!getline(pchar, count))
	{
		return false;
	}*/


	return ReadLine(pchar, count);
}

bool TCIFStream::ReadLine(char* pchar, int count)
{
	if(text_file_mode) 
	{
		 if(getline(pchar, count)) return true;

		 clear();

		 return false;
	}

	int data;
	int p = 0;
	char* pbuff = pchar;
	char dummy;

	while(!eof())
	{
		data = peek();

		while(data != '\n' && data != EOF && (p < count) && data != '\r')
//		while(data != '\r' && data != EOF && (p < count))
		{
			read(pbuff++, sizeof(char));
			p++;
			data = peek();
		}

		if(data == EOF) 
		{
			read(&dummy, sizeof(char));// force eof;
			*pchar = 0;
			return false;
		}

		if(data == '\r')
		{
			read(&dummy, sizeof(char));// get cr;

			data = peek();
		}
		
		if(data == '\n')
		{
			read(&dummy, sizeof(char));// get linefeed;
		}

		*pbuff = 0;// terminate string

		return true;
	}

	clear();

	return false;
}

CString GetWindowsProductID(void)
{
	CString CText;

	HKEY	hKey			= HKEY_LOCAL_MACHINE;
	HKEY	h_software		= NULL;
	HKEY	h_microsoft		= NULL;
	HKEY	h_windows		= NULL;
	HKEY	h_version		= NULL;
	DWORD	size;

	if(RegOpenKeyEx(hKey, "Software",0 , KEY_READ, &h_software) != ERROR_SUCCESS) return CText;

	if(RegOpenKeyEx(h_software, "Microsoft", 0 , KEY_READ, &h_microsoft) != ERROR_SUCCESS) return CText;

	if(RegOpenKeyEx(h_microsoft, "Windows", 0 , KEY_READ, &h_windows) != ERROR_SUCCESS) return CText;

	if(RegOpenKeyEx(h_windows, "CurrentVersion", 0 , KEY_READ, &h_version) != ERROR_SUCCESS) return CText;

	BYTE buff[256];

	size = 255;

	RegQueryValueEx(h_version, "ProductId", NULL, NULL, buff, &size);
 
	CText = buff;

	RegCloseKey(h_version);
	RegCloseKey(h_windows);
	RegCloseKey(h_microsoft);
	RegCloseKey(h_software);
	RegCloseKey(hKey);

	return CText;
}

CString GetWindowsProductIDLastWord(void)
{
	CString CText;

	CText = GetWindowsProductID();

	if(CText == "") return "";

	CText = CText.Right(5);

	return CText;
}

CString GetSuperSpiceDefaultFileName(CString CFileName)
{
	CString CName;
	CString CDir;
	CString CPathAndName;

	if(FileExists(CFileName)) return CFileName;

	CName = ExtractFileName(CFileName);

	CDir = GetInitDirectory();

	CPathAndName = CDir + CName;

	if(FileExists(CPathAndName)) return CPathAndName;

	CDir = GetSuperSpiceSystemDir();

	CPathAndName = CDir + CName;

	if(FileExists(CPathAndName)) return CPathAndName;

	return CFileName;
}