#ifndef _FILE_FUNCTIONS_H
#define _FILE_FUNCTIONS_H

#include "stdafx.h"
#include <fstream>
#include <iostream>
using namespace std;
#include <afxtempl.h>

CString GetProgramDirectory(void);
CString GetPathFromPathAndName(CString CPathAndName);
CString GetFileExtention(CString CPathAndName);
CString GetInitName(void);
CString GetInitDirectory(void);
CString GetExamplesDir(void);
CString GetSuperSpiceSystemDir(void);
CString GetSuperSpiceFilterDir(void);
CString ExpandFilePath(CString CPath);
CString GetApplicationDataDirectory(void);

bool AppendFile(CString CDestinationFile, CString CSourceFile);

bool FileExists(CString &CName);
bool CreateNullFile(CString &CName);
CString GetWindowsProductID(void);
CString GetWindowsProductIDLastWord(void);
CString GetSuperSpiceDefaultFileName(CString CFileName);
CString GetAllUsersAppDataFolderName(void);

CString FindLine(ifstream &CFileStream, CString CFirstWord);

class TCAchiveRaw : public CFile
{
	bool m_is_storing;

	public:

		TCAchiveRaw(bool is_storing);

		virtual	~TCAchiveRaw();

		inline	bool IsStoring(){return m_is_storing;};

		bool GetLine(CString * CGetLine);

		void operator << (CString &Data);
		void operator >> (CString &Data);
		void operator << (float &Data);
		void operator >> (float &Data);
		void operator << (int &Data);
		void operator >> (int &Data);
		void operator << (double &Data);
		void operator >> (double &Data);
		void operator << (char &Data);
		void operator >> (char &Data); 
		void operator << (bool &Data);
		void operator >> (bool &Data); 

};


class CFileObject
{
	public:
			CFileObject(){};
			~CFileObject(){};

			virtual void Serialize(TCAchiveRaw &CRawFile){CRawFile;};
			
};



class TCIFStream : public ifstream
{
	public:	
	
				bool GetLine(char* pchar, int count);
				bool ReadLine(char* pchar, int count);

				bool text_file_mode;

};



bool SaveGenericToRawArchive(CFileObject *CDataObject, CString CFileName);
bool LoadGenericFromRawArchive(CFileObject *CDataObject, CString CFileName);
#endif