#include "stdafx.h"
#include "resource.h"
#include "generic.h"
#include "TCSuperSpiceDataBase.h"
#include "TCSuperSpiceGlobalData.h"
#include "TCFileTreeDoc.h"
#include "TCFileTreeView.h"
#include "TCSuperSpiceDoc.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

extern TCSuperSpiceGlobalData	GCSuperSpiceGlobalData;
extern TCSuperSpiceDataBase		GCSuperSpiceDataBase; 
extern CString GLastFileTreeFilesFile;
extern CString GLastFileTreeFiles;

HTREEITEM InsertTreeItem(CTreeCtrl * ctrl,LPCTSTR txt,int imgind,int selimgind, int id);
HTREEITEM InsertTreeItem(CTreeCtrl * ctrl,HTREEITEM hTreeItem, LPCTSTR txt,int imgind,int selimgind, int id);

/////////////////////////////////////////////////////////////////////////////
// TCFileTreeView

IMPLEMENT_DYNCREATE(TCFileTreeView, CXTTreeView)

BEGIN_MESSAGE_MAP(TCFileTreeView, CXTTreeView)
	//{{AFX_MSG_MAP(TCFileTreeView)
		// NOTE - the ClassWizard will add and remove mapping macros here.
		//    DO NOT EDIT what you see in these blocks of generated code !
	ON_WM_ERASEBKGND()
	ON_WM_PAINT()
	ON_WM_CREATE()
	ON_WM_NCHITTEST()
	ON_WM_CONTEXTMENU()
	ON_WM_RBUTTONDOWN()
	//}}AFX_MSG_MAP
	// Standard printing commands

	ON_NOTIFY_REFLECT(NM_DBLCLK, OnDoubleClickTree) 
	ON_COMMAND(ID_REFRESH_TREE, Refresh)
	ON_COMMAND(ID_POPUP_REMOVEFROMLIST, RemoveFile)

	
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// TCFileTreeView construction/destruction

TCFileTreeView::TCFileTreeView()
{
	m_pTreeCtrl = &GetTreeCtrl();

	ASSERT(m_pTreeCtrl);

	hlast_saved_file = NULL;
	hlast_saved_item = NULL;
	f_last_file		 = false;	
}

TCFileTreeView::~TCFileTreeView()
{
	m_ImageList.DeleteImageList();
}

BOOL TCFileTreeView::PreCreateWindow(CREATESTRUCT& cs)
{
	if( !CXTTreeView::PreCreateWindow( cs ))
		return FALSE;

	// Set the style for the tree control.
	cs.style |= TVS_HASBUTTONS|TVS_HASLINES|TVS_LINESATROOT;

	// TODO: Modify the Window class or styles here by modifying
	//  the CREATESTRUCT cs

	return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
// TCFileTreeView drawing

void TCFileTreeView::OnDraw(CDC* pDC)
{
	pDC;
	TCFileTreeDoc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);
	// TODO: add draw code for native data here

}

void TCFileTreeView::OnInitialUpdate()
{
	CXTTreeView::OnInitialUpdate();

	// TODO: You may populate your TreeView with items by directly accessing
	//  its tree control through a call to GetTreeCtrl().

}



/////////////////////////////////////////////////////////////////////////////
// TCFileTreeView diagnostics

#ifdef _DEBUG
void TCFileTreeView::AssertValid() const
{
	CXTTreeView::AssertValid();
}

void TCFileTreeView::Dump(CDumpContext& dc) const
{
	CXTTreeView::Dump(dc);
}

TCFileTreeDoc* TCFileTreeView::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(TCFileTreeDoc)));
	return (TCFileTreeDoc*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// TCFileTreeView message handlers

void TCFileTreeView::OnUpdate(CView* pSender, LPARAM lHint, CObject* pHint) 
{
	pSender;
	lHint;
	pHint;
}

void TCFileTreeView::UpdateView()
{

}

BOOL TCFileTreeView::OnEraseBkgnd(CDC* pDC) 
{
	UNUSED_ALWAYS(pDC);
	return TRUE;
}

int TCFileTreeView::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if (CXTTreeView::OnCreate(lpCreateStruct) == -1)
		return -1;

	CBitmap bitmap;

	m_ImageList.Create(23, 19, ILC_COLOR|ILC_MASK, 6, 4); 
	m_ImageList.SetBkColor(GetSysColor(COLOR_WINDOW));
	bitmap.LoadBitmap(IDB_TREENODES);
	m_ImageList.Add(&bitmap, (COLORREF)0xFFFFFF);
	m_pTreeCtrl->SetImageList(&m_ImageList, TVSIL_NORMAL);

	 
	UpdateView();

	return 0;
}

void TCFileTreeView::OnRButtonDown(UINT nFlags, CPoint point)
{
	nFlags;
	OnContextMenu(NULL, point);// XT messes up context menu handling
}

void TCFileTreeView::OnContextMenu(CWnd*, CPoint point)
{
	CMenu menu;
	VERIFY(menu.LoadMenu(CG_IDR_POPUP_TREE_FILE));

	CMenu* pPopup = menu.GetSubMenu(0);
	ASSERT(pPopup != NULL);

	ClientToScreen(&point);// XT messes up context menu handling

	CWnd* pWndPopupOwner = this;
//	while (pWndPopupOwner->GetStyle() & WS_CHILD)
//		pWndPopupOwner = pWndPopupOwner->GetParent();

	pPopup->TrackPopupMenu(TPM_LEFTALIGN | TPM_RIGHTBUTTON, point.x, point.y,pWndPopupOwner);
}

LRESULT TCFileTreeView::OnNcHitTest(CPoint point) 
{
	UINT uFlag=0;

	if(!m_pTreeCtrl) return HTNOWHERE;
	if(!m_pTreeCtrl->m_hWnd) return HTNOWHERE;

	// Get the cursor location in client coordinates.
	CPoint pt = point;	
	ScreenToClient(&pt);

	// Get a pointer to the tooltip control.
	CToolTipCtrl* pCtrl = (CToolTipCtrl*)CWnd::FromHandle(
		(HWND)::SendMessage(m_hWnd, TVM_GETTOOLTIPS, 0, 0L));

	// If we have a valid tooltip pointer and the cursor
	// is over a tree item, the bring the tooltip control
	// to the top of the Z-order.
	if (pCtrl && m_pTreeCtrl->HitTest(pt, &uFlag)){
		pCtrl->SetWindowPos(&wndTop,0, 0, 0, 0,
			SWP_NOACTIVATE | SWP_NOSIZE |SWP_NOMOVE);
	}
	
	return CXTTreeView::OnNcHitTest(point);
}

void TCFileTreeView::OnDoubleClickTree(NMHDR * pNMHDR, LRESULT* pResult)
{
	*pResult = 0;

	pNMHDR;

	DWORD				dwpos;
	TV_HITTESTINFO		tvhti;
	HTREEITEM           htiItemClicked, hparent;
	POINT				point;
	int					id;

	dwpos = GetMessagePos();
	point.x = LOWORD(dwpos);
	point.y = HIWORD(dwpos);

	::MapWindowPoints(HWND_DESKTOP, m_hWnd, &point, 1);

	tvhti.pt = point;

	htiItemClicked = m_pTreeCtrl->HitTest(&tvhti);

	if(!htiItemClicked) return;

	hparent = m_pTreeCtrl->GetParentItem(htiItemClicked);

	if(!hparent) return;

	if(!(tvhti.flags & (TVHT_ONITEMLABEL | TVHT_ONITEMICON))) return;

	CString CFileName = m_pTreeCtrl->GetItemText(htiItemClicked);

	if(CFileName == "") return;

	id = m_pTreeCtrl->GetItemData(htiItemClicked);

	if(id < 0) return; 

	id = CFileID.GetPageIndex(id);

	if(id < 0) return;

	CFileName = CFileID.CPageIdData[id].CPageTitle;

	id = m_pTreeCtrl->GetItemData(hparent);

	if(id < 0) return; 

	id = CFileID.GetPageIndex(id);

	if(id < 0) return;

	CString CFileFolderName = CFileID.CPageIdData[id].CPageTitle;

	if(CFileFolderName == "") return;

	OpenDocument(CFileFolderName, CFileName);
}

bool TCFileTreeView::OpenDocument(CString CFolderName, CString CFileName)
{
	if(!FileExists(CFileName)) 
	{
		AfxMessageBox(IDS_FILE_NOT_EXISTS);

		return false;
	}

	TCSuperSpiceDoc *PCSuperSpiceDoc = FindDocument(CFolderName);

	if(!PCSuperSpiceDoc) return false;// Should not happen

	if(CFileName == CFolderName)
	{
		ActivateADocumentView(PCSuperSpiceDoc);

		return true;
	}
	
	CString CExt = GetFileExtention(CFileName);

	CExt.MakeLower();

	if(CExt == "sss") PCSuperSpiceDoc->DisplayChildSchematicDocument(CFileName, "X?");
	else if(CExt == "ssg") PCSuperSpiceDoc->DisplayOutputGraphics(CFileName);
	else if(CExt == "sym") PCSuperSpiceDoc->DisplaySymbolEditorDocument(CFileName);
	else 
	{
		if(!PCSuperSpiceDoc->DisplayTextBasedDocument(CFileName))// try opening from main open file
		{
			AfxGetApp()->OpenDocumentFile(CFileName);
		}
	}

	return true;
}

void TCFileTreeView::UpdateAllData(void)
{
	TCSuperSpiceDoc *PCSuperSpiceDoc = NULL;
	CDocTemplate *PCDocTemplate;
	CDocument	*PCDocument;
	POSITION DocTemplatePos = AfxGetApp()->GetFirstDocTemplatePosition();
	POSITION DocPos;
	
	CArray <CDocument*, CDocument*> CDocList;

	while(DocTemplatePos)// get top level schematics
	{
		PCDocTemplate = AfxGetApp()->GetNextDocTemplate(DocTemplatePos);

		DocPos = PCDocTemplate->GetFirstDocPosition();

		while(DocPos)
		{
			PCDocument = PCDocTemplate->GetNextDoc(DocPos);

			if(!PCDocument) continue;

			if(PCDocument->IsKindOf(RUNTIME_CLASS(TCSuperSpiceDoc)))
			{
				PCSuperSpiceDoc = (TCSuperSpiceDoc *)PCDocument;

				if(!PCSuperSpiceDoc->top_level) continue;
				
				CDocList.Add(PCDocument);
			}
		}
	}

	int count = CDocList.GetSize();

	for(int p = 0; p < count; p++)
	{
		PCSuperSpiceDoc = (TCSuperSpiceDoc *) CDocList[p];	

		if(!AfxIsValidAddress(PCSuperSpiceDoc, sizeof(TCSuperSpiceDoc))) continue;

		AddSchematicFileFolder(PCSuperSpiceDoc, PCSuperSpiceDoc->GetPathName());

		AddSchematicFile(PCSuperSpiceDoc, PCSuperSpiceDoc->GetPathName());

		PCSuperSpiceDoc->AddToProjectTree();// Add the schematic files to the folder
	}

	f_last_file = true;
}

bool TCFileTreeView::AddSchematicFileFolder(TCSuperSpiceDoc *PCDoc, CString CFileName)
{
	if(!PCDoc) return false;

	HTREEITEM htmp = NULL;
	int id;
	int index_id;
	
	id = CFileID.GetNewPageId("");

	index_id = CFileID.GetPageIndex(id);

	if(index_id < 0) return false;

	CFileID.CPageIdData[index_id].CPageTitle = CFileName;

	CFileName = ExtractFileName(CFileName);

	htmp = InsertTreeItem(m_pTreeCtrl, RemoveExtention(CFileName), 0, 1, id);

	PCDoc->HProjectFileTree = htmp;

	m_pTreeCtrl->SelectItem(htmp);

	if(!hlast_saved_file && CFileID.CPageIdData[index_id].CPageTitle == GLastFileTreeFiles)
	{
		hlast_saved_file = htmp;
	}

	return true;
}

bool TCFileTreeView::AddSchematicFile(TCSuperSpiceDoc *PCDoc, CString CFileName)
{
	if(!PCDoc) return false;

	HTREEITEM HItem = NULL;
	HTREEITEM htmp = NULL;
	int id;
	int index_id;

	TCSuperSpiceDoc *PCSuperSpiceDoc = PCDoc->GetTopLevelDoc();

	if(!PCSuperSpiceDoc) return false;

	CString CExt = GetFileExtention(CFileName);

	CExt.MakeLower();

	if(CExt == "spw" || CExt == "srp") return false;// backwards compatability

	id = CFileID.GetNewPageId("");

	index_id = CFileID.GetPageIndex(id);

	if(index_id < 0) return false;

	CFileID.CPageIdData[index_id].CPageTitle = CFileName;// full name fto recover later

	CFileName = ExtractFileName(CFileName);// only display ain part of name

	HItem = PCSuperSpiceDoc->HProjectFileTree;

	if(!HItem) return false;//needs a parent file folder

	htmp = InsertTreeItem(m_pTreeCtrl, HItem, CFileName, 2, 3, id);

	if(hlast_saved_file)
	{
		if(GLastFileTreeFilesFile == CFileName)
			hlast_saved_item = htmp;
	}

	m_pTreeCtrl->SelectItem(htmp);// force redraw

	return true;
}

void TCFileTreeView::Refresh(void)
{
	ASSERT(m_pTreeCtrl);

	m_pTreeCtrl->DeleteAllItems();

	CFileID.Clear();

	TCSuperSpiceDoc *PCSuperSpiceDoc = NULL;
	CDocTemplate *PCDocTemplate;
	CDocument	*PCDocument;
	POSITION DocTemplatePos = AfxGetApp()->GetFirstDocTemplatePosition();
	POSITION DocPos;
	
	while(DocTemplatePos)
	{
		PCDocTemplate = AfxGetApp()->GetNextDocTemplate(DocTemplatePos);

		DocPos = PCDocTemplate->GetFirstDocPosition();

		while(DocPos)
		{
			PCDocument = PCDocTemplate->GetNextDoc(DocPos);

			if(PCDocument->IsKindOf(RUNTIME_CLASS(TCSuperSpiceDoc)))
			{
				PCSuperSpiceDoc = (TCSuperSpiceDoc *)PCDocument;

				PCSuperSpiceDoc->HProjectFileTree = NULL;
			}
		}
	}

	UpdateAllData();
}

void TCFileTreeView::Remove(TCSuperSpiceDoc *PCDoc)
{
	int id;

	if(!PCDoc) return;

	HTREEITEM HItem = PCDoc->HProjectFileTree;

	if(!HItem) return;

	HTREEITEM hparent = m_pTreeCtrl->GetParentItem(HItem);

	if(!hparent)// must be the file folder
	{
		id = m_pTreeCtrl->GetItemData(HItem);

		if(id < 0) return;

		CFileID.RemovePageId(id);
	}

	if(HItem) m_pTreeCtrl->DeleteItem(HItem);
}

void TCFileTreeView::Remove(HTREEITEM HItem)
{
	int id;

	if(!HItem) return;

	if(IsBadCodePtr((FARPROC) HItem)) return;

	HTREEITEM hparent = m_pTreeCtrl->GetParentItem(HItem);

	if(!hparent)// must be the file folder
	{
		id = m_pTreeCtrl->GetItemData(HItem);

		if(id < 0) return;

		CFileID.RemovePageId(id);
	}

	if(HItem) m_pTreeCtrl->DeleteItem(HItem);
}

TCSuperSpiceDoc *TCFileTreeView::FindDocument(CString CFileName)
{
	CDocTemplate *PCDocTemplate;
	CDocument	*PCDocument;
	POSITION DocTemplatePos = AfxGetApp()->GetFirstDocTemplatePosition();
	POSITION DocPos;

	TCSuperSpiceDoc *PCSuperSpiceDoc = NULL;

	while(DocTemplatePos)
	{
		PCDocTemplate = AfxGetApp()->GetNextDocTemplate(DocTemplatePos);

		DocPos = PCDocTemplate->GetFirstDocPosition();

		while(DocPos)
		{
			PCDocument = PCDocTemplate->GetNextDoc(DocPos);

			if(PCDocument->IsKindOf(RUNTIME_CLASS(TCSuperSpiceDoc)))
			{			
				PCSuperSpiceDoc = (TCSuperSpiceDoc *)PCDocument;

				if(PCSuperSpiceDoc->GetPathName() == CFileName)
				{
					return PCSuperSpiceDoc;
				}
			}
		}
	}

	return NULL;
}

CString TCFileTreeView::GetFileName(void)
{
	HTREEITEM		htiItemClicked, hparent;

	htiItemClicked = m_pTreeCtrl->GetSelectedItem();

	if(!htiItemClicked) return "";

	hparent = m_pTreeCtrl->GetParentItem(htiItemClicked);

	if(!hparent) hparent = htiItemClicked;

	CString CFileFileName = m_pTreeCtrl->GetItemText(htiItemClicked);

	if(CFileFileName == "") return "";

	CString CModelFileNameType = m_pTreeCtrl->GetItemText(hparent);	

	int id = m_pTreeCtrl->GetItemData(hparent);

	if(id < 0) return "";

	id = CFileID.GetPageIndex(id);

	if(id < 0) return "";

	return CFileID.CPageIdData[id].CPageTitle;
}

void TCFileTreeView::RemoveFile(void)
{
	CString CFileName = GetFileName();

	if(CFileName == "") return;

	HTREEITEM htiItemClicked = m_pTreeCtrl->GetSelectedItem();

	if(!htiItemClicked) return;

	HTREEITEM	hparent;
	CString		CFileFolderName;

	hparent = m_pTreeCtrl->GetParentItem(htiItemClicked);

	if(!hparent) return;

	int id = m_pTreeCtrl->GetItemData(hparent);

	if(id < 0) return;

	id = CFileID.GetPageIndex(id);

	if(id < 0) return;

	CFileFolderName = CFileID.CPageIdData[id].CPageTitle;

	if(CFileFolderName == "") return;
	if(CFileFolderName == CFileName) return;

	TCSuperSpiceDoc *PCSuperSpiceDoc = FindDocument(CFileFolderName);

	if(!PCSuperSpiceDoc) return;

	CString CSubString = CFileFolderName;

	CSubString = m_pTreeCtrl->GetItemText(hparent);

	CSubString = RemoveExtention(CSubString);

	if(CFileName.Find(CSubString) < 0)// leave some key files always in the list
	{
		PCSuperSpiceDoc->CDocumentWindowsList.Remove(CFileName, false);

		Remove(htiItemClicked);
	}
}
