// TCFindModelDlg.cpp : implementation file
//

#include "stdafx.h"
#include "superspice.h"
#include "TCSuperSpiceDataBase.h"
#include "TCFindModelDlg.h"
#include "TCGeneralReportsTab.h"
#include "TCWorkspaceTree.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// TCFindModelDlg dialog

extern TCSuperSpiceDataBase GCSuperSpiceDataBase;
extern TCGeneralReportsTab GCGeneralReportsTab;
extern TCWorkspaceTree GCWorkspaceTree;


TCFindModelDlg::TCFindModelDlg(CWnd* pParent /*=NULL*/)
	: CDialog(TCFindModelDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(TCFindModelDlg)
	CMModelName = _T("");
	CMModelSelected = _T("");
	//}}AFX_DATA_INIT
}


void TCFindModelDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(TCFindModelDlg)
	DDX_Control(pDX, IDC_COMBO_MODEL_LIST, CMModelList);
	DDX_Text(pDX, IDC_EDIT_FIND_MODEL, CMModelName);
	DDX_CBString(pDX, IDC_COMBO_MODEL_LIST, CMModelSelected);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(TCFindModelDlg, CDialog)
	//{{AFX_MSG_MAP(TCFindModelDlg)
	ON_BN_CLICKED(IDC_BUTTON_FIND, OnButtonFind)
	ON_BN_CLICKED(IDC_BUTTON_PLACE, OnButtonPlace)
	ON_CBN_SELCHANGE(IDC_COMBO_MODEL_LIST, OnSelchangeComboModelList)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// TCFindModelDlg message handlers

void TCFindModelDlg::OnButtonFind() 
{
	UpdateData(true);

	if(!FindModel(CMModelName))
	{
		CMModelSelected.LoadString(IDS_NO_MODEL_MATCH_FOUND);
	}

	SetDisplay();
}

void TCFindModelDlg::SetDisplay(void)
{
	CMModelList.ResetContent();

	int count = CModelNames.GetSize();
	
	if(CMHandles.GetSize() != count) return;

	for(int p = 0; p < count; p++)
	{
		CMModelList.InsertString(-1, CModelNames[p]);
	}

	if(count) CMModelSelected = CModelNames[0];
	else CMModelSelected.LoadString(IDS_EMPTY_MODEL_SEARCH);

	UpdateData(false);
}

void TCFindModelDlg::OnButtonPlace() 
{
	UpdateData(true);

	SelectModel();

	if(!GCWorkspaceTree.PlaceModel()) return;

	OnOK();	
}

void TCFindModelDlg::SelectModel(void)
{
	int index = CMModelList.GetCurSel();

	if(index < 0) return;
	
	if(!(index < CMHandles.GetSize())) return;

	GCWorkspaceTree.SelectModel(CMHandles[index]);
}

BOOL TCFindModelDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	SetDisplay();
	
	return TRUE;
}

void TCFindModelDlg::OnSelchangeComboModelList() 
{
	SelectModel();
}


bool TCFindModelDlg::FindModel(CString CModelName)
{
	CString CMsg;

	CModelName.TrimLeft();
	CModelName.TrimRight();

	if(CModelName == "") return false;

	int count = GCSuperSpiceDataBase.FindModels(CModelName, CModelNames, CMHandles);

	if(!count)
	{
		GCGeneralReportsTab.DisplayMessage(IDS_EER_STATUS, IDS_NO_MODEL_MATCH_FOUND, -1);

		return false;
	}

	return true;
}

bool TCFindModelDlg::FindAndDisplayModel(CString CModelName)
{
	CString CMsg;

	CModelName.TrimLeft();
	CModelName.TrimRight();

	if(CModelName == "") return false;

	int count = GCSuperSpiceDataBase.FindModels(CModelName, CModelNames, CMHandles);

	if(!count)
	{
		GCGeneralReportsTab.DisplayMessage(IDS_EER_STATUS, IDS_NO_MODEL_MATCH_FOUND, -1);

		return false;
	}

	for(int p = 0; p < count; p++)
	{
		GCGeneralReportsTab.DisplayMessage(IDS_MODELS_FOUND, CModelNames[p], -1);		
	}

	GCWorkspaceTree.SelectModel(CMHandles[0]);

	return true;
}
