#include "stdafx.h"
#include "TDVersion.h"

#include "TCFloatingCursorData.h"
#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

IMPLEMENT_SERIAL(TCFloatingCursorData, CObject, ID_VERSION_NUMBER)


TCFloatingCursorData::TCFloatingCursorData(void)
{
	Zero();
	CSignalName;
	CSignalNameHeader	= "Signal: ";
	CRun				= "Nominal Run";

	PCGraphData = NULL;
	graph_start_index = 0;
	type = 0;
	xindex		 = 0;
	signal_index = 0;
	run_index	= 0;
	axis_index = 0;
	signal_type = 0;
	delta_y = 0;
	delta_x = 0;
	is_xindex = true;
	cursor2_active = false;
	PCSignalX = NULL;
	PCSignalY = NULL;
	y_not_found = true;
}

TCFloatingCursorData::TCFloatingCursorData(TCFloatingCursorData &CFloatingCursorData)
{
	*this = CFloatingCursorData;
}
TCFloatingCursorData::~TCFloatingCursorData(void)
{

}

void TCFloatingCursorData::Zero(void)
{
	dx = 0;
	dy = 0;
	x1 = 0;
	x2 = 0;
	y1 = 0;
	y2 = 0;

	CSignalName = "";
}

void TCFloatingCursorData::Serialize(CArchive& CArchiveFile)
{
	CObject::Serialize(CArchiveFile);

	if(CArchiveFile.IsStoring())
	{
		CArchiveFile <<	dx;
		CArchiveFile <<	dy;
		CArchiveFile <<	x1;
		CArchiveFile <<	x2;
		CArchiveFile <<	y1;
		CArchiveFile <<	y2;
		CArchiveFile <<	CSignalName;
		CArchiveFile <<	CSignalNameHeader;
		CArchiveFile << CRun;
		CArchiveFile << CSignalLocation;
		CArchiveFile << graph_start_index;
		CArchiveFile << xindex;
		CArchiveFile << signal_index;
		CArchiveFile << run_index;
		CArchiveFile << type;
		CArchiveFile << axis_index;
		CArchiveFile << signal_type;
		CArchiveFile << delta_y;
		CArchiveFile << delta_x;
		CArchiveFile << is_xindex;
		CArchiveFile << cursor2_active;
		CArchiveFile << y_not_found;
	}
	else
	{
		CArchiveFile >> dx;
		CArchiveFile >> dy;
		CArchiveFile >> x1;
		CArchiveFile >> x2;
		CArchiveFile >> y1;
		CArchiveFile >> y2;
		CArchiveFile >> CSignalName;
		CArchiveFile >> CSignalNameHeader;
		CArchiveFile >> CRun;
		CArchiveFile >> CSignalLocation;
		CArchiveFile >> graph_start_index;
		CArchiveFile >> xindex;
		CArchiveFile >> signal_index;
		CArchiveFile >> run_index;
		CArchiveFile >> type;
		CArchiveFile >> axis_index;
		CArchiveFile >> signal_type;
		CArchiveFile >> delta_y;
		CArchiveFile >> delta_x;
		CArchiveFile >> is_xindex;
		CArchiveFile >> cursor2_active;
		CArchiveFile >> y_not_found;
	}	
}

void TCFloatingCursorData::operator = (TCFloatingCursorData &CFloatingCursorData)
{
	dx	= CFloatingCursorData.dx;
	dy	= CFloatingCursorData.dy;
	x1	= CFloatingCursorData.x1;
	x2	= CFloatingCursorData.x2;
	y1	= CFloatingCursorData.y1;
	y2	= CFloatingCursorData.y2;
	CSignalName			= CFloatingCursorData.CSignalName;
	CSignalNameHeader	= CFloatingCursorData.CSignalNameHeader;
	CSignalLocation 	= CFloatingCursorData.CSignalLocation;
	PCGraphData			= CFloatingCursorData.PCGraphData;
	graph_start_index	= CFloatingCursorData.graph_start_index;
	xindex				= CFloatingCursorData.xindex;
	signal_index		= CFloatingCursorData.signal_index;
	run_index			= CFloatingCursorData.run_index;
	type				= CFloatingCursorData.type;
	axis_index 			= CFloatingCursorData.axis_index;
	signal_type			= CFloatingCursorData.signal_type;
	delta_y				= CFloatingCursorData.delta_y;
	delta_x				= CFloatingCursorData.delta_x;
	is_xindex			= CFloatingCursorData.is_xindex;
	cursor2_active		= CFloatingCursorData.cursor2_active;
	PCSignalY			= CFloatingCursorData.PCSignalY;
	PCSignalX			= CFloatingCursorData.PCSignalX;
	y_not_found			= CFloatingCursorData.y_not_found;
	CRun				= CFloatingCursorData.CRun;
}