#include "stdafx.h"
#include "resource.h"
#include "TCFileFunctions.h"
#include "TCStringFunctions.h"
#include "TCGeneralReportsTab.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


TCGeneralReportsTab::TCGeneralReportsTab()
{
	m_position		 = 0;
	m_max_line_count = 128;
	m_line_counter	 = 0;
	gmin_started	 = false;
	source_step_started = false;
	m_enable = false;

	CLineList.SetSize(m_max_line_count, m_max_line_count);
}

TCGeneralReportsTab::~TCGeneralReportsTab()
{

}

BEGIN_MESSAGE_MAP(TCGeneralReportsTab, CWnd)
	//{{AFX_MSG_MAP(TCGeneralReportsTab)
	ON_WM_ERASEBKGND()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

void TCGeneralReportsTab::ClearMessages(void)
{
	if(!m_enable) return;

	SetWindowText("");
	
	CLineList.SetSize(0, m_max_line_count);
	CLineList.SetSize(m_max_line_count, m_max_line_count);

	m_position		= 0;
	m_line_counter	= 0;	
}

void TCGeneralReportsTab::SetMaxNumberLines(int num_lines)
{
	if(!m_enable) return;

	if(num_lines < 1) m_max_line_count = num_lines;

	else m_max_line_count = num_lines;

	ClearMessages();
}

void TCGeneralReportsTab::Display(CString CText)
{	
	if(!m_enable) return;
	if(!(m_position < m_max_line_count))		m_position = 0;// should not happen
	if(!(m_line_counter < m_max_line_count))	m_line_counter = m_max_line_count;// should not happen

	CString CWindowText;
	CString CLineEnd;

	CLineEnd = "\r\n";

	CLineList[m_position] = CText + CLineEnd;

	int start = m_max_line_count - m_line_counter + m_position + 1;
	int stop = m_position + 1;

	int p;

	for(p = start; p < m_max_line_count; p++)
	{
		CWindowText += CLineList[p];
	}

	for(p = 0; p < stop; p++)
	{
		CWindowText += CLineList[p];
	}

	SetWindowText(CWindowText);

	m_position++;
	m_line_counter++;

	if(!(m_position < m_max_line_count))		m_position = 0;
	if(!(m_line_counter < m_max_line_count))	m_line_counter = m_max_line_count;

	LineScroll(m_line_counter);
}

void TCGeneralReportsTab::DisplayHeaderText(void)
{
	if(!m_enable) return;

	Display(IDS_HELP_HEADER_1);
	
	Display(" ");
	
	Display(IDS_HELP_HEADER_2);
		
	Display(IDS_HELP_HEADER_3);
	
	Display(IDS_HELP_HEADER_4);
	
	Display(IDS_HELP_HEADER_5);
	
	Display(IDS_HELP_HEADER_6);
	
	Display(IDS_HELP_HEADER_7);
	
	Display(IDS_HELP_HEADER_8);
	
	Display(IDS_HELP_HEADER_9);
	
	Display(IDS_HELP_HEADER_10);
	
	Display(IDS_HELP_HEADER_11);
	
	Display(IDS_HELP_HEADER_12);
	
	Display(IDS_HELP_HEADER_13);
	
	Display(IDS_HELP_HEADER_14);
	
	Display(IDS_HELP_HEADER_15);
	
	Display(IDS_HELP_HEADER_16);
		
	Display(IDS_HELP_HEADER_17);	
}

void TCGeneralReportsTab::Display(int text_id)
{
	if(!m_enable) return;

	CString CText;

	CText.LoadString(text_id);

	Display(CText);
}

void TCGeneralReportsTab::DisplayFile(CString CFileName, int log_file)
{
	if(!m_enable) return;

	CString CMsg;

	CMsg.LoadString(IDS_UNABLE_TO_OPEN_LOG_FILE);
		
	CMsg += ' ' + CFileName;

	if(!FileExists(CFileName))
	{	
		Display(CMsg);

		return;
	}
		
	TCIFStream	CFileStream;
	int			flags;

	flags = ios::in;
	CFileStream.text_file_mode = true;

//	CFileStream.text_file_mode = false;

	CFileStream.open(CFileName, flags);

	if(CFileStream.fail()) 
	{	
		Display(CMsg);

		return;
	}

	char *buff = new char[2048];

	if(!buff) return;

	int line_counter = 0;

	CString CTextLine;

	int length;

	while(!CFileStream.eof())
	{
		if(!(line_counter++ < 1048576)) 
		{
			ASSERT(0);

			return;//shouldnt happen
		}

		if(!CFileStream.ReadLine(buff, 2047)) 
		{
			break;
		}

		CTextLine = buff;

		length = CTextLine.GetLength();

		if(!length) continue;

		if(CTextLine.GetAt(length - 1) == '\r') CTextLine = CTextLine.Left(length - 1);

		if(log_file) CTextLine = ProccessLogFileLine(CTextLine, line_counter, log_file);

		if(CTextLine != "") Display(CTextLine);
	}

	if(log_file == TE_STATUS_REPORT_FILE_LOG)// must contain errors
	{
		if(line_counter < 4) 
		{
			CTextLine.LoadString(IDS_UNKNOWN_XSPICE_ERROR);

			Display(CTextLine);
		}
	}

	delete [] buff;
}

CString TCGeneralReportsTab::ProccessLogFileLine(CString CText, int line_number, int file_type)
{
	if(!m_enable) return "";

	if(file_type == TE_STATUS_REPORT_FILE_MSG) return CText;// display everything in the file

	CString CLineText;

	if(line_number == 1) // Redundant text
	{
		if(!(CText.Find("Running Spice Engine") < 0)) return "";
	}
	
	if(!(CText.Find("data wrote") < 0)) return "";// ignore keep alive output data


	if(!(CText.Find("starting Gmin stepping") < 0))  //only display "One successful Gmin step" once
	{
		gmin_started = 1;

		return CText;
	}

	if(!(CText.Find("One successful Gmin step") < 0))
	{
		if(gmin_started == 1)
		{
			gmin_started = 2;

			return CText;
		}

		return "";
	}

	if(!(CText.Find("starting source stepping") < 0))  //only display "One source stepping" once
	{
		source_step_started = 1;

		return CText;
	}

	if(!(CText.Find("One successful source step") < 0))
	{
		if(source_step_started == 1)
		{
			source_step_started = 2;

			return CText;
		}

		return "";
	}

	gmin_started = 0;
	source_step_started = 0;

	if(!(CText.Find("breakdown current increased") < 0)) return "";
	if(!(CText.Find("specified saturation current") < 0)) return "";

	CLineText = CText;

	return CLineText;
}

void TCGeneralReportsTab::DisplayLogFile(CString CFileName, int file_type)
{
	if(!m_enable) return;

	Display(IDS_XSPICE_LOG_FILE);

	DisplayFile(CFileName, file_type);

	Display(IDS_XSPICE_END_LOG_FILE);
}

void TCGeneralReportsTab::DisplayMessage(CString CDescription, CString CErrorMsg, int error_code)
{
	if(!m_enable) return;

	error_code;

	CString CText;

	CText = CDescription + ": " + CErrorMsg;

	Display(CText);
}

void TCGeneralReportsTab::DisplayMessage(UINT description, UINT msg, int error_code)
{
	if(!m_enable) return;

	error_code;

	CString CText, CDescription, CErrorMsg;

	CDescription.LoadString(description);
	CErrorMsg.LoadString(msg);

	CText = CDescription + ": " + CErrorMsg;

	Display(CText);
}

void TCGeneralReportsTab::DisplayMessage(UINT description,  CString CErrorMsg, int error_code)
{
	if(!m_enable) return;

	error_code;

	CString CText, CDescription;

	CDescription.LoadString(description);

	CText = CDescription + ": " + CErrorMsg;

	Display(CText);
}
