// TCGeneratorDCVoltDlg.cpp : implementation file
//

#include "stdafx.h"
#include "resource.h"
#include "TCMKSConvert.h"
#include "TESuperSpiceEnums.h"
#include "TESuperSpiceLabelEnums.h"
#include "TCSchematicObjectData.h"
#include "TCGeneratorDCVoltDlg.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

IMPLEMENT_DYNCREATE(TCGeneratorDCVoltDlg, CPropertyPage)

extern int	g_last_active_generator_property_page;


/////////////////////////////////////////////////////////////////////////////
// TCGeneratorDCVoltDlg property page

TCGeneratorDCVoltDlg::TCGeneratorDCVoltDlg() : CPropertyPage(TCGeneratorDCVoltDlg::IDD)
{
	//{{AFX_DATA_INIT(TCGeneratorDCVoltDlg)
	CMEditVolts1 = _T("");
	CMEditVolts2 = _T("");
	m_ac_phase_visable = FALSE;
	m_ac_visable = FALSE;
	m_dc_visable = FALSE;
	m_imd_f1_visable = FALSE;
	m_imd_f2_visable = FALSE;
	CMEditIMDF1 = _T("");
	CMEditIMDF2 = _T("");
	CMEditVolts3 = _T("");
	CMEditVolts4 = _T("");
	CMDCVoltage = _T("");
	CMACVoltage = _T("");
	CMACPhase = _T("");
	//}}AFX_DATA_INIT

	m_ac_phase = 1.0;
	m_ac_voltage = 1.0;
	m_dc_voltage = 1.0;
}

TCGeneratorDCVoltDlg::~TCGeneratorDCVoltDlg()
{
}

void TCGeneratorDCVoltDlg::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(TCGeneratorDCVoltDlg)
//	DDX_MKSValue(pDX, IDC_EDIT_AC_PHASE, m_ac_phase);
//	DDX_MKSValue(pDX, IDC_EDIT_AC_VOLTAGE, m_ac_voltage);
//	DDX_MKSValue(pDX, IDC_EDIT_DC_VOLTAGE, m_dc_voltage);
	DDX_Text(pDX, IDC_STATIC_VOLTS_CURRENT1, CMEditVolts1);
	DDX_Text(pDX, IDC_STATIC_VOLTS_CURRENT2, CMEditVolts2);
	DDX_Check(pDX, IDC_CHECK_AC_PHASE_VISABLE, m_ac_phase_visable);
	DDX_Check(pDX, IDC_CHECK_AC_VISABLE, m_ac_visable);
	DDX_Check(pDX, IDC_CHECK_DC_VISABLE, m_dc_visable);
	DDX_Check(pDX, IDC_CHECK_IMDF1_VISABLE, m_imd_f1_visable);
	DDX_Check(pDX, IDC_CHECK_IMDF2_VISABLE, m_imd_f2_visable);
	DDX_Text(pDX, IDC_EDIT_IMD_F1, CMEditIMDF1);
	DDX_Text(pDX, IDC_EDIT_IMD_F2, CMEditIMDF2);
	DDX_Text(pDX, IDC_STATIC_IMD1, CMEditVolts3);
	DDX_Text(pDX, IDC_STATIC_IMD2, CMEditVolts4);
	DDX_Text(pDX, IDC_EDIT_DC_VOLTAGE, CMDCVoltage);
	DDX_Text(pDX, IDC_EDIT_AC_VOLTAGE, CMACVoltage);
	DDX_Text(pDX, IDC_EDIT_AC_PHASE, CMACPhase);
	
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(TCGeneratorDCVoltDlg, CPropertyPage)
	//{{AFX_MSG_MAP(TCGeneratorDCVoltDlg)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

BOOL TCGeneratorDCVoltDlg::OnSetActive() 
{
	g_last_active_generator_property_page = 1;

	return CPropertyPage::OnSetActive();
}

BOOL TCGeneratorDCVoltDlg::OnKillActive() 
{
	int value =  CPropertyPage::OnKillActive();

	if(value)
	{
//		PCSchematicObjectData->PCGeneratorData->CDCGeneratorData.dc_voltage	= m_dc_voltage;
//		PCSchematicObjectData->PCGeneratorData->CDCGeneratorData.ac_voltage	= m_ac_voltage;
//		PCSchematicObjectData->PCGeneratorData->CDCGeneratorData.ac_phase	= m_ac_phase;

		PCSchematicObjectData->PCGeneratorData->CDCGeneratorData.dc_voltage	= MKSStringToFloat(CMDCVoltage);
		PCSchematicObjectData->PCGeneratorData->CDCGeneratorData.ac_voltage	= MKSStringToFloat(CMACVoltage);
		PCSchematicObjectData->PCGeneratorData->CDCGeneratorData.ac_phase	= MKSStringToFloat(CMACPhase);

		PCSchematicObjectData->PCGeneratorData->CDCGeneratorData.CDCVoltage = CMDCVoltage;
		PCSchematicObjectData->PCGeneratorData->CDCGeneratorData.CACVoltage = CMACVoltage;
		PCSchematicObjectData->PCGeneratorData->CDCGeneratorData.CACPhase   = CMACPhase;

		if(!(E_GENERATOR_PHASE_VALUE < PCSchematicObjectData->CLabelListData.GetSize())) return value;

		PCSchematicObjectData->CLabelListData[E_GENERATOR_AC_VALUE].is_visable		= !!m_ac_visable;
		PCSchematicObjectData->CLabelListData[E_GENERATOR_DC_VALUE].is_visable		= !!m_dc_visable;
		PCSchematicObjectData->CLabelListData[E_GENERATOR_PHASE_VALUE].is_visable	= !!m_ac_phase_visable;

		PCSchematicObjectData->CLabelListData[E_GENERATOR_AC_IMD1].is_visable = !!m_imd_f1_visable;
		PCSchematicObjectData->CLabelListData[E_GENERATOR_AC_IMD2].is_visable = !!m_imd_f2_visable;
		PCSchematicObjectData->CLabelListData[E_GENERATOR_AC_IMD1].CLabelValue = CMEditIMDF1;
		PCSchematicObjectData->CLabelListData[E_GENERATOR_AC_IMD2].CLabelValue = CMEditIMDF2;

		PCSchematicObjectData->FormatLabels();
	}
	return value;
}

BOOL TCGeneratorDCVoltDlg::OnInitDialog() 
{
//	m_dc_voltage = PCSchematicObjectData->PCGeneratorData->CDCGeneratorData.dc_voltage;
//	m_ac_voltage = PCSchematicObjectData->PCGeneratorData->CDCGeneratorData.ac_voltage;
//	m_ac_phase	 = PCSchematicObjectData->PCGeneratorData->CDCGeneratorData.ac_phase;

	CMDCVoltage = PCSchematicObjectData->PCGeneratorData->CDCGeneratorData.CDCVoltage;
	CMACVoltage = PCSchematicObjectData->PCGeneratorData->CDCGeneratorData.CACVoltage;
	CMACPhase   = PCSchematicObjectData->PCGeneratorData->CDCGeneratorData.CACPhase;

	if(E_GENERATOR_PHASE_VALUE < PCSchematicObjectData->CLabelListData.GetSize())
	{
		m_ac_visable		= PCSchematicObjectData->CLabelListData[E_GENERATOR_AC_VALUE].is_visable;
		m_dc_visable		= PCSchematicObjectData->CLabelListData[E_GENERATOR_DC_VALUE].is_visable;
		m_ac_phase_visable	= PCSchematicObjectData->CLabelListData[E_GENERATOR_PHASE_VALUE].is_visable;

		m_imd_f1_visable	= PCSchematicObjectData->CLabelListData[E_GENERATOR_AC_IMD1].is_visable;
		m_imd_f2_visable	= PCSchematicObjectData->CLabelListData[E_GENERATOR_AC_IMD2].is_visable;
		CMEditIMDF1			= PCSchematicObjectData->CLabelListData[E_GENERATOR_AC_IMD1].CLabelValue;
		CMEditIMDF2			= PCSchematicObjectData->CLabelListData[E_GENERATOR_AC_IMD2].CLabelValue;
	}
	CString CText;

	if(PCSchematicObjectData->version > E_SINGLE_FREQ_VOLTAGE_FM)
	{
		CText = "Amps";
	}
	else CText = "Volts";

	CMEditVolts1 = CText;
	CMEditVolts2 = CText;
	CMEditVolts3 = CText;
	CMEditVolts4 = CText;

	CPropertyPage::OnInitDialog();
	
	return TRUE; 	
}
