#include "stdafx.h"
#include "TDVersion.h"
#include "TESuperSpiceEnums.h"
#include "TCMKSConvert.h"
#include "TCSuperSpiceGlobalData.h"
#include "TCGeneratorData.h"
#include "resource.h"
#include "TCSuperSpiceDoc.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

UINT VERSION = 100; // useless peice of shit from M$

extern CString GGeneratorLoadVersion;
extern CString GGeneratorSaveVersion;

IMPLEMENT_SERIAL(TCGeneratorData, TCObject, VERSION)
IMPLEMENT_SERIAL(TCDCGeneratorData, CObject, VERSION)
IMPLEMENT_SERIAL(TCSineGeneratorData, CObject, VERSION)
IMPLEMENT_SERIAL(TCPulseGeneratorData, CObject, VERSION)
IMPLEMENT_SERIAL(TCExponentialGeneratorData, CObject, VERSION)
IMPLEMENT_SERIAL(TCPWLGeneratorData, CObject, VERSION)
IMPLEMENT_SERIAL(TCSFFMGeneratorData, CObject, VERSION)


TCSFFMGeneratorData::TCSFFMGeneratorData(void)
{
	offset				= 0;
	carrier_magnitude	= 1;
	carrier_frequency	= 1e6;
	modulation_index	= 0.5;
	modulation_frequency= 1e3;
}
TCSFFMGeneratorData::TCSFFMGeneratorData(TCSFFMGeneratorData &CSFFMGeneratorData)
{
	*this = CSFFMGeneratorData;
}
TCSFFMGeneratorData::~TCSFFMGeneratorData(void)
{

}

void TCSFFMGeneratorData::Serialize(CArchive& CArchiveFile)
{
	CObject::Serialize(CArchiveFile);

	if(CArchiveFile.IsStoring())
	{
		if(GGeneratorSaveVersion == '1')
		{
			CArchiveFile << offset;
			CArchiveFile << carrier_magnitude;
			CArchiveFile << carrier_frequency;
			CArchiveFile << modulation_index;
			CArchiveFile << modulation_frequency;
		}
		else
		{
			CArchiveFile << COffset;
			CArchiveFile << CCarrierMagnitude;
			CArchiveFile << CCarrierFrequency;
			CArchiveFile << CModulationIndex;
			CArchiveFile << CModulationFrequency;
		}
	}
	else
	{
		if(GGeneratorLoadVersion == '1')
		{
			CArchiveFile >> offset;
			CArchiveFile >> carrier_magnitude;
			CArchiveFile >> carrier_frequency;
			CArchiveFile >> modulation_index;
			CArchiveFile >> modulation_frequency;

			ConvertVersion();
		}
		else
		{
			CArchiveFile >> COffset;
			CArchiveFile >> CCarrierMagnitude;
			CArchiveFile >> CCarrierFrequency;
			CArchiveFile >> CModulationIndex;
			CArchiveFile >> CModulationFrequency;
		}
	}
}
void TCSFFMGeneratorData::operator = (TCSFFMGeneratorData &CSFFMGeneratorData)
{
	offset				= CSFFMGeneratorData.offset;
	carrier_magnitude	= CSFFMGeneratorData.carrier_magnitude;
	carrier_frequency	= CSFFMGeneratorData.carrier_frequency;
	modulation_index	= CSFFMGeneratorData.modulation_index;
	modulation_frequency= CSFFMGeneratorData.modulation_frequency;

	COffset				= CSFFMGeneratorData.COffset; 
	CCarrierMagnitude	= CSFFMGeneratorData.CCarrierMagnitude;
	CCarrierFrequency	= CSFFMGeneratorData.CCarrierFrequency;
    CModulationIndex	= CSFFMGeneratorData.CModulationIndex;
	CModulationFrequency =CSFFMGeneratorData.CModulationFrequency;

}

CString  TCSFFMGeneratorData::GetAllSpiceValues(void)
{
	CString CSpiceValues;
	CString CSpace = ' ';

	CSpiceValues = COffset + CSpace + CCarrierMagnitude + CSpace + CCarrierFrequency + CSpace + CModulationIndex + CSpace + CModulationFrequency;

	return CSpiceValues;
}

void TCSFFMGeneratorData::ConvertVersion(void)
{
	COffset				= FloatToMKSString(offset);
	CCarrierMagnitude	= FloatToMKSString(carrier_magnitude);
	CCarrierFrequency	= FloatToMKSString(carrier_frequency);
	CModulationIndex		= FloatToMKSString(modulation_index);
	CModulationFrequency	= FloatToMKSString(modulation_frequency);
}

CString TCSFFMGeneratorData::Format(TCSuperSpiceDoc *PCDoc)
{
	CString CText;

	if(!PCDoc)
	{
		CText = "SFFM " + FloatToSpiceMKSString(offset) + " " +
		    FloatToSpiceMKSString(carrier_magnitude) + " " +
			FloatToSpiceMKSString(carrier_frequency) + " " +
			FloatToSpiceMKSString(modulation_index) + " " +
			FloatToSpiceMKSString(modulation_frequency);

		return CText;
	}

	CText = "SFFM " + FloatToSpiceMKSString(PCDoc->EvaluateComponentValue(COffset)) + " " +
		    FloatToSpiceMKSString(PCDoc->EvaluateComponentValue(CCarrierMagnitude)) + " " +
			FloatToSpiceMKSString(PCDoc->EvaluateComponentValue(CCarrierFrequency)) + " " +
			FloatToSpiceMKSString(PCDoc->EvaluateComponentValue(CModulationIndex)) + " " +
			FloatToSpiceMKSString(PCDoc->EvaluateComponentValue(CModulationFrequency));


	return CText;
}

//////////////////////////////
TCPWLGeneratorData::TCPWLGeneratorData(void)
{
	index		= 0;
}
TCPWLGeneratorData::TCPWLGeneratorData(TCPWLGeneratorData &CPWLGeneratorData)
{
	*this = CPWLGeneratorData;
}
TCPWLGeneratorData::~TCPWLGeneratorData(void)
{

}

void TCPWLGeneratorData::Serialize(CArchive& CArchiveFile)
{
	CObject::Serialize(CArchiveFile);

	CData.Serialize(CArchiveFile);

	if(CArchiveFile.IsStoring())
	{
		CArchiveFile << index;
	}
	else
	{
		CArchiveFile >> index;
	}
}
void TCPWLGeneratorData::operator = (TCPWLGeneratorData &CPWLGeneratorData)
{
	index		= CPWLGeneratorData.index;
	CData		= CPWLGeneratorData.CData;
}

CString TCPWLGeneratorData::Format(TCSuperSpiceDoc *PCDoc)
{
	CString CText, CText1;
	int p, count;
	PCDoc; // {} not supported for PWL

	CText1 = "PWL";

	count = CData.CList.GetSize();

	for(p = 0; p < count; p++)
	{
		CText = " " + FloatToSpiceMKSString(CData.CList[p].x) +
			    " " + FloatToSpiceMKSString(CData.CList[p].y);

		CText1 += CText;
	}

	return CText1;
}
////////////////////////////////////
TCExponentialGeneratorData::TCExponentialGeneratorData(void)
{
	start		= 0;
	end			= 0;
	delay1		= 10;
	rise_time1	= 1u;
	delay2		= 0;
	rise_time2	= 1u;
}
TCExponentialGeneratorData::TCExponentialGeneratorData(TCExponentialGeneratorData &CExponentialGeneratorData)
{
	*this = CExponentialGeneratorData;
}
TCExponentialGeneratorData::~TCExponentialGeneratorData(void)
{

}

void TCExponentialGeneratorData::Serialize(CArchive& CArchiveFile)
{
	CObject::Serialize(CArchiveFile);

	if(CArchiveFile.IsStoring())
	{
		if(GGeneratorSaveVersion == '1')
		{
			CArchiveFile << start;
			CArchiveFile << end;
			CArchiveFile << delay1;
			CArchiveFile << rise_time1;
			CArchiveFile << delay2;
			CArchiveFile << rise_time2;
		}
		else
		{
			CArchiveFile << CStart; 
			CArchiveFile << CEnd;
			CArchiveFile << CDelay1;
			CArchiveFile << CRiseTime1;
			CArchiveFile << CDelay2;
			CArchiveFile << CRiseTime2;
		}
	}
	else
	{
		if(GGeneratorLoadVersion == '1')
		{
			CArchiveFile >> start;
			CArchiveFile >> end;
			CArchiveFile >> delay1;
			CArchiveFile >> rise_time1;
			CArchiveFile >> delay2;
			CArchiveFile >> rise_time2;

			ConvertVersion();
		}
		else
		{
			CArchiveFile >> CStart; 
			CArchiveFile >> CEnd;
			CArchiveFile >> CDelay1;
			CArchiveFile >> CRiseTime1;
			CArchiveFile >> CDelay2;
			CArchiveFile >> CRiseTime2;
		}
	}
}
void TCExponentialGeneratorData::operator = (TCExponentialGeneratorData &CExponentialGeneratorData)
{
	start		= CExponentialGeneratorData.start;
	end			= CExponentialGeneratorData.end;
	delay1		= CExponentialGeneratorData.delay1;
	rise_time1	= CExponentialGeneratorData.rise_time1;
	delay2		= CExponentialGeneratorData.delay2;
	rise_time2	= CExponentialGeneratorData.rise_time2;

	CStart		= CExponentialGeneratorData.CStart; 
	CEnd		= CExponentialGeneratorData.CEnd; 
	CDelay1		= CExponentialGeneratorData.CDelay1; 
	CRiseTime1	= CExponentialGeneratorData.CRiseTime1; 
	CDelay2		= CExponentialGeneratorData.CDelay2; 
	CRiseTime2	= CExponentialGeneratorData.CRiseTime2; 
}
CString  TCExponentialGeneratorData::GetAllSpiceValues(void)
{
	CString CSpiceValues;

	CString CSpace = ' ';

	CSpiceValues = CStart + CSpace + CEnd + CSpace + CDelay1 + CSpace + CRiseTime1 + CSpace + CDelay2 + CSpace + CRiseTime2;

	return CSpiceValues;
}
void TCExponentialGeneratorData::ConvertVersion(void)
{		
	CStart		= FloatToMKSString(start); 
	CEnd		= FloatToMKSString(end); 
	CDelay1		= FloatToMKSString(delay1); 
	CRiseTime1	= FloatToMKSString(rise_time1); 
	CDelay2		= FloatToMKSString(delay2); 
	CRiseTime2	= FloatToMKSString(rise_time2); 
}

CString TCExponentialGeneratorData::Format(TCSuperSpiceDoc *PCDoc)
{
	CString CText = "EXP ";

	if(!PCDoc)
	{
		CText = CText + FloatToSpiceMKSString(start) + " " +
			FloatToSpiceMKSString(end) + " " +
			FloatToSpiceMKSString(delay1) + " " +
			FloatToSpiceMKSString(rise_time1) + " " +
			FloatToSpiceMKSString(delay2) + " " +
			FloatToSpiceMKSString(rise_time2);

		return CText;
	}

	CText = CText + FloatToSpiceMKSString(PCDoc->EvaluateComponentValue(CStart)) + " " +
			FloatToSpiceMKSString(PCDoc->EvaluateComponentValue(CEnd)) + " " +
			FloatToSpiceMKSString(PCDoc->EvaluateComponentValue(CDelay1)) + " " +
			FloatToSpiceMKSString(PCDoc->EvaluateComponentValue(CRiseTime1)) + " " +
			FloatToSpiceMKSString(PCDoc->EvaluateComponentValue(CDelay2)) + " " +
			FloatToSpiceMKSString(PCDoc->EvaluateComponentValue(CRiseTime2));

	return CText;
}
//////////////////////////////////////
TCPulseGeneratorData::TCPulseGeneratorData(void)
{
	start	= 0;
	end		= 10;
	delay	= 0;
	rise	= 1u;
	fall	= 1u;
	width	= 48u;
	period	= 100;
}
TCPulseGeneratorData::TCPulseGeneratorData(TCPulseGeneratorData &CPulseGeneratorData)
{
	*this = CPulseGeneratorData;
}
TCPulseGeneratorData::~TCPulseGeneratorData(void)
{

}

void TCPulseGeneratorData::Serialize(CArchive& CArchiveFile)
{
	CObject::Serialize(CArchiveFile);

	if(CArchiveFile.IsStoring())
	{
		if(GGeneratorSaveVersion == '1')
		{
			CArchiveFile << start;
			CArchiveFile << end;
			CArchiveFile << delay;
			CArchiveFile << rise;
			CArchiveFile << fall;
			CArchiveFile << width;
			CArchiveFile << period;
		}
		else
		{
			CArchiveFile << CStart;
			CArchiveFile << CEnd;
			CArchiveFile << CDelay;
			CArchiveFile << CRise;
			CArchiveFile << CFall;
			CArchiveFile << CWidth;
			CArchiveFile << CPeriod;
		}
	}
	else
	{
		if(GGeneratorLoadVersion == '1')
		{
			CArchiveFile >> start;
			CArchiveFile >> end;
			CArchiveFile >> delay;
			CArchiveFile >> rise;
			CArchiveFile >> fall;
			CArchiveFile >> width;
			CArchiveFile >> period;

			ConvertVersion();
		}
		else
		{
			CArchiveFile >> CStart;
			CArchiveFile >> CEnd;
			CArchiveFile >> CDelay;
			CArchiveFile >> CRise;
			CArchiveFile >> CFall;
			CArchiveFile >> CWidth;
			CArchiveFile >> CPeriod;
		}
	}
}
void TCPulseGeneratorData::operator = (TCPulseGeneratorData &CPulseGeneratorData)
{
	start	= CPulseGeneratorData.start;
	end		= CPulseGeneratorData.end;
	delay	= CPulseGeneratorData.delay;
	rise	= CPulseGeneratorData.rise;
	fall	= CPulseGeneratorData.fall;
	width	= CPulseGeneratorData.width;
	period	= CPulseGeneratorData.period;

	CStart	= CPulseGeneratorData.CStart;
	CEnd	= CPulseGeneratorData.CEnd;
	CDelay	= CPulseGeneratorData.CDelay;
	CRise	= CPulseGeneratorData.CRise;
	CFall	= CPulseGeneratorData.CFall;
	CWidth	= CPulseGeneratorData.CWidth;
	CPeriod	= CPulseGeneratorData.CPeriod;
}
CString  TCPulseGeneratorData::GetAllSpiceValues(void)
{
	CString CSpiceValues;

	CString CSpace = ' ';

	CSpiceValues = CStart + CSpace + CEnd + CSpace + CDelay + CSpace + CRise + CSpace + CFall + CSpace + CWidth + CSpace + CPeriod;

	return CSpiceValues;
}
void TCPulseGeneratorData::ConvertVersion(void)
{

	CStart	= FloatToMKSString(start);
	CEnd	= FloatToMKSString(end);
	CDelay	= FloatToMKSString(delay);
	CRise	= FloatToMKSString(rise);
	CFall	= FloatToMKSString(fall);
	CWidth	= FloatToMKSString(width);
	CPeriod	= FloatToMKSString(period);
}

CString TCPulseGeneratorData::Format(TCSuperSpiceDoc *PCDoc)
{
	CString CText;

	if(!PCDoc)
	{
		CText = "PULSE " + FloatToSpiceMKSString(start) + " " +
			FloatToSpiceMKSString(end) + " " +
			FloatToSpiceMKSString(delay) + " " +
			FloatToSpiceMKSString(rise) + " " +
			FloatToSpiceMKSString(fall) + " " +
			FloatToSpiceMKSString(width) + " " +
			FloatToSpiceMKSString(period);
		
			return CText;
	}

	CText = "PULSE " + FloatToSpiceMKSString(PCDoc->EvaluateComponentValue(CStart)) + " " +
			FloatToSpiceMKSString(PCDoc->EvaluateComponentValue(CEnd)) + " " +
			FloatToSpiceMKSString(PCDoc->EvaluateComponentValue(CDelay)) + " " +
			FloatToSpiceMKSString(PCDoc->EvaluateComponentValue(CRise)) + " " +
			FloatToSpiceMKSString(PCDoc->EvaluateComponentValue(CFall)) + " " +
			FloatToSpiceMKSString(PCDoc->EvaluateComponentValue(CWidth)) + " " +
			FloatToSpiceMKSString(PCDoc->EvaluateComponentValue(CPeriod));

	return CText;
}
///////////////////////////////
////////////////////////////////
TCSineGeneratorData::TCSineGeneratorData(void)
{
	offset		= 0;
	amplitude	= 1;
	frequency	= 1e3;
	delay		= 0;
	damping		= 0;
}
TCSineGeneratorData::TCSineGeneratorData(TCSineGeneratorData &CSineGeneratorData)
{
	*this = CSineGeneratorData;
}
TCSineGeneratorData::~TCSineGeneratorData(void)
{

}

void TCSineGeneratorData::Serialize(CArchive& CArchiveFile)
{
	CObject::Serialize(CArchiveFile);

	if(CArchiveFile.IsStoring())
	{
		if(GGeneratorSaveVersion == '1')
		{
			CArchiveFile << offset;
			CArchiveFile << amplitude;
			CArchiveFile << frequency;
			CArchiveFile << delay;
			CArchiveFile << damping;
		}
		else
		{
			CArchiveFile << COffset;
			CArchiveFile << CAmplitude;
			CArchiveFile << CFrequency;
			CArchiveFile << CDelay;
			CArchiveFile << CDamping;
		}
	}
	else
	{
		if(GGeneratorLoadVersion == '1')
		{
			CArchiveFile >> offset;
			CArchiveFile >> amplitude;
			CArchiveFile >> frequency;
			CArchiveFile >> delay;
			CArchiveFile >> damping;

			ConvertVersion();
		}
		else
		{
			CArchiveFile >> COffset;
			CArchiveFile >> CAmplitude;
			CArchiveFile >> CFrequency;
			CArchiveFile >> CDelay;
			CArchiveFile >> CDamping;
		}
	}
}
void TCSineGeneratorData::operator = (TCSineGeneratorData &CSineGeneratorData)
{
	offset		= CSineGeneratorData.offset;
	amplitude	= CSineGeneratorData.amplitude;
	frequency	= CSineGeneratorData.frequency;
	delay		= CSineGeneratorData.delay;
	damping		= CSineGeneratorData.damping;

	COffset		= CSineGeneratorData.COffset;
	CAmplitude	= CSineGeneratorData.CAmplitude;
	CFrequency	= CSineGeneratorData.CFrequency;
	CDelay		= CSineGeneratorData.CDelay;
	CDamping	= CSineGeneratorData.CDamping;
}
CString  TCSineGeneratorData::GetAllSpiceValues(void)
{
	CString CSpiceValues;

	CString CSpace = ' ';

	CSpiceValues = COffset + CSpace + CAmplitude + CSpace + CFrequency + CSpace + CDelay + CSpace + CDamping;

	return CSpiceValues;
}
void TCSineGeneratorData::ConvertVersion(void)
{
	COffset		= FloatToMKSString(offset);
	CAmplitude	= FloatToMKSString(amplitude);
	CFrequency	= FloatToMKSString(frequency);
	CDelay		= FloatToMKSString(delay);
	CDamping	= FloatToMKSString(damping);
}

CString TCSineGeneratorData::Format(TCSuperSpiceDoc *PCDoc)
{
	CString CText;

	if(!PCDoc)
	{
		CText = "SIN " + FloatToSpiceMKSString(offset) + " " +
			FloatToSpiceMKSString(amplitude) + " " +
			FloatToSpiceMKSString(frequency) + " " +
			FloatToSpiceMKSString(delay) + " " +
			FloatToSpiceMKSString(damping);

		return CText;
	}

	CText = "SIN " + FloatToSpiceMKSString(PCDoc->EvaluateComponentValue(COffset)) + " " +
			FloatToSpiceMKSString(PCDoc->EvaluateComponentValue(CAmplitude)) + " " +
			FloatToSpiceMKSString(PCDoc->EvaluateComponentValue(CFrequency)) + " " +
			FloatToSpiceMKSString(PCDoc->EvaluateComponentValue(CDelay)) + " " +
			FloatToSpiceMKSString(PCDoc->EvaluateComponentValue(CDamping));

	return CText;
}
///////////////////////////////
TCDCGeneratorData::TCDCGeneratorData(void)
{
	dc_voltage	= 1;
	ac_voltage	= 1;
	ac_phase	= 0;
}
TCDCGeneratorData::TCDCGeneratorData(TCDCGeneratorData &CDCGeneratorData)
{
	*this = CDCGeneratorData;
}
TCDCGeneratorData::~TCDCGeneratorData(void)
{

}

void TCDCGeneratorData::Serialize(CArchive& CArchiveFile)
{
	CObject::Serialize(CArchiveFile);

	if(CArchiveFile.IsStoring())
	{
		if(GGeneratorSaveVersion == '1')
		{
			CArchiveFile << dc_voltage;
			CArchiveFile << ac_voltage;
			CArchiveFile << ac_phase;
		}
		else
		{
			CArchiveFile << CDCVoltage;
			CArchiveFile << CACVoltage;
			CArchiveFile << CACPhase;
		}
	}
	else
	{
		if(GGeneratorLoadVersion == '1')
		{
			CArchiveFile >> dc_voltage;
			CArchiveFile >> ac_voltage;
			CArchiveFile >> ac_phase;

			ConvertVersion();
		}
		else
		{
			CArchiveFile >> CDCVoltage;
			CArchiveFile >> CACVoltage;
			CArchiveFile >> CACPhase;
		}
	}
}
void TCDCGeneratorData::operator = (TCDCGeneratorData &CDCGeneratorData)
{
	dc_voltage	= CDCGeneratorData.dc_voltage;
	ac_voltage	= CDCGeneratorData.ac_voltage;
	ac_phase	= CDCGeneratorData.ac_phase;

	CDCVoltage	= CDCGeneratorData.CDCVoltage;
	CACVoltage	= CDCGeneratorData.CACVoltage;
	CACPhase	= CDCGeneratorData.CACPhase;
}
CString  TCDCGeneratorData::GetAllSpiceValues(void)
{
	CString CSpiceValues;

	CString CSpace = ' ';

	CSpiceValues = CDCVoltage + CSpace + CACVoltage + CSpace + CACPhase;

	return CSpiceValues;
}

void TCDCGeneratorData::ConvertVersion(void)
{
	CDCVoltage	= FloatToMKSString(dc_voltage);
	CACVoltage	= FloatToMKSString(ac_voltage);
	CACPhase	= FloatToMKSString(ac_phase);
}

CString TCDCGeneratorData::Format(TCSuperSpiceDoc *PCDoc, int loop_gain)
{
	CString CText, CText1, CText2, CText3;

	if(!PCDoc)
		CText1 = "DC " + CDCVoltage; //FloatToSpiceMKSString(dc_voltage);
	else
	{
		CText1 = "DC " + FloatToSpiceMKSString(PCDoc->EvaluateComponentValue(CDCVoltage));
	}

	if(CDCVoltage != "")
	{
		if(!PCDoc)
			CText2 = " AC " + CACVoltage; // FloatToSpiceMKSString(ac_voltage);
		else
		{
			if(!loop_gain)
			{
				CText2 = " AC " + FloatToSpiceMKSString(PCDoc->EvaluateComponentValue(CACVoltage));
			}
			else
			{
				CText2 = " AC 0";
			}
		}

		if(CACPhase != "" && !loop_gain)
		{
			if(!PCDoc)
				CText3 = " " + CACPhase;// FloatToSpiceMKSString(ac_phase);
			else
				CText3 = " " + FloatToSpiceMKSString(PCDoc->EvaluateComponentValue(CACPhase));
		}
	}

	CText = CText1 + CText2 + CText3;

	return CText;
}
////////////////////////////

TCGeneratorData::TCGeneratorData(void)
{
	version = 0;
}
TCGeneratorData::TCGeneratorData(TCGeneratorData &CGeneratorData)
{
	*this = CGeneratorData;
}
TCGeneratorData::~TCGeneratorData(void)
{
	
}

void TCGeneratorData::Serialize(CArchive& CArchiveFile)
{
	CObject::Serialize(CArchiveFile);
	CDCGeneratorData.Serialize(CArchiveFile);
	CSineGeneratorData.Serialize(CArchiveFile);
	CPulseGeneratorData.Serialize(CArchiveFile);
	CExponentialGeneratorData.Serialize(CArchiveFile);
	CPWLGeneratorData.Serialize(CArchiveFile);
	CSFFMGeneratorData.Serialize(CArchiveFile);

	if(CArchiveFile.IsStoring())
	{
		CArchiveFile << version;
	}
	else
	{
		CArchiveFile >> version;
	}
}
void TCGeneratorData::operator = (TCGeneratorData &CGeneratorData)
{
	version						= CGeneratorData.version;
	CDCGeneratorData			= CGeneratorData.CDCGeneratorData;
	CSineGeneratorData			= CGeneratorData.CSineGeneratorData;
	CPulseGeneratorData			= CGeneratorData.CPulseGeneratorData;
	CExponentialGeneratorData	= CGeneratorData.CExponentialGeneratorData;
	CPWLGeneratorData			= CGeneratorData.CPWLGeneratorData;
	CSFFMGeneratorData			= CGeneratorData.CSFFMGeneratorData;
}

CString  TCGeneratorData::GetAllSpiceValues(void)
{	
	CString CText1;
	CString CText2;

	switch(version)
	{
		case E_DC_VOLTAGE_SOURCE:				CText2 = CDCGeneratorData.GetAllSpiceValues(); break;
		case E_SINE_VOLTAGE_SOURCE:				CText2 = CSineGeneratorData.GetAllSpiceValues(); break;
		case E_PULSE_VOLTAGE_SOURCE:			CText2 = CPulseGeneratorData.GetAllSpiceValues(); break;
		case E_EXPONENTIAL_VOLTAGE_SOURCE:		CText2 = CExponentialGeneratorData.GetAllSpiceValues(); break;
//		case E_PIECEWISE_LINEAR_VOLTAGE_SOURCE:	CText2 = CPWLGeneratorData.GetAllSpiceValues(); break;
		case E_SINGLE_FREQ_VOLTAGE_FM:			CText2 = CSFFMGeneratorData.GetAllSpiceValues(); break;
		case E_DC_CURRENT_SOURCE:				CText2 = CDCGeneratorData.GetAllSpiceValues(); break;
		case E_SINE_CURRENT_SOURCE:				CText2 = CSineGeneratorData.GetAllSpiceValues(); break;
		case E_PULSE_CURRENT_SOURCE:			CText2 = CPulseGeneratorData.GetAllSpiceValues(); break;
		case E_EXPONENTIAL_CURRENT_SOURCE:		CText2 = CExponentialGeneratorData.GetAllSpiceValues(); break;
//		case E_PIECEWISE_LINEAR_CURRENT_SOURCE:	CText2 = CPWLGeneratorData.GetAllSpiceValues(); break;
		case E_SINGLE_FREQ_CURRENT_FM:			CText2 = CSFFMGeneratorData.GetAllSpiceValues(); break;

		default: return "";
	}

	if(version != E_DC_VOLTAGE_SOURCE && version != E_DC_CURRENT_SOURCE)
	{
		CText1 = CDCGeneratorData.GetAllSpiceValues() + " " + CText2;

		return CText1;
	}
	else
	{
		return CText2;
	}
}

CString TCGeneratorData::Format(TCSuperSpiceDoc *PCDoc, int loop_gain)
{
	CString CText1;
	CString CText2;

	switch(version)
	{
		case E_DC_VOLTAGE_SOURCE:				CText2 = CDCGeneratorData.Format(PCDoc, loop_gain); break;
		case E_SINE_VOLTAGE_SOURCE:				CText2 = CSineGeneratorData.Format(PCDoc); break;
		case E_PULSE_VOLTAGE_SOURCE:			CText2 = CPulseGeneratorData.Format(PCDoc); break;
		case E_EXPONENTIAL_VOLTAGE_SOURCE:		CText2 = CExponentialGeneratorData.Format(PCDoc); break;
		case E_PIECEWISE_LINEAR_VOLTAGE_SOURCE:	CText2 = CPWLGeneratorData.Format(PCDoc); break;
		case E_SINGLE_FREQ_VOLTAGE_FM:			CText2 = CSFFMGeneratorData.Format(PCDoc); break;
		case E_DC_CURRENT_SOURCE:				CText2 = CDCGeneratorData.Format(PCDoc, loop_gain); break;
		case E_SINE_CURRENT_SOURCE:				CText2 = CSineGeneratorData.Format(PCDoc); break;
		case E_PULSE_CURRENT_SOURCE:			CText2 = CPulseGeneratorData.Format(PCDoc); break;
		case E_EXPONENTIAL_CURRENT_SOURCE:		CText2 = CExponentialGeneratorData.Format(PCDoc); break;
		case E_PIECEWISE_LINEAR_CURRENT_SOURCE:	CText2 = CPWLGeneratorData.Format(PCDoc); break;
		case E_SINGLE_FREQ_CURRENT_FM:			CText2 = CSFFMGeneratorData.Format(PCDoc); break;
	}

	if(version != E_DC_VOLTAGE_SOURCE && version != E_DC_CURRENT_SOURCE)
	{
		CText1 = CDCGeneratorData.Format(PCDoc, loop_gain) + " " + CText2;

		return CText1;
	}
	else
	{
		return CText2;
	}
}

bool TCGeneratorData::IsVailidTransientSetup(void)
{
	switch(version)
	{
		case E_DC_CURRENT_SOURCE:
		case E_DC_VOLTAGE_SOURCE:				return false;

		case E_SINE_CURRENT_SOURCE:
		case E_SINE_VOLTAGE_SOURCE:				
												if(CSineGeneratorData.frequency <= 0) return false;
												return true;

		case E_PULSE_CURRENT_SOURCE:
		case E_PULSE_VOLTAGE_SOURCE:			
												if((CPulseGeneratorData.fall + CPulseGeneratorData.rise + CPulseGeneratorData.width) > CPulseGeneratorData.period) return false;
												return true;

		case E_EXPONENTIAL_CURRENT_SOURCE:		 
		case E_EXPONENTIAL_VOLTAGE_SOURCE:		 
												return true;

		case E_SINGLE_FREQ_CURRENT_FM:			 
		case E_SINGLE_FREQ_VOLTAGE_FM:			 
												if(CSFFMGeneratorData.carrier_frequency <= 0) return false;
												if(CSFFMGeneratorData.modulation_frequency <= 0) return false;
												return true;
		
		case E_PIECEWISE_LINEAR_CURRENT_SOURCE:	 
		case E_PIECEWISE_LINEAR_VOLTAGE_SOURCE:	 
												if(CPWLGeneratorData.CData.CList.GetSize() < 2) return false;
												return true;// more to do
		

	}

	return true;
}