
#ifndef _TCGeneratorData_H
#define _TCGeneratorData_H

#include <afxtempl.h>
#include "TCObject.h"
#include "TCXYArray.h"

class TCSuperSpiceDoc;

class TCSFFMGeneratorData : public CObject
{
	public:	TCSFFMGeneratorData(void);
			TCSFFMGeneratorData(TCSFFMGeneratorData &CSFFMGeneratorData);
			~TCSFFMGeneratorData(void);

			double offset;
			double carrier_magnitude;
			double carrier_frequency;
			double modulation_index;
			double modulation_frequency;

			CString COffset;
			CString CCarrierMagnitude;
			CString CCarrierFrequency;
			CString CModulationIndex;
			CString CModulationFrequency;

			void ConvertVersion(void);

			CString Format(TCSuperSpiceDoc *PCDoc);
			CString GetAllSpiceValues(void);

			void operator = (TCSFFMGeneratorData &CSFFMGeneratorData);
	
			void Serialize(CArchive& CArchiveFile);

			DECLARE_SERIAL(TCSFFMGeneratorData)

};

class TCPWLGeneratorData : public CObject
{
	public:	TCPWLGeneratorData(void);
			TCPWLGeneratorData(TCPWLGeneratorData &CPWLGeneratorData);
			~TCPWLGeneratorData(void);

			TCXYArrayList CData;
			int			index;

			CString Format(TCSuperSpiceDoc *PCDoc);
			CString GetAllSpiceValues(void);

			void operator = (TCPWLGeneratorData &CPWLGeneratorData);
	
			void Serialize(CArchive& CArchiveFile);

			DECLARE_SERIAL(TCPWLGeneratorData)

};

class TCExponentialGeneratorData : public CObject
{
	public:	TCExponentialGeneratorData(void);
			TCExponentialGeneratorData(TCExponentialGeneratorData &CExponentialGeneratorData);
			~TCExponentialGeneratorData(void);

			double start;
			double end;
			double delay1;
			double rise_time1;
			double delay2;
			double rise_time2;

			CString CStart; 
			CString CEnd;
			CString CDelay1;
			CString CRiseTime1;
			CString CDelay2;
			CString CRiseTime2;

			void ConvertVersion(void);

			CString Format(TCSuperSpiceDoc *PCDoc);
			CString GetAllSpiceValues(void);

			void operator = (TCExponentialGeneratorData &CExponentialGeneratorData);
	
			void Serialize(CArchive& CArchiveFile);

			DECLARE_SERIAL(TCExponentialGeneratorData)

};

class TCPulseGeneratorData : public CObject
{
	public:	TCPulseGeneratorData(void);
			TCPulseGeneratorData(TCPulseGeneratorData &CPulseGeneratorData);
			~TCPulseGeneratorData(void);

			double start;
			double end;
			double delay;
			double rise;
			double fall;
			double width;
			double period;

			CString CStart;
			CString CEnd;
			CString CDelay;
			CString CRise;
			CString CFall;
			CString CWidth;
			CString CPeriod;

			void ConvertVersion(void);

			CString Format(TCSuperSpiceDoc *PCDoc);
			CString GetAllSpiceValues(void);

			void operator = (TCPulseGeneratorData &CPulseGeneratorData);
	
			void Serialize(CArchive& CArchiveFile);

			DECLARE_SERIAL(TCPulseGeneratorData)

};

class TCSineGeneratorData : public CObject
{
	public:	TCSineGeneratorData(void);
			TCSineGeneratorData(TCSineGeneratorData &CSineGeneratorData);
			~TCSineGeneratorData(void);

			double offset;
			double amplitude;
			double frequency;
			double delay;
			double damping;

			CString COffset;
			CString CAmplitude;
			CString CFrequency;
			CString CDelay;
			CString CDamping;

			void ConvertVersion(void);

			CString Format(TCSuperSpiceDoc *PCDoc);
			CString GetAllSpiceValues(void);

			void operator = (TCSineGeneratorData &CSineGeneratorData);
	
			void Serialize(CArchive& CArchiveFile);

			DECLARE_SERIAL(TCSineGeneratorData)

};

class TCDCGeneratorData : public CObject
{
	public:	TCDCGeneratorData(void);
			TCDCGeneratorData(TCDCGeneratorData &CDCGeneratorData);
			~TCDCGeneratorData(void);

			double dc_voltage;
			double ac_voltage;
			double ac_phase;

			CString CDCVoltage;
			CString CACVoltage;
			CString CACPhase;

			void ConvertVersion(void);

			CString Format(TCSuperSpiceDoc *PCDoc, int loop_gain = 0);
			CString GetAllSpiceValues(void);

			void operator = (TCDCGeneratorData &CDCGeneratorData);
	
			void Serialize(CArchive& CArchiveFile);

			DECLARE_SERIAL(TCDCGeneratorData)

};

class TCGeneratorData : public TCObject
{
	public:	TCGeneratorData(void);
			TCGeneratorData(TCGeneratorData &CGeneratorData);
			~TCGeneratorData(void);

			int version;

			TCDCGeneratorData			CDCGeneratorData;
			TCSineGeneratorData			CSineGeneratorData;
			TCPulseGeneratorData		CPulseGeneratorData;
			TCExponentialGeneratorData	CExponentialGeneratorData;
			TCPWLGeneratorData			CPWLGeneratorData;
			TCSFFMGeneratorData			CSFFMGeneratorData;

			CString Format(TCSuperSpiceDoc *PCDoc, int loop_gain = 0);
			CString GetAllSpiceValues(void);

			bool IsVailidTransientSetup(void);

			void operator = (TCGeneratorData &CGeneratorData);

			void Serialize(CArchive& CArchiveFile);

			DECLARE_SERIAL(TCGeneratorData)

};

#endif