// TCGeneratorExpVoltDlg.cpp : implementation file
//

#include "stdafx.h"
#include "resource.h"
#include "TESuperSpiceEnums.h"
#include "TCMKSConvert.h"
#include "TESuperSpiceLabelEnums.h"
#include "TCSchematicObjectData.h"
#include "TCGeneratorExpVoltDlg.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

IMPLEMENT_DYNCREATE(TCGeneratorExpVoltDlg, CPropertyPage)

extern int	g_last_active_generator_property_page;


/////////////////////////////////////////////////////////////////////////////
// TCGeneratorExpVoltDlg property page

TCGeneratorExpVoltDlg::TCGeneratorExpVoltDlg() : CPropertyPage(TCGeneratorExpVoltDlg::IDD)
{
	//{{AFX_DATA_INIT(TCGeneratorExpVoltDlg)
	CMEditVolts1 = _T("");
	CMEditVolts2 = _T("");
	CMEditVolts3 = _T("");
	CMEditVolts4 = _T("");
	m_ac_phase_visable = FALSE;
	m_ac_visable = FALSE;
	m_dc_visable = FALSE;
	m_start_visable = FALSE;
	m_stop_visable = FALSE;
	m_tau1_visable = FALSE;
	m_tau1_delay_visable = FALSE;
	m_tau2_visable = FALSE;
	m_tau2_delay_visable = FALSE;
	m_imd_f1_visable = FALSE;
	m_imd_f2_visable = FALSE;
	CMEditIMDF1 = _T("");
	CMEditIMDF2 = _T("");
	CMVoltEdit3 = _T("");
	CMVoltEdit4 = _T("");

	CDCVoltage = _T(""); 
	CACVoltage = _T("");
	CACPhase   = _T("");

	CStart = _T("");
	CEnd = _T("");
	CDelay1 = _T("");
	CRiseTime1 = _T("");
	CDelay2 = _T("");
	CRiseTime2 = _T("");

	//}}AFX_DATA_INIT

	m_ac_phase = 1.0;
	m_ac_voltage = 1.0;
	m_dc_voltage = 1.0;
	m_start = 1.0;
	m_end = 1.0;
	m_delay1 = 1.0;
	m_delay2 = 1.0;
	m_rise_time1 = 1.0;
	m_rise_time2 = 1.0;
}

TCGeneratorExpVoltDlg::~TCGeneratorExpVoltDlg()
{
}

void TCGeneratorExpVoltDlg::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(TCGeneratorExpVoltDlg)
//	DDX_MKSValue(pDX, IDC_EDIT_AC_PHASE, m_ac_phase);
//	DDX_MKSValue(pDX, IDC_EDIT_AC_VOLTAGE, m_ac_voltage);
//	DDX_MKSValue(pDX, IDC_EDIT_DC_VOLTAGE, m_dc_voltage);
//	DDX_MKSValue(pDX, IDC_EDIT_START_AMPLITUDE, m_start);
//	DDX_MKSValue(pDX, IDC_EDIT_STOP_AMPLITUDE, m_end);
//	DDX_MKSValue(pDX, IDC_EDIT_DELAY1, m_delay1);
//	DDX_MKSValue(pDX, IDC_EDIT_DELAY2, m_delay2);
//	DDX_MKSValue(pDX, IDC_EDIT_RISE_TIME1, m_rise_time1);
//	DDX_MKSValue(pDX, IDC_EDIT_RISE_TIME2, m_rise_time2);
	DDX_Text(pDX, IDC_STATIC_VOLTS_CURRENT1, CMEditVolts1);
	DDX_Text(pDX, IDC_STATIC_VOLTS_CURRENT2, CMEditVolts2);
	DDX_Text(pDX, IDC_STATIC_VOLTS_CURRENT3, CMEditVolts3);
	DDX_Text(pDX, IDC_STATIC_VOLTS_CURRENT4, CMEditVolts4);
	DDX_Check(pDX, IDC_CHECK_AC_PHASE_VISABLE, m_ac_phase_visable);
	DDX_Check(pDX, IDC_CHECK_AC_VISABLE, m_ac_visable);
	DDX_Check(pDX, IDC_CHECK_DC_VISABLE, m_dc_visable);
	DDX_Check(pDX, IDC_CHECK_START_AMPLITUDE, m_start_visable);
	DDX_Check(pDX, IDC_CHECK_STOP_AMPLITUDE, m_stop_visable);
	DDX_Check(pDX, IDC_CHECK_TAU1, m_tau1_visable);
	DDX_Check(pDX, IDC_CHECK_TAU1_DELAY, m_tau1_delay_visable);
	DDX_Check(pDX, IDC_CHECK_TAU2, m_tau2_visable);
	DDX_Check(pDX, IDC_CHECK_TAU2_DELAY, m_tau2_delay_visable);
	DDX_Check(pDX, IDC_CHECK_IMDF1_VISABLE2, m_imd_f1_visable);
	DDX_Check(pDX, IDC_CHECK_IMDF2_VISABLE2, m_imd_f2_visable);
	DDX_Text(pDX, IDC_EDIT_IMD_F1, CMEditIMDF1);
	DDX_Text(pDX, IDC_EDIT_IMD_F2, CMEditIMDF2);
	DDX_Text(pDX, IDC_STATIC_IMD1, CMVoltEdit3);
	DDX_Text(pDX, IDC_STATIC_IMD2, CMVoltEdit4);

	DDX_Text(pDX, IDC_EDIT_DC_VOLTAGE, CDCVoltage);
	DDX_Text(pDX, IDC_EDIT_AC_VOLTAGE, CACVoltage);
	DDX_Text(pDX, IDC_EDIT_AC_PHASE, CACPhase);

	DDX_Text(pDX, IDC_EDIT_START_AMPLITUDE, CStart); 
	DDX_Text(pDX, IDC_EDIT_STOP_AMPLITUDE, CEnd);
	DDX_Text(pDX, IDC_EDIT_DELAY1, CDelay1);
	DDX_Text(pDX, IDC_EDIT_RISE_TIME1 , CRiseTime1);
	DDX_Text(pDX, IDC_EDIT_DELAY2, CDelay2);
	DDX_Text(pDX, IDC_EDIT_RISE_TIME2, CRiseTime2);

	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(TCGeneratorExpVoltDlg, CPropertyPage)
	//{{AFX_MSG_MAP(TCGeneratorExpVoltDlg)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()




BOOL TCGeneratorExpVoltDlg::OnSetActive() 
{
	g_last_active_generator_property_page = 1;
	
	return CPropertyPage::OnSetActive();
}

BOOL TCGeneratorExpVoltDlg::OnKillActive() 
{
	int value =  CPropertyPage::OnKillActive();

	if(value)
	{
//		PCSchematicObjectData->PCGeneratorData->CDCGeneratorData.dc_voltage	= m_dc_voltage;
//		PCSchematicObjectData->PCGeneratorData->CDCGeneratorData.ac_voltage	= m_ac_voltage;
//		PCSchematicObjectData->PCGeneratorData->CDCGeneratorData.ac_phase	= m_ac_phase;

		PCSchematicObjectData->PCGeneratorData->CDCGeneratorData.dc_voltage	= MKSStringToFloat(CDCVoltage);
		PCSchematicObjectData->PCGeneratorData->CDCGeneratorData.ac_voltage	= MKSStringToFloat(CACVoltage);
		PCSchematicObjectData->PCGeneratorData->CDCGeneratorData.ac_phase	= MKSStringToFloat(CACPhase);

		PCSchematicObjectData->PCGeneratorData->CExponentialGeneratorData.start			= MKSStringToFloat(CStart);
		PCSchematicObjectData->PCGeneratorData->CExponentialGeneratorData.end			= MKSStringToFloat(CEnd);
		PCSchematicObjectData->PCGeneratorData->CExponentialGeneratorData.delay1		= MKSStringToFloat(CDelay1);
		PCSchematicObjectData->PCGeneratorData->CExponentialGeneratorData.rise_time1	= MKSStringToFloat(CRiseTime1);
		PCSchematicObjectData->PCGeneratorData->CExponentialGeneratorData.delay2		= MKSStringToFloat(CDelay2);
		PCSchematicObjectData->PCGeneratorData->CExponentialGeneratorData.rise_time2	= MKSStringToFloat(CRiseTime2);

		PCSchematicObjectData->PCGeneratorData->CDCGeneratorData.CDCVoltage = CDCVoltage;
		PCSchematicObjectData->PCGeneratorData->CDCGeneratorData.CACVoltage = CACVoltage;
		PCSchematicObjectData->PCGeneratorData->CDCGeneratorData.CACPhase   = CACPhase;

		PCSchematicObjectData->PCGeneratorData->CExponentialGeneratorData.CStart		= CStart; 
		PCSchematicObjectData->PCGeneratorData->CExponentialGeneratorData.CEnd			= CEnd;
		PCSchematicObjectData->PCGeneratorData->CExponentialGeneratorData.CDelay1		= CDelay1;
		PCSchematicObjectData->PCGeneratorData->CExponentialGeneratorData.CRiseTime1	= CRiseTime1;
		PCSchematicObjectData->PCGeneratorData->CExponentialGeneratorData.CDelay2		= CDelay2;
		PCSchematicObjectData->PCGeneratorData->CExponentialGeneratorData.CRiseTime2	= CRiseTime2;

		if(!(E_GENERATOR_EXP_TAU2_VALUE < PCSchematicObjectData->CLabelListData.GetSize())) return value;

		PCSchematicObjectData->CLabelListData[E_GENERATOR_AC_VALUE].is_visable		= !!m_ac_visable;
		PCSchematicObjectData->CLabelListData[E_GENERATOR_DC_VALUE].is_visable		= !!m_dc_visable;
		PCSchematicObjectData->CLabelListData[E_GENERATOR_PHASE_VALUE].is_visable	= !!m_ac_phase_visable;

		PCSchematicObjectData->CLabelListData[E_GENERATOR_EXP_START_VALUE].is_visable		= !!m_start_visable;
		PCSchematicObjectData->CLabelListData[E_GENERATOR_EXP_STOP_VALUE].is_visable		= !!m_stop_visable;
		PCSchematicObjectData->CLabelListData[E_GENERATOR_EXP_TAU1_VALUE].is_visable		= !!m_tau1_visable;
		PCSchematicObjectData->CLabelListData[E_GENERATOR_EXP_TAU1_DELAY_VALUE].is_visable	= !!m_tau1_delay_visable;
		PCSchematicObjectData->CLabelListData[E_GENERATOR_EXP_TAU2_VALUE].is_visable		= !!m_tau2_visable;
		PCSchematicObjectData->CLabelListData[E_GENERATOR_EXP_TAU2_DELAY_VALUE].is_visable	= !!m_tau2_delay_visable;

		PCSchematicObjectData->CLabelListData[E_GENERATOR_EXP_IMD1].is_visable = !!m_imd_f1_visable;
		PCSchematicObjectData->CLabelListData[E_GENERATOR_EXP_IMD2].is_visable = !!m_imd_f2_visable;
		PCSchematicObjectData->CLabelListData[E_GENERATOR_EXP_IMD1].CLabelValue = CMEditIMDF1;
		PCSchematicObjectData->CLabelListData[E_GENERATOR_EXP_IMD2].CLabelValue = CMEditIMDF2;

		PCSchematicObjectData->FormatLabels();
	}
	return value;
}

BOOL TCGeneratorExpVoltDlg::OnInitDialog() 
{

	m_dc_voltage = PCSchematicObjectData->PCGeneratorData->CDCGeneratorData.dc_voltage;
	m_ac_voltage = PCSchematicObjectData->PCGeneratorData->CDCGeneratorData.ac_voltage;
	m_ac_phase	 = PCSchematicObjectData->PCGeneratorData->CDCGeneratorData.ac_phase;

	m_end			= PCSchematicObjectData->PCGeneratorData->CExponentialGeneratorData.end;
	m_start			= PCSchematicObjectData->PCGeneratorData->CExponentialGeneratorData.start;
	m_rise_time1	= PCSchematicObjectData->PCGeneratorData->CExponentialGeneratorData.rise_time1;
	m_rise_time2	= PCSchematicObjectData->PCGeneratorData->CExponentialGeneratorData.rise_time2;
	m_delay1		= PCSchematicObjectData->PCGeneratorData->CExponentialGeneratorData.delay1;
	m_delay2		= PCSchematicObjectData->PCGeneratorData->CExponentialGeneratorData.delay2;

	CDCVoltage = PCSchematicObjectData->PCGeneratorData->CDCGeneratorData.CDCVoltage;
	CACVoltage = PCSchematicObjectData->PCGeneratorData->CDCGeneratorData.CACVoltage;
	CACPhase   = PCSchematicObjectData->PCGeneratorData->CDCGeneratorData.CACPhase;

	CStart		= PCSchematicObjectData->PCGeneratorData->CExponentialGeneratorData.CStart; 
	CEnd		= PCSchematicObjectData->PCGeneratorData->CExponentialGeneratorData.CEnd;
	CDelay1		= PCSchematicObjectData->PCGeneratorData->CExponentialGeneratorData.CDelay1;
	CRiseTime1	= PCSchematicObjectData->PCGeneratorData->CExponentialGeneratorData.CRiseTime1;
	CDelay2		= PCSchematicObjectData->PCGeneratorData->CExponentialGeneratorData.CDelay2;
	CRiseTime2	= PCSchematicObjectData->PCGeneratorData->CExponentialGeneratorData.CRiseTime2;

	if(E_GENERATOR_EXP_TAU2_VALUE < PCSchematicObjectData->CLabelListData.GetSize()) 
	{
		m_ac_visable		= PCSchematicObjectData->CLabelListData[E_GENERATOR_AC_VALUE].is_visable;
		m_dc_visable		= PCSchematicObjectData->CLabelListData[E_GENERATOR_DC_VALUE].is_visable;
		m_ac_phase_visable	= PCSchematicObjectData->CLabelListData[E_GENERATOR_PHASE_VALUE].is_visable;

		m_start_visable			= PCSchematicObjectData->CLabelListData[E_GENERATOR_EXP_START_VALUE].is_visable;
		m_stop_visable			= PCSchematicObjectData->CLabelListData[E_GENERATOR_EXP_STOP_VALUE].is_visable;
		m_tau1_visable			= PCSchematicObjectData->CLabelListData[E_GENERATOR_EXP_TAU1_VALUE].is_visable;
		m_tau1_delay_visable	= PCSchematicObjectData->CLabelListData[E_GENERATOR_EXP_TAU1_DELAY_VALUE].is_visable;
		m_tau2_visable			= PCSchematicObjectData->CLabelListData[E_GENERATOR_EXP_TAU2_VALUE].is_visable;
		m_tau2_delay_visable	= PCSchematicObjectData->CLabelListData[E_GENERATOR_EXP_TAU2_DELAY_VALUE].is_visable;

		m_imd_f1_visable	= PCSchematicObjectData->CLabelListData[E_GENERATOR_EXP_IMD1].is_visable;
		m_imd_f2_visable	= PCSchematicObjectData->CLabelListData[E_GENERATOR_EXP_IMD2].is_visable;
		CMEditIMDF1			= PCSchematicObjectData->CLabelListData[E_GENERATOR_EXP_IMD1].CLabelValue;
		CMEditIMDF2			= PCSchematicObjectData->CLabelListData[E_GENERATOR_EXP_IMD2].CLabelValue;
	}
	CString CText;

	if(PCSchematicObjectData->version > E_SINGLE_FREQ_VOLTAGE_FM)
	{
		CText = "Amps";
	}
	else CText = "Volts";


	CMEditVolts1 = CText;
	CMEditVolts2 = CText;
	CMEditVolts3 = CText;
	CMEditVolts4 = CText;
	CMVoltEdit3  = CText;
	CMVoltEdit4  = CText;

	CPropertyPage::OnInitDialog();
	
	return TRUE; 	
}
