// TCGeneratorPWLVoltDlg.cpp : implementation file
//

#include "stdafx.h"
#include "resource.h"
#include "TCMKSConvert.h"
#include "TESuperSpiceEnums.h"
#include "TESuperSpiceLabelEnums.h"
#include "TCSchematicObjectData.h"
#include "TCGeneratorPWLVoltDlg.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

IMPLEMENT_DYNCREATE(TCGeneratorPWLVoltDlg, CPropertyPage)

extern int	g_last_active_generator_property_page;


/////////////////////////////////////////////////////////////////////////////
// TCGeneratorPWLVoltDlg property page

TCGeneratorPWLVoltDlg::TCGeneratorPWLVoltDlg() : CPropertyPage(TCGeneratorPWLVoltDlg::IDD)
{
	//{{AFX_DATA_INIT(TCGeneratorPWLVoltDlg)
	CMEditVolts1 = _T("");
	CMEditVolts2 = _T("");
	CMEditVolts3 = _T("");
	CMEditVolts4 = _T("");
	m_index = 0;
	m_ac_phase_visable = FALSE;
	m_ac_visable = FALSE;
	m_dc_visable = FALSE;
	m_imd_f1_visable = FALSE;
	m_imd_f2_visable = FALSE;
	CMEditIMDF1 = _T("");
	CMEditIMDF2 = _T("");
	CMEditVolt5 = _T("");
	CMEditVolt6 = _T("");
	//}}AFX_DATA_INIT

	m_ac_phase = 1.0;
	m_ac_voltage = 1.0;
	m_dc_voltage = 1.0;	
	m_index		= 0;
	m_amplitude = 0;
	m_amplitude = 1.0;
	m_time = 1.0;
}	

TCGeneratorPWLVoltDlg::~TCGeneratorPWLVoltDlg()
{
}

void TCGeneratorPWLVoltDlg::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(TCGeneratorPWLVoltDlg)
	DDX_Control(pDX, IDC_LIST_TIME_AMPLITUDE, CMListTimeAmplitude);
	DDX_MKSValue(pDX, IDC_EDIT_AC_PHASE, m_ac_phase);
	DDX_MKSValue(pDX, IDC_EDIT_AC_VOLTAGE, m_ac_voltage);
	DDX_MKSValue(pDX, IDC_EDIT_DC_VOLTAGE, m_dc_voltage);
	DDX_Text(pDX, IDC_STATIC_VOLTS_CURRENT1, CMEditVolts1);
	DDX_Text(pDX, IDC_STATIC_VOLTS_CURRENT2, CMEditVolts2);
	DDX_Text(pDX, IDC_STATIC_VOLTS_CURRENT3, CMEditVolts3);
	DDX_Text(pDX, IDC_STATIC_VOLTS_CURRENT4, CMEditVolts4);
	DDX_MKSValue(pDX, IDC_EDIT_TIME, m_time);
	DDX_Text(pDX, IDC_EDIT_INDEX, m_index);
	DDX_MKSValue(pDX, IDC_EDIT_AMPLITUDE, m_amplitude);
	DDX_Check(pDX, IDC_CHECK_AC_PHASE_VISABLE, m_ac_phase_visable);
	DDX_Check(pDX, IDC_CHECK_AC_VISABLE, m_ac_visable);
	DDX_Check(pDX, IDC_CHECK_DC_VISABLE, m_dc_visable);
	DDX_Check(pDX, IDC_CHECK_IMDF1_VISABLE3, m_imd_f1_visable);
	DDX_Check(pDX, IDC_CHECK_IMDF2_VISABLE3, m_imd_f2_visable);
	DDX_Text(pDX, IDC_EDIT_IMD_F2, CMEditIMDF1);
	DDX_Text(pDX, IDC_EDIT_IMD_F3, CMEditIMDF2);
	DDX_Text(pDX, IDC_STATIC_IMD1, CMEditVolt5);
	DDX_Text(pDX, IDC_STATIC_IMD2, CMEditVolt6);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(TCGeneratorPWLVoltDlg, CPropertyPage)
	//{{AFX_MSG_MAP(TCGeneratorPWLVoltDlg)
	ON_BN_CLICKED(IDC_BUTTON_DELETE, OnButtonDelete)
	ON_BN_CLICKED(IDC_BUTTON_DELETE_ALL, OnButtonDeleteAll)
	ON_BN_CLICKED(IDC_BUTTON_INSERT, OnButtonInsert)
	ON_NOTIFY(NM_CLICK, IDC_LIST_TIME_AMPLITUDE, OnClickListTimeAmplitude)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()




BOOL TCGeneratorPWLVoltDlg::OnSetActive() 
{
	g_last_active_generator_property_page = 1;
	
	return CPropertyPage::OnSetActive();
}

BOOL TCGeneratorPWLVoltDlg::OnKillActive() 
{
	int value =  CPropertyPage::OnKillActive();

	if(value)
	{
		GetDisplay();

		PCSchematicObjectData->PCGeneratorData->CDCGeneratorData.dc_voltage	= m_dc_voltage;
		PCSchematicObjectData->PCGeneratorData->CDCGeneratorData.ac_voltage	= m_ac_voltage;
		PCSchematicObjectData->PCGeneratorData->CDCGeneratorData.ac_phase	= m_ac_phase;
		PCSchematicObjectData->PCGeneratorData->CPWLGeneratorData.CData;

		if(!(E_GENERATOR_PWL_IMD2 < PCSchematicObjectData->CLabelListData.GetSize())) return value;

		PCSchematicObjectData->CLabelListData[E_GENERATOR_PHASE_VALUE].is_visable	= !!m_ac_phase_visable;
		PCSchematicObjectData->CLabelListData[E_GENERATOR_AC_VALUE].is_visable		= !!m_ac_visable;
		PCSchematicObjectData->CLabelListData[E_GENERATOR_DC_VALUE].is_visable		= !!m_dc_visable;
	
		PCSchematicObjectData->CLabelListData[E_GENERATOR_PWL_IMD1].is_visable = !!m_imd_f1_visable;
		PCSchematicObjectData->CLabelListData[E_GENERATOR_PWL_IMD2].is_visable = !!m_imd_f2_visable;
		PCSchematicObjectData->CLabelListData[E_GENERATOR_PWL_IMD1].CLabelValue = CMEditIMDF1;
		PCSchematicObjectData->CLabelListData[E_GENERATOR_PWL_IMD2].CLabelValue = CMEditIMDF2;

		PCSchematicObjectData->FormatLabels();
	}
	return value;
}

BOOL TCGeneratorPWLVoltDlg::OnInitDialog() 
{

	m_dc_voltage = PCSchematicObjectData->PCGeneratorData->CDCGeneratorData.dc_voltage;
	m_ac_voltage = PCSchematicObjectData->PCGeneratorData->CDCGeneratorData.ac_voltage;
	m_ac_phase	 = PCSchematicObjectData->PCGeneratorData->CDCGeneratorData.ac_phase;

	if(E_GENERATOR_PWL_IMD2 < PCSchematicObjectData->CLabelListData.GetSize()) 
	{
		m_ac_phase_visable	= PCSchematicObjectData->CLabelListData[E_GENERATOR_PHASE_VALUE ].is_visable;
		m_ac_visable		= PCSchematicObjectData->CLabelListData[E_GENERATOR_AC_VALUE].is_visable;
		m_dc_visable		= PCSchematicObjectData->CLabelListData[E_GENERATOR_DC_VALUE].is_visable;

		m_imd_f1_visable	= PCSchematicObjectData->CLabelListData[E_GENERATOR_PWL_IMD1].is_visable;
		m_imd_f2_visable	= PCSchematicObjectData->CLabelListData[E_GENERATOR_PWL_IMD2].is_visable;
		CMEditIMDF1			= PCSchematicObjectData->CLabelListData[E_GENERATOR_PWL_IMD1].CLabelValue;
		CMEditIMDF2			= PCSchematicObjectData->CLabelListData[E_GENERATOR_PWL_IMD2].CLabelValue;
	}
	CString CText;

	if(PCSchematicObjectData->version > E_SINGLE_FREQ_VOLTAGE_FM)
	{
		CText = "Amps";
	}
	else CText = "Volts";


	CMEditVolts1 = CText;
	CMEditVolts2 = CText;
	CMEditVolts3 = CText;
	CMEditVolt5 = CText;
	CMEditVolt6 = CText;


	CPropertyPage::OnInitDialog();

	int length = (int)(CMListTimeAmplitude.GetStringWidth("At time") * 3);

	CText ="At time";
	CMListTimeAmplitude.InsertColumn(0, CText, LVCFMT_LEFT,length,0);

	CText ="Value is";
	CMListTimeAmplitude.InsertColumn(1, CText, LVCFMT_LEFT, length,1);

	InsertItems();
	SetDisplay();

	return TRUE; 	
}

void TCGeneratorPWLVoltDlg::GetDisplay(void)
{
	UpdateData(true);

	TCPWLGeneratorData &CPWLGeneratorData = PCSchematicObjectData->PCGeneratorData->CPWLGeneratorData;

	CPWLGeneratorData.index	= m_index;

	int size = CPWLGeneratorData.CData.CList.GetSize();

	if(size && m_index < size)
	{
		CPWLGeneratorData.CData.CList[m_index].x = m_time;
		CPWLGeneratorData.CData.CList[m_index].y = m_amplitude;
	}
}

void TCGeneratorPWLVoltDlg::SetDisplay(void)
{
	TCPWLGeneratorData &CPWLGeneratorData = PCSchematicObjectData->PCGeneratorData->CPWLGeneratorData;

	m_index			= CPWLGeneratorData.index;

	int size = CPWLGeneratorData.CData.CList.GetSize();

	if(size && m_index < size)
	{
		m_time		= CPWLGeneratorData.CData.CList[m_index].x ;
		m_amplitude = CPWLGeneratorData.CData.CList[m_index].y;
	}

	int count = CPWLGeneratorData.CData.CList.GetSize();
	
	CString CText;

	for(int p = 0; p < count; p++)
	{	
		CText = FloatToMKSString(CPWLGeneratorData.CData.CList[p].x);
	
		CMListTimeAmplitude.SetItemText(p, 0, CText);
		
		CText = FloatToMKSString(CPWLGeneratorData.CData.CList[p].y);

		CMListTimeAmplitude.SetItemText(p, 1, CText);
	}

	UpdateData(false);

	CMListTimeAmplitude.SetItemState(m_index, LVIS_SELECTED | LVIS_FOCUSED, LVIS_SELECTED | LVIS_FOCUSED );
}

void TCGeneratorPWLVoltDlg::InsertItems(void)
{
	CMListTimeAmplitude.DeleteAllItems();

	TCPWLGeneratorData &CPWLGeneratorData = PCSchematicObjectData->PCGeneratorData->CPWLGeneratorData;

	int count = CPWLGeneratorData.CData.CList.GetSize();
	
	CString CText;

	for(int p = 0; p < count; p++)
	{	
		CText = FloatToMKSString(CPWLGeneratorData.CData.CList[p].x);
	
		CMListTimeAmplitude.InsertItem(p, CText);
	}

	CMListTimeAmplitude.SetItemState(CPWLGeneratorData.index, LVIS_SELECTED | LVIS_FOCUSED, LVIS_SELECTED | LVIS_FOCUSED );
}

void TCGeneratorPWLVoltDlg::OnButtonInsert() 
{
//	GetDisplay();

	UpdateData(true);

	TCPWLGeneratorData &CPWLGeneratorData = PCSchematicObjectData->PCGeneratorData->CPWLGeneratorData;

	TCXYArray CData;

//	m_time		= CData.x;
//	m_amplitude	= CData.x;

	CData.x = m_time;
	CData.y = m_amplitude;

	int index = CPWLGeneratorData.index;
	
	if(!CPWLGeneratorData.CData.CList.GetSize())// if empty
	{
		CPWLGeneratorData.index = 0;
		index = 0;
	}
	else index++;

	CPWLGeneratorData.index = index;

	CPWLGeneratorData.CData.CList.InsertAt(index, CData);

	InsertItems();
	SetDisplay();
}

void TCGeneratorPWLVoltDlg::OnButtonDelete() 
{
	GetDisplay();

	TCPWLGeneratorData &CPWLGeneratorData = PCSchematicObjectData->PCGeneratorData->CPWLGeneratorData;

	int size = CPWLGeneratorData.CData.CList.GetSize();

	if(!size) return;

	if(CPWLGeneratorData.index >= size) return;

	CPWLGeneratorData.CData.CList.RemoveAt(CPWLGeneratorData.index);

	if(CPWLGeneratorData.index > 0) CPWLGeneratorData.index--;

	InsertItems();
	SetDisplay();
}

void TCGeneratorPWLVoltDlg::OnButtonDeleteAll() 
{
	GetDisplay();

	TCPWLGeneratorData &CPWLGeneratorData = PCSchematicObjectData->PCGeneratorData->CPWLGeneratorData;

	CPWLGeneratorData.CData.CList.SetSize(0);

	CPWLGeneratorData.index		= 0;

	InsertItems();
	SetDisplay();
}


void TCGeneratorPWLVoltDlg::OnClickListTimeAmplitude(NMHDR* pNMHDR, LRESULT* pResult) 
{	
	pNMHDR;
	*pResult = 0;

	GetDisplay();

	int item = CMListTimeAmplitude.GetNextItem(-1, LVNI_SELECTED | LVNI_FOCUSED);

	if(item < 0) return;

	TCPWLGeneratorData &CPWLGeneratorData = PCSchematicObjectData->PCGeneratorData->CPWLGeneratorData;

	CPWLGeneratorData.index = item;

	SetDisplay();//does not update time
}
