// TCGeneratorPulseVoltDlg.cpp : implementation file
//

#include "stdafx.h"
#include "resource.h"
#include "TCMKSConvert.h"
#include "TESuperSpiceEnums.h"
#include "TESuperSpiceLabelEnums.h"
#include "TCSchematicObjectData.h"
#include "TCGeneratorPulseVoltDlg.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

IMPLEMENT_DYNCREATE(TCGeneratorPulseVoltDlg, CPropertyPage)

extern int	g_last_active_generator_property_page;


/////////////////////////////////////////////////////////////////////////////
// TCGeneratorPulseVoltDlg property page

TCGeneratorPulseVoltDlg::TCGeneratorPulseVoltDlg() : CPropertyPage(TCGeneratorPulseVoltDlg::IDD)
{
	//{{AFX_DATA_INIT(TCGeneratorPulseVoltDlg)
	CMEditVolts1 = _T("");
	CMEditVolts2 = _T("");
	CMEditVolts3 = _T("");
	CMEditVolts4 = _T("");
	m_ac_visable = FALSE;
	m_dc_visable = FALSE;
	m_delay_visable = FALSE;
	m_fall_visable = FALSE;
	m_period_visable = FALSE;
	m_width_visable = FALSE;
	m_rise_visable = FALSE;
	m_start_visable = FALSE;
	m_stop_visable = FALSE;
	m_ac_phase_visable = FALSE;
	m_imd_f1_visable = FALSE;
	m_imd_f2_visable = FALSE;
	CMEditIMDF1 = _T("");
	CMEditIMDF2 = _T("");
	CMEditVolts7 = _T("");
	CMEditVolts9 = _T("");

	CDCVoltage = _T(""); 
	CACVoltage = _T("");
	CACPhase   = _T("");
	CStart  = _T("");
	CEnd  = _T("");
	CDelay  = _T("");
	CRise  = _T("");
	CFall  = _T("");
	CWidth  = _T("");
	CPeriod  = _T("");

	//}}AFX_DATA_INIT

	m_ac_phase = 1.0;
	m_ac_voltage = 1.0;
	m_dc_voltage = 1.0;	
	m_delay= 1.0;
	m_period= 1.0;
	m_width= 1.0;
	m_fall= 1.0;
	m_rise= 1.0;
	m_start= 1.0;
	m_end= 1.0;
}

TCGeneratorPulseVoltDlg::~TCGeneratorPulseVoltDlg()
{
}

void TCGeneratorPulseVoltDlg::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(TCGeneratorPulseVoltDlg)
//	DDX_MKSValue(pDX, IDC_EDIT_AC_PHASE, m_ac_phase);
//	DDX_MKSValue(pDX, IDC_EDIT_AC_VOLTAGE, m_ac_voltage);
//	DDX_MKSValue(pDX, IDC_EDIT_DC_VOLTAGE, m_dc_voltage);
//	DDX_MKSValue(pDX, IDC_EDIT_DELAY, m_delay);
//	DDX_MKSValue(pDX, IDC_EDIT_PERIOD, m_period);
//	DDX_MKSValue(pDX, IDC_EDIT_PULSE_WIDTH, m_width);
//	DDX_MKSValue(pDX, IDC_EDIT_FALL_TIME, m_fall);
//	DDX_MKSValue(pDX, IDC_EDIT_RISE_TIME, m_rise);
//	DDX_MKSValue(pDX, IDC_EDIT_START_AMPLITUDE, m_start);
//	DDX_MKSValue(pDX, IDC_EDIT_STOP_AMPLITUDE, m_end);
	DDX_Text(pDX, IDC_STATIC_VOLTS_CURRENT1, CMEditVolts1);
	DDX_Text(pDX, IDC_STATIC_VOLTS_CURRENT2, CMEditVolts2);
	DDX_Text(pDX, IDC_STATIC_VOLTS_CURRENT3, CMEditVolts3);
	DDX_Text(pDX, IDC_STATIC_VOLTS_CURRENT4, CMEditVolts4);
	DDX_Check(pDX, IDC_CHECK_AC_VISABLE, m_ac_visable);
	DDX_Check(pDX, IDC_CHECK_DC_VISABLE, m_dc_visable);
	DDX_Check(pDX, IDC_CHECK_DELAY, m_delay_visable);
	DDX_Check(pDX, IDC_CHECK_FALL_TIME, m_fall_visable);
	DDX_Check(pDX, IDC_CHECK_PERIOD, m_period_visable);
	DDX_Check(pDX, IDC_CHECK_PULSE_WIDTH, m_width_visable);
	DDX_Check(pDX, IDC_CHECK_RISE_TIME, m_rise_visable);
	DDX_Check(pDX, IDC_CHECK_START_AMPLITUDE, m_start_visable);
	DDX_Check(pDX, IDC_CHECK_STOP_AMPLITUDE, m_stop_visable);
	DDX_Check(pDX, IDC_CHECK_AC_PHASE_VISABLE, m_ac_phase_visable);
	DDX_Check(pDX, IDC_CHECK_IMDF1_VISABLE2, m_imd_f1_visable);
	DDX_Check(pDX, IDC_CHECK_IMDF2_VISABLE2, m_imd_f2_visable);
	DDX_Text(pDX, IDC_EDIT_IMD_F1, CMEditIMDF1);
	DDX_Text(pDX, IDC_EDIT_IMD_F2, CMEditIMDF2);
	DDX_Text(pDX, IDC_STATIC_VOLTS_CURRENT7, CMEditVolts7);
	DDX_Text(pDX, IDC_STATIC_VOLTS_CURRENT9, CMEditVolts9);

	DDX_Text(pDX, IDC_EDIT_DC_VOLTAGE, CDCVoltage); 
	DDX_Text(pDX, IDC_EDIT_AC_VOLTAGE, CACVoltage);
	DDX_Text(pDX, IDC_EDIT_AC_PHASE, CACPhase);
	DDX_Text(pDX, IDC_EDIT_START_AMPLITUDE, CStart);
	DDX_Text(pDX, IDC_EDIT_STOP_AMPLITUDE, CEnd);
	DDX_Text(pDX, IDC_EDIT_DELAY, CDelay);
	DDX_Text(pDX, IDC_EDIT_RISE_TIME, CRise);
	DDX_Text(pDX, IDC_EDIT_FALL_TIME, CFall);
	DDX_Text(pDX, IDC_EDIT_PULSE_WIDTH, CWidth);
	DDX_Text(pDX, IDC_EDIT_PERIOD, CPeriod);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(TCGeneratorPulseVoltDlg, CPropertyPage)
	//{{AFX_MSG_MAP(TCGeneratorPulseVoltDlg)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()




BOOL TCGeneratorPulseVoltDlg::OnSetActive() 
{
	g_last_active_generator_property_page = 1;
	
	return CPropertyPage::OnSetActive();
}

BOOL TCGeneratorPulseVoltDlg::OnKillActive() 
{
	int value =  CPropertyPage::OnKillActive();

	if(value)
	{
//		PCSchematicObjectData->PCGeneratorData->CDCGeneratorData.dc_voltage	= m_dc_voltage;
//		PCSchematicObjectData->PCGeneratorData->CDCGeneratorData.ac_voltage	= m_ac_voltage;
//		PCSchematicObjectData->PCGeneratorData->CDCGeneratorData.ac_phase	= m_ac_phase;

		PCSchematicObjectData->PCGeneratorData->CDCGeneratorData.dc_voltage	= MKSStringToFloat(CDCVoltage);
		PCSchematicObjectData->PCGeneratorData->CDCGeneratorData.ac_voltage	= MKSStringToFloat(CACVoltage);
		PCSchematicObjectData->PCGeneratorData->CDCGeneratorData.ac_phase	= MKSStringToFloat(CACPhase);

		PCSchematicObjectData->PCGeneratorData->CPulseGeneratorData.end = MKSStringToFloat(CEnd);
		PCSchematicObjectData->PCGeneratorData->CPulseGeneratorData.start = MKSStringToFloat(CStart);
		PCSchematicObjectData->PCGeneratorData->CPulseGeneratorData.delay = MKSStringToFloat(CDelay);
		PCSchematicObjectData->PCGeneratorData->CPulseGeneratorData.rise = MKSStringToFloat(CRise);
		PCSchematicObjectData->PCGeneratorData->CPulseGeneratorData.fall = MKSStringToFloat(CFall);
		PCSchematicObjectData->PCGeneratorData->CPulseGeneratorData.width = MKSStringToFloat(CWidth);
		PCSchematicObjectData->PCGeneratorData->CPulseGeneratorData.period = MKSStringToFloat(CPeriod);

		PCSchematicObjectData->PCGeneratorData->CDCGeneratorData.CDCVoltage	= CDCVoltage; 
		PCSchematicObjectData->PCGeneratorData->CDCGeneratorData.CACVoltage	= CACVoltage;
		PCSchematicObjectData->PCGeneratorData->CDCGeneratorData.CACPhase	= CACPhase;
		PCSchematicObjectData->PCGeneratorData->CPulseGeneratorData.CStart	= CStart;
		PCSchematicObjectData->PCGeneratorData->CPulseGeneratorData.CEnd	= CEnd;
		PCSchematicObjectData->PCGeneratorData->CPulseGeneratorData.CDelay	= CDelay;
		PCSchematicObjectData->PCGeneratorData->CPulseGeneratorData.CRise	= CRise;
		PCSchematicObjectData->PCGeneratorData->CPulseGeneratorData.CFall	= CFall;
		PCSchematicObjectData->PCGeneratorData->CPulseGeneratorData.CWidth	= CWidth;
		PCSchematicObjectData->PCGeneratorData->CPulseGeneratorData.CPeriod	= CPeriod;

		if(!(E_GENERATOR_PULSE_PERIOD_VALUE < PCSchematicObjectData->CLabelListData.GetSize())) return value;

		PCSchematicObjectData->CLabelListData[E_GENERATOR_AC_VALUE].is_visable		= !!m_ac_visable;
		PCSchematicObjectData->CLabelListData[E_GENERATOR_DC_VALUE].is_visable		= !!m_dc_visable;
		PCSchematicObjectData->CLabelListData[E_GENERATOR_PHASE_VALUE].is_visable	= !!m_ac_phase_visable;

		PCSchematicObjectData->CLabelListData[E_GENERATOR_PULSE_DELAY_VALUE].is_visable				= !!m_delay_visable;
		PCSchematicObjectData->CLabelListData[E_GENERATOR_PULSE_FALL_TIME_VALUE].is_visable			= !!m_fall_visable;
		PCSchematicObjectData->CLabelListData[E_GENERATOR_PULSE_PERIOD_VALUE].is_visable			= !!m_period_visable;
		PCSchematicObjectData->CLabelListData[E_GENERATOR_PULSE_WIDTH_VALUE].is_visable				= !!m_width_visable;
		PCSchematicObjectData->CLabelListData[E_GENERATOR_PULSE_RISE_TIME_VALUE].is_visable			= !!m_rise_visable;
		PCSchematicObjectData->CLabelListData[E_GENERATOR_PULSE_START_AMPLITUDE_VALUE].is_visable	= !!m_start_visable;
		PCSchematicObjectData->CLabelListData[E_GENERATOR_PULSE_STOP_AMPLITUDE_VALUE].is_visable	= !!m_stop_visable;

		PCSchematicObjectData->CLabelListData[E_GENERATOR_PULSE_IMD1].is_visable = !!m_imd_f1_visable;
		PCSchematicObjectData->CLabelListData[E_GENERATOR_PULSE_IMD2].is_visable = !!m_imd_f2_visable;
		PCSchematicObjectData->CLabelListData[E_GENERATOR_PULSE_IMD1].CLabelValue = CMEditIMDF1;
		PCSchematicObjectData->CLabelListData[E_GENERATOR_PULSE_IMD2].CLabelValue = CMEditIMDF2;

		PCSchematicObjectData->FormatLabels();
	}
	return value;
}

BOOL TCGeneratorPulseVoltDlg::OnInitDialog() 
{

	m_dc_voltage = PCSchematicObjectData->PCGeneratorData->CDCGeneratorData.dc_voltage;
	m_ac_voltage = PCSchematicObjectData->PCGeneratorData->CDCGeneratorData.ac_voltage;
	m_ac_phase	 = PCSchematicObjectData->PCGeneratorData->CDCGeneratorData.ac_phase;

	m_end	= PCSchematicObjectData->PCGeneratorData->CPulseGeneratorData.end;
	m_start	= PCSchematicObjectData->PCGeneratorData->CPulseGeneratorData.start;
	m_rise	= PCSchematicObjectData->PCGeneratorData->CPulseGeneratorData.rise;
	m_fall  = PCSchematicObjectData->PCGeneratorData->CPulseGeneratorData.fall;
	m_width = PCSchematicObjectData->PCGeneratorData->CPulseGeneratorData.width;
	m_delay	= PCSchematicObjectData->PCGeneratorData->CPulseGeneratorData.delay;
	m_period = PCSchematicObjectData->PCGeneratorData->CPulseGeneratorData.period;

	CDCVoltage = PCSchematicObjectData->PCGeneratorData->CDCGeneratorData.CDCVoltage; 
	CACVoltage = PCSchematicObjectData->PCGeneratorData->CDCGeneratorData.CACVoltage;
	CACPhase	= PCSchematicObjectData->PCGeneratorData->CDCGeneratorData.CACPhase;

	CStart	= PCSchematicObjectData->PCGeneratorData->CPulseGeneratorData.CStart;
	CEnd	= PCSchematicObjectData->PCGeneratorData->CPulseGeneratorData.CEnd;
	CDelay	= PCSchematicObjectData->PCGeneratorData->CPulseGeneratorData.CDelay;
	CRise	= PCSchematicObjectData->PCGeneratorData->CPulseGeneratorData.CRise;
	CFall	= PCSchematicObjectData->PCGeneratorData->CPulseGeneratorData.CFall;
	CWidth	= PCSchematicObjectData->PCGeneratorData->CPulseGeneratorData.CWidth;
	CPeriod = PCSchematicObjectData->PCGeneratorData->CPulseGeneratorData.CPeriod;

	if(E_GENERATOR_PULSE_PERIOD_VALUE < PCSchematicObjectData->CLabelListData.GetSize()) 
	{
		m_ac_visable		= PCSchematicObjectData->CLabelListData[E_GENERATOR_AC_VALUE].is_visable;
		m_dc_visable		= PCSchematicObjectData->CLabelListData[E_GENERATOR_DC_VALUE].is_visable;
		m_ac_phase_visable	= PCSchematicObjectData->CLabelListData[E_GENERATOR_PHASE_VALUE].is_visable;

		m_delay_visable		= PCSchematicObjectData->CLabelListData[E_GENERATOR_PULSE_DELAY_VALUE].is_visable;
		m_fall_visable		= PCSchematicObjectData->CLabelListData[E_GENERATOR_PULSE_FALL_TIME_VALUE].is_visable;
		m_period_visable	= PCSchematicObjectData->CLabelListData[E_GENERATOR_PULSE_PERIOD_VALUE].is_visable;
		m_width_visable		= PCSchematicObjectData->CLabelListData[E_GENERATOR_PULSE_WIDTH_VALUE].is_visable;
		m_rise_visable		= PCSchematicObjectData->CLabelListData[E_GENERATOR_PULSE_RISE_TIME_VALUE].is_visable;
		m_start_visable		= PCSchematicObjectData->CLabelListData[E_GENERATOR_PULSE_START_AMPLITUDE_VALUE].is_visable;
		m_stop_visable		= PCSchematicObjectData->CLabelListData[E_GENERATOR_PULSE_STOP_AMPLITUDE_VALUE].is_visable;

		m_imd_f1_visable	= PCSchematicObjectData->CLabelListData[E_GENERATOR_PULSE_IMD1].is_visable;
		m_imd_f2_visable	= PCSchematicObjectData->CLabelListData[E_GENERATOR_PULSE_IMD2].is_visable;
		CMEditIMDF1			= PCSchematicObjectData->CLabelListData[E_GENERATOR_PULSE_IMD1].CLabelValue;
		CMEditIMDF2			= PCSchematicObjectData->CLabelListData[E_GENERATOR_PULSE_IMD2].CLabelValue;

	}
	CString CText;

	if(PCSchematicObjectData->version > E_SINGLE_FREQ_VOLTAGE_FM)
	{
		CText = "Amps";
	}
	else CText = "Volts";


	CMEditVolts1 = CText;
	CMEditVolts2 = CText;
	CMEditVolts3 = CText;
	CMEditVolts4 = CText;
	CMEditVolts7 = CText;
	CMEditVolts9 = CText;

	CPropertyPage::OnInitDialog();

	return TRUE; 	
}
