// TCGeneratorSFFMVoltDlg.cpp : implementation file
//

#include "stdafx.h"
#include "resource.h"
#include "TESuperSpiceEnums.h"
#include "TCMKSConvert.h"
#include "TESuperSpiceLabelEnums.h"
#include "TCSchematicObjectData.h"
#include "TCGeneratorSFFMVoltDlg.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

IMPLEMENT_DYNCREATE(TCGeneratorSFFMVoltDlg, CPropertyPage)

extern int	g_last_active_generator_property_page;


/////////////////////////////////////////////////////////////////////////////
// TCGeneratorSFFMVoltDlg property page

TCGeneratorSFFMVoltDlg::TCGeneratorSFFMVoltDlg() : CPropertyPage(TCGeneratorSFFMVoltDlg::IDD)
{
	//{{AFX_DATA_INIT(TCGeneratorSFFMVoltDlg)
	CMEditVolts1 = _T("");
	CMEditVolts2 = _T("");
	CMEditVolts3 = _T("");
	CMEditVolts4 = _T("");
	CMEditVolts5 = _T("");
	CMEditVolts6 = _T("");
	m_ac_phase_visable = FALSE;
	m_ac_visable = FALSE;
	m_carrier_amplitude_visable = FALSE;
	m_carrier_frequency_visable = FALSE;
	m_dc_visable = FALSE;
	m_modulation_frequency_visable = FALSE;
	m_modulation_visable = FALSE;
	m_offset_visable = FALSE;
	m_imd_f1_visable = FALSE;
	m_imd_f2_visable = FALSE;
	CMEditIMDF1 = _T("");
	CMEditIMDF2 = _T("");
	CMEditVolts8 = _T("");
	CMEditVolts7 = _T("");

	CDCVoltage = _T(""); 
	CACVoltage = _T("");
	CACPhase = _T("");
	COffset = _T("");
	CCarrierMagnitude = _T("");
	CCarrierFrequency = _T("");
	CModulationIndex = _T("");
	CModulationFrequency = _T("");

	//}}AFX_DATA_INIT

	m_ac_phase = 1.0;
	m_ac_voltage = 1.0;
	m_dc_voltage = 1.0;	
	m_carrier_frequency= 1.0;
	m_modulation_frequency= 1.0;
	m_modulation_index= 1.0;
	m_offset= 1.0;
    m_carrier_magnitude= 1.0;
}

TCGeneratorSFFMVoltDlg::~TCGeneratorSFFMVoltDlg()
{
}

void TCGeneratorSFFMVoltDlg::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(TCGeneratorSFFMVoltDlg)
//	DDX_MKSValue(pDX, IDC_EDIT_AC_PHASE, m_ac_phase);
//	DDX_MKSValue(pDX, IDC_EDIT_AC_VOLTAGE, m_ac_voltage);
//	DDX_MKSValue(pDX, IDC_EDIT_DC_VOLTAGE, m_dc_voltage);
//	DDX_MKSValue(pDX, IDC_EDIT_CARRIER_FREQUENCY, m_carrier_frequency);
//	DDX_MKSValue(pDX, IDC_EDIT_MODULATION_FREQUENCY, m_modulation_frequency);
//	DDX_MKSValue(pDX, IDC_EDIT_MODULATION_INDEX, m_modulation_index);
//	DDX_MKSValue(pDX, IDC_EDIT_OFFSET, m_offset);
//	DDX_MKSValue(pDX, IDC_EDIT_CARRIER_AMPLITUDE, m_carrier_magnitude);
	DDX_Text(pDX, IDC_STATIC_VOLTS_CURRENT1, CMEditVolts1);
	DDX_Text(pDX, IDC_STATIC_VOLTS_CURRENT2, CMEditVolts2);
	DDX_Text(pDX, IDC_STATIC_VOLTS_CURRENT3, CMEditVolts3);
	DDX_Text(pDX, IDC_STATIC_VOLTS_CURRENT4, CMEditVolts4);
	DDX_Text(pDX, IDC_STATIC_VOLTS_CURRENT5, CMEditVolts5);
	DDX_Text(pDX, IDC_STATIC_VOLTS_CURRENT6, CMEditVolts6);
	DDX_Check(pDX, IDC_CHECK_AC_PHASE_VISABLE, m_ac_phase_visable);
	DDX_Check(pDX, IDC_CHECK_AC_VISABLE, m_ac_visable);
	DDX_Check(pDX, IDC_CHECK_CARRIER_AMPLIDUDE, m_carrier_amplitude_visable);
	DDX_Check(pDX, IDC_CHECK_CARRIER_FREQUENCY, m_carrier_frequency_visable);
	DDX_Check(pDX, IDC_CHECK_DC_VISABLE, m_dc_visable);
	DDX_Check(pDX, IDC_CHECK_MODULATION_FREQUENCY, m_modulation_frequency_visable);
	DDX_Check(pDX, IDC_CHECK_MODULATION_INDEX, m_modulation_visable);
	DDX_Check(pDX, IDC_CHECK_OFFSET, m_offset_visable);
	DDX_Check(pDX, IDC_CHECK_IMDF1_VISABLE4, m_imd_f1_visable);
	DDX_Check(pDX, IDC_CHECK_IMDF2_VISABLE4, m_imd_f2_visable);
	DDX_Text(pDX, IDC_EDIT_IMD_F2, CMEditIMDF1);
	DDX_Text(pDX, IDC_EDIT_IMD_F4, CMEditIMDF2);
	DDX_Text(pDX, IDC_STATIC_IMD1, CMEditVolts8);
	DDX_Text(pDX, ID_STATIC_IMD2, CMEditVolts7);

	DDX_Text(pDX, IDC_EDIT_DC_VOLTAGE, CDCVoltage);
	DDX_Text(pDX, IDC_EDIT_AC_VOLTAGE, CACVoltage);
	DDX_Text(pDX, IDC_EDIT_AC_PHASE, CACPhase);

	DDX_Text(pDX, IDC_EDIT_OFFSET, COffset);
	DDX_Text(pDX, IDC_EDIT_CARRIER_AMPLITUDE, CCarrierMagnitude);
	DDX_Text(pDX, IDC_EDIT_CARRIER_FREQUENCY, CCarrierFrequency);
	DDX_Text(pDX, IDC_EDIT_MODULATION_INDEX, CModulationIndex);
	DDX_Text(pDX, IDC_EDIT_MODULATION_FREQUENCY, CModulationFrequency);

	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(TCGeneratorSFFMVoltDlg, CPropertyPage)
	//{{AFX_MSG_MAP(TCGeneratorSFFMVoltDlg)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()




BOOL TCGeneratorSFFMVoltDlg::OnSetActive() 
{
	g_last_active_generator_property_page = 1;
	
	return CPropertyPage::OnSetActive();
}

BOOL TCGeneratorSFFMVoltDlg::OnKillActive() 
{
	int value =  CPropertyPage::OnKillActive();

	if(value)
	{
//		PCSchematicObjectData->PCGeneratorData->CDCGeneratorData.dc_voltage	= m_dc_voltage;
//		PCSchematicObjectData->PCGeneratorData->CDCGeneratorData.ac_voltage	= m_ac_voltage;
//		PCSchematicObjectData->PCGeneratorData->CDCGeneratorData.ac_phase	= m_ac_phase;

		PCSchematicObjectData->PCGeneratorData->CDCGeneratorData.dc_voltage	= MKSStringToFloat(CDCVoltage);
		PCSchematicObjectData->PCGeneratorData->CDCGeneratorData.ac_voltage	= MKSStringToFloat(CACVoltage);
		PCSchematicObjectData->PCGeneratorData->CDCGeneratorData.ac_phase	= MKSStringToFloat(CACPhase);

		PCSchematicObjectData->PCGeneratorData->CSFFMGeneratorData.offset = MKSStringToFloat(COffset);
		PCSchematicObjectData->PCGeneratorData->CSFFMGeneratorData.carrier_magnitude = MKSStringToFloat(CCarrierMagnitude);
		PCSchematicObjectData->PCGeneratorData->CSFFMGeneratorData.modulation_index = MKSStringToFloat(CModulationIndex);
		PCSchematicObjectData->PCGeneratorData->CSFFMGeneratorData.modulation_frequency = MKSStringToFloat(CModulationFrequency);
		PCSchematicObjectData->PCGeneratorData->CSFFMGeneratorData.carrier_frequency = MKSStringToFloat(CCarrierFrequency);

		PCSchematicObjectData->PCGeneratorData->CDCGeneratorData.CDCVoltage = CDCVoltage; 
		PCSchematicObjectData->PCGeneratorData->CDCGeneratorData.CACVoltage = CACVoltage;
		PCSchematicObjectData->PCGeneratorData->CDCGeneratorData.CACPhase = CACPhase;

		PCSchematicObjectData->PCGeneratorData->CSFFMGeneratorData.COffset = COffset;
		PCSchematicObjectData->PCGeneratorData->CSFFMGeneratorData.CCarrierMagnitude = CCarrierMagnitude;
		PCSchematicObjectData->PCGeneratorData->CSFFMGeneratorData.CCarrierFrequency = CCarrierFrequency;
		PCSchematicObjectData->PCGeneratorData->CSFFMGeneratorData.CModulationIndex = CModulationIndex;
		PCSchematicObjectData->PCGeneratorData->CSFFMGeneratorData.CModulationFrequency = CModulationFrequency;

		if(!(E_GENERATOR_SFFM_OFFSET_VALUE < PCSchematicObjectData->CLabelListData.GetSize())) return value;

		PCSchematicObjectData->CLabelListData[E_GENERATOR_PHASE_VALUE].is_visable	= !!m_ac_phase_visable;
		PCSchematicObjectData->CLabelListData[E_GENERATOR_AC_VALUE].is_visable		= !!m_ac_visable;
		PCSchematicObjectData->CLabelListData[E_GENERATOR_DC_VALUE].is_visable		= !!m_dc_visable;

		PCSchematicObjectData->CLabelListData[E_GENERATOR_SFFM_OFFSET_VALUE].is_visable					= !!m_offset_visable;
		PCSchematicObjectData->CLabelListData[E_GENERATOR_SFFM_CARRIER_AMPLITUDE_VALUE].is_visable		= !!m_carrier_amplitude_visable;
		PCSchematicObjectData->CLabelListData[E_GENERATOR_SFFM_MODULATION_INDEX_VALUE].is_visable		= !!m_modulation_visable;
		PCSchematicObjectData->CLabelListData[E_GENERATOR_SFFM_MODULATION_FREQUENCY_VALUE].is_visable	= !!m_modulation_frequency_visable;
		PCSchematicObjectData->CLabelListData[E_GENERATOR_SFFM_CARRIER_FREQUENCY_VALUE].is_visable		= !!m_carrier_frequency_visable;
		
		PCSchematicObjectData->CLabelListData[E_GENERATOR_SFFM_IMD1].is_visable = !!m_imd_f1_visable;
		PCSchematicObjectData->CLabelListData[E_GENERATOR_SFFM_IMD2].is_visable = !!m_imd_f2_visable;
		PCSchematicObjectData->CLabelListData[E_GENERATOR_SFFM_IMD1].CLabelValue = CMEditIMDF1;
		PCSchematicObjectData->CLabelListData[E_GENERATOR_SFFM_IMD2].CLabelValue = CMEditIMDF2;

		PCSchematicObjectData->FormatLabels();
	}
	return value;
}

BOOL TCGeneratorSFFMVoltDlg::OnInitDialog() 
{

	m_dc_voltage = PCSchematicObjectData->PCGeneratorData->CDCGeneratorData.dc_voltage;
	m_ac_voltage = PCSchematicObjectData->PCGeneratorData->CDCGeneratorData.ac_voltage;
	m_ac_phase	 = PCSchematicObjectData->PCGeneratorData->CDCGeneratorData.ac_phase;

	m_offset				= PCSchematicObjectData->PCGeneratorData->CSFFMGeneratorData.offset;
	m_carrier_magnitude		= PCSchematicObjectData->PCGeneratorData->CSFFMGeneratorData.carrier_magnitude;
	m_modulation_index		= PCSchematicObjectData->PCGeneratorData->CSFFMGeneratorData.modulation_index;
	m_modulation_frequency  = PCSchematicObjectData->PCGeneratorData->CSFFMGeneratorData.modulation_frequency;
	m_carrier_frequency		= PCSchematicObjectData->PCGeneratorData->CSFFMGeneratorData.carrier_frequency;

	CDCVoltage = PCSchematicObjectData->PCGeneratorData->CDCGeneratorData.CDCVoltage; 
	CACVoltage = PCSchematicObjectData->PCGeneratorData->CDCGeneratorData.CACVoltage;
	CACPhase = PCSchematicObjectData->PCGeneratorData->CDCGeneratorData.CACPhase;
	COffset = PCSchematicObjectData->PCGeneratorData->CSFFMGeneratorData.COffset;
	CCarrierMagnitude = PCSchematicObjectData->PCGeneratorData->CSFFMGeneratorData.CCarrierMagnitude;
	CCarrierFrequency = PCSchematicObjectData->PCGeneratorData->CSFFMGeneratorData.CCarrierFrequency;
	CModulationIndex = PCSchematicObjectData->PCGeneratorData->CSFFMGeneratorData.CModulationIndex;
	CModulationFrequency = PCSchematicObjectData->PCGeneratorData->CSFFMGeneratorData.CModulationFrequency;

	if(E_GENERATOR_SFFM_OFFSET_VALUE < PCSchematicObjectData->CLabelListData.GetSize())
	{
		m_ac_phase_visable	= PCSchematicObjectData->CLabelListData[E_GENERATOR_PHASE_VALUE ].is_visable;
		m_ac_visable		= PCSchematicObjectData->CLabelListData[E_GENERATOR_AC_VALUE].is_visable;
		m_dc_visable		= PCSchematicObjectData->CLabelListData[E_GENERATOR_DC_VALUE].is_visable;

		m_offset_visable				= PCSchematicObjectData->CLabelListData[E_GENERATOR_SFFM_OFFSET_VALUE].is_visable;
		m_carrier_amplitude_visable		= PCSchematicObjectData->CLabelListData[E_GENERATOR_SFFM_CARRIER_AMPLITUDE_VALUE].is_visable;
		m_modulation_visable			= PCSchematicObjectData->CLabelListData[E_GENERATOR_SFFM_MODULATION_INDEX_VALUE].is_visable;
		m_modulation_frequency_visable  = PCSchematicObjectData->CLabelListData[E_GENERATOR_SFFM_MODULATION_FREQUENCY_VALUE].is_visable;
		m_carrier_frequency_visable		= PCSchematicObjectData->CLabelListData[E_GENERATOR_SFFM_CARRIER_FREQUENCY_VALUE].is_visable;

		m_imd_f1_visable	= PCSchematicObjectData->CLabelListData[E_GENERATOR_SFFM_IMD1].is_visable;
		m_imd_f2_visable	= PCSchematicObjectData->CLabelListData[E_GENERATOR_SFFM_IMD2].is_visable;
		CMEditIMDF1			= PCSchematicObjectData->CLabelListData[E_GENERATOR_SFFM_IMD1].CLabelValue;
		CMEditIMDF2			= PCSchematicObjectData->CLabelListData[E_GENERATOR_SFFM_IMD2].CLabelValue;
	}
	CString CText;

	if(PCSchematicObjectData->version > E_SINGLE_FREQ_VOLTAGE_FM)
	{
		CText = "Amps";
	}
	else CText = "Volts";


	CMEditVolts1 = CText;
	CMEditVolts2 = CText;
	CMEditVolts3 = CText;
	CMEditVolts4 = CText;
	CMEditVolts5 = CText;
	CMEditVolts6 = CText;
	CMEditVolts7 = CText;
	CMEditVolts8 = CText;

	CPropertyPage::OnInitDialog();

	return TRUE; 	
}
