// TCGeneratorSineVoltDlg.cpp : implementation file
//

#include "stdafx.h"
#include "resource.h"
#include "TCMKSConvert.h"
#include "TESuperSpiceEnums.h"
#include "TESuperSpiceLabelEnums.h"
#include "TCSchematicObjectData.h"
#include "TCGeneratorSineVoltDlg.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

IMPLEMENT_DYNCREATE(TCGeneratorSineVoltDlg, CPropertyPage)

extern int	g_last_active_generator_property_page;


/////////////////////////////////////////////////////////////////////////////
// TCGeneratorSineVoltDlg property page

TCGeneratorSineVoltDlg::TCGeneratorSineVoltDlg() : CPropertyPage(TCGeneratorSineVoltDlg::IDD)
{
	//{{AFX_DATA_INIT(TCGeneratorSineVoltDlg)
	CMEditVolts1 = _T("");
	CMEditVolts2 = _T("");
	CMEditVolts3 = _T("");
	CMEditVolts4 = _T("");
	m_ac_visable = FALSE;
	m_dc_visable = FALSE;
	m_ac_phase_visable = FALSE;
	m_amplitude_visable = FALSE;
	m_damping_visable = FALSE;
	m_delay_visable = FALSE;
	m_frequency_visable = FALSE;
	m_offset_visable = FALSE;
	m_imd_f1_visable = FALSE;
	m_imd_f2_visable = FALSE;
	CMEditIMDF1 = _T("");
	CMEditIMDF2 = _T("");
	CMEditVolts6 = _T("");
	CMEditVolts7 = _T("");

	CDCVoltage = _T(""); 
	CACVoltage = _T("");
	CACPhase = _T("");
	COffset = _T("");
	CAmplitude = _T("");
	CFrequency = _T("");
	CDelay = _T("");
	CDamping = _T("");

	//}}AFX_DATA_INIT

	m_ac_phase = 1.0;
	m_ac_voltage = 1.0;
	m_dc_voltage = 1.0;	
	m_frequency = 1.0;
	m_amplitude = 1.0;
	m_damping = 1.0;
	m_delay = 1.0;
	m_offset = 1.0;
}

TCGeneratorSineVoltDlg::~TCGeneratorSineVoltDlg()
{
}

void TCGeneratorSineVoltDlg::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(TCGeneratorSineVoltDlg)
//	DDX_MKSValue(pDX, IDC_EDIT_AC_PHASE, m_ac_phase);
//	DDX_MKSValue(pDX, IDC_EDIT_AC_VOLTAGE, m_ac_voltage);
//	DDX_MKSValue(pDX, IDC_EDIT_DC_VOLTAGE, m_dc_voltage);
//	DDX_MKSValue(pDX, IDC_EDIT_FREQUENCY, m_frequency);
//	DDX_MKSValue(pDX, IDC_EDIT_AMPLITUDE, m_amplitude);
//	DDX_MKSValue(pDX, IDC_EDIT_DAMPING, m_damping);
//	DDX_MKSValue(pDX, IDC_EDIT_DELAY, m_delay);
//	DDX_MKSValue(pDX, IDC_EDIT_OFFSET, m_offset);
	DDX_Text(pDX, IDC_STATIC_VOLTS_CURRENT1, CMEditVolts1);
	DDX_Text(pDX, IDC_STATIC_VOLTS_CURRENT2, CMEditVolts2);
	DDX_Text(pDX, IDC_STATIC_VOLTS_CURRENT3, CMEditVolts3);
	DDX_Text(pDX, IDC_STATIC_VOLTS_CURRENT4, CMEditVolts4);
	DDX_Check(pDX, IDC_CHECK_AC_VISABLE, m_ac_visable);
	DDX_Check(pDX, IDC_CHECK_DC_VISABLE, m_dc_visable);
	DDX_Check(pDX, IDC_CHECK_AC_PHASE_VISABLE, m_ac_phase_visable);
	DDX_Check(pDX, IDC_CHECK_AMPLITUDE, m_amplitude_visable);
	DDX_Check(pDX, IDC_CHECK_DAMPING, m_damping_visable);
	DDX_Check(pDX, IDC_CHECK_DELAY, m_delay_visable);
	DDX_Check(pDX, IDC_CHECK_FREQUENCY, m_frequency_visable);
	DDX_Check(pDX, IDC_CHECK_OFFSET, m_offset_visable);
	DDX_Check(pDX, IDC_CHECK_IMDF1_VISABLE5, m_imd_f1_visable);
	DDX_Check(pDX, IDC_CHECK_IMDF2_VISABLE4, m_imd_f2_visable);
	DDX_Text(pDX, IDC_EDIT_IMD_F5, CMEditIMDF1);
	DDX_Text(pDX, IDC_EDIT_IMD_F6, CMEditIMDF2);
	DDX_Text(pDX, IDC_STATIC_IMD1, CMEditVolts6);
	DDX_Text(pDX, IDC_STATIC_IMD2, CMEditVolts7);

	DDX_Text(pDX, IDC_EDIT_DC_VOLTAGE, CDCVoltage);
	DDX_Text(pDX, IDC_EDIT_AC_VOLTAGE, CACVoltage);
	DDX_Text(pDX, IDC_EDIT_AC_PHASE, CACPhase);
	DDX_Text(pDX, IDC_EDIT_OFFSET, COffset);
	DDX_Text(pDX, IDC_EDIT_AMPLITUDE, CAmplitude);
	DDX_Text(pDX, IDC_EDIT_FREQUENCY, CFrequency);
	DDX_Text(pDX, IDC_EDIT_DELAY, CDelay);
	DDX_Text(pDX, IDC_EDIT_DAMPING, CDamping);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(TCGeneratorSineVoltDlg, CPropertyPage)
	//{{AFX_MSG_MAP(TCGeneratorSineVoltDlg)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()




BOOL TCGeneratorSineVoltDlg::OnSetActive() 
{
	g_last_active_generator_property_page = 1;
	
	return CPropertyPage::OnSetActive();
}

BOOL TCGeneratorSineVoltDlg::OnKillActive() 
{
	int value =  CPropertyPage::OnKillActive();

	if(value)
	{
//		PCSchematicObjectData->PCGeneratorData->CDCGeneratorData.dc_voltage	= m_dc_voltage;
//		PCSchematicObjectData->PCGeneratorData->CDCGeneratorData.ac_voltage	= m_ac_voltage;
//		PCSchematicObjectData->PCGeneratorData->CDCGeneratorData.ac_phase	= m_ac_phase;

		PCSchematicObjectData->PCGeneratorData->CDCGeneratorData.dc_voltage	= MKSStringToFloat(CDCVoltage);
		PCSchematicObjectData->PCGeneratorData->CDCGeneratorData.ac_voltage	= MKSStringToFloat(CACVoltage);
		PCSchematicObjectData->PCGeneratorData->CDCGeneratorData.ac_phase	= MKSStringToFloat(CACPhase);

		PCSchematicObjectData->PCGeneratorData->CSineGeneratorData.frequency = MKSStringToFloat(CFrequency);
		PCSchematicObjectData->PCGeneratorData->CSineGeneratorData.amplitude = MKSStringToFloat(CAmplitude);
		PCSchematicObjectData->PCGeneratorData->CSineGeneratorData.offset = MKSStringToFloat(COffset);
		PCSchematicObjectData->PCGeneratorData->CSineGeneratorData.delay = MKSStringToFloat(CDelay);
		PCSchematicObjectData->PCGeneratorData->CSineGeneratorData.damping = MKSStringToFloat(CDamping);

		PCSchematicObjectData->PCGeneratorData->CDCGeneratorData.CDCVoltage = CDCVoltage; 
		PCSchematicObjectData->PCGeneratorData->CDCGeneratorData.CACVoltage = CACVoltage;
		PCSchematicObjectData->PCGeneratorData->CDCGeneratorData.CACPhase = CACPhase;

		PCSchematicObjectData->PCGeneratorData->CSineGeneratorData.COffset = COffset;
		PCSchematicObjectData->PCGeneratorData->CSineGeneratorData.CAmplitude = CAmplitude;
		PCSchematicObjectData->PCGeneratorData->CSineGeneratorData.CFrequency = CFrequency;
		PCSchematicObjectData->PCGeneratorData->CSineGeneratorData.CDelay = CDelay;
		PCSchematicObjectData->PCGeneratorData->CSineGeneratorData.CDamping = CDamping;

		if(!(E_GENERATOR_SINE_DAMPING_VALUE < PCSchematicObjectData->CLabelListData.GetSize())) return value;

		PCSchematicObjectData->CLabelListData[E_GENERATOR_AC_VALUE].is_visable		= !!m_ac_visable;
		PCSchematicObjectData->CLabelListData[E_GENERATOR_DC_VALUE].is_visable		= !!m_dc_visable;
		PCSchematicObjectData->CLabelListData[E_GENERATOR_PHASE_VALUE].is_visable	= !!m_ac_phase_visable;

		PCSchematicObjectData->CLabelListData[E_GENERATOR_SINE_AMPLITUDE_VALUE].is_visable	= !!m_amplitude_visable;
		PCSchematicObjectData->CLabelListData[E_GENERATOR_SINE_FREQUENCY_VALUE].is_visable	= !!m_frequency_visable;
		PCSchematicObjectData->CLabelListData[E_GENERATOR_SINE_OFFSET_VALUE].is_visable		= !!m_offset_visable;
		PCSchematicObjectData->CLabelListData[E_GENERATOR_SINE_DELAY_VALUE].is_visable		= !!m_delay_visable;
		PCSchematicObjectData->CLabelListData[E_GENERATOR_SINE_DAMPING_VALUE].is_visable	= !!m_damping_visable;

		PCSchematicObjectData->CLabelListData[E_GENERATOR_SINE_IMD1].is_visable = !!m_imd_f1_visable;
		PCSchematicObjectData->CLabelListData[E_GENERATOR_SINE_IMD2].is_visable = !!m_imd_f2_visable;
		PCSchematicObjectData->CLabelListData[E_GENERATOR_SINE_IMD1].CLabelValue = CMEditIMDF1;
		PCSchematicObjectData->CLabelListData[E_GENERATOR_SINE_IMD2].CLabelValue = CMEditIMDF2;

		PCSchematicObjectData->FormatLabels();
	}
	return value;
}

BOOL TCGeneratorSineVoltDlg::OnInitDialog() 
{

	m_dc_voltage = PCSchematicObjectData->PCGeneratorData->CDCGeneratorData.dc_voltage;
	m_ac_voltage = PCSchematicObjectData->PCGeneratorData->CDCGeneratorData.ac_voltage;
	m_ac_phase	 = PCSchematicObjectData->PCGeneratorData->CDCGeneratorData.ac_phase;

	m_amplitude = PCSchematicObjectData->PCGeneratorData->CSineGeneratorData.amplitude;
	m_frequency = PCSchematicObjectData->PCGeneratorData->CSineGeneratorData.frequency;
	m_offset	= PCSchematicObjectData->PCGeneratorData->CSineGeneratorData.offset;
	m_delay		= PCSchematicObjectData->PCGeneratorData->CSineGeneratorData.delay;
	m_damping	= PCSchematicObjectData->PCGeneratorData->CSineGeneratorData.damping;

	CDCVoltage	= PCSchematicObjectData->PCGeneratorData->CDCGeneratorData.CDCVoltage; 
	CACVoltage	= PCSchematicObjectData->PCGeneratorData->CDCGeneratorData.CACVoltage;
	CACPhase	= PCSchematicObjectData->PCGeneratorData->CDCGeneratorData.CACPhase;

	COffset		= PCSchematicObjectData->PCGeneratorData->CSineGeneratorData.COffset;
	CAmplitude	= PCSchematicObjectData->PCGeneratorData->CSineGeneratorData.CAmplitude;
	CFrequency	= PCSchematicObjectData->PCGeneratorData->CSineGeneratorData.CFrequency;
	CDelay		= PCSchematicObjectData->PCGeneratorData->CSineGeneratorData.CDelay;
	CDamping	= PCSchematicObjectData->PCGeneratorData->CSineGeneratorData.CDamping;

	if(E_GENERATOR_SINE_DAMPING_VALUE < PCSchematicObjectData->CLabelListData.GetSize())
	{
		m_ac_visable		= PCSchematicObjectData->CLabelListData[E_GENERATOR_AC_VALUE].is_visable;
		m_dc_visable		= PCSchematicObjectData->CLabelListData[E_GENERATOR_DC_VALUE].is_visable;
		m_ac_phase_visable	= PCSchematicObjectData->CLabelListData[E_GENERATOR_PHASE_VALUE].is_visable;

		m_amplitude_visable	= PCSchematicObjectData->CLabelListData[E_GENERATOR_SINE_AMPLITUDE_VALUE].is_visable;
		m_frequency_visable	= PCSchematicObjectData->CLabelListData[E_GENERATOR_SINE_FREQUENCY_VALUE].is_visable;
		m_offset_visable	= PCSchematicObjectData->CLabelListData[E_GENERATOR_SINE_OFFSET_VALUE].is_visable;
		m_delay_visable		= PCSchematicObjectData->CLabelListData[E_GENERATOR_SINE_DELAY_VALUE].is_visable;
		m_damping_visable	= PCSchematicObjectData->CLabelListData[E_GENERATOR_SINE_DAMPING_VALUE].is_visable;

		m_imd_f1_visable	= PCSchematicObjectData->CLabelListData[E_GENERATOR_SINE_IMD1].is_visable;
		m_imd_f2_visable	= PCSchematicObjectData->CLabelListData[E_GENERATOR_SINE_IMD2].is_visable;
		CMEditIMDF1			= PCSchematicObjectData->CLabelListData[E_GENERATOR_SINE_IMD1].CLabelValue;
		CMEditIMDF2			= PCSchematicObjectData->CLabelListData[E_GENERATOR_SINE_IMD2].CLabelValue;
	}
	CString CText;

	if(PCSchematicObjectData->version > E_SINGLE_FREQ_VOLTAGE_FM)
	{
		CText = "Amps";
	}
	else CText = "Volts";


	CMEditVolts1 = CText;
	CMEditVolts2 = CText;
	CMEditVolts3 = CText;
	CMEditVolts4 = CText;
	CMEditVolts7 = CText;
	CMEditVolts6 = CText;

	CPropertyPage::OnInitDialog();

	return TRUE; 	
}
