// TCGenericLabelsDlg.cpp : implementation file
//

#include "stdafx.h"
#include "resource.h"
#include "TESuperSpiceEnums.h"
#include "TEPropertyViewTypes.h"
#include "TESuperSpiceLabelEnums.h"
#include "TCSchematicObjectData.h"
#include "TCGenericLabelsDlg.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

IMPLEMENT_DYNCREATE(TCGenericLabelsDlg, CPropertyPage)

extern int g_last_active_generator_property_page;
extern double MKSStringToFloat(CString &CTextData);
extern CString FloatToSpiceMKSString(double data);

/////////////////////////////////////////////////////////////////////////////
// TCGenericLabelsDlg property page

TCGenericLabelsDlg::TCGenericLabelsDlg() : CPropertyPage(TCGenericLabelsDlg::IDD)
{
	//{{AFX_DATA_INIT(TCGenericLabelsDlg)
	m_ref_des_visable = FALSE;
	m_spice_name_visable = FALSE;
	m_value_visable = FALSE;
	CMEditSpicename = _T("");
	CMEditRefDes = _T("");
	CMEditValue = _T("");
	m_type_name_visable = FALSE;
	CMEditTypeName = _T("");
	CMEditValueHeader = _T("");
	//}}AFX_DATA_INIT
}

TCGenericLabelsDlg::~TCGenericLabelsDlg()
{
}

void TCGenericLabelsDlg::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(TCGenericLabelsDlg)
	DDX_Control(pDX, IDC_EDIT_TYPE_NAME, CMEditCntlTypeName);
	DDX_Control(pDX, IDC_EDIT_VALUE, CMEditCntlValue);
	DDX_Control(pDX, IDC_EDIT_SPICE_NAME, CMEditCntlSpiceName);
	DDX_Control(pDX, IDC_EDIT_REF_DESIGNATOR, CMEditCntlRefDes);
	DDX_Check(pDX, IDC_CHECK_VISABLE_REF_DESIGNATOR, m_ref_des_visable);
	DDX_Check(pDX, IDC_CHECK_VISABLE_SPICE_NAME, m_spice_name_visable);
	DDX_Check(pDX, IDC_CHECK_VISABLE_VALUE, m_value_visable);
	DDX_Text(pDX, IDC_EDIT_SPICE_NAME, CMEditSpicename);
	DDX_Text(pDX, IDC_EDIT_REF_DESIGNATOR, CMEditRefDes);
	DDX_Text(pDX, IDC_EDIT_VALUE, CMEditValue);
	DDX_Check(pDX, IDC_CHECK_VISABLE_TYPE_NAME, m_type_name_visable);
	DDX_Text(pDX, IDC_EDIT_TYPE_NAME, CMEditTypeName);
	DDX_Text(pDX, IDC_STATIC_VALUE, CMEditValueHeader);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(TCGenericLabelsDlg, CPropertyPage)
	//{{AFX_MSG_MAP(TCGenericLabelsDlg)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()



BOOL TCGenericLabelsDlg::OnKillActive() 
{
	
	CPropertyPage::OnKillActive();

	if(!PCSchematicObjectData) return true;

	PCSchematicObjectData->CLabelListData[E_COMPONENT_SYMBOL_NAME].is_visable = !!m_type_name_visable;
	PCSchematicObjectData->CLabelListData[E_COMPONENT_SYMBOL_NAME].CLabel = 	CMEditTypeName;

	PCSchematicObjectData->CLabelListData[E_COMPONENT_VALUE].is_visable = !!m_value_visable;
	
	double data =  MKSStringToFloat(CMEditValue);

	if(!data) CMEditValue = "1m";
	
	PCSchematicObjectData->CLabelListData[E_COMPONENT_VALUE].CLabel = CMEditValue;

	PCSchematicObjectData->CLabelListData[E_COMPONENT_DESIGNATOR].is_visable = !!m_ref_des_visable;
	PCSchematicObjectData->CLabelListData[E_COMPONENT_DESIGNATOR].CLabel = CMEditRefDes;

	PCSchematicObjectData->CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].is_visable = !!m_spice_name_visable;
	PCSchematicObjectData->CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel = CMEditSpicename;

	return true;
}

BOOL TCGenericLabelsDlg::OnSetActive() 
{
	g_last_active_generator_property_page = 0;
		
	// need to update from value set in other page
	CMEditValue	=  PCSchematicObjectData->CLabelListData[E_COMPONENT_VALUE].CLabel;

	PCSchematicObjectData->FormatSpiceName();

	CMEditSpicename	=  PCSchematicObjectData->CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel;

	return CPropertyPage::OnSetActive();
}

BOOL TCGenericLabelsDlg::OnInitDialog() 
{
	 
	m_type_name_visable = PCSchematicObjectData->CLabelListData[E_COMPONENT_SYMBOL_NAME].is_visable;
	CMEditTypeName		=  PCSchematicObjectData->CLabelListData[E_COMPONENT_SYMBOL_NAME].CLabel;

	m_value_visable = PCSchematicObjectData->CLabelListData[E_COMPONENT_VALUE].is_visable;
	CMEditValue		=  PCSchematicObjectData->CLabelListData[E_COMPONENT_VALUE].CLabel;

	m_ref_des_visable = PCSchematicObjectData->CLabelListData[E_COMPONENT_DESIGNATOR].is_visable;
	CMEditRefDes		=  PCSchematicObjectData->CLabelListData[E_COMPONENT_DESIGNATOR].CLabel;

	m_spice_name_visable = PCSchematicObjectData->CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].is_visable;
	CMEditSpicename		=  PCSchematicObjectData->CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].CLabel;

	CMEditValueHeader = "Spice value";

	CPropertyPage::OnInitDialog();

//	CMEditCntlSpiceName.SetReadOnly(PCSchematicObjectData->CLabelListData[E_COMPONENT_SPICE_MODEL_NAME].read_only);
	CMEditCntlValue.SetReadOnly(PCSchematicObjectData->CLabelListData[E_COMPONENT_VALUE].read_only);
	CMEditCntlRefDes.SetReadOnly(PCSchematicObjectData->CLabelListData[E_COMPONENT_DESIGNATOR].read_only);

	return TRUE;  
}


