/*

	Copywrite Kevin Aylward (c) 1996
	
	File:	TCGraphicBitMapVectorObject.cpp




 */

#include "stdafx.h"
#include "math.h"
#include "TESuperSpiceEnums.h"
#include "TCGraphicsFunctions.h"
#include "Generic.h"
#include "TCWireInfo.h"
#include "TCGraphicBitMapVectorObject.h"
#include "TCSuperSpiceGlobalData.h"
#include "TCOutputWaveformData.h"


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

extern HDC	HDCMSrcCmp;
extern HDC	HDCMDestCmp;
extern CDC GlobalCDCTemp;
extern int global_screen_planes;
extern int global_screen_bitspixels;

CBitmap	CBitmapTemp1;
CBitmap	CBitmapTemp2;


IMPLEMENT_SERIAL(TCGraphicBitMapVectorObject, TCGraphicObject, ID_VERSION_NUMBER )

extern TCSuperSpiceGlobalData	GCSuperSpiceGlobalData;

/////////////////////////

IMPLEMENT_SERIAL(TCWaveFormDrawData, CObject, ID_VERSION_NUMBER)

TCWaveFormDrawData::TCWaveFormDrawData(void)
{

}

TCWaveFormDrawData::TCWaveFormDrawData(TCWaveFormDrawData &CWaveFormDrawData)
{
	*this = CWaveFormDrawData;
}

TCWaveFormDrawData::~TCWaveFormDrawData(void)
{

}

void TCWaveFormDrawData::Serialize(CArchive& CArchiveFile)
{
	CObject::Serialize(CArchiveFile);

	if(CArchiveFile.IsStoring())
	{

	}
	else
	{

	}
}

void TCWaveFormDrawData::operator = (TCWaveFormDrawData &CWaveFormDrawData)
{
	int count = CWaveFormDrawData.CLines.GetSize();

	CLines.SetSize(count);

	for(int p = 0; p < count; p++)
	{
		CLines[p] = CWaveFormDrawData.CLines[p];
	}
}

void TCWaveFormDrawData::operator = (CArray <TCLineData,  TCLineData &> &CLineData)
{
	int count = CLineData.GetSize();

	CLines.SetSize(count);

	for(int p = 0; p < count; p++)
	{
		CLines[p] = CLineData[p];
	}
}

////////////////////////
TCGraphicBitMapVectorObject::TCGraphicBitMapVectorObject():TCGraphicObject()
{
	fm_bitmap_vector_loaded = false;
	m_active_line_color		= m_line_color;
	m_snap_to_distance		= 12;
	PCWaveformDataRuns		= NULL;
	PCParentHeader			= NULL;
	m_waveform_index_start  = 0;
	m_waveform_index		= 0;
	is_symbol_editor		= false;
	m_line_gradient			= 1;
	m_line_constant			= 0.0;
}

TCGraphicBitMapVectorObject::TCGraphicBitMapVectorObject(TCGraphicBitMapVectorObject &CGraphiCBitmapVectorObject)
{
	*this = CGraphiCBitmapVectorObject;
}
	
			
TCGraphicBitMapVectorObject::~TCGraphicBitMapVectorObject()
{
	if(m_mode == E_VECTOR_OBJECT) VectorDelete();
	else DeleteBitmapNew();
}

int TCGraphicBitMapVectorObject::GetGridSize(void)
{
	if(is_symbol_editor) return GCSuperSpiceGlobalData.CDrawData.symbol_editor_grid_size;
	return GCSuperSpiceGlobalData.CDrawData.grid_size;
}

int TCGraphicBitMapVectorObject::GetSnapToDistance(void)
{
	// * 2 is a fudge to give lines and pins more optimum resolution
	if(is_symbol_editor) return 2*GCSuperSpiceGlobalData.CDrawData.symbol_editor_snap_to_distance;
	return GCSuperSpiceGlobalData.CDrawData.snap_to_distance;
}

bool TCGraphicBitMapVectorObject::IsSnapToGridOn(void)
{
	if(GCSuperSpiceGlobalData.CDrawData.symbol_editor_overide_snap_to_grid) return false;

	return !!GCSuperSpiceGlobalData.CDrawData.is_snap_to_grid_on;
}

void TCGraphicBitMapVectorObject::DeleteBitmapNew(void)
{
	if(!fm_bitmap_vector_loaded) return;

	if(m_mode == E_VECTOR_OBJECT)
	{
		VectorDelete();

		return;
	}


	CBitmapBackground.DeleteObject();
	CBitmapTemp1.DeleteObject();
	CBitmapTemp2.DeleteObject();
	CBitmapImage.DeleteObject();
	CBitmapImageMask.DeleteObject();
	
	fm_bitmap_vector_loaded = false;
}

void TCGraphicBitMapVectorObject::Serialize(CArchive& archive)
{
	TCGraphicObject::Serialize(archive);

	if(m_mode == E_VECTOR_OBJECT)
	{
		VectorSerialize(archive);

		return;
	}

	if (archive.IsStoring())
	{
		// TODO: add storing code here
	}
	else
	{
		CreateGrabRegion(CMLocation);

		HBActiveImage  = CBitmapImage;

		if(m_selected) SetSelect();
		else if(m_highlighted)SetHighlight(true);
	}
}

bool TCGraphicBitMapVectorObject::CreateTempBitmaps(void)
{
	if(m_selected)
		m_active_line_color = m_line_selected_color;
	else
		m_active_line_color = m_line_color;
	if(m_highlighted) 
		m_active_line_color = m_line_highlighted_color;

	LOGFONT sm_logfont = *GetLogFont();

	LOGFONT s_logfont = sm_logfont;

	s_logfont.lfHeight = (LONG)(sm_logfont.lfHeight * m_zoom);
	s_logfont.lfWidth  = (LONG)(sm_logfont.lfWidth * m_zoom);

	float connection_dot = false;

	if(m_type == 666)
	{
		connection_dot = m_zoom * GCSuperSpiceGlobalData.CDrawData.connection_dot_size;
	}

	if(!CBitmapImageMask.CreateTextMaskBitmap(&GlobalCDCTemp, s_logfont, CMLabel, connection_dot))
	{
		return false;
	}

	if(!CBitmapImage.CreateTextBitmap(&GlobalCDCTemp, s_logfont, CMLabel, m_active_line_color, connection_dot)) 
	{
		CBitmapImageMask.DeleteObject();

		return false;
	}

	if(!CBitmapTemp2.CreateBitmap(m_object_width, m_object_height, global_screen_planes, global_screen_bitspixels,  NULL))
	{
		CBitmapImageMask.DeleteObject();
		CBitmapImage.DeleteObject();

		return false;
	}

	if(!CBitmapTemp1.CreateBitmap(m_object_width, m_object_height, global_screen_planes, global_screen_bitspixels,  NULL))
	{
		CBitmapImageMask.DeleteObject();
		CBitmapImage.DeleteObject();
		CBitmapTemp2.DeleteObject(); 

		return false;
	}


	HBActiveImage  = CBitmapImage;


	return true;
}

void TCGraphicBitMapVectorObject::DeleteTempBitmaps(void)
{
	CBitmapTemp1.DeleteObject();
	CBitmapTemp2.DeleteObject();
	CBitmapImage.DeleteObject(); 
	CBitmapImageMask.DeleteObject();
//	CBitmapImageSelected.DeleteObject();

//	if(GCSuperSpiceGlobalData.CDrawData.hyde_labels)
//		CBitmapBackground.DeleteObject();// testing gdi
	//Save CBitmapBackground in  non GDI memory and 
	//then delete CBitmapBackground
}

bool TCGraphicBitMapVectorObject::Create(int id_bitmap, int id_bitmap_mask, int id_bit_map_selected, int id_bitmap_highlighted)
{
	if(!id_bitmap)				return false;
	if(!id_bitmap_mask)			return false;
	if(!id_bit_map_selected)	return false;

	if(!id_bitmap_highlighted) id_bitmap_highlighted = id_bit_map_selected;
	
	fm_bitmap_vector_loaded	= false;

	if(!CBitmapImage.LoadBitmap(id_bitmap)) return false;


	m_mode = E_BITMAP_OBJECT;
	
	if(!CBitmapImageMask.LoadBitmap(id_bitmap_mask))
	{
		CBitmapImage.DeleteObject();

		return false;
	}

	if(!CBitmapBackground.LoadBitmap(id_bitmap_mask))// initial value not important
	{
		CBitmapImage.DeleteObject();
		CBitmapImageMask.DeleteObject(); 

		return false;
	}

	if(!CBitmapImageSelected.LoadBitmap(id_bit_map_selected))
	{
		
		CBitmapImage.DeleteObject();
		CBitmapImageMask.DeleteObject(); 
		CBitmapBackground.DeleteObject();
		CBitmapTemp1.DeleteObject();
		CBitmapTemp2.DeleteObject();

		return false;
	}

	if(!CBitmapImageHighlighted.LoadBitmap(id_bitmap_highlighted))
	{
		
		CBitmapImage.DeleteObject();
		CBitmapImageMask.DeleteObject(); 
		CBitmapBackground.DeleteObject();
		CBitmapTemp1.DeleteObject();
		CBitmapTemp2.DeleteObject();
		CBitmapImageSelected.DeleteObject();

		return false;
	}

	HBActiveImage  = CBitmapImage;

	BITMAP Bitmap;
	GetObject(CBitmapImage, sizeof(BITMAP), &Bitmap);

	m_object_width	= (unsigned short)Bitmap.bmWidth;
	m_object_height	= (unsigned short)Bitmap.bmHeight;

	CMCenterPoint.x = m_object_width/2;
	CMCenterPoint.y = m_object_height/2;

	fm_bitmap_vector_loaded = true;
	
	return true;
}

bool TCGraphicBitMapVectorObject::Create(CDC *PCViewDC, CString CText, float zoom, COLORREF text_colour,
									COLORREF selected_colour, COLORREF highlighted_colour)
{
	if(!PCViewDC)	return false;
	if(CText == "") return false;


	m_mode						= E_BITMAP_TEXT_OBJECT;
	m_zoom						= zoom;
	m_line_color				= text_colour;
	m_line_highlighted_color	= highlighted_colour;
	m_line_selected_color		= selected_colour;
	m_active_line_color			= m_line_color;
	CMLabel						= CText;
	
	if(!m_property) m_property = E_SCHEMATIC_LABEL;

	fm_bitmap_vector_loaded	= false;
	m_box_select			= true;

	CFont CTextFont;// Only need to get bitmap sizes

	LOGFONT sm_logfont = *GetLogFont();

	LOGFONT s_logfont = sm_logfont;

	s_logfont.lfHeight = (LONG)(s_logfont.lfHeight * zoom);
	s_logfont.lfWidth  = (LONG)(s_logfont.lfWidth * zoom);

//	s_logfont.lfEscapement  = 270; 
//	s_logfont.lfOrientation = 270; 

	if(!CTextFont.CreateFontIndirect(&s_logfont))return false;

	CFont *COldFont	= PCViewDC->SelectObject(&CTextFont);

	if(!COldFont)
	{
		CTextFont.DeleteObject();

		return false;
	}
	CSize CBitmapSize	= PCViewDC->GetTextExtent(CText);

	PCViewDC->SelectObject(COldFont);
	CTextFont.DeleteObject();

	float connection_dot = false;

	if(m_type == 666)
	{
		connection_dot = m_zoom * GCSuperSpiceGlobalData.CDrawData.connection_dot_size;

		CBitmapSize.cx = (int)(connection_dot);
		CBitmapSize.cy = (int)(connection_dot);
	}

	m_object_width	= (unsigned short)CBitmapSize.cx;
	m_object_height	= (unsigned short)CBitmapSize.cy;

	CMCenterPoint.x = (m_object_width >> 1);
	CMCenterPoint.y = (m_object_height >> 1);

	if(!GCSuperSpiceGlobalData.CDrawData.hyde_labels || m_property == E_SCHEMATIC_TEXT_LABEL)
		if(!CBitmapBackground.CreateTextBitmap(PCViewDC, s_logfont, CText, m_line_color, connection_dot)) return false;

	HBActiveImage  = CBitmapImage;

	fm_bitmap_vector_loaded = true;

	return true;
}
bool TCGraphicBitMapVectorObject::CreateBitmapBackgroundLabel(void)
{
	CBitmapBackground.DeleteObject();

	LOGFONT sm_logfont = *GetLogFont();	
	
	LOGFONT s_logfont = sm_logfont;

	s_logfont.lfHeight = (LONG)(sm_logfont.lfHeight * m_zoom);
	s_logfont.lfWidth  = (LONG)(sm_logfont.lfWidth * m_zoom);

	CDC CDCTemp;

	CDCTemp.CreateCompatibleDC(NULL);

	float connection_dot = false;

	if(m_type == 666)
	{
		connection_dot = m_zoom * GCSuperSpiceGlobalData.CDrawData.connection_dot_size;
	}
	
	if(!CBitmapBackground.CreateTextBitmap(&CDCTemp, s_logfont, CMLabel, m_line_color, connection_dot)) return false;

	TCTextBitmap CBitmapTemp;

	if(!CBitmapTemp.CreateTextBitmap(&CDCTemp, s_logfont, CMLabel, m_line_color, connection_dot))
	{
		CBitmapBackground.DeleteObject();

		return false;
	}
	HDC htemp = CDCTemp.m_hDC;// Fake a background, this will do for now

	CBrush CBackgroundBrush(GCSuperSpiceGlobalData.CColorData.background);
 
	CBrush* pOldBrush = CDCTemp.SelectObject(&CBackgroundBrush);
 
	HOMDest	= SelectObject(CDCTemp, CBitmapTemp);// create space
	CDCTemp.PatBlt(0, 0, m_object_width, m_object_height, PATCOPY);
			
	HOMSrc	= SelectObject(HDCMDestCmp, CBitmapBackground);

	BitBlt(HDCMDestCmp, 0, 0, m_object_width, m_object_height, htemp, 0, 0, SRCCOPY);

	SelectObject(CDCTemp, HOMDest);

	SelectObject(HDCMDestCmp, HOMSrc);

	CDCTemp.SelectObject(pOldBrush);

	CBackgroundBrush.DeleteObject();

	CBitmapTemp.DeleteObject();

	return true;
}

int TCGraphicBitMapVectorObject::Create(TCGraphicBitMapVectorObject &CGraphiCBitmapObject)
{
	fm_bitmap_vector_loaded	= false;

	if(m_property == E_SCHEMATIC_TEXT_LABEL || m_property == E_SCHEMATIC_LABEL || m_property == E_SCHEMATIC_PIN_LABEL)
	{
		CDC CDCTemp;

		if(!CDCTemp.CreateCompatibleDC(NULL)) return false;
		
		
		Create(&CDCTemp, CGraphiCBitmapObject.CMLabel, CGraphiCBitmapObject.m_zoom, 
			    CGraphiCBitmapObject.m_line_color, CGraphiCBitmapObject.m_line_selected_color,
				CGraphiCBitmapObject.m_line_highlighted_color);


		fm_bitmap_vector_loaded = true;

		return true;
	}

	//this wont get called yet until  bitmap suporrt is finished
	BITMAP Bitmap;

	GetObject(CGraphiCBitmapObject.CBitmapImage, sizeof(BITMAP), &Bitmap);

	int bitspixels = Bitmap.bmBitsPixel;
	int planes		= Bitmap.bmPlanes;

	m_object_width	= CGraphiCBitmapObject.m_object_width;
	m_object_height = CGraphiCBitmapObject.m_object_height;
	if(!CBitmapImage.CreateBitmap(m_object_width, m_object_height, planes, bitspixels,  NULL)) return false;
	
	if(!CBitmapImageMask.CreateBitmap(m_object_width, m_object_height, planes, bitspixels,  NULL))
	{
		CBitmapImage.DeleteObject();

		return false;
	}

	if(!CBitmapBackground.CreateBitmap(m_object_width, m_object_height, planes, bitspixels,  NULL))// initial value not important
	{
		CBitmapImage.DeleteObject();
		CBitmapImageMask.DeleteObject(); 

		return false;
	}

	if(!CBitmapTemp1.CreateBitmap(m_object_width, m_object_height, planes, bitspixels,  NULL))
	{
		CBitmapImage.DeleteObject();
		CBitmapImageMask.DeleteObject(); 
		CBitmapBackground.DeleteObject(); 

		return false;
	}
	if(!CBitmapTemp2.CreateBitmap(m_object_width, m_object_height, planes, bitspixels,  NULL))
	{
		
		CBitmapImage.DeleteObject();
		CBitmapImageMask.DeleteObject(); 
		CBitmapBackground.DeleteObject();
		CBitmapTemp1.DeleteObject(); 

		return false;
	}

	
	if(!CBitmapImageSelected.CreateBitmap(m_object_width, m_object_height, planes, bitspixels,  NULL))
	{
		
		CBitmapImage.DeleteObject();
		CBitmapImageMask.DeleteObject(); 
		CBitmapBackground.DeleteObject();
		CBitmapTemp1.DeleteObject();
		CBitmapTemp2.DeleteObject();

		return false;
	}

	if(!CBitmapImageHighlighted.CreateBitmap(m_object_width, m_object_height, planes, bitspixels,  NULL))
	{
		
		CBitmapImage.DeleteObject();
		CBitmapImageMask.DeleteObject(); 
		CBitmapBackground.DeleteObject();
		CBitmapTemp1.DeleteObject();
		CBitmapTemp2.DeleteObject();
		CBitmapImageSelected.DeleteObject();

		return false;
	}


	CPoint CStartLocation(0, 0);
	CreateGrabRegion(CStartLocation);

	HBActiveImage  = CBitmapImage;

	HOMDest = SelectObject(HDCMDestCmp, CBitmapImage);
	HOMSrc	= SelectObject(HDCMSrcCmp, CGraphiCBitmapObject.CBitmapImage);

	BitBlt(HDCMDestCmp, 0, 0, m_object_width, m_object_height, HDCMSrcCmp, 0, 0, SRCCOPY);

	SelectObject(HDCMDestCmp, CBitmapImageMask);
	SelectObject(HDCMSrcCmp, CGraphiCBitmapObject.CBitmapImageMask);

	BitBlt(HDCMDestCmp, 0, 0, m_object_width, m_object_height, HDCMSrcCmp, 0, 0, SRCCOPY);

	SelectObject(HDCMDestCmp, CBitmapImageSelected);
	SelectObject(HDCMSrcCmp, CGraphiCBitmapObject.CBitmapImageSelected);

	BitBlt(HDCMDestCmp, 0, 0, m_object_width, m_object_height, HDCMSrcCmp, 0, 0, SRCCOPY);

	SelectObject(HDCMDestCmp, CBitmapImageHighlighted);
	SelectObject(HDCMSrcCmp, CGraphiCBitmapObject.CBitmapImageHighlighted);

	BitBlt(HDCMDestCmp, 0, 0, m_object_width, m_object_height, HDCMSrcCmp, 0, 0, SRCCOPY);

	SelectObject(HDCMSrcCmp, HOMSrc);       
	SelectObject(HDCMDestCmp, HOMDest);	      

	DeleteTempBitmaps();

	fm_bitmap_vector_loaded = true;

	return true;
}

bool TCGraphicBitMapVectorObject::Create(CArray <TCLineData, TCLineData &> &CSymbolData, unsigned short width, unsigned short height,
								COLORREF normal_colour,
				                COLORREF selected_colour,
								COLORREF highlighted_colour)
{

	m_line_color				= normal_colour;
	m_line_selected_color		= selected_colour;
	m_line_highlighted_color	= highlighted_colour;
	m_line_width				= 1;
	m_object_width				= width;
	m_object_height				= height;

	CMCenterPoint.x = m_object_width/2;
	CMCenterPoint.y = m_object_height/2;

	m_mode						= E_VECTOR_OBJECT;

	CPoint CStartLocation(0, 0);

	int size = CSymbolData.GetSize();
	
	CMDrawLineData.SetSize(size, size);

	for(int p = 0; p < size; p++) 
	{
		CMDrawLineData[p] = CSymbolData[p];
		CMDrawLineData[p].FormatLinePoints();
	}

	fm_bitmap_vector_loaded = true;

	return true;
}

bool TCGraphicBitMapVectorObject::Create(TCWaveformDataRuns *PCWaveformDataRunsParent, TCOutputWaveformDataHeader *PCHeader, int waveform_type)
{
	m_mode				= E_VECTOR_OBJECT;
	PCWaveformDataRuns	= PCWaveformDataRunsParent;
	PCParentHeader		= PCHeader;
	m_waveform_index	= waveform_type;

	fm_bitmap_vector_loaded = true;

	return true;
}

void TCGraphicBitMapVectorObject::operator = (TCGraphicBitMapVectorObject &CGraphiCBitmapObject)
{
	TCGraphicObject::operator = (CGraphiCBitmapObject);

	is_symbol_editor = CGraphiCBitmapObject.is_symbol_editor;

	if(CGraphiCBitmapObject.m_mode == E_VECTOR_OBJECT)
	{
		PCWaveformDataRuns		= CGraphiCBitmapObject.PCWaveformDataRuns;
		m_waveform_index		= CGraphiCBitmapObject.m_waveform_index;
		m_waveform_index_start	= CGraphiCBitmapObject.m_waveform_index_start;


		if(!CGraphiCBitmapObject.fm_bitmap_vector_loaded) return;

		fm_bitmap_vector_loaded = true;

		int size = CGraphiCBitmapObject.CMDrawLineData.GetSize();

		CMDrawLineData.SetSize(size, size);

		for(int p = 0; p < size; p++)
		{
			CMDrawLineData[p] = CGraphiCBitmapObject.CMDrawLineData[p];
		}
		m_draw_angle		= CGraphiCBitmapObject.m_draw_angle;
		m_snap_to_distance	= CGraphiCBitmapObject.m_snap_to_distance;

		if(m_selected)
			m_active_line_color  = m_line_selected_color;
		else
			m_active_line_color  = m_line_color;

		if(m_highlighted) m_active_line_color = m_line_highlighted_color;

		return;
	}

	DeleteBitmapNew();

	Create(CGraphiCBitmapObject);

	if(m_selected)
		HBActiveImage  = CBitmapImageSelected;
	else
		HBActiveImage  = CBitmapImage;

	if(m_highlighted) HBActiveImage = CBitmapImageHighlighted;
}


bool TCGraphicBitMapVectorObject::GetBackground(CDC *PCDC)
{
	if(m_mode == E_VECTOR_OBJECT)
	{
		return VectorGetBackground(PCDC);
	}

	HDC HDCDest = PCDC->m_hDC;

	int x = CMLocation.x;
	int y = CMLocation.y;

	CreateTempBitmaps();

	HOMDest = SelectObject(HDCMDestCmp, CBitmapBackground);

	BitBlt(HDCMDestCmp, 0, 0, m_object_width, m_object_height, HDCDest, x, y, SRCCOPY);

	SelectObject(HDCMDestCmp, HOMDest);

	DeleteTempBitmaps();

	return true;
}

LOGFONT	*TCGraphicBitMapVectorObject::GetLogFont(void)
{
	switch(m_property)
	{
		case E_SCHEMATIC_OBJECT:		return &GCSuperSpiceGlobalData.CFontData.CComponentLogFont;
		case E_SCHEMATIC_WIRE:			return &GCSuperSpiceGlobalData.CFontData.CComponentLogFont;
		case E_SCHEMATIC_LABEL:		//	return &GCSuperSpiceGlobalData.CFontData.CComponentLogFont;
		{
			if(m_type != 666) return &GCSuperSpiceGlobalData.CFontData.CComponentLogFont;

			return &GCSuperSpiceGlobalData.CFontData.CConnectionDotFont;
		}
		case E_SCHEMATIC_PIN:			return &GCSuperSpiceGlobalData.CFontData.CPinsLogFont;
		case E_SCHEMATIC_PIN_LABEL:		return &GCSuperSpiceGlobalData.CFontData.CPinsLogFont;
		
		case E_SCHEMATIC_TEXT_LABEL:
		{
			switch(m_version)//  
			{
				case E_WAVEFORM_TITLE: return &GCSuperSpiceGlobalData.CFontData.CWaveformTitleLogFont; 
				case E_WAVEFORM_DATE_AND_TIME: return &GCSuperSpiceGlobalData.CFontData.CWaveformTitleLogFont;
				case E_WAVEFORM_PLOT_NAME:return &GCSuperSpiceGlobalData.CFontData.CWaveformTitleLogFont;

				default: return &GCSuperSpiceGlobalData.CFontData.CUserLogFont;// todo
			}
		}

	
		case E_SCHEMATIC_BITMAP:		return &GCSuperSpiceGlobalData.CFontData.CComponentLogFont;
		case E_WAVEFORM_OBJECT:			return &GCSuperSpiceGlobalData.CFontData.CWaveformAxisLogFont;		
	}

	return &GCSuperSpiceGlobalData.CFontData.CComponentLogFont;
}

int TCGraphicBitMapVectorObject::IsThere(CPoint CLocation, bool fine)
{
	if(!fm_bitmap_vector_loaded) return false;

	if(m_property == E_WAVEFORM_OBJECT)
	{
//		return WaveformIsThere(CLocation);
	}

	if(m_mode == E_VECTOR_OBJECT)// handle invisable wire pin
	{
		return VectorIsThere(CLocation, fine);
	}

	if(!m_visable) return false;

	int x = CLocation.x;
	int y = CLocation.y;

	int lx = CMLocation.x;
	int ly = CMLocation.y;

	if(!CMRectGrabLocationRegion.PtInRect(CLocation)) return false;

	if(!fine) return true;

	int dx = x - lx;
	int dy = y - ly; 	

	HOMDest = SelectObject(HDCMDestCmp, CBitmapImageMask);
	COLORREF memory = GetPixel(HDCMDestCmp, dx, dy);

	if(!memory) 
	{
		SelectObject(HDCMDestCmp, HOMDest);


		return false;
	}

	SelectObject(HDCMDestCmp, HOMDest);
	 
	return true;

}

int TCGraphicBitMapVectorObject::IsThere(CRect CRegion, bool all_enclosed)
{
	CRect CTestRect;

	if(m_property == E_WAVEFORM_OBJECT)
	{
		return WaveformIsThere(CRegion);
	}

	if(all_enclosed) return RectInRect(CRegion, CMRectGrabLocationRegion);

	return CTestRect.IntersectRect(CRegion, CMRectGrabLocationRegion);
}

bool TCGraphicBitMapVectorObject::WaveformIsThere(CPoint CLocation)
{
	CLocation;
	return false;
}

bool TCGraphicBitMapVectorObject::WaveformIsThere(CRect CRegion)
{
	CRegion;// may not be needed
	return false;
}

void TCGraphicBitMapVectorObject::CreateGrabRegion(CPoint CLocation)
{
	bool flag = false;
	
	// Quick fix
	m_snap_to_distance = GetSnapToDistance();

	if(m_property == E_SCHEMATIC_WIRE)	
	{
		if (m_draw_angle == E_VERTICAL)	CreateVerticalalWireGrabRegion(CLocation);
		else if (m_draw_angle == E_HORIZONTAL) CreateHorizontalWireGrabRegion(CLocation);
			 else CreateAngledWireGrabRegion(CLocation);

		CMWireInfo.CExtent	= CMRectGrabLocationRegion;
		return;
	}

	switch(m_type)
	{
		case E_POINTING_UP_PIN_COMPONENT: flag = true;
			 CreatePointingUpPinGrabRegion(CLocation);break;
		case E_POINTING_DOWN_PIN_COMPONENT:flag = true;
			 CreatePointingDownPinGrabRegion(CLocation);break;
		case E_POINTING_LEFT_PIN_COMPONENT:flag = true;
			 CreatePointingLeftPinGrabRegion(CLocation);break;
		case E_POINTING_RIGHT_PIN_COMPONENT:flag = true;
			 CreatePointingRightPinGrabRegion(CLocation);break;
	}

	if(flag) return;

	CPoint  CLocationOffset = CMLocationOffset;
	MultyplyCPoint(&CLocationOffset, m_zoom);

	CPoint CUnity(1, 1);

	CPoint CGrabOffset = CMGrabOffset;

	MultyplyCPoint(&CGrabOffset, m_zoom);

	if(m_property == E_WAVEFORM_OBJECT)// top left corner
	{
		CLocation += CGrabOffset;

		int snap_to_distance = (int)(m_zoom * GetSnapToDistance());

		CMRectGrabLocationRegion.top	= -snap_to_distance;
		CMRectGrabLocationRegion.left	= 0;
		CMRectGrabLocationRegion.bottom	= snap_to_distance;
		CMRectGrabLocationRegion.right	= m_object_width + 1;

		CMRectGrabLocationRegion += CLocation;

		return;
	}

	CMRectGrabLocationRegion.top	= 0;
	CMRectGrabLocationRegion.left	= 0;
	CMRectGrabLocationRegion.bottom	= m_object_height;
	CMRectGrabLocationRegion.right	= m_object_width;

	if(m_property != E_SCHEMATIC_OBJECT ||
	   (m_rotation_state == E_FIRST_QUADRANT && !m_mirror_state))
	{
		CLocation += CGrabOffset;

		CMRectGrabLocationRegion += CLocation;

		CMRectGrabLocationRegion += CUnity;

		return;
	}

	//inbuilt symbols only, more advanced grab calculation
	CPoint CNewGrabOffset;

	if(m_rotation_state == E_SECOND_QUADRANT && !m_mirror_state)
	{//ok
		CNewGrabOffset.x = CLocationOffset.x - m_object_width +
			               CLocationOffset.y - CGrabOffset.y;
		CNewGrabOffset.y = CLocationOffset.y - CLocationOffset.x + CGrabOffset.x;

	}

	else if(m_rotation_state == E_SECOND_QUADRANT && m_mirror_state)
	{//ok
		CNewGrabOffset.x = CLocationOffset.x - 
			               CLocationOffset.y + CGrabOffset.y;
		CNewGrabOffset.y = CLocationOffset.y - CLocationOffset.x + CGrabOffset.x;

	}

	else if(m_rotation_state == E_FIRST_QUADRANT && m_mirror_state)
	{//ok
		CNewGrabOffset.x = 2*CLocationOffset.x - m_object_width +
			               CGrabOffset.x;
		CNewGrabOffset.y = CGrabOffset.y;
	}

	else if(m_rotation_state == E_THIRD_QUADRANT && !m_mirror_state)
	{//ok
		CNewGrabOffset.x = 2*CLocationOffset.x - m_object_width +
			               CGrabOffset.x;
		CNewGrabOffset.y = -CGrabOffset.y - m_object_height + 2*CLocationOffset.y;
	}

	else if(m_rotation_state == E_THIRD_QUADRANT && m_mirror_state)
	{//ok
		CNewGrabOffset.x = CGrabOffset.x;
		CNewGrabOffset.y = -CGrabOffset.y - m_object_height + 2*CLocationOffset.y;

	}
	else if(m_rotation_state == E_FORTH_QUADRANT && !m_mirror_state)
	{//ok
		CNewGrabOffset.x = CGrabOffset.y - CLocationOffset.y + CLocationOffset.x;
		CNewGrabOffset.y = CLocationOffset.x + CLocationOffset.y - m_object_height - CGrabOffset.x;
	}
	else if(m_rotation_state == E_FORTH_QUADRANT && m_mirror_state)
	{//ok
		CNewGrabOffset.x = -m_object_width -CGrabOffset.y + CLocationOffset.y + CLocationOffset.x;  // CGrabOffset.y - CLocationOffset.y + CLocationOffset.x;
		CNewGrabOffset.y = CLocationOffset.x + CLocationOffset.y - m_object_height - CGrabOffset.x;
	}
 
	CMRectGrabLocationRegion += CNewGrabOffset;
	CMRectGrabLocationRegion += CLocation;

	if(m_type) CMRectGrabLocationRegion += CUnity;// user symbols dont want this extra bit
}

void TCGraphicBitMapVectorObject::CreateHorizontalWireGrabRegion(CPoint CLocation)
{
	int snap_to_distance = (int)(m_zoom * GetSnapToDistance());

	if(snap_to_distance < 2) snap_to_distance = 2;

	CMRectGrabLocationRegion.top	= CLocation.y - snap_to_distance;
	CMRectGrabLocationRegion.left	= CLocation.x;
	CMRectGrabLocationRegion.bottom	= CLocation.y  + m_object_height + snap_to_distance;
	CMRectGrabLocationRegion.right	= CLocation.x + m_object_width;
}

void TCGraphicBitMapVectorObject::CreateVerticalalWireGrabRegion(CPoint CLocation)
{
	int snap_to_distance = (int)(m_zoom * GetSnapToDistance());

	if(snap_to_distance < 2) snap_to_distance = 2;

	CMRectGrabLocationRegion.top	= CLocation.y;
	CMRectGrabLocationRegion.left	= CLocation.x  - snap_to_distance;
	CMRectGrabLocationRegion.bottom	= CLocation.y + m_object_height;
	CMRectGrabLocationRegion.right	= CLocation.x + m_object_width + snap_to_distance;	
}

void TCGraphicBitMapVectorObject::CreateAngledWireGrabRegion(CPoint CLocation)
{
	CPoint CTopLeft, CBottomRight;
	
	switch(m_draw_angle)
	{
		case E_FIRST_QUADRANT:
		{
			CBottomRight.x	= m_object_width;
			CBottomRight.y	= 0;
			CTopLeft.x		= 0;
			CTopLeft.y		= -m_object_height;

			CRect CTempRect(CTopLeft, CBottomRight);
			CMRectGrabLocationRegion = CTempRect;
		}break;
		case E_SECOND_QUADRANT:
		{ 
			CBottomRight.x	= 0;
			CBottomRight.y	= 0;
			CTopLeft.x		= -m_object_width;
			CTopLeft.y		= -m_object_height;

			CRect CTempRect(CTopLeft, CBottomRight);
			CMRectGrabLocationRegion = CTempRect;
		}break;
		case E_THIRD_QUADRANT:
		{

			CTopLeft.x		= -m_object_width;
			CTopLeft.y		= 0;
			CBottomRight.x	= 0;
			CBottomRight.y	= m_object_height;

			CRect CTempRect(CTopLeft, CBottomRight);
			CMRectGrabLocationRegion = CTempRect;
		}break;
		case E_FORTH_QUADRANT:
		{
			CBottomRight.x	= m_object_width;
			CBottomRight.y	= m_object_height;
			CTopLeft.x		= 0;
			CTopLeft.y		= 0;

			CRect CTempRect(CTopLeft, CBottomRight);
			CMRectGrabLocationRegion = CTempRect;
		}break;
	}

	CMRectGrabLocationRegion += CLocation;

	if(!(CMLineEnd.x - CMLineStart.x)) return;// cant happen

	CMLineStart;
	
	CMLineEnd;

	m_line_gradient = (float)(CMLineEnd.y - CMLineStart.y)/(float)(CMLineEnd.x - CMLineStart.x);// to do
	
	if(m_line_gradient == 0.0) 
	{
		m_line_gradient = 1;

		return;
	}

	m_line_constant = CMLineEnd.y - m_line_gradient * CMLineEnd.x;
}

int TCGraphicBitMapVectorObject::IsWireThere(CPoint CLocation, bool fine)
{
CLocation;fine;
	return false;
}

int TCGraphicBitMapVectorObject::IsWireThere(CRect CRegion, bool all_enclosed)
{CRegion;all_enclosed;

	return false;
}
void TCGraphicBitMapVectorObject::OutlineWire(int outline_state)
{
outline_state;
}

void TCGraphicBitMapVectorObject::CreatePointingUpPinGrabRegion(CPoint CLocation)
{
	CPoint  CLocationOffset = CMLocationOffset;
	MultyplyCPoint(&CLocationOffset, m_zoom);

	int snap_to_distance = (int)(m_zoom * GetSnapToDistance());

	if(snap_to_distance < 2) snap_to_distance = 2;

	CLocation += CLocationOffset;

	CMRectGrabLocationRegion.top	= CLocation.y - m_object_height - snap_to_distance - 1;
	CMRectGrabLocationRegion.left	= CLocation.x  - snap_to_distance - 1;
	CMRectGrabLocationRegion.bottom	= CLocation.y  - m_object_height + snap_to_distance;
	CMRectGrabLocationRegion.right	= CLocation.x + m_object_width + snap_to_distance + 1;	
}
void TCGraphicBitMapVectorObject::CreatePointingDownPinGrabRegion(CPoint CLocation)
{
	CPoint  CLocationOffset = CMLocationOffset;
	MultyplyCPoint(&CLocationOffset, m_zoom);
	CLocation += CLocationOffset;

	int snap_to_distance = (int)(m_zoom * GetSnapToDistance());

	if(snap_to_distance < 2) snap_to_distance = 2;

	CMRectGrabLocationRegion.top	= CLocation.y + m_object_height - snap_to_distance - 1;
	CMRectGrabLocationRegion.left	= CLocation.x  - snap_to_distance - 1;
	CMRectGrabLocationRegion.bottom	= CLocation.y + m_object_height + snap_to_distance;
	CMRectGrabLocationRegion.right	= CLocation.x + m_object_width + snap_to_distance + 1;	
}
void TCGraphicBitMapVectorObject::CreatePointingRightPinGrabRegion(CPoint CLocation)
{
	CPoint  CLocationOffset = CMLocationOffset;
	MultyplyCPoint(&CLocationOffset, m_zoom);

	int snap_to_distance = (int)(m_zoom * GetSnapToDistance());

	if(snap_to_distance < 2) snap_to_distance = 2;

	CLocation += CLocationOffset;

	CMRectGrabLocationRegion.top	= CLocation.y - snap_to_distance - 1;
	CMRectGrabLocationRegion.left	= CLocation.x  - snap_to_distance + m_object_width - 1;
	CMRectGrabLocationRegion.bottom	= CLocation.y + m_object_height + snap_to_distance;
	CMRectGrabLocationRegion.right	= CLocation.x + m_object_width + snap_to_distance + 1;	
}
void TCGraphicBitMapVectorObject::CreatePointingLeftPinGrabRegion(CPoint CLocation)
{
	CPoint  CLocationOffset = CMLocationOffset;
	MultyplyCPoint(&CLocationOffset, m_zoom);
	
	int snap_to_distance = (int)(m_zoom * GetSnapToDistance());

	if(snap_to_distance < 2) snap_to_distance = 2;
	// A square around pin end

	CLocation += CLocationOffset;

	CMRectGrabLocationRegion.top	= CLocation.y - snap_to_distance - 1;
	CMRectGrabLocationRegion.left	= CLocation.x  - snap_to_distance - m_object_width - 1;
	CMRectGrabLocationRegion.bottom	= CLocation.y + m_object_height + snap_to_distance;
	CMRectGrabLocationRegion.right	= CLocation.x - m_object_width + snap_to_distance + 1;	
}

CRect TCGraphicBitMapVectorObject::GetGrabLocationRegion(void)
{
	return CMRectGrabLocationRegion;
}


bool TCGraphicBitMapVectorObject::Paste(CDC *PCDC, CPoint CLocation, float zoom,  bool is_visable)
{
	CMAbsoluteLocation.x = (int)(CLocation.x / zoom);
	CMAbsoluteLocation.y = (int)(CLocation.y / zoom);

	if(IsSnapToGridOn()) 
		CMAbsoluteLocation = SnapToGrid(CMAbsoluteLocation, GetGridSize());

	if(m_mode == E_VECTOR_OBJECT)
	{
		CMAbsoluteEndLocation.x = (int)(CMLineEnd.x / zoom); //For wires only
		CMAbsoluteEndLocation.y = (int)(CMLineEnd.y / zoom); //For wires only

		return VectorPaste(PCDC, CLocation, is_visable);
	}

	CMLocation = CLocation;

	if(!is_visable) return true;

	if(!fm_bitmap_vector_loaded) return false;	

   	HDC HDCDest = PCDC->m_hDC;

	int x = CLocation.x;
	int y = CLocation.y;

	CreateGrabRegion(CLocation);

	CreateTempBitmaps();

 // First get the background at the new destination

	HBITMAP htest = CBitmapBackground;
	bool flag = false;

	if(!htest) // this is to keep transparant text
	{
		flag = true;
		CreateBitmapBackgroundLabel();
	}
	HOMDest = SelectObject(HDCMDestCmp, CBitmapBackground);

	BitBlt(HDCMDestCmp, 0, 0, m_object_width,m_object_height, HDCDest, x, y, SRCCOPY);

	SelectObject(HDCMDestCmp, CBitmapTemp1);
	HOMSrc  = SelectObject(HDCMSrcCmp, HBActiveImage);

//	MaskBlt(HDCDest, x, y, m_object_width, m_object_height, HDCMSrcCmp, 0, 0, CBitmapImageMask, 0, 0, MAKEROP4(SRCAND, 0));

	BitBlt(HDCMDestCmp, 0, 0, m_object_width,m_object_height, HDCMSrcCmp, 0, 0, SRCCOPY);

	SelectObject(HDCMSrcCmp, CBitmapImageMask);
	BitBlt(HDCMDestCmp, 0, 0, m_object_width,m_object_height, HDCMSrcCmp, 0, 0, SRCAND);

	SelectObject(HDCMSrcCmp, CBitmapImageMask);
	SelectObject(HDCMDestCmp, CBitmapTemp2);
	BitBlt(HDCMDestCmp, 0, 0, m_object_width,m_object_height, HDCMSrcCmp, 0, 0, NOTSRCCOPY);

	SelectObject(HDCMSrcCmp, CBitmapBackground);
	BitBlt(HDCMDestCmp, 0, 0, m_object_width,m_object_height, HDCMSrcCmp, 0, 0, SRCAND);

	SelectObject(HDCMSrcCmp, CBitmapTemp1);
	SelectObject(HDCMDestCmp, CBitmapTemp2);

	BitBlt(HDCMDestCmp, 0, 0, m_object_width,m_object_height, HDCMSrcCmp, 0, 0, SRCINVERT);
	BitBlt(HDCDest, x , y, m_object_width,m_object_height, HDCMDestCmp, 0, 0, SRCCOPY);

	SelectObject(HDCMSrcCmp, HOMSrc);
	SelectObject(HDCMDestCmp, HOMDest);
	
	if(flag) CBitmapBackground.DeleteObject();

	DeleteTempBitmaps();

	return true;
}

bool TCGraphicBitMapVectorObject::RePaste(CDC *PCDC, CPoint CLocation)
{
	if(m_mode == E_VECTOR_OBJECT)
	{
		return VectorRePaste(PCDC, CLocation);
	}
		
	HDC HDCDest = PCDC->m_hDC;

	CreateTempBitmaps();

	int x = CLocation.x;
	int y = CLocation.y;
	bool flag = false;

 // First get the background at the new destination
	HBITMAP htest = CBitmapBackground;

	if(!htest) // this is to keep transparant text
	{
		flag = true;
		CreateBitmapBackgroundLabel();
	}
	HOMDest = SelectObject(HDCMDestCmp, CBitmapBackground);

	BitBlt(HDCMDestCmp, 0, 0, m_object_width,m_object_height, HDCDest, x, y, SRCCOPY);
//
	SelectObject(HDCMDestCmp, CBitmapTemp1);
	HOMSrc  = SelectObject(HDCMSrcCmp, HBActiveImage);

//	MaskBlt(HDCDest, x, y, m_object_width, m_object_height, HDCMSrcCmp, 0, 0, CBitmapImageMask, 0, 0, MAKEROP4(SRCAND, 0));

	BitBlt(HDCMDestCmp, 0, 0, m_object_width,m_object_height, HDCMSrcCmp, 0, 0, SRCCOPY);

	SelectObject(HDCMSrcCmp, CBitmapImageMask);
	BitBlt(HDCMDestCmp, 0, 0, m_object_width,m_object_height, HDCMSrcCmp, 0, 0, SRCAND);

	SelectObject(HDCMSrcCmp, CBitmapImageMask);
	SelectObject(HDCMDestCmp, CBitmapTemp2);
	BitBlt(HDCMDestCmp, 0, 0, m_object_width,m_object_height, HDCMSrcCmp, 0, 0, NOTSRCCOPY);

	SelectObject(HDCMSrcCmp, CBitmapBackground);
	BitBlt(HDCMDestCmp, 0, 0, m_object_width,m_object_height, HDCMSrcCmp, 0, 0, SRCAND);

	SelectObject(HDCMSrcCmp, CBitmapTemp1);
	SelectObject(HDCMDestCmp, CBitmapTemp2);

	BitBlt(HDCMDestCmp, 0, 0, m_object_width,m_object_height, HDCMSrcCmp, 0, 0, SRCINVERT);
	BitBlt(HDCDest, x , y, m_object_width,m_object_height, HDCMDestCmp, 0, 0, SRCCOPY);

	SelectObject(HDCMSrcCmp, HOMSrc);
	SelectObject(HDCMDestCmp, HOMDest);

	if(flag) CBitmapBackground.DeleteObject();

	DeleteTempBitmaps();

	return true;
}

bool TCGraphicBitMapVectorObject::Print(CDC *PCDC, CPoint CLocation)
{
	if(m_mode == E_VECTOR_OBJECT)
	{
		return VectorPrint(PCDC, CLocation);
	}
	
	// Bitmaps to do

//  Text out
	int x = CLocation.x;
	int y = CLocation.y;

	CFont CTextFont;

	LOGFONT sm_logfont = *GetLogFont();
	LOGFONT s_logfont;

	s_logfont = sm_logfont;

	s_logfont.lfHeight = (LONG)(s_logfont.lfHeight * m_zoom);
	s_logfont.lfWidth  = (LONG)(s_logfont.lfWidth * m_zoom);

	if(!CTextFont.CreateFontIndirect(&s_logfont))return false;

	CFont *COldFont	= PCDC->SelectObject(&CTextFont);

	if(!COldFont)
	{
		CTextFont.DeleteObject();

		return false;
	}

	COLORREF temp_active_line_color;
	
	if(m_type != 666)//devil number for conection dots!!!
	{
		temp_active_line_color = m_active_line_color;

		if(GCSuperSpiceGlobalData.CColorData.black_white_printing) temp_active_line_color = RGB(0,0,0);

		COLORREF prior_colour = PCDC->SetTextColor(temp_active_line_color);

		PCDC->TextOut(x, y, CMLabel);

		PCDC->SetTextColor(prior_colour);
	}
	else
	{
		CBrush BrushBlack(RGB(0, 0, 0));
		CBrush* pOldBrush = PCDC->SelectObject(&BrushBlack);

		int connection_dot = (int)(m_zoom * GCSuperSpiceGlobalData.CDrawData.connection_dot_size);

		CRect CConnectionDot(CLocation.x, CLocation.y, CLocation.x + connection_dot, CLocation.y + connection_dot);

		PCDC->Rectangle(CConnectionDot);

		PCDC->SelectObject(pOldBrush);
	}

	PCDC->SelectObject(COldFont);

	CTextFont.DeleteObject();

	return true;
}

bool TCGraphicBitMapVectorObject::BitmapPrint(CDC *PCDC, CPoint CLocation)
{CLocation;
	if(!PCDC) return false;// some printers can not take the setpixels
/*	
	CDC CMemDC;

	CMemDC.CreateCompatibleDC(PCDC);

	int w = CMRectGrabLocationRegion.Width();
	int h = CMRectGrabLocationRegion.Height();
//	int screen_planes = PCDC->GetDeviceCaps(PLANES);
//	int screen_bitspixels = PCDC->GetDeviceCaps(BITSPIXEL);

	CBitmap CBitMap;
//global_screen_planes, global_screen_bitspixels
	// create memory for dc
//	if(!CBitMap.CreateBitmap(w, h, screen_planes, screen_bitspixels,  NULL))return false;
	if(!CBitMap.CreateCompatibleBitmap(PCDC, w, h))return false;

	HGDIOBJ oldobject = CMemDC.SelectObject(CBitMap);

	if(!oldobject) 
	{	
		CMemDC.SelectObject(oldobject);

		CMemDC.DeleteDC();

		return false;
	}
 
//	ClearScreen(&CMemDC);
	int result = CMemDC.BitBlt(0, 0, w, h, NULL, 0, 0, WHITENESS);

	CPoint CZeroLocatioin(0, 0);

	result = VectorPrint(&CMemDC, CZeroLocatioin);

	SECDib CSECDib;
	CPalette *pOldPalette = NULL;

	CSECDib.CreateFromBitmap(PCDC, &CBitMap);

	if(CSECDib.m_pPalette)
	{
		pOldPalette = PCDC->SelectPalette(CSECDib.m_pPalette, TRUE);
	}

	CSECDib.StretchDIBits(PCDC, CLocation.x, CLocation.y, (int)CSECDib.m_dwWidth,
							(int)CSECDib.m_dwHeight, 0,0,
							(int)CSECDib.m_dwWidth,
							(int)CSECDib.m_dwHeight,
							CSECDib.m_lpSrcBits,
							CSECDib.m_lpBMI, DIB_RGB_COLORS,
							SRCCOPY);     
  
	if(CSECDib.m_pPalette) 
	{
		PCDC->SelectPalette(pOldPalette, TRUE);
	} 
//	if(!PrintBitmap(PCDC, CBitMap, CLocation.x, CLocation.y)) return false;

//	if(!PCDC->BitBlt(CLocation.x, CLocation.y, w, h, &CMemDC, 0, 0, SRCCOPY)) return false;

	CMemDC.SelectObject(oldobject);
*/
	return true;
}

bool TCGraphicBitMapVectorObject::VectorPrint(CDC *PCDC, CPoint CLocation)
{
	int count2 = CMDrawLineData.GetSize();

	if(!count2) return false;

	register int x;
	register int y;
	register int x0;
	register int y0;
	int count;
	int q;

	x0 = CLocation.x - CMLocation.x;
	y0 = CLocation.y - CMLocation.y;

	COLORREF temp_active_line_color = m_active_line_color;

	int signal_index = 0;
	m_run_counter = 0;

	for(int p = 0; p < count2; p++)
	{
		count = CMDrawLineData[p].CPoints.GetSize();

	 // for waveform only, each array member is different signal with different colour

		if(p >= m_waveform_index_start)// only occures for waveforms
			if(PCWaveformDataRuns)
				if(m_property == E_WAVEFORM_OBJECT)// 
				{
					if(!(signal_index < GetMaxSignalCount(m_run_counter)))
					{
						signal_index = 0;
						m_run_counter++;
					}

					temp_active_line_color = GetWaveformActiveColour(m_run_counter, signal_index);
					
					signal_index++;
				}
	//

		if(GCSuperSpiceGlobalData.CColorData.black_white_printing) temp_active_line_color = RGB(0,0,0);

		for(q = 0; q < count; q++) 
		{
			x = CMDrawLineData[p].CPoints[q].CLocation.x;
			y = CMDrawLineData[p].CPoints[q].CLocation.y;

			x += x0;
			y += y0;

			if(!PCDC->SetPixel(x, y, temp_active_line_color)) return false;
		}
	}

	return true;
}
int TCGraphicBitMapVectorObject::GetMaxSignalCount(int run_index)
{
	if(!PCWaveformDataRuns) return 0;

	int run_count = PCWaveformDataRuns->CRuns.GetSize();

	if(!(run_index < run_count))return 0;

	TCOutputWaveformData *PCOutputWaveformData =  PCWaveformDataRuns->CRuns[run_index];

	if(!(m_waveform_index < PCOutputWaveformData->CRecords.GetSize())) return 0; 

	TCOutputWaveformDataHeader *PCHeader;

	PCHeader = &PCOutputWaveformData->CRecords[m_waveform_index].CHeader;

	if(PCParentHeader) if(run_count == 1) PCHeader = PCParentHeader;

	CArray <TCDisplayedSignals, TCDisplayedSignals&>  &CSignals = PCHeader->CDisplayedSignalsList;

	return CSignals.GetSize();
}

COLORREF TCGraphicBitMapVectorObject::GetWaveformActiveColour(int run_index, int signal_index)
{
	COLORREF colour = RGB(255,255,255);

	if(!PCWaveformDataRuns) return colour;

	int run_count = PCWaveformDataRuns->CRuns.GetSize();

	if(!(run_index < run_count))return colour;

	TCOutputWaveformData *PCOutputWaveformData =  PCWaveformDataRuns->CRuns[run_index];

	if(IsBadReadPtr(PCOutputWaveformData, sizeof(PCOutputWaveformData)))
	{
		return 0;
	}

	if(!(m_waveform_index < PCOutputWaveformData->CRecords.GetSize())) return colour; 

	TCOutputWaveformDataHeader *PCHeader;

	PCHeader = &PCOutputWaveformData->CRecords[m_waveform_index].CHeader;

	if(PCParentHeader) if(run_count == 1) PCHeader = PCParentHeader;

	CArray <TCDisplayedSignals, TCDisplayedSignals&>  &CSignals = PCHeader->CDisplayedSignalsList;

	if(!(signal_index < CSignals.GetSize())) return colour;

	TCDisplayedSignals &CDisplayedSignal = CSignals[signal_index];

	TCSignal  *PCSignal = CDisplayedSignal.PCSignal1;// needed for signal functions

	if(IsBadReadPtr(PCSignal, sizeof(PCOutputWaveformData)))
	{
		return 0;
	}

	if(!PCSignal) return colour;

	if(CDisplayedSignal.type == TE_SIGNAL_DISPLAY_MAGNITUDE|| CDisplayedSignal.type == TE_SIGNAL_DISPLAY_DB_MAGNITUDE)
	{
		if(m_selected)
			colour = PCSignal->selected_colour;
		else if(m_highlighted) colour = PCSignal->highlighted_colour;
			else colour = PCSignal->normal_colour;
	}
	else if (CDisplayedSignal.type == TE_SIGNAL_DISPLAY_PHASE_DEG|| CDisplayedSignal.type == TE_SIGNAL_DISPLAY_PHASE_RADIANS)
	{
		if(m_selected)
			colour = PCSignal->selected_phase_colour;
		else if(m_highlighted) colour = PCSignal->highlighted_phase_colour;
			else colour = PCSignal->normal_phase_colour;
	}

	return colour;
}

bool TCGraphicBitMapVectorObject::VectorRePaste(CDC *PCDC, CPoint CLocation, bool waveform_only)
{
	int count2 = CMDrawLineData.GetSize();

	if(!count2) return false;

	register TCDrawLineData	*PCPoints;
	register TCLineData	*PCLineData = CMDrawLineData.GetData();
	register int x;
	register int y;
	register int x0;
	register int y0;
	int count, p, q;

	x0 = CLocation.x - CMLocation.x;
	y0 = CLocation.y - CMLocation.y;

	HDC h_dc = PCDC->m_hDC;

	COLORREF temp_active_line_color = m_active_line_color;

	int signal_index = 0;
	m_run_counter = 0;
	int start = 0;

	int p_start = 0;
	
	if(waveform_only) 
	{
		PCLineData += m_waveform_index_start;
		p_start = m_waveform_index_start;
	}

	for(p = p_start; p < count2; p++)
	{
	 // for waveform only, each array member is differnt signal with different colour

		if(p >= m_waveform_index_start)// only occures for waveforms
			if(PCWaveformDataRuns)
				if(m_property == E_WAVEFORM_OBJECT)// 
				{
					if(!(signal_index < GetMaxSignalCount(m_run_counter)))
					{
						signal_index = 0;
						m_run_counter++;
					}

					temp_active_line_color = GetWaveformActiveColour(m_run_counter, signal_index);

					if(0)// tsting new code
					{
						if(!(signal_index < CMWaveFormDrawData.GetSize())) return false;

						int size = CMWaveFormDrawData[signal_index].CLines.GetSize();

						CPen CCurrentPen(PS_SOLID, 1, temp_active_line_color);

						CObject *PColdObj = PCDC->SelectObject(&CCurrentPen);

						for(int r = 0; r < size; r++)
						{
							TCLineData &CLineData = CMWaveFormDrawData[signal_index].CLines[r];

							PCDC->MoveTo(CLineData.CStartLocation + CMLocation);
							PCDC->LineTo(CLineData.CEndLocation + CMLocation);
						}

						PCDC->SelectObject(PColdObj);

						signal_index++;

						continue;
					}
					else signal_index++;
				}
	//
		count = PCLineData->CPoints.GetSize();

		PCPoints = PCLineData->CPoints.GetData();

		if(waveform_only) // only plot a range of points when updating real time display 
		{
			start = PCLineData->start_point;

			PCPoints += start;
		}

		if(PCLineData->stop_point > count) PCLineData->stop_point = count;//auto protection
		if(PCLineData->stop_point) count = PCLineData->stop_point;

		for(q = start; q < count; q++) 
		{
			x = PCPoints->CLocation.x;
			y = PCPoints->CLocation.y;

			x += x0;
			y += y0;

			if(m_property != E_WAVEFORM_OBJECT)// waveform drawing dont need it
				PCPoints->back_ground = GetPixel(h_dc, x, y);
	
			SetPixel(h_dc, x, y, temp_active_line_color);

			PCPoints++;
		}
		PCLineData++;
	}
	
	return true;
}

bool TCGraphicBitMapVectorObject::MoveTo(CDC *PCDC, CPoint CLocation, float zoom,  bool is_visable)
{
	if(m_mode == E_VECTOR_OBJECT)
	{
		return VectorMoveTo(PCDC, CLocation, zoom, is_visable);
	}

	HDC HDCDest = PCDC->m_hDC;

	int x = CMLocation.x;
	int y = CMLocation.y;

	if(!is_visable) 
	{
		CMLocation = CLocation;
		return true;
	}

	if(!fm_bitmap_vector_loaded) return false;	

	// First Clear old
	CreateTempBitmaps();

	HOMDest	= SelectObject(HDCMDestCmp, CBitmapTemp1);
	HOMSrc	= SelectObject(HDCMSrcCmp, CBitmapBackground);

	BitBlt(HDCMDestCmp, 0, 0, m_object_width, m_object_height, HDCMSrcCmp, 0, 0, SRCCOPY);

	SelectObject(HDCMSrcCmp, HBActiveImage);
	BitBlt(HDCMDestCmp, 0, 0, m_object_width, m_object_height, HDCMSrcCmp, 0, 0, SRCINVERT);

	SelectObject(HDCMSrcCmp, CBitmapImageMask);
	BitBlt(HDCMDestCmp, 0, 0, m_object_width, m_object_height, HDCMSrcCmp, 0, 0, SRCAND);

	BitBlt(HDCDest, x, y, m_object_width, m_object_height, HDCMDestCmp, 0, 0, SRCINVERT);

	x = CLocation.x;
	y = CLocation.y;
	
	CMLocation = CLocation;
	
 // First get the background at the new destination

	HBITMAP htest = CBitmapBackground;
	if(!htest) CreateBitmapBackgroundLabel();
	HOMDest = SelectObject(HDCMDestCmp, CBitmapBackground);
	SelectObject(HDCMDestCmp, CBitmapBackground);
	BitBlt(HDCMDestCmp, 0, 0, m_object_width, m_object_height, HDCDest, x, y, SRCCOPY);

	//	Then paste at new position

	SelectObject(HDCMDestCmp, CBitmapTemp1);
	SelectObject(HDCMSrcCmp, HBActiveImage);

	BitBlt(HDCMDestCmp, 0, 0, m_object_width, m_object_height, HDCMSrcCmp, 0, 0, SRCCOPY);

	SelectObject(HDCMSrcCmp, CBitmapImageMask);
	BitBlt(HDCMDestCmp, 0, 0, m_object_width, m_object_height, HDCMSrcCmp, 0, 0, SRCAND);

	SelectObject(HDCMSrcCmp, CBitmapImageMask);
	SelectObject(HDCMDestCmp, CBitmapTemp2);
	BitBlt(HDCMDestCmp, 0, 0, m_object_width, m_object_height, HDCMSrcCmp, 0, 0, NOTSRCCOPY);

	SelectObject(HDCMSrcCmp, CBitmapBackground);
	BitBlt(HDCMDestCmp, 0, 0, m_object_width, m_object_height, HDCMSrcCmp, 0, 0, SRCAND);

	SelectObject(HDCMSrcCmp, CBitmapTemp1);
	SelectObject(HDCMDestCmp, CBitmapTemp2);
	
	BitBlt(HDCMDestCmp, 0, 0, m_object_width, m_object_height, HDCMSrcCmp, 0, 0, SRCINVERT);
	BitBlt(HDCDest, x , y, m_object_width, m_object_height, HDCMDestCmp, 0, 0, SRCCOPY);

	SelectObject(HDCMSrcCmp, HOMSrc);       
	SelectObject(HDCMDestCmp, HOMDest);
	
	DeleteTempBitmaps();

	return true;

}
 
bool TCGraphicBitMapVectorObject::Clear(CDC *PCDC)
{
	if(!fm_bitmap_vector_loaded) return false;

	if(m_mode == E_VECTOR_OBJECT)
	{
		return VectorClear(PCDC);
	}

	HBITMAP htest = CBitmapBackground;

//	if(!htest) return false;

	HDC HDCDest = PCDC->m_hDC;

	int x	= CMLocation.x;
	int y	= CMLocation.y;

	CreateTempBitmaps();

	if(!htest)
	{
		CreateBitmapBackgroundLabel();
	}

	HOMDest	= SelectObject(HDCMDestCmp, CBitmapTemp1);
	HOMSrc	= SelectObject(HDCMSrcCmp, CBitmapBackground);

	BitBlt(HDCMDestCmp, 0, 0, m_object_width, m_object_height, HDCMSrcCmp, 0, 0, SRCCOPY);

	SelectObject(HDCMSrcCmp, HOMSrc);

	HOMSrc = SelectObject(HDCMSrcCmp, HBActiveImage);
	BitBlt(HDCMDestCmp, 0, 0, m_object_width, m_object_height, HDCMSrcCmp, 0, 0, SRCINVERT);

	SelectObject(HDCMSrcCmp, CBitmapImageMask);
	BitBlt(HDCMDestCmp, 0, 0, m_object_width, m_object_height, HDCMSrcCmp, 0, 0, SRCAND);

	BitBlt(HDCDest, x, y, m_object_width, m_object_height, HDCMDestCmp, 0, 0, SRCINVERT);

	SelectObject(HDCMSrcCmp, HOMSrc);       
	SelectObject(HDCMDestCmp, HOMDest);

	if(!htest)
	{
		CBitmapBackground.DeleteObject();
	}

	DeleteTempBitmaps();

	return true;
}

void TCGraphicBitMapVectorObject::SetSelect(void)
{
	m_highlighted		= false;
	m_selected			= true;
	m_highlighted		= false;
	m_active_line_color = m_line_selected_color;

	HBActiveImage  = CBitmapImageSelected;
}

void TCGraphicBitMapVectorObject::ResetSelect(void)
{
	m_selected			= false;
	m_highlighted		= false;
	m_highlighted		= false;
	m_active_line_color = m_line_color;

	HBActiveImage  = CBitmapImage;
}

void TCGraphicBitMapVectorObject::SetHighlight(bool highlighted)
{
	m_highlighted	= false;
	m_selected		= false;

	if(highlighted) 
	{
		m_highlighted		= true;
		m_selected			= false;
		m_active_line_color = m_line_highlighted_color; 
	}
	else m_active_line_color = m_line_color;

	HBActiveImage = CBitmapImage;
}

void TCGraphicBitMapVectorObject::VectorDelete(void)
{

}

void TCGraphicBitMapVectorObject::VectorSerialize(CArchive& archive)
{
	if (archive.IsStoring())
	{
		// TODO: add storing code here
	}
	else
	{
		m_active_line_color = m_line_color;

		if(m_selected) SetSelect();
		else if(m_highlighted)SetHighlight(true);
	}
}


int TCGraphicBitMapVectorObject::VectorIsThere(CPoint CLocation, bool fine)
{
	int x;
	int y;
	int lx;
	int ly;

	x = CLocation.x;
	y = CLocation.y;

	lx = CMLocation.x;
	ly = CMLocation.y;

	int xtest;
	int ytest;
  
	if(m_type != E_WIRE_COMPONENT)
	{
		if(!CMRectGrabLocationRegion.PtInRect(CLocation)) return false;
	}
	else
	{
		if(m_draw_angle == E_VERTICAL || m_draw_angle == E_HORIZONTAL)
		{
			if(!CMRectGrabLocationRegion.PtInRect(CLocation)) return false;
		}
		else 
		{
			if(!CMRectGrabLocationRegion.PtInRect(CLocation)) return false;
	
			int snap_to_distance = (int)(m_zoom * GetSnapToDistance());

			ytest = (int)(m_line_gradient * x + m_line_constant);
			xtest = (int)((y - m_line_constant)/m_line_gradient);

			// check y, if y fails check x
			if((ytest - snap_to_distance) > y || (ytest + snap_to_distance) < y) 
			{
				if((xtest + snap_to_distance) < x || (xtest - snap_to_distance) > x) return false;
			}
		}
	}

	if(!fine) return true;

	return true;// ignore the rest for now
/*
	int count = CMDrawLineData.GetSize();

	int count2;

	for(int p = 0; p < count; p++)
	{
		count2 = CMDrawLineData[p].CPoints.GetSize();

		for(int q = 0; q < count2; q++)
		{
			if(CMDrawLineData[p].CPoints[q].CLocation.x == x &&
			   CMDrawLineData[p].CPoints[q].CLocation.y == y)
					return true;
		}
	}
	return false;*/
}

void TCGraphicBitMapVectorObject::RealignLocation(CPoint CLocation)
{
	CPoint  CLocationOffset = CMLocationOffset;
	MultyplyCPoint(&CLocationOffset, m_zoom);

	CMLocation = CLocation;

	int count2 = CMDrawLineData.GetSize();

	if(!count2) return;

	if(!CMDrawLineData[0].CPoints.GetSize()) return;

	register TCDrawLineData	*PCPoints;
	register TCLineData	*PCLineData = CMDrawLineData.GetData();
	register int q;
	register int p;
	register int count;

	CPoint CDeltaLocation;
	CPoint CLinelength;
	CDeltaLocation = CLocation - PCLineData->CPoints[0].CLocation;
	CDeltaLocation += CLocationOffset;

	CreateGrabRegion(CLocation); 

	CMLineStart = CLocation;
	
	CMLineEnd += CDeltaLocation;

	CLocation += CLocationOffset;

	PCLineData->CPoints[0].CLocation = CLocation;

	PCLineData++;
	for(p = 1; p < count2; p++) // Update all new point positions 
	{
		if(!PCLineData->CPoints.GetSize()) break;

		PCLineData->CPoints[0].CLocation += CDeltaLocation;

		PCLineData++;
	}

	PCLineData = CMDrawLineData.GetData();

	for(p = 0; p < count2; p++)
	{
		count = PCLineData->CPoints.GetSize();

		PCPoints = PCLineData->CPoints.GetData();
		PCPoints++;

		for(q = 1; q < count; q++) // Update all new point positions 
		{
			PCPoints->CLocation += CDeltaLocation;
			
			PCPoints++;
		}
		PCLineData++;
	}
}
bool TCGraphicBitMapVectorObject::VectorPaste(CDC *PCDC, CPoint CLocation, bool is_visable)
{
	int count2 = CMDrawLineData.GetSize();

	if(!count2) return false;

	RealignLocation(CLocation);

	if(!is_visable) return true;

	register TCDrawLineData	*PCPoints;
	register TCLineData	*PCLineData = CMDrawLineData.GetData();
	register int x;
	register int y;
	register int count;
	register int q;
	register int p;

	HDC h_dc = PCDC->m_hDC;

	register int fastest_drawing_mode = GCSuperSpiceGlobalData.CDrawData.fastest_drawing_mode;

	if(m_property == E_SCHEMATIC_WIRE) fastest_drawing_mode = false;

	int prior = false;
		
	if(fastest_drawing_mode) prior = PCDC->SetROP2(R2_XORPEN);

	int signal_index = 0;
	m_run_counter = 0;

	COLORREF temp_active_line_color = m_active_line_color;
	int start = 0;

	for(p = 0; p < count2; p++)
	{
		// for waveform only, each array member is differnt signal with different colour
		if(p >= m_waveform_index_start)// only occures for waveforms
		{
			if(PCWaveformDataRuns)
				if(m_property == E_WAVEFORM_OBJECT)// 
				{
					if(!(signal_index < GetMaxSignalCount(m_run_counter)))
					{
						signal_index = 0;
						m_run_counter++;
					}

					temp_active_line_color = GetWaveformActiveColour(m_run_counter, signal_index);

					if(0)// testing new code
					{
						if(!(signal_index < CMWaveFormDrawData.GetSize())) {ASSERT(0); return false;}

						int size = CMWaveFormDrawData[signal_index].CLines.GetSize();

						CPen CCurrentPen(PS_SOLID, 1, temp_active_line_color);

						CObject *PColdObj = PCDC->SelectObject(&CCurrentPen);

						for(int r = 0; r < size; r++)
						{
							TCLineData &CLineData = CMWaveFormDrawData[signal_index].CLines[r];

							PCDC->MoveTo(CLineData.CStartLocation + CMLocation);
							PCDC->LineTo(CLineData.CEndLocation + CMLocation);
						}

						PCDC->SelectObject(PColdObj);

						signal_index++;

						continue;
					}
					else signal_index++;					
				}
		}

		count = PCLineData->CPoints.GetSize();

		PCPoints = PCLineData->CPoints.GetData();

		if(PCLineData->stop_point > count) PCLineData->stop_point = count;//auto protection
		if(PCLineData->stop_point)  count = PCLineData->stop_point;

		for(q = start; q < count; q++) 
		{
			x = PCPoints->CLocation.x;
			y = PCPoints->CLocation.y;

			if(!fastest_drawing_mode) if(m_property != E_WAVEFORM_OBJECT) PCPoints->back_ground = GetPixel(h_dc, x, y);
	
			SetPixel(h_dc, x, y, temp_active_line_color);

			PCPoints++;
		}

		PCLineData++;
	}

	if(fastest_drawing_mode) PCDC->SetROP2(prior);

	return true;
}

bool TCGraphicBitMapVectorObject::VectorMoveTo(CDC *PCDC, CPoint CLocation, float zoom,  bool is_visable)
{
	Clear(PCDC);

	Paste(PCDC, CLocation, zoom, is_visable);

	return true;
}

bool TCGraphicBitMapVectorObject::VectorClear(CDC *PCDC)
{
	register TCDrawLineData	*PCPoints;
	register TCLineData	*PCLineData = CMDrawLineData.GetData();
	register int x;
	register int y;
	register int count;
	register int q;
	register int p;
	register int count2;

	register int fastest_drawing_mode = GCSuperSpiceGlobalData.CDrawData.fastest_drawing_mode;
	
	if(m_property == E_SCHEMATIC_WIRE) fastest_drawing_mode = false;

	HDC h_dc = PCDC->m_hDC;

	int prior = PCDC->SetROP2(R2_XORPEN);

	count2 = CMDrawLineData.GetSize();

	int signal_index = 0;
	m_run_counter = 0;
	
	COLORREF temp_active_line_color = m_active_line_color;

	for(p = 0; p < count2; p++)
	{

	 // for waveform only, each array member is differnt signal with different colour

		if(p >= m_waveform_index_start)// only occures for waveforms
			if(PCWaveformDataRuns)
				if(m_property == E_WAVEFORM_OBJECT)// 
				{
					if(!(signal_index < GetMaxSignalCount(m_run_counter)))
					{
						signal_index = 0;
						m_run_counter++;
					}

					temp_active_line_color = GetWaveformActiveColour(m_run_counter, signal_index);
				
					signal_index++;
				}
		//

		count = PCLineData->CPoints.GetSize();

		PCPoints = PCLineData->CPoints.GetData();

		if(PCLineData->stop_point) if(PCLineData->stop_point <= count) count = PCLineData->stop_point;

		for(q = 0; q < count; q++) 
		{
			x = PCPoints->CLocation.x;
			y = PCPoints->CLocation.y;

			if(!fastest_drawing_mode) if(m_property != E_WAVEFORM_OBJECT) SetPixel(h_dc, x, y, PCPoints->back_ground);
			
			SetPixel(h_dc, x, y, temp_active_line_color);

			PCPoints++;
		}
		PCLineData++;
	}

	PCDC->SetROP2(prior);

	return true;
}

bool TCGraphicBitMapVectorObject::VectorGetBackground(CDC *PCDC)
{PCDC;
	return true;
}


bool TCGraphicBitMapVectorObject::StartDrawingLine(CDC *PCDC, CPoint CMousePosition, COLORREF line_color,
				                COLORREF line_selected_color,
								COLORREF line_highlighted_color,
								unsigned short line_width, int snap_to_distance)
{
	PCDC;

	CMLocation					= CMousePosition;

	m_line_color				= line_color;
	m_line_selected_color		= line_selected_color;
	m_line_highlighted_color	= line_highlighted_color;
	m_line_width				= line_width;
	m_snap_to_distance			= snap_to_distance;

	if(!m_line_width) return false;

	CPoint CInc(1, 1); // Will be adjusted later

	CMDrawLineData.SetSize(0, m_line_width);
	CMDrawLineData.SetSize(m_line_width, m_line_width);

	CMLineStart	= CMousePosition;
	CMLocation	= CMousePosition;
	CMLineEnd	= CMousePosition;

	for(int p = 0; p < m_line_width; p++)
	{
		CMDrawLineData[p].CStartLocation = CMousePosition;

		CMousePosition = (CPoint) (CMousePosition + CInc);
	}

	m_mode = E_VECTOR_OBJECT;

	SetSelect(); 

	return true;
}
bool TCGraphicBitMapVectorObject::ContinueDrawingLine(CDC *PCDC, CPoint CMousePosition)
{
	VectorClear(PCDC);

	int count = CMDrawLineData.GetSize();

	if(!count) return false;

	CMLineEnd = CMousePosition;

	CPoint CInc(1, 1);

	int p;

	for(p = 0; p < count; p++)
	{
		CMDrawLineData[p].CEndLocation = CMousePosition;

		CMousePosition = (CPoint) (CMousePosition + CInc);
	}

	int x,y;
	int r;

	for(p = 0; p < count; p++) CMDrawLineData[p].FormatLinePoints();


	for(p = 0; p < count; p++)
	{
		r = CMDrawLineData[p].CPoints.GetSize();

		for(int q = 0; q < r; q++) // Draw the new line
		{
			x = CMDrawLineData[p].CPoints[q].CLocation.x;
			y = CMDrawLineData[p].CPoints[q].CLocation.y;

			CMDrawLineData[p].CPoints[q].back_ground = PCDC->GetPixel(x, y);
		
			PCDC->SetPixel(x, y, m_active_line_color);
		}
	}
	return true;
}
bool TCGraphicBitMapVectorObject::StopDrawingLine(CDC *PCDC, CPoint CMousePosition, int is_draw_orthoganal_on)
{
	PCDC;
	CPoint CLocation;

	if(is_draw_orthoganal_on)
	{
		CPoint CLine = (CPoint)(CMousePosition - CMLocation);
		int x = abs(CLine.x);
		int y = abs(CLine.y);

		if(y > x) CMousePosition.x = CMLocation.x;
		else	CMousePosition.y = CMLocation.y;
	}

	CLocation = CMLocation;

	int count2 = CMDrawLineData.GetSize();
	if(!count2) return false;
	count2--;

	int count = CMDrawLineData[0].CPoints.GetSize();
	if(!count) return false;

	count--;

	if(PCDC) VectorClear(PCDC);
	
	Create(CMLocation, CMousePosition, m_line_width, m_line_color, m_line_selected_color, m_line_highlighted_color
		   , m_snap_to_distance);


	if(PCDC) Paste(PCDC, CMLocation, m_zoom, true);
	
	return true;
}

bool TCGraphicBitMapVectorObject::Create(CPoint CStartLine, CPoint CEndLine, unsigned short line_width,
										 COLORREF line_color, COLORREF selected_color, COLORREF highlighted_color,
										 int snap_to_distance)
{
	m_mode = E_VECTOR_OBJECT;

	CMLocation					= CStartLine;
	CMLineStart					= CMLocation;
	CMLineEnd					= CEndLine;
	m_line_width				= line_width;
	m_line_color				= line_color;		
	m_line_highlighted_color	= highlighted_color;
	m_line_selected_color		= selected_color;
	m_snap_to_distance			= snap_to_distance;
	m_draw_angle				= -1;

	int x0, x1, y0, y1;

	x0 = CMLocation.x;
	y0 = CMLocation.y;
	x1 = CMLineEnd.x;
	y1 = CMLineEnd.y;

	CPoint CTopLeft; 
	CPoint CBottomLeft; 
	CPoint CBottomRight; 
	CPoint CTopRight;

	CMDrawLineData.SetSize(0, 4);

	CPoint CInc(0, 0);

	m_object_height = (unsigned short) abs(CEndLine.y - CStartLine.y);
	m_object_width  = (unsigned short)abs(CEndLine.x - CStartLine.x);

	m_draw_angle = E_FIRST_QUADRANT;

	CArray <CPoint, CPoint> CPointArray;

	if(!(CEndLine.y - CStartLine.y)) // horizontal line
	{
		if(CEndLine.x - CStartLine.x < 0) // swop r->l to l->r
		{
			CMLineStart.x	= CMLocation.x - m_object_width;
			CMLineEnd		= CMLocation;
			CEndLine		= CMLineEnd;
			CStartLine		= CMLineStart;
			CMLocation.x	= CMLineStart.x;
		}
		m_object_height = line_width; 


		CreateHorizontalWireGrabRegion(CMLocation);

		m_draw_angle = E_HORIZONTAL;
		m_rotation_state = 1; // Temp cheating
		CInc.y = 1;	
	}
	else if(!(CEndLine.x - CStartLine.x)) // vertical line
		{
			if(CEndLine.y - CStartLine.y < 0)
			{
				CMLineStart.y	= CMLocation.y - m_object_height;
				CMLineEnd		= CMLocation;
				CEndLine		= CMLineEnd;
				CStartLine		= CMLineStart;
				CMLocation.y	= CMLocation.y - m_object_height;
			}
			m_object_width = line_width;
//			m_object_height--;

			CreateVerticalalWireGrabRegion(CMLocation);

			m_draw_angle = E_VERTICAL;
			m_rotation_state = 2;// Temp cheating
			CInc.x = 1;
		}

		else if(y0 - y1 >= 0 && x1 - x0 >= 0) //1st quadrant
			{
	
				m_draw_angle = E_FIRST_QUADRANT;
		}
		else	if(y0 - y1 >= 0 && x0 - x1 >= 0) //2nd quadrant 
			{
				m_draw_angle = E_SECOND_QUADRANT;
			}
			else	if (y1 - y0 >= 0 && x0 - x1 >= 0) // 3rd quadrant
					{
						m_draw_angle = E_THIRD_QUADRANT;
					}
					else // 4th quadrant
					{
						m_draw_angle = E_FORTH_QUADRANT;
					} 

	for(int p = 0; p < m_line_width; p++)
	{
		AddLine(CStartLine, CEndLine, (unsigned short)p);

		CStartLine	= (CPoint) (CStartLine + CInc);
		CEndLine	= (CPoint) (CEndLine + CInc);
	}

	CMCenterPoint.x = m_object_width/2;
	CMCenterPoint.y = m_object_height/2;

	fm_bitmap_vector_loaded = true;

	return true;
}

bool TCGraphicBitMapVectorObject::AddLine(CPoint CLineStart, CPoint CLineEnd, unsigned short p)
{
	TCLineData CLineData;

	CLineData.CStartLocation = CLineStart;
	CLineData.CEndLocation	 = CLineEnd;

	CMDrawLineData.SetAtGrow(p, CLineData);

	CMDrawLineData[p].FormatLinePoints();

	return true;
}

bool TCGraphicBitMapVectorObject::SetLine(int index, CPoint CLineStart, CPoint CLineEnd)
{
	TCLineData CLineData;

	CLineData.CStartLocation = CLineStart;
	CLineData.CEndLocation	 = CLineEnd;

	CMDrawLineData.SetAt(index, CLineData);

	CMDrawLineData[index].FormatLinePoints();

	return true;
}

void TCGraphicBitMapVectorObject::CreateWirePins(CDC *PCDC)
{
PCDC;
}

TCWireInfo &TCGraphicBitMapVectorObject::GetWireInfo(void)
{
	CMWireInfo.type		= m_draw_angle;
	CMWireInfo.CExtent	= CMRectGrabLocationRegion; //done in create grab
	CMWireInfo.CStart	= CMLineStart;
	CMWireInfo.CEnd		= CMLineEnd;

	int snap_to_distance = (int)(m_zoom * GetSnapToDistance());

	snap_to_distance /= 2;

	// extend, e.g. horizontal wire horizontal by grab distance
	// and reduce vertical distance?
	
	switch(m_draw_angle)
	{
		case E_HORIZONTAL: CMWireInfo.CExtent.left -= snap_to_distance;
						  CMWireInfo.CExtent.right += snap_to_distance;
						  CMWireInfo.CExtent.top += snap_to_distance;
						  CMWireInfo.CExtent.bottom -= snap_to_distance;

						  break;
		case E_VERTICAL:  CMWireInfo.CExtent.top -= snap_to_distance;
						  CMWireInfo.CExtent.bottom += snap_to_distance;
						  CMWireInfo.CExtent.left += snap_to_distance;
						  CMWireInfo.CExtent.right -= snap_to_distance;

						  break;
		default:		break;
	}

	return CMWireInfo;
}
//////////////////////////////////////////////////////


////////////////////////////////////////////


