#ifndef _TCGRAPHIC_BITMAP_VECTOR_OBJECT_H
#define _TCGRAPHIC_BITMAP_VECTOR_OBJECT_H


#include "TDVersion.h"
#include "TCWireInfo.h"
#include "TCTextBitmap.h"
#include "TCGraphicObject.h"


class TCWaveformDataRuns;
class TCOutputWaveformDataHeader;

class TCWaveFormDrawData : public CObject
{
	public:

			TCWaveFormDrawData(void);
			TCWaveFormDrawData(TCWaveFormDrawData &CWaveFormDrawData);
			~TCWaveFormDrawData(void);

			void operator = (TCWaveFormDrawData &CWaveFormDrawData);
			void operator = (CArray <TCLineData,  TCLineData &> &CLineData);
	
			void Serialize(CArchive& CArchiveFile);

			DECLARE_SERIAL(TCWaveFormDrawData)

			CArray <TCLineData,  TCLineData &> CLines;
};

class TCGraphicBitMapVectorObject : public TCGraphicObject
{
public:	

				bool		fm_bitmap_vector_loaded;

				int			m_draw_angle;
				TCWireInfo	CMWireInfo;

				TCTextBitmap	CBitmapImage;
				TCTextBitmap	CBitmapImageMask;
				TCTextBitmap	CBitmapBackground;
				TCTextBitmap	CBitmapImageSelected;
				TCTextBitmap	CBitmapImageHighlighted;

				TCWaveformDataRuns *PCWaveformDataRuns;
				int					m_waveform_index_start;
				int					m_run_counter;
				int					m_waveform_index;//ac. dc noise etc 

				HBITMAP		HBActiveImage;

				HGDIOBJ		HOMSrc, HOMDest;
				int			m_snap_to_distance;
				int			is_symbol_editor;
				float		m_line_gradient;
				float		m_line_constant;

				int GetGridSize(void);
				int GetSnapToDistance(void);
				bool IsSnapToGridOn(void);

			CArray <TCLineData,  TCLineData &> CMDrawLineData;
			CArray <TCWaveFormDrawData,  TCWaveFormDrawData &> CMWaveFormDrawData;
			
			TCOutputWaveformDataHeader *PCParentHeader;

			void VectorDelete(void);
			virtual void VectorSerialize(CArchive& archive);

			int VectorIsThere(CPoint CLocation, bool fine);
			 
			 bool VectorPaste(CDC *PCDC, CPoint CLocation, bool is_visable);
			 bool VectorMoveTo(CDC *PCDC, CPoint CLocation, float zoom,  bool is_visable);
			 bool VectorClear(CDC *PCDC);
			 bool VectorGetBackground(CDC *PCDC);

			bool CreateTempBitmaps(void);
			void DeleteTempBitmaps(void);
			bool CreateBitmapBackgroundLabel(void);
			void CreateWirePins(CDC *PCDC);

			TCGraphicBitMapVectorObject();

			virtual bool Create(CPoint CStartLine, CPoint CEndLine,  unsigned short line_width,
				                COLORREF line_color, COLORREF selected_color,
								COLORREF highlighted_color, int snap_to_distance);
			TCGraphicBitMapVectorObject(TCGraphicBitMapVectorObject &CGraphiCBitmapVectorObject);


			virtual ~TCGraphicBitMapVectorObject();


			virtual bool Create(int id_bitmap, int id_bitmap_mask, int id_bitmap_selected, int id_bitmap_highlighted = 0);
			virtual bool Create(CDC *PCViewDC, CString CText, float zoom, COLORREF text_colour,
				                COLORREF selected_colour,
								COLORREF highlighted_colour);
			virtual bool Create(CArray <TCLineData, TCLineData &> &CSymbolData, unsigned short width, unsigned short height,
				                COLORREF normal_colour,
				                COLORREF selected_colour,
								COLORREF highlighted_colour);
			bool		Create(TCWaveformDataRuns *PCWaveformDataRunsParent, TCOutputWaveformDataHeader *PCHeader, int waveform_type);

			virtual int Create(TCGraphicBitMapVectorObject &CGraphiCBitmapObject);
			virtual bool AddLine(CPoint CLineStart, CPoint CLineEnd, unsigned short line_width);
			bool SetLine(int index, CPoint CLineStart, CPoint CLineEnd);
			void DeleteBitmapNew(void);
			virtual void Serialize(CArchive& archive);

			int GetMaxSignalCount(int run_index);

			virtual void CreateGrabRegion(CPoint CLocation);
			void CreateHorizontalWireGrabRegion(CPoint CLocation);
			void CreateVerticalalWireGrabRegion(CPoint CLocation);
			void CreateAngledWireGrabRegion(CPoint CLocation);
			void CreatePointingUpPinGrabRegion(CPoint CLocation);
			void CreatePointingDownPinGrabRegion(CPoint CLocation);
			void CreatePointingRightPinGrabRegion(CPoint CLocation);
			void CreatePointingLeftPinGrabRegion(CPoint CLocation);

			virtual	int IsThere(CPoint CLocation, bool fine);
			virtual int IsThere(CRect CRegion, bool all_enclosed);

			bool WaveformIsThere(CPoint CLocation);
			bool WaveformIsThere(CRect CRegion);
			COLORREF GetWaveformActiveColour(int run_index, int signal_index);

			virtual CRect GetGrabLocationRegion(void);
			int IsWireThere(CPoint CLocation, bool fine);
			int IsWireThere(CRect CRegion, bool all_enclosed);
			void OutlineWire(int outline_state);

			virtual bool Paste(CDC *PCDC, CPoint CLocation, float zoom,  bool is_visable);
			virtual bool MoveTo(CDC *PCDC, CPoint CLocation, float zoom,  bool is_visable);
			virtual bool Clear(CDC *PCDC);
			bool	GetBackground(CDC *PCDC);
			virtual bool RePaste(CDC *PCDC, CPoint CLocation);
			bool Print(CDC *PCDC, CPoint CLocation);
			bool BitmapPrint(CDC *PCDC, CPoint CLocation);
			bool VectorPrint(CDC *PCDC, CPoint CLocation);
			bool VectorRePaste(CDC *PCDC, CPoint CLocation, bool waveform_only = false);


			virtual TCWireInfo &GetWireInfo(void);

			
			virtual bool StartDrawingLine(CDC *PCDC, CPoint CMousePosition, COLORREF line_color,
				                          COLORREF line_selected_color, COLORREF line_highlighted_color,
										  unsigned short line_width, int snap_to_distance);
			virtual bool ContinueDrawingLine(CDC *PCDC, CPoint CMousePosition);
			virtual bool StopDrawingLine(CDC *PCDC, CPoint CMousePosition, int is_draw_orthoganal_on);

			virtual void SetSelect(void);
			virtual void ResetSelect(void);
			virtual void SetHighlight(bool highlighted = true);
			void		RealignLocation(CPoint CLocation);
			LOGFONT		*GetLogFont(void);

			void operator = (TCGraphicBitMapVectorObject &CGraphiCBitmapObject);



			DECLARE_SERIAL(TCGraphicBitMapVectorObject)

};


#endif