/*

	Copywrite ANASOFT LTD. (c) 1996
	
	File:	TCGraphicObject.cpp




 */



#include "stdafx.h"
#include <memory.h>
#include "float.h"
#include "math.h"
#include "TCGraphicsFunctions.h"
#include "TCGraphicObject.h"


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

IMPLEMENT_SERIAL(TCLineData, CObject, ID_VERSION_NUMBER )
IMPLEMENT_SERIAL(TCGraphicObject, CObject, ID_VERSION_NUMBER)  
IMPLEMENT_SERIAL(TCGraphicObjectData, CObject, ID_VERSION_NUMBER)  
IMPLEMENT_SERIAL(TCLableLocations, CObject, ID_VERSION_NUMBER)  
IMPLEMENT_SERIAL(TCGraphicPinObjectData, CObject, ID_VERSION_NUMBER)  

TCLineData::TCLineData(void)
{
	type			= E_SCHEMATIC_SYMBOL_LINE;
	aspect_ratio	= 1;
	start_angle		= 0;
	end_angle		= 0;
	radius			= 1;
	start_point		= 0;
	stop_point		= 0;
}

TCLineData::TCLineData(TCLineData &CLineData)
{
	*this = CLineData; 
}

void TCLineData::operator = (TCLineData &CLineData)
{
	CStartLocation	= CLineData.CStartLocation;
	CEndLocation	= CLineData.CEndLocation;
	radius			= CLineData.radius;
	type			= CLineData.type;
	aspect_ratio	= CLineData.aspect_ratio;
	start_angle		= CLineData.start_angle;
	end_angle		= CLineData.end_angle;
	start_point		= CLineData.start_point;
	stop_point		= CLineData.stop_point;

	int count = CLineData.CPoints.GetSize();
	
	CPoints.SetSize(count, count);
	
	for(int p = 0; p < count; p++) CPoints[p] = CLineData.CPoints[p];
}

void TCLineData::Zoom(float scale)
{
	CStartLocation.x	= (long)(CStartLocation.x * scale);
	CStartLocation.y	= (long)(CStartLocation.y * scale);
	
	if(type != E_SCHEMATIC_SYMBOL_CIRCLE)
	{
		CEndLocation.x		= (long)(CEndLocation.x * scale);
		CEndLocation.y		= (long)(CEndLocation.y * scale);
	}
	else radius	= (long)(radius * scale);

	FormatLinePoints();
}

void TCLineData::Rotate(CPoint &CRotatePointCenter, double sin_angle, double cos_angle)
{
	CStartLocation	= RotatePoint(CStartLocation, sin_angle,cos_angle, CRotatePointCenter);
	
	if(type != E_SCHEMATIC_SYMBOL_CIRCLE)
		CEndLocation = RotatePoint(CEndLocation, sin_angle, cos_angle, CRotatePointCenter);
}

void TCLineData::Rotate(CPoint &CRotatePointCenter, int angle)
{
	CRotatePointCenter;
	end_angle	+= angle;
	start_angle += angle;
}

void TCLineData::Mirror(int x0)
{
	CStartLocation	= MirrorPoint(CStartLocation, x0);

	if(type != E_SCHEMATIC_SYMBOL_CIRCLE)
		CEndLocation = MirrorPoint(CEndLocation, x0);

	if(type != E_SCHEMATIC_SYMBOL_CIRCLE) return;
	
	if(start_angle > 0)
	{
		start_angle = 180 - start_angle;
	}
	else 
	{
		start_angle = -(start_angle + 180);	
	}

	if(end_angle > 0)
	{
		end_angle = 180 - end_angle;
	}
	else
	{
		end_angle = -(end_angle + 180);
	}

	int temp = end_angle;

	// This code may not be general.
	// mirroring might fail for various non symetrical
	// circle shapes

	end_angle = start_angle;

	start_angle = temp;

	if(start_angle == end_angle) end_angle += 360;
}

void TCLineData::Flip(int y0)
{
	CStartLocation	= FlipPoint(CStartLocation, y0);
	CEndLocation	= FlipPoint(CEndLocation, y0);

	start_angle =  - start_angle;
	end_angle	=  - end_angle;
}

void TCLineData::Serialize(CArchive& CFileArchive)
{

	if(CFileArchive.IsStoring())
	{
		CFileArchive << type;
		CFileArchive << aspect_ratio;
		CFileArchive << CStartLocation;
		CFileArchive << CEndLocation;
		CFileArchive << radius;
		CFileArchive << start_angle;
		CFileArchive << end_angle;
	}
	else
	{
		CFileArchive >> type;
		CFileArchive >> aspect_ratio;
		CFileArchive >> CStartLocation;
		CFileArchive >> CEndLocation;
		CFileArchive >> radius;
		CFileArchive >> start_angle;
		CFileArchive >> end_angle;
		
		//Bug fix, CEndLocation was unused for circles
		if(type == E_SCHEMATIC_SYMBOL_CIRCLE) CEndLocation.y = abs(end_angle - start_angle);

		FormatLinePoints();
	}
}

bool TCLineData::IsNotInRegion(CPoint CLocation, long width, long height)
{
	CPoint CStart	= CStartLocation - CLocation;
	CPoint CEnd		= CEndLocation - CLocation;

	if(CEnd.x > width && CStart.x > width) return true;
	if(CEnd.x < 0 && CStart.x < 0) return true;
		
	if(CEnd.y > height && CStart.y > height) return true;
	if(CEnd.y < 0 && CStart.y < 0) return true;

	return false;
}

bool TCLineData::Clip(CPoint CLocation, long width, long height)
{
	CPoint CStart	= CStartLocation - CLocation;
	CPoint CEnd		= CEndLocation - CLocation;
	
	if(IsNotInRegion(CLocation, width, height)) return false;

	if(CEnd.x == CStart.x)
	{
		if(CStart.y < CEnd.y)
		{
			if(CStart.y < 0)	CStart.y = 0;
			if(CEnd.y > height) CEnd.y = height;
		}
		else
		{
			if(CEnd.y < 0) CEnd.y = 0;
			if(CStart.y > height) CStart.y = height;
		}
	}

	if(CEnd.y == CStart.y)
	{
		if(CStart.x < CEnd.x)
		{
			if(CStart.x < 0)	CStart.x = 0;
			if(CEnd.x > width) CEnd.x = width;
		}
		else
		{
			if(CEnd.x < 0) CEnd.x = 0;
			if(CStart.x > width) CStart.x = width;
		}
	}

	long dx, dy;

	dx = CEnd.x - CStart.x;
	dy = CEnd.y - CStart.y;

	if(dx < 0) 
	{
		CPoint CTemp = CEnd;

		CEnd = CStart;
		CStart = CTemp;

		dx = -dx;
	}

	if(!dx)
	{
		CStartLocation	= CStart + CLocation;
		CEndLocation	= CEnd + CLocation;

		return true;
	}

	if(!dy)
	{
		CStartLocation	= CStart + CLocation;
		CEndLocation	= CEnd + CLocation;

		return true;
	}

	long y, x;

	if(CEnd.x > width || (CEnd.y > height || CEnd.y < 0) && (CStart.x > 0 && CStart.x < width))// end out of region
	{
		//rhs out of region
		if(CEnd.x > width)
		{
			x = width;

			if(CEnd.y < CStart.y) y = CStart.y + ((width - CStart.x) * dy)/dx;//-
			else y = CStart.y + ((width - CStart.x) * dy)/dx;//

			if(y < 0 || y > height)// above might be the wrong choice
			{
				if(CEnd.y < CStart.y) 
				{
					x = CStart.x - (CStart.y * dx)/dy;//-

					y = 0;
				}
				else
				{
					x = CStart.x + ((height - CStart.y) * dx)/dy;

					y = height;
				}
			}

			CEnd.y = y;
			CEnd.x = x;
		}
		else
		{
			if(CEnd.y < CStart.y) 
			{
				x = CStart.x - (CStart.y * dx)/dy;//-

				y = 0;
			}
			else
			{
				x = CStart.x + ((height - CStart.y) * dx)/dy;

				y = height;
			}

			if(x < 0 || x > width)
			{
				x = width;

				if(CEnd.y < CStart.y) y = CStart.y + ((width - CStart.x) * dy)/dx;//-
				else y = CStart.y + ((width - CStart.x) * dy)/dx;//
			}

			CEnd.y = y;
			CEnd.x = x;
		}
	}
	else if(CStart.x < 0 || (CStart.y > height || CStart.y < 0) && (CEnd.x > 0 && CEnd.x < width))//start out of region
	{
		//lhs out of region
		if(CStart.x < 0)
		{
			x = 0;

			if(CStart.y < CEnd.y) y = CEnd.y - (CEnd.x*dy)/dx;//
			else y = CEnd.y - (CEnd.x*dy)/dx;//-

			if(y < 0 || y > height)
			{
				if(CEnd.y < CStart.y)
				{
					y = height;	

					x = CEnd.x + ((height - CEnd.y)*dx)/dy;//-
				}
				else
				{
					y = 0;

					x = CEnd.x - (CEnd.y*dx)/dy;
				}
			}

			CStart.y = y;
			CStart.x = x;
		}
		else
		{
			if(CEnd.y < CStart.y)
			{
				y = height;	

				x = CEnd.x + ((height - CEnd.y)*dx)/dy;//-
			}
			else
			{
				y = 0;

				x = CEnd.x - (CEnd.y*dx)/dy;
			}

			if(x < 0 || x > width)
			{
				x = 0;

				if(CStart.y < CEnd.y) y = CEnd.y - (CEnd.x*dy)/dx;//
				else y = CEnd.y - (CEnd.x*dy)/dx;//-
			}

			CStart.x = x;
			CStart.y = y;
		}
	}

	if(CStart.y < 0 || CStart.y > height || CStart.x < 0 || CStart.x > width ||
		CEnd.y < 0 || CEnd.y > height || CEnd.x < 0 || CEnd.x > width)
	{
		return false;
	}

	CStartLocation	= CStart + CLocation;
	CEndLocation	= CEnd + CLocation;

	return true;
}

int TCLineData::FormatLinePoints(void)
{
	if(type == E_SCHEMATIC_SYMBOL_CIRCLE)
	{
		return FormatCirclePoints();
	}

	register int t, distance;  //Bresenhams algorithm
	register int x_increment;
	register int y_increment;
	register int x = 0; 
	register int y = 0;
	register int delta_x;
	register int delta_y;

	CPoint CAddPoint = CStartLocation;
	TCDrawLineData CLineData;

	delta_x = CEndLocation.x - CStartLocation.x;
	delta_y = CEndLocation.y - CStartLocation.y;

	if(delta_x > 0) x_increment = 1;
	else if(delta_x == 0)  x_increment = 0;
		 else x_increment = -1;

	if(delta_y > 0) y_increment = 1;
	else if(delta_y == 0)  y_increment = 0;
		 else y_increment = -1;

	delta_x = abs(delta_x);
	delta_y = abs(delta_y);

	if(delta_x > delta_y) distance = delta_x;
	else distance = delta_y;

	int xlast = -1;
	int ylast = -1;
	int points_counter = 0;

	if(distance > 4095)
	{
		return -distance;// to stop lockups
	}

	int distance_count = distance + 2;// changed from 1 to 2, 6th Aug.2003 last point missed

	CPoints.SetSize(distance_count);// create space

	for(t = 0; t < distance_count; t++)
	{
		CLineData.CLocation.x = CAddPoint.x;
		CLineData.CLocation.y = CAddPoint.y;

		if(!(xlast == CAddPoint.x && ylast == CAddPoint.y))
		{
			CPoints[points_counter] = CLineData;

			points_counter++;
		}

		xlast = CAddPoint.x;
		ylast = CAddPoint.y;

		x += delta_x;
		y += delta_y;

		if(x > distance)
		{
			x -= distance;
			CAddPoint.x += x_increment;
		}

		if(y > distance)
		{
			y -= distance;
			CAddPoint.y += y_increment;
		}
	}

	CPoints.SetSize(points_counter);//delete unused space.

	return 0;
}

int TCLineData::FormatCirclePoints(void)
{
	// initially use math, use Bresenhams algorithm when debugged
	// ignor aspect ratio first, draw only circles

//	register int x, y, delta;

	int xlast = -1;
	int ylast = -1;
	int angle;

	int count = end_angle - start_angle;

	if(CEndLocation.y) count = CEndLocation.y;//added to fix bug, overides the above count, CEndLocation was unused for circles
	else CEndLocation.y = count;

	if(count < 0) count = -count;
	if(count > 360) count = 360;

	TCDrawLineData CLineData;

	int points_counter = 0;

	CPoints.SetSize(count);

	try
	{
		angle = start_angle;

		for(int p = 0; p < count; p++)
		{
			CLineData.CLocation.x = (int)(radius * cos(angle/57.29577951308));
			CLineData.CLocation.y = (int)(radius * sin(angle/57.29577951308));

			angle++;

			CLineData.CLocation += CStartLocation;

			if(!(xlast == CLineData.CLocation.x && ylast == CLineData.CLocation.y))
			{
				CPoints[points_counter] = CLineData;

				points_counter++;
			}

			xlast = CLineData.CLocation.x;
			ylast = CLineData.CLocation.y;
		}

		CPoints.SetSize(points_counter);
	}
	catch(...)
	{
		_fpreset();
	}
/*
	y		= radius;
	delta	= 3 - 2 * radius;

	for(x = 0; x < y; )
	{
		CLineData.CLocation.x = x;
		CLineData.CLocation.y = y;

		CLineData.CLocation += CStartLocation;

	//	if(!(xlast == CLineData.CLocation.x && ylast == CLineData.CLocation.y))
		{
			CPoints[points_counter] = CLineData;

			points_counter++;
		}
		xlast = CLineData.CLocation.x;
		ylast = CLineData.CLocation.y;

		if(delta < 0) delta += 4 * x  + 6; 
		else
		{
			delta += 4 * (x - y) + 10; 
			y--;
		}
		x++;
	}
	x = y;
	if(y)
	{
		CLineData.CLocation.x = x;
		CLineData.CLocation.y = y;

		CLineData.CLocation += CStartLocation;

		if(!(xlast == CLineData.CLocation.x && ylast == CLineData.CLocation.y))
		{
			CPoints[points_counter] = CLineData;

			points_counter++;
		}
	}
	*/

	return count;
}

void TCLineData::operator += (TCLineData &CLineData)
{
	CEndLocation = CLineData.CEndLocation; 

	int count1 = CPoints.GetSize();

	int count2 = CLineData.CPoints.GetSize();

	if(!count2) return;

	int p;
	int new_size;

	if(!count1)//copy over
	{
		start_point = CLineData.start_point;
		stop_point  = CLineData.stop_point;

		CPoints.SetSize(count2);

		if(CLineData.stop_point < count2) count2 = CLineData.stop_point;

		for(p = 0; p < count2; p++) CPoints[p] = CLineData.CPoints[p];

		return;
	}

	if(!stop_point && !CLineData.stop_point) //Accumalute all
	{
		new_size = count1 + count2;

		CPoints.SetSize(new_size);

		for(p = 0; p < count2; p++) CPoints[count1 + p] = CLineData.CPoints[p];

		return;
	}

	if(stop_point && !CLineData.stop_point) 
	{
		new_size = stop_point + count2;

		if(new_size < count1) CPoints.SetSize(new_size * 2);

		start_point = stop_point;
		stop_point = new_size;	

		for(p = 0; p < count2; p++) CPoints[stop_point + p] = CLineData.CPoints[p];

		return;
	}

	if(!stop_point && CLineData.stop_point) 
	{
		new_size = count1 + CLineData.stop_point;

		CPoints.SetSize(new_size * 2);

		for(p = 0; p < CLineData.stop_point; p++) CPoints[count1 + p] = CLineData.CPoints[p];

		start_point = stop_point;
		stop_point = new_size;
		
		return;
	}
	//Specific code for realtime display of waveform data, need to add to existing points, without to much new allocations
	new_size = stop_point + CLineData.stop_point;// try and make the new alloc not happen
	
	if(CLineData.stop_point > count2) CLineData.stop_point = count2;//protection
	
	if(!(new_size < count1)) CPoints.SetSize(2 * new_size);// try and avoid new alloc next time round

	for(p = 0; p < CLineData.stop_point; p++) CPoints[stop_point + p] = CLineData.CPoints[p];

	start_point = stop_point;	
	stop_point = new_size;	
}

int TCLineData::FindXYIndex(CPoint CLocation, int resolution)
{
	/// multyvalue suport
	int		count = CPoints.GetSize();
	long	y = CLocation.y;
	long	x = CLocation.x;
		
	if(!count) return -1;

	long min, max, xvalue;

	min = x;// - resolution;
	max = y;// + resolution;

	long y_max;
	long y_min;
	int index;

	index = FindYIndex(y, 0);

	if(index < 0) return -1;

	y_max = CPoints[index].CLocation.y;
	y_min = y_max;

	y_max += resolution;
	y_min -= resolution;

	for(int p = 0; p < count; p++)
	{
		xvalue = CPoints[p].CLocation.x;
		y	    = CPoints[p].CLocation.y;

		if(xvalue > max) continue;

		if(xvalue < min) continue;

		if(y > y_max) continue;// does y agree with mouse?
		if(y < y_min) continue;

		return p;
	}

	return -1;
}

int TCLineData::FindYXIndex(CPoint CLocation, int resolution)
{ /// searches for a y value near the x value
	int		count = CPoints.GetSize();
	long	y = CLocation.y;
	long	x = CLocation.x;
		
	if(!count) return -1;

	long min, max, yvalue;

	min = y;// - resolution;
	max = y;// + resolution;

	long x_max;
	long x_min;
	int index;

	index = FindXIndex(x, 0);

	if(index < 0) return -1;

	x_max = CPoints[index].CLocation.x;
	x_min = x_max;

	x_max += resolution;
	x_min -= resolution;

	for(int p = 0; p < count; p++)
	{
		yvalue = CPoints[p].CLocation.y;
		x	    = CPoints[p].CLocation.x;

		if(yvalue > max) continue;

		if(yvalue < min) continue;

		if(x > x_max) continue;// does x agree with mouse?
		if(x < x_min) continue;

		return p;
	}

	return -1;
}

int TCLineData::FindYIndex(long y, int resolution)
{
	int count = CPoints.GetSize();
		
	if(!count) return -1;

	long min, max;

	min = y - resolution;
	max = y + resolution;

	long xvalue;

	for(int p = 0; p < count; p++)
	{
		xvalue = CPoints[p].CLocation.y;

		if(xvalue > max) continue;

		if(xvalue < min) continue;

		return p;
	}

	return -1;
}

int TCLineData::FindXIndex(long x, int resolution)
{
	int count = CPoints.GetSize();
		
	if(!count) return -1;

	long min, max;

	min = x - resolution;
	max = x + resolution;

	long xvalue;

	for(int p = 0; p < count; p++)
	{
		xvalue = CPoints[p].CLocation.x;

		if(xvalue == x) return p;

		if(xvalue > max) continue;

		if(xvalue < min) continue;

		return p;
	}

	return -1;
}

bool TCLineData::GetValueY(int index, long &y, int resolution)
{
	int count = CPoints.GetSize();// find data point whithin a range but return the exact value at index
		
	if(!(index < count)) return false;

	long min, max;

	min = y - resolution;
	max = y + resolution;

	y = CPoints[index].CLocation.y;

	if(y > max) return false;

	if(y < min) return false;

	return true;
}

bool TCLineData::GetValueX(int index, long &x, int resolution)
{
	int count = CPoints.GetSize();// find data point whithin a range but return the exact value at index
		
	if(!(index < count)) return false;

	long min, max;

	min = x - resolution;
	max = x + resolution;

	x = CPoints[index].CLocation.x;

	if(x > max) return false;

	if(x < min) return false;

	return true;
}

void TCLineData::operator + (TCLineData &CLineData)
{
	CLineData;
}
//////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////

TCLableLocations::TCLableLocations()
{

}
TCLableLocations::TCLableLocations(TCLableLocations &CLableLocations)
{
	*this = CLableLocations;
}
TCLableLocations::~TCLableLocations()
{

}

void TCLableLocations::operator =  (TCLableLocations &CLableLocations)
{
	int count = CLableLocations.CQuadrant.GetSize();

	CQuadrant.SetSize(count, count);

	for(int p = 0; p < count; p++)
	{
		CQuadrant[p] = CLableLocations.CQuadrant[p];
	}
}

void TCLableLocations::Serialize(CArchive& CFileArchive)
{
	CObject::Serialize(CFileArchive);

	unsigned char count;

	if (CFileArchive.IsStoring())
	{
		count = (unsigned char) CQuadrant.GetSize();

		CFileArchive << count;

		for(unsigned char p = 0; p < count; p++) CFileArchive << CQuadrant[p];
	}
	else
	{
		CFileArchive >> count;

		CQuadrant.SetSize((int)count, (int)count);

		for(unsigned char p = 0; p < count; p++) CFileArchive >> CQuadrant[p];
	}
}

///////////////////////////////////////////////////////
void TCGraphicPinObjectData::operator =  (TCGraphicPinObjectData &CGraphicObjectData)
{
	Copy(CGraphicObjectData);
}

void TCGraphicPinObjectData::Copy(TCGraphicPinObjectData &CGraphicObjectData)
{
	type			= CGraphicObjectData.type;
	CLabel			= CGraphicObjectData.CLabel;
	CLocation		= CGraphicObjectData.CLocation;
	is_visable		= CGraphicObjectData.is_visable;
	CLocationOffset = CGraphicObjectData.CLocationOffset;
	width					= CGraphicObjectData.width;
	height					= CGraphicObjectData.height;
	connection_type			= CGraphicObjectData.connection_type;
	reserved1				= CGraphicObjectData.reserved1;
}

TCGraphicPinObjectData::TCGraphicPinObjectData(void)
{
	type				= 0;
	CLocation.x			= 0;
	CLocation.y			= 0;
	CLocationOffset.x	= 0;
	CLocationOffset.y	= 0;
	connection_type		= 0;
	reserved1			= 0;
	is_visable			= false;
}

void TCGraphicPinObjectData::Serialize(CArchive& CFileArchive)
{
	CObject::Serialize(CFileArchive);

	if (CFileArchive.IsStoring())
	{
		CFileArchive << type;
		CFileArchive << CLabel;

		CFileArchive << CLocation;
		CFileArchive << CLocationOffset;
		CFileArchive.Write(&is_visable, sizeof(is_visable));
		CFileArchive << width;
		CFileArchive << height;
		CFileArchive << connection_type;
		CFileArchive << reserved1;
	}
	else
	{
		CFileArchive >> type;
		CFileArchive >> CLabel;
		CFileArchive >> CLocation;
		CFileArchive >> CLocationOffset;
		CFileArchive.Read(&is_visable, sizeof(is_visable));
		CFileArchive >> width;
		CFileArchive >> height;
		CFileArchive >> connection_type;
		CFileArchive >> reserved1;
	}	
}

///////////////////////////////////////////////////////
void TCGraphicObjectData::operator =  (TCGraphicObjectData &CGraphicObjectData)
{
	Copy(CGraphicObjectData);
}

void TCGraphicObjectData::Copy(TCGraphicObjectData &CGraphicObjectData)
{
	type			= CGraphicObjectData.type;
	CLabel			= CGraphicObjectData.CLabel;
	CLabelType		= CGraphicObjectData.CLabelType;
	CLabelValue		= CGraphicObjectData.CLabelValue;
	CLocation		= CGraphicObjectData.CLocation;
	is_visable		= CGraphicObjectData.is_visable;
	CLocationOffset = CGraphicObjectData.CLocationOffset;
	width					= CGraphicObjectData.width;
	height					= CGraphicObjectData.height;
	f_vector_graphic		= CGraphicObjectData.f_vector_graphic;
	mirror_state			= CGraphicObjectData.mirror_state;
	rotation_state			= CGraphicObjectData.rotation_state;
	user_label_preferred	= CGraphicObjectData.user_label_preferred;
	read_only				= CGraphicObjectData.read_only;
	reserved				= CGraphicObjectData.reserved;

	int count = CGraphicObjectData.CLocations_Mirror.GetSize();

	CLocations_Mirror.SetSize(count, count);

	for(int p = 0; p < count; p++) CLocations_Mirror[p] = CGraphicObjectData.CLocations_Mirror[p];
}

TCGraphicObjectData::TCGraphicObjectData(void)
{
	type				= 0;
	CLocation.x			= 0;
	CLocation.y			= 0;
	CLocationOffset.x	= 0;
	CLocationOffset.y	= 0;
	mirror_state			= E_MIRRORED_NORMAL;
	rotation_state			= E_FIRST_QUADRANT;

	f_vector_graphic		= false;
	is_visable				= false;
	user_label_preferred	= false;
	read_only				= false;
	reserved				= 0;
}

void TCGraphicObjectData::Serialize(CArchive& CFileArchive)
{
	CObject::Serialize(CFileArchive);

	unsigned char count;

	if (CFileArchive.IsStoring())
	{
		CFileArchive << reserved;
		CFileArchive << type;
		CFileArchive << CLabel;
		CFileArchive << CLabelType;
		CFileArchive << CLabelValue;
		CFileArchive << CLocation;
		CFileArchive << CLocationOffset;
		CFileArchive.Write(&is_visable, sizeof(is_visable));
		CFileArchive.Write(&f_vector_graphic, sizeof(f_vector_graphic));
		CFileArchive << width;
		CFileArchive << height;
		CFileArchive << mirror_state;
		CFileArchive << rotation_state;
		CFileArchive.Write(&user_label_preferred, sizeof(user_label_preferred));
		CFileArchive.Write(&read_only, sizeof(read_only));


		count = (unsigned char)CLocations_Mirror.GetSize();

		CFileArchive << count;

		for(unsigned char p = 0; p < count; p++) CLocations_Mirror[p].Serialize(CFileArchive);
	}
	else
	{
		CFileArchive >> reserved;
		CFileArchive >> type;
		CFileArchive >> CLabel;
		CFileArchive >> CLabelType;
		CFileArchive >> CLabelValue;
		CFileArchive >> CLocation;
		CFileArchive >> CLocationOffset;
		CFileArchive.Read(&is_visable, sizeof(is_visable));
		CFileArchive.Read(&f_vector_graphic, sizeof(f_vector_graphic));
		CFileArchive >> width;
		CFileArchive >> height;
		CFileArchive >> mirror_state;
		CFileArchive >> rotation_state;
		CFileArchive.Read(&user_label_preferred, sizeof(user_label_preferred));
		CFileArchive.Read(&read_only, sizeof(read_only));

		CFileArchive >> count;

		CLocations_Mirror.SetSize((int)count, (int) count);

		for(unsigned char p = 0; p < count; p++) CLocations_Mirror[p].Serialize(CFileArchive);
	}	
}

////////////////////////////////////////////////////////////////////


TCGraphicObject::TCGraphicObject():CObject()
{
	CPoint CZero(0,0);
	CRect CRectZero(0, 0, 0, 0);

	m_selected		= false;
	CMMouseOffset	= CZero;
	CMCenterPoint	= CZero;
	m_visable		= true;
	m_overlaped		= false;
	m_highlighted	= false;
	m_box_select	= false;
	m_zoom			= 1;
	CMRectGrabLocationRegion = CRectZero;
	m_mode			= 0;
	m_type			= 1;
	m_line_width	= 1;
	m_line_color	= RGB(128, 128, 128);
	m_line_selected_color = RGB(255, 0, 0);
	m_line_highlighted_color = RGB(0, 255, 255);
	m_property = 0;
	CMLineStart = 0;
	CMLineEnd = 0;
	CMLocation = CZero;
	CMAbsoluteLocation = CZero;
	CMLocationOffset	= CZero;
	CMAbsoluteEndLocation = CZero;
	CMGrabOffset = CZero;
	m_mirror_state = 0;
	m_rotation_state = 1;
	m_user_label_preferred = false;
	m_is_local	=  0;
	m_page_id	= 0;
	m_version = -1;
	reserved = 0;
}	

TCGraphicObject::TCGraphicObject(TCGraphicObject &CGraphicObject)
{
	*this = CGraphicObject;
}
			
TCGraphicObject::~TCGraphicObject()
{


}

void TCGraphicObject::operator =  (TCGraphicObject &CGraphicObject)
{
	reserved = CGraphicObject.reserved;

	CMCenterPoint		= CGraphicObject.CMCenterPoint;
	CMRectGrabLocationRegion	= CGraphicObject.CMRectGrabLocationRegion;
	m_selected			= CGraphicObject.m_selected;
	m_overlaped			= CGraphicObject.m_overlaped;
	CMMouseOffset		= CGraphicObject.CMMouseOffset;
	CMLocation			= CGraphicObject.CMLocation;
	CMAbsoluteLocation  = CGraphicObject.CMAbsoluteLocation;
	CMAbsoluteEndLocation  = CGraphicObject.CMAbsoluteEndLocation;
	CMLocationOffset	= CGraphicObject.CMLocationOffset;
	CMGrabOffset		= CGraphicObject.CMGrabOffset;
	
	m_type				= CGraphicObject.m_type;
	m_zoom				= CGraphicObject.m_zoom;
	m_visable			= CGraphicObject.m_visable;
	m_highlighted		= CGraphicObject.m_highlighted;
	m_box_select 		= CGraphicObject.m_box_select;
	m_mode				= CGraphicObject.m_mode;
	m_line_width		= CGraphicObject.m_line_width;
	m_line_color		= CGraphicObject.m_line_color;
	m_line_selected_color = CGraphicObject.m_line_selected_color;
	m_line_highlighted_color = CGraphicObject.m_line_highlighted_color;
	m_property				= CGraphicObject.m_property;
	CMLineStart				= CGraphicObject.CMLineStart;
	CMLineEnd				= CGraphicObject.CMLineEnd;
	m_object_width			= CGraphicObject.m_object_width;
	m_object_height			= CGraphicObject.m_object_height;
	m_active_line_color		= CGraphicObject.m_active_line_color;
	CMLabel					= CGraphicObject.CMLabel;
	m_mirror_state			= CGraphicObject.m_mirror_state;
	m_rotation_state		= CGraphicObject.m_rotation_state;
	m_user_label_preferred	= CGraphicObject.m_user_label_preferred;
	m_page_id				= CGraphicObject.m_page_id;
	CMPageId				= CGraphicObject.CMPageId;
	m_version				= CGraphicObject.m_version;
}

bool TCGraphicObject::operator != (TCGraphicObject &CGraphicObject)
{
	if(CMCenterPoint == CGraphicObject.CMCenterPoint) return false;
	if(CMRectGrabLocationRegion == CGraphicObject.CMRectGrabLocationRegion) return false;
	if(m_selected == CGraphicObject.m_selected) return false;
	if(m_overlaped == CGraphicObject.m_overlaped) return false;
	if(CMMouseOffset == CGraphicObject.CMMouseOffset) return false;
	if(CMLocation == CGraphicObject.CMLocation) return false;
	if(m_type == CGraphicObject.m_type) return false;
	if(m_visable	== CGraphicObject.m_visable) return false;
	if(m_highlighted == CGraphicObject.m_highlighted)return false;
	if(m_box_select == CGraphicObject.m_box_select)return false;;
	if(m_mode == CGraphicObject.m_mode) return false;
	if(m_line_width	== CGraphicObject.m_line_width) return false;
	if(m_line_color	== CGraphicObject.m_line_color) return false;
	if(m_line_selected_color == CGraphicObject.m_line_selected_color) return false;;
	if(m_line_highlighted_color == CGraphicObject.m_line_highlighted_color) return false;;
	if(m_property == CGraphicObject.m_property) return false;
	if(CMLineStart == CGraphicObject.CMLineStart) return false;
	if(CMLineEnd == CGraphicObject.CMLineEnd) return false;
	if(m_object_width	== CGraphicObject.m_object_width) return false;;
	if(m_object_height	== CGraphicObject.m_object_height) return false;;
	if(m_version	== CGraphicObject.m_version) return false;;
	if(CMAbsoluteLocation == CGraphicObject.CMAbsoluteLocation) return false;
	if(CMAbsoluteEndLocation == CGraphicObject.CMAbsoluteEndLocation) return false;
	if(m_active_line_color	== CGraphicObject.m_active_line_color) return false;
	if(m_zoom	== CGraphicObject.m_zoom) return false;
	if(CMLabel	== CGraphicObject.CMLabel) return false;
	if(CMLocationOffset	== CGraphicObject.CMLocationOffset) return false;
	if(CMGrabOffset	== CGraphicObject.CMGrabOffset) return false;
	if(m_mirror_state	== CGraphicObject.m_mirror_state) return false;
	if(m_rotation_state	== CGraphicObject.m_rotation_state) return false;
	if(reserved == CGraphicObject.reserved) return false;

	return true;
}

/*
bool TCGraphicObject::operator == (TCGraphicObject &CGraphicObject)
{
	CGraphicObject;
	;//return !(*this == CGraphicObject);
}*/

void TCGraphicObject::Serialize(CArchive& CFileArchive)
{
	
	CObject::Serialize(CFileArchive);

	if (CFileArchive.IsStoring())
	{
		CFileArchive << reserved;
		CFileArchive << CMCenterPoint;
		CFileArchive << CMRectGrabLocationRegion;
		CFileArchive.Write(&m_selected, sizeof(m_selected));
		CFileArchive.Write(&m_overlaped, sizeof(m_overlaped));
		CFileArchive << CMMouseOffset;
		CFileArchive << CMLocation;
		CFileArchive << m_type;
		CFileArchive.Write(&m_visable, sizeof(m_visable));
		CFileArchive.Write(&m_highlighted, sizeof(m_highlighted));
		CFileArchive.Write(&m_box_select ,sizeof(m_box_select));
		CFileArchive.Write(&m_mode ,sizeof(m_mode));
		CFileArchive << m_line_width;
		CFileArchive << m_line_color;
		CFileArchive << m_line_selected_color;
		CFileArchive << m_line_highlighted_color;
		CFileArchive << m_property;
		CFileArchive << CMLineStart;
		CFileArchive << CMLineEnd;
		CFileArchive << m_object_height;
		CFileArchive << m_object_width;
		CFileArchive << CMAbsoluteLocation;
		CFileArchive << CMAbsoluteEndLocation;
		CFileArchive << m_active_line_color;
		CFileArchive << m_zoom;
		CFileArchive << CMLabel;
		CFileArchive << CMLocationOffset;
		CFileArchive << CMGrabOffset;
		CFileArchive << m_mirror_state;
		CFileArchive << m_rotation_state;
		CFileArchive.Write(&m_user_label_preferred, sizeof(m_user_label_preferred));
		CFileArchive << m_page_id;
		CFileArchive << CMPageId;
		CFileArchive << m_version;
	}
	else
	{
		CFileArchive >> reserved;
		CFileArchive >> CMCenterPoint;
		CFileArchive >> CMRectGrabLocationRegion;
		CFileArchive.Read(&m_selected, sizeof(m_selected));
		CFileArchive.Read(&m_overlaped, sizeof(m_overlaped));
		CFileArchive >> CMMouseOffset;
		CFileArchive >> CMLocation;
		CFileArchive >> m_type;
		CFileArchive.Read(&m_visable, sizeof(m_visable));
		CFileArchive.Read(&m_highlighted, sizeof(m_highlighted));
		CFileArchive.Read(&m_box_select ,sizeof(m_box_select));
		CFileArchive.Read(&m_mode ,sizeof(m_mode));
		CFileArchive >> m_line_width;
		CFileArchive >> m_line_color;
		CFileArchive >> m_line_selected_color;
		CFileArchive >> m_line_highlighted_color;
		CFileArchive >> m_property;
		CFileArchive >> CMLineStart;
		CFileArchive >> CMLineEnd;
		CFileArchive >> m_object_height;
		CFileArchive >> m_object_width;
		CFileArchive >> CMAbsoluteLocation;
		CFileArchive >> CMAbsoluteEndLocation;
		CFileArchive >> m_active_line_color;
		CFileArchive >> m_zoom;
		CFileArchive >> CMLabel;
		CFileArchive >> CMLocationOffset;
		CFileArchive >> CMGrabOffset;
		CFileArchive >> m_mirror_state;
		CFileArchive >> m_rotation_state;
		CFileArchive.Read(&m_user_label_preferred, sizeof(m_user_label_preferred));
		CFileArchive >> m_page_id;
		CFileArchive >> CMPageId;
		CFileArchive >> m_version;
	}	
}

CPoint	&TCGraphicObject::GetAbsoluteEndLocation(void)
{
	return CMAbsoluteEndLocation;
}
void TCGraphicObject::SetAbsoluteEndLocation(CPoint &CAbsLocation)
{
		CMAbsoluteEndLocation = CAbsLocation;
}
void TCGraphicObject::SetAbsoluteLocation(CPoint &CAbsLocation)
{
	CMAbsoluteLocation = CAbsLocation;
}
CPoint	&TCGraphicObject::GetAbsoluteLocation(void)
{
	return CMAbsoluteLocation;
}
bool TCGraphicObject::Create(TCGraphicObjectData &CGraphicObjectData)
{
	CGraphicObjectData;

	return true;
}


int TCGraphicObject::IsThere(CPoint CLocation, bool fine)
{
	CLocation;
	fine;

	return false;
}

int TCGraphicObject::IsThere(CRect CLocation)
{
	CLocation;

	return false;
}

bool TCGraphicObject::Paste(CDC *PCDC, CPoint CLocation, float zoom)
{
	CLocation;	
	PCDC;
	zoom;
	return true;
}

bool TCGraphicObject::MoveTo(CDC *PCDC, CPoint CLocation, float zoom)
{
	CLocation;
	PCDC;
	zoom;
	return true;
}

bool TCGraphicObject::Print(CDC *PCDC, CPoint CLocation)
{
	CLocation;
	PCDC;

	return true;
}

bool TCGraphicObject::Clear(CDC *PCDC)
{
	PCDC;

	return true;
}



void TCGraphicObject::SetSelect(void)
{
	m_selected = true;

}

void TCGraphicObject::ResetSelect(void)
{
	m_selected = false;
}

bool TCGraphicObject::GetSelect(void)
{
	return m_selected;
}

void TCGraphicObject::SetHighlight(bool highlight)
{
	m_highlighted = highlight;

}

bool TCGraphicObject::GetHighlight(void)
{
	return m_highlighted;
}

bool TCGraphicObject::GetLocation(CPoint *PCLocation)
{
	*PCLocation = CMLocation;

	return true;
}


bool TCGraphicObject::SetLocation(CPoint CLocation)
{
	CMLocation = CLocation;

	return true;
}

void TCGraphicObject::CreateGrabRegion(CPoint CLocation)
{
	CLocation;
}

void TCGraphicObject::SetMouseOffset(CPoint CMouseOffset)
{
	CMMouseOffset = CMouseOffset;
}	
CPoint TCGraphicObject::GetMouseOffset(void)
{

	return CMMouseOffset;
}

CPoint TCGraphicObject::GetCenter(void)
{
	return CMCenterPoint;
}
void TCGraphicObject::SetCenter(CPoint CCenterPoint)
{
	CMCenterPoint = CCenterPoint;
}

void TCGraphicObject::SetType(unsigned short type)
{
	m_type = type;
}
unsigned short	TCGraphicObject::GetType(void)
{
	return m_type;
}

bool TCGraphicObject::GetOverlaped(void)
{
	return m_overlaped;
}
void TCGraphicObject::SetOverlaped(void)
{
	m_overlaped = true;
}
void TCGraphicObject::ResetOverlaped(void)
{
	m_overlaped = 0;
}

CRect TCGraphicObject::GetGrabLocationRegion(void)
{
	return CMRectGrabLocationRegion;
}

void TCGraphicObject::SetVisable(bool visable)
{
	m_visable = visable;
}

bool TCGraphicObject::IsVisable(void)
{
	return m_visable;
}
unsigned short	TCGraphicObject::GetLineWidth()
{
	return m_line_width;
}
COLORREF TCGraphicObject::GetLineColor()
{
	return m_line_color;
}
void TCGraphicObject::SetLineWidth(unsigned short width)
{
	m_line_width = width;
}
void TCGraphicObject::SetLineColor(COLORREF color)
{
	m_line_color = color;
}
void TCGraphicObject::SetProperty(int m_property)
{
	m_property = m_property;
}
int	TCGraphicObject::GetProperty(void)
{
	return m_property;
}
CString	TCGraphicObject::GetLabel(void)
{
	return CMLabel;
}
void TCGraphicObject::SetLabel(CString CLabel)
{
	CMLabel = CLabel;
}

float TCGraphicObject::GetZoom(void)
{
	return m_zoom;
}

void TCGraphicObject::Mirror(void)
{

}

void TCGraphicObject::Rotate(void)
{

}
void TCGraphicObject::Flip(void)
{

}