#ifndef _TCGRAPHIC_OBJECT_H
#define _TCGRAPHIC_OBJECT_H


#include "TDVersion.h"
#include <afxtempl.h>

enum TE_GRAPHIC_ENUMS
{
	E_RIGHT			= 0,
	E_TOP			= 1,
	E_BOTTOM		= 2,
	E_LEFT			= 3,

	E_FIRST_QUADRANT	= 1,
	E_SECOND_QUADRANT	= 2,
	E_THIRD_QUADRANT	= 3,
	E_FORTH_QUADRANT	= 4,
	E_HORIZONTAL		= 5,
	E_VERTICAL			= 6,

	E_MIRRORED_NORMAL	= 0,
	E_MIRRORED_INVERTED	= 1,

	E_WIRE_ALLOC_SIZE	= 32,
	E_COMPONENTS_ALLOC_SIZE = 32,

	E_SELECTION_REGION_OUTLINE_STYE = 0,
	E_COMPONENT_OUTLINE_STYE = 1

};

enum TE_SCHEMATIC_SYMBOL
{
	E_SCHEMATIC_SYMBOL_LINE,
	E_SCHEMATIC_SYMBOL_CIRCLE,
	E_SCHEMATIC_SYMBOL_ELIPSE

};

enum E_GRAPHIC_OBJECT_MODE
{
	E_BITMAP_TEXT_OBJECT = 0,
	E_VECTOR_OBJECT = 1,
	E_BITMAP_OBJECT,
	E_LINE_DRAW_ALLOC_SIZE = 8
};

class TCDrawLineData
{
	public:
			COLORREF back_ground; 
			CPoint	 CLocation;			
};

class TCLineData : public CObject
{
	public:

			TCLineData(void);
			TCLineData(TCLineData &CLineData);
			~TCLineData(){};

			int		type;
			CPoint	CStartLocation;// in pixels or angles
			CPoint	CEndLocation;
			int		start_angle;
			int		end_angle;
			int		radius;
			float	aspect_ratio;
			int		start_point;
			int		stop_point;

			CArray<TCDrawLineData, TCDrawLineData&> CPoints;

			int FindYIndex(long y, int resolution);
			int FindXIndex(long x, int resolution);
			int FindYXIndex(CPoint CLocation, int resolution);
			int FindXYIndex(CPoint CLocation, int resolution);
			bool GetValueY(int index, long &y, int resolution);
			bool GetValueX(int index, long &y, int resolution);

			void operator = (TCLineData &CLineData);
			void operator += (TCLineData &CLineData);
			void operator + (TCLineData &CLineData);

			void Zoom(float scale);
			void Rotate(CPoint &CRotatePointCenter, double sin_angle, double cos_angle);
			void Rotate(CPoint &CRotatePointCenter, int angle);
			void Mirror(int x0);
			void Flip(int y0);
			void Serialize(CArchive& CFileArchive);
			int FormatLinePoints(void);
			int FormatCirclePoints(void);

			bool Clip(CPoint CLocation, long width, long height);
			bool IsNotInRegion(CPoint CLocation, long width, long height);

			DECLARE_SERIAL(TCLineData)
};
class TCLableLocations : public CObject
{
public:
		TCLableLocations();
		TCLableLocations(TCLableLocations &CLableLocations);
		~TCLableLocations();

		CArray <CPoint, CPoint &> CQuadrant;
		void operator =  (TCLableLocations &CLableLocations);

		virtual void Serialize(CArchive& CFileArchive);

		DECLARE_SERIAL(TCLableLocations)

};


class TCGraphicObjectData : public CObject
{
	public:
			TCGraphicObjectData(void);
			
			bool			is_visable;
			bool 			read_only;// for labels
			bool			user_label_preferred;
			bool			f_vector_graphic;
			unsigned char	mirror_state;
			unsigned char	rotation_state;
			unsigned short	width;
			unsigned short	height;
			unsigned short	type;	// Basic component type (includes wires and pins)
			unsigned short	reserved;	

			CPoint	CLocation;
			CPoint	CLocationOffset;
			CString	CLabel;	
			CString CLabelType;
			CString CLabelValue;

			CArray <TCLableLocations, TCLableLocations &> CLocations_Mirror;

			void operator =  (TCGraphicObjectData &CGraphicObjectData);

			void Copy(TCGraphicObjectData &CGraphicObjectData);
			
			virtual void Serialize(CArchive& CFileArchive);

			DECLARE_SERIAL(TCGraphicObjectData)
};

class TCGraphicPinObjectData : public CObject
{
	public:
			TCGraphicPinObjectData(void);
			
			bool			is_visable;
//			bool 			read_only;// for labels
//			bool			user_label_preferred;
//			bool			f_vector_graphic;
			unsigned char	connection_type;// this was changed from mirror_state which is not needed
			unsigned char	reserved1;
			unsigned short	width;
			unsigned short	height;
			unsigned short	type;	// Basic component type (includes wires and pins)

			CPoint	CLocation;
			CPoint	CLocationOffset;
			CString	CLabel;	
//			CString CLabelType;
//			CString CLabelValue;

			void operator =  (TCGraphicPinObjectData &CGraphicObjectData);

			void Copy(TCGraphicPinObjectData &CGraphicObjectData);
			
			virtual void Serialize(CArchive& CFileArchive);

			DECLARE_SERIAL(TCGraphicPinObjectData)
};
class TCGraphicObject : public CObject
{
	private:	
			
				friend class TCNetList;// to speed up netlisting

	public:	
				bool			m_selected;
				bool			m_highlighted;
				bool			m_overlaped;
				bool			m_visable;
				bool			m_box_select;
				unsigned char	m_mode;	
				unsigned char	m_mirror_state;
				unsigned char	m_rotation_state;
				unsigned char	m_property ;	// component, wire, pin etc
				unsigned short	m_line_width;
				unsigned short	m_object_width;
				unsigned short	m_object_height;
				unsigned short	m_type;			// base type stored in data as well
				short			m_version;
				float			m_zoom;
				unsigned short	reserved;


				COLORREF	m_line_color;
				COLORREF	m_line_highlighted_color;
				COLORREF	m_line_selected_color;
				COLORREF	m_active_line_color;
				CRect		CMRectGrabLocationRegion;
				CPoint		CMCenterPoint;
				CPoint		CMMouseOffset;
				CPoint		CMAbsoluteLocation;
				CPoint		CMAbsoluteEndLocation;
				CPoint		CMLocation;
				CPoint		CMLocationOffset;
				CPoint		CMLineStart;
				CPoint		CMLineEnd;
				CString		CMLabel;
				CPoint		CMGrabOffset;

				
				
				virtual void CreateGrabRegion(CPoint CLocation);
				

			TCGraphicObject();
			TCGraphicObject(TCGraphicObject &CGraphicObject);
			virtual ~TCGraphicObject();

			bool	m_user_label_preferred;
			bool	user_tag;
			bool	m_is_local;
			int		m_page_id;
			CString CMPageId;// reqired for netlisting global vs local
						

			friend class TCSchematicObject;
			friend class TCSchematicPinObject;
			virtual bool Create(TCGraphicObjectData &CGraphicObjectData);
 
			void operator =  (TCGraphicObject &CGraphicObject);
		//	bool operator == (TCGraphicObject &CGraphicObject);
			bool operator != (TCGraphicObject &CGraphicObject);

			virtual void Serialize(CArchive& CFileArchive);

			virtual	int IsThere(CPoint CLocation, bool fine);
			virtual	int IsThere(CRect CLocation);
			virtual bool Paste(CDC *PCDC, CPoint CLocation, float zoom);
			virtual bool MoveTo(CDC *PCDC, CPoint CLocation, float zoom);
			virtual bool Print(CDC *PCDC, CPoint CLocation);

			virtual bool Clear(CDC *PCDC);
			virtual void Mirror(void);
			virtual void Rotate(void);
			virtual void Flip(void);

			virtual void SetSelect(void);
			virtual void ResetSelect(void);
			virtual CRect GetGrabLocationRegion(void);

			virtual void SetHighlight(bool highlight = true);
			bool	GetHighlight(void);
			bool	GetSelect(void);
			bool	GetLocation(CPoint *PCLocation);
			CPoint	&GetAbsoluteLocation(void);
			CPoint	&GetAbsoluteEndLocation(void);
			virtual	void SetAbsoluteLocation(CPoint &CAbsLocation);
			virtual	void SetAbsoluteEndLocation(CPoint &CAbsLocation);
			
			virtual void	SetMouseOffset(CPoint CMouseOffset);
			CPoint	GetMouseOffset(void);
			CPoint  GetCenter(void);
			void	SetCenter(CPoint CCenterPoint);
			void	SetType(unsigned short type);
			unsigned short		GetType(void);
			void	SetProperty(int property);
			int		GetProperty(void);
			bool	GetOverlaped(void);
			void	SetOverlaped(void);
			void	ResetOverlaped(void);

			bool	SetLocation(CPoint CLocation);
			void	SetVisable(bool visable);
			bool	IsVisable(void);

			unsigned short	GetLineWidth();
			COLORREF	GetLineColor();
			void		SetLineWidth(unsigned short width);
			void		SetLineColor(COLORREF color);
			CString		GetLabel(void);
			void		SetLabel(CString CLabel);
			float		GetZoom(void);

			DECLARE_SERIAL(TCGraphicObject)

};


#endif