// TCGraphicsFunctions.cpp: implementation of the TCGraphicsFunctions class.
//
//////////////////////////////////////////////////////////////////////


#include "TCGraphicsFunctions.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////
// assumes npi/2
CRect RotateRect(CRect CRotateRect, int quadrant, CPoint &CRotatePointCenter)
{
	CPoint CTopLeft, CBottomRight;

	CTopLeft.x = CRotateRect.left;
	CTopLeft.y = CRotateRect.top;
	CBottomRight.x = CRotateRect.right;
	CBottomRight.y = CRotateRect.bottom;

	switch(quadrant)
	{
		case 1: return CRotateRect; break;
		case 2: CTopLeft = RotatePoint(CTopLeft, 1, 0, CRotatePointCenter);
				CBottomRight = RotatePoint(CBottomRight, 1, 0, CRotatePointCenter);
				CRotateRect.SetRect(CTopLeft.x, CTopLeft.y, CBottomRight.x, CBottomRight.y);
			//	CRotated.top = CRotateRect.right;
			//	CRotated.left = CRotateRect.top;
			 //   CRotated.bottom = CRotateRect.left;
			 //   CRotated.right = CRotateRect.bottom;
				break;
		case 3: CTopLeft = RotatePoint(CTopLeft, 0, -1, CRotatePointCenter);
				CBottomRight = RotatePoint(CBottomRight, 0, -1, CRotatePointCenter);
				CRotateRect.SetRect(CTopLeft.x, CTopLeft.y, CBottomRight.x, CBottomRight.y);
			//	CRotated.top = CRotateRect.bottom;
			//	CRotated.left = CRotateRect.right;
			 //   CRotated.bottom = CRotateRect.top;
			//    CRotated.right = CRotateRect.left;
				break;
		case 4: CTopLeft = RotatePoint(CTopLeft, -1, 0, CRotatePointCenter);
				CBottomRight = RotatePoint(CBottomRight, -1, 0, CRotatePointCenter);
				CRotateRect.SetRect(CTopLeft.x, CTopLeft.y, CBottomRight.x, CBottomRight.y);
			//	CRotated.top = CRotateRect.left;
			//	CRotated.left = CRotateRect.bottom;
			//    CRotated.bottom = CRotateRect.right;
			//    CRotated.right = CRotateRect.top;
				break;
	}

	return CRotateRect;
}
CRect MirrorPoint(CRect CMirrorRect, int x0)
{
	CRect CRotated(0,0,0,0);
	x0;CMirrorRect;
	return CRotated;
}
CPoint RotatePoint(CPoint &CRotatePoint, double sin_angle, double cos_angle, CPoint &CRotatePointCenter)
{
	CPoint CRotated;
	double x = cos_angle * (CRotatePoint.x - CRotatePointCenter.x) - sin_angle * (CRotatePoint.y - CRotatePointCenter.y);
	double y = sin_angle * (CRotatePoint.x - CRotatePointCenter.x) + cos_angle * (CRotatePoint.y - CRotatePointCenter.y);

	int ix, iy;

	if(x < 0) ix = (int)(x - 0.50001);
	else ix = (int)(x + 0.5);
	if(y < 0) iy = (int)(y - 0.50001);
	else iy = (int)(y + 0.5);

	CRotated.x = ix;
	CRotated.y = iy; 

	return CRotated;
}
CPoint RotatePoint(CPoint &CRotatePoint,  int sin_angle, int cos_angle, CPoint &CRotatePointCenter)
{
	CPoint CRotated;

	int x = cos_angle * (CRotatePoint.x - CRotatePointCenter.x) - sin_angle * (CRotatePoint.y - CRotatePointCenter.y);
	int y = sin_angle * (CRotatePoint.x - CRotatePointCenter.x) + cos_angle * (CRotatePoint.y - CRotatePointCenter.y);

	CRotated.x = x;
	CRotated.y = y; 

	return CRotated;
}
CPoint RotatePoint(CPoint CRotatePoint,  int quadrant, CPoint &CRotatePointCenter)
{
	CPoint CRotated;
	int sin_angle = 0;
	int cos_angle = 0;

	switch(quadrant)
	{
		case 1: return CRotatePoint; break;
		case 2: sin_angle = 1;  cos_angle = 0; break;
		case 3: sin_angle = 0;  cos_angle = -1; break;
		case 4: sin_angle = -1;  cos_angle = 0; break;
	}

	int x = cos_angle * (CRotatePoint.x - CRotatePointCenter.x) - sin_angle * (CRotatePoint.y - CRotatePointCenter.y);
	int y = sin_angle * (CRotatePoint.x - CRotatePointCenter.x) + cos_angle * (CRotatePoint.y - CRotatePointCenter.y);

	CRotated.x = x;
	CRotated.y = y; 

	return CRotated;
}
CPoint MirrorPoint(CPoint &CRotatePoint, int x0)
{
	CPoint CMirrored; // Reflect in x axis

	CMirrored.x = x0 - CRotatePoint.x;
	CMirrored.y =  CRotatePoint.y;

	return CMirrored;
}
CPoint FlipPoint(CPoint &CFlipPoint, int y0)
{
	CPoint CFliped;  // Reflect in y axis

	CFliped.y = y0 -CFlipPoint.y;
	CFliped.x = CFlipPoint.x;

	return CFliped;
}

bool RectInRect(CRect CEnclosing, CRect CEnclosed)
{
	CPoint CTextPoint;

	CTextPoint.y = CEnclosed.top;
	CTextPoint.x = CEnclosed.left;

	if(!CEnclosing.PtInRect(CTextPoint)) return false;

	CTextPoint.y = CEnclosed.top;
	CTextPoint.x = CEnclosed.right;

	if(!CEnclosing.PtInRect(CTextPoint)) return false;

	CTextPoint.y = CEnclosed.bottom;
	CTextPoint.x = CEnclosed.left;

	if(!CEnclosing.PtInRect(CTextPoint)) return false;

	CTextPoint.y = CEnclosed.bottom;
	CTextPoint.x = CEnclosed.right;

	if(!CEnclosing.PtInRect(CTextPoint)) return false;

	return true;
}

TCGraphicsFunctions::TCGraphicsFunctions()
{

}

TCGraphicsFunctions::~TCGraphicsFunctions()
{

}
